"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2025 Phonexia s.r.o.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Phonexia Voice Activity Detection gRPC API.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import phonexia.grpc.common.core_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class DetectRequest(google.protobuf.message.Message):
    """The top-level message sent by the client for the <code>Detect</code>
    method.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AUDIO_FIELD_NUMBER: builtins.int
    @property
    def audio(self) -> phonexia.grpc.common.core_pb2.Audio:
        """Audio to be processed.
        The audio should have minimum length of 0.8 seconds. If the audio is shorter,
        the <code>segments</code> will be empty.
        """

    def __init__(
        self,
        *,
        audio: phonexia.grpc.common.core_pb2.Audio | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audio", b"audio"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audio", b"audio"]) -> None: ...

global___DetectRequest = DetectRequest

@typing.final
class DetectResponse(google.protobuf.message.Message):
    """The top-level message returned to the client by the <code>Detect</code>
    method.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEECH_LENGTH_FIELD_NUMBER: builtins.int
    SEGMENTS_FIELD_NUMBER: builtins.int
    PROCESSED_AUDIO_LENGTH_FIELD_NUMBER: builtins.int
    @property
    def speech_length(self) -> google.protobuf.duration_pb2.Duration:
        """Total speech length detected in the audio."""

    @property
    def segments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Segment]:
        """List of detected voice segments. Will be empty if the audio is shorter than 0.8 seconds."""

    @property
    def processed_audio_length(self) -> google.protobuf.duration_pb2.Duration:
        """Total length of the processed audio."""

    def __init__(
        self,
        *,
        speech_length: google.protobuf.duration_pb2.Duration | None = ...,
        segments: collections.abc.Iterable[global___Segment] | None = ...,
        processed_audio_length: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "speech_length", b"speech_length"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["processed_audio_length", b"processed_audio_length", "segments", b"segments", "speech_length", b"speech_length"]) -> None: ...

global___DetectResponse = DetectResponse

@typing.final
class Segment(google.protobuf.message.Message):
    """Detected voice segment."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SegmentType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SegmentTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Segment._SegmentType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VOICE: Segment._SegmentType.ValueType  # 0

    class SegmentType(_SegmentType, metaclass=_SegmentTypeEnumTypeWrapper):
        """Enumeration of supported segment types."""

    VOICE: Segment.SegmentType.ValueType  # 0

    TYPE_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    type: global___Segment.SegmentType.ValueType
    """Type of the segment."""
    @property
    def start_time(self) -> google.protobuf.duration_pb2.Duration:
        """Timestamp specifying the beginning of the segment."""

    @property
    def end_time(self) -> google.protobuf.duration_pb2.Duration:
        """Timestamp specifying the end of the segment."""

    def __init__(
        self,
        *,
        type: global___Segment.SegmentType.ValueType = ...,
        start_time: google.protobuf.duration_pb2.Duration | None = ...,
        end_time: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["end_time", b"end_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["end_time", b"end_time", "start_time", b"start_time", "type", b"type"]) -> None: ...

global___Segment = Segment
