replacePollutantName = {
    "co": "CO",
    "no": "NO",
    "no2": "NO\u2082",
    "nox": "NO\u2093",
    "nv10": "NV\u2081\u2080",
    "nv25": "NV\u2082\u2085",
    "o3": "O\u2083",
    "pm10": "PM\u2081\u2080",
    "pm2.5": "PM\u2082\u2085",
    "so2": "SO\u2082",
    "v10": "V\u2081\u2080",
    "v25": "V\u2082\u2085",
    "ch4": "CH\u2084",
}

neatFeatureVectorColumnName = {
    "Bicycle Score": "Transport Use Bicycle Score",
    "Car and Taxi Score": "Transport Use Car and Taxi Score",
    "Bus and Coach Score": "Transport Use Bus and Coach Score",
    "LGV Score": "Transport Use LGV Score",
    "HGV Score": "Transport Use HGV Score",
    "Week Number": "Temporal Week",
    "Month Number": "Temporal Month",
    "Day of Week Number": "Temporal Day of Week",
    "Hour Number": "Temporal Hour",
    "100m_u_component_of_wind": "Meteorological  100m U Component of Wind",
    "100m_v_component_of_wind": "Meteorological 100m V Component of Wind",
    "10m_u_component_of_wind": "Meteorological 10m U Component of Wind",
    "10m_v_component_of_wind": "Meteorological 10m V Component of Wind",
    "2m_dewpoint_temperature": "Meteorological 2m Dewpoint Temperature",
    "2m_temperature": "Meteorological 2m Temperature",
    "boundary_layer_height": "Meteorological Boundary Layer Height",
    "downward_uv_radiation_at_the_surface": "Meteorological Downward UV Radiation At Surface",
    "instantaneous_10m_wind_gust": "Meteorological Instantaneous 10m Wind Gust",
    "surface_pressure": "Meteorological Surface Pressure",
    "total_column_rain_water": "Meteorological Total Column Rain Water",
    "S5P_NO2": "Remote Sensing Sentinel 5P NO\u2082",
    "S5P_AAI": "Remote Sensing Sentinel 5P Absorbing Aerosol Index",
    "S5P_CO": "Remote Sensing Sentinel 5P CO",
    "S5P_HCHO": "Remote Sensing Sentinel 5P HCHO",
    "S5P_O3": "Remote Sensing Sentinel 5P O\u2083",
    "Road Infrastructure Distance residential": "Transport Infrastructure Distance Residential",
    "Road Infrastructure Distance footway": "Transport Infrastructure Distance Footway",
    "Road Infrastructure Distance service": "Transport Infrastructure Distance Service",
    "Road Infrastructure Distance primary": "Transport Infrastructure Distance Primary",
    "Road Infrastructure Distance path": "Transport Infrastructure Distance Path",
    "Road Infrastructure Distance cycleway": "Transport Infrastructure Distance Cycleway",
    "Road Infrastructure Distance tertiary": "Transport Infrastructure Distance Tertiary",
    "Road Infrastructure Distance secondary": "Transport Infrastructure Distance Secondary",
    "Road Infrastructure Distance unclassified": "Transport Infrastructure Distance Unclassified",
    "Road Infrastructure Distance trunk": "Transport Infrastructure Distance Trunk",
    "Road Infrastructure Distance track": "Transport Infrastructure Distance Track",
    "Road Infrastructure Distance motorway": "Transport Infrastructure Distance Motorway",
    "Road Infrastructure Distance pedestrian": "Transport Infrastructure Distance Pedestrian",
    "Road Infrastructure Distance living_street": "Transport Infrastructure Distance Living Street",
    "Total Length cycleway": "Transport Infrastructure Length Cycleway",
    "Total Length footway": "Transport Infrastructure Length Footway",
    "Total Length living_street": "Transport Infrastructure Length Living Street",
    "Total Length motorway": "Transport Infrastructure Length Motorway",
    "Total Length path": "Transport Infrastructure Length Path",
    "Total Length pedestrian": "Transport Infrastructure Length Pedestrian",
    "Total Length primary": "Transport Infrastructure Length Primary",
    "Total Length residential": "Transport Infrastructure Length Residential",
    "Total Length secondary": "Transport Infrastructure Length Secondary",
    "Total Length service": "Transport Infrastructure Length Service",
    "Total Length tertiary": "Transport Infrastructure Length Tertiary",
    "Total Length track": "Transport Infrastructure Length Track",
    "Total Length trunk": "Transport Infrastructure Length Trunk",
    "Total Length unclassified": "Transport Infrastructure Length Unclassified",
    "No Land": "Geographical No Land",
    "Broadleaved woodland": "Geographical Broadleaved Woodland",
    "Coniferous Woodland": "Geographical Coniferous Woodland",
    "Arable and Horticulture": "Geographical Arable and Horticulture",
    "Improved Grassland": "Geographical Improved Grassland",
    "Neutral Grassland": "Geographical Neutral Grassland",
    "Calcareous Grassland": "Geographical Calcareous Grassland",
    "Acid grassland": "Geographical Acid Grassland",
    "Fen Marsh and Swamp": "Geographical Fen Marsh and Swamp",
    "Heather": "Geographical Heather",
    "Heather grassland": "Geographical Heather Grassland",
    "Bog": "Geographical Bog",
    "Inland Rock": "Geographical Inland Rock",
    "Saltwater": "Geographical Saltwater",
    "Freshwater": "Geographical Freshwater",
    "Supra-littoral Rock": "Geographical Supra-littoral Rock",
    "Supra-littoral Sediment": "Geographical Supra-littoral Sediment",
    "Littoral Rock": "Geographical Littoral Rock",
    "Littoral sediment": "Geographical Littoral Sediment",
    "Saltmarsh": "Geographical Saltmarash",
    "Urban": "Geographical Urban",
    "Suburban": "Geographical Suburban",
    "NAEI SNAP 1 NOx": "Emissions SNAP 1 NOx",
    "NAEI SNAP 2 NOx": "Emissions SNAP 2 NOx",
    "NAEI SNAP 3 NOx": "Emissions SNAP 3 NOx",
    "NAEI SNAP 4 NOx": "Emissions SNAP 4 NOx",
    "NAEI SNAP 5 NOx": "Emissions SNAP 5 NOx",
    "NAEI SNAP 6 NOx": "Emissions SNAP 6 NOx",
    "NAEI SNAP 7 NOx": "Emissions SNAP 7 NOx",
    "NAEI SNAP 8 NOx": "Emissions SNAP 8 NOx",
    "NAEI SNAP 9 NOx": "Emissions SNAP 9 NOx",
    "NAEI SNAP 10 NOx": "Emissions SNAP 10 NOx",
    "NAEI SNAP 11 NOx": "Emissions SNAP 11 NOx",
    "NAEI SNAP 1 CO": "Emissions SNAP 1 CO",
    "NAEI SNAP 2 CO": "Emissions SNAP 2 CO",
    "NAEI SNAP 3 CO": "Emissions SNAP 3 CO",
    "NAEI SNAP 4 CO": "Emissions SNAP 4 CO",
    "NAEI SNAP 5 CO": "Emissions SNAP 5 CO",
    "NAEI SNAP 6 CO": "Emissions SNAP 6 CO",
    "NAEI SNAP 7 CO": "Emissions SNAP 7 CO",
    "NAEI SNAP 8 CO": "Emissions SNAP 8 CO",
    "NAEI SNAP 9 CO": "Emissions SNAP 9 CO",
    "NAEI SNAP 10 CO": "Emissions SNAP 10 CO",
    "NAEI SNAP 11 CO": "Emissions SNAP 11 CO",
    "NAEI SNAP 1 SOx": "Emissions SNAP 1 SOx",
    "NAEI SNAP 2 SOx": "Emissions SNAP 2 SOx",
    "NAEI SNAP 3 SOx": "Emissions SNAP 3 SOx",
    "NAEI SNAP 4 SOx": "Emissions SNAP 4 SOx",
    "NAEI SNAP 5 SOx": "Emissions SNAP 5 SOx",
    "NAEI SNAP 6 SOx": "Emissions SNAP 6 SOx",
    "NAEI SNAP 7 SOx": "Emissions SNAP 7 SOx",
    "NAEI SNAP 8 SOx": "Emissions SNAP 8 SOx",
    "NAEI SNAP 9 SOx": "Emissions SNAP 9 SOx",
    "NAEI SNAP 10 SOx": "Emissions SNAP 10 SOx",
    "NAEI SNAP 11 SOx": "Emissions SNAP 11 SOx",
    "NAEI SNAP 1 NH3": "Emissions SNAP 1 NH3",
    "NAEI SNAP 2 NH3": "Emissions SNAP 2 NH3",
    "NAEI SNAP 3 NH3": "Emissions SNAP 3 NH3",
    "NAEI SNAP 4 NH3": "Emissions SNAP 4 NH3",
    "NAEI SNAP 5 NH3": "Emissions SNAP 5 NH3",
    "NAEI SNAP 6 NH3": "Emissions SNAP 6 NH3",
    "NAEI SNAP 7 NH3": "Emissions SNAP 7 NH3",
    "NAEI SNAP 8 NH3": "Emissions SNAP 8 NH3",
    "NAEI SNAP 9 NH3": "Emissions SNAP 9 NH3",
    "NAEI SNAP 10 NH3": "Emissions SNAP 10 NH3",
    "NAEI SNAP 11 NH3": "Emissions SNAP 11 NH3",
    "NAEI SNAP 1 NMVOC": "Emissions SNAP 1 NMVOC",
    "NAEI SNAP 2 NMVOC": "Emissions SNAP 2 NMVOC",
    "NAEI SNAP 3 NMVOC": "Emissions SNAP 3 NMVOC",
    "NAEI SNAP 4 NMVOC": "Emissions SNAP 4 NMVOC",
    "NAEI SNAP 5 NMVOC": "Emissions SNAP 5 NMVOC",
    "NAEI SNAP 6 NMVOC": "Emissions SNAP 6 NMVOC",
    "NAEI SNAP 7 NMVOC": "Emissions SNAP 7 NMVOC",
    "NAEI SNAP 8 NMVOC": "Emissions SNAP 8 NMVOC",
    "NAEI SNAP 9 NMVOC": "Emissions SNAP 9 NMVOC",
    "NAEI SNAP 10 NMVOC": "Emissions SNAP 10 NMVOC",
    "NAEI SNAP 11 NMVOC": "Emissions SNAP 11 NMVOC",
    "NAEI SNAP 1 PM10": "Emissions SNAP 1 PM10",
    "NAEI SNAP 2 PM10": "Emissions SNAP 2 PM10",
    "NAEI SNAP 3 PM10": "Emissions SNAP 3 PM10",
    "NAEI SNAP 4 PM10": "Emissions SNAP 4 PM10",
    "NAEI SNAP 5 PM10": "Emissions SNAP 5 PM10",
    "NAEI SNAP 6 PM10": "Emissions SNAP 6 PM10",
    "NAEI SNAP 7 PM10": "Emissions SNAP 7 PM10",
    "NAEI SNAP 8 PM10": "Emissions SNAP 8 PM10",
    "NAEI SNAP 9 PM10": "Emissions SNAP 9 PM10",
    "NAEI SNAP 10 PM10": "Emissions SNAP 10 PM10",
    "NAEI SNAP 11 PM10": "Emissions SNAP 11 PM10",
    "NAEI SNAP 1 PM25": "Emissions SNAP 1 PM25",
    "NAEI SNAP 2 PM25": "Emissions SNAP 2 PM25",
    "NAEI SNAP 3 PM25": "Emissions SNAP 3 PM25",
    "NAEI SNAP 4 PM25": "Emissions SNAP 4 PM25",
    "NAEI SNAP 5 PM25": "Emissions SNAP 5 PM25",
    "NAEI SNAP 6 PM25": "Emissions SNAP 6 PM25",
    "NAEI SNAP 7 PM25": "Emissions SNAP 7 PM25",
    "NAEI SNAP 8 PM25": "Emissions SNAP 8 PM25",
    "NAEI SNAP 9 PM25": "Emissions SNAP 9 PM25",
    "NAEI SNAP 10 PM25": "Emissions SNAP 10 PM25",
    "NAEI SNAP 11 PM25": "Emissions SNAP 11 PM25",
}

neatFeatureVectorColumnNameShort = {
    "Bicycle Score": "TU Bicycle Score",
    "Car and Taxi Score": "TU Car and Taxi Score",
    "Bus and Coach Score": "TU Bus and Coach Score",
    "LGV Score": "TU LGV Score",
    "HGV Score": "TU HGV Score",
    "Week Number": "T Week",
    "Month Number": "T Month",
    "Day of Week Number": "T Day of Week",
    "Hour Number": "T Hour",
    "100m_u_component_of_wind": "M 100m U Component of Wind",
    "100m_v_component_of_wind": "M 100m V Component of Wind",
    "10m_u_component_of_wind": "M 10m U Component of Wind",
    "10m_v_component_of_wind": "M 10m V Component of Wind",
    "2m_dewpoint_temperature": "M 2m Dewpoint Temperature",
    "2m_temperature": "M 2m Temperature",
    "boundary_layer_height": "M Boundary Layer Height",
    "downward_uv_radiation_at_the_surface": "M Downward UV Radiation At Surface",
    "instantaneous_10m_wind_gust": "M Instantaneous 10m Wind Gust",
    "surface_pressure": "M Surface Pressure",
    "total_column_rain_water": "M Total Column Rain Water",
    "S5P_NO2": "RS Sentinel 5P NO\u2082",
    "S5P_AAI": "RS Sentinel 5P Absorbing Aerosol Index",
    "S5P_CO": "RS Sentinel 5P CO",
    "S5P_HCHO": "RS Sentinel 5P HCHO",
    "S5P_O3": "RS Sentinel 5P O\u2083",
    "Road Infrastructure Distance residential": "TI Distance Residential",
    "Road Infrastructure Distance footway": "TI Distance Footway",
    "Road Infrastructure Distance service": "TI Distance Service",
    "Road Infrastructure Distance primary": "TI Distance Primary",
    "Road Infrastructure Distance path": "TI Distance Path",
    "Road Infrastructure Distance cycleway": "TI Distance Cycleway",
    "Road Infrastructure Distance tertiary": "TI Distance Tertiary",
    "Road Infrastructure Distance secondary": "TI Distance Secondary",
    "Road Infrastructure Distance unclassified": "TI Distance Unclassified",
    "Road Infrastructure Distance trunk": "TI Distance Trunk",
    "Road Infrastructure Distance track": "TI Distance Track",
    "Road Infrastructure Distance motorway": "TI Distance Motorway",
    "Road Infrastructure Distance pedestrian": "TI Distance Pedestrian",
    "Road Infrastructure Distance living_street": "TI Distance Living Street",
    "Total Length cycleway": "TI Length Cycleway",
    "Total Length footway": "TI Length Footway",
    "Total Length living_street": "TI Length Living Street",
    "Total Length motorway": "TI Length Motorway",
    "Total Length path": "TI Length Path",
    "Total Length pedestrian": "TI Length Pedestrian",
    "Total Length primary": "TI Length Primary",
    "Total Length residential": "TI Length Residential",
    "Total Length secondary": "TI Length Secondary",
    "Total Length service": "TI Length Service",
    "Total Length tertiary": "TI Length Tertiary",
    "Total Length track": "TI Length Track",
    "Total Length trunk": "TI Length Trunk",
    "Total Length unclassified": "TI Length Unclassified",
    "No Land": "G No Land",
    "Broadleaved woodland": "G Broadleaved Woodland",
    "Coniferous Woodland": "G Coniferous Woodland",
    "Arable and Horticulture": "G Arable and Horticulture",
    "Improved Grassland": "G Improved Grassland",
    "Neutral Grassland": "G Neutral Grassland",
    "Calcareous Grassland": "G Calcareous Grassland",
    "Acid grassland": "G Acid Grassland",
    "Fen Marsh and Swamp": "G Fen Marsh and Swamp",
    "Heather": "G Heather",
    "Heather grassland": "G Heather Grassland",
    "Bog": "G Bog",
    "Inland Rock": "G Inland Rock",
    "Saltwater": "G Saltwater",
    "Freshwater": "G Freshwater",
    "Supra-littoral Rock": "G Supra-littoral Rock",
    "Supra-littoral Sediment": "G Supra-littoral Sediment",
    "Littoral Rock": "G Littoral Rock",
    "Littoral sediment": "G Littoral Sediment",
    "Saltmarsh": "G Saltmarash",
    "Urban": "G Urban",
    "Suburban": "G Suburban",
    "NAEI SNAP 1 NOx": "E SNAP 1 NOx",
    "NAEI SNAP 2 NOx": "E SNAP 2 NOx",
    "NAEI SNAP 3 NOx": "E SNAP 3 NOx",
    "NAEI SNAP 4 NOx": "E SNAP 4 NOx",
    "NAEI SNAP 5 NOx": "E SNAP 5 NOx",
    "NAEI SNAP 6 NOx": "E SNAP 6 NOx",
    "NAEI SNAP 7 NOx": "E SNAP 7 NOx",
    "NAEI SNAP 8 NOx": "E SNAP 8 NOx",
    "NAEI SNAP 9 NOx": "E SNAP 9 NOx",
    "NAEI SNAP 10 NOx": "E SNAP 10 NOx",
    "NAEI SNAP 11 NOx": "E SNAP 11 NOx",
    "NAEI SNAP 1 CO": "E SNAP 1 CO",
    "NAEI SNAP 2 CO": "E SNAP 2 CO",
    "NAEI SNAP 3 CO": "E SNAP 3 CO",
    "NAEI SNAP 4 CO": "E SNAP 4 CO",
    "NAEI SNAP 5 CO": "E SNAP 5 CO",
    "NAEI SNAP 6 CO": "E SNAP 6 CO",
    "NAEI SNAP 7 CO": "E SNAP 7 CO",
    "NAEI SNAP 8 CO": "E SNAP 8 CO",
    "NAEI SNAP 9 CO": "E SNAP 9 CO",
    "NAEI SNAP 10 CO": "E SNAP 10 CO",
    "NAEI SNAP 11 CO": "E SNAP 11 CO",
    "NAEI SNAP 1 SOx": "E SNAP 1 SOx",
    "NAEI SNAP 2 SOx": "E SNAP 2 SOx",
    "NAEI SNAP 3 SOx": "E SNAP 3 SOx",
    "NAEI SNAP 4 SOx": "E SNAP 4 SOx",
    "NAEI SNAP 5 SOx": "E SNAP 5 SOx",
    "NAEI SNAP 6 SOx": "E SNAP 6 SOx",
    "NAEI SNAP 7 SOx": "E SNAP 7 SOx",
    "NAEI SNAP 8 SOx": "E SNAP 8 SOx",
    "NAEI SNAP 9 SOx": "E SNAP 9 SOx",
    "NAEI SNAP 10 SOx": "E SNAP 10 SOx",
    "NAEI SNAP 11 SOx": "E SNAP 11 SOx",
    "NAEI SNAP 1 NH3": "E SNAP 1 NH3",
    "NAEI SNAP 2 NH3": "E SNAP 2 NH3",
    "NAEI SNAP 3 NH3": "E SNAP 3 NH3",
    "NAEI SNAP 4 NH3": "E SNAP 4 NH3",
    "NAEI SNAP 5 NH3": "E SNAP 5 NH3",
    "NAEI SNAP 6 NH3": "E SNAP 6 NH3",
    "NAEI SNAP 7 NH3": "E SNAP 7 NH3",
    "NAEI SNAP 8 NH3": "E SNAP 8 NH3",
    "NAEI SNAP 9 NH3": "E SNAP 9 NH3",
    "NAEI SNAP 10 NH3": "E SNAP 10 NH3",
    "NAEI SNAP 11 NH3": "E SNAP 11 NH3",
    "NAEI SNAP 1 NMVOC": "E SNAP 1 NMVOC",
    "NAEI SNAP 2 NMVOC": "E SNAP 2 NMVOC",
    "NAEI SNAP 3 NMVOC": "E SNAP 3 NMVOC",
    "NAEI SNAP 4 NMVOC": "E SNAP 4 NMVOC",
    "NAEI SNAP 5 NMVOC": "E SNAP 5 NMVOC",
    "NAEI SNAP 6 NMVOC": "E SNAP 6 NMVOC",
    "NAEI SNAP 7 NMVOC": "E SNAP 7 NMVOC",
    "NAEI SNAP 8 NMVOC": "E SNAP 8 NMVOC",
    "NAEI SNAP 9 NMVOC": "E SNAP 9 NMVOC",
    "NAEI SNAP 10 NMVOC": "E SNAP 10 NMVOC",
    "NAEI SNAP 11 NMVOC": "E SNAP 11 NMVOC",
    "NAEI SNAP 1 PM10": "E SNAP 1 PM10",
    "NAEI SNAP 2 PM10": "E SNAP 2 PM10",
    "NAEI SNAP 3 PM10": "E SNAP 3 PM10",
    "NAEI SNAP 4 PM10": "E SNAP 4 PM10",
    "NAEI SNAP 5 PM10": "E SNAP 5 PM10",
    "NAEI SNAP 6 PM10": "E SNAP 6 PM10",
    "NAEI SNAP 7 PM10": "E SNAP 7 PM10",
    "NAEI SNAP 8 PM10": "E SNAP 8 PM10",
    "NAEI SNAP 9 PM10": "E SNAP 9 PM10",
    "NAEI SNAP 10 PM10": "E SNAP 10 PM10",
    "NAEI SNAP 11 PM10": "E SNAP 11 PM10",
    "NAEI SNAP 1 PM25": "E SNAP 1 PM25",
    "NAEI SNAP 2 PM25": "E SNAP 2 PM25",
    "NAEI SNAP 3 PM25": "E SNAP 3 PM25",
    "NAEI SNAP 4 PM25": "E SNAP 4 PM25",
    "NAEI SNAP 5 PM25": "E SNAP 5 PM25",
    "NAEI SNAP 6 PM25": "E SNAP 6 PM25",
    "NAEI SNAP 7 PM25": "E SNAP 7 PM25",
    "NAEI SNAP 8 PM25": "E SNAP 8 PM25",
    "NAEI SNAP 9 PM25": "E SNAP 9 PM25",
    "NAEI SNAP 10 PM25": "E SNAP 10 PM25",
    "NAEI SNAP 11 PM25": "E SNAP 11 PM25",
}


featureVectorColumnNames = [
    "Bicycle Score",
    "Car and Taxi Score",
    "Bus and Coach Score",
    "LGV Score",
    "HGV Score",
    "Week Number",
    "Month Number",
    "Day of Week Number",
    "Hour Number",
    "100m_u_component_of_wind",
    "100m_v_component_of_wind",
    "10m_u_component_of_wind",
    "10m_v_component_of_wind",
    "2m_dewpoint_temperature",
    "2m_temperature",
    "boundary_layer_height",
    "downward_uv_radiation_at_the_surface",
    "instantaneous_10m_wind_gust",
    "surface_pressure",
    "total_column_rain_water",
    "S5P_NO2",
    "S5P_AAI",
    "S5P_CO",
    "S5P_HCHO",
    "S5P_O3",
    "Road Infrastructure Distance residential",
    "Road Infrastructure Distance footway",
    "Road Infrastructure Distance service",
    "Road Infrastructure Distance primary",
    "Road Infrastructure Distance path",
    "Road Infrastructure Distance cycleway",
    "Road Infrastructure Distance tertiary",
    "Road Infrastructure Distance secondary",
    "Road Infrastructure Distance unclassified",
    "Road Infrastructure Distance trunk",
    "Road Infrastructure Distance track",
    "Road Infrastructure Distance motorway",
    "Road Infrastructure Distance pedestrian",
    "Road Infrastructure Distance living_street",
    "Total Length cycleway",
    "Total Length footway",
    "Total Length living_street",
    "Total Length motorway",
    "Total Length path",
    "Total Length pedestrian",
    "Total Length primary",
    "Total Length residential",
    "Total Length secondary",
    "Total Length service",
    "Total Length tertiary",
    "Total Length track",
    "Total Length trunk",
    "Total Length unclassified",
    "No Land",
    "Broadleaved woodland",
    "Coniferous Woodland",
    "Arable and Horticulture",
    "Improved Grassland",
    "Neutral Grassland",
    "Calcareous Grassland",
    "Acid grassland",
    "Fen Marsh and Swamp",
    "Heather",
    "Heather grassland",
    "Bog",
    "Inland Rock",
    "Saltwater",
    "Freshwater",
    "Supra-littoral Rock",
    "Supra-littoral Sediment",
    "Littoral Rock",
    "Littoral sediment",
    "Saltmarsh",
    "Urban",
    "Suburban",
    "NAEI SNAP 1 NOx",
    "NAEI SNAP 2 NOx",
    "NAEI SNAP 3 NOx",
    "NAEI SNAP 4 NOx",
    "NAEI SNAP 5 NOx",
    "NAEI SNAP 6 NOx",
    "NAEI SNAP 7 NOx",
    "NAEI SNAP 8 NOx",
    "NAEI SNAP 9 NOx",
    "NAEI SNAP 10 NOx",
    "NAEI SNAP 11 NOx",
    "NAEI SNAP 1 CO",
    "NAEI SNAP 2 CO",
    "NAEI SNAP 3 CO",
    "NAEI SNAP 4 CO",
    "NAEI SNAP 5 CO",
    "NAEI SNAP 6 CO",
    "NAEI SNAP 7 CO",
    "NAEI SNAP 8 CO",
    "NAEI SNAP 9 CO",
    "NAEI SNAP 10 CO",
    "NAEI SNAP 11 CO",
    "NAEI SNAP 1 SOx",
    "NAEI SNAP 2 SOx",
    "NAEI SNAP 3 SOx",
    "NAEI SNAP 4 SOx",
    "NAEI SNAP 5 SOx",
    "NAEI SNAP 6 SOx",
    "NAEI SNAP 7 SOx",
    "NAEI SNAP 8 SOx",
    "NAEI SNAP 9 SOx",
    "NAEI SNAP 10 SOx",
    "NAEI SNAP 11 SOx",
    "NAEI SNAP 1 NH3",
    "NAEI SNAP 2 NH3",
    "NAEI SNAP 3 NH3",
    "NAEI SNAP 4 NH3",
    "NAEI SNAP 5 NH3",
    "NAEI SNAP 6 NH3",
    "NAEI SNAP 7 NH3",
    "NAEI SNAP 8 NH3",
    "NAEI SNAP 9 NH3",
    "NAEI SNAP 10 NH3",
    "NAEI SNAP 11 NH3",
    "NAEI SNAP 1 NMVOC",
    "NAEI SNAP 2 NMVOC",
    "NAEI SNAP 3 NMVOC",
    "NAEI SNAP 4 NMVOC",
    "NAEI SNAP 5 NMVOC",
    "NAEI SNAP 6 NMVOC",
    "NAEI SNAP 7 NMVOC",
    "NAEI SNAP 8 NMVOC",
    "NAEI SNAP 9 NMVOC",
    "NAEI SNAP 10 NMVOC",
    "NAEI SNAP 11 NMVOC",
    "NAEI SNAP 1 PM10",
    "NAEI SNAP 2 PM10",
    "NAEI SNAP 3 PM10",
    "NAEI SNAP 4 PM10",
    "NAEI SNAP 5 PM10",
    "NAEI SNAP 6 PM10",
    "NAEI SNAP 7 PM10",
    "NAEI SNAP 8 PM10",
    "NAEI SNAP 9 PM10",
    "NAEI SNAP 10 PM10",
    "NAEI SNAP 11 PM10",
    "NAEI SNAP 1 PM25",
    "NAEI SNAP 2 PM25",
    "NAEI SNAP 3 PM25",
    "NAEI SNAP 4 PM25",
    "NAEI SNAP 5 PM25",
    "NAEI SNAP 6 PM25",
    "NAEI SNAP 7 PM25",
    "NAEI SNAP 8 PM25",
    "NAEI SNAP 9 PM25",
    "NAEI SNAP 10 PM25",
    "NAEI SNAP 11 PM25",
]

featureVectorDatasetFamily = {
    "Bicycle Score": "Transport Use",
    "Car and Taxi Score": "Transport Use",
    "Bus and Coach Score": "Transport Use",
    "LGV Score": "Transport Use",
    "HGV Score": "Transport Use",
    "Week Number": "Temporal",
    "Month Number": "Temporal",
    "Day of Week Number": "Temporal",
    "Hour Number": "Temporal",
    "100m_u_component_of_wind": "Metrological",
    "100m_v_component_of_wind": "Metrological",
    "10m_u_component_of_wind": "Metrological",
    "10m_v_component_of_wind": "Metrological",
    "2m_dewpoint_temperature": "Metrological",
    "2m_temperature": "Metrological",
    "boundary_layer_height": "Metrological",
    "downward_uv_radiation_at_the_surface": "Metrological",
    "instantaneous_10m_wind_gust": "Metrological",
    "surface_pressure": "Metrological",
    "total_column_rain_water": "Metrological",
    "S5P_NO2": "Remote Sensing",
    "S5P_AAI": "Remote Sensing",
    "S5P_CO": "Remote Sensing",
    "S5P_HCHO": "Remote Sensing",
    "S5P_O3": "Remote Sensing",
    "Road Infrastructure Distance residential": "Transport Infrastructure",
    "Road Infrastructure Distance footway": "Transport Infrastructure",
    "Road Infrastructure Distance service": "Transport Infrastructure",
    "Road Infrastructure Distance primary": "Transport Infrastructure",
    "Road Infrastructure Distance path": "Transport Infrastructure",
    "Road Infrastructure Distance cycleway": "Transport Infrastructure",
    "Road Infrastructure Distance tertiary": "Transport Infrastructure",
    "Road Infrastructure Distance secondary": "Transport Infrastructure",
    "Road Infrastructure Distance unclassified": "Transport Infrastructure",
    "Road Infrastructure Distance trunk": "Transport Infrastructure",
    "Road Infrastructure Distance track": "Transport Infrastructure",
    "Road Infrastructure Distance motorway": "Transport Infrastructure",
    "Road Infrastructure Distance pedestrian": "Transport Infrastructure",
    "Road Infrastructure Distance living_street": "Transport Infrastructure",
    "Total Length cycleway": "Transport Infrastructure",
    "Total Length footway": "Transport Infrastructure",
    "Total Length living_street": "Transport Infrastructure",
    "Total Length motorway": "Transport Infrastructure",
    "Total Length path": "Transport Infrastructure",
    "Total Length pedestrian": "Transport Infrastructure",
    "Total Length primary": "Transport Infrastructure",
    "Total Length residential": "Transport Infrastructure",
    "Total Length secondary": "Transport Infrastructure",
    "Total Length service": "Transport Infrastructure",
    "Total Length tertiary": "Transport Infrastructure",
    "Total Length track": "Transport Infrastructure",
    "Total Length trunk": "Transport Infrastructure",
    "Total Length unclassified": "Transport Infrastructure",
    "No Land": "Geographic",
    "Broadleaved woodland": "Geographic",
    "Coniferous Woodland": "Geographic",
    "Arable and Horticulture": "Geographic",
    "Improved Grassland": "Geographic",
    "Neutral Grassland": "Geographic",
    "Calcareous Grassland": "Geographic",
    "Acid grassland": "Geographic",
    "Fen Marsh and Swamp": "Geographic",
    "Heather": "Geographic",
    "Heather grassland": "Geographic",
    "Bog": "Geographic",
    "Inland Rock": "Geographic",
    "Saltwater": "Geographic",
    "Freshwater": "Geographic",
    "Supra-littoral Rock": "Geographic",
    "Supra-littoral Sediment": "Geographic",
    "Littoral Rock": "Geographic",
    "Littoral sediment": "Geographic",
    "Saltmarsh": "Geographic",
    "Urban": "Geographic",
    "Suburban": "Geographic",
    "NAEI SNAP 1 NOx": "Emissions",
    "NAEI SNAP 2 NOx": "Emissions",
    "NAEI SNAP 3 NOx": "Emissions",
    "NAEI SNAP 4 NOx": "Emissions",
    "NAEI SNAP 5 NOx": "Emissions",
    "NAEI SNAP 6 NOx": "Emissions",
    "NAEI SNAP 7 NOx": "Emissions",
    "NAEI SNAP 8 NOx": "Emissions",
    "NAEI SNAP 9 NOx": "Emissions",
    "NAEI SNAP 10 NOx": "Emissions",
    "NAEI SNAP 11 NOx": "Emissions",
    "NAEI SNAP 1 CO": "Emissions",
    "NAEI SNAP 2 CO": "Emissions",
    "NAEI SNAP 3 CO": "Emissions",
    "NAEI SNAP 4 CO": "Emissions",
    "NAEI SNAP 5 CO": "Emissions",
    "NAEI SNAP 6 CO": "Emissions",
    "NAEI SNAP 7 CO": "Emissions",
    "NAEI SNAP 8 CO": "Emissions",
    "NAEI SNAP 9 CO": "Emissions",
    "NAEI SNAP 10 CO": "Emissions",
    "NAEI SNAP 11 CO": "Emissions",
    "NAEI SNAP 1 SOx": "Emissions",
    "NAEI SNAP 2 SOx": "Emissions",
    "NAEI SNAP 3 SOx": "Emissions",
    "NAEI SNAP 4 SOx": "Emissions",
    "NAEI SNAP 5 SOx": "Emissions",
    "NAEI SNAP 6 SOx": "Emissions",
    "NAEI SNAP 7 SOx": "Emissions",
    "NAEI SNAP 8 SOx": "Emissions",
    "NAEI SNAP 9 SOx": "Emissions",
    "NAEI SNAP 10 SOx": "Emissions",
    "NAEI SNAP 11 SOx": "Emissions",
    "NAEI SNAP 1 NH3": "Emissions",
    "NAEI SNAP 2 NH3": "Emissions",
    "NAEI SNAP 3 NH3": "Emissions",
    "NAEI SNAP 4 NH3": "Emissions",
    "NAEI SNAP 5 NH3": "Emissions",
    "NAEI SNAP 6 NH3": "Emissions",
    "NAEI SNAP 7 NH3": "Emissions",
    "NAEI SNAP 8 NH3": "Emissions",
    "NAEI SNAP 9 NH3": "Emissions",
    "NAEI SNAP 10 NH3": "Emissions",
    "NAEI SNAP 11 NH3": "Emissions",
    "NAEI SNAP 1 NMVOC": "Emissions",
    "NAEI SNAP 2 NMVOC": "Emissions",
    "NAEI SNAP 3 NMVOC": "Emissions",
    "NAEI SNAP 4 NMVOC": "Emissions",
    "NAEI SNAP 5 NMVOC": "Emissions",
    "NAEI SNAP 6 NMVOC": "Emissions",
    "NAEI SNAP 7 NMVOC": "Emissions",
    "NAEI SNAP 8 NMVOC": "Emissions",
    "NAEI SNAP 9 NMVOC": "Emissions",
    "NAEI SNAP 10 NMVOC": "Emissions",
    "NAEI SNAP 11 NMVOC": "Emissions",
    "NAEI SNAP 1 PM10": "Emissions",
    "NAEI SNAP 2 PM10": "Emissions",
    "NAEI SNAP 3 PM10": "Emissions",
    "NAEI SNAP 4 PM10": "Emissions",
    "NAEI SNAP 5 PM10": "Emissions",
    "NAEI SNAP 6 PM10": "Emissions",
    "NAEI SNAP 7 PM10": "Emissions",
    "NAEI SNAP 8 PM10": "Emissions",
    "NAEI SNAP 9 PM10": "Emissions",
    "NAEI SNAP 10 PM10": "Emissions",
    "NAEI SNAP 11 PM10": "Emissions",
    "NAEI SNAP 1 PM25": "Emissions",
    "NAEI SNAP 2 PM25": "Emissions",
    "NAEI SNAP 3 PM25": "Emissions",
    "NAEI SNAP 4 PM25": "Emissions",
    "NAEI SNAP 5 PM25": "Emissions",
    "NAEI SNAP 6 PM25": "Emissions",
    "NAEI SNAP 7 PM25": "Emissions",
    "NAEI SNAP 8 PM25": "Emissions",
    "NAEI SNAP 9 PM25": "Emissions",
    "NAEI SNAP 10 PM25": "Emissions",
    "NAEI SNAP 11 PM25": "Emissions",
}


transportColumns = [
    "Bicycle Score",
    "Car and Taxi Score",
    "Bus and Coach Score",
    "LGV Score",
    "HGV Score",
]
osmRoadInfrastructure = [
    "Road Infrastructure Distance residential",
    "Road Infrastructure Distance footway",
    "Road Infrastructure Distance service",
    "Road Infrastructure Distance primary",
    "Road Infrastructure Distance path",
    "Road Infrastructure Distance cycleway",
    "Road Infrastructure Distance tertiary",
    "Road Infrastructure Distance secondary",
    "Road Infrastructure Distance unclassified",
    "Road Infrastructure Distance trunk",
    "Road Infrastructure Distance track",
    "Road Infrastructure Distance motorway",
    "Road Infrastructure Distance pedestrian",
    "Road Infrastructure Distance living_street",
    "Total Length cycleway",
    "Total Length footway",
    "Total Length living_street",
    "Total Length motorway",
    "Total Length path",
    "Total Length pedestrian",
    "Total Length primary",
    "Total Length residential",
    "Total Length secondary",
    "Total Length service",
    "Total Length tertiary",
    "Total Length track",
    "Total Length trunk",
    "Total Length unclassified",
]
geographicColumns = [
    "No Land",
    "Broadleaved woodland",
    "Coniferous Woodland",
    "Arable and Horticulture",
    "Improved Grassland",
    "Neutral Grassland",
    "Calcareous Grassland",
    "Acid grassland",
    "Fen Marsh and Swamp",
    "Heather",
    "Heather grassland",
    "Bog",
    "Inland Rock",
    "Saltwater",
    "Freshwater",
    "Supra-littoral Rock",
    "Supra-littoral Sediment",
    "Littoral Rock",
    "Littoral sediment",
    "Saltmarsh",
    "Urban",
    "Suburban",
]
metrologicalColumns = [
    "100m_u_component_of_wind",
    "100m_v_component_of_wind",
    "10m_u_component_of_wind",
    "10m_v_component_of_wind",
    "2m_dewpoint_temperature",
    "2m_temperature",
    "boundary_layer_height",
    "downward_uv_radiation_at_the_surface",
    "instantaneous_10m_wind_gust",
    "surface_pressure",
    "total_column_rain_water",
]
emissionsColumns = [
    "NAEI SNAP 1 NOx",
    "NAEI SNAP 2 NOx",
    "NAEI SNAP 3 NOx",
    "NAEI SNAP 4 NOx",
    "NAEI SNAP 5 NOx",
    "NAEI SNAP 6 NOx",
    "NAEI SNAP 7 NOx",
    "NAEI SNAP 8 NOx",
    "NAEI SNAP 9 NOx",
    "NAEI SNAP 10 NOx",
    "NAEI SNAP 11 NOx",
    "NAEI SNAP 1 CO",
    "NAEI SNAP 2 CO",
    "NAEI SNAP 3 CO",
    "NAEI SNAP 4 CO",
    "NAEI SNAP 5 CO",
    "NAEI SNAP 6 CO",
    "NAEI SNAP 7 CO",
    "NAEI SNAP 8 CO",
    "NAEI SNAP 9 CO",
    "NAEI SNAP 10 CO",
    "NAEI SNAP 11 CO",
    "NAEI SNAP 1 SOx",
    "NAEI SNAP 2 SOx",
    "NAEI SNAP 3 SOx",
    "NAEI SNAP 4 SOx",
    "NAEI SNAP 5 SOx",
    "NAEI SNAP 6 SOx",
    "NAEI SNAP 7 SOx",
    "NAEI SNAP 8 SOx",
    "NAEI SNAP 9 SOx",
    "NAEI SNAP 10 SOx",
    "NAEI SNAP 11 SOx",
    "NAEI SNAP 1 NH3",
    "NAEI SNAP 2 NH3",
    "NAEI SNAP 3 NH3",
    "NAEI SNAP 4 NH3",
    "NAEI SNAP 5 NH3",
    "NAEI SNAP 6 NH3",
    "NAEI SNAP 7 NH3",
    "NAEI SNAP 8 NH3",
    "NAEI SNAP 9 NH3",
    "NAEI SNAP 10 NH3",
    "NAEI SNAP 11 NH3",
    "NAEI SNAP 1 NMVOC",
    "NAEI SNAP 2 NMVOC",
    "NAEI SNAP 3 NMVOC",
    "NAEI SNAP 4 NMVOC",
    "NAEI SNAP 5 NMVOC",
    "NAEI SNAP 6 NMVOC",
    "NAEI SNAP 7 NMVOC",
    "NAEI SNAP 8 NMVOC",
    "NAEI SNAP 9 NMVOC",
    "NAEI SNAP 10 NMVOC",
    "NAEI SNAP 11 NMVOC",
    "NAEI SNAP 1 PM10",
    "NAEI SNAP 2 PM10",
    "NAEI SNAP 3 PM10",
    "NAEI SNAP 4 PM10",
    "NAEI SNAP 5 PM10",
    "NAEI SNAP 6 PM10",
    "NAEI SNAP 7 PM10",
    "NAEI SNAP 8 PM10",
    "NAEI SNAP 9 PM10",
    "NAEI SNAP 10 PM10",
    "NAEI SNAP 11 PM10",
    "NAEI SNAP 1 PM25",
    "NAEI SNAP 2 PM25",
    "NAEI SNAP 3 PM25",
    "NAEI SNAP 4 PM25",
    "NAEI SNAP 5 PM25",
    "NAEI SNAP 6 PM25",
    "NAEI SNAP 7 PM25",
    "NAEI SNAP 8 PM25",
    "NAEI SNAP 9 PM25",
    "NAEI SNAP 10 PM25",
    "NAEI SNAP 11 PM25",
]
remoteSensingColumns = ["S5P_NO2", "S5P_AAI", "S5P_CO", "S5P_HCHO", "S5P_O3"]
temporalColumns = ["Week Number", "Month Number", "Day of Week Number", "Hour Number"]

featureVectorSubsets = {
    "All": transportColumns
    + temporalColumns
    + metrologicalColumns
    + remoteSensingColumns
    + osmRoadInfrastructure
    + geographicColumns
    + emissionsColumns,
    "Forecasting": osmRoadInfrastructure
    + geographicColumns
    + metrologicalColumns
    + temporalColumns,
    "Forecasting (Transport and Emissions)": transportColumns
    + osmRoadInfrastructure
    + geographicColumns
    + metrologicalColumns
    + temporalColumns
    + emissionsColumns,
    "Global": temporalColumns + metrologicalColumns + remoteSensingColumns,
    "Temporal": temporalColumns,
    "Metrological": metrologicalColumns,
    "Transport Infrastructure": osmRoadInfrastructure,
    "Transport Use": transportColumns,
    "Remote Sensing": remoteSensingColumns,
    "Geographic": geographicColumns,
    "Emissions": emissionsColumns,
    "Transport Infrastructure Policy": temporalColumns
    + metrologicalColumns
    + osmRoadInfrastructure,
    "Climate Projections": transportColumns
    + temporalColumns
    + metrologicalColumns
    + osmRoadInfrastructure
    + geographicColumns,
}
