# generated by datamodel-codegen:
#   filename:  queue_message.json
#   timestamp: 2025-11-20T23:53:07+00:00

from __future__ import annotations

from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import Field, RootModel, constr, ConfigDict, field_validator
from utf_queue_client.models.base_model import BaseModel


class Model(RootModel[Any]):
    root: Any


class QueueRecord(BaseModel):
    model_config = ConfigDict(extra="allow")


class DataLakeData(BaseModel):
    dataFormat: Literal["CSV", "JSON", "JSONSTR", "NDJSON", "PARQUET"]
    object_id: Optional[str] = None
    data: Union[Dict[str, Any], List[Dict[str, Any]], str]
    compression: Optional[Literal["GZIP", "NONE", "SNAPPY"]] = None


class TelemetryData(BaseModel):
    dataType: Literal["LOGS", "METRICS", "TRACES"]
    base64ProtobufData: str
    compression: Optional[str] = None


class ArtifactMetadata(BaseModel):
    model_config = ConfigDict(extra="allow")


class ArtifactBuildMetadata(BaseModel):
    branch: Optional[str] = None
    stack: Optional[str] = None
    build_number: Optional[str] = None
    target: Optional[str] = None
    studio: Optional[str] = None
    compiler: Optional[str] = None
    app_name: Optional[str] = None
    test_suite: Optional[str] = None
    chip_id: Optional[str] = None
    studio_build_version: Optional[str] = None
    compiler_build_version: Optional[str] = None


class SqaAppBuildResult(BaseModel):
    session_pk_id: str = Field(
        ...,
        description="Logical FK to dbo.jobStatusTable.\nNot creating the constraint in case this comes in before the session record.",
    )
    app_name: constr(max_length=512) = Field(..., description="Name of the application")
    app_description: Optional[constr(max_length=1024)] = Field(
        None, description="Description of what the application does"
    )
    test_suite_name: Optional[constr(max_length=512)] = Field(
        None, description="Description of the grouping of applications"
    )
    test_result_type: constr(max_length=256) = Field(
        ..., description="Need table for validation created from the existing java enum"
    )
    executor_name: Optional[constr(max_length=256)] = Field(
        None, description="Where the application was built"
    )
    feature_name: Optional[constr(max_length=256)] = Field(
        None, description="Feature being tested by this test"
    )
    module_name: Optional[constr(max_length=256)] = Field(
        None, description="Description of the device type that the application runs on"
    )
    phy_name: Optional[constr(max_length=256)] = Field(
        None, description="Radio configuration used by the device"
    )
    test_result: Literal["FAIL", "PASS", "block", "fail", "pass", "skip"] = Field(
        ..., description="Did the application build"
    )
    engineer_name: Optional[constr(max_length=256)] = Field(
        None, description="Name of the engineer who created the test"
    )
    exception_msg: Optional[str] = Field(
        None, description="Stack dump exception message from build"
    )
    iot_req_id: Optional[constr(max_length=256)] = Field(
        None, description="JIRA IOT Req Number"
    )
    tool_chain: Optional[constr(max_length=256)] = Field(
        None,
        description="Need table for validation.\nThis is the tool and version used to build the application with colon separation\niar:7.80.1",
    )
    notes: Optional[constr(max_length=256)] = None
    test_duration_sec: float = Field(
        ..., description="Length of time to build the application"
    )
    package_info: Optional[str] = None
    artifact_id: Optional[constr(max_length=36)] = None
    app_version: Optional[constr(max_length=50)] = None


class SqaTestResult(BaseModel):
    session_pk_id: str = Field(
        ...,
        description="Logical FK to dbo.jobStatusTable.\nNot creating the constraint in case this comes in before the session record.",
    )
    test_case_id: constr(max_length=512) = Field(
        ...,
        description="Passed in from the test executor.\nFrom the test management system or git.",
    )
    test_case_version_num: int
    test_suite_name: Optional[constr(max_length=512)] = Field(
        None, description="Named group of tests"
    )
    test_description: Optional[constr(max_length=1024)] = Field(
        None, description="What does the test case actually do"
    )
    test_result_type: constr(max_length=256) = Field(
        ..., description="Need to create a table for verification of this field"
    )
    test_parametric_data: Optional[str] = Field(
        None, description="Test Parametric Data"
    )
    test_case_name: constr(max_length=512) = Field(
        ...,
        description="Human readable version of the test case ID\nShort summary/description",
    )
    executor_name: constr(max_length=256) = Field(
        ..., description="Where the test actually ran"
    )
    feature_name: constr(max_length=256) = Field(
        ..., description="Feature being tested by this test"
    )
    test_creation_date: str = Field(
        ..., description="Date the test was created\nISO-8601 format"
    )
    testbed_name: constr(max_length=256) = Field(
        ..., description="Grouping of all of the hardware used to execute the test"
    )
    module_name: constr(max_length=256) = Field(
        ..., description="Testbed component list"
    )
    phy_name: Optional[constr(max_length=256)] = Field(
        None, description="Radio configuration used by the device"
    )
    test_result: Literal["block", "fail", "metrics", "pass", "skip"]
    engineer_name: Optional[constr(max_length=256)] = Field(
        None, description="Name of the engineer who created the test"
    )
    exception_msg: Optional[str] = Field(
        None, description="If an error occurs, this is the message returned."
    )
    iot_req_id: constr(max_length=256)
    tool_chain: constr(max_length=256) = Field(
        ...,
        description="Need table for validation.\nThis is the tool and version used to build the application with colon separation\niar:7.80.1",
    )
    vendor_name: Optional[constr(max_length=256)] = None
    vendor_build: Optional[constr(max_length=256)] = None
    vendor_result: Optional[constr(max_length=256)] = None
    notes: Optional[constr(max_length=1024)] = None
    portal_watch: Optional[str] = Field(
        None, description="Change this to boolean - default false"
    )
    test_duration_sec: float = Field(..., description="Test duration in seconds")
    test_bed_label: Optional[constr(max_length=256)] = None
    req_id: Optional[constr(max_length=256)] = None
    product_line: Optional[constr(max_length=256)] = None
    product_type: Optional[constr(max_length=256)] = None
    customer_type: Optional[constr(max_length=256)] = None
    jenkins_test_case_results_url: Optional[constr(max_length=1500)] = None
    test_case_uuid: Optional[str] = Field(
        None, description="UUID generated by the client software"
    )


class SqaTestSession(BaseModel):
    PK_ID: str = Field(..., description="UUID generated by the Jenkins client software")
    startTime: str = Field(..., description="ISO-8601 Datetime")
    stopTime: Optional[str] = Field(None, description="ISO-8601 datetime")
    jenkinsJobStatus: Literal["COMPLETE", "FAIL", "IN PROGRESS"] = Field(
        ..., description="Status of the Jenkins job"
    )
    duration: Optional[int] = Field(
        None,
        description="Elapsed number of seconds for the Jenkins job.\nShould be close to stop time - start time.\nChange the data type in the DB to integer.",
    )
    jobType: Optional[constr(max_length=256)] = Field(
        None, description="Type of Jenkins job"
    )
    releaseName: constr(max_length=256)
    branchName: constr(max_length=256)
    stackName: constr(max_length=256)
    SDKBuildNum: float
    SDKUrl: Optional[constr(max_length=1500)] = None
    studioUrl: Optional[constr(max_length=1500)] = None
    totalTests: Optional[int] = None
    PASS_cnt: Optional[int] = None
    FAIL_cnt: Optional[int] = None
    SKIP_cnt: Optional[int] = None
    BLOCK_cnt: Optional[int] = None
    jenkinsServerName: constr(max_length=256)
    jenkinRunNum: int
    jenkinsJobName: constr(max_length=1500)
    jenkinsTestResultsUrl: constr(max_length=1500)
    traceId: Optional[constr(max_length=500)] = None
    testFramework: Optional[constr(max_length=256)] = None
    SDKVersion: Optional[constr(max_length=256)] = None
    test_run_by: Optional[constr(max_length=256)] = None
    package_name: Optional[constr(max_length=500)] = None
    package_version: Optional[constr(max_length=50)] = None
    package_datetime: Optional[str] = Field(None, description="ISO-8601 Datetime")
    from_branch_name: Optional[constr(max_length=250)] = Field(
        None, description="Branch from which the test originated"
    )
    from_build_num: Optional[float] = Field(
        None, description="Build number from which the test originated"
    )


class LogEvent(BaseModel):
    pass


class ExceptionEvent(BaseModel):
    pass


class TestResultCustomProps(BaseModel):
    model_config = ConfigDict(extra="allow")


class XrayInfo(BaseModel):
    project: Optional[str] = None
    summary: Optional[str] = None
    description: Optional[str] = None
    version: Optional[str] = None
    revision: Optional[str] = None
    user: Optional[str] = None
    start_date: Optional[str] = None
    finish_date: Optional[str] = None
    test_plan_key: Optional[str] = None
    test_environments: Optional[List[str]] = None


class XrayStep(BaseModel):
    action: str
    data: str
    result: str


class XrayParameter(BaseModel):
    name: str
    value: str


class XrayCustomField(BaseModel):
    name: str
    id: Optional[int] = None
    value: str


class XrayIteration(BaseModel):
    name: Optional[str] = None
    id: Optional[int] = None
    parameters: List[XrayParameter]
    status: str = Field(
        ...,
        description="Status for the iteration (examples: PASS, FAIL, SKIP, BLOCK, BROKEN, REGRESSION)",
    )


class XrayTestInfo(BaseModel):
    project_key: str
    summary: Optional[str] = None
    description: Optional[str] = None
    test_type: Optional[str] = None
    requirement_keys: Optional[List[str]] = None
    labels: Optional[List[str]] = None
    steps: Optional[List[XrayStep]] = None


class XrayTestExecUpdate(BaseModel):
    test_key: str
    status: str = Field(
        ...,
        description="Status for the iteration (examples: PASS, FAIL, SKIP, BLOCK, BROKEN, REGRESSION)",
    )
    test_info: Optional[XrayTestInfo] = None
    test_version: Optional[str] = None
    start: Optional[str] = None
    finish: Optional[str] = None
    comment: Optional[str] = None
    executed_by: Optional[str] = None
    assignee: Optional[str] = None
    steps: Optional[List[XrayStep]] = None
    iterations: Optional[List[XrayIteration]] = None
    custom_fields: Optional[List[XrayCustomField]] = None


class XrayImportTestExecution(BaseModel):
    test_execution_key: str
    tests: List[XrayTestExecUpdate]
    test_map_field_name: Optional[str] = None
    info: Optional[XrayInfo] = None
    add_tests_to_plan: Optional[bool] = None
    create_test_for_execution: Optional[bool] = None


class SqaTestResultApps(BaseModel):
    test_case_uuid: constr(max_length=36)
    artifact_id: constr(max_length=36)


class QueueMessage(BaseModel):

    @field_validator("payload", mode="before")
    def validate_payload(cls, v):
        if isinstance(v, BaseModel):
            return QueueRecord(v.model_dump())
        return v

    recordType: Literal[
        "ARTIFACT_UPLOAD_REQUEST",
        "DATALAKE_DATA",
        "EXCEPTION_EVENT",
        "LOG_EVENT",
        "OPENTELEMETRY_DATA",
        "TEST_RAIL_EVENT",
        "UTF_TEST_EVENT",
        "XRAY_EVENT",
    ] = Field(..., description="Type of record")
    recordSubType: Optional[
        Literal[
            "BUILD_RESULT",
            "IMPORT_TEST_EXECUTION",
            "SESSION_START",
            "SESSION_STOP",
            "TEST_RESULT",
            "TEST_RESULT_APP",
        ]
    ] = Field(
        None,
        description="Subtype of record. Not all types have a subtype, but it is required when they have one.",
    )
    tenantKey: str = Field(
        ...,
        description="Unique string that identifies the app/group sending the message.\nForward looking to match the data lake infrastructure.",
    )
    recordTimestamp: str = Field(
        ...,
        description="UTC datetime.\nUse ISO-8601 format with time zone\n2022-03-10T18:50:05Z",
    )
    payload: QueueRecord = Field(
        ...,
        description="Record Payload.\nThis is flexible to allow different fields for different record types and DB tables",
    )
    messageId: Optional[str] = Field(None, description="Unique client-generated UUID")


class QueueMessageV1(BaseModel):

    @field_validator("payload", mode="before")
    def validate_payload(cls, v):
        if isinstance(v, BaseModel):
            return QueueRecord(v.model_dump())
        return v

    recordType: Literal[
        "ARTIFACT_UPLOAD_REQUEST",
        "EXCEPTION_EVENT",
        "LOG_EVENT",
        "TEST_EVENT",
        "UTF_TEST_EVENT",
    ] = Field(..., description="Type of record")
    payload: QueueRecord = Field(..., description="Record Payload")
    timestamp: float = Field(
        ..., description="UTC Timestamp\nGiven in seconds since epoch (unix time)"
    )


class ArtifactUploadRequest(BaseModel):
    name: str
    extension: str
    metadata: Union[ArtifactMetadata, ArtifactBuildMetadata]
    base64Content: str
    validateMetadata: bool


class TestRailResult(BaseModel):
    id: str
    run_id: int
    status: str
    comment: Optional[str] = None
    version: Optional[str] = None
    defects: Optional[str] = None
    assigned_to_id: Optional[int] = None
    custom_props: Optional[TestResultCustomProps] = None
