"""
 Import all RDKit chemistry modules

"""
from __future__ import annotations
from collections import namedtuple
import numpy as numpy
from rdkit.Chem import CanonSmiles
from rdkit.Chem.ChemicalFeatures import MCFF_GetFeaturesForMol
from rdkit.Chem.EnumerateStereoisomers import EnumerateStereoisomers
from rdkit.Chem.EnumerateStereoisomers import StereoEnumerationOptions
from rdkit.Chem import FindMolChiralCenters
from rdkit.Chem import QuickSmartsMatch
from rdkit.Chem import SupplierFromFilename
from rdkit.Chem import inchi
from rdkit.Chem.inchi import InchiReadWriteError
from rdkit.Chem.inchi import InchiToInchiKey
from rdkit.Chem.inchi import MolBlockToInchi
from rdkit.Chem.inchi import MolBlockToInchiAndAuxInfo
from rdkit.Chem.inchi import MolFromInchi
from rdkit.Chem.inchi import MolToInchi
from rdkit.Chem.inchi import MolToInchiAndAuxInfo
from rdkit.Chem.inchi import MolToInchiKey
from rdkit.Chem import rdCIPLabeler
import rdkit.Chem.rdChemReactions
from rdkit.Chem.rdChemReactions import CartesianProductStrategy
from rdkit.Chem.rdChemReactions import ChemicalReaction
from rdkit.Chem.rdChemReactions import EnumerateLibrary
from rdkit.Chem.rdChemReactions import EnumerateLibraryBase
from rdkit.Chem.rdChemReactions import EnumerationParams
from rdkit.Chem.rdChemReactions import EnumerationStrategyBase
from rdkit.Chem.rdChemReactions import EvenSamplePairsStrategy
from rdkit.Chem.rdChemReactions import FingerprintType
from rdkit.Chem.rdChemReactions import MOL_SPTR_VECT
from rdkit.Chem.rdChemReactions import RandomSampleAllBBsStrategy
from rdkit.Chem.rdChemReactions import RandomSampleStrategy
from rdkit.Chem.rdChemReactions import ReactionFingerprintParams
from rdkit.Chem.rdChemReactions import SanitizeFlags
from rdkit.Chem.rdChemReactions import VectMolVect
from rdkit.Chem.rdChemicalFeatures import FreeChemicalFeature
from rdkit.Chem import rdCoordGen
from rdkit.Chem.rdDepictor import ConstrainedDepictionParams
from rdkit.Chem.rdDepictor import UsingCoordGen
import rdkit.Chem.rdDistGeom
from rdkit.Chem.rdDistGeom import EmbedFailureCauses
from rdkit.Chem.rdDistGeom import EmbedParameters
import rdkit.Chem.rdFingerprintGenerator
from rdkit.Chem.rdFingerprintGenerator import AdditionalOutput
from rdkit.Chem.rdFingerprintGenerator import AtomInvariantsGenerator
from rdkit.Chem.rdFingerprintGenerator import AtomPairFingerprintOptions
from rdkit.Chem.rdFingerprintGenerator import BondInvariantsGenerator
from rdkit.Chem.rdFingerprintGenerator import FPType
from rdkit.Chem.rdFingerprintGenerator import FingerprintGenerator32
from rdkit.Chem.rdFingerprintGenerator import FingerprintGenerator64
from rdkit.Chem.rdFingerprintGenerator import FingerprintOptions
from rdkit.Chem.rdFingerprintGenerator import MorganFingerprintOptions
from rdkit.Chem.rdFingerprintGenerator import RDKitFingerprintOptions
from rdkit.Chem.rdFingerprintGenerator import TopologicalTorsionFingerprintOptions
from rdkit.Chem.rdMolAlign import O3A
from rdkit.Chem.rdMolChemicalFeatures import MolChemicalFeature
from rdkit.Chem.rdMolChemicalFeatures import MolChemicalFeatureFactory
from rdkit.Chem.rdMolDescriptors import AtomPairsParameters
from rdkit.Chem.rdMolDescriptors import DoubleCubicLatticeVolume
from rdkit.Chem.rdMolDescriptors import NumRotatableBondsOptions
from rdkit.Chem.rdMolDescriptors import Properties
from rdkit.Chem.rdMolDescriptors import PropertyFunctor
from rdkit.Chem.rdMolDescriptors import PropertyRangeQuery
from rdkit.Chem.rdMolDescriptors import PythonPropertyFunctor
from rdkit.Chem.rdMolEnumerator import EnumeratorType
from rdkit.Chem.rdMolEnumerator import MolEnumeratorParams
from rdkit.Chem import rdMolInterchange
from rdkit.Chem.rdMolInterchange import JSONParseParameters
from rdkit.Chem.rdMolInterchange import JSONWriteParameters
import rdkit.Chem.rdchem
from rdkit.Chem import rdchem
from rdkit.Chem.rdchem import Atom
from rdkit.Chem.rdchem import AtomKekulizeException
from rdkit.Chem.rdchem import AtomMonomerInfo
from rdkit.Chem.rdchem import AtomMonomerType
from rdkit.Chem.rdchem import AtomPDBResidueInfo
from rdkit.Chem.rdchem import AtomSanitizeException
from rdkit.Chem.rdchem import AtomValenceException
from rdkit.Chem.rdchem import Bond
from rdkit.Chem.rdchem import BondDir
from rdkit.Chem.rdchem import BondStereo
from rdkit.Chem.rdchem import BondType
from rdkit.Chem.rdchem import ChiralType
from rdkit.Chem.rdchem import CompositeQueryType
from rdkit.Chem.rdchem import Conformer
from rdkit.Chem.rdchem import EditableMol
from rdkit.Chem.rdchem import FixedMolSizeMolBundle
from rdkit.Chem.rdchem import HybridizationType
from rdkit.Chem.rdchem import KekulizeException
from rdkit.Chem.rdchem import Mol
from rdkit.Chem.rdchem import MolBundle
from rdkit.Chem.rdchem import MolSanitizeException
from rdkit.Chem.rdchem import PeriodicTable
from rdkit.Chem.rdchem import PropertyPickleOptions
from rdkit.Chem.rdchem import QueryAtom
from rdkit.Chem.rdchem import QueryBond
from rdkit.Chem.rdchem import RWMol
from rdkit.Chem.rdchem import ResonanceFlags
from rdkit.Chem.rdchem import ResonanceMolSupplier
from rdkit.Chem.rdchem import ResonanceMolSupplierCallback
from rdkit.Chem.rdchem import RingInfo
from rdkit.Chem.rdchem import StereoDescriptor
from rdkit.Chem.rdchem import StereoGroup
from rdkit.Chem.rdchem import StereoGroupType
from rdkit.Chem.rdchem import StereoGroup_vect
from rdkit.Chem.rdchem import StereoInfo
from rdkit.Chem.rdchem import StereoSpecified
from rdkit.Chem.rdchem import StereoType
from rdkit.Chem.rdchem import SubstanceGroup
from rdkit.Chem.rdchem import SubstanceGroupAttach
from rdkit.Chem.rdchem import SubstanceGroupCState
from rdkit.Chem.rdchem import SubstanceGroup_VECT
from rdkit.Chem.rdchem import SubstructMatchParameters
from rdkit.Chem.rdchem import ValenceType
from rdkit.Chem import rdinchi
from rdkit.Chem import rdmolfiles
from rdkit.Chem.rdmolfiles import CXSmilesFields
from rdkit.Chem.rdmolfiles import ForwardSDMolSupplier
from rdkit.Chem.rdmolfiles import MaeMolSupplier
from rdkit.Chem.rdmolfiles import MaeWriter
from rdkit.Chem.rdmolfiles import MolWriterParams
from rdkit.Chem.rdmolfiles import MultithreadedSDMolSupplier
from rdkit.Chem.rdmolfiles import MultithreadedSmilesMolSupplier
from rdkit.Chem.rdmolfiles import PDBWriter
from rdkit.Chem.rdmolfiles import RestoreBondDirOption
from rdkit.Chem.rdmolfiles import SDMolSupplier
from rdkit.Chem.rdmolfiles import SDWriter
from rdkit.Chem.rdmolfiles import SmartsParserParams
from rdkit.Chem.rdmolfiles import SmilesMolSupplier
from rdkit.Chem.rdmolfiles import SmilesParserParams
from rdkit.Chem.rdmolfiles import SmilesWriteParams
from rdkit.Chem.rdmolfiles import SmilesWriter
from rdkit.Chem.rdmolfiles import TDTMolSupplier
from rdkit.Chem.rdmolfiles import TDTWriter
from rdkit.Chem import rdmolops
import rdkit.Chem.rdmolops
from rdkit.Chem.rdmolops import AddHsParameters
from rdkit.Chem.rdmolops import AdjustQueryParameters
from rdkit.Chem.rdmolops import AdjustQueryWhichFlags
from rdkit.Chem.rdmolops import AromaticityModel
from rdkit.Chem.rdmolops import BondWedgingParameters
from rdkit.Chem.rdmolops import MolzipLabel
from rdkit.Chem.rdmolops import MolzipParams
from rdkit.Chem.rdmolops import RemoveHsParameters
from rdkit.Chem.rdmolops import StereoBondThresholds
from rdkit.Chem.rdmolops import StereoGroupAbsOptions
from rdkit import DataStructs
from rdkit import ForceField
from rdkit.Geometry import rdGeometry
from rdkit import RDConfig
import rdkit.RDLogger
from rdkit import rdBase
import sys as sys
import warnings as warnings
__all__ = ['ADJUST_IGNOREALL', 'ADJUST_IGNORECHAINS', 'ADJUST_IGNOREDUMMIES', 'ADJUST_IGNOREMAPPED', 'ADJUST_IGNORENONDUMMIES', 'ADJUST_IGNORENONE', 'ADJUST_IGNORERINGS', 'ALLOW_CHARGE_SEPARATION', 'ALLOW_INCOMPLETE_OCTETS', 'AROMATICITY_CUSTOM', 'AROMATICITY_DEFAULT', 'AROMATICITY_MDL', 'AROMATICITY_MMFF94', 'AROMATICITY_RDKIT', 'AROMATICITY_SIMPLE', 'AddHsParameters', 'AdditionalOutput', 'AdjustQueryParameters', 'AdjustQueryWhichFlags', 'AllProps', 'AromaticityModel', 'AssignBondOrdersFromTemplate', 'Atom', 'AtomInvariantsGenerator', 'AtomKekulizeException', 'AtomMonomerInfo', 'AtomMonomerType', 'AtomPDBResidueInfo', 'AtomPairFP', 'AtomPairFingerprintOptions', 'AtomPairsParameters', 'AtomProps', 'AtomSanitizeException', 'AtomValenceException', 'BAD_DOUBLE_BOND_STEREO', 'Bond', 'BondDir', 'BondInvariantsGenerator', 'BondProps', 'BondStereo', 'BondType', 'BondWedgingParameters', 'CHECK_CHIRAL_CENTERS', 'CHECK_CHIRAL_CENTERS2', 'CHECK_TETRAHEDRAL_CENTERS', 'CHI_ALLENE', 'CHI_OCTAHEDRAL', 'CHI_OTHER', 'CHI_SQUAREPLANAR', 'CHI_TETRAHEDRAL', 'CHI_TETRAHEDRAL_CCW', 'CHI_TETRAHEDRAL_CW', 'CHI_TRIGONALBIPYRAMIDAL', 'CHI_UNSPECIFIED', 'COMPOSITE_AND', 'COMPOSITE_OR', 'COMPOSITE_XOR', 'CXSmilesFields', 'CanonSmiles', 'CartesianProductStrategy', 'ChemicalReaction', 'ChiralType', 'CompositeQueryType', 'ComputeMolShape', 'ComputeMolVolume', 'ComputedProps', 'Conformer', 'ConstrainedDepictionParams', 'ConstrainedEmbed', 'CoordsAsDouble', 'DataStructs', 'DoubleCubicLatticeVolume', 'ETK_MINIMIZATION', 'EXPLICIT', 'EditableMol', 'EmbedFailureCauses', 'EmbedParameters', 'EnumerateLibrary', 'EnumerateLibraryBase', 'EnumerateLibraryFromReaction', 'EnumerateStereoisomers', 'EnumerationParams', 'EnumerationStrategyBase', 'EnumeratorType', 'EvenSamplePairsStrategy', 'FINAL_CENTER_IN_VOLUME', 'FINAL_CHIRAL_BOUNDS', 'FIRST_MINIMIZATION', 'FPType', 'FindMolChiralCenters', 'FingerprintGenerator32', 'FingerprintGenerator64', 'FingerprintOptions', 'FingerprintType', 'FixedMolSizeMolBundle', 'ForceField', 'ForwardSDMolSupplier', 'FreeChemicalFeature', 'GetConformerRMS', 'GetConformerRMSMatrix', 'HybridizationType', 'IMPLICIT', 'INCHI_AVAILABLE', 'INITIAL_COORDS', 'InchiReadWriteError', 'InchiToInchiKey', 'JSONParseParameters', 'JSONWriteParameters', 'KEKULE_ALL', 'KekulizeException', 'LINEAR_DOUBLE_BOND', 'LayeredFingerprint_substructLayers', 'MCFF_GetFeaturesForMol', 'MINIMIZE_FOURTH_DIMENSION', 'MOL_SPTR_VECT', 'MaeMolSupplier', 'MaeWriter', 'Mol', 'MolBlockToInchi', 'MolBlockToInchiAndAuxInfo', 'MolBundle', 'MolChemicalFeature', 'MolChemicalFeatureFactory', 'MolEnumeratorParams', 'MolFromInchi', 'MolProps', 'MolSanitizeException', 'MolToInchi', 'MolToInchiAndAuxInfo', 'MolToInchiKey', 'MolWriterParams', 'MolzipLabel', 'MolzipParams', 'MorganFP', 'MorganFingerprintOptions', 'MultithreadedSDMolSupplier', 'MultithreadedSmilesMolSupplier', 'NoConformers', 'NoProps', 'NumRotatableBondsOptions', 'O3A', 'PDBWriter', 'PeriodicTable', 'PrivateProps', 'Properties', 'PropertyFunctor', 'PropertyPickleOptions', 'PropertyRangeQuery', 'PythonPropertyFunctor', 'QueryAtom', 'QueryAtomData', 'QueryBond', 'QuickSmartsMatch', 'RDConfig', 'RDKitFP', 'RDKitFingerprintOptions', 'RWMol', 'RandomSampleAllBBsStrategy', 'RandomSampleStrategy', 'ReactionFingerprintParams', 'RemoveHsParameters', 'ResonanceFlags', 'ResonanceMolSupplier', 'ResonanceMolSupplierCallback', 'RestoreBondDirOption', 'RingInfo', 'SANITIZE_ADJUSTHS', 'SANITIZE_ADJUST_REACTANTS', 'SANITIZE_ALL', 'SANITIZE_ATOM_MAPS', 'SANITIZE_CLEANUP', 'SANITIZE_CLEANUPATROPISOMERS', 'SANITIZE_CLEANUPCHIRALITY', 'SANITIZE_CLEANUP_ORGANOMETALLICS', 'SANITIZE_FINDRADICALS', 'SANITIZE_KEKULIZE', 'SANITIZE_MERGEHS', 'SANITIZE_NONE', 'SANITIZE_PROPERTIES', 'SANITIZE_RGROUP_NAMES', 'SANITIZE_SETAROMATICITY', 'SANITIZE_SETCONJUGATION', 'SANITIZE_SETHYBRIDIZATION', 'SANITIZE_SYMMRINGS', 'SDMolSupplier', 'SDWriter', 'STEREO_ABSOLUTE', 'STEREO_AND', 'STEREO_OR', 'SanitizeFlags', 'SmartsParserParams', 'SmilesMolSupplier', 'SmilesParserParams', 'SmilesWriteParams', 'SmilesWriter', 'StereoBondThresholds', 'StereoDescriptor', 'StereoEnumerationOptions', 'StereoGroup', 'StereoGroupAbsOptions', 'StereoGroupType', 'StereoGroup_vect', 'StereoInfo', 'StereoSpecified', 'StereoType', 'SubstanceGroup', 'SubstanceGroupAttach', 'SubstanceGroupCState', 'SubstanceGroup_VECT', 'SubstructMatchParameters', 'SupplierFromFilename', 'TDTMolSupplier', 'TDTWriter', 'TopologicalTorsionFP', 'TopologicalTorsionFingerprintOptions', 'TransformMol', 'UNCONSTRAINED_ANIONS', 'UNCONSTRAINED_CATIONS', 'UsingCoordGen', 'ValenceType', 'VectMolVect', 'inchi', 'logger', 'namedtuple', 'numpy', 'rdBase', 'rdCIPLabeler', 'rdCoordGen', 'rdGeometry', 'rdMolInterchange', 'rdchem', 'rdinchi', 'rdmolfiles', 'rdmolops', 'sys', 'templDir', 'warnings']
def AssignBondOrdersFromTemplate(refmol, mol):
    """
     assigns bond orders to a molecule based on the
        bond orders in a template molecule
    
        Arguments
          - refmol: the template molecule
          - mol: the molecule to assign bond orders to
    
        An example, start by generating a template from a SMILES
        and read in the PDB structure of the molecule
    
        >>> import os
        >>> from rdkit.Chem import AllChem
        >>> template = AllChem.MolFromSmiles("CN1C(=NC(C1=O)(c2ccccc2)c3ccccc3)N")
        >>> mol = AllChem.MolFromPDBFile(os.path.join(RDConfig.RDCodeDir, 'Chem', 'test_data', '4DJU_lig.pdb'))
        >>> len([1 for b in template.GetBonds() if b.GetBondTypeAsDouble() == 1.0])
        8
        >>> len([1 for b in mol.GetBonds() if b.GetBondTypeAsDouble() == 1.0])
        22
    
        Now assign the bond orders based on the template molecule
    
        >>> newMol = AllChem.AssignBondOrdersFromTemplate(template, mol)
        >>> len([1 for b in newMol.GetBonds() if b.GetBondTypeAsDouble() == 1.0])
        8
    
        Note that the template molecule should have no explicit hydrogens
        else the algorithm will fail.
    
        It also works if there are different formal charges (this was github issue 235):
    
        >>> template=AllChem.MolFromSmiles('CN(C)C(=O)Cc1ccc2c(c1)NC(=O)c3ccc(cc3N2)c4ccc(c(c4)OC)[N+](=O)[O-]')
        >>> mol = AllChem.MolFromMolFile(os.path.join(RDConfig.RDCodeDir, 'Chem', 'test_data', '4FTR_lig.mol'))
        >>> AllChem.MolToSmiles(mol)
        'COC1CC(C2CCC3C(O)NC4CC(CC(O)N(C)C)CCC4NC3C2)CCC1N(O)O'
        >>> newMol = AllChem.AssignBondOrdersFromTemplate(template, mol)
        >>> AllChem.MolToSmiles(newMol)
        'COc1cc(-c2ccc3c(c2)Nc2ccc(CC(=O)N(C)C)cc2NC3=O)ccc1[N+](=O)[O-]'
    
        
    """
def ComputeMolShape(mol, confId = -1, boxDim = (20, 20, 20), spacing = 0.5, **kwargs):
    """
     returns a grid representation of the molecule's shape
    
      Arguments:
        - mol: the molecule
        - confId: (optional) the conformer id to use
        - boxDim: (optional) the dimensions of the box to use
        - spacing: (optional) the spacing to use
        - kwargs: additional arguments to pass to the encoding function
    
      Returns:
        a UniformGrid3D object
      
    """
def ComputeMolVolume(mol, confId = -1, gridSpacing = 0.2, boxMargin = 2.0):
    """
     Calculates the volume of a particular conformer of a molecule
        based on a grid-encoding of the molecular shape.
    
    
      Arguments:
        - mol: the molecule
        - confId: (optional) the conformer id to use
        - gridSpacing: (optional) the spacing to use 
        - boxMargin: (optional) the margin to use around the molecule
    
        A bit of demo as well as a test of github #1883:
    
        >>> from rdkit import Chem
        >>> from rdkit.Chem import AllChem
        >>> mol = Chem.AddHs(Chem.MolFromSmiles('C'))
        >>> AllChem.EmbedMolecule(mol)
        0
        >>> ComputeMolVolume(mol)
        28...
        >>> mol = Chem.AddHs(Chem.MolFromSmiles('O'))
        >>> AllChem.EmbedMolecule(mol)
        0
        >>> ComputeMolVolume(mol)
        20...
    
        
    """
def ConstrainedEmbed(mol, core, useTethers = True, coreConfId = -1, randomseed = 2342, getForceField = ..., **kwargs):
    """
     generates an embedding of a molecule where part of the molecule
        is constrained to have particular coordinates
    
        Arguments
          - mol: the molecule to embed
          - core: the molecule to use as a source of constraints
          - useTethers: (optional) if True, the final conformation will be
              optimized subject to a series of extra forces that pull the
              matching atoms to the positions of the core atoms. Otherwise
              simple distance constraints based on the core atoms will be
              used in the optimization.
          - coreConfId: (optional) id of the core conformation to use
          - randomSeed: (optional) seed for the random number generator
          - getForceField: (optional) a function to use to get a force field
              for the final cleanup
          - kwargs: additional arguments to pass to the embedding function
    
        An example, start by generating a template with a 3D structure:
    
        >>> from rdkit.Chem import AllChem
        >>> template = AllChem.MolFromSmiles("c1nn(Cc2ccccc2)cc1")
        >>> AllChem.EmbedMolecule(template)
        0
        >>> AllChem.UFFOptimizeMolecule(template)
        0
    
        Here's a molecule:
    
        >>> mol = AllChem.MolFromSmiles("c1nn(Cc2ccccc2)cc1-c3ccccc3")
    
        Now do the constrained embedding
      
        >>> mol = AllChem.ConstrainedEmbed(mol, template)
    
        Demonstrate that the positions are nearly the same with template:
    
        >>> import math
        >>> molp = mol.GetConformer().GetAtomPosition(0)
        >>> templatep = template.GetConformer().GetAtomPosition(0)
        >>> all(math.isclose(v, 0.0, abs_tol=0.01) for v in molp-templatep)
        True
        >>> molp = mol.GetConformer().GetAtomPosition(1)
        >>> templatep = template.GetConformer().GetAtomPosition(1)
        >>> all(math.isclose(v, 0.0, abs_tol=0.01) for v in molp-templatep)
        True
    
        
    """
def EnumerateLibraryFromReaction(reaction, sidechainSets, returnReactants = False):
    """
     Returns a generator for the virtual library defined by
        a reaction and a sequence of sidechain sets
    
        Arguments:
          - reaction: the reaction
          - sidechainSets: a sequence of sequences of sidechains
          - returnReactants: (optional) if True, the generator will return information about the reactants
                             as well as the products
    
        >>> from rdkit import Chem
        >>> from rdkit.Chem import AllChem
        >>> s1=[Chem.MolFromSmiles(x) for x in ('NC','NCC')]
        >>> s2=[Chem.MolFromSmiles(x) for x in ('OC=O','OC(=O)C')]
        >>> rxn = AllChem.ReactionFromSmarts('[O:2]=[C:1][OH].[N:3]>>[O:2]=[C:1][N:3]')
        >>> r = AllChem.EnumerateLibraryFromReaction(rxn,[s2,s1])
        >>> [Chem.MolToSmiles(x[0]) for x in list(r)]
        ['CNC=O', 'CCNC=O', 'CNC(C)=O', 'CCNC(C)=O']
    
        Note that this is all done in a lazy manner, so "infinitely" large libraries can
        be done without worrying about running out of memory. Your patience will run out first:
    
        Define a set of 10000 amines:
    
        >>> amines = (Chem.MolFromSmiles('N'+'C'*x) for x in range(10000))
    
        ... a set of 10000 acids
    
        >>> acids = (Chem.MolFromSmiles('OC(=O)'+'C'*x) for x in range(10000))
    
        ... now the virtual library (1e8 compounds in principle):
    
        >>> r = AllChem.EnumerateLibraryFromReaction(rxn,[acids,amines])
    
        ... look at the first 4 compounds:
    
        >>> [Chem.MolToSmiles(next(r)[0]) for x in range(4)]
        ['NC=O', 'CNC=O', 'CCNC=O', 'CCCNC=O']
    
        Here's what returnReactants does:
    
        >>> l = list(AllChem.EnumerateLibraryFromReaction(rxn,[s2,s1],returnReactants=True))
        >>> type(l[0])
        <class 'rdkit.Chem.AllChem.ProductReactants'>
        >>> [Chem.MolToSmiles(x) for x in l[0].reactants]
        ['O=CO', 'CN']
        >>> [Chem.MolToSmiles(x) for x in l[0].products]
        ['CNC=O']
    
        
    """
def GetConformerRMS(mol, confId1, confId2, atomIds = None, prealigned = False):
    """
     Returns the RMS between two conformations.
        By default, the conformers will be aligned to the first conformer
        before the RMS calculation and, as a side-effect, the second will be left
        in the aligned state.
    
        Arguments:
          - mol:        the molecule
          - confId1:    the id of the first conformer
          - confId2:    the id of the second conformer
          - atomIds:    (optional) list of atom ids to use a points for
                        alingment - defaults to all atoms
          - prealigned: (optional) by default the conformers are assumed
                        be unaligned and the second conformer be aligned
                        to the first
    
        
    """
def GetConformerRMSMatrix(mol, atomIds = None, prealigned = False):
    """
     Returns the RMS matrix of the conformers of a molecule.
        As a side-effect, the conformers will be aligned to the first
        conformer (i.e. the reference) and will left in the aligned state.
    
        Arguments:
          - mol:     the molecule
          - atomIds: (optional) list of atom ids to use a points for
                     alingment - defaults to all atoms
          - prealigned: (optional) by default the conformers are assumed
                        be unaligned and will therefore be aligned to the
                        first conformer
    
        Note that the returned RMS matrix is symmetrical, i.e. it is the
        lower half of the matrix, e.g. for 5 conformers::
    
          rmsmatrix = [ a,
                        b, c,
                        d, e, f,
                        g, h, i, j]
    
        where a is the RMS between conformers 0 and 1, b is the RMS between
        conformers 0 and 2, etc.
        This way it can be directly used as distance matrix in e.g. Butina
        clustering.
    
        
    """
def TransformMol(mol, tform, confId = -1, keepConfs = False):
    """
      Applies the transformation (usually a 4x4 double matrix) to a molecule
        
      Arguments:
        - mol: the molecule to be transformed
        - tform: the transformation to apply
        - confId: (optional) the conformer id to transform
        - keepConfs: (optional) if keepConfs is False then all but that conformer are removed
      
      
    """
ADJUST_IGNOREALL: rdkit.Chem.rdmolops.AdjustQueryWhichFlags  # value = rdkit.Chem.rdmolops.AdjustQueryWhichFlags.ADJUST_IGNOREALL
ADJUST_IGNORECHAINS: rdkit.Chem.rdmolops.AdjustQueryWhichFlags  # value = rdkit.Chem.rdmolops.AdjustQueryWhichFlags.ADJUST_IGNORECHAINS
ADJUST_IGNOREDUMMIES: rdkit.Chem.rdmolops.AdjustQueryWhichFlags  # value = rdkit.Chem.rdmolops.AdjustQueryWhichFlags.ADJUST_IGNOREDUMMIES
ADJUST_IGNOREMAPPED: rdkit.Chem.rdmolops.AdjustQueryWhichFlags  # value = rdkit.Chem.rdmolops.AdjustQueryWhichFlags.ADJUST_IGNOREMAPPED
ADJUST_IGNORENONDUMMIES: rdkit.Chem.rdmolops.AdjustQueryWhichFlags  # value = rdkit.Chem.rdmolops.AdjustQueryWhichFlags.ADJUST_IGNORENONDUMMIES
ADJUST_IGNORENONE: rdkit.Chem.rdmolops.AdjustQueryWhichFlags  # value = rdkit.Chem.rdmolops.AdjustQueryWhichFlags.ADJUST_IGNORENONE
ADJUST_IGNORERINGS: rdkit.Chem.rdmolops.AdjustQueryWhichFlags  # value = rdkit.Chem.rdmolops.AdjustQueryWhichFlags.ADJUST_IGNORERINGS
ALLOW_CHARGE_SEPARATION: rdkit.Chem.rdchem.ResonanceFlags  # value = rdkit.Chem.rdchem.ResonanceFlags.ALLOW_CHARGE_SEPARATION
ALLOW_INCOMPLETE_OCTETS: rdkit.Chem.rdchem.ResonanceFlags  # value = rdkit.Chem.rdchem.ResonanceFlags.ALLOW_INCOMPLETE_OCTETS
AROMATICITY_CUSTOM: rdkit.Chem.rdmolops.AromaticityModel  # value = rdkit.Chem.rdmolops.AromaticityModel.AROMATICITY_CUSTOM
AROMATICITY_DEFAULT: rdkit.Chem.rdmolops.AromaticityModel  # value = rdkit.Chem.rdmolops.AromaticityModel.AROMATICITY_DEFAULT
AROMATICITY_MDL: rdkit.Chem.rdmolops.AromaticityModel  # value = rdkit.Chem.rdmolops.AromaticityModel.AROMATICITY_MDL
AROMATICITY_MMFF94: rdkit.Chem.rdmolops.AromaticityModel  # value = rdkit.Chem.rdmolops.AromaticityModel.AROMATICITY_MMFF94
AROMATICITY_RDKIT: rdkit.Chem.rdmolops.AromaticityModel  # value = rdkit.Chem.rdmolops.AromaticityModel.AROMATICITY_RDKIT
AROMATICITY_SIMPLE: rdkit.Chem.rdmolops.AromaticityModel  # value = rdkit.Chem.rdmolops.AromaticityModel.AROMATICITY_SIMPLE
AllProps: rdkit.Chem.rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.AllProps
AtomPairFP: rdkit.Chem.rdFingerprintGenerator.FPType  # value = rdkit.Chem.rdFingerprintGenerator.FPType.AtomPairFP
AtomProps: rdkit.Chem.rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.AtomProps
BAD_DOUBLE_BOND_STEREO: rdkit.Chem.rdDistGeom.EmbedFailureCauses  # value = rdkit.Chem.rdDistGeom.EmbedFailureCauses.BAD_DOUBLE_BOND_STEREO
BondProps: rdkit.Chem.rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.BondProps
CHECK_CHIRAL_CENTERS: rdkit.Chem.rdDistGeom.EmbedFailureCauses  # value = rdkit.Chem.rdDistGeom.EmbedFailureCauses.CHECK_CHIRAL_CENTERS
CHECK_CHIRAL_CENTERS2: rdkit.Chem.rdDistGeom.EmbedFailureCauses  # value = rdkit.Chem.rdDistGeom.EmbedFailureCauses.CHECK_CHIRAL_CENTERS2
CHECK_TETRAHEDRAL_CENTERS: rdkit.Chem.rdDistGeom.EmbedFailureCauses  # value = rdkit.Chem.rdDistGeom.EmbedFailureCauses.CHECK_TETRAHEDRAL_CENTERS
CHI_ALLENE: rdkit.Chem.rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_ALLENE
CHI_OCTAHEDRAL: rdkit.Chem.rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_OCTAHEDRAL
CHI_OTHER: rdkit.Chem.rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_OTHER
CHI_SQUAREPLANAR: rdkit.Chem.rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_SQUAREPLANAR
CHI_TETRAHEDRAL: rdkit.Chem.rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_TETRAHEDRAL
CHI_TETRAHEDRAL_CCW: rdkit.Chem.rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_TETRAHEDRAL_CCW
CHI_TETRAHEDRAL_CW: rdkit.Chem.rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_TETRAHEDRAL_CW
CHI_TRIGONALBIPYRAMIDAL: rdkit.Chem.rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_TRIGONALBIPYRAMIDAL
CHI_UNSPECIFIED: rdkit.Chem.rdchem.ChiralType  # value = rdkit.Chem.rdchem.ChiralType.CHI_UNSPECIFIED
COMPOSITE_AND: rdkit.Chem.rdchem.CompositeQueryType  # value = rdkit.Chem.rdchem.CompositeQueryType.COMPOSITE_AND
COMPOSITE_OR: rdkit.Chem.rdchem.CompositeQueryType  # value = rdkit.Chem.rdchem.CompositeQueryType.COMPOSITE_OR
COMPOSITE_XOR: rdkit.Chem.rdchem.CompositeQueryType  # value = rdkit.Chem.rdchem.CompositeQueryType.COMPOSITE_XOR
ComputedProps: rdkit.Chem.rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.ComputedProps
CoordsAsDouble: rdkit.Chem.rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.CoordsAsDouble
ETK_MINIMIZATION: rdkit.Chem.rdDistGeom.EmbedFailureCauses  # value = rdkit.Chem.rdDistGeom.EmbedFailureCauses.ETK_MINIMIZATION
EXPLICIT: rdkit.Chem.rdchem.ValenceType  # value = rdkit.Chem.rdchem.ValenceType.EXPLICIT
FINAL_CENTER_IN_VOLUME: rdkit.Chem.rdDistGeom.EmbedFailureCauses  # value = rdkit.Chem.rdDistGeom.EmbedFailureCauses.FINAL_CENTER_IN_VOLUME
FINAL_CHIRAL_BOUNDS: rdkit.Chem.rdDistGeom.EmbedFailureCauses  # value = rdkit.Chem.rdDistGeom.EmbedFailureCauses.FINAL_CHIRAL_BOUNDS
FIRST_MINIMIZATION: rdkit.Chem.rdDistGeom.EmbedFailureCauses  # value = rdkit.Chem.rdDistGeom.EmbedFailureCauses.FIRST_MINIMIZATION
IMPLICIT: rdkit.Chem.rdchem.ValenceType  # value = rdkit.Chem.rdchem.ValenceType.IMPLICIT
INCHI_AVAILABLE: bool = True
INITIAL_COORDS: rdkit.Chem.rdDistGeom.EmbedFailureCauses  # value = rdkit.Chem.rdDistGeom.EmbedFailureCauses.INITIAL_COORDS
KEKULE_ALL: rdkit.Chem.rdchem.ResonanceFlags  # value = rdkit.Chem.rdchem.ResonanceFlags.KEKULE_ALL
LINEAR_DOUBLE_BOND: rdkit.Chem.rdDistGeom.EmbedFailureCauses  # value = rdkit.Chem.rdDistGeom.EmbedFailureCauses.LINEAR_DOUBLE_BOND
LayeredFingerprint_substructLayers: int = 7
MINIMIZE_FOURTH_DIMENSION: rdkit.Chem.rdDistGeom.EmbedFailureCauses  # value = rdkit.Chem.rdDistGeom.EmbedFailureCauses.MINIMIZE_FOURTH_DIMENSION
MolProps: rdkit.Chem.rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.MolProps
MorganFP: rdkit.Chem.rdFingerprintGenerator.FPType  # value = rdkit.Chem.rdFingerprintGenerator.FPType.MorganFP
NoConformers: rdkit.Chem.rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.NoConformers
NoProps: rdkit.Chem.rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.NoProps
PrivateProps: rdkit.Chem.rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.PrivateProps
QueryAtomData: rdkit.Chem.rdchem.PropertyPickleOptions  # value = rdkit.Chem.rdchem.PropertyPickleOptions.QueryAtomData
RDKitFP: rdkit.Chem.rdFingerprintGenerator.FPType  # value = rdkit.Chem.rdFingerprintGenerator.FPType.RDKitFP
SANITIZE_ADJUSTHS: rdkit.Chem.rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_ADJUSTHS
SANITIZE_ADJUST_REACTANTS: rdkit.Chem.rdChemReactions.SanitizeFlags  # value = rdkit.Chem.rdChemReactions.SanitizeFlags.SANITIZE_ADJUST_REACTANTS
SANITIZE_ALL: rdkit.Chem.rdChemReactions.SanitizeFlags  # value = rdkit.Chem.rdChemReactions.SanitizeFlags.SANITIZE_ALL
SANITIZE_ATOM_MAPS: rdkit.Chem.rdChemReactions.SanitizeFlags  # value = rdkit.Chem.rdChemReactions.SanitizeFlags.SANITIZE_ATOM_MAPS
SANITIZE_CLEANUP: rdkit.Chem.rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_CLEANUP
SANITIZE_CLEANUPATROPISOMERS: rdkit.Chem.rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_CLEANUPATROPISOMERS
SANITIZE_CLEANUPCHIRALITY: rdkit.Chem.rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_CLEANUPCHIRALITY
SANITIZE_CLEANUP_ORGANOMETALLICS: rdkit.Chem.rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_CLEANUP_ORGANOMETALLICS
SANITIZE_FINDRADICALS: rdkit.Chem.rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_FINDRADICALS
SANITIZE_KEKULIZE: rdkit.Chem.rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_KEKULIZE
SANITIZE_MERGEHS: rdkit.Chem.rdChemReactions.SanitizeFlags  # value = rdkit.Chem.rdChemReactions.SanitizeFlags.SANITIZE_MERGEHS
SANITIZE_NONE: rdkit.Chem.rdChemReactions.SanitizeFlags  # value = rdkit.Chem.rdChemReactions.SanitizeFlags.SANITIZE_NONE
SANITIZE_PROPERTIES: rdkit.Chem.rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_PROPERTIES
SANITIZE_RGROUP_NAMES: rdkit.Chem.rdChemReactions.SanitizeFlags  # value = rdkit.Chem.rdChemReactions.SanitizeFlags.SANITIZE_RGROUP_NAMES
SANITIZE_SETAROMATICITY: rdkit.Chem.rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_SETAROMATICITY
SANITIZE_SETCONJUGATION: rdkit.Chem.rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_SETCONJUGATION
SANITIZE_SETHYBRIDIZATION: rdkit.Chem.rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_SETHYBRIDIZATION
SANITIZE_SYMMRINGS: rdkit.Chem.rdmolops.SanitizeFlags  # value = rdkit.Chem.rdmolops.SanitizeFlags.SANITIZE_SYMMRINGS
STEREO_ABSOLUTE: rdkit.Chem.rdchem.StereoGroupType  # value = rdkit.Chem.rdchem.StereoGroupType.STEREO_ABSOLUTE
STEREO_AND: rdkit.Chem.rdchem.StereoGroupType  # value = rdkit.Chem.rdchem.StereoGroupType.STEREO_AND
STEREO_OR: rdkit.Chem.rdchem.StereoGroupType  # value = rdkit.Chem.rdchem.StereoGroupType.STEREO_OR
TopologicalTorsionFP: rdkit.Chem.rdFingerprintGenerator.FPType  # value = rdkit.Chem.rdFingerprintGenerator.FPType.TopologicalTorsionFP
UNCONSTRAINED_ANIONS: rdkit.Chem.rdchem.ResonanceFlags  # value = rdkit.Chem.rdchem.ResonanceFlags.UNCONSTRAINED_ANIONS
UNCONSTRAINED_CATIONS: rdkit.Chem.rdchem.ResonanceFlags  # value = rdkit.Chem.rdchem.ResonanceFlags.UNCONSTRAINED_CATIONS
logger: rdkit.RDLogger.logger  # value = <rdkit.RDLogger.logger object>
templDir: str = '/Users/runner/work/rdkit-pypi/rdkit-pypi/build/temp.macosx-11.0-arm64-cpython-39/rdkit_install/share/RDKit/Data/'
