# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/bigQueryConnection.json
#   timestamp: 2022-04-13T14:46:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from .. import connectionBasicType


class BigqueryType(Enum):
    BigQuery = 'BigQuery'


class BigqueryScheme(Enum):
    bigquery = 'bigquery'


class BigQueryConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[BigqueryType] = Field(
        BigqueryType.BigQuery, description='Service Type'
    )
    scheme: Optional[BigqueryScheme] = Field(
        BigqueryScheme.bigquery, description='SQLAlchemy driver scheme options.'
    )
    hostPort: Optional[str] = Field(
        'bigquery.googleapis.com', description='BigQuery APIs URL'
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the Athena. This user should have privileges to read all the metadata in Athena.',
    )
    projectID: Optional[str] = Field(None, description='Google BigQuery project id.')
    enablePolicyTagImport: Optional[bool] = Field(
        True, description='Enable importing policy tags of BigQuery into OpenMetadata'
    )
    tagCategoryName: Optional[str] = Field(
        'BigqueryPolicyTags',
        description='OpenMetadata Tag category name if enablePolicyTagImport is set to true.',
    )
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in Athena.',
    )
    partitionQueryDuration: Optional[int] = Field(
        1, description='Duration for partitioning bigquery tables'
    )
    partitionQuery: Optional[str] = Field(
        'select * from {}.{} WHERE {} = "{}" LIMIT 1000',
        description='Partitioning query for bigquery tables',
    )
    partitionField: Optional[str] = Field(
        '_PARTITIONTIME',
        description='Column name on which bigquery table will be partitioned',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
    supportsUsageExtraction: Optional[
        connectionBasicType.SupportsUsageExtraction
    ] = None
