# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from .. import core
from ..types.optimize_streaming_latency import OptimizeStreamingLatency
from ..types.output_format import OutputFormat
from ..core.request_options import RequestOptions
from ..core.jsonable_encoder import jsonable_encoder
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..core.unchecked_base_model import construct_type
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SpeechToSpeechClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def convert(
        self,
        voice_id: str,
        *,
        audio: core.File,
        enable_logging: typing.Optional[bool] = None,
        optimize_streaming_latency: typing.Optional[OptimizeStreamingLatency] = None,
        output_format: typing.Optional[OutputFormat] = None,
        model_id: typing.Optional[str] = None,
        voice_settings: typing.Optional[str] = None,
        seed: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[bytes]:
        """
        Create speech by combining the content and emotion of the uploaded audio with a voice of your choice.

        Parameters
        ----------
        voice_id : str
            Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.

        audio : core.File
            See core.File for more documentation

        enable_logging : typing.Optional[bool]
            When enable_logging is set to false full privacy mode will be used for the request. This will mean history features are unavailable for this request, including request stitching. Full privacy mode may only be used by enterprise customers.

        optimize_streaming_latency : typing.Optional[OptimizeStreamingLatency]
            You can turn on latency optimizations at some cost of quality. The best possible final latency varies by model.

        output_format : typing.Optional[OutputFormat]
            The output format of the generated audio.

        model_id : typing.Optional[str]
            Identifier of the model that will be used, you can query them using GET /v1/models. The model needs to have support for speech to speech, you can check this using the can_do_voice_conversion property.

        voice_settings : typing.Optional[str]
            Voice settings overriding stored setttings for the given voice. They are applied only on the given request. Needs to be send as a JSON encoded string.

        seed : typing.Optional[int]
            If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism is not guaranteed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[bytes]
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.speech_to_speech.convert(
            voice_id="string",
            enable_logging=True,
            optimize_streaming_latency="0",
            output_format="mp3_22050_32",
        )
        """
        with self._client_wrapper.httpx_client.stream(
            f"v1/speech-to-speech/{jsonable_encoder(voice_id)}",
            method="POST",
            params={
                "enable_logging": enable_logging,
                "optimize_streaming_latency": optimize_streaming_latency,
                "output_format": output_format,
            },
            data={
                "model_id": model_id,
                "voice_settings": voice_settings,
                "seed": seed,
            },
            files={
                "audio": audio,
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:
            try:
                if 200 <= _response.status_code < 300:
                    for _chunk in _response.iter_bytes():
                        yield _chunk
                    return
                _response.read()
                if _response.status_code == 422:
                    raise UnprocessableEntityError(
                        typing.cast(
                            HttpValidationError,
                            construct_type(
                                type_=HttpValidationError,  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    def convert_as_stream(
        self,
        voice_id: str,
        *,
        audio: core.File,
        enable_logging: typing.Optional[OptimizeStreamingLatency] = None,
        optimize_streaming_latency: typing.Optional[OutputFormat] = None,
        output_format: typing.Optional[str] = None,
        model_id: typing.Optional[str] = None,
        voice_settings: typing.Optional[str] = None,
        seed: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[bytes]:
        """
        Create speech by combining the content and emotion of the uploaded audio with a voice of your choice and returns an audio stream.

        Parameters
        ----------
        voice_id : str
            Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.

        audio : core.File
            See core.File for more documentation

        enable_logging : typing.Optional[OptimizeStreamingLatency]
            You can turn on latency optimizations at some cost of quality. The best possible final latency varies by model.

        optimize_streaming_latency : typing.Optional[OutputFormat]
            The output format of the generated audio.

        output_format : typing.Optional[str]
            Output format of the generated audio. Must be one of:
            mp3_22050_32 - output format, mp3 with 22.05kHz sample rate at 32kbps.
            mp3_44100_32 - output format, mp3 with 44.1kHz sample rate at 32kbps.
            mp3_44100_64 - output format, mp3 with 44.1kHz sample rate at 64kbps.
            mp3_44100_96 - output format, mp3 with 44.1kHz sample rate at 96kbps.
            mp3_44100_128 - default output format, mp3 with 44.1kHz sample rate at 128kbps.
            mp3_44100_192 - output format, mp3 with 44.1kHz sample rate at 192kbps. Requires you to be subscribed to Creator tier or above.
            pcm_16000 - PCM format (S16LE) with 16kHz sample rate.
            pcm_22050 - PCM format (S16LE) with 22.05kHz sample rate.
            pcm_24000 - PCM format (S16LE) with 24kHz sample rate.
            pcm_44100 - PCM format (S16LE) with 44.1kHz sample rate. Requires you to be subscribed to Pro tier or above.
            ulaw_8000 - μ-law format (sometimes written mu-law, often approximated as u-law) with 8kHz sample rate. Note that this format is commonly used for Twilio audio inputs.

        model_id : typing.Optional[str]
            Identifier of the model that will be used, you can query them using GET /v1/models. The model needs to have support for speech to speech, you can check this using the can_do_voice_conversion property.

        voice_settings : typing.Optional[str]
            Voice settings overriding stored setttings for the given voice. They are applied only on the given request. Needs to be send as a JSON encoded string.

        seed : typing.Optional[int]
            If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism is not guaranteed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[bytes]
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.speech_to_speech.convert_as_stream(
            voice_id="string",
            enable_logging="0",
            optimize_streaming_latency="mp3_22050_32",
            output_format="string",
        )
        """
        with self._client_wrapper.httpx_client.stream(
            f"v1/speech-to-speech/{jsonable_encoder(voice_id)}/stream",
            method="POST",
            params={
                "enable_logging": enable_logging,
                "optimize_streaming_latency": optimize_streaming_latency,
                "output_format": output_format,
            },
            data={
                "model_id": model_id,
                "voice_settings": voice_settings,
                "seed": seed,
            },
            files={
                "audio": audio,
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:
            try:
                if 200 <= _response.status_code < 300:
                    for _chunk in _response.iter_bytes():
                        yield _chunk
                    return
                _response.read()
                if _response.status_code == 422:
                    raise UnprocessableEntityError(
                        typing.cast(
                            HttpValidationError,
                            construct_type(
                                type_=HttpValidationError,  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncSpeechToSpeechClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def convert(
        self,
        voice_id: str,
        *,
        audio: core.File,
        enable_logging: typing.Optional[bool] = None,
        optimize_streaming_latency: typing.Optional[OptimizeStreamingLatency] = None,
        output_format: typing.Optional[OutputFormat] = None,
        model_id: typing.Optional[str] = None,
        voice_settings: typing.Optional[str] = None,
        seed: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[bytes]:
        """
        Create speech by combining the content and emotion of the uploaded audio with a voice of your choice.

        Parameters
        ----------
        voice_id : str
            Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.

        audio : core.File
            See core.File for more documentation

        enable_logging : typing.Optional[bool]
            When enable_logging is set to false full privacy mode will be used for the request. This will mean history features are unavailable for this request, including request stitching. Full privacy mode may only be used by enterprise customers.

        optimize_streaming_latency : typing.Optional[OptimizeStreamingLatency]
            You can turn on latency optimizations at some cost of quality. The best possible final latency varies by model.

        output_format : typing.Optional[OutputFormat]
            The output format of the generated audio.

        model_id : typing.Optional[str]
            Identifier of the model that will be used, you can query them using GET /v1/models. The model needs to have support for speech to speech, you can check this using the can_do_voice_conversion property.

        voice_settings : typing.Optional[str]
            Voice settings overriding stored setttings for the given voice. They are applied only on the given request. Needs to be send as a JSON encoded string.

        seed : typing.Optional[int]
            If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism is not guaranteed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[bytes]
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.speech_to_speech.convert(
                voice_id="string",
                enable_logging=True,
                optimize_streaming_latency="0",
                output_format="mp3_22050_32",
            )


        asyncio.run(main())
        """
        async with self._client_wrapper.httpx_client.stream(
            f"v1/speech-to-speech/{jsonable_encoder(voice_id)}",
            method="POST",
            params={
                "enable_logging": enable_logging,
                "optimize_streaming_latency": optimize_streaming_latency,
                "output_format": output_format,
            },
            data={
                "model_id": model_id,
                "voice_settings": voice_settings,
                "seed": seed,
            },
            files={
                "audio": audio,
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:
            try:
                if 200 <= _response.status_code < 300:
                    async for _chunk in _response.aiter_bytes():
                        yield _chunk
                    return
                await _response.aread()
                if _response.status_code == 422:
                    raise UnprocessableEntityError(
                        typing.cast(
                            HttpValidationError,
                            construct_type(
                                type_=HttpValidationError,  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    async def convert_as_stream(
        self,
        voice_id: str,
        *,
        audio: core.File,
        enable_logging: typing.Optional[OptimizeStreamingLatency] = None,
        optimize_streaming_latency: typing.Optional[OutputFormat] = None,
        output_format: typing.Optional[str] = None,
        model_id: typing.Optional[str] = None,
        voice_settings: typing.Optional[str] = None,
        seed: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[bytes]:
        """
        Create speech by combining the content and emotion of the uploaded audio with a voice of your choice and returns an audio stream.

        Parameters
        ----------
        voice_id : str
            Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.

        audio : core.File
            See core.File for more documentation

        enable_logging : typing.Optional[OptimizeStreamingLatency]
            You can turn on latency optimizations at some cost of quality. The best possible final latency varies by model.

        optimize_streaming_latency : typing.Optional[OutputFormat]
            The output format of the generated audio.

        output_format : typing.Optional[str]
            Output format of the generated audio. Must be one of:
            mp3_22050_32 - output format, mp3 with 22.05kHz sample rate at 32kbps.
            mp3_44100_32 - output format, mp3 with 44.1kHz sample rate at 32kbps.
            mp3_44100_64 - output format, mp3 with 44.1kHz sample rate at 64kbps.
            mp3_44100_96 - output format, mp3 with 44.1kHz sample rate at 96kbps.
            mp3_44100_128 - default output format, mp3 with 44.1kHz sample rate at 128kbps.
            mp3_44100_192 - output format, mp3 with 44.1kHz sample rate at 192kbps. Requires you to be subscribed to Creator tier or above.
            pcm_16000 - PCM format (S16LE) with 16kHz sample rate.
            pcm_22050 - PCM format (S16LE) with 22.05kHz sample rate.
            pcm_24000 - PCM format (S16LE) with 24kHz sample rate.
            pcm_44100 - PCM format (S16LE) with 44.1kHz sample rate. Requires you to be subscribed to Pro tier or above.
            ulaw_8000 - μ-law format (sometimes written mu-law, often approximated as u-law) with 8kHz sample rate. Note that this format is commonly used for Twilio audio inputs.

        model_id : typing.Optional[str]
            Identifier of the model that will be used, you can query them using GET /v1/models. The model needs to have support for speech to speech, you can check this using the can_do_voice_conversion property.

        voice_settings : typing.Optional[str]
            Voice settings overriding stored setttings for the given voice. They are applied only on the given request. Needs to be send as a JSON encoded string.

        seed : typing.Optional[int]
            If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism is not guaranteed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[bytes]
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.speech_to_speech.convert_as_stream(
                voice_id="string",
                enable_logging="0",
                optimize_streaming_latency="mp3_22050_32",
                output_format="string",
            )


        asyncio.run(main())
        """
        async with self._client_wrapper.httpx_client.stream(
            f"v1/speech-to-speech/{jsonable_encoder(voice_id)}/stream",
            method="POST",
            params={
                "enable_logging": enable_logging,
                "optimize_streaming_latency": optimize_streaming_latency,
                "output_format": output_format,
            },
            data={
                "model_id": model_id,
                "voice_settings": voice_settings,
                "seed": seed,
            },
            files={
                "audio": audio,
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:
            try:
                if 200 <= _response.status_code < 300:
                    async for _chunk in _response.aiter_bytes():
                        yield _chunk
                    return
                await _response.aread()
                if _response.status_code == 422:
                    raise UnprocessableEntityError(
                        typing.cast(
                            HttpValidationError,
                            construct_type(
                                type_=HttpValidationError,  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)
