"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const codedeploy_generated_1 = require("../codedeploy.generated");
const utils_1 = require("../utils");
/**
 * A CodeDeploy Application that deploys to an AWS Lambda function.
 */
class LambdaApplication extends cdk.Construct {
    /**
     * Import an Application defined either outside the CDK,
     * or in a different CDK Stack and exported using the {@link ILambdaApplication#export} method.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param props the properties of the referenced Application
     * @returns a Construct representing a reference to an existing Application
     */
    static import(scope, id, props) {
        return new ImportedLambdaApplication(scope, id, props);
    }
    constructor(scope, id, props = {}) {
        super(scope, id);
        const resource = new codedeploy_generated_1.CfnApplication(this, 'Resource', {
            applicationName: props.applicationName,
            computePlatform: 'Lambda'
        });
        this.applicationName = resource.ref;
        this.applicationArn = utils_1.applicationNameToArn(this.applicationName, this);
    }
    export() {
        return {
            applicationName: new cdk.CfnOutput(this, 'ApplicationName', { value: this.applicationName }).makeImportValue().toString()
        };
    }
}
exports.LambdaApplication = LambdaApplication;
class ImportedLambdaApplication extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.applicationName = props.applicationName;
        this.applicationArn = utils_1.applicationNameToArn(props.applicationName, this);
    }
    export() {
        return this.props;
    }
}
//# sourceMappingURL=data:application/json;base64,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