"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const utils_1 = require("../utils");
class DefaultLambdaDeploymentConfig {
    constructor(deploymentConfigName) {
        this.deploymentConfigName = `CodeDeployDefault.Lambda${deploymentConfigName}`;
    }
    deploymentConfigArn(scope) {
        return utils_1.arnForDeploymentConfigName(this.deploymentConfigName, scope);
    }
}
class ImportedLambdaDeploymentConfig extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.deploymentConfigName = props.deploymentConfigName;
    }
    deploymentConfigArn(scope) {
        return utils_1.arnForDeploymentConfigName(this.deploymentConfigName, scope);
    }
    export() {
        return this.props;
    }
}
/**
 * A custom Deployment Configuration for a Lambda Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom Lambda Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 */
class LambdaDeploymentConfig {
    constructor() {
        // nothing to do until CFN supports custom lambda deployment configurations
    }
    /**
     * Import a custom Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param props the properties of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static import(scope, id, props) {
        return new ImportedLambdaDeploymentConfig(scope, id, props);
    }
}
LambdaDeploymentConfig.AllAtOnce = new DefaultLambdaDeploymentConfig('AllAtOnce');
LambdaDeploymentConfig.Canary10Percent30Minutes = new DefaultLambdaDeploymentConfig('Canary10Percent30Minutes');
LambdaDeploymentConfig.Canary10Percent5Minutes = new DefaultLambdaDeploymentConfig('Canary10Percent5Minutes');
LambdaDeploymentConfig.Canary10Percent10Minutes = new DefaultLambdaDeploymentConfig('Canary10Percent10Minutes');
LambdaDeploymentConfig.Canary10Percent15Minutes = new DefaultLambdaDeploymentConfig('Canary10Percent15Minutes');
LambdaDeploymentConfig.Linear10PercentEvery10Minutes = new DefaultLambdaDeploymentConfig('Linear10PercentEvery10Minutes');
LambdaDeploymentConfig.Linear10PercentEvery1Minute = new DefaultLambdaDeploymentConfig('Linear10PercentEvery1Minute');
LambdaDeploymentConfig.Linear10PercentEvery2Minutes = new DefaultLambdaDeploymentConfig('Linear10PercentEvery2Minutes');
LambdaDeploymentConfig.Linear10PercentEvery3Minutes = new DefaultLambdaDeploymentConfig('Linear10PercentEvery3Minutes');
exports.LambdaDeploymentConfig = LambdaDeploymentConfig;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVwbG95bWVudC1jb25maWcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJkZXBsb3ltZW50LWNvbmZpZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLG9DQUFxQztBQUNyQyxvQ0FBc0Q7QUFnQnRELE1BQU0sNkJBQTZCO0lBR2pDLFlBQVksb0JBQTRCO1FBQ3RDLElBQUksQ0FBQyxvQkFBb0IsR0FBRywyQkFBMkIsb0JBQW9CLEVBQUUsQ0FBQztJQUNoRixDQUFDO0lBRU0sbUJBQW1CLENBQUMsS0FBcUI7UUFDOUMsT0FBTyxrQ0FBMEIsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDdEUsQ0FBQztDQUNGO0FBZ0JELE1BQU0sOEJBQStCLFNBQVEsR0FBRyxDQUFDLFNBQVM7SUFHeEQsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBbUIsS0FBd0M7UUFDckcsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUQ0QyxVQUFLLEdBQUwsS0FBSyxDQUFtQztRQUdyRyxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLG9CQUFvQixDQUFDO0lBQ3pELENBQUM7SUFFTSxtQkFBbUIsQ0FBQyxLQUFxQjtRQUM5QyxPQUFPLGtDQUEwQixDQUFDLElBQUksQ0FBQyxvQkFBb0IsRUFBRSxLQUFLLENBQUMsQ0FBQztJQUN0RSxDQUFDO0lBRU0sTUFBTTtRQUNYLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0NBQ0Y7QUFFRDs7Ozs7O0dBTUc7QUFDSCxNQUFhLHNCQUFzQjtJQXVCakM7UUFDRSwyRUFBMkU7SUFDN0UsQ0FBQztJQWREOzs7Ozs7O09BT0c7SUFDSSxNQUFNLENBQUMsTUFBTSxDQUFDLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQXdDO1FBQzdGLE9BQU8sSUFBSSw4QkFBOEIsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO0lBQzlELENBQUM7O0FBcEJzQixnQ0FBUyxHQUE0QixJQUFJLDZCQUE2QixDQUFDLFdBQVcsQ0FBQyxDQUFDO0FBQ3BGLCtDQUF3QixHQUE0QixJQUFJLDZCQUE2QixDQUFDLDBCQUEwQixDQUFDLENBQUM7QUFDbEgsOENBQXVCLEdBQTRCLElBQUksNkJBQTZCLENBQUMseUJBQXlCLENBQUMsQ0FBQztBQUNoSCwrQ0FBd0IsR0FBNEIsSUFBSSw2QkFBNkIsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0FBQ2xILCtDQUF3QixHQUE0QixJQUFJLDZCQUE2QixDQUFDLDBCQUEwQixDQUFDLENBQUM7QUFDbEgsb0RBQTZCLEdBQTRCLElBQUksNkJBQTZCLENBQUMsK0JBQStCLENBQUMsQ0FBQztBQUM1SCxrREFBMkIsR0FBNEIsSUFBSSw2QkFBNkIsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO0FBQ3hILG1EQUE0QixHQUE0QixJQUFJLDZCQUE2QixDQUFDLDhCQUE4QixDQUFDLENBQUM7QUFDMUgsbURBQTRCLEdBQTRCLElBQUksNkJBQTZCLENBQUMsOEJBQThCLENBQUMsQ0FBQztBQVRuSix3REEwQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY2RrJyk7XG5pbXBvcnQgeyBhcm5Gb3JEZXBsb3ltZW50Q29uZmlnTmFtZSB9IGZyb20gJy4uL3V0aWxzJztcblxuLyoqXG4gKiBUaGUgRGVwbG95bWVudCBDb25maWd1cmF0aW9uIG9mIGEgTGFtYmRhIERlcGxveW1lbnQgR3JvdXAuXG4gKiBUaGUgZGVmYXVsdCwgcHJlLWRlZmluZWQgQ29uZmlndXJhdGlvbnMgYXJlIGF2YWlsYWJsZSBhcyBjb25zdGFudHMgb24gdGhlIHtAbGluayBMYW1iZGFEZXBsb3ltZW50Q29uZmlnfSBjbGFzc1xuICogKGBMYW1iZGFEZXBsb3ltZW50Q29uZmlnLkFsbEF0T25jZWAsIGBMYW1iZGFEZXBsb3ltZW50Q29uZmlnLkNhbmFyeTEwUGVyY2VudDMwTWludXRlc2AsIGV0Yy4pLlxuICpcbiAqIE5vdGU6IENsb3VkRm9ybWF0aW9uIGRvZXMgbm90IGN1cnJlbnRseSBzdXBwb3J0IGNyZWF0aW5nIGN1c3RvbSBsYW1iZGEgY29uZmlncyBvdXRzaWRlXG4gKiBvZiB1c2luZyBhIGN1c3RvbSByZXNvdXJjZS4gWW91IGNhbiBpbXBvcnQgY3VzdG9tIGRlcGxveW1lbnQgY29uZmlnIGNyZWF0ZWQgb3V0c2lkZSB0aGVcbiAqIENESyBvciB2aWEgYSBjdXN0b20gcmVzb3VyY2Ugd2l0aCB7QGxpbmsgTGFtYmRhRGVwbG95bWVudENvbmZpZyNpbXBvcnR9LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElMYW1iZGFEZXBsb3ltZW50Q29uZmlnIHtcbiAgcmVhZG9ubHkgZGVwbG95bWVudENvbmZpZ05hbWU6IHN0cmluZztcbiAgZGVwbG95bWVudENvbmZpZ0FybihzY29wZTogY2RrLklDb25zdHJ1Y3QpOiBzdHJpbmc7XG59XG5cbmNsYXNzIERlZmF1bHRMYW1iZGFEZXBsb3ltZW50Q29uZmlnIGltcGxlbWVudHMgSUxhbWJkYURlcGxveW1lbnRDb25maWcge1xuICBwdWJsaWMgcmVhZG9ubHkgZGVwbG95bWVudENvbmZpZ05hbWU6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihkZXBsb3ltZW50Q29uZmlnTmFtZTogc3RyaW5nKSB7XG4gICAgdGhpcy5kZXBsb3ltZW50Q29uZmlnTmFtZSA9IGBDb2RlRGVwbG95RGVmYXVsdC5MYW1iZGEke2RlcGxveW1lbnRDb25maWdOYW1lfWA7XG4gIH1cblxuICBwdWJsaWMgZGVwbG95bWVudENvbmZpZ0FybihzY29wZTogY2RrLklDb25zdHJ1Y3QpOiBzdHJpbmcge1xuICAgIHJldHVybiBhcm5Gb3JEZXBsb3ltZW50Q29uZmlnTmFtZSh0aGlzLmRlcGxveW1lbnRDb25maWdOYW1lLCBzY29wZSk7XG4gIH1cbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIG9mIGEgcmVmZXJlbmNlIHRvIGEgQ29kZURlcGxveSBMYW1iZGEgRGVwbG95bWVudCBDb25maWd1cmF0aW9uLlxuICpcbiAqIEBzZWUgTGFtYmRhRGVwbG95bWVudENvbmZpZyNpbXBvcnRcbiAqIEBzZWUgTGFtYmRhRGVwbG95bWVudENvbmZpZyNleHBvcnRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBMYW1iZGFEZXBsb3ltZW50Q29uZmlnSW1wb3J0UHJvcHMge1xuICAvKipcbiAgICogVGhlIHBoeXNpY2FsLCBodW1hbi1yZWFkYWJsZSBuYW1lIG9mIHRoZSBjdXN0b20gQ29kZURlcGxveSBMYW1iZGEgRGVwbG95bWVudCBDb25maWd1cmF0aW9uXG4gICAqIHRoYXQgd2UgYXJlIHJlZmVyZW5jaW5nLlxuICAgKi9cbiAgcmVhZG9ubHkgZGVwbG95bWVudENvbmZpZ05hbWU6IHN0cmluZztcbn1cblxuY2xhc3MgSW1wb3J0ZWRMYW1iZGFEZXBsb3ltZW50Q29uZmlnIGV4dGVuZHMgY2RrLkNvbnN0cnVjdCBpbXBsZW1lbnRzIElMYW1iZGFEZXBsb3ltZW50Q29uZmlnIHtcbiAgcHVibGljIHJlYWRvbmx5IGRlcGxveW1lbnRDb25maWdOYW1lOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IExhbWJkYURlcGxveW1lbnRDb25maWdJbXBvcnRQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLmRlcGxveW1lbnRDb25maWdOYW1lID0gcHJvcHMuZGVwbG95bWVudENvbmZpZ05hbWU7XG4gIH1cblxuICBwdWJsaWMgZGVwbG95bWVudENvbmZpZ0FybihzY29wZTogY2RrLklDb25zdHJ1Y3QpOiBzdHJpbmcge1xuICAgIHJldHVybiBhcm5Gb3JEZXBsb3ltZW50Q29uZmlnTmFtZSh0aGlzLmRlcGxveW1lbnRDb25maWdOYW1lLCBzY29wZSk7XG4gIH1cblxuICBwdWJsaWMgZXhwb3J0KCkge1xuICAgIHJldHVybiB0aGlzLnByb3BzO1xuICB9XG59XG5cbi8qKlxuICogQSBjdXN0b20gRGVwbG95bWVudCBDb25maWd1cmF0aW9uIGZvciBhIExhbWJkYSBEZXBsb3ltZW50IEdyb3VwLlxuICpcbiAqIE5vdGU6IFRoaXMgY2xhc3MgY3VycmVudGx5IHN0YW5kcyBhcyBuYW1lc3BhY2VkIGNvbnRhaW5lciBvZiB0aGUgZGVmYXVsdCBjb25maWd1cmF0aW9uc1xuICogdW50aWwgQ2xvdWRGb3JtYXRpb24gc3VwcG9ydHMgY3VzdG9tIExhbWJkYSBEZXBsb3ltZW50IENvbmZpZ3MuIFVudGlsIHRoZW4gaXQgaXMgY2xvc2VkXG4gKiAocHJpdmF0ZSBjb25zdHJ1Y3RvcikgYW5kIGRvZXMgbm90IGV4dGVuZCB7QGxpbmsgY2RrLkNvbnN0cnVjdH1cbiAqL1xuZXhwb3J0IGNsYXNzIExhbWJkYURlcGxveW1lbnRDb25maWcge1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFsbEF0T25jZTogSUxhbWJkYURlcGxveW1lbnRDb25maWcgPSBuZXcgRGVmYXVsdExhbWJkYURlcGxveW1lbnRDb25maWcoJ0FsbEF0T25jZScpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENhbmFyeTEwUGVyY2VudDMwTWludXRlczogSUxhbWJkYURlcGxveW1lbnRDb25maWcgPSBuZXcgRGVmYXVsdExhbWJkYURlcGxveW1lbnRDb25maWcoJ0NhbmFyeTEwUGVyY2VudDMwTWludXRlcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENhbmFyeTEwUGVyY2VudDVNaW51dGVzOiBJTGFtYmRhRGVwbG95bWVudENvbmZpZyA9IG5ldyBEZWZhdWx0TGFtYmRhRGVwbG95bWVudENvbmZpZygnQ2FuYXJ5MTBQZXJjZW50NU1pbnV0ZXMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDYW5hcnkxMFBlcmNlbnQxME1pbnV0ZXM6IElMYW1iZGFEZXBsb3ltZW50Q29uZmlnID0gbmV3IERlZmF1bHRMYW1iZGFEZXBsb3ltZW50Q29uZmlnKCdDYW5hcnkxMFBlcmNlbnQxME1pbnV0ZXMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDYW5hcnkxMFBlcmNlbnQxNU1pbnV0ZXM6IElMYW1iZGFEZXBsb3ltZW50Q29uZmlnID0gbmV3IERlZmF1bHRMYW1iZGFEZXBsb3ltZW50Q29uZmlnKCdDYW5hcnkxMFBlcmNlbnQxNU1pbnV0ZXMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBMaW5lYXIxMFBlcmNlbnRFdmVyeTEwTWludXRlczogSUxhbWJkYURlcGxveW1lbnRDb25maWcgPSBuZXcgRGVmYXVsdExhbWJkYURlcGxveW1lbnRDb25maWcoJ0xpbmVhcjEwUGVyY2VudEV2ZXJ5MTBNaW51dGVzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTGluZWFyMTBQZXJjZW50RXZlcnkxTWludXRlOiBJTGFtYmRhRGVwbG95bWVudENvbmZpZyA9IG5ldyBEZWZhdWx0TGFtYmRhRGVwbG95bWVudENvbmZpZygnTGluZWFyMTBQZXJjZW50RXZlcnkxTWludXRlJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTGluZWFyMTBQZXJjZW50RXZlcnkyTWludXRlczogSUxhbWJkYURlcGxveW1lbnRDb25maWcgPSBuZXcgRGVmYXVsdExhbWJkYURlcGxveW1lbnRDb25maWcoJ0xpbmVhcjEwUGVyY2VudEV2ZXJ5Mk1pbnV0ZXMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBMaW5lYXIxMFBlcmNlbnRFdmVyeTNNaW51dGVzOiBJTGFtYmRhRGVwbG95bWVudENvbmZpZyA9IG5ldyBEZWZhdWx0TGFtYmRhRGVwbG95bWVudENvbmZpZygnTGluZWFyMTBQZXJjZW50RXZlcnkzTWludXRlcycpO1xuXG4gIC8qKlxuICAgKiBJbXBvcnQgYSBjdXN0b20gRGVwbG95bWVudCBDb25maWd1cmF0aW9uIGZvciBhIExhbWJkYSBEZXBsb3ltZW50IEdyb3VwIGRlZmluZWQgb3V0c2lkZSB0aGUgQ0RLLlxuICAgKlxuICAgKiBAcGFyYW0gc2NvcGUgdGhlIHBhcmVudCBDb25zdHJ1Y3QgZm9yIHRoaXMgbmV3IENvbnN0cnVjdFxuICAgKiBAcGFyYW0gaWQgdGhlIGxvZ2ljYWwgSUQgb2YgdGhpcyBuZXcgQ29uc3RydWN0XG4gICAqIEBwYXJhbSBwcm9wcyB0aGUgcHJvcGVydGllcyBvZiB0aGUgcmVmZXJlbmNlZCBjdXN0b20gRGVwbG95bWVudCBDb25maWd1cmF0aW9uXG4gICAqIEByZXR1cm5zIGEgQ29uc3RydWN0IHJlcHJlc2VudGluZyBhIHJlZmVyZW5jZSB0byBhbiBleGlzdGluZyBjdXN0b20gRGVwbG95bWVudCBDb25maWd1cmF0aW9uXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGltcG9ydChzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IExhbWJkYURlcGxveW1lbnRDb25maWdJbXBvcnRQcm9wcyk6IElMYW1iZGFEZXBsb3ltZW50Q29uZmlnIHtcbiAgICByZXR1cm4gbmV3IEltcG9ydGVkTGFtYmRhRGVwbG95bWVudENvbmZpZyhzY29wZSwgaWQsIHByb3BzKTtcbiAgfVxuXG4gIHByaXZhdGUgY29uc3RydWN0b3IoKSB7XG4gICAgLy8gbm90aGluZyB0byBkbyB1bnRpbCBDRk4gc3VwcG9ydHMgY3VzdG9tIGxhbWJkYSBkZXBsb3ltZW50IGNvbmZpZ3VyYXRpb25zXG4gIH1cbn1cbiJdfQ==