import codepipeline = require('@aws-cdk/aws-codepipeline-api');
import cdk = require('@aws-cdk/cdk');
import { IServerDeploymentGroup } from './server';
/**
 * Common properties for creating a {@link PipelineDeployAction},
 * either directly, through its constructor,
 * or through {@link IServerDeploymentGroup#toCodePipelineDeployAction}.
 */
export interface CommonPipelineDeployActionProps extends codepipeline.CommonActionProps {
    /**
     * The source to use as input for deployment.
     */
    readonly inputArtifact: codepipeline.Artifact;
}
/**
 * Construction properties of the {@link PipelineDeployAction CodeDeploy deploy CodePipeline Action}.
 */
export interface PipelineDeployActionProps extends CommonPipelineDeployActionProps {
    /**
     * The CodeDeploy Deployment Group to deploy to.
     */
    readonly deploymentGroup: IServerDeploymentGroup;
}
export declare class PipelineDeployAction extends codepipeline.DeployAction {
    private readonly deploymentGroup;
    constructor(props: PipelineDeployActionProps);
    protected bind(stage: codepipeline.IStage, scope: cdk.Construct): void;
}
