"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codepipeline = require("@aws-cdk/aws-codepipeline-api");
const iam = require("@aws-cdk/aws-iam");
class PipelineDeployAction extends codepipeline.DeployAction {
    constructor(props) {
        super(Object.assign({}, props, { artifactBounds: { minInputs: 1, maxInputs: 1, minOutputs: 0, maxOutputs: 0 }, provider: 'CodeDeploy', inputArtifact: props.inputArtifact, configuration: {
                ApplicationName: props.deploymentGroup.application.applicationName,
                DeploymentGroupName: props.deploymentGroup.deploymentGroupName,
            } }));
        this.deploymentGroup = props.deploymentGroup;
    }
    bind(stage, scope) {
        // permissions, based on:
        // https://docs.aws.amazon.com/codedeploy/latest/userguide/auth-and-access-control-permissions-reference.html
        stage.pipeline.role.addToPolicy(new iam.PolicyStatement()
            .addResource(this.deploymentGroup.application.applicationArn)
            .addActions('codedeploy:GetApplicationRevision', 'codedeploy:RegisterApplicationRevision'));
        stage.pipeline.role.addToPolicy(new iam.PolicyStatement()
            .addResource(this.deploymentGroup.deploymentGroupArn)
            .addActions('codedeploy:CreateDeployment', 'codedeploy:GetDeployment'));
        stage.pipeline.role.addToPolicy(new iam.PolicyStatement()
            .addResource(this.deploymentGroup.deploymentConfig.deploymentConfigArn(scope))
            .addActions('codedeploy:GetDeploymentConfig'));
        // grant the ASG Role permissions to read from the Pipeline Bucket
        for (const asg of this.deploymentGroup.autoScalingGroups || []) {
            stage.pipeline.grantBucketRead(asg.role);
        }
    }
}
exports.PipelineDeployAction = PipelineDeployAction;
//# sourceMappingURL=data:application/json;base64,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