"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const codedeploy_generated_1 = require("../codedeploy.generated");
const utils_1 = require("../utils");
class ImportedServerApplication extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.applicationName = props.applicationName;
        this.applicationArn = utils_1.applicationNameToArn(this.applicationName, this);
    }
    export() {
        return this.props;
    }
}
/**
 * A CodeDeploy Application that deploys to EC2/on-premise instances.
 */
class ServerApplication extends cdk.Construct {
    /**
     * Import an Application defined either outside the CDK,
     * or in a different CDK Stack and exported using the {@link #export} method.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param props the properties of the referenced Application
     * @returns a Construct representing a reference to an existing Application
     */
    static import(scope, id, props) {
        return new ImportedServerApplication(scope, id, props);
    }
    constructor(scope, id, props = {}) {
        super(scope, id);
        const resource = new codedeploy_generated_1.CfnApplication(this, 'Resource', {
            applicationName: props.applicationName,
            computePlatform: 'Server',
        });
        this.applicationName = resource.ref;
        this.applicationArn = utils_1.applicationNameToArn(this.applicationName, this);
    }
    export() {
        return {
            applicationName: new cdk.CfnOutput(this, 'ApplicationName', { value: this.applicationName }).makeImportValue().toString()
        };
    }
}
exports.ServerApplication = ServerApplication;
//# sourceMappingURL=data:application/json;base64,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