import cdk = require('@aws-cdk/cdk');
/**
 * The Deployment Configuration of an EC2/on-premise Deployment Group.
 * The default, pre-defined Configurations are available as constants on the {@link ServerDeploymentConfig} class
 * (`ServerDeploymentConfig.HalfAtATime`, `ServerDeploymentConfig.AllAtOnce`, etc.).
 * To create a custom Deployment Configuration,
 * instantiate the {@link ServerDeploymentConfig} Construct.
 */
export interface IServerDeploymentConfig {
    readonly deploymentConfigName: string;
    deploymentConfigArn(scope: cdk.IConstruct): string;
    export(): ServerDeploymentConfigImportProps;
}
/**
 * Properties of a reference to a CodeDeploy EC2/on-premise Deployment Configuration.
 *
 * @see ServerDeploymentConfig#import
 * @see ServerDeploymentConfig#export
 */
export interface ServerDeploymentConfigImportProps {
    /**
     * The physical, human-readable name of the custom CodeDeploy EC2/on-premise Deployment Configuration
     * that we are referencing.
     */
    readonly deploymentConfigName: string;
}
/**
 * Construction properties of {@link ServerDeploymentConfig}.
 */
export interface ServerDeploymentConfigProps {
    /**
     * The physical, human-readable name of the Deployment Configuration.
     *
     * @default a name will be auto-generated
     */
    readonly deploymentConfigName?: string;
    /**
     * The minimum healhty hosts threshold expressed as an absolute number.
     * If you've specified this value,
     * you can't specify {@link #minHealthyHostPercentage},
     * however one of this or {@link #minHealthyHostPercentage} is required.
     */
    readonly minHealthyHostCount?: number;
    /**
     * The minmum healhty hosts threshold expressed as a percentage of the fleet.
     * If you've specified this value,
     * you can't specify {@link #minHealthyHostCount},
     * however one of this or {@link #minHealthyHostCount} is required.
     */
    readonly minHealthyHostPercentage?: number;
}
/**
 * A custom Deployment Configuration for an EC2/on-premise Deployment Group.
 */
export declare class ServerDeploymentConfig extends cdk.Construct implements IServerDeploymentConfig {
    static readonly OneAtATime: IServerDeploymentConfig;
    static readonly HalfAtATime: IServerDeploymentConfig;
    static readonly AllAtOnce: IServerDeploymentConfig;
    /**
     * Import a custom Deployment Configuration for an EC2/on-premise Deployment Group defined either outside the CDK,
     * or in a different CDK Stack and exported using the {@link #export} method.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param props the properties of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static import(scope: cdk.Construct, id: string, props: ServerDeploymentConfigImportProps): IServerDeploymentConfig;
    readonly deploymentConfigName: string;
    constructor(scope: cdk.Construct, id: string, props: ServerDeploymentConfigProps);
    deploymentConfigArn(scope: cdk.IConstruct): string;
    export(): ServerDeploymentConfigImportProps;
    private minimumHealthyHosts;
}
