import cloudwatch = require('@aws-cdk/aws-cloudwatch');
import cdk = require('@aws-cdk/cdk');
import { CfnDeploymentGroup } from './codedeploy.generated';
import { AutoRollbackConfig } from './rollback-config';
export declare function applicationNameToArn(applicationName: string, scope: cdk.IConstruct): string;
export declare function deploymentGroupNameToArn(applicationName: string, deploymentGroupName: string, scope: cdk.IConstruct): string;
export declare function arnForDeploymentConfigName(name: string, scope: cdk.IConstruct): string;
export declare function renderAlarmConfiguration(alarms: cloudwatch.Alarm[], ignorePollAlarmFailure?: boolean): CfnDeploymentGroup.AlarmConfigurationProperty | undefined;
export declare function renderAutoRollbackConfiguration(alarms: cloudwatch.Alarm[], autoRollbackConfig?: AutoRollbackConfig): CfnDeploymentGroup.AutoRollbackConfigurationProperty | undefined;
