"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function applicationNameToArn(applicationName, scope) {
    return scope.node.stack.formatArn({
        service: 'codedeploy',
        resource: 'application',
        resourceName: applicationName,
        sep: ':',
    });
}
exports.applicationNameToArn = applicationNameToArn;
function deploymentGroupNameToArn(applicationName, deploymentGroupName, scope) {
    return scope.node.stack.formatArn({
        service: 'codedeploy',
        resource: 'deploymentgroup',
        resourceName: `${applicationName}/${deploymentGroupName}`,
        sep: ':',
    });
}
exports.deploymentGroupNameToArn = deploymentGroupNameToArn;
function arnForDeploymentConfigName(name, scope) {
    return scope.node.stack.formatArn({
        service: 'codedeploy',
        resource: 'deploymentconfig',
        resourceName: name,
        sep: ':',
    });
}
exports.arnForDeploymentConfigName = arnForDeploymentConfigName;
function renderAlarmConfiguration(alarms, ignorePollAlarmFailure) {
    return alarms.length === 0
        ? undefined
        : {
            alarms: alarms.map(a => ({ name: a.alarmName })),
            enabled: true,
            ignorePollAlarmFailure,
        };
}
exports.renderAlarmConfiguration = renderAlarmConfiguration;
var AutoRollbackEvent;
(function (AutoRollbackEvent) {
    AutoRollbackEvent["DeploymentFailure"] = "DEPLOYMENT_FAILURE";
    AutoRollbackEvent["DeploymentStopOnAlarm"] = "DEPLOYMENT_STOP_ON_ALARM";
    AutoRollbackEvent["DeploymentStopOnRequest"] = "DEPLOYMENT_STOP_ON_REQUEST";
})(AutoRollbackEvent || (AutoRollbackEvent = {}));
function renderAutoRollbackConfiguration(alarms, autoRollbackConfig = {}) {
    const events = new Array();
    // we roll back failed deployments by default
    if (autoRollbackConfig.failedDeployment !== false) {
        events.push(AutoRollbackEvent.DeploymentFailure);
    }
    // we _do not_ roll back stopped deployments by default
    if (autoRollbackConfig.stoppedDeployment === true) {
        events.push(AutoRollbackEvent.DeploymentStopOnRequest);
    }
    // we _do not_ roll back alarm-triggering deployments by default
    // unless the Deployment Group has at least one alarm
    if (autoRollbackConfig.deploymentInAlarm !== false) {
        if (alarms.length > 0) {
            events.push(AutoRollbackEvent.DeploymentStopOnAlarm);
        }
        else if (autoRollbackConfig.deploymentInAlarm === true) {
            throw new Error("The auto-rollback setting 'deploymentInAlarm' does not have any effect unless you associate " +
                "at least one CloudWatch alarm with the Deployment Group");
        }
    }
    return events.length > 0
        ? {
            enabled: true,
            events,
        }
        : undefined;
}
exports.renderAutoRollbackConfiguration = renderAutoRollbackConfiguration;
//# sourceMappingURL=data:application/json;base64,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