"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const autoscaling = require("@aws-cdk/aws-autoscaling");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const ec2 = require("@aws-cdk/aws-ec2");
const lb = require("@aws-cdk/aws-elasticloadbalancing");
const cdk = require("@aws-cdk/cdk");
const codedeploy = require("../../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-codedeploy-server-dg');
const vpc = new ec2.VpcNetwork(stack, 'VPC');
const asg = new autoscaling.AutoScalingGroup(stack, 'ASG', {
    instanceType: new ec2.InstanceTypePair(ec2.InstanceClass.M5, ec2.InstanceSize.Large),
    machineImage: new ec2.AmazonLinuxImage(),
    vpc,
});
const elb = new lb.LoadBalancer(stack, 'ELB', { vpc });
elb.addListener({
    externalPort: 80,
});
new codedeploy.ServerDeploymentGroup(stack, 'CodeDeployGroup', {
    deploymentConfig: codedeploy.ServerDeploymentConfig.AllAtOnce,
    autoScalingGroups: [asg],
    loadBalancer: elb,
    alarms: [
        new cloudwatch.Alarm(stack, 'Alarm1', {
            metric: new cloudwatch.Metric({
                metricName: 'Errors',
                namespace: 'my.namespace',
            }),
            threshold: 1,
            evaluationPeriods: 1,
        }),
    ],
    autoRollback: {
        failedDeployment: false,
        deploymentInAlarm: false,
    },
});
app.run();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVwbG95bWVudC1ncm91cC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLmRlcGxveW1lbnQtZ3JvdXAudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSx3REFBeUQ7QUFDekQsc0RBQXVEO0FBQ3ZELHdDQUF5QztBQUN6Qyx3REFBeUQ7QUFDekQsb0NBQXFDO0FBQ3JDLHdDQUF5QztBQUV6QyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUUxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLDhCQUE4QixDQUFDLENBQUM7QUFFakUsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztBQUU3QyxNQUFNLEdBQUcsR0FBRyxJQUFJLFdBQVcsQ0FBQyxnQkFBZ0IsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFO0lBQ3pELFlBQVksRUFBRSxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsYUFBYSxDQUFDLEVBQUUsRUFBRSxHQUFHLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQztJQUNwRixZQUFZLEVBQUUsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLEVBQUU7SUFDeEMsR0FBRztDQUNKLENBQUMsQ0FBQztBQUVILE1BQU0sR0FBRyxHQUFHLElBQUksRUFBRSxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztBQUN2RCxHQUFHLENBQUMsV0FBVyxDQUFDO0lBQ2QsWUFBWSxFQUFFLEVBQUU7Q0FDakIsQ0FBQyxDQUFDO0FBRUgsSUFBSSxVQUFVLENBQUMscUJBQXFCLENBQUMsS0FBSyxFQUFFLGlCQUFpQixFQUFFO0lBQzdELGdCQUFnQixFQUFFLFVBQVUsQ0FBQyxzQkFBc0IsQ0FBQyxTQUFTO0lBQzdELGlCQUFpQixFQUFFLENBQUMsR0FBRyxDQUFDO0lBQ3hCLFlBQVksRUFBRSxHQUFHO0lBQ2pCLE1BQU0sRUFBRTtRQUNOLElBQUksVUFBVSxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsUUFBUSxFQUFFO1lBQ3BDLE1BQU0sRUFBRSxJQUFJLFVBQVUsQ0FBQyxNQUFNLENBQUM7Z0JBQzVCLFVBQVUsRUFBRSxRQUFRO2dCQUNwQixTQUFTLEVBQUUsY0FBYzthQUMxQixDQUFDO1lBQ0YsU0FBUyxFQUFFLENBQUM7WUFDWixpQkFBaUIsRUFBRSxDQUFDO1NBQ3JCLENBQUM7S0FDSDtJQUNELFlBQVksRUFBRTtRQUNaLGdCQUFnQixFQUFFLEtBQUs7UUFDdkIsaUJBQWlCLEVBQUUsS0FBSztLQUN6QjtDQUNGLENBQUMsQ0FBQztBQUVILEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBhdXRvc2NhbGluZyA9IHJlcXVpcmUoJ0Bhd3MtY2RrL2F3cy1hdXRvc2NhbGluZycpO1xuaW1wb3J0IGNsb3Vkd2F0Y2ggPSByZXF1aXJlKCdAYXdzLWNkay9hd3MtY2xvdWR3YXRjaCcpO1xuaW1wb3J0IGVjMiA9IHJlcXVpcmUoJ0Bhd3MtY2RrL2F3cy1lYzInKTtcbmltcG9ydCBsYiA9IHJlcXVpcmUoJ0Bhd3MtY2RrL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZycpO1xuaW1wb3J0IGNkayA9IHJlcXVpcmUoJ0Bhd3MtY2RrL2NkaycpO1xuaW1wb3J0IGNvZGVkZXBsb3kgPSByZXF1aXJlKCcuLi8uLi9saWInKTtcblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcblxuY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ2F3cy1jZGstY29kZWRlcGxveS1zZXJ2ZXItZGcnKTtcblxuY29uc3QgdnBjID0gbmV3IGVjMi5WcGNOZXR3b3JrKHN0YWNrLCAnVlBDJyk7XG5cbmNvbnN0IGFzZyA9IG5ldyBhdXRvc2NhbGluZy5BdXRvU2NhbGluZ0dyb3VwKHN0YWNrLCAnQVNHJywge1xuICBpbnN0YW5jZVR5cGU6IG5ldyBlYzIuSW5zdGFuY2VUeXBlUGFpcihlYzIuSW5zdGFuY2VDbGFzcy5NNSwgZWMyLkluc3RhbmNlU2l6ZS5MYXJnZSksXG4gIG1hY2hpbmVJbWFnZTogbmV3IGVjMi5BbWF6b25MaW51eEltYWdlKCksXG4gIHZwYyxcbn0pO1xuXG5jb25zdCBlbGIgPSBuZXcgbGIuTG9hZEJhbGFuY2VyKHN0YWNrLCAnRUxCJywgeyB2cGMgfSk7XG5lbGIuYWRkTGlzdGVuZXIoe1xuICBleHRlcm5hbFBvcnQ6IDgwLFxufSk7XG5cbm5ldyBjb2RlZGVwbG95LlNlcnZlckRlcGxveW1lbnRHcm91cChzdGFjaywgJ0NvZGVEZXBsb3lHcm91cCcsIHtcbiAgZGVwbG95bWVudENvbmZpZzogY29kZWRlcGxveS5TZXJ2ZXJEZXBsb3ltZW50Q29uZmlnLkFsbEF0T25jZSxcbiAgYXV0b1NjYWxpbmdHcm91cHM6IFthc2ddLFxuICBsb2FkQmFsYW5jZXI6IGVsYixcbiAgYWxhcm1zOiBbXG4gICAgbmV3IGNsb3Vkd2F0Y2guQWxhcm0oc3RhY2ssICdBbGFybTEnLCB7XG4gICAgICBtZXRyaWM6IG5ldyBjbG91ZHdhdGNoLk1ldHJpYyh7XG4gICAgICAgIG1ldHJpY05hbWU6ICdFcnJvcnMnLFxuICAgICAgICBuYW1lc3BhY2U6ICdteS5uYW1lc3BhY2UnLFxuICAgICAgfSksXG4gICAgICB0aHJlc2hvbGQ6IDEsXG4gICAgICBldmFsdWF0aW9uUGVyaW9kczogMSxcbiAgICB9KSxcbiAgXSxcbiAgYXV0b1JvbGxiYWNrOiB7XG4gICAgZmFpbGVkRGVwbG95bWVudDogZmFsc2UsXG4gICAgZGVwbG95bWVudEluQWxhcm06IGZhbHNlLFxuICB9LFxufSk7XG5cbmFwcC5ydW4oKTtcbiJdfQ==