"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/cdk");
const codedeploy = require("../../lib");
module.exports = {
    'CodeDeploy DeploymentConfig': {
        "cannot be created without specifying minHealthyHostCount or minHealthyHostPercentage"(test) {
            const stack = new cdk.Stack();
            test.throws(() => {
                new codedeploy.ServerDeploymentConfig(stack, 'DeploymentConfig', {});
            }, /minHealthyHost/i);
            test.done();
        },
        "cannot be created specifying both minHealthyHostCount and minHealthyHostPercentage"(test) {
            const stack = new cdk.Stack();
            test.throws(() => {
                new codedeploy.ServerDeploymentConfig(stack, 'DeploymentConfig', {
                    minHealthyHostCount: 1,
                    minHealthyHostPercentage: 1,
                });
            }, /minHealthyHost/i);
            test.done();
        },
        "can be created by specifying only minHealthyHostCount"(test) {
            const stack = new cdk.Stack();
            new codedeploy.ServerDeploymentConfig(stack, 'DeploymentConfig', {
                minHealthyHostCount: 1,
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::DeploymentConfig', {
                "MinimumHealthyHosts": {
                    "Type": "HOST_COUNT",
                    "Value": 1,
                },
            }));
            test.done();
        },
        "can be created by specifying only minHealthyHostPercentage"(test) {
            const stack = new cdk.Stack();
            new codedeploy.ServerDeploymentConfig(stack, 'DeploymentConfig', {
                minHealthyHostPercentage: 75,
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::DeploymentConfig', {
                "MinimumHealthyHosts": {
                    "Type": "FLEET_PERCENT",
                    "Value": 75,
                },
            }));
            test.done();
        },
        'can be imported'(test) {
            const stack = new cdk.Stack();
            const deploymentConfig = codedeploy.ServerDeploymentConfig.import(stack, 'MyDC', {
                deploymentConfigName: 'MyDC',
            });
            test.notEqual(deploymentConfig, undefined);
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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