# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetApmDomainsApmDomainResult',
    'GetApmDomainsFilterResult',
    'GetDataKeysDataKeyResult',
    'GetDataKeysFilterResult',
]

@pulumi.output_type
class GetApmDomainsApmDomainResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 data_upload_endpoint: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_free_tier: bool,
                 state: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str data_upload_endpoint: The endpoint where the APM agents upload their observations and metrics.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str description: Description of the APM domain.
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: Unique identifier that is immutable on creation.
        :param bool is_free_tier: Indicates if this is an Always Free resource.
        :param str state: A filter to return only resources that match the given life-cycle state.
        :param str time_created: The time the APM domain was created, expressed in RFC 3339 timestamp format.
        :param str time_updated: The time the APM domain was updated, expressed in RFC 3339 timestamp format.
        """
        GetApmDomainsApmDomainResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            data_upload_endpoint=data_upload_endpoint,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            is_free_tier=is_free_tier,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             data_upload_endpoint: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_free_tier: bool,
             state: str,
             time_created: str,
             time_updated: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("data_upload_endpoint", data_upload_endpoint)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_free_tier", is_free_tier)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataUploadEndpoint")
    def data_upload_endpoint(self) -> str:
        """
        The endpoint where the APM agents upload their observations and metrics.
        """
        return pulumi.get(self, "data_upload_endpoint")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the APM domain.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isFreeTier")
    def is_free_tier(self) -> bool:
        """
        Indicates if this is an Always Free resource.
        """
        return pulumi.get(self, "is_free_tier")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources that match the given life-cycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the APM domain was created, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the APM domain was updated, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetApmDomainsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetApmDomainsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDataKeysDataKeyResult(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str,
                 value: str):
        """
        :param str name: Name of the Data Key. The name uniquely identifies a Data Key within an APM domain.
        :param str type: Type of the Data Key.
        :param str value: Value of the Data Key.
        """
        GetDataKeysDataKeyResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            type=type,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             type: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("type", type)
        _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Data Key. The name uniquely identifies a Data Key within an APM domain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the Data Key.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the Data Key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDataKeysFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of the Data Key. The name uniquely identifies a Data Key within an APM domain.
        """
        GetDataKeysFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Data Key. The name uniquely identifies a Data Key within an APM domain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


