# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTraceAggregatedSnapshotDataResult',
    'AwaitableGetTraceAggregatedSnapshotDataResult',
    'get_trace_aggregated_snapshot_data',
    'get_trace_aggregated_snapshot_data_output',
]

@pulumi.output_type
class GetTraceAggregatedSnapshotDataResult:
    """
    A collection of values returned by getTraceAggregatedSnapshotData.
    """
    def __init__(__self__, apm_domain_id=None, details=None, id=None, trace_key=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if details and not isinstance(details, list):
            raise TypeError("Expected argument 'details' to be a list")
        pulumi.set(__self__, "details", details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if trace_key and not isinstance(trace_key, str):
            raise TypeError("Expected argument 'trace_key' to be a str")
        pulumi.set(__self__, "trace_key", trace_key)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> str:
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.GetTraceAggregatedSnapshotDataDetailResult']:
        """
        Aggregated snapshot details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="traceKey")
    def trace_key(self) -> str:
        return pulumi.get(self, "trace_key")


class AwaitableGetTraceAggregatedSnapshotDataResult(GetTraceAggregatedSnapshotDataResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTraceAggregatedSnapshotDataResult(
            apm_domain_id=self.apm_domain_id,
            details=self.details,
            id=self.id,
            trace_key=self.trace_key)


def get_trace_aggregated_snapshot_data(apm_domain_id: Optional[str] = None,
                                       trace_key: Optional[str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTraceAggregatedSnapshotDataResult:
    """
    This data source provides details about a specific Trace Aggregated Snapshot Data resource in Oracle Cloud Infrastructure Apm Traces service.

    Gets the aggregated snapshot identified by trace ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_trace_aggregated_snapshot_data = oci.ApmTraces.get_trace_aggregated_snapshot_data(apm_domain_id=oci_apm_apm_domain["test_apm_domain"]["id"],
        trace_key=var["trace_aggregated_snapshot_data_trace_key"])
    ```


    :param str apm_domain_id: The APM Domain ID the request is intended for.
    :param str trace_key: Unique Application Performance Monitoring trace identifier (traceId).
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['traceKey'] = trace_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmTraces/getTraceAggregatedSnapshotData:getTraceAggregatedSnapshotData', __args__, opts=opts, typ=GetTraceAggregatedSnapshotDataResult).value

    return AwaitableGetTraceAggregatedSnapshotDataResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        details=pulumi.get(__ret__, 'details'),
        id=pulumi.get(__ret__, 'id'),
        trace_key=pulumi.get(__ret__, 'trace_key'))


@_utilities.lift_output_func(get_trace_aggregated_snapshot_data)
def get_trace_aggregated_snapshot_data_output(apm_domain_id: Optional[pulumi.Input[str]] = None,
                                              trace_key: Optional[pulumi.Input[str]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTraceAggregatedSnapshotDataResult]:
    """
    This data source provides details about a specific Trace Aggregated Snapshot Data resource in Oracle Cloud Infrastructure Apm Traces service.

    Gets the aggregated snapshot identified by trace ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_trace_aggregated_snapshot_data = oci.ApmTraces.get_trace_aggregated_snapshot_data(apm_domain_id=oci_apm_apm_domain["test_apm_domain"]["id"],
        trace_key=var["trace_aggregated_snapshot_data_trace_key"])
    ```


    :param str apm_domain_id: The APM Domain ID the request is intended for.
    :param str trace_key: Unique Application Performance Monitoring trace identifier (traceId).
    """
    ...
