# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 certificate_config: pulumi.Input['CertificateCertificateConfigArgs'],
                 compartment_id: pulumi.Input[str],
                 certificate_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input['CertificateCertificateConfigArgs'] certificate_config: (Updatable) The details of the contents of the certificate and certificate metadata.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where you want to create the certificate.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]] certificate_rules: (Updatable) An optional list of rules that control how the certificate is used and managed.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A brief description of the certificate. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] name: A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        CertificateArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            certificate_config=certificate_config,
            compartment_id=compartment_id,
            certificate_rules=certificate_rules,
            defined_tags=defined_tags,
            description=description,
            freeform_tags=freeform_tags,
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             certificate_config: pulumi.Input['CertificateCertificateConfigArgs'],
             compartment_id: pulumi.Input[str],
             certificate_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             name: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("certificate_config", certificate_config)
        _setter("compartment_id", compartment_id)
        if certificate_rules is not None:
            _setter("certificate_rules", certificate_rules)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if name is not None:
            _setter("name", name)

    @property
    @pulumi.getter(name="certificateConfig")
    def certificate_config(self) -> pulumi.Input['CertificateCertificateConfigArgs']:
        """
        (Updatable) The details of the contents of the certificate and certificate metadata.
        """
        return pulumi.get(self, "certificate_config")

    @certificate_config.setter
    def certificate_config(self, value: pulumi.Input['CertificateCertificateConfigArgs']):
        pulumi.set(self, "certificate_config", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment where you want to create the certificate.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="certificateRules")
    def certificate_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]]]:
        """
        (Updatable) An optional list of rules that control how the certificate is used and managed.
        """
        return pulumi.get(self, "certificate_rules")

    @certificate_rules.setter
    def certificate_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]]]):
        pulumi.set(self, "certificate_rules", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A brief description of the certificate. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 certificate_config: Optional[pulumi.Input['CertificateCertificateConfigArgs']] = None,
                 certificate_profile_type: Optional[pulumi.Input[str]] = None,
                 certificate_revocation_list_details: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRevocationListDetailArgs']]]] = None,
                 certificate_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 config_type: Optional[pulumi.Input[str]] = None,
                 current_versions: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCurrentVersionArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 issuer_certificate_authority_id: Optional[pulumi.Input[str]] = None,
                 key_algorithm: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 signature_algorithm: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subjects: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateSubjectArgs']]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_of_deletion: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input['CertificateCertificateConfigArgs'] certificate_config: (Updatable) The details of the contents of the certificate and certificate metadata.
        :param pulumi.Input[str] certificate_profile_type: The name of the profile used to create the certificate, which depends on the type of certificate you need.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRevocationListDetailArgs']]] certificate_revocation_list_details: The details of the certificate revocation list (CRL).
        :param pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]] certificate_rules: (Updatable) An optional list of rules that control how the certificate is used and managed.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where you want to create the certificate.
        :param pulumi.Input[str] config_type: (Updatable) The origin of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateCurrentVersionArgs']]] current_versions: The details of the certificate version. This object does not contain the certificate contents.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A brief description of the certificate. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] issuer_certificate_authority_id: The OCID of the private CA.
        :param pulumi.Input[str] key_algorithm: The algorithm to use to create key pairs.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state of the certificate.
        :param pulumi.Input[str] name: A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] signature_algorithm: The algorithm to use to sign the public key certificate.
        :param pulumi.Input[str] state: The current lifecycle state of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateSubjectArgs']]] subjects: The subject of the certificate, which is a distinguished name that identifies the entity that owns the public key in the certificate.
        :param pulumi.Input[str] time_created: A property indicating when the certificate was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[str] time_of_deletion: An optional property indicating when to delete the certificate version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        _CertificateState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            certificate_config=certificate_config,
            certificate_profile_type=certificate_profile_type,
            certificate_revocation_list_details=certificate_revocation_list_details,
            certificate_rules=certificate_rules,
            compartment_id=compartment_id,
            config_type=config_type,
            current_versions=current_versions,
            defined_tags=defined_tags,
            description=description,
            freeform_tags=freeform_tags,
            issuer_certificate_authority_id=issuer_certificate_authority_id,
            key_algorithm=key_algorithm,
            lifecycle_details=lifecycle_details,
            name=name,
            signature_algorithm=signature_algorithm,
            state=state,
            subjects=subjects,
            time_created=time_created,
            time_of_deletion=time_of_deletion,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             certificate_config: Optional[pulumi.Input['CertificateCertificateConfigArgs']] = None,
             certificate_profile_type: Optional[pulumi.Input[str]] = None,
             certificate_revocation_list_details: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRevocationListDetailArgs']]]] = None,
             certificate_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             config_type: Optional[pulumi.Input[str]] = None,
             current_versions: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCurrentVersionArgs']]]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             issuer_certificate_authority_id: Optional[pulumi.Input[str]] = None,
             key_algorithm: Optional[pulumi.Input[str]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             signature_algorithm: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             subjects: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateSubjectArgs']]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_of_deletion: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if certificate_config is not None:
            _setter("certificate_config", certificate_config)
        if certificate_profile_type is not None:
            _setter("certificate_profile_type", certificate_profile_type)
        if certificate_revocation_list_details is not None:
            _setter("certificate_revocation_list_details", certificate_revocation_list_details)
        if certificate_rules is not None:
            _setter("certificate_rules", certificate_rules)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if config_type is not None:
            _setter("config_type", config_type)
        if current_versions is not None:
            _setter("current_versions", current_versions)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if issuer_certificate_authority_id is not None:
            _setter("issuer_certificate_authority_id", issuer_certificate_authority_id)
        if key_algorithm is not None:
            _setter("key_algorithm", key_algorithm)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if name is not None:
            _setter("name", name)
        if signature_algorithm is not None:
            _setter("signature_algorithm", signature_algorithm)
        if state is not None:
            _setter("state", state)
        if subjects is not None:
            _setter("subjects", subjects)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_of_deletion is not None:
            _setter("time_of_deletion", time_of_deletion)

    @property
    @pulumi.getter(name="certificateConfig")
    def certificate_config(self) -> Optional[pulumi.Input['CertificateCertificateConfigArgs']]:
        """
        (Updatable) The details of the contents of the certificate and certificate metadata.
        """
        return pulumi.get(self, "certificate_config")

    @certificate_config.setter
    def certificate_config(self, value: Optional[pulumi.Input['CertificateCertificateConfigArgs']]):
        pulumi.set(self, "certificate_config", value)

    @property
    @pulumi.getter(name="certificateProfileType")
    def certificate_profile_type(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the profile used to create the certificate, which depends on the type of certificate you need.
        """
        return pulumi.get(self, "certificate_profile_type")

    @certificate_profile_type.setter
    def certificate_profile_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_profile_type", value)

    @property
    @pulumi.getter(name="certificateRevocationListDetails")
    def certificate_revocation_list_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRevocationListDetailArgs']]]]:
        """
        The details of the certificate revocation list (CRL).
        """
        return pulumi.get(self, "certificate_revocation_list_details")

    @certificate_revocation_list_details.setter
    def certificate_revocation_list_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRevocationListDetailArgs']]]]):
        pulumi.set(self, "certificate_revocation_list_details", value)

    @property
    @pulumi.getter(name="certificateRules")
    def certificate_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]]]:
        """
        (Updatable) An optional list of rules that control how the certificate is used and managed.
        """
        return pulumi.get(self, "certificate_rules")

    @certificate_rules.setter
    def certificate_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCertificateRuleArgs']]]]):
        pulumi.set(self, "certificate_rules", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment where you want to create the certificate.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The origin of the certificate.
        """
        return pulumi.get(self, "config_type")

    @config_type.setter
    def config_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_type", value)

    @property
    @pulumi.getter(name="currentVersions")
    def current_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCurrentVersionArgs']]]]:
        """
        The details of the certificate version. This object does not contain the certificate contents.
        """
        return pulumi.get(self, "current_versions")

    @current_versions.setter
    def current_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateCurrentVersionArgs']]]]):
        pulumi.set(self, "current_versions", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A brief description of the certificate. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="issuerCertificateAuthorityId")
    def issuer_certificate_authority_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the private CA.
        """
        return pulumi.get(self, "issuer_certificate_authority_id")

    @issuer_certificate_authority_id.setter
    def issuer_certificate_authority_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_certificate_authority_id", value)

    @property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The algorithm to use to create key pairs.
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_algorithm", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state of the certificate.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The algorithm to use to sign the public key certificate.
        """
        return pulumi.get(self, "signature_algorithm")

    @signature_algorithm.setter
    def signature_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature_algorithm", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the certificate.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def subjects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateSubjectArgs']]]]:
        """
        The subject of the certificate, which is a distinguished name that identifies the entity that owns the public key in the certificate.
        """
        return pulumi.get(self, "subjects")

    @subjects.setter
    def subjects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateSubjectArgs']]]]):
        pulumi.set(self, "subjects", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        A property indicating when the certificate was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> Optional[pulumi.Input[str]]:
        """
        An optional property indicating when to delete the certificate version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @time_of_deletion.setter
    def time_of_deletion(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_deletion", value)


class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_config: Optional[pulumi.Input[pulumi.InputType['CertificateCertificateConfigArgs']]] = None,
                 certificate_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateCertificateRuleArgs']]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Certificate resource in Oracle Cloud Infrastructure Certificates Management service.

        Creates a new certificate according to the details of the request.

        ## Import

        Certificates can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:CertificatesManagement/certificate:Certificate test_certificate "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['CertificateCertificateConfigArgs']] certificate_config: (Updatable) The details of the contents of the certificate and certificate metadata.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateCertificateRuleArgs']]]] certificate_rules: (Updatable) An optional list of rules that control how the certificate is used and managed.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where you want to create the certificate.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A brief description of the certificate. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] name: A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Certificate resource in Oracle Cloud Infrastructure Certificates Management service.

        Creates a new certificate according to the details of the request.

        ## Import

        Certificates can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:CertificatesManagement/certificate:Certificate test_certificate "id"
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            CertificateArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_config: Optional[pulumi.Input[pulumi.InputType['CertificateCertificateConfigArgs']]] = None,
                 certificate_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateCertificateRuleArgs']]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            if certificate_config is not None and not isinstance(certificate_config, CertificateCertificateConfigArgs):
                certificate_config = certificate_config or {}
                def _setter(key, value):
                    certificate_config[key] = value
                CertificateCertificateConfigArgs._configure(_setter, **certificate_config)
            if certificate_config is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_config'")
            __props__.__dict__["certificate_config"] = certificate_config
            __props__.__dict__["certificate_rules"] = certificate_rules
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["name"] = name
            __props__.__dict__["certificate_profile_type"] = None
            __props__.__dict__["certificate_revocation_list_details"] = None
            __props__.__dict__["config_type"] = None
            __props__.__dict__["current_versions"] = None
            __props__.__dict__["issuer_certificate_authority_id"] = None
            __props__.__dict__["key_algorithm"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["signature_algorithm"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["subjects"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_of_deletion"] = None
        super(Certificate, __self__).__init__(
            'oci:CertificatesManagement/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_config: Optional[pulumi.Input[pulumi.InputType['CertificateCertificateConfigArgs']]] = None,
            certificate_profile_type: Optional[pulumi.Input[str]] = None,
            certificate_revocation_list_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateCertificateRevocationListDetailArgs']]]]] = None,
            certificate_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateCertificateRuleArgs']]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            config_type: Optional[pulumi.Input[str]] = None,
            current_versions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateCurrentVersionArgs']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            issuer_certificate_authority_id: Optional[pulumi.Input[str]] = None,
            key_algorithm: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            signature_algorithm: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subjects: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateSubjectArgs']]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_of_deletion: Optional[pulumi.Input[str]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['CertificateCertificateConfigArgs']] certificate_config: (Updatable) The details of the contents of the certificate and certificate metadata.
        :param pulumi.Input[str] certificate_profile_type: The name of the profile used to create the certificate, which depends on the type of certificate you need.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateCertificateRevocationListDetailArgs']]]] certificate_revocation_list_details: The details of the certificate revocation list (CRL).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateCertificateRuleArgs']]]] certificate_rules: (Updatable) An optional list of rules that control how the certificate is used and managed.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where you want to create the certificate.
        :param pulumi.Input[str] config_type: (Updatable) The origin of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateCurrentVersionArgs']]]] current_versions: The details of the certificate version. This object does not contain the certificate contents.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A brief description of the certificate. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] issuer_certificate_authority_id: The OCID of the private CA.
        :param pulumi.Input[str] key_algorithm: The algorithm to use to create key pairs.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state of the certificate.
        :param pulumi.Input[str] name: A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] signature_algorithm: The algorithm to use to sign the public key certificate.
        :param pulumi.Input[str] state: The current lifecycle state of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateSubjectArgs']]]] subjects: The subject of the certificate, which is a distinguished name that identifies the entity that owns the public key in the certificate.
        :param pulumi.Input[str] time_created: A property indicating when the certificate was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[str] time_of_deletion: An optional property indicating when to delete the certificate version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["certificate_config"] = certificate_config
        __props__.__dict__["certificate_profile_type"] = certificate_profile_type
        __props__.__dict__["certificate_revocation_list_details"] = certificate_revocation_list_details
        __props__.__dict__["certificate_rules"] = certificate_rules
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["config_type"] = config_type
        __props__.__dict__["current_versions"] = current_versions
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["issuer_certificate_authority_id"] = issuer_certificate_authority_id
        __props__.__dict__["key_algorithm"] = key_algorithm
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["name"] = name
        __props__.__dict__["signature_algorithm"] = signature_algorithm
        __props__.__dict__["state"] = state
        __props__.__dict__["subjects"] = subjects
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_of_deletion"] = time_of_deletion
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateConfig")
    def certificate_config(self) -> pulumi.Output['outputs.CertificateCertificateConfig']:
        """
        (Updatable) The details of the contents of the certificate and certificate metadata.
        """
        return pulumi.get(self, "certificate_config")

    @property
    @pulumi.getter(name="certificateProfileType")
    def certificate_profile_type(self) -> pulumi.Output[str]:
        """
        The name of the profile used to create the certificate, which depends on the type of certificate you need.
        """
        return pulumi.get(self, "certificate_profile_type")

    @property
    @pulumi.getter(name="certificateRevocationListDetails")
    def certificate_revocation_list_details(self) -> pulumi.Output[Sequence['outputs.CertificateCertificateRevocationListDetail']]:
        """
        The details of the certificate revocation list (CRL).
        """
        return pulumi.get(self, "certificate_revocation_list_details")

    @property
    @pulumi.getter(name="certificateRules")
    def certificate_rules(self) -> pulumi.Output[Optional[Sequence['outputs.CertificateCertificateRule']]]:
        """
        (Updatable) An optional list of rules that control how the certificate is used and managed.
        """
        return pulumi.get(self, "certificate_rules")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment where you want to create the certificate.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The origin of the certificate.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="currentVersions")
    def current_versions(self) -> pulumi.Output[Sequence['outputs.CertificateCurrentVersion']]:
        """
        The details of the certificate version. This object does not contain the certificate contents.
        """
        return pulumi.get(self, "current_versions")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) A brief description of the certificate. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="issuerCertificateAuthorityId")
    def issuer_certificate_authority_id(self) -> pulumi.Output[str]:
        """
        The OCID of the private CA.
        """
        return pulumi.get(self, "issuer_certificate_authority_id")

    @property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Output[str]:
        """
        The algorithm to use to create key pairs.
        """
        return pulumi.get(self, "key_algorithm")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state of the certificate.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> pulumi.Output[str]:
        """
        The algorithm to use to sign the public key certificate.
        """
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the certificate.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def subjects(self) -> pulumi.Output[Sequence['outputs.CertificateSubject']]:
        """
        The subject of the certificate, which is a distinguished name that identifies the entity that owns the public key in the certificate.
        """
        return pulumi.get(self, "subjects")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        A property indicating when the certificate was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> pulumi.Output[str]:
        """
        An optional property indicating when to delete the certificate version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

