# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DbManagementPrivateEndpointArgs', 'DbManagementPrivateEndpoint']

@pulumi.input_type
class DbManagementPrivateEndpointArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 is_cluster: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a DbManagementPrivateEndpoint resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] description: (Updatable) The description of the private endpoint.
        :param pulumi.Input[bool] is_cluster: Specifies whether the Database Management private endpoint will be used for Oracle Databases in a cluster.
        :param pulumi.Input[str] name: (Updatable) The display name of the Database Management private endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The OCIDs of the Network Security Groups to which the Database Management private endpoint belongs.
        """
        DbManagementPrivateEndpointArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            subnet_id=subnet_id,
            description=description,
            is_cluster=is_cluster,
            name=name,
            nsg_ids=nsg_ids,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             subnet_id: pulumi.Input[str],
             description: Optional[pulumi.Input[str]] = None,
             is_cluster: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("subnet_id", subnet_id)
        if description is not None:
            _setter("description", description)
        if is_cluster is not None:
            _setter("is_cluster", is_cluster)
        if name is not None:
            _setter("name", name)
        if nsg_ids is not None:
            _setter("nsg_ids", nsg_ids)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the private endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the Database Management private endpoint will be used for Oracle Databases in a cluster.
        """
        return pulumi.get(self, "is_cluster")

    @is_cluster.setter
    def is_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cluster", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the Database Management private endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The OCIDs of the Network Security Groups to which the Database Management private endpoint belongs.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)


@pulumi.input_type
class _DbManagementPrivateEndpointState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_cluster: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DbManagementPrivateEndpoint resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] description: (Updatable) The description of the private endpoint.
        :param pulumi.Input[bool] is_cluster: Specifies whether the Database Management private endpoint will be used for Oracle Databases in a cluster.
        :param pulumi.Input[str] name: (Updatable) The display name of the Database Management private endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The OCIDs of the Network Security Groups to which the Database Management private endpoint belongs.
        :param pulumi.Input[str] private_ip: The IP addresses assigned to the Database Management private endpoint.
        :param pulumi.Input[str] state: The current lifecycle state of the Database Management private endpoint.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time the Database Managament private endpoint was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
        """
        _DbManagementPrivateEndpointState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            description=description,
            is_cluster=is_cluster,
            name=name,
            nsg_ids=nsg_ids,
            private_ip=private_ip,
            state=state,
            subnet_id=subnet_id,
            time_created=time_created,
            vcn_id=vcn_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             description: Optional[pulumi.Input[str]] = None,
             is_cluster: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             private_ip: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             subnet_id: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             vcn_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if description is not None:
            _setter("description", description)
        if is_cluster is not None:
            _setter("is_cluster", is_cluster)
        if name is not None:
            _setter("name", name)
        if nsg_ids is not None:
            _setter("nsg_ids", nsg_ids)
        if private_ip is not None:
            _setter("private_ip", private_ip)
        if state is not None:
            _setter("state", state)
        if subnet_id is not None:
            _setter("subnet_id", subnet_id)
        if time_created is not None:
            _setter("time_created", time_created)
        if vcn_id is not None:
            _setter("vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the private endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the Database Management private endpoint will be used for Oracle Databases in a cluster.
        """
        return pulumi.get(self, "is_cluster")

    @is_cluster.setter
    def is_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_cluster", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the Database Management private endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The OCIDs of the Network Security Groups to which the Database Management private endpoint belongs.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP addresses assigned to the Database Management private endpoint.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the Database Management private endpoint.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Database Managament private endpoint was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcn_id", value)


class DbManagementPrivateEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_cluster: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Db Management Private Endpoint resource in Oracle Cloud Infrastructure Database Management service.

        Creates a new Database Management private endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_management_private_endpoint = oci.database_management.DbManagementPrivateEndpoint("testDbManagementPrivateEndpoint",
            compartment_id=var["compartment_id"],
            subnet_id=oci_core_subnet["test_subnet"]["id"],
            description=var["db_management_private_endpoint_description"],
            is_cluster=var["db_management_private_endpoint_is_cluster"],
            nsg_ids=var["db_management_private_endpoint_nsg_ids"])
        ```

        ## Import

        DbManagementPrivateEndpoints can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DatabaseManagement/dbManagementPrivateEndpoint:DbManagementPrivateEndpoint test_db_management_private_endpoint "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] description: (Updatable) The description of the private endpoint.
        :param pulumi.Input[bool] is_cluster: Specifies whether the Database Management private endpoint will be used for Oracle Databases in a cluster.
        :param pulumi.Input[str] name: (Updatable) The display name of the Database Management private endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The OCIDs of the Network Security Groups to which the Database Management private endpoint belongs.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbManagementPrivateEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Db Management Private Endpoint resource in Oracle Cloud Infrastructure Database Management service.

        Creates a new Database Management private endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_management_private_endpoint = oci.database_management.DbManagementPrivateEndpoint("testDbManagementPrivateEndpoint",
            compartment_id=var["compartment_id"],
            subnet_id=oci_core_subnet["test_subnet"]["id"],
            description=var["db_management_private_endpoint_description"],
            is_cluster=var["db_management_private_endpoint_is_cluster"],
            nsg_ids=var["db_management_private_endpoint_nsg_ids"])
        ```

        ## Import

        DbManagementPrivateEndpoints can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DatabaseManagement/dbManagementPrivateEndpoint:DbManagementPrivateEndpoint test_db_management_private_endpoint "id"
        ```

        :param str resource_name: The name of the resource.
        :param DbManagementPrivateEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbManagementPrivateEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            DbManagementPrivateEndpointArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_cluster: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbManagementPrivateEndpointArgs.__new__(DbManagementPrivateEndpointArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["description"] = description
            __props__.__dict__["is_cluster"] = is_cluster
            __props__.__dict__["name"] = name
            __props__.__dict__["nsg_ids"] = nsg_ids
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["vcn_id"] = None
        super(DbManagementPrivateEndpoint, __self__).__init__(
            'oci:DatabaseManagement/dbManagementPrivateEndpoint:DbManagementPrivateEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            is_cluster: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            vcn_id: Optional[pulumi.Input[str]] = None) -> 'DbManagementPrivateEndpoint':
        """
        Get an existing DbManagementPrivateEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] description: (Updatable) The description of the private endpoint.
        :param pulumi.Input[bool] is_cluster: Specifies whether the Database Management private endpoint will be used for Oracle Databases in a cluster.
        :param pulumi.Input[str] name: (Updatable) The display name of the Database Management private endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The OCIDs of the Network Security Groups to which the Database Management private endpoint belongs.
        :param pulumi.Input[str] private_ip: The IP addresses assigned to the Database Management private endpoint.
        :param pulumi.Input[str] state: The current lifecycle state of the Database Management private endpoint.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time the Database Managament private endpoint was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbManagementPrivateEndpointState.__new__(_DbManagementPrivateEndpointState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["description"] = description
        __props__.__dict__["is_cluster"] = is_cluster
        __props__.__dict__["name"] = name
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["vcn_id"] = vcn_id
        return DbManagementPrivateEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the private endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> pulumi.Output[bool]:
        """
        Specifies whether the Database Management private endpoint will be used for Oracle Databases in a cluster.
        """
        return pulumi.get(self, "is_cluster")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the Database Management private endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The OCIDs of the Network Security Groups to which the Database Management private endpoint belongs.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        The IP addresses assigned to the Database Management private endpoint.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the Database Management private endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the Database Managament private endpoint was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
        """
        return pulumi.get(self, "vcn_id")

