# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedDatabasesResetDatabaseParameterArgs', 'ManagedDatabasesResetDatabaseParameter']

@pulumi.input_type
class ManagedDatabasesResetDatabaseParameterArgs:
    def __init__(__self__, *,
                 credentials: pulumi.Input['ManagedDatabasesResetDatabaseParameterCredentialsArgs'],
                 managed_database_id: pulumi.Input[str],
                 parameters: pulumi.Input[Sequence[pulumi.Input[str]]],
                 scope: pulumi.Input[str]):
        """
        The set of arguments for constructing a ManagedDatabasesResetDatabaseParameter resource.
        :param pulumi.Input['ManagedDatabasesResetDatabaseParameterCredentialsArgs'] credentials: The database credentials used to perform management activity.
        :param pulumi.Input[str] managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] parameters: A list of database parameter names.
        :param pulumi.Input[str] scope: The clause used to specify when the parameter change takes effect.
               
               Use `MEMORY` to make the change in memory and ensure that it takes effect immediately. Use `SPFILE` to make the change in the server parameter file. The change takes effect when the database is next shut down and started up again. Use `BOTH` to make the change in memory and in the server parameter file. The change takes effect immediately and persists after the database is shut down and started up again.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ManagedDatabasesResetDatabaseParameterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            credentials=credentials,
            managed_database_id=managed_database_id,
            parameters=parameters,
            scope=scope,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             credentials: pulumi.Input['ManagedDatabasesResetDatabaseParameterCredentialsArgs'],
             managed_database_id: pulumi.Input[str],
             parameters: pulumi.Input[Sequence[pulumi.Input[str]]],
             scope: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("credentials", credentials)
        _setter("managed_database_id", managed_database_id)
        _setter("parameters", parameters)
        _setter("scope", scope)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input['ManagedDatabasesResetDatabaseParameterCredentialsArgs']:
        """
        The database credentials used to perform management activity.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input['ManagedDatabasesResetDatabaseParameterCredentialsArgs']):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        """
        return pulumi.get(self, "managed_database_id")

    @managed_database_id.setter
    def managed_database_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "managed_database_id", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of database parameter names.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[str]:
        """
        The clause used to specify when the parameter change takes effect.

        Use `MEMORY` to make the change in memory and ensure that it takes effect immediately. Use `SPFILE` to make the change in the server parameter file. The change takes effect when the database is next shut down and started up again. Use `BOTH` to make the change in memory and in the server parameter file. The change takes effect immediately and persists after the database is shut down and started up again.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[str]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _ManagedDatabasesResetDatabaseParameterState:
    def __init__(__self__, *,
                 credentials: Optional[pulumi.Input['ManagedDatabasesResetDatabaseParameterCredentialsArgs']] = None,
                 managed_database_id: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ManagedDatabasesResetDatabaseParameter resources.
        :param pulumi.Input['ManagedDatabasesResetDatabaseParameterCredentialsArgs'] credentials: The database credentials used to perform management activity.
        :param pulumi.Input[str] managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] parameters: A list of database parameter names.
        :param pulumi.Input[str] scope: The clause used to specify when the parameter change takes effect.
               
               Use `MEMORY` to make the change in memory and ensure that it takes effect immediately. Use `SPFILE` to make the change in the server parameter file. The change takes effect when the database is next shut down and started up again. Use `BOTH` to make the change in memory and in the server parameter file. The change takes effect immediately and persists after the database is shut down and started up again.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        _ManagedDatabasesResetDatabaseParameterState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            credentials=credentials,
            managed_database_id=managed_database_id,
            parameters=parameters,
            scope=scope,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             credentials: Optional[pulumi.Input['ManagedDatabasesResetDatabaseParameterCredentialsArgs']] = None,
             managed_database_id: Optional[pulumi.Input[str]] = None,
             parameters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             scope: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if credentials is not None:
            _setter("credentials", credentials)
        if managed_database_id is not None:
            _setter("managed_database_id", managed_database_id)
        if parameters is not None:
            _setter("parameters", parameters)
        if scope is not None:
            _setter("scope", scope)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['ManagedDatabasesResetDatabaseParameterCredentialsArgs']]:
        """
        The database credentials used to perform management activity.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['ManagedDatabasesResetDatabaseParameterCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        """
        return pulumi.get(self, "managed_database_id")

    @managed_database_id.setter
    def managed_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_database_id", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of database parameter names.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        The clause used to specify when the parameter change takes effect.

        Use `MEMORY` to make the change in memory and ensure that it takes effect immediately. Use `SPFILE` to make the change in the server parameter file. The change takes effect when the database is next shut down and started up again. Use `BOTH` to make the change in memory and in the server parameter file. The change takes effect immediately and persists after the database is shut down and started up again.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


class ManagedDatabasesResetDatabaseParameter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials: Optional[pulumi.Input[pulumi.InputType['ManagedDatabasesResetDatabaseParameterCredentialsArgs']]] = None,
                 managed_database_id: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Managed Databases Reset Database Parameter resource in Oracle Cloud Infrastructure Database Management service.

        Resets database parameter values to their default or startup values.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_databases_reset_database_parameter = oci.database_management.ManagedDatabasesResetDatabaseParameter("testManagedDatabasesResetDatabaseParameter",
            credentials=oci.database_management.ManagedDatabasesResetDatabaseParameterCredentialsArgs(
                password=var["managed_databases_reset_database_parameter_credentials_password"],
                role=var["managed_databases_reset_database_parameter_credentials_role"],
                secret_id=oci_vault_secret["test_secret"]["id"],
                user_name=oci_identity_user["test_user"]["name"],
            ),
            managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
            parameters=var["managed_databases_reset_database_parameter_parameters"],
            scope=var["managed_databases_reset_database_parameter_scope"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ManagedDatabasesResetDatabaseParameterCredentialsArgs']] credentials: The database credentials used to perform management activity.
        :param pulumi.Input[str] managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] parameters: A list of database parameter names.
        :param pulumi.Input[str] scope: The clause used to specify when the parameter change takes effect.
               
               Use `MEMORY` to make the change in memory and ensure that it takes effect immediately. Use `SPFILE` to make the change in the server parameter file. The change takes effect when the database is next shut down and started up again. Use `BOTH` to make the change in memory and in the server parameter file. The change takes effect immediately and persists after the database is shut down and started up again.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedDatabasesResetDatabaseParameterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Databases Reset Database Parameter resource in Oracle Cloud Infrastructure Database Management service.

        Resets database parameter values to their default or startup values.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_databases_reset_database_parameter = oci.database_management.ManagedDatabasesResetDatabaseParameter("testManagedDatabasesResetDatabaseParameter",
            credentials=oci.database_management.ManagedDatabasesResetDatabaseParameterCredentialsArgs(
                password=var["managed_databases_reset_database_parameter_credentials_password"],
                role=var["managed_databases_reset_database_parameter_credentials_role"],
                secret_id=oci_vault_secret["test_secret"]["id"],
                user_name=oci_identity_user["test_user"]["name"],
            ),
            managed_database_id=oci_database_management_managed_database["test_managed_database"]["id"],
            parameters=var["managed_databases_reset_database_parameter_parameters"],
            scope=var["managed_databases_reset_database_parameter_scope"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ManagedDatabasesResetDatabaseParameterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedDatabasesResetDatabaseParameterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ManagedDatabasesResetDatabaseParameterArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials: Optional[pulumi.Input[pulumi.InputType['ManagedDatabasesResetDatabaseParameterCredentialsArgs']]] = None,
                 managed_database_id: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedDatabasesResetDatabaseParameterArgs.__new__(ManagedDatabasesResetDatabaseParameterArgs)

            if credentials is not None and not isinstance(credentials, ManagedDatabasesResetDatabaseParameterCredentialsArgs):
                credentials = credentials or {}
                def _setter(key, value):
                    credentials[key] = value
                ManagedDatabasesResetDatabaseParameterCredentialsArgs._configure(_setter, **credentials)
            if credentials is None and not opts.urn:
                raise TypeError("Missing required property 'credentials'")
            __props__.__dict__["credentials"] = credentials
            if managed_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_database_id'")
            __props__.__dict__["managed_database_id"] = managed_database_id
            if parameters is None and not opts.urn:
                raise TypeError("Missing required property 'parameters'")
            __props__.__dict__["parameters"] = parameters
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
        super(ManagedDatabasesResetDatabaseParameter, __self__).__init__(
            'oci:DatabaseManagement/managedDatabasesResetDatabaseParameter:ManagedDatabasesResetDatabaseParameter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credentials: Optional[pulumi.Input[pulumi.InputType['ManagedDatabasesResetDatabaseParameterCredentialsArgs']]] = None,
            managed_database_id: Optional[pulumi.Input[str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            scope: Optional[pulumi.Input[str]] = None) -> 'ManagedDatabasesResetDatabaseParameter':
        """
        Get an existing ManagedDatabasesResetDatabaseParameter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ManagedDatabasesResetDatabaseParameterCredentialsArgs']] credentials: The database credentials used to perform management activity.
        :param pulumi.Input[str] managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] parameters: A list of database parameter names.
        :param pulumi.Input[str] scope: The clause used to specify when the parameter change takes effect.
               
               Use `MEMORY` to make the change in memory and ensure that it takes effect immediately. Use `SPFILE` to make the change in the server parameter file. The change takes effect when the database is next shut down and started up again. Use `BOTH` to make the change in memory and in the server parameter file. The change takes effect immediately and persists after the database is shut down and started up again.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedDatabasesResetDatabaseParameterState.__new__(_ManagedDatabasesResetDatabaseParameterState)

        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["managed_database_id"] = managed_database_id
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["scope"] = scope
        return ManagedDatabasesResetDatabaseParameter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Output['outputs.ManagedDatabasesResetDatabaseParameterCredentials']:
        """
        The database credentials used to perform management activity.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
        """
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of database parameter names.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[str]:
        """
        The clause used to specify when the parameter change takes effect.

        Use `MEMORY` to make the change in memory and ensure that it takes effect immediately. Use `SPFILE` to make the change in the server parameter file. The change takes effect when the database is next shut down and started up again. Use `BOTH` to make the change in memory and in the server parameter file. The change takes effect immediately and persists after the database is shut down and started up again.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scope")

