# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectionAdminCredentials',
    'ConnectionConnectDescriptor',
    'ConnectionPrivateEndpoint',
    'ConnectionReplicationCredentials',
    'ConnectionSshDetails',
    'ConnectionVaultDetails',
    'JobProgress',
    'JobProgressPhase',
    'JobProgressPhaseExtract',
    'JobProgressPhaseLogLocation',
    'JobUnsupportedObject',
    'MigrationAdvisorSettings',
    'MigrationDataTransferMediumDetails',
    'MigrationDataTransferMediumDetailsDatabaseLinkDetails',
    'MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucket',
    'MigrationDataTransferMediumDetailsObjectStorageDetails',
    'MigrationDataTransferMediumDetailsV2',
    'MigrationDataTransferMediumDetailsV2ObjectStorageBucket',
    'MigrationDatapumpSettings',
    'MigrationDatapumpSettingsDataPumpParameters',
    'MigrationDatapumpSettingsExportDirectoryObject',
    'MigrationDatapumpSettingsImportDirectoryObject',
    'MigrationDatapumpSettingsMetadataRemap',
    'MigrationDumpTransferDetails',
    'MigrationDumpTransferDetailsSource',
    'MigrationDumpTransferDetailsTarget',
    'MigrationExcludeObject',
    'MigrationGoldenGateDetails',
    'MigrationGoldenGateDetailsHub',
    'MigrationGoldenGateDetailsHubRestAdminCredentials',
    'MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentials',
    'MigrationGoldenGateDetailsHubSourceDbAdminCredentials',
    'MigrationGoldenGateDetailsHubTargetDbAdminCredentials',
    'MigrationGoldenGateDetailsSettings',
    'MigrationGoldenGateDetailsSettingsExtract',
    'MigrationGoldenGateDetailsSettingsReplicat',
    'MigrationGoldenGateServiceDetails',
    'MigrationGoldenGateServiceDetailsGgsDeployment',
    'MigrationGoldenGateServiceDetailsSettings',
    'MigrationGoldenGateServiceDetailsSettingsExtract',
    'MigrationGoldenGateServiceDetailsSettingsReplicat',
    'MigrationGoldenGateServiceDetailsSourceContainerDbCredentials',
    'MigrationGoldenGateServiceDetailsSourceDbCredentials',
    'MigrationGoldenGateServiceDetailsTargetDbCredentials',
    'MigrationIncludeObject',
    'MigrationVaultDetails',
    'GetAgentImagesAgentImageCollectionResult',
    'GetAgentImagesAgentImageCollectionItemResult',
    'GetAgentImagesFilterResult',
    'GetAgentsAgentCollectionResult',
    'GetAgentsAgentCollectionItemResult',
    'GetAgentsFilterResult',
    'GetConnectionAdminCredentialResult',
    'GetConnectionConnectDescriptorResult',
    'GetConnectionPrivateEndpointResult',
    'GetConnectionReplicationCredentialResult',
    'GetConnectionSshDetailResult',
    'GetConnectionVaultDetailResult',
    'GetConnectionsConnectionCollectionResult',
    'GetConnectionsConnectionCollectionItemResult',
    'GetConnectionsConnectionCollectionItemAdminCredentialResult',
    'GetConnectionsConnectionCollectionItemConnectDescriptorResult',
    'GetConnectionsConnectionCollectionItemPrivateEndpointResult',
    'GetConnectionsConnectionCollectionItemReplicationCredentialResult',
    'GetConnectionsConnectionCollectionItemSshDetailResult',
    'GetConnectionsConnectionCollectionItemVaultDetailResult',
    'GetConnectionsFilterResult',
    'GetJobAdvisorReportReportLocationDetailResult',
    'GetJobAdvisorReportReportLocationDetailObjectStorageDetailResult',
    'GetJobOutputItemResult',
    'GetMigrationAdvisorSettingResult',
    'GetMigrationDataTransferMediumDetailResult',
    'GetMigrationDataTransferMediumDetailDatabaseLinkDetailResult',
    'GetMigrationDataTransferMediumDetailDatabaseLinkDetailWalletBucketResult',
    'GetMigrationDataTransferMediumDetailObjectStorageDetailResult',
    'GetMigrationDataTransferMediumDetailsV2Result',
    'GetMigrationDataTransferMediumDetailsV2ObjectStorageBucketResult',
    'GetMigrationDatapumpSettingResult',
    'GetMigrationDatapumpSettingDataPumpParameterResult',
    'GetMigrationDatapumpSettingExportDirectoryObjectResult',
    'GetMigrationDatapumpSettingImportDirectoryObjectResult',
    'GetMigrationDatapumpSettingMetadataRemapResult',
    'GetMigrationDumpTransferDetailResult',
    'GetMigrationDumpTransferDetailSourceResult',
    'GetMigrationDumpTransferDetailTargetResult',
    'GetMigrationExcludeObjectResult',
    'GetMigrationGoldenGateDetailResult',
    'GetMigrationGoldenGateDetailHubResult',
    'GetMigrationGoldenGateDetailHubRestAdminCredentialResult',
    'GetMigrationGoldenGateDetailHubSourceContainerDbAdminCredentialResult',
    'GetMigrationGoldenGateDetailHubSourceDbAdminCredentialResult',
    'GetMigrationGoldenGateDetailHubTargetDbAdminCredentialResult',
    'GetMigrationGoldenGateDetailSettingResult',
    'GetMigrationGoldenGateDetailSettingExtractResult',
    'GetMigrationGoldenGateDetailSettingReplicatResult',
    'GetMigrationGoldenGateServiceDetailResult',
    'GetMigrationGoldenGateServiceDetailGgsDeploymentResult',
    'GetMigrationGoldenGateServiceDetailSettingResult',
    'GetMigrationGoldenGateServiceDetailSettingExtractResult',
    'GetMigrationGoldenGateServiceDetailSettingReplicatResult',
    'GetMigrationGoldenGateServiceDetailSourceContainerDbCredentialResult',
    'GetMigrationGoldenGateServiceDetailSourceDbCredentialResult',
    'GetMigrationGoldenGateServiceDetailTargetDbCredentialResult',
    'GetMigrationIncludeObjectResult',
    'GetMigrationObjectTypesFilterResult',
    'GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionResult',
    'GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionItemResult',
    'GetMigrationVaultDetailResult',
    'GetMigrationsFilterResult',
    'GetMigrationsMigrationCollectionResult',
    'GetMigrationsMigrationCollectionItemResult',
    'GetMigrationsMigrationCollectionItemAdvisorSettingResult',
    'GetMigrationsMigrationCollectionItemDataTransferMediumDetailResult',
    'GetMigrationsMigrationCollectionItemDataTransferMediumDetailDatabaseLinkDetailResult',
    'GetMigrationsMigrationCollectionItemDataTransferMediumDetailDatabaseLinkDetailWalletBucketResult',
    'GetMigrationsMigrationCollectionItemDataTransferMediumDetailObjectStorageDetailResult',
    'GetMigrationsMigrationCollectionItemDataTransferMediumDetailsV2Result',
    'GetMigrationsMigrationCollectionItemDataTransferMediumDetailsV2ObjectStorageBucketResult',
    'GetMigrationsMigrationCollectionItemDatapumpSettingResult',
    'GetMigrationsMigrationCollectionItemDatapumpSettingDataPumpParameterResult',
    'GetMigrationsMigrationCollectionItemDatapumpSettingExportDirectoryObjectResult',
    'GetMigrationsMigrationCollectionItemDatapumpSettingImportDirectoryObjectResult',
    'GetMigrationsMigrationCollectionItemDatapumpSettingMetadataRemapResult',
    'GetMigrationsMigrationCollectionItemDumpTransferDetailResult',
    'GetMigrationsMigrationCollectionItemDumpTransferDetailSourceResult',
    'GetMigrationsMigrationCollectionItemDumpTransferDetailTargetResult',
    'GetMigrationsMigrationCollectionItemExcludeObjectResult',
    'GetMigrationsMigrationCollectionItemGoldenGateDetailResult',
    'GetMigrationsMigrationCollectionItemGoldenGateDetailHubResult',
    'GetMigrationsMigrationCollectionItemGoldenGateDetailHubRestAdminCredentialResult',
    'GetMigrationsMigrationCollectionItemGoldenGateDetailHubSourceContainerDbAdminCredentialResult',
    'GetMigrationsMigrationCollectionItemGoldenGateDetailHubSourceDbAdminCredentialResult',
    'GetMigrationsMigrationCollectionItemGoldenGateDetailHubTargetDbAdminCredentialResult',
    'GetMigrationsMigrationCollectionItemGoldenGateDetailSettingResult',
    'GetMigrationsMigrationCollectionItemGoldenGateDetailSettingExtractResult',
    'GetMigrationsMigrationCollectionItemGoldenGateDetailSettingReplicatResult',
    'GetMigrationsMigrationCollectionItemGoldenGateServiceDetailResult',
    'GetMigrationsMigrationCollectionItemGoldenGateServiceDetailGgsDeploymentResult',
    'GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingResult',
    'GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingExtractResult',
    'GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingReplicatResult',
    'GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSourceContainerDbCredentialResult',
    'GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSourceDbCredentialResult',
    'GetMigrationsMigrationCollectionItemGoldenGateServiceDetailTargetDbCredentialResult',
    'GetMigrationsMigrationCollectionItemIncludeObjectResult',
    'GetMigrationsMigrationCollectionItemVaultDetailResult',
]

@pulumi.output_type
class ConnectionAdminCredentials(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: (Updatable) Administrator password
        :param str username: (Updatable) Administrator username
        """
        ConnectionAdminCredentials._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        (Updatable) Administrator password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        (Updatable) Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionConnectDescriptor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectString":
            suggest = "connect_string"
        elif key == "databaseServiceName":
            suggest = "database_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionConnectDescriptor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionConnectDescriptor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionConnectDescriptor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_string: Optional[str] = None,
                 database_service_name: Optional[str] = None,
                 host: Optional[str] = None,
                 port: Optional[int] = None):
        """
        :param str connect_string: (Updatable) Connect String. Required if no host, port nor databaseServiceName were specified. If a Private Endpoint was specified in the Connection, the host entry should be a valid IP address. Supported formats: Easy connect: <host>:<port>/<db_service_name> Long format: (description= (address=(port=<port>)(host=<host>))(connect_data=(service_name=<db_service_name>)))
        :param str database_service_name: (Updatable) Database service name. Required if no connectString was specified.
        :param str host: (Updatable) Name of the host the SSH key is valid for.
        :param int port: (Updatable) Port of the connect descriptor. Required if no connectString was specified.
        """
        ConnectionConnectDescriptor._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            connect_string=connect_string,
            database_service_name=database_service_name,
            host=host,
            port=port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             connect_string: Optional[str] = None,
             database_service_name: Optional[str] = None,
             host: Optional[str] = None,
             port: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if connect_string is not None:
            _setter("connect_string", connect_string)
        if database_service_name is not None:
            _setter("database_service_name", database_service_name)
        if host is not None:
            _setter("host", host)
        if port is not None:
            _setter("port", port)

    @property
    @pulumi.getter(name="connectString")
    def connect_string(self) -> Optional[str]:
        """
        (Updatable) Connect String. Required if no host, port nor databaseServiceName were specified. If a Private Endpoint was specified in the Connection, the host entry should be a valid IP address. Supported formats: Easy connect: <host>:<port>/<db_service_name> Long format: (description= (address=(port=<port>)(host=<host>))(connect_data=(service_name=<db_service_name>)))
        """
        return pulumi.get(self, "connect_string")

    @property
    @pulumi.getter(name="databaseServiceName")
    def database_service_name(self) -> Optional[str]:
        """
        (Updatable) Database service name. Required if no connectString was specified.
        """
        return pulumi.get(self, "database_service_name")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        (Updatable) Name of the host the SSH key is valid for.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        (Updatable) Port of the connect descriptor. Required if no connectString was specified.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ConnectionPrivateEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vcnId":
            suggest = "vcn_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionPrivateEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionPrivateEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionPrivateEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: str,
                 subnet_id: str,
                 vcn_id: str,
                 id: Optional[str] = None):
        """
        :param str compartment_id: (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        :param str subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer's subnet where the private endpoint VNIC will reside.
        :param str vcn_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN where the Private Endpoint will be bound to.
        :param str id: [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a previously created Private Endpoint.
        """
        ConnectionPrivateEndpoint._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            subnet_id=subnet_id,
            vcn_id=vcn_id,
            id=id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             subnet_id: str,
             vcn_id: str,
             id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("subnet_id", subnet_id)
        _setter("vcn_id", vcn_id)
        if id is not None:
            _setter("id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer's subnet where the private endpoint VNIC will reside.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN where the Private Endpoint will be bound to.
        """
        return pulumi.get(self, "vcn_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a previously created Private Endpoint.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ConnectionReplicationCredentials(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: (Updatable) Administrator password
        :param str username: (Updatable) Administrator username
        """
        ConnectionReplicationCredentials._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        (Updatable) Administrator password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        (Updatable) Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionSshDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sudoLocation":
            suggest = "sudo_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionSshDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionSshDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionSshDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: str,
                 sshkey: str,
                 user: str,
                 sudo_location: Optional[str] = None):
        """
        :param str host: (Updatable) Name of the host the SSH key is valid for.
        :param str sshkey: (Updatable) Private SSH key string.
        :param str user: (Updatable) SSH user
        :param str sudo_location: (Updatable) Sudo location
        """
        ConnectionSshDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host=host,
            sshkey=sshkey,
            user=user,
            sudo_location=sudo_location,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host: str,
             sshkey: str,
             user: str,
             sudo_location: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("host", host)
        _setter("sshkey", sshkey)
        _setter("user", user)
        if sudo_location is not None:
            _setter("sudo_location", sudo_location)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        (Updatable) Name of the host the SSH key is valid for.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def sshkey(self) -> str:
        """
        (Updatable) Private SSH key string.
        """
        return pulumi.get(self, "sshkey")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        (Updatable) SSH user
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="sudoLocation")
    def sudo_location(self) -> Optional[str]:
        """
        (Updatable) Sudo location
        """
        return pulumi.get(self, "sudo_location")


@pulumi.output_type
class ConnectionVaultDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"
        elif key == "keyId":
            suggest = "key_id"
        elif key == "vaultId":
            suggest = "vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionVaultDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionVaultDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionVaultDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: str,
                 key_id: str,
                 vault_id: str):
        """
        :param str compartment_id: (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        :param str key_id: (Updatable) OCID of the vault encryption key
        :param str vault_id: (Updatable) OCID of the vault 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ConnectionVaultDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            key_id=key_id,
            vault_id=vault_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             key_id: str,
             vault_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("key_id", key_id)
        _setter("vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        (Updatable) OCID of the vault encryption key
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        (Updatable) OCID of the vault 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class JobProgress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentPhase":
            suggest = "current_phase"
        elif key == "currentStatus":
            suggest = "current_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobProgress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobProgress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobProgress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_phase: Optional[str] = None,
                 current_status: Optional[str] = None,
                 phases: Optional[Sequence['outputs.JobProgressPhase']] = None):
        """
        :param str current_phase: Current phase of the job.
        :param str current_status: Current status of the job.
        :param Sequence['JobProgressPhaseArgs'] phases: List of phase status for the job.
        """
        JobProgress._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            current_phase=current_phase,
            current_status=current_status,
            phases=phases,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             current_phase: Optional[str] = None,
             current_status: Optional[str] = None,
             phases: Optional[Sequence['outputs.JobProgressPhase']] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if current_phase is not None:
            _setter("current_phase", current_phase)
        if current_status is not None:
            _setter("current_status", current_status)
        if phases is not None:
            _setter("phases", phases)

    @property
    @pulumi.getter(name="currentPhase")
    def current_phase(self) -> Optional[str]:
        """
        Current phase of the job.
        """
        return pulumi.get(self, "current_phase")

    @property
    @pulumi.getter(name="currentStatus")
    def current_status(self) -> Optional[str]:
        """
        Current status of the job.
        """
        return pulumi.get(self, "current_status")

    @property
    @pulumi.getter
    def phases(self) -> Optional[Sequence['outputs.JobProgressPhase']]:
        """
        List of phase status for the job.
        """
        return pulumi.get(self, "phases")


@pulumi.output_type
class JobProgressPhase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInMs":
            suggest = "duration_in_ms"
        elif key == "isAdvisorReportAvailable":
            suggest = "is_advisor_report_available"
        elif key == "logLocations":
            suggest = "log_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobProgressPhase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobProgressPhase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobProgressPhase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[str] = None,
                 duration_in_ms: Optional[int] = None,
                 extracts: Optional[Sequence['outputs.JobProgressPhaseExtract']] = None,
                 is_advisor_report_available: Optional[bool] = None,
                 issue: Optional[str] = None,
                 log_locations: Optional[Sequence['outputs.JobProgressPhaseLogLocation']] = None,
                 name: Optional[str] = None,
                 progress: Optional[int] = None,
                 status: Optional[str] = None):
        """
        :param str action: The text describing the action required to fix the issue
        :param int duration_in_ms: Duration of the phase in milliseconds
        :param Sequence['JobProgressPhaseExtractArgs'] extracts: Summary of phase status results.
        :param bool is_advisor_report_available: True if a Pre-Migration Advisor report is available for this phase. False or null if no report is available.
        :param str issue: The text describing the root cause of the reported issue
        :param Sequence['JobProgressPhaseLogLocationArgs'] log_locations: Details to access log file in the specified Object Storage bucket, if any.
        :param str name: Phase name
        :param int progress: Percent progress of job phase.
        :param str status: Phase status
        """
        JobProgressPhase._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            duration_in_ms=duration_in_ms,
            extracts=extracts,
            is_advisor_report_available=is_advisor_report_available,
            issue=issue,
            log_locations=log_locations,
            name=name,
            progress=progress,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: Optional[str] = None,
             duration_in_ms: Optional[int] = None,
             extracts: Optional[Sequence['outputs.JobProgressPhaseExtract']] = None,
             is_advisor_report_available: Optional[bool] = None,
             issue: Optional[str] = None,
             log_locations: Optional[Sequence['outputs.JobProgressPhaseLogLocation']] = None,
             name: Optional[str] = None,
             progress: Optional[int] = None,
             status: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if action is not None:
            _setter("action", action)
        if duration_in_ms is not None:
            _setter("duration_in_ms", duration_in_ms)
        if extracts is not None:
            _setter("extracts", extracts)
        if is_advisor_report_available is not None:
            _setter("is_advisor_report_available", is_advisor_report_available)
        if issue is not None:
            _setter("issue", issue)
        if log_locations is not None:
            _setter("log_locations", log_locations)
        if name is not None:
            _setter("name", name)
        if progress is not None:
            _setter("progress", progress)
        if status is not None:
            _setter("status", status)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The text describing the action required to fix the issue
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="durationInMs")
    def duration_in_ms(self) -> Optional[int]:
        """
        Duration of the phase in milliseconds
        """
        return pulumi.get(self, "duration_in_ms")

    @property
    @pulumi.getter
    def extracts(self) -> Optional[Sequence['outputs.JobProgressPhaseExtract']]:
        """
        Summary of phase status results.
        """
        return pulumi.get(self, "extracts")

    @property
    @pulumi.getter(name="isAdvisorReportAvailable")
    def is_advisor_report_available(self) -> Optional[bool]:
        """
        True if a Pre-Migration Advisor report is available for this phase. False or null if no report is available.
        """
        return pulumi.get(self, "is_advisor_report_available")

    @property
    @pulumi.getter
    def issue(self) -> Optional[str]:
        """
        The text describing the root cause of the reported issue
        """
        return pulumi.get(self, "issue")

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Optional[Sequence['outputs.JobProgressPhaseLogLocation']]:
        """
        Details to access log file in the specified Object Storage bucket, if any.
        """
        return pulumi.get(self, "log_locations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Phase name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def progress(self) -> Optional[int]:
        """
        Percent progress of job phase.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Phase status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class JobProgressPhaseExtract(dict):
    def __init__(__self__, *,
                 message: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str message: Message in entry.
        :param str type: Type of unsupported object
        """
        JobProgressPhaseExtract._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            message=message,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             message: Optional[str] = None,
             type: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if message is not None:
            _setter("message", message)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Message in entry.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of unsupported object
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobProgressPhaseLogLocation(dict):
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None):
        """
        :param str bucket: Name of the bucket containing the log file.
        :param str namespace: Object Storage namespace.
        :param str object: Name of the object (regular expression is allowed)
        """
        JobProgressPhaseLogLocation._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            object=object,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: Optional[str] = None,
             namespace: Optional[str] = None,
             object: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if bucket is not None:
            _setter("bucket", bucket)
        if namespace is not None:
            _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Name of the bucket containing the log file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class JobUnsupportedObject(dict):
    def __init__(__self__, *,
                 object: Optional[str] = None,
                 owner: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str object: Name of the object (regular expression is allowed)
        :param str owner: Owner of the object (regular expression is allowed)
        :param str type: Type of unsupported object
        """
        JobUnsupportedObject._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            object=object,
            owner=owner,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             object: Optional[str] = None,
             owner: Optional[str] = None,
             type: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if object is not None:
            _setter("object", object)
        if owner is not None:
            _setter("owner", owner)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def owner(self) -> Optional[str]:
        """
        Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of unsupported object
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MigrationAdvisorSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isIgnoreErrors":
            suggest = "is_ignore_errors"
        elif key == "isSkipAdvisor":
            suggest = "is_skip_advisor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationAdvisorSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationAdvisorSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationAdvisorSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_ignore_errors: Optional[bool] = None,
                 is_skip_advisor: Optional[bool] = None):
        """
        :param bool is_ignore_errors: (Updatable) True to not interrupt migration execution due to Pre-Migration Advisor errors. Default is false.
        :param bool is_skip_advisor: (Updatable) True to skip the Pre-Migration Advisor execution. Default is false.
        """
        MigrationAdvisorSettings._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_ignore_errors=is_ignore_errors,
            is_skip_advisor=is_skip_advisor,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_ignore_errors: Optional[bool] = None,
             is_skip_advisor: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if is_ignore_errors is not None:
            _setter("is_ignore_errors", is_ignore_errors)
        if is_skip_advisor is not None:
            _setter("is_skip_advisor", is_skip_advisor)

    @property
    @pulumi.getter(name="isIgnoreErrors")
    def is_ignore_errors(self) -> Optional[bool]:
        """
        (Updatable) True to not interrupt migration execution due to Pre-Migration Advisor errors. Default is false.
        """
        return pulumi.get(self, "is_ignore_errors")

    @property
    @pulumi.getter(name="isSkipAdvisor")
    def is_skip_advisor(self) -> Optional[bool]:
        """
        (Updatable) True to skip the Pre-Migration Advisor execution. Default is false.
        """
        return pulumi.get(self, "is_skip_advisor")


@pulumi.output_type
class MigrationDataTransferMediumDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseLinkDetails":
            suggest = "database_link_details"
        elif key == "objectStorageDetails":
            suggest = "object_storage_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationDataTransferMediumDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationDataTransferMediumDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationDataTransferMediumDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_link_details: Optional['outputs.MigrationDataTransferMediumDetailsDatabaseLinkDetails'] = None,
                 object_storage_details: Optional['outputs.MigrationDataTransferMediumDetailsObjectStorageDetails'] = None):
        """
        :param 'MigrationDataTransferMediumDetailsDatabaseLinkDetailsArgs' database_link_details: (Updatable) Optional details for creating a network database link from Oracle Cloud Infrastructure database to on-premise database.
        :param 'MigrationDataTransferMediumDetailsObjectStorageDetailsArgs' object_storage_details: (Updatable) In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        MigrationDataTransferMediumDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            database_link_details=database_link_details,
            object_storage_details=object_storage_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             database_link_details: Optional['outputs.MigrationDataTransferMediumDetailsDatabaseLinkDetails'] = None,
             object_storage_details: Optional['outputs.MigrationDataTransferMediumDetailsObjectStorageDetails'] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if database_link_details is not None:
            _setter("database_link_details", database_link_details)
        if object_storage_details is not None:
            _setter("object_storage_details", object_storage_details)

    @property
    @pulumi.getter(name="databaseLinkDetails")
    def database_link_details(self) -> Optional['outputs.MigrationDataTransferMediumDetailsDatabaseLinkDetails']:
        """
        (Updatable) Optional details for creating a network database link from Oracle Cloud Infrastructure database to on-premise database.
        """
        return pulumi.get(self, "database_link_details")

    @property
    @pulumi.getter(name="objectStorageDetails")
    def object_storage_details(self) -> Optional['outputs.MigrationDataTransferMediumDetailsObjectStorageDetails']:
        """
        (Updatable) In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        return pulumi.get(self, "object_storage_details")


@pulumi.output_type
class MigrationDataTransferMediumDetailsDatabaseLinkDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "walletBucket":
            suggest = "wallet_bucket"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationDataTransferMediumDetailsDatabaseLinkDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationDataTransferMediumDetailsDatabaseLinkDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationDataTransferMediumDetailsDatabaseLinkDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 wallet_bucket: Optional['outputs.MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucket'] = None):
        """
        :param str name: (Updatable) Name of directory object in database
        :param 'MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucketArgs' wallet_bucket: (Updatable) In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        MigrationDataTransferMediumDetailsDatabaseLinkDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            wallet_bucket=wallet_bucket,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             wallet_bucket: Optional['outputs.MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucket'] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if name is not None:
            _setter("name", name)
        if wallet_bucket is not None:
            _setter("wallet_bucket", wallet_bucket)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) Name of directory object in database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="walletBucket")
    def wallet_bucket(self) -> Optional['outputs.MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucket']:
        """
        (Updatable) In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        return pulumi.get(self, "wallet_bucket")


@pulumi.output_type
class MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucket(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str):
        """
        :param str bucket: (Updatable) Bucket name.
        :param str namespace: (Updatable) Namespace name of the object store bucket.
        """
        MigrationDataTransferMediumDetailsDatabaseLinkDetailsWalletBucket._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        (Updatable) Bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        (Updatable) Namespace name of the object store bucket.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class MigrationDataTransferMediumDetailsObjectStorageDetails(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str):
        """
        :param str bucket: (Updatable) Bucket name.
        :param str namespace: (Updatable) Namespace name of the object store bucket.
        """
        MigrationDataTransferMediumDetailsObjectStorageDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        (Updatable) Bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        (Updatable) Namespace name of the object store bucket.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class MigrationDataTransferMediumDetailsV2(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "objectStorageBucket":
            suggest = "object_storage_bucket"
        elif key == "secretAccessKey":
            suggest = "secret_access_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationDataTransferMediumDetailsV2. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationDataTransferMediumDetailsV2.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationDataTransferMediumDetailsV2.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 access_key_id: Optional[str] = None,
                 name: Optional[str] = None,
                 object_storage_bucket: Optional['outputs.MigrationDataTransferMediumDetailsV2ObjectStorageBucket'] = None,
                 region: Optional[str] = None,
                 secret_access_key: Optional[str] = None):
        """
        :param str type: (Updatable) Migration type.
        :param str name: (Updatable) Name of directory object in database
        """
        MigrationDataTransferMediumDetailsV2._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            access_key_id=access_key_id,
            name=name,
            object_storage_bucket=object_storage_bucket,
            region=region,
            secret_access_key=secret_access_key,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: str,
             access_key_id: Optional[str] = None,
             name: Optional[str] = None,
             object_storage_bucket: Optional['outputs.MigrationDataTransferMediumDetailsV2ObjectStorageBucket'] = None,
             region: Optional[str] = None,
             secret_access_key: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("type", type)
        if access_key_id is not None:
            _setter("access_key_id", access_key_id)
        if name is not None:
            _setter("name", name)
        if object_storage_bucket is not None:
            _setter("object_storage_bucket", object_storage_bucket)
        if region is not None:
            _setter("region", region)
        if secret_access_key is not None:
            _setter("secret_access_key", secret_access_key)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (Updatable) Migration type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[str]:
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) Name of directory object in database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectStorageBucket")
    def object_storage_bucket(self) -> Optional['outputs.MigrationDataTransferMediumDetailsV2ObjectStorageBucket']:
        return pulumi.get(self, "object_storage_bucket")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[str]:
        return pulumi.get(self, "secret_access_key")


@pulumi.output_type
class MigrationDataTransferMediumDetailsV2ObjectStorageBucket(dict):
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 namespace: Optional[str] = None):
        """
        :param str bucket: (Updatable) Bucket name.
        :param str namespace: (Updatable) Namespace name of the object store bucket.
        """
        MigrationDataTransferMediumDetailsV2ObjectStorageBucket._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: Optional[str] = None,
             namespace: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if bucket is not None:
            _setter("bucket", bucket)
        if namespace is not None:
            _setter("namespace", namespace)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        (Updatable) Bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        (Updatable) Namespace name of the object store bucket.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class MigrationDatapumpSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataPumpParameters":
            suggest = "data_pump_parameters"
        elif key == "exportDirectoryObject":
            suggest = "export_directory_object"
        elif key == "importDirectoryObject":
            suggest = "import_directory_object"
        elif key == "jobMode":
            suggest = "job_mode"
        elif key == "metadataRemaps":
            suggest = "metadata_remaps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationDatapumpSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationDatapumpSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationDatapumpSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_pump_parameters: Optional['outputs.MigrationDatapumpSettingsDataPumpParameters'] = None,
                 export_directory_object: Optional['outputs.MigrationDatapumpSettingsExportDirectoryObject'] = None,
                 import_directory_object: Optional['outputs.MigrationDatapumpSettingsImportDirectoryObject'] = None,
                 job_mode: Optional[str] = None,
                 metadata_remaps: Optional[Sequence['outputs.MigrationDatapumpSettingsMetadataRemap']] = None):
        """
        :param 'MigrationDatapumpSettingsDataPumpParametersArgs' data_pump_parameters: (Updatable) Optional parameters for Data Pump Export and Import. Refer to [Configuring Optional Initial Load Advanced Settings](https://docs.us.oracle.com/en/cloud/paas/database-migration/dmsus/working-migration-resources.html#GUID-24BD3054-FDF8-48FF-8492-636C1D4B71ED)
        :param 'MigrationDatapumpSettingsExportDirectoryObjectArgs' export_directory_object: (Updatable) Directory object details, used to define either import or export directory objects in Data Pump Settings. Import directory is required for Non-Autonomous target connections. If specified for an autonomous target, it will show an error. Export directory will error if there are database link details specified.
        :param 'MigrationDatapumpSettingsImportDirectoryObjectArgs' import_directory_object: (Updatable) Directory object details, used to define either import or export directory objects in Data Pump Settings. Import directory is required for Non-Autonomous target connections. If specified for an autonomous target, it will show an error. Export directory will error if there are database link details specified.
        :param str job_mode: (Updatable) Data Pump job mode. Refer to [link text](https://docs.oracle.com/en/database/oracle/oracle-database/19/sutil/oracle-data-pump-export-utility.html#GUID-8E497131-6B9B-4CC8-AA50-35F480CAC2C4)
        :param Sequence['MigrationDatapumpSettingsMetadataRemapArgs'] metadata_remaps: (Updatable) Defines remapping to be applied to objects as they are processed. Refer to [DATA_REMAP](https://docs.oracle.com/en/database/oracle/oracle-database/19/arpls/DBMS_DATAPUMP.html#GUID-E75AAE6F-4EA6-4737-A752-6B62F5E9D460)
        """
        MigrationDatapumpSettings._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            data_pump_parameters=data_pump_parameters,
            export_directory_object=export_directory_object,
            import_directory_object=import_directory_object,
            job_mode=job_mode,
            metadata_remaps=metadata_remaps,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             data_pump_parameters: Optional['outputs.MigrationDatapumpSettingsDataPumpParameters'] = None,
             export_directory_object: Optional['outputs.MigrationDatapumpSettingsExportDirectoryObject'] = None,
             import_directory_object: Optional['outputs.MigrationDatapumpSettingsImportDirectoryObject'] = None,
             job_mode: Optional[str] = None,
             metadata_remaps: Optional[Sequence['outputs.MigrationDatapumpSettingsMetadataRemap']] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if data_pump_parameters is not None:
            _setter("data_pump_parameters", data_pump_parameters)
        if export_directory_object is not None:
            _setter("export_directory_object", export_directory_object)
        if import_directory_object is not None:
            _setter("import_directory_object", import_directory_object)
        if job_mode is not None:
            _setter("job_mode", job_mode)
        if metadata_remaps is not None:
            _setter("metadata_remaps", metadata_remaps)

    @property
    @pulumi.getter(name="dataPumpParameters")
    def data_pump_parameters(self) -> Optional['outputs.MigrationDatapumpSettingsDataPumpParameters']:
        """
        (Updatable) Optional parameters for Data Pump Export and Import. Refer to [Configuring Optional Initial Load Advanced Settings](https://docs.us.oracle.com/en/cloud/paas/database-migration/dmsus/working-migration-resources.html#GUID-24BD3054-FDF8-48FF-8492-636C1D4B71ED)
        """
        return pulumi.get(self, "data_pump_parameters")

    @property
    @pulumi.getter(name="exportDirectoryObject")
    def export_directory_object(self) -> Optional['outputs.MigrationDatapumpSettingsExportDirectoryObject']:
        """
        (Updatable) Directory object details, used to define either import or export directory objects in Data Pump Settings. Import directory is required for Non-Autonomous target connections. If specified for an autonomous target, it will show an error. Export directory will error if there are database link details specified.
        """
        return pulumi.get(self, "export_directory_object")

    @property
    @pulumi.getter(name="importDirectoryObject")
    def import_directory_object(self) -> Optional['outputs.MigrationDatapumpSettingsImportDirectoryObject']:
        """
        (Updatable) Directory object details, used to define either import or export directory objects in Data Pump Settings. Import directory is required for Non-Autonomous target connections. If specified for an autonomous target, it will show an error. Export directory will error if there are database link details specified.
        """
        return pulumi.get(self, "import_directory_object")

    @property
    @pulumi.getter(name="jobMode")
    def job_mode(self) -> Optional[str]:
        """
        (Updatable) Data Pump job mode. Refer to [link text](https://docs.oracle.com/en/database/oracle/oracle-database/19/sutil/oracle-data-pump-export-utility.html#GUID-8E497131-6B9B-4CC8-AA50-35F480CAC2C4)
        """
        return pulumi.get(self, "job_mode")

    @property
    @pulumi.getter(name="metadataRemaps")
    def metadata_remaps(self) -> Optional[Sequence['outputs.MigrationDatapumpSettingsMetadataRemap']]:
        """
        (Updatable) Defines remapping to be applied to objects as they are processed. Refer to [DATA_REMAP](https://docs.oracle.com/en/database/oracle/oracle-database/19/arpls/DBMS_DATAPUMP.html#GUID-E75AAE6F-4EA6-4737-A752-6B62F5E9D460)
        """
        return pulumi.get(self, "metadata_remaps")


@pulumi.output_type
class MigrationDatapumpSettingsDataPumpParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeParameters":
            suggest = "exclude_parameters"
        elif key == "exportParallelismDegree":
            suggest = "export_parallelism_degree"
        elif key == "importParallelismDegree":
            suggest = "import_parallelism_degree"
        elif key == "isCluster":
            suggest = "is_cluster"
        elif key == "tableExistsAction":
            suggest = "table_exists_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationDatapumpSettingsDataPumpParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationDatapumpSettingsDataPumpParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationDatapumpSettingsDataPumpParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 estimate: Optional[str] = None,
                 exclude_parameters: Optional[Sequence[str]] = None,
                 export_parallelism_degree: Optional[int] = None,
                 import_parallelism_degree: Optional[int] = None,
                 is_cluster: Optional[bool] = None,
                 table_exists_action: Optional[str] = None):
        """
        :param str estimate: (Updatable) Estimate size of dumps that will be generated.
        :param Sequence[str] exclude_parameters: (Updatable) Exclude paratemers for Export and Import.
        :param int export_parallelism_degree: (Updatable) Maximum number of worker processes that can be used for a Data Pump Export job.
        :param int import_parallelism_degree: (Updatable) Maximum number of worker processes that can be used for a Data Pump Import job. For an Autonomous Database, ODMS will automatically query its CPU core count and set this property.
        :param bool is_cluster: (Updatable) Set to false to force Data Pump worker process to run on one instance.
        :param str table_exists_action: (Updatable) IMPORT: Specifies the action to be performed when data is loaded into a preexisting table.
        """
        MigrationDatapumpSettingsDataPumpParameters._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            estimate=estimate,
            exclude_parameters=exclude_parameters,
            export_parallelism_degree=export_parallelism_degree,
            import_parallelism_degree=import_parallelism_degree,
            is_cluster=is_cluster,
            table_exists_action=table_exists_action,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             estimate: Optional[str] = None,
             exclude_parameters: Optional[Sequence[str]] = None,
             export_parallelism_degree: Optional[int] = None,
             import_parallelism_degree: Optional[int] = None,
             is_cluster: Optional[bool] = None,
             table_exists_action: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if estimate is not None:
            _setter("estimate", estimate)
        if exclude_parameters is not None:
            _setter("exclude_parameters", exclude_parameters)
        if export_parallelism_degree is not None:
            _setter("export_parallelism_degree", export_parallelism_degree)
        if import_parallelism_degree is not None:
            _setter("import_parallelism_degree", import_parallelism_degree)
        if is_cluster is not None:
            _setter("is_cluster", is_cluster)
        if table_exists_action is not None:
            _setter("table_exists_action", table_exists_action)

    @property
    @pulumi.getter
    def estimate(self) -> Optional[str]:
        """
        (Updatable) Estimate size of dumps that will be generated.
        """
        return pulumi.get(self, "estimate")

    @property
    @pulumi.getter(name="excludeParameters")
    def exclude_parameters(self) -> Optional[Sequence[str]]:
        """
        (Updatable) Exclude paratemers for Export and Import.
        """
        return pulumi.get(self, "exclude_parameters")

    @property
    @pulumi.getter(name="exportParallelismDegree")
    def export_parallelism_degree(self) -> Optional[int]:
        """
        (Updatable) Maximum number of worker processes that can be used for a Data Pump Export job.
        """
        return pulumi.get(self, "export_parallelism_degree")

    @property
    @pulumi.getter(name="importParallelismDegree")
    def import_parallelism_degree(self) -> Optional[int]:
        """
        (Updatable) Maximum number of worker processes that can be used for a Data Pump Import job. For an Autonomous Database, ODMS will automatically query its CPU core count and set this property.
        """
        return pulumi.get(self, "import_parallelism_degree")

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> Optional[bool]:
        """
        (Updatable) Set to false to force Data Pump worker process to run on one instance.
        """
        return pulumi.get(self, "is_cluster")

    @property
    @pulumi.getter(name="tableExistsAction")
    def table_exists_action(self) -> Optional[str]:
        """
        (Updatable) IMPORT: Specifies the action to be performed when data is loaded into a preexisting table.
        """
        return pulumi.get(self, "table_exists_action")


@pulumi.output_type
class MigrationDatapumpSettingsExportDirectoryObject(dict):
    def __init__(__self__, *,
                 name: str,
                 path: Optional[str] = None):
        """
        :param str name: (Updatable) Name of directory object in database
        :param str path: (Updatable) Absolute path of directory on database server
        """
        MigrationDatapumpSettingsExportDirectoryObject._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            path=path,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             path: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        if path is not None:
            _setter("path", path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Updatable) Name of directory object in database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        (Updatable) Absolute path of directory on database server
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class MigrationDatapumpSettingsImportDirectoryObject(dict):
    def __init__(__self__, *,
                 name: str,
                 path: Optional[str] = None):
        """
        :param str name: (Updatable) Name of directory object in database
        :param str path: (Updatable) Absolute path of directory on database server
        """
        MigrationDatapumpSettingsImportDirectoryObject._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            path=path,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             path: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        if path is not None:
            _setter("path", path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Updatable) Name of directory object in database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        (Updatable) Absolute path of directory on database server
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class MigrationDatapumpSettingsMetadataRemap(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newValue":
            suggest = "new_value"
        elif key == "oldValue":
            suggest = "old_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationDatapumpSettingsMetadataRemap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationDatapumpSettingsMetadataRemap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationDatapumpSettingsMetadataRemap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 new_value: str,
                 old_value: str,
                 type: str):
        """
        :param str new_value: (Updatable) Specifies the new value that oldValue should be translated into.
        :param str old_value: (Updatable) Specifies the value which needs to be reset.
        :param str type: (Updatable) Migration type.
        """
        MigrationDatapumpSettingsMetadataRemap._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            new_value=new_value,
            old_value=old_value,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             new_value: str,
             old_value: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("new_value", new_value)
        _setter("old_value", old_value)
        _setter("type", type)

    @property
    @pulumi.getter(name="newValue")
    def new_value(self) -> str:
        """
        (Updatable) Specifies the new value that oldValue should be translated into.
        """
        return pulumi.get(self, "new_value")

    @property
    @pulumi.getter(name="oldValue")
    def old_value(self) -> str:
        """
        (Updatable) Specifies the value which needs to be reset.
        """
        return pulumi.get(self, "old_value")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (Updatable) Migration type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MigrationDumpTransferDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sharedStorageMountTargetId":
            suggest = "shared_storage_mount_target_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationDumpTransferDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationDumpTransferDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationDumpTransferDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 shared_storage_mount_target_id: Optional[str] = None,
                 source: Optional['outputs.MigrationDumpTransferDetailsSource'] = None,
                 target: Optional['outputs.MigrationDumpTransferDetailsTarget'] = None):
        """
        :param 'MigrationDumpTransferDetailsSourceArgs' source: (Updatable) Optional additional properties for dump transfer in source or target host. Default kind is CURL
        :param 'MigrationDumpTransferDetailsTargetArgs' target: (Updatable) Optional additional properties for dump transfer in source or target host. Default kind is CURL
        """
        MigrationDumpTransferDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            shared_storage_mount_target_id=shared_storage_mount_target_id,
            source=source,
            target=target,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             shared_storage_mount_target_id: Optional[str] = None,
             source: Optional['outputs.MigrationDumpTransferDetailsSource'] = None,
             target: Optional['outputs.MigrationDumpTransferDetailsTarget'] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if shared_storage_mount_target_id is not None:
            _setter("shared_storage_mount_target_id", shared_storage_mount_target_id)
        if source is not None:
            _setter("source", source)
        if target is not None:
            _setter("target", target)

    @property
    @pulumi.getter(name="sharedStorageMountTargetId")
    def shared_storage_mount_target_id(self) -> Optional[str]:
        return pulumi.get(self, "shared_storage_mount_target_id")

    @property
    @pulumi.getter
    def source(self) -> Optional['outputs.MigrationDumpTransferDetailsSource']:
        """
        (Updatable) Optional additional properties for dump transfer in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> Optional['outputs.MigrationDumpTransferDetailsTarget']:
        """
        (Updatable) Optional additional properties for dump transfer in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class MigrationDumpTransferDetailsSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ociHome":
            suggest = "oci_home"
        elif key == "walletLocation":
            suggest = "wallet_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationDumpTransferDetailsSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationDumpTransferDetailsSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationDumpTransferDetailsSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 oci_home: Optional[str] = None,
                 wallet_location: Optional[str] = None):
        """
        :param str kind: (Updatable) Type of dump transfer to use during migration in source or target host. Default kind is CURL
        :param str oci_home: (Updatable) Path to the Oracle Cloud Infrastructure CLI installation in the node.
        :param str wallet_location: (Updatable) Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        MigrationDumpTransferDetailsSource._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kind=kind,
            oci_home=oci_home,
            wallet_location=wallet_location,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kind: str,
             oci_home: Optional[str] = None,
             wallet_location: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("kind", kind)
        if oci_home is not None:
            _setter("oci_home", oci_home)
        if wallet_location is not None:
            _setter("wallet_location", wallet_location)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        (Updatable) Type of dump transfer to use during migration in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="ociHome")
    def oci_home(self) -> Optional[str]:
        """
        (Updatable) Path to the Oracle Cloud Infrastructure CLI installation in the node.
        """
        return pulumi.get(self, "oci_home")

    @property
    @pulumi.getter(name="walletLocation")
    def wallet_location(self) -> Optional[str]:
        """
        (Updatable) Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        return pulumi.get(self, "wallet_location")


@pulumi.output_type
class MigrationDumpTransferDetailsTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ociHome":
            suggest = "oci_home"
        elif key == "walletLocation":
            suggest = "wallet_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationDumpTransferDetailsTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationDumpTransferDetailsTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationDumpTransferDetailsTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 oci_home: Optional[str] = None,
                 wallet_location: Optional[str] = None):
        """
        :param str kind: (Updatable) Type of dump transfer to use during migration in source or target host. Default kind is CURL
        :param str oci_home: (Updatable) Path to the Oracle Cloud Infrastructure CLI installation in the node.
        :param str wallet_location: (Updatable) Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        MigrationDumpTransferDetailsTarget._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kind=kind,
            oci_home=oci_home,
            wallet_location=wallet_location,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kind: str,
             oci_home: Optional[str] = None,
             wallet_location: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("kind", kind)
        if oci_home is not None:
            _setter("oci_home", oci_home)
        if wallet_location is not None:
            _setter("wallet_location", wallet_location)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        (Updatable) Type of dump transfer to use during migration in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="ociHome")
    def oci_home(self) -> Optional[str]:
        """
        (Updatable) Path to the Oracle Cloud Infrastructure CLI installation in the node.
        """
        return pulumi.get(self, "oci_home")

    @property
    @pulumi.getter(name="walletLocation")
    def wallet_location(self) -> Optional[str]:
        """
        (Updatable) Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        return pulumi.get(self, "wallet_location")


@pulumi.output_type
class MigrationExcludeObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isOmitExcludedTableFromReplication":
            suggest = "is_omit_excluded_table_from_replication"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationExcludeObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationExcludeObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationExcludeObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object: str,
                 owner: str,
                 is_omit_excluded_table_from_replication: Optional[bool] = None,
                 type: Optional[str] = None):
        """
        :param str object: (Updatable) Name of the object (regular expression is allowed)
        :param str owner: (Updatable) Owner of the object (regular expression is allowed)
        :param bool is_omit_excluded_table_from_replication: (Updatable) Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        :param str type: (Updatable) Migration type.
        """
        MigrationExcludeObject._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            object=object,
            owner=owner,
            is_omit_excluded_table_from_replication=is_omit_excluded_table_from_replication,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             object: str,
             owner: str,
             is_omit_excluded_table_from_replication: Optional[bool] = None,
             type: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("object", object)
        _setter("owner", owner)
        if is_omit_excluded_table_from_replication is not None:
            _setter("is_omit_excluded_table_from_replication", is_omit_excluded_table_from_replication)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        (Updatable) Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        (Updatable) Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="isOmitExcludedTableFromReplication")
    def is_omit_excluded_table_from_replication(self) -> Optional[bool]:
        """
        (Updatable) Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        """
        return pulumi.get(self, "is_omit_excluded_table_from_replication")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        (Updatable) Migration type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MigrationGoldenGateDetails(dict):
    def __init__(__self__, *,
                 hub: 'outputs.MigrationGoldenGateDetailsHub',
                 settings: Optional['outputs.MigrationGoldenGateDetailsSettings'] = None):
        """
        :param 'MigrationGoldenGateDetailsHubArgs' hub: (Updatable) Details about Oracle GoldenGate Microservices. Required for online logical migration.
        :param 'MigrationGoldenGateDetailsSettingsArgs' settings: (Updatable) Optional settings for GoldenGate Microservices processes
        """
        MigrationGoldenGateDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            hub=hub,
            settings=settings,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             hub: 'outputs.MigrationGoldenGateDetailsHub',
             settings: Optional['outputs.MigrationGoldenGateDetailsSettings'] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("hub", hub)
        if settings is not None:
            _setter("settings", settings)

    @property
    @pulumi.getter
    def hub(self) -> 'outputs.MigrationGoldenGateDetailsHub':
        """
        (Updatable) Details about Oracle GoldenGate Microservices. Required for online logical migration.
        """
        return pulumi.get(self, "hub")

    @property
    @pulumi.getter
    def settings(self) -> Optional['outputs.MigrationGoldenGateDetailsSettings']:
        """
        (Updatable) Optional settings for GoldenGate Microservices processes
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class MigrationGoldenGateDetailsHub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restAdminCredentials":
            suggest = "rest_admin_credentials"
        elif key == "computeId":
            suggest = "compute_id"
        elif key == "sourceContainerDbAdminCredentials":
            suggest = "source_container_db_admin_credentials"
        elif key == "sourceDbAdminCredentials":
            suggest = "source_db_admin_credentials"
        elif key == "sourceMicroservicesDeploymentName":
            suggest = "source_microservices_deployment_name"
        elif key == "targetDbAdminCredentials":
            suggest = "target_db_admin_credentials"
        elif key == "targetMicroservicesDeploymentName":
            suggest = "target_microservices_deployment_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationGoldenGateDetailsHub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationGoldenGateDetailsHub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationGoldenGateDetailsHub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rest_admin_credentials: 'outputs.MigrationGoldenGateDetailsHubRestAdminCredentials',
                 url: str,
                 compute_id: Optional[str] = None,
                 source_container_db_admin_credentials: Optional['outputs.MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentials'] = None,
                 source_db_admin_credentials: Optional['outputs.MigrationGoldenGateDetailsHubSourceDbAdminCredentials'] = None,
                 source_microservices_deployment_name: Optional[str] = None,
                 target_db_admin_credentials: Optional['outputs.MigrationGoldenGateDetailsHubTargetDbAdminCredentials'] = None,
                 target_microservices_deployment_name: Optional[str] = None):
        """
        :param 'MigrationGoldenGateDetailsHubRestAdminCredentialsArgs' rest_admin_credentials: (Updatable) Database Administrator Credentials details.
        :param str url: (Updatable) Oracle GoldenGate Microservices hub's REST endpoint. Refer to https://docs.oracle.com/en/middleware/goldengate/core/19.1/securing/network.html#GUID-A709DA55-111D-455E-8942-C9BDD1E38CAA
        :param str compute_id: (Updatable) OCID of GoldenGate Microservices compute instance.
        :param 'MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentialsArgs' source_container_db_admin_credentials: (Updatable) Database Administrator Credentials details.
        :param 'MigrationGoldenGateDetailsHubSourceDbAdminCredentialsArgs' source_db_admin_credentials: (Updatable) Database Administrator Credentials details.
        :param str source_microservices_deployment_name: (Updatable) Name of GoldenGate Microservices deployment to operate on source database
        :param 'MigrationGoldenGateDetailsHubTargetDbAdminCredentialsArgs' target_db_admin_credentials: (Updatable) Database Administrator Credentials details.
        :param str target_microservices_deployment_name: (Updatable) Name of GoldenGate Microservices deployment to operate on target database
        """
        MigrationGoldenGateDetailsHub._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            rest_admin_credentials=rest_admin_credentials,
            url=url,
            compute_id=compute_id,
            source_container_db_admin_credentials=source_container_db_admin_credentials,
            source_db_admin_credentials=source_db_admin_credentials,
            source_microservices_deployment_name=source_microservices_deployment_name,
            target_db_admin_credentials=target_db_admin_credentials,
            target_microservices_deployment_name=target_microservices_deployment_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             rest_admin_credentials: 'outputs.MigrationGoldenGateDetailsHubRestAdminCredentials',
             url: str,
             compute_id: Optional[str] = None,
             source_container_db_admin_credentials: Optional['outputs.MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentials'] = None,
             source_db_admin_credentials: Optional['outputs.MigrationGoldenGateDetailsHubSourceDbAdminCredentials'] = None,
             source_microservices_deployment_name: Optional[str] = None,
             target_db_admin_credentials: Optional['outputs.MigrationGoldenGateDetailsHubTargetDbAdminCredentials'] = None,
             target_microservices_deployment_name: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("rest_admin_credentials", rest_admin_credentials)
        _setter("url", url)
        if compute_id is not None:
            _setter("compute_id", compute_id)
        if source_container_db_admin_credentials is not None:
            _setter("source_container_db_admin_credentials", source_container_db_admin_credentials)
        if source_db_admin_credentials is not None:
            _setter("source_db_admin_credentials", source_db_admin_credentials)
        if source_microservices_deployment_name is not None:
            _setter("source_microservices_deployment_name", source_microservices_deployment_name)
        if target_db_admin_credentials is not None:
            _setter("target_db_admin_credentials", target_db_admin_credentials)
        if target_microservices_deployment_name is not None:
            _setter("target_microservices_deployment_name", target_microservices_deployment_name)

    @property
    @pulumi.getter(name="restAdminCredentials")
    def rest_admin_credentials(self) -> 'outputs.MigrationGoldenGateDetailsHubRestAdminCredentials':
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "rest_admin_credentials")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        (Updatable) Oracle GoldenGate Microservices hub's REST endpoint. Refer to https://docs.oracle.com/en/middleware/goldengate/core/19.1/securing/network.html#GUID-A709DA55-111D-455E-8942-C9BDD1E38CAA
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[str]:
        """
        (Updatable) OCID of GoldenGate Microservices compute instance.
        """
        return pulumi.get(self, "compute_id")

    @property
    @pulumi.getter(name="sourceContainerDbAdminCredentials")
    def source_container_db_admin_credentials(self) -> Optional['outputs.MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentials']:
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "source_container_db_admin_credentials")

    @property
    @pulumi.getter(name="sourceDbAdminCredentials")
    def source_db_admin_credentials(self) -> Optional['outputs.MigrationGoldenGateDetailsHubSourceDbAdminCredentials']:
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "source_db_admin_credentials")

    @property
    @pulumi.getter(name="sourceMicroservicesDeploymentName")
    def source_microservices_deployment_name(self) -> Optional[str]:
        """
        (Updatable) Name of GoldenGate Microservices deployment to operate on source database
        """
        return pulumi.get(self, "source_microservices_deployment_name")

    @property
    @pulumi.getter(name="targetDbAdminCredentials")
    def target_db_admin_credentials(self) -> Optional['outputs.MigrationGoldenGateDetailsHubTargetDbAdminCredentials']:
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "target_db_admin_credentials")

    @property
    @pulumi.getter(name="targetMicroservicesDeploymentName")
    def target_microservices_deployment_name(self) -> Optional[str]:
        """
        (Updatable) Name of GoldenGate Microservices deployment to operate on target database
        """
        return pulumi.get(self, "target_microservices_deployment_name")


@pulumi.output_type
class MigrationGoldenGateDetailsHubRestAdminCredentials(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: (Updatable) Database  password
        :param str username: (Updatable) Database username
        """
        MigrationGoldenGateDetailsHubRestAdminCredentials._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        (Updatable) Database  password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        (Updatable) Database username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentials(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: (Updatable) Database  password
        :param str username: (Updatable) Database username
        """
        MigrationGoldenGateDetailsHubSourceContainerDbAdminCredentials._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        (Updatable) Database  password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        (Updatable) Database username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class MigrationGoldenGateDetailsHubSourceDbAdminCredentials(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: (Updatable) Database  password
        :param str username: (Updatable) Database username
        """
        MigrationGoldenGateDetailsHubSourceDbAdminCredentials._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        (Updatable) Database  password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        (Updatable) Database username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class MigrationGoldenGateDetailsHubTargetDbAdminCredentials(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: (Updatable) Database  password
        :param str username: (Updatable) Database username
        """
        MigrationGoldenGateDetailsHubTargetDbAdminCredentials._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        (Updatable) Database  password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        (Updatable) Database username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class MigrationGoldenGateDetailsSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceptableLag":
            suggest = "acceptable_lag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationGoldenGateDetailsSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationGoldenGateDetailsSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationGoldenGateDetailsSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acceptable_lag: Optional[int] = None,
                 extract: Optional['outputs.MigrationGoldenGateDetailsSettingsExtract'] = None,
                 replicat: Optional['outputs.MigrationGoldenGateDetailsSettingsReplicat'] = None):
        """
        :param int acceptable_lag: (Updatable) ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        :param 'MigrationGoldenGateDetailsSettingsExtractArgs' extract: (Updatable) Parameters for GoldenGate Extract processes.
        :param 'MigrationGoldenGateDetailsSettingsReplicatArgs' replicat: (Updatable) Parameters for GoldenGate Replicat processes.
        """
        MigrationGoldenGateDetailsSettings._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            acceptable_lag=acceptable_lag,
            extract=extract,
            replicat=replicat,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             acceptable_lag: Optional[int] = None,
             extract: Optional['outputs.MigrationGoldenGateDetailsSettingsExtract'] = None,
             replicat: Optional['outputs.MigrationGoldenGateDetailsSettingsReplicat'] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if acceptable_lag is not None:
            _setter("acceptable_lag", acceptable_lag)
        if extract is not None:
            _setter("extract", extract)
        if replicat is not None:
            _setter("replicat", replicat)

    @property
    @pulumi.getter(name="acceptableLag")
    def acceptable_lag(self) -> Optional[int]:
        """
        (Updatable) ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        """
        return pulumi.get(self, "acceptable_lag")

    @property
    @pulumi.getter
    def extract(self) -> Optional['outputs.MigrationGoldenGateDetailsSettingsExtract']:
        """
        (Updatable) Parameters for GoldenGate Extract processes.
        """
        return pulumi.get(self, "extract")

    @property
    @pulumi.getter
    def replicat(self) -> Optional['outputs.MigrationGoldenGateDetailsSettingsReplicat']:
        """
        (Updatable) Parameters for GoldenGate Replicat processes.
        """
        return pulumi.get(self, "replicat")


@pulumi.output_type
class MigrationGoldenGateDetailsSettingsExtract(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "longTransDuration":
            suggest = "long_trans_duration"
        elif key == "performanceProfile":
            suggest = "performance_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationGoldenGateDetailsSettingsExtract. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationGoldenGateDetailsSettingsExtract.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationGoldenGateDetailsSettingsExtract.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 long_trans_duration: Optional[int] = None,
                 performance_profile: Optional[str] = None):
        """
        :param int long_trans_duration: (Updatable) Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        :param str performance_profile: (Updatable) Extract performance.
        """
        MigrationGoldenGateDetailsSettingsExtract._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            long_trans_duration=long_trans_duration,
            performance_profile=performance_profile,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             long_trans_duration: Optional[int] = None,
             performance_profile: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if long_trans_duration is not None:
            _setter("long_trans_duration", long_trans_duration)
        if performance_profile is not None:
            _setter("performance_profile", performance_profile)

    @property
    @pulumi.getter(name="longTransDuration")
    def long_trans_duration(self) -> Optional[int]:
        """
        (Updatable) Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        """
        return pulumi.get(self, "long_trans_duration")

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> Optional[str]:
        """
        (Updatable) Extract performance.
        """
        return pulumi.get(self, "performance_profile")


@pulumi.output_type
class MigrationGoldenGateDetailsSettingsReplicat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mapParallelism":
            suggest = "map_parallelism"
        elif key == "maxApplyParallelism":
            suggest = "max_apply_parallelism"
        elif key == "minApplyParallelism":
            suggest = "min_apply_parallelism"
        elif key == "performanceProfile":
            suggest = "performance_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationGoldenGateDetailsSettingsReplicat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationGoldenGateDetailsSettingsReplicat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationGoldenGateDetailsSettingsReplicat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 map_parallelism: Optional[int] = None,
                 max_apply_parallelism: Optional[int] = None,
                 min_apply_parallelism: Optional[int] = None,
                 performance_profile: Optional[str] = None):
        """
        :param int map_parallelism: (Updatable) Number of threads used to read trail files (valid for Parallel Replicat)
        :param int max_apply_parallelism: (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        :param int min_apply_parallelism: (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        :param str performance_profile: (Updatable) Extract performance.
        """
        MigrationGoldenGateDetailsSettingsReplicat._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            map_parallelism=map_parallelism,
            max_apply_parallelism=max_apply_parallelism,
            min_apply_parallelism=min_apply_parallelism,
            performance_profile=performance_profile,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             map_parallelism: Optional[int] = None,
             max_apply_parallelism: Optional[int] = None,
             min_apply_parallelism: Optional[int] = None,
             performance_profile: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if map_parallelism is not None:
            _setter("map_parallelism", map_parallelism)
        if max_apply_parallelism is not None:
            _setter("max_apply_parallelism", max_apply_parallelism)
        if min_apply_parallelism is not None:
            _setter("min_apply_parallelism", min_apply_parallelism)
        if performance_profile is not None:
            _setter("performance_profile", performance_profile)

    @property
    @pulumi.getter(name="mapParallelism")
    def map_parallelism(self) -> Optional[int]:
        """
        (Updatable) Number of threads used to read trail files (valid for Parallel Replicat)
        """
        return pulumi.get(self, "map_parallelism")

    @property
    @pulumi.getter(name="maxApplyParallelism")
    def max_apply_parallelism(self) -> Optional[int]:
        """
        (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "max_apply_parallelism")

    @property
    @pulumi.getter(name="minApplyParallelism")
    def min_apply_parallelism(self) -> Optional[int]:
        """
        (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "min_apply_parallelism")

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> Optional[str]:
        """
        (Updatable) Extract performance.
        """
        return pulumi.get(self, "performance_profile")


@pulumi.output_type
class MigrationGoldenGateServiceDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ggsDeployments":
            suggest = "ggs_deployments"
        elif key == "sourceContainerDbCredentials":
            suggest = "source_container_db_credentials"
        elif key == "sourceDbCredentials":
            suggest = "source_db_credentials"
        elif key == "targetDbCredentials":
            suggest = "target_db_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationGoldenGateServiceDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationGoldenGateServiceDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationGoldenGateServiceDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ggs_deployments: Optional[Sequence['outputs.MigrationGoldenGateServiceDetailsGgsDeployment']] = None,
                 settings: Optional['outputs.MigrationGoldenGateServiceDetailsSettings'] = None,
                 source_container_db_credentials: Optional['outputs.MigrationGoldenGateServiceDetailsSourceContainerDbCredentials'] = None,
                 source_db_credentials: Optional['outputs.MigrationGoldenGateServiceDetailsSourceDbCredentials'] = None,
                 target_db_credentials: Optional['outputs.MigrationGoldenGateServiceDetailsTargetDbCredentials'] = None):
        """
        :param Sequence['MigrationGoldenGateServiceDetailsGgsDeploymentArgs'] ggs_deployments: Details about Oracle GoldenGate GGS Deployment.
        :param 'MigrationGoldenGateServiceDetailsSettingsArgs' settings: (Updatable) Optional settings for GoldenGate Microservices processes
        :param 'MigrationGoldenGateServiceDetailsSourceContainerDbCredentialsArgs' source_container_db_credentials: (Updatable) Database Credentials details.
        :param 'MigrationGoldenGateServiceDetailsSourceDbCredentialsArgs' source_db_credentials: (Updatable) Database Credentials details.
        :param 'MigrationGoldenGateServiceDetailsTargetDbCredentialsArgs' target_db_credentials: (Updatable) Database Credentials details.
        """
        MigrationGoldenGateServiceDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ggs_deployments=ggs_deployments,
            settings=settings,
            source_container_db_credentials=source_container_db_credentials,
            source_db_credentials=source_db_credentials,
            target_db_credentials=target_db_credentials,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ggs_deployments: Optional[Sequence['outputs.MigrationGoldenGateServiceDetailsGgsDeployment']] = None,
             settings: Optional['outputs.MigrationGoldenGateServiceDetailsSettings'] = None,
             source_container_db_credentials: Optional['outputs.MigrationGoldenGateServiceDetailsSourceContainerDbCredentials'] = None,
             source_db_credentials: Optional['outputs.MigrationGoldenGateServiceDetailsSourceDbCredentials'] = None,
             target_db_credentials: Optional['outputs.MigrationGoldenGateServiceDetailsTargetDbCredentials'] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if ggs_deployments is not None:
            _setter("ggs_deployments", ggs_deployments)
        if settings is not None:
            _setter("settings", settings)
        if source_container_db_credentials is not None:
            _setter("source_container_db_credentials", source_container_db_credentials)
        if source_db_credentials is not None:
            _setter("source_db_credentials", source_db_credentials)
        if target_db_credentials is not None:
            _setter("target_db_credentials", target_db_credentials)

    @property
    @pulumi.getter(name="ggsDeployments")
    def ggs_deployments(self) -> Optional[Sequence['outputs.MigrationGoldenGateServiceDetailsGgsDeployment']]:
        """
        Details about Oracle GoldenGate GGS Deployment.
        """
        return pulumi.get(self, "ggs_deployments")

    @property
    @pulumi.getter
    def settings(self) -> Optional['outputs.MigrationGoldenGateServiceDetailsSettings']:
        """
        (Updatable) Optional settings for GoldenGate Microservices processes
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="sourceContainerDbCredentials")
    def source_container_db_credentials(self) -> Optional['outputs.MigrationGoldenGateServiceDetailsSourceContainerDbCredentials']:
        """
        (Updatable) Database Credentials details.
        """
        return pulumi.get(self, "source_container_db_credentials")

    @property
    @pulumi.getter(name="sourceDbCredentials")
    def source_db_credentials(self) -> Optional['outputs.MigrationGoldenGateServiceDetailsSourceDbCredentials']:
        """
        (Updatable) Database Credentials details.
        """
        return pulumi.get(self, "source_db_credentials")

    @property
    @pulumi.getter(name="targetDbCredentials")
    def target_db_credentials(self) -> Optional['outputs.MigrationGoldenGateServiceDetailsTargetDbCredentials']:
        """
        (Updatable) Database Credentials details.
        """
        return pulumi.get(self, "target_db_credentials")


@pulumi.output_type
class MigrationGoldenGateServiceDetailsGgsDeployment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentId":
            suggest = "deployment_id"
        elif key == "ggsAdminCredentialsSecretId":
            suggest = "ggs_admin_credentials_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationGoldenGateServiceDetailsGgsDeployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationGoldenGateServiceDetailsGgsDeployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationGoldenGateServiceDetailsGgsDeployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_id: Optional[str] = None,
                 ggs_admin_credentials_secret_id: Optional[str] = None):
        """
        :param str deployment_id: OCID of a GoldenGate Deployment
        :param str ggs_admin_credentials_secret_id: OCID of a VaultSecret containing the Admin Credentials for the GGS Deployment
        """
        MigrationGoldenGateServiceDetailsGgsDeployment._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            deployment_id=deployment_id,
            ggs_admin_credentials_secret_id=ggs_admin_credentials_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             deployment_id: Optional[str] = None,
             ggs_admin_credentials_secret_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if deployment_id is not None:
            _setter("deployment_id", deployment_id)
        if ggs_admin_credentials_secret_id is not None:
            _setter("ggs_admin_credentials_secret_id", ggs_admin_credentials_secret_id)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[str]:
        """
        OCID of a GoldenGate Deployment
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="ggsAdminCredentialsSecretId")
    def ggs_admin_credentials_secret_id(self) -> Optional[str]:
        """
        OCID of a VaultSecret containing the Admin Credentials for the GGS Deployment
        """
        return pulumi.get(self, "ggs_admin_credentials_secret_id")


@pulumi.output_type
class MigrationGoldenGateServiceDetailsSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceptableLag":
            suggest = "acceptable_lag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationGoldenGateServiceDetailsSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationGoldenGateServiceDetailsSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationGoldenGateServiceDetailsSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acceptable_lag: Optional[int] = None,
                 extract: Optional['outputs.MigrationGoldenGateServiceDetailsSettingsExtract'] = None,
                 replicat: Optional['outputs.MigrationGoldenGateServiceDetailsSettingsReplicat'] = None):
        """
        :param int acceptable_lag: (Updatable) ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        :param 'MigrationGoldenGateServiceDetailsSettingsExtractArgs' extract: (Updatable) Parameters for GoldenGate Extract processes.
        :param 'MigrationGoldenGateServiceDetailsSettingsReplicatArgs' replicat: (Updatable) Parameters for GoldenGate Replicat processes.
        """
        MigrationGoldenGateServiceDetailsSettings._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            acceptable_lag=acceptable_lag,
            extract=extract,
            replicat=replicat,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             acceptable_lag: Optional[int] = None,
             extract: Optional['outputs.MigrationGoldenGateServiceDetailsSettingsExtract'] = None,
             replicat: Optional['outputs.MigrationGoldenGateServiceDetailsSettingsReplicat'] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if acceptable_lag is not None:
            _setter("acceptable_lag", acceptable_lag)
        if extract is not None:
            _setter("extract", extract)
        if replicat is not None:
            _setter("replicat", replicat)

    @property
    @pulumi.getter(name="acceptableLag")
    def acceptable_lag(self) -> Optional[int]:
        """
        (Updatable) ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        """
        return pulumi.get(self, "acceptable_lag")

    @property
    @pulumi.getter
    def extract(self) -> Optional['outputs.MigrationGoldenGateServiceDetailsSettingsExtract']:
        """
        (Updatable) Parameters for GoldenGate Extract processes.
        """
        return pulumi.get(self, "extract")

    @property
    @pulumi.getter
    def replicat(self) -> Optional['outputs.MigrationGoldenGateServiceDetailsSettingsReplicat']:
        """
        (Updatable) Parameters for GoldenGate Replicat processes.
        """
        return pulumi.get(self, "replicat")


@pulumi.output_type
class MigrationGoldenGateServiceDetailsSettingsExtract(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "longTransDuration":
            suggest = "long_trans_duration"
        elif key == "performanceProfile":
            suggest = "performance_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationGoldenGateServiceDetailsSettingsExtract. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationGoldenGateServiceDetailsSettingsExtract.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationGoldenGateServiceDetailsSettingsExtract.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 long_trans_duration: Optional[int] = None,
                 performance_profile: Optional[str] = None):
        """
        :param int long_trans_duration: (Updatable) Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        :param str performance_profile: (Updatable) Extract performance.
        """
        MigrationGoldenGateServiceDetailsSettingsExtract._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            long_trans_duration=long_trans_duration,
            performance_profile=performance_profile,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             long_trans_duration: Optional[int] = None,
             performance_profile: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if long_trans_duration is not None:
            _setter("long_trans_duration", long_trans_duration)
        if performance_profile is not None:
            _setter("performance_profile", performance_profile)

    @property
    @pulumi.getter(name="longTransDuration")
    def long_trans_duration(self) -> Optional[int]:
        """
        (Updatable) Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        """
        return pulumi.get(self, "long_trans_duration")

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> Optional[str]:
        """
        (Updatable) Extract performance.
        """
        return pulumi.get(self, "performance_profile")


@pulumi.output_type
class MigrationGoldenGateServiceDetailsSettingsReplicat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mapParallelism":
            suggest = "map_parallelism"
        elif key == "maxApplyParallelism":
            suggest = "max_apply_parallelism"
        elif key == "minApplyParallelism":
            suggest = "min_apply_parallelism"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationGoldenGateServiceDetailsSettingsReplicat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationGoldenGateServiceDetailsSettingsReplicat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationGoldenGateServiceDetailsSettingsReplicat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 map_parallelism: Optional[int] = None,
                 max_apply_parallelism: Optional[int] = None,
                 min_apply_parallelism: Optional[int] = None):
        """
        :param int map_parallelism: (Updatable) Number of threads used to read trail files (valid for Parallel Replicat)
        :param int max_apply_parallelism: (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        :param int min_apply_parallelism: (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        MigrationGoldenGateServiceDetailsSettingsReplicat._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            map_parallelism=map_parallelism,
            max_apply_parallelism=max_apply_parallelism,
            min_apply_parallelism=min_apply_parallelism,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             map_parallelism: Optional[int] = None,
             max_apply_parallelism: Optional[int] = None,
             min_apply_parallelism: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if map_parallelism is not None:
            _setter("map_parallelism", map_parallelism)
        if max_apply_parallelism is not None:
            _setter("max_apply_parallelism", max_apply_parallelism)
        if min_apply_parallelism is not None:
            _setter("min_apply_parallelism", min_apply_parallelism)

    @property
    @pulumi.getter(name="mapParallelism")
    def map_parallelism(self) -> Optional[int]:
        """
        (Updatable) Number of threads used to read trail files (valid for Parallel Replicat)
        """
        return pulumi.get(self, "map_parallelism")

    @property
    @pulumi.getter(name="maxApplyParallelism")
    def max_apply_parallelism(self) -> Optional[int]:
        """
        (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "max_apply_parallelism")

    @property
    @pulumi.getter(name="minApplyParallelism")
    def min_apply_parallelism(self) -> Optional[int]:
        """
        (Updatable) Defines the range in which the Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "min_apply_parallelism")


@pulumi.output_type
class MigrationGoldenGateServiceDetailsSourceContainerDbCredentials(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: (Updatable) Database  password
        :param str username: (Updatable) Database username
        """
        MigrationGoldenGateServiceDetailsSourceContainerDbCredentials._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        (Updatable) Database  password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        (Updatable) Database username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class MigrationGoldenGateServiceDetailsSourceDbCredentials(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: (Updatable) Database  password
        :param str username: (Updatable) Database username
        """
        MigrationGoldenGateServiceDetailsSourceDbCredentials._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        (Updatable) Database  password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        (Updatable) Database username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class MigrationGoldenGateServiceDetailsTargetDbCredentials(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str password: (Updatable) Database  password
        :param str username: (Updatable) Database username
        """
        MigrationGoldenGateServiceDetailsTargetDbCredentials._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        (Updatable) Database  password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        (Updatable) Database username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class MigrationIncludeObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isOmitExcludedTableFromReplication":
            suggest = "is_omit_excluded_table_from_replication"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationIncludeObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationIncludeObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationIncludeObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object: str,
                 owner: str,
                 is_omit_excluded_table_from_replication: Optional[bool] = None,
                 type: Optional[str] = None):
        """
        :param str object: (Updatable) Name of the object (regular expression is allowed)
        :param str owner: (Updatable) Owner of the object (regular expression is allowed)
        :param bool is_omit_excluded_table_from_replication: (Updatable) Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        :param str type: (Updatable) Migration type.
        """
        MigrationIncludeObject._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            object=object,
            owner=owner,
            is_omit_excluded_table_from_replication=is_omit_excluded_table_from_replication,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             object: str,
             owner: str,
             is_omit_excluded_table_from_replication: Optional[bool] = None,
             type: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("object", object)
        _setter("owner", owner)
        if is_omit_excluded_table_from_replication is not None:
            _setter("is_omit_excluded_table_from_replication", is_omit_excluded_table_from_replication)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        (Updatable) Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        (Updatable) Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="isOmitExcludedTableFromReplication")
    def is_omit_excluded_table_from_replication(self) -> Optional[bool]:
        """
        (Updatable) Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        """
        return pulumi.get(self, "is_omit_excluded_table_from_replication")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        (Updatable) Migration type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MigrationVaultDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"
        elif key == "keyId":
            suggest = "key_id"
        elif key == "vaultId":
            suggest = "vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationVaultDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationVaultDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationVaultDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: str,
                 key_id: str,
                 vault_id: str):
        """
        :param str compartment_id: (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        :param str key_id: (Updatable) OCID of the vault encryption key
        :param str vault_id: (Updatable) OCID of the vault 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        MigrationVaultDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            key_id=key_id,
            vault_id=vault_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             key_id: str,
             vault_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("key_id", key_id)
        _setter("vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        (Updatable) OCID of the vault encryption key
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        (Updatable) OCID of the vault 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetAgentImagesAgentImageCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetAgentImagesAgentImageCollectionItemResult']):
        """
        :param Sequence['GetAgentImagesAgentImageCollectionItemArgs'] items: Items in collection.
        """
        GetAgentImagesAgentImageCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetAgentImagesAgentImageCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAgentImagesAgentImageCollectionItemResult']:
        """
        Items in collection.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetAgentImagesAgentImageCollectionItemResult(dict):
    def __init__(__self__, *,
                 download_url: str,
                 version: str):
        """
        :param str download_url: URL to download Agent Image of the ODMS Agent.
        :param str version: ODMS Agent Image version.
        """
        GetAgentImagesAgentImageCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            download_url=download_url,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             download_url: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("download_url", download_url)
        _setter("version", version)

    @property
    @pulumi.getter(name="downloadUrl")
    def download_url(self) -> str:
        """
        URL to download Agent Image of the ODMS Agent.
        """
        return pulumi.get(self, "download_url")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        ODMS Agent Image version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetAgentImagesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetAgentImagesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetAgentsAgentCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetAgentsAgentCollectionItemResult']):
        GetAgentsAgentCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetAgentsAgentCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAgentsAgentCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetAgentsAgentCollectionItemResult(dict):
    def __init__(__self__, *,
                 agent_id: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 public_key: str,
                 state: str,
                 stream_id: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str,
                 version: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The OCID of the resource
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param str public_key: ODMS Agent public key.
        :param str state: The current state of the Database Migration Deployment.
        :param str stream_id: The OCID of the Stream
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time the Agent was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time of the last Agent details update. An RFC3339 formatted datetime string.
        :param str version: ODMS Agent version
        """
        GetAgentsAgentCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            agent_id=agent_id,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            lifecycle_details=lifecycle_details,
            public_key=public_key,
            state=state,
            stream_id=stream_id,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             agent_id: str,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             lifecycle_details: str,
             public_key: str,
             state: str,
             stream_id: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("agent_id", agent_id)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("lifecycle_details", lifecycle_details)
        _setter("public_key", public_key)
        _setter("state", state)
        _setter("stream_id", stream_id)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("version", version)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> str:
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        ODMS Agent public key.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Database Migration Deployment.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> str:
        """
        The OCID of the Stream
        """
        return pulumi.get(self, "stream_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the Agent was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time of the last Agent details update. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        ODMS Agent version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetAgentsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetAgentsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetConnectionAdminCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetConnectionAdminCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetConnectionConnectDescriptorResult(dict):
    def __init__(__self__, *,
                 connect_string: str,
                 database_service_name: str,
                 host: str,
                 port: int):
        """
        :param str connect_string: Connect string.
        :param str database_service_name: Database service name.
        :param str host: Name of the host the SSH key is valid for.
        :param int port: Port of the connect descriptor.
        """
        GetConnectionConnectDescriptorResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            connect_string=connect_string,
            database_service_name=database_service_name,
            host=host,
            port=port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             connect_string: str,
             database_service_name: str,
             host: str,
             port: int,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("connect_string", connect_string)
        _setter("database_service_name", database_service_name)
        _setter("host", host)
        _setter("port", port)

    @property
    @pulumi.getter(name="connectString")
    def connect_string(self) -> str:
        """
        Connect string.
        """
        return pulumi.get(self, "connect_string")

    @property
    @pulumi.getter(name="databaseServiceName")
    def database_service_name(self) -> str:
        """
        Database service name.
        """
        return pulumi.get(self, "database_service_name")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Name of the host the SSH key is valid for.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port of the connect descriptor.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetConnectionPrivateEndpointResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 id: str,
                 subnet_id: str,
                 vcn_id: str):
        """
        :param str compartment_id: OCID of the compartment where the secret containing the credentials will be created.
        :param str id: [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a previously created Private Endpoint.
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer's subnet where the private endpoint VNIC will reside.
        :param str vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN where the Private Endpoint will be bound to.
        """
        GetConnectionPrivateEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            id=id,
            subnet_id=subnet_id,
            vcn_id=vcn_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             id: str,
             subnet_id: str,
             vcn_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("id", id)
        _setter("subnet_id", subnet_id)
        _setter("vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a previously created Private Endpoint.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer's subnet where the private endpoint VNIC will reside.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN where the Private Endpoint will be bound to.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetConnectionReplicationCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetConnectionReplicationCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetConnectionSshDetailResult(dict):
    def __init__(__self__, *,
                 host: str,
                 sshkey: str,
                 sudo_location: str,
                 user: str):
        """
        :param str host: Name of the host the SSH key is valid for.
        :param str sudo_location: Sudo location
        :param str user: SSH user
        """
        GetConnectionSshDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host=host,
            sshkey=sshkey,
            sudo_location=sudo_location,
            user=user,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host: str,
             sshkey: str,
             sudo_location: str,
             user: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("host", host)
        _setter("sshkey", sshkey)
        _setter("sudo_location", sudo_location)
        _setter("user", user)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Name of the host the SSH key is valid for.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def sshkey(self) -> str:
        return pulumi.get(self, "sshkey")

    @property
    @pulumi.getter(name="sudoLocation")
    def sudo_location(self) -> str:
        """
        Sudo location
        """
        return pulumi.get(self, "sudo_location")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        SSH user
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class GetConnectionVaultDetailResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 key_id: str,
                 vault_id: str):
        """
        :param str compartment_id: OCID of the compartment where the secret containing the credentials will be created.
        :param str key_id: OCID of the vault encryption key
        :param str vault_id: OCID of the vault
        """
        GetConnectionVaultDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            key_id=key_id,
            vault_id=vault_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             key_id: str,
             vault_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("key_id", key_id)
        _setter("vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        OCID of the vault encryption key
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        OCID of the vault
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetConnectionsConnectionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetConnectionsConnectionCollectionItemResult']):
        GetConnectionsConnectionCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetConnectionsConnectionCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetConnectionsConnectionCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetConnectionsConnectionCollectionItemResult(dict):
    def __init__(__self__, *,
                 admin_credentials: Sequence['outputs.GetConnectionsConnectionCollectionItemAdminCredentialResult'],
                 certificate_tdn: str,
                 compartment_id: str,
                 connect_descriptors: Sequence['outputs.GetConnectionsConnectionCollectionItemConnectDescriptorResult'],
                 credentials_secret_id: str,
                 database_id: str,
                 database_type: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 nsg_ids: Sequence[str],
                 private_endpoints: Sequence['outputs.GetConnectionsConnectionCollectionItemPrivateEndpointResult'],
                 replication_credentials: Sequence['outputs.GetConnectionsConnectionCollectionItemReplicationCredentialResult'],
                 ssh_details: Sequence['outputs.GetConnectionsConnectionCollectionItemSshDetailResult'],
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str,
                 tls_keystore: str,
                 tls_wallet: str,
                 vault_details: Sequence['outputs.GetConnectionsConnectionCollectionItemVaultDetailResult']):
        """
        :param Sequence['GetConnectionsConnectionCollectionItemAdminCredentialArgs'] admin_credentials: Database Administrator Credentials details.
        :param str certificate_tdn: This name is the distinguished name used while creating the certificate on target database.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetConnectionsConnectionCollectionItemConnectDescriptorArgs'] connect_descriptors: Connect Descriptor details.
        :param str credentials_secret_id: OCID of the Secret in the Oracle Cloud Infrastructure vault containing the Database Connection credentials.
        :param str database_id: The OCID of the cloud database.
        :param str database_type: Database connection type.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a previously created Private Endpoint.
        :param str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Sequence[str] nsg_ids: An array of Network Security Group OCIDs used to define network access for Connections.
        :param Sequence['GetConnectionsConnectionCollectionItemPrivateEndpointArgs'] private_endpoints: Oracle Cloud Infrastructure Private Endpoint configuration details.
        :param Sequence['GetConnectionsConnectionCollectionItemReplicationCredentialArgs'] replication_credentials: Database Administrator Credentials details.
        :param Sequence['GetConnectionsConnectionCollectionItemSshDetailArgs'] ssh_details: Details of the SSH key that will be used.
        :param str state: The current state of the Database Migration Deployment.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time the Connection resource was created. An RFC3339 formatted datetime string.
        :param str time_updated: The time of the last Connection resource details update. An RFC3339 formatted datetime string.
        :param Sequence['GetConnectionsConnectionCollectionItemVaultDetailArgs'] vault_details: Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        """
        GetConnectionsConnectionCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            admin_credentials=admin_credentials,
            certificate_tdn=certificate_tdn,
            compartment_id=compartment_id,
            connect_descriptors=connect_descriptors,
            credentials_secret_id=credentials_secret_id,
            database_id=database_id,
            database_type=database_type,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            lifecycle_details=lifecycle_details,
            nsg_ids=nsg_ids,
            private_endpoints=private_endpoints,
            replication_credentials=replication_credentials,
            ssh_details=ssh_details,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
            tls_keystore=tls_keystore,
            tls_wallet=tls_wallet,
            vault_details=vault_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             admin_credentials: Sequence['outputs.GetConnectionsConnectionCollectionItemAdminCredentialResult'],
             certificate_tdn: str,
             compartment_id: str,
             connect_descriptors: Sequence['outputs.GetConnectionsConnectionCollectionItemConnectDescriptorResult'],
             credentials_secret_id: str,
             database_id: str,
             database_type: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             lifecycle_details: str,
             nsg_ids: Sequence[str],
             private_endpoints: Sequence['outputs.GetConnectionsConnectionCollectionItemPrivateEndpointResult'],
             replication_credentials: Sequence['outputs.GetConnectionsConnectionCollectionItemReplicationCredentialResult'],
             ssh_details: Sequence['outputs.GetConnectionsConnectionCollectionItemSshDetailResult'],
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_updated: str,
             tls_keystore: str,
             tls_wallet: str,
             vault_details: Sequence['outputs.GetConnectionsConnectionCollectionItemVaultDetailResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("admin_credentials", admin_credentials)
        _setter("certificate_tdn", certificate_tdn)
        _setter("compartment_id", compartment_id)
        _setter("connect_descriptors", connect_descriptors)
        _setter("credentials_secret_id", credentials_secret_id)
        _setter("database_id", database_id)
        _setter("database_type", database_type)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("lifecycle_details", lifecycle_details)
        _setter("nsg_ids", nsg_ids)
        _setter("private_endpoints", private_endpoints)
        _setter("replication_credentials", replication_credentials)
        _setter("ssh_details", ssh_details)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("tls_keystore", tls_keystore)
        _setter("tls_wallet", tls_wallet)
        _setter("vault_details", vault_details)

    @property
    @pulumi.getter(name="adminCredentials")
    def admin_credentials(self) -> Sequence['outputs.GetConnectionsConnectionCollectionItemAdminCredentialResult']:
        """
        Database Administrator Credentials details.
        """
        return pulumi.get(self, "admin_credentials")

    @property
    @pulumi.getter(name="certificateTdn")
    def certificate_tdn(self) -> str:
        """
        This name is the distinguished name used while creating the certificate on target database.
        """
        return pulumi.get(self, "certificate_tdn")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectDescriptors")
    def connect_descriptors(self) -> Sequence['outputs.GetConnectionsConnectionCollectionItemConnectDescriptorResult']:
        """
        Connect Descriptor details.
        """
        return pulumi.get(self, "connect_descriptors")

    @property
    @pulumi.getter(name="credentialsSecretId")
    def credentials_secret_id(self) -> str:
        """
        OCID of the Secret in the Oracle Cloud Infrastructure vault containing the Database Connection credentials.
        """
        return pulumi.get(self, "credentials_secret_id")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> str:
        """
        The OCID of the cloud database.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> str:
        """
        Database connection type.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a previously created Private Endpoint.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        An array of Network Security Group OCIDs used to define network access for Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> Sequence['outputs.GetConnectionsConnectionCollectionItemPrivateEndpointResult']:
        """
        Oracle Cloud Infrastructure Private Endpoint configuration details.
        """
        return pulumi.get(self, "private_endpoints")

    @property
    @pulumi.getter(name="replicationCredentials")
    def replication_credentials(self) -> Sequence['outputs.GetConnectionsConnectionCollectionItemReplicationCredentialResult']:
        """
        Database Administrator Credentials details.
        """
        return pulumi.get(self, "replication_credentials")

    @property
    @pulumi.getter(name="sshDetails")
    def ssh_details(self) -> Sequence['outputs.GetConnectionsConnectionCollectionItemSshDetailResult']:
        """
        Details of the SSH key that will be used.
        """
        return pulumi.get(self, "ssh_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Database Migration Deployment.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the Connection resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time of the last Connection resource details update. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="tlsKeystore")
    def tls_keystore(self) -> str:
        return pulumi.get(self, "tls_keystore")

    @property
    @pulumi.getter(name="tlsWallet")
    def tls_wallet(self) -> str:
        return pulumi.get(self, "tls_wallet")

    @property
    @pulumi.getter(name="vaultDetails")
    def vault_details(self) -> Sequence['outputs.GetConnectionsConnectionCollectionItemVaultDetailResult']:
        """
        Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        """
        return pulumi.get(self, "vault_details")


@pulumi.output_type
class GetConnectionsConnectionCollectionItemAdminCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetConnectionsConnectionCollectionItemAdminCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetConnectionsConnectionCollectionItemConnectDescriptorResult(dict):
    def __init__(__self__, *,
                 connect_string: str,
                 database_service_name: str,
                 host: str,
                 port: int):
        """
        :param str connect_string: Connect string.
        :param str database_service_name: Database service name.
        :param str host: Name of the host the SSH key is valid for.
        :param int port: Port of the connect descriptor.
        """
        GetConnectionsConnectionCollectionItemConnectDescriptorResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            connect_string=connect_string,
            database_service_name=database_service_name,
            host=host,
            port=port,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             connect_string: str,
             database_service_name: str,
             host: str,
             port: int,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("connect_string", connect_string)
        _setter("database_service_name", database_service_name)
        _setter("host", host)
        _setter("port", port)

    @property
    @pulumi.getter(name="connectString")
    def connect_string(self) -> str:
        """
        Connect string.
        """
        return pulumi.get(self, "connect_string")

    @property
    @pulumi.getter(name="databaseServiceName")
    def database_service_name(self) -> str:
        """
        Database service name.
        """
        return pulumi.get(self, "database_service_name")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Name of the host the SSH key is valid for.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port of the connect descriptor.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetConnectionsConnectionCollectionItemPrivateEndpointResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 id: str,
                 subnet_id: str,
                 vcn_id: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str id: [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a previously created Private Endpoint.
        :param str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer's subnet where the private endpoint VNIC will reside.
        :param str vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN where the Private Endpoint will be bound to.
        """
        GetConnectionsConnectionCollectionItemPrivateEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            id=id,
            subnet_id=subnet_id,
            vcn_id=vcn_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             id: str,
             subnet_id: str,
             vcn_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("id", id)
        _setter("subnet_id", subnet_id)
        _setter("vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a previously created Private Endpoint.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the customer's subnet where the private endpoint VNIC will reside.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN where the Private Endpoint will be bound to.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetConnectionsConnectionCollectionItemReplicationCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetConnectionsConnectionCollectionItemReplicationCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetConnectionsConnectionCollectionItemSshDetailResult(dict):
    def __init__(__self__, *,
                 host: str,
                 sshkey: str,
                 sudo_location: str,
                 user: str):
        """
        :param str host: Name of the host the SSH key is valid for.
        :param str sudo_location: Sudo location
        :param str user: SSH user
        """
        GetConnectionsConnectionCollectionItemSshDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            host=host,
            sshkey=sshkey,
            sudo_location=sudo_location,
            user=user,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             host: str,
             sshkey: str,
             sudo_location: str,
             user: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("host", host)
        _setter("sshkey", sshkey)
        _setter("sudo_location", sudo_location)
        _setter("user", user)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Name of the host the SSH key is valid for.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def sshkey(self) -> str:
        return pulumi.get(self, "sshkey")

    @property
    @pulumi.getter(name="sudoLocation")
    def sudo_location(self) -> str:
        """
        Sudo location
        """
        return pulumi.get(self, "sudo_location")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        SSH user
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class GetConnectionsConnectionCollectionItemVaultDetailResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 key_id: str,
                 vault_id: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str key_id: OCID of the vault encryption key
        :param str vault_id: OCID of the vault
        """
        GetConnectionsConnectionCollectionItemVaultDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            key_id=key_id,
            vault_id=vault_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             key_id: str,
             vault_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("key_id", key_id)
        _setter("vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        OCID of the vault encryption key
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        OCID of the vault
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetConnectionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetConnectionsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetJobAdvisorReportReportLocationDetailResult(dict):
    def __init__(__self__, *,
                 location_in_source: str,
                 object_storage_details: Sequence['outputs.GetJobAdvisorReportReportLocationDetailObjectStorageDetailResult']):
        """
        :param str location_in_source: Path in the Source Registered Connection where the Pre-Migration advisor report can be accessed.
        :param Sequence['GetJobAdvisorReportReportLocationDetailObjectStorageDetailArgs'] object_storage_details: Details to access Pre-Migration Advisor report in the specified Object Storage bucket, if any.
        """
        GetJobAdvisorReportReportLocationDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            location_in_source=location_in_source,
            object_storage_details=object_storage_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             location_in_source: str,
             object_storage_details: Sequence['outputs.GetJobAdvisorReportReportLocationDetailObjectStorageDetailResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("location_in_source", location_in_source)
        _setter("object_storage_details", object_storage_details)

    @property
    @pulumi.getter(name="locationInSource")
    def location_in_source(self) -> str:
        """
        Path in the Source Registered Connection where the Pre-Migration advisor report can be accessed.
        """
        return pulumi.get(self, "location_in_source")

    @property
    @pulumi.getter(name="objectStorageDetails")
    def object_storage_details(self) -> Sequence['outputs.GetJobAdvisorReportReportLocationDetailObjectStorageDetailResult']:
        """
        Details to access Pre-Migration Advisor report in the specified Object Storage bucket, if any.
        """
        return pulumi.get(self, "object_storage_details")


@pulumi.output_type
class GetJobAdvisorReportReportLocationDetailObjectStorageDetailResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: Name of the bucket containing the Pre-Migration Advisor report.
        :param str namespace: Object Storage namespace.
        :param str object: Pre-Migration Advisor report object name.
        """
        GetJobAdvisorReportReportLocationDetailObjectStorageDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
            object=object,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             object: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)
        _setter("object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the bucket containing the Pre-Migration Advisor report.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Pre-Migration Advisor report object name.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetJobOutputItemResult(dict):
    def __init__(__self__, *,
                 message: str):
        """
        :param str message: Job output line.
        """
        GetJobOutputItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            message=message,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             message: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("message", message)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Job output line.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class GetMigrationAdvisorSettingResult(dict):
    def __init__(__self__, *,
                 is_ignore_errors: bool,
                 is_skip_advisor: bool):
        """
        :param bool is_ignore_errors: True to not interrupt migration execution due to Pre-Migration Advisor errors. Default is false.
        :param bool is_skip_advisor: True to skip the Pre-Migration Advisor execution. Default is false.
        """
        GetMigrationAdvisorSettingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_ignore_errors=is_ignore_errors,
            is_skip_advisor=is_skip_advisor,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_ignore_errors: bool,
             is_skip_advisor: bool,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("is_ignore_errors", is_ignore_errors)
        _setter("is_skip_advisor", is_skip_advisor)

    @property
    @pulumi.getter(name="isIgnoreErrors")
    def is_ignore_errors(self) -> bool:
        """
        True to not interrupt migration execution due to Pre-Migration Advisor errors. Default is false.
        """
        return pulumi.get(self, "is_ignore_errors")

    @property
    @pulumi.getter(name="isSkipAdvisor")
    def is_skip_advisor(self) -> bool:
        """
        True to skip the Pre-Migration Advisor execution. Default is false.
        """
        return pulumi.get(self, "is_skip_advisor")


@pulumi.output_type
class GetMigrationDataTransferMediumDetailResult(dict):
    def __init__(__self__, *,
                 database_link_details: Sequence['outputs.GetMigrationDataTransferMediumDetailDatabaseLinkDetailResult'],
                 object_storage_details: Sequence['outputs.GetMigrationDataTransferMediumDetailObjectStorageDetailResult']):
        """
        :param Sequence['GetMigrationDataTransferMediumDetailDatabaseLinkDetailArgs'] database_link_details: Optional details for creating a network database link from Oracle Cloud Infrastructure database to on-premise database.
        :param Sequence['GetMigrationDataTransferMediumDetailObjectStorageDetailArgs'] object_storage_details: In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        GetMigrationDataTransferMediumDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            database_link_details=database_link_details,
            object_storage_details=object_storage_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             database_link_details: Sequence['outputs.GetMigrationDataTransferMediumDetailDatabaseLinkDetailResult'],
             object_storage_details: Sequence['outputs.GetMigrationDataTransferMediumDetailObjectStorageDetailResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("database_link_details", database_link_details)
        _setter("object_storage_details", object_storage_details)

    @property
    @pulumi.getter(name="databaseLinkDetails")
    def database_link_details(self) -> Sequence['outputs.GetMigrationDataTransferMediumDetailDatabaseLinkDetailResult']:
        """
        Optional details for creating a network database link from Oracle Cloud Infrastructure database to on-premise database.
        """
        return pulumi.get(self, "database_link_details")

    @property
    @pulumi.getter(name="objectStorageDetails")
    def object_storage_details(self) -> Sequence['outputs.GetMigrationDataTransferMediumDetailObjectStorageDetailResult']:
        """
        In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        return pulumi.get(self, "object_storage_details")


@pulumi.output_type
class GetMigrationDataTransferMediumDetailDatabaseLinkDetailResult(dict):
    def __init__(__self__, *,
                 name: str,
                 wallet_buckets: Sequence['outputs.GetMigrationDataTransferMediumDetailDatabaseLinkDetailWalletBucketResult']):
        """
        :param str name: Name of directory object in database
        :param Sequence['GetMigrationDataTransferMediumDetailDatabaseLinkDetailWalletBucketArgs'] wallet_buckets: In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        GetMigrationDataTransferMediumDetailDatabaseLinkDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            wallet_buckets=wallet_buckets,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             wallet_buckets: Sequence['outputs.GetMigrationDataTransferMediumDetailDatabaseLinkDetailWalletBucketResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("wallet_buckets", wallet_buckets)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of directory object in database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="walletBuckets")
    def wallet_buckets(self) -> Sequence['outputs.GetMigrationDataTransferMediumDetailDatabaseLinkDetailWalletBucketResult']:
        """
        In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        return pulumi.get(self, "wallet_buckets")


@pulumi.output_type
class GetMigrationDataTransferMediumDetailDatabaseLinkDetailWalletBucketResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str):
        """
        :param str bucket: Bucket name.
        :param str namespace: Namespace name of the object store bucket.
        """
        GetMigrationDataTransferMediumDetailDatabaseLinkDetailWalletBucketResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace name of the object store bucket.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetMigrationDataTransferMediumDetailObjectStorageDetailResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str):
        """
        :param str bucket: Bucket name.
        :param str namespace: Namespace name of the object store bucket.
        """
        GetMigrationDataTransferMediumDetailObjectStorageDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace name of the object store bucket.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetMigrationDataTransferMediumDetailsV2Result(dict):
    def __init__(__self__, *,
                 access_key_id: str,
                 name: str,
                 object_storage_buckets: Sequence['outputs.GetMigrationDataTransferMediumDetailsV2ObjectStorageBucketResult'],
                 region: str,
                 secret_access_key: str,
                 type: str):
        """
        :param str name: Name of directory object in database
        :param str type: Migration type.
        """
        GetMigrationDataTransferMediumDetailsV2Result._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_key_id=access_key_id,
            name=name,
            object_storage_buckets=object_storage_buckets,
            region=region,
            secret_access_key=secret_access_key,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_key_id: str,
             name: str,
             object_storage_buckets: Sequence['outputs.GetMigrationDataTransferMediumDetailsV2ObjectStorageBucketResult'],
             region: str,
             secret_access_key: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("access_key_id", access_key_id)
        _setter("name", name)
        _setter("object_storage_buckets", object_storage_buckets)
        _setter("region", region)
        _setter("secret_access_key", secret_access_key)
        _setter("type", type)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> str:
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of directory object in database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectStorageBuckets")
    def object_storage_buckets(self) -> Sequence['outputs.GetMigrationDataTransferMediumDetailsV2ObjectStorageBucketResult']:
        return pulumi.get(self, "object_storage_buckets")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> str:
        return pulumi.get(self, "secret_access_key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Migration type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMigrationDataTransferMediumDetailsV2ObjectStorageBucketResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str):
        """
        :param str bucket: Bucket name.
        :param str namespace: Namespace name of the object store bucket.
        """
        GetMigrationDataTransferMediumDetailsV2ObjectStorageBucketResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace name of the object store bucket.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetMigrationDatapumpSettingResult(dict):
    def __init__(__self__, *,
                 data_pump_parameters: Sequence['outputs.GetMigrationDatapumpSettingDataPumpParameterResult'],
                 export_directory_objects: Sequence['outputs.GetMigrationDatapumpSettingExportDirectoryObjectResult'],
                 import_directory_objects: Sequence['outputs.GetMigrationDatapumpSettingImportDirectoryObjectResult'],
                 job_mode: str,
                 metadata_remaps: Sequence['outputs.GetMigrationDatapumpSettingMetadataRemapResult']):
        """
        :param Sequence['GetMigrationDatapumpSettingDataPumpParameterArgs'] data_pump_parameters: Optional parameters for Data Pump Export and Import. Refer to [Configuring Optional Initial Load Advanced Settings](https://docs.us.oracle.com/en/cloud/paas/database-migration/dmsus/working-migration-resources.html#GUID-24BD3054-FDF8-48FF-8492-636C1D4B71ED)
        :param Sequence['GetMigrationDatapumpSettingExportDirectoryObjectArgs'] export_directory_objects: Directory object details, used to define either import or export directory objects in Data Pump Settings.
        :param Sequence['GetMigrationDatapumpSettingImportDirectoryObjectArgs'] import_directory_objects: Directory object details, used to define either import or export directory objects in Data Pump Settings.
        :param str job_mode: Data Pump job mode. Refer to [Data Pump Export Modes ](https://docs.oracle.com/en/database/oracle/oracle-database/19/sutil/oracle-data-pump-export-utility.html#GUID-8E497131-6B9B-4CC8-AA50-35F480CAC2C4)
        :param Sequence['GetMigrationDatapumpSettingMetadataRemapArgs'] metadata_remaps: Defines remapping to be applied to objects as they are processed. Refer to [METADATA_REMAP Procedure ](https://docs.oracle.com/en/database/oracle/oracle-database/19/arpls/DBMS_DATAPUMP.html#GUID-0FC32790-91E6-4781-87A3-229DE024CB3D)
        """
        GetMigrationDatapumpSettingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            data_pump_parameters=data_pump_parameters,
            export_directory_objects=export_directory_objects,
            import_directory_objects=import_directory_objects,
            job_mode=job_mode,
            metadata_remaps=metadata_remaps,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             data_pump_parameters: Sequence['outputs.GetMigrationDatapumpSettingDataPumpParameterResult'],
             export_directory_objects: Sequence['outputs.GetMigrationDatapumpSettingExportDirectoryObjectResult'],
             import_directory_objects: Sequence['outputs.GetMigrationDatapumpSettingImportDirectoryObjectResult'],
             job_mode: str,
             metadata_remaps: Sequence['outputs.GetMigrationDatapumpSettingMetadataRemapResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("data_pump_parameters", data_pump_parameters)
        _setter("export_directory_objects", export_directory_objects)
        _setter("import_directory_objects", import_directory_objects)
        _setter("job_mode", job_mode)
        _setter("metadata_remaps", metadata_remaps)

    @property
    @pulumi.getter(name="dataPumpParameters")
    def data_pump_parameters(self) -> Sequence['outputs.GetMigrationDatapumpSettingDataPumpParameterResult']:
        """
        Optional parameters for Data Pump Export and Import. Refer to [Configuring Optional Initial Load Advanced Settings](https://docs.us.oracle.com/en/cloud/paas/database-migration/dmsus/working-migration-resources.html#GUID-24BD3054-FDF8-48FF-8492-636C1D4B71ED)
        """
        return pulumi.get(self, "data_pump_parameters")

    @property
    @pulumi.getter(name="exportDirectoryObjects")
    def export_directory_objects(self) -> Sequence['outputs.GetMigrationDatapumpSettingExportDirectoryObjectResult']:
        """
        Directory object details, used to define either import or export directory objects in Data Pump Settings.
        """
        return pulumi.get(self, "export_directory_objects")

    @property
    @pulumi.getter(name="importDirectoryObjects")
    def import_directory_objects(self) -> Sequence['outputs.GetMigrationDatapumpSettingImportDirectoryObjectResult']:
        """
        Directory object details, used to define either import or export directory objects in Data Pump Settings.
        """
        return pulumi.get(self, "import_directory_objects")

    @property
    @pulumi.getter(name="jobMode")
    def job_mode(self) -> str:
        """
        Data Pump job mode. Refer to [Data Pump Export Modes ](https://docs.oracle.com/en/database/oracle/oracle-database/19/sutil/oracle-data-pump-export-utility.html#GUID-8E497131-6B9B-4CC8-AA50-35F480CAC2C4)
        """
        return pulumi.get(self, "job_mode")

    @property
    @pulumi.getter(name="metadataRemaps")
    def metadata_remaps(self) -> Sequence['outputs.GetMigrationDatapumpSettingMetadataRemapResult']:
        """
        Defines remapping to be applied to objects as they are processed. Refer to [METADATA_REMAP Procedure ](https://docs.oracle.com/en/database/oracle/oracle-database/19/arpls/DBMS_DATAPUMP.html#GUID-0FC32790-91E6-4781-87A3-229DE024CB3D)
        """
        return pulumi.get(self, "metadata_remaps")


@pulumi.output_type
class GetMigrationDatapumpSettingDataPumpParameterResult(dict):
    def __init__(__self__, *,
                 estimate: str,
                 exclude_parameters: Sequence[str],
                 export_parallelism_degree: int,
                 import_parallelism_degree: int,
                 is_cluster: bool,
                 table_exists_action: str):
        """
        :param str estimate: Estimate size of dumps that will be generated.
        :param Sequence[str] exclude_parameters: Exclude paratemers for Export and Import.
        :param int export_parallelism_degree: Maximum number of worker processes that can be used for a Data Pump Export job.
        :param int import_parallelism_degree: Maximum number of worker processes that can be used for a Data Pump Import job. For an Autonomous Database, ODMS will automatically query its CPU core count and set this property.
        :param bool is_cluster: Set to false to force Data Pump worker processes to run on one instance.
        :param str table_exists_action: IMPORT: Specifies the action to be performed when data is loaded into a preexisting table.
        """
        GetMigrationDatapumpSettingDataPumpParameterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            estimate=estimate,
            exclude_parameters=exclude_parameters,
            export_parallelism_degree=export_parallelism_degree,
            import_parallelism_degree=import_parallelism_degree,
            is_cluster=is_cluster,
            table_exists_action=table_exists_action,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             estimate: str,
             exclude_parameters: Sequence[str],
             export_parallelism_degree: int,
             import_parallelism_degree: int,
             is_cluster: bool,
             table_exists_action: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("estimate", estimate)
        _setter("exclude_parameters", exclude_parameters)
        _setter("export_parallelism_degree", export_parallelism_degree)
        _setter("import_parallelism_degree", import_parallelism_degree)
        _setter("is_cluster", is_cluster)
        _setter("table_exists_action", table_exists_action)

    @property
    @pulumi.getter
    def estimate(self) -> str:
        """
        Estimate size of dumps that will be generated.
        """
        return pulumi.get(self, "estimate")

    @property
    @pulumi.getter(name="excludeParameters")
    def exclude_parameters(self) -> Sequence[str]:
        """
        Exclude paratemers for Export and Import.
        """
        return pulumi.get(self, "exclude_parameters")

    @property
    @pulumi.getter(name="exportParallelismDegree")
    def export_parallelism_degree(self) -> int:
        """
        Maximum number of worker processes that can be used for a Data Pump Export job.
        """
        return pulumi.get(self, "export_parallelism_degree")

    @property
    @pulumi.getter(name="importParallelismDegree")
    def import_parallelism_degree(self) -> int:
        """
        Maximum number of worker processes that can be used for a Data Pump Import job. For an Autonomous Database, ODMS will automatically query its CPU core count and set this property.
        """
        return pulumi.get(self, "import_parallelism_degree")

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> bool:
        """
        Set to false to force Data Pump worker processes to run on one instance.
        """
        return pulumi.get(self, "is_cluster")

    @property
    @pulumi.getter(name="tableExistsAction")
    def table_exists_action(self) -> str:
        """
        IMPORT: Specifies the action to be performed when data is loaded into a preexisting table.
        """
        return pulumi.get(self, "table_exists_action")


@pulumi.output_type
class GetMigrationDatapumpSettingExportDirectoryObjectResult(dict):
    def __init__(__self__, *,
                 name: str,
                 path: str):
        """
        :param str name: Name of directory object in database
        :param str path: Absolute path of directory on database server
        """
        GetMigrationDatapumpSettingExportDirectoryObjectResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            path=path,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             path: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("path", path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of directory object in database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Absolute path of directory on database server
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetMigrationDatapumpSettingImportDirectoryObjectResult(dict):
    def __init__(__self__, *,
                 name: str,
                 path: str):
        """
        :param str name: Name of directory object in database
        :param str path: Absolute path of directory on database server
        """
        GetMigrationDatapumpSettingImportDirectoryObjectResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            path=path,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             path: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("path", path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of directory object in database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Absolute path of directory on database server
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetMigrationDatapumpSettingMetadataRemapResult(dict):
    def __init__(__self__, *,
                 new_value: str,
                 old_value: str,
                 type: str):
        """
        :param str new_value: Specifies the new value that oldValue should be translated into.
        :param str old_value: Specifies the value which needs to be reset.
        :param str type: Migration type.
        """
        GetMigrationDatapumpSettingMetadataRemapResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            new_value=new_value,
            old_value=old_value,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             new_value: str,
             old_value: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("new_value", new_value)
        _setter("old_value", old_value)
        _setter("type", type)

    @property
    @pulumi.getter(name="newValue")
    def new_value(self) -> str:
        """
        Specifies the new value that oldValue should be translated into.
        """
        return pulumi.get(self, "new_value")

    @property
    @pulumi.getter(name="oldValue")
    def old_value(self) -> str:
        """
        Specifies the value which needs to be reset.
        """
        return pulumi.get(self, "old_value")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Migration type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMigrationDumpTransferDetailResult(dict):
    def __init__(__self__, *,
                 shared_storage_mount_target_id: str,
                 sources: Sequence['outputs.GetMigrationDumpTransferDetailSourceResult'],
                 targets: Sequence['outputs.GetMigrationDumpTransferDetailTargetResult']):
        """
        :param Sequence['GetMigrationDumpTransferDetailSourceArgs'] sources: Optional additional properties for dump transfer in source or target host. Default kind is CURL
        :param Sequence['GetMigrationDumpTransferDetailTargetArgs'] targets: Optional additional properties for dump transfer in source or target host. Default kind is CURL
        """
        GetMigrationDumpTransferDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            shared_storage_mount_target_id=shared_storage_mount_target_id,
            sources=sources,
            targets=targets,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             shared_storage_mount_target_id: str,
             sources: Sequence['outputs.GetMigrationDumpTransferDetailSourceResult'],
             targets: Sequence['outputs.GetMigrationDumpTransferDetailTargetResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("shared_storage_mount_target_id", shared_storage_mount_target_id)
        _setter("sources", sources)
        _setter("targets", targets)

    @property
    @pulumi.getter(name="sharedStorageMountTargetId")
    def shared_storage_mount_target_id(self) -> str:
        return pulumi.get(self, "shared_storage_mount_target_id")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetMigrationDumpTransferDetailSourceResult']:
        """
        Optional additional properties for dump transfer in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetMigrationDumpTransferDetailTargetResult']:
        """
        Optional additional properties for dump transfer in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class GetMigrationDumpTransferDetailSourceResult(dict):
    def __init__(__self__, *,
                 kind: str,
                 oci_home: str,
                 wallet_location: str):
        """
        :param str kind: Type of dump transfer to use during migration in source or target host. Default kind is CURL
        :param str oci_home: Path to the Oracle Cloud Infrastructure CLI installation in the node.
        :param str wallet_location: Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        GetMigrationDumpTransferDetailSourceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kind=kind,
            oci_home=oci_home,
            wallet_location=wallet_location,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kind: str,
             oci_home: str,
             wallet_location: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("kind", kind)
        _setter("oci_home", oci_home)
        _setter("wallet_location", wallet_location)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of dump transfer to use during migration in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="ociHome")
    def oci_home(self) -> str:
        """
        Path to the Oracle Cloud Infrastructure CLI installation in the node.
        """
        return pulumi.get(self, "oci_home")

    @property
    @pulumi.getter(name="walletLocation")
    def wallet_location(self) -> str:
        """
        Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        return pulumi.get(self, "wallet_location")


@pulumi.output_type
class GetMigrationDumpTransferDetailTargetResult(dict):
    def __init__(__self__, *,
                 kind: str,
                 oci_home: str,
                 wallet_location: str):
        """
        :param str kind: Type of dump transfer to use during migration in source or target host. Default kind is CURL
        :param str oci_home: Path to the Oracle Cloud Infrastructure CLI installation in the node.
        :param str wallet_location: Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        GetMigrationDumpTransferDetailTargetResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kind=kind,
            oci_home=oci_home,
            wallet_location=wallet_location,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kind: str,
             oci_home: str,
             wallet_location: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("kind", kind)
        _setter("oci_home", oci_home)
        _setter("wallet_location", wallet_location)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of dump transfer to use during migration in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="ociHome")
    def oci_home(self) -> str:
        """
        Path to the Oracle Cloud Infrastructure CLI installation in the node.
        """
        return pulumi.get(self, "oci_home")

    @property
    @pulumi.getter(name="walletLocation")
    def wallet_location(self) -> str:
        """
        Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        return pulumi.get(self, "wallet_location")


@pulumi.output_type
class GetMigrationExcludeObjectResult(dict):
    def __init__(__self__, *,
                 is_omit_excluded_table_from_replication: bool,
                 object: str,
                 owner: str,
                 type: str):
        """
        :param bool is_omit_excluded_table_from_replication: Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        :param str object: Name of the object (regular expression is allowed)
        :param str owner: Owner of the object (regular expression is allowed)
        :param str type: Migration type.
        """
        GetMigrationExcludeObjectResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_omit_excluded_table_from_replication=is_omit_excluded_table_from_replication,
            object=object,
            owner=owner,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_omit_excluded_table_from_replication: bool,
             object: str,
             owner: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("is_omit_excluded_table_from_replication", is_omit_excluded_table_from_replication)
        _setter("object", object)
        _setter("owner", owner)
        _setter("type", type)

    @property
    @pulumi.getter(name="isOmitExcludedTableFromReplication")
    def is_omit_excluded_table_from_replication(self) -> bool:
        """
        Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        """
        return pulumi.get(self, "is_omit_excluded_table_from_replication")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Migration type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMigrationGoldenGateDetailResult(dict):
    def __init__(__self__, *,
                 hubs: Sequence['outputs.GetMigrationGoldenGateDetailHubResult'],
                 settings: Sequence['outputs.GetMigrationGoldenGateDetailSettingResult']):
        """
        :param Sequence['GetMigrationGoldenGateDetailHubArgs'] hubs: Details about Oracle GoldenGate Microservices.
        :param Sequence['GetMigrationGoldenGateDetailSettingArgs'] settings: Optional settings for Oracle GoldenGate processes
        """
        GetMigrationGoldenGateDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            hubs=hubs,
            settings=settings,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             hubs: Sequence['outputs.GetMigrationGoldenGateDetailHubResult'],
             settings: Sequence['outputs.GetMigrationGoldenGateDetailSettingResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("hubs", hubs)
        _setter("settings", settings)

    @property
    @pulumi.getter
    def hubs(self) -> Sequence['outputs.GetMigrationGoldenGateDetailHubResult']:
        """
        Details about Oracle GoldenGate Microservices.
        """
        return pulumi.get(self, "hubs")

    @property
    @pulumi.getter
    def settings(self) -> Sequence['outputs.GetMigrationGoldenGateDetailSettingResult']:
        """
        Optional settings for Oracle GoldenGate processes
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class GetMigrationGoldenGateDetailHubResult(dict):
    def __init__(__self__, *,
                 compute_id: str,
                 rest_admin_credentials: Sequence['outputs.GetMigrationGoldenGateDetailHubRestAdminCredentialResult'],
                 source_container_db_admin_credentials: Sequence['outputs.GetMigrationGoldenGateDetailHubSourceContainerDbAdminCredentialResult'],
                 source_db_admin_credentials: Sequence['outputs.GetMigrationGoldenGateDetailHubSourceDbAdminCredentialResult'],
                 source_microservices_deployment_name: str,
                 target_db_admin_credentials: Sequence['outputs.GetMigrationGoldenGateDetailHubTargetDbAdminCredentialResult'],
                 target_microservices_deployment_name: str,
                 url: str):
        """
        :param str compute_id: OCID of GoldenGate compute instance.
        :param Sequence['GetMigrationGoldenGateDetailHubRestAdminCredentialArgs'] rest_admin_credentials: Database Administrator Credentials details.
        :param Sequence['GetMigrationGoldenGateDetailHubSourceContainerDbAdminCredentialArgs'] source_container_db_admin_credentials: Database Administrator Credentials details.
        :param Sequence['GetMigrationGoldenGateDetailHubSourceDbAdminCredentialArgs'] source_db_admin_credentials: Database Administrator Credentials details.
        :param str source_microservices_deployment_name: Name of GoldenGate deployment to operate on source database
        :param Sequence['GetMigrationGoldenGateDetailHubTargetDbAdminCredentialArgs'] target_db_admin_credentials: Database Administrator Credentials details.
        :param str target_microservices_deployment_name: Name of GoldenGate deployment to operate on target database
        :param str url: Oracle GoldenGate hub's REST endpoint. Refer to https://docs.oracle.com/en/middleware/goldengate/core/19.1/securing/network.html#GUID-A709DA55-111D-455E-8942-C9BDD1E38CAA
        """
        GetMigrationGoldenGateDetailHubResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compute_id=compute_id,
            rest_admin_credentials=rest_admin_credentials,
            source_container_db_admin_credentials=source_container_db_admin_credentials,
            source_db_admin_credentials=source_db_admin_credentials,
            source_microservices_deployment_name=source_microservices_deployment_name,
            target_db_admin_credentials=target_db_admin_credentials,
            target_microservices_deployment_name=target_microservices_deployment_name,
            url=url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compute_id: str,
             rest_admin_credentials: Sequence['outputs.GetMigrationGoldenGateDetailHubRestAdminCredentialResult'],
             source_container_db_admin_credentials: Sequence['outputs.GetMigrationGoldenGateDetailHubSourceContainerDbAdminCredentialResult'],
             source_db_admin_credentials: Sequence['outputs.GetMigrationGoldenGateDetailHubSourceDbAdminCredentialResult'],
             source_microservices_deployment_name: str,
             target_db_admin_credentials: Sequence['outputs.GetMigrationGoldenGateDetailHubTargetDbAdminCredentialResult'],
             target_microservices_deployment_name: str,
             url: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compute_id", compute_id)
        _setter("rest_admin_credentials", rest_admin_credentials)
        _setter("source_container_db_admin_credentials", source_container_db_admin_credentials)
        _setter("source_db_admin_credentials", source_db_admin_credentials)
        _setter("source_microservices_deployment_name", source_microservices_deployment_name)
        _setter("target_db_admin_credentials", target_db_admin_credentials)
        _setter("target_microservices_deployment_name", target_microservices_deployment_name)
        _setter("url", url)

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> str:
        """
        OCID of GoldenGate compute instance.
        """
        return pulumi.get(self, "compute_id")

    @property
    @pulumi.getter(name="restAdminCredentials")
    def rest_admin_credentials(self) -> Sequence['outputs.GetMigrationGoldenGateDetailHubRestAdminCredentialResult']:
        """
        Database Administrator Credentials details.
        """
        return pulumi.get(self, "rest_admin_credentials")

    @property
    @pulumi.getter(name="sourceContainerDbAdminCredentials")
    def source_container_db_admin_credentials(self) -> Sequence['outputs.GetMigrationGoldenGateDetailHubSourceContainerDbAdminCredentialResult']:
        """
        Database Administrator Credentials details.
        """
        return pulumi.get(self, "source_container_db_admin_credentials")

    @property
    @pulumi.getter(name="sourceDbAdminCredentials")
    def source_db_admin_credentials(self) -> Sequence['outputs.GetMigrationGoldenGateDetailHubSourceDbAdminCredentialResult']:
        """
        Database Administrator Credentials details.
        """
        return pulumi.get(self, "source_db_admin_credentials")

    @property
    @pulumi.getter(name="sourceMicroservicesDeploymentName")
    def source_microservices_deployment_name(self) -> str:
        """
        Name of GoldenGate deployment to operate on source database
        """
        return pulumi.get(self, "source_microservices_deployment_name")

    @property
    @pulumi.getter(name="targetDbAdminCredentials")
    def target_db_admin_credentials(self) -> Sequence['outputs.GetMigrationGoldenGateDetailHubTargetDbAdminCredentialResult']:
        """
        Database Administrator Credentials details.
        """
        return pulumi.get(self, "target_db_admin_credentials")

    @property
    @pulumi.getter(name="targetMicroservicesDeploymentName")
    def target_microservices_deployment_name(self) -> str:
        """
        Name of GoldenGate deployment to operate on target database
        """
        return pulumi.get(self, "target_microservices_deployment_name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Oracle GoldenGate hub's REST endpoint. Refer to https://docs.oracle.com/en/middleware/goldengate/core/19.1/securing/network.html#GUID-A709DA55-111D-455E-8942-C9BDD1E38CAA
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetMigrationGoldenGateDetailHubRestAdminCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetMigrationGoldenGateDetailHubRestAdminCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMigrationGoldenGateDetailHubSourceContainerDbAdminCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetMigrationGoldenGateDetailHubSourceContainerDbAdminCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMigrationGoldenGateDetailHubSourceDbAdminCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetMigrationGoldenGateDetailHubSourceDbAdminCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMigrationGoldenGateDetailHubTargetDbAdminCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetMigrationGoldenGateDetailHubTargetDbAdminCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMigrationGoldenGateDetailSettingResult(dict):
    def __init__(__self__, *,
                 acceptable_lag: int,
                 extracts: Sequence['outputs.GetMigrationGoldenGateDetailSettingExtractResult'],
                 replicats: Sequence['outputs.GetMigrationGoldenGateDetailSettingReplicatResult']):
        """
        :param int acceptable_lag: ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        :param Sequence['GetMigrationGoldenGateDetailSettingExtractArgs'] extracts: Parameters for Extract processes.
        :param Sequence['GetMigrationGoldenGateDetailSettingReplicatArgs'] replicats: Parameters for Replicat processes.
        """
        GetMigrationGoldenGateDetailSettingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            acceptable_lag=acceptable_lag,
            extracts=extracts,
            replicats=replicats,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             acceptable_lag: int,
             extracts: Sequence['outputs.GetMigrationGoldenGateDetailSettingExtractResult'],
             replicats: Sequence['outputs.GetMigrationGoldenGateDetailSettingReplicatResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("acceptable_lag", acceptable_lag)
        _setter("extracts", extracts)
        _setter("replicats", replicats)

    @property
    @pulumi.getter(name="acceptableLag")
    def acceptable_lag(self) -> int:
        """
        ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        """
        return pulumi.get(self, "acceptable_lag")

    @property
    @pulumi.getter
    def extracts(self) -> Sequence['outputs.GetMigrationGoldenGateDetailSettingExtractResult']:
        """
        Parameters for Extract processes.
        """
        return pulumi.get(self, "extracts")

    @property
    @pulumi.getter
    def replicats(self) -> Sequence['outputs.GetMigrationGoldenGateDetailSettingReplicatResult']:
        """
        Parameters for Replicat processes.
        """
        return pulumi.get(self, "replicats")


@pulumi.output_type
class GetMigrationGoldenGateDetailSettingExtractResult(dict):
    def __init__(__self__, *,
                 long_trans_duration: int,
                 performance_profile: str):
        """
        :param int long_trans_duration: Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        :param str performance_profile: Extract performance.
        """
        GetMigrationGoldenGateDetailSettingExtractResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            long_trans_duration=long_trans_duration,
            performance_profile=performance_profile,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             long_trans_duration: int,
             performance_profile: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("long_trans_duration", long_trans_duration)
        _setter("performance_profile", performance_profile)

    @property
    @pulumi.getter(name="longTransDuration")
    def long_trans_duration(self) -> int:
        """
        Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        """
        return pulumi.get(self, "long_trans_duration")

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> str:
        """
        Extract performance.
        """
        return pulumi.get(self, "performance_profile")


@pulumi.output_type
class GetMigrationGoldenGateDetailSettingReplicatResult(dict):
    def __init__(__self__, *,
                 map_parallelism: int,
                 max_apply_parallelism: int,
                 min_apply_parallelism: int,
                 performance_profile: str):
        """
        :param int map_parallelism: Number of threads used to read trail files (valid for Parallel Replicat)
        :param int max_apply_parallelism: Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        :param int min_apply_parallelism: Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        :param str performance_profile: Extract performance.
        """
        GetMigrationGoldenGateDetailSettingReplicatResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            map_parallelism=map_parallelism,
            max_apply_parallelism=max_apply_parallelism,
            min_apply_parallelism=min_apply_parallelism,
            performance_profile=performance_profile,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             map_parallelism: int,
             max_apply_parallelism: int,
             min_apply_parallelism: int,
             performance_profile: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("map_parallelism", map_parallelism)
        _setter("max_apply_parallelism", max_apply_parallelism)
        _setter("min_apply_parallelism", min_apply_parallelism)
        _setter("performance_profile", performance_profile)

    @property
    @pulumi.getter(name="mapParallelism")
    def map_parallelism(self) -> int:
        """
        Number of threads used to read trail files (valid for Parallel Replicat)
        """
        return pulumi.get(self, "map_parallelism")

    @property
    @pulumi.getter(name="maxApplyParallelism")
    def max_apply_parallelism(self) -> int:
        """
        Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "max_apply_parallelism")

    @property
    @pulumi.getter(name="minApplyParallelism")
    def min_apply_parallelism(self) -> int:
        """
        Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "min_apply_parallelism")

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> str:
        """
        Extract performance.
        """
        return pulumi.get(self, "performance_profile")


@pulumi.output_type
class GetMigrationGoldenGateServiceDetailResult(dict):
    def __init__(__self__, *,
                 ggs_deployments: Sequence['outputs.GetMigrationGoldenGateServiceDetailGgsDeploymentResult'],
                 settings: Sequence['outputs.GetMigrationGoldenGateServiceDetailSettingResult'],
                 source_container_db_credentials: Sequence['outputs.GetMigrationGoldenGateServiceDetailSourceContainerDbCredentialResult'],
                 source_db_credentials: Sequence['outputs.GetMigrationGoldenGateServiceDetailSourceDbCredentialResult'],
                 target_db_credentials: Sequence['outputs.GetMigrationGoldenGateServiceDetailTargetDbCredentialResult']):
        """
        :param Sequence['GetMigrationGoldenGateServiceDetailGgsDeploymentArgs'] ggs_deployments: Details about Oracle GoldenGate GGS Deployment.
        :param Sequence['GetMigrationGoldenGateServiceDetailSettingArgs'] settings: Optional settings for Oracle GoldenGate processes
        """
        GetMigrationGoldenGateServiceDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ggs_deployments=ggs_deployments,
            settings=settings,
            source_container_db_credentials=source_container_db_credentials,
            source_db_credentials=source_db_credentials,
            target_db_credentials=target_db_credentials,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ggs_deployments: Sequence['outputs.GetMigrationGoldenGateServiceDetailGgsDeploymentResult'],
             settings: Sequence['outputs.GetMigrationGoldenGateServiceDetailSettingResult'],
             source_container_db_credentials: Sequence['outputs.GetMigrationGoldenGateServiceDetailSourceContainerDbCredentialResult'],
             source_db_credentials: Sequence['outputs.GetMigrationGoldenGateServiceDetailSourceDbCredentialResult'],
             target_db_credentials: Sequence['outputs.GetMigrationGoldenGateServiceDetailTargetDbCredentialResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("ggs_deployments", ggs_deployments)
        _setter("settings", settings)
        _setter("source_container_db_credentials", source_container_db_credentials)
        _setter("source_db_credentials", source_db_credentials)
        _setter("target_db_credentials", target_db_credentials)

    @property
    @pulumi.getter(name="ggsDeployments")
    def ggs_deployments(self) -> Sequence['outputs.GetMigrationGoldenGateServiceDetailGgsDeploymentResult']:
        """
        Details about Oracle GoldenGate GGS Deployment.
        """
        return pulumi.get(self, "ggs_deployments")

    @property
    @pulumi.getter
    def settings(self) -> Sequence['outputs.GetMigrationGoldenGateServiceDetailSettingResult']:
        """
        Optional settings for Oracle GoldenGate processes
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="sourceContainerDbCredentials")
    def source_container_db_credentials(self) -> Sequence['outputs.GetMigrationGoldenGateServiceDetailSourceContainerDbCredentialResult']:
        return pulumi.get(self, "source_container_db_credentials")

    @property
    @pulumi.getter(name="sourceDbCredentials")
    def source_db_credentials(self) -> Sequence['outputs.GetMigrationGoldenGateServiceDetailSourceDbCredentialResult']:
        return pulumi.get(self, "source_db_credentials")

    @property
    @pulumi.getter(name="targetDbCredentials")
    def target_db_credentials(self) -> Sequence['outputs.GetMigrationGoldenGateServiceDetailTargetDbCredentialResult']:
        return pulumi.get(self, "target_db_credentials")


@pulumi.output_type
class GetMigrationGoldenGateServiceDetailGgsDeploymentResult(dict):
    def __init__(__self__, *,
                 deployment_id: str,
                 ggs_admin_credentials_secret_id: str):
        """
        :param str deployment_id: OCID of a GoldenGate Deployment
        :param str ggs_admin_credentials_secret_id: OCID of a VaultSecret containing the Admin Credentials for the GGS Deployment
        """
        GetMigrationGoldenGateServiceDetailGgsDeploymentResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            deployment_id=deployment_id,
            ggs_admin_credentials_secret_id=ggs_admin_credentials_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             deployment_id: str,
             ggs_admin_credentials_secret_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("deployment_id", deployment_id)
        _setter("ggs_admin_credentials_secret_id", ggs_admin_credentials_secret_id)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> str:
        """
        OCID of a GoldenGate Deployment
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="ggsAdminCredentialsSecretId")
    def ggs_admin_credentials_secret_id(self) -> str:
        """
        OCID of a VaultSecret containing the Admin Credentials for the GGS Deployment
        """
        return pulumi.get(self, "ggs_admin_credentials_secret_id")


@pulumi.output_type
class GetMigrationGoldenGateServiceDetailSettingResult(dict):
    def __init__(__self__, *,
                 acceptable_lag: int,
                 extracts: Sequence['outputs.GetMigrationGoldenGateServiceDetailSettingExtractResult'],
                 replicats: Sequence['outputs.GetMigrationGoldenGateServiceDetailSettingReplicatResult']):
        """
        :param int acceptable_lag: ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        :param Sequence['GetMigrationGoldenGateServiceDetailSettingExtractArgs'] extracts: Parameters for Extract processes.
        :param Sequence['GetMigrationGoldenGateServiceDetailSettingReplicatArgs'] replicats: Parameters for Replicat processes.
        """
        GetMigrationGoldenGateServiceDetailSettingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            acceptable_lag=acceptable_lag,
            extracts=extracts,
            replicats=replicats,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             acceptable_lag: int,
             extracts: Sequence['outputs.GetMigrationGoldenGateServiceDetailSettingExtractResult'],
             replicats: Sequence['outputs.GetMigrationGoldenGateServiceDetailSettingReplicatResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("acceptable_lag", acceptable_lag)
        _setter("extracts", extracts)
        _setter("replicats", replicats)

    @property
    @pulumi.getter(name="acceptableLag")
    def acceptable_lag(self) -> int:
        """
        ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        """
        return pulumi.get(self, "acceptable_lag")

    @property
    @pulumi.getter
    def extracts(self) -> Sequence['outputs.GetMigrationGoldenGateServiceDetailSettingExtractResult']:
        """
        Parameters for Extract processes.
        """
        return pulumi.get(self, "extracts")

    @property
    @pulumi.getter
    def replicats(self) -> Sequence['outputs.GetMigrationGoldenGateServiceDetailSettingReplicatResult']:
        """
        Parameters for Replicat processes.
        """
        return pulumi.get(self, "replicats")


@pulumi.output_type
class GetMigrationGoldenGateServiceDetailSettingExtractResult(dict):
    def __init__(__self__, *,
                 long_trans_duration: int,
                 performance_profile: str):
        """
        :param int long_trans_duration: Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        :param str performance_profile: Extract performance.
        """
        GetMigrationGoldenGateServiceDetailSettingExtractResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            long_trans_duration=long_trans_duration,
            performance_profile=performance_profile,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             long_trans_duration: int,
             performance_profile: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("long_trans_duration", long_trans_duration)
        _setter("performance_profile", performance_profile)

    @property
    @pulumi.getter(name="longTransDuration")
    def long_trans_duration(self) -> int:
        """
        Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        """
        return pulumi.get(self, "long_trans_duration")

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> str:
        """
        Extract performance.
        """
        return pulumi.get(self, "performance_profile")


@pulumi.output_type
class GetMigrationGoldenGateServiceDetailSettingReplicatResult(dict):
    def __init__(__self__, *,
                 map_parallelism: int,
                 max_apply_parallelism: int,
                 min_apply_parallelism: int):
        """
        :param int map_parallelism: Number of threads used to read trail files (valid for Parallel Replicat)
        :param int max_apply_parallelism: Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        :param int min_apply_parallelism: Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        GetMigrationGoldenGateServiceDetailSettingReplicatResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            map_parallelism=map_parallelism,
            max_apply_parallelism=max_apply_parallelism,
            min_apply_parallelism=min_apply_parallelism,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             map_parallelism: int,
             max_apply_parallelism: int,
             min_apply_parallelism: int,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("map_parallelism", map_parallelism)
        _setter("max_apply_parallelism", max_apply_parallelism)
        _setter("min_apply_parallelism", min_apply_parallelism)

    @property
    @pulumi.getter(name="mapParallelism")
    def map_parallelism(self) -> int:
        """
        Number of threads used to read trail files (valid for Parallel Replicat)
        """
        return pulumi.get(self, "map_parallelism")

    @property
    @pulumi.getter(name="maxApplyParallelism")
    def max_apply_parallelism(self) -> int:
        """
        Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "max_apply_parallelism")

    @property
    @pulumi.getter(name="minApplyParallelism")
    def min_apply_parallelism(self) -> int:
        """
        Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "min_apply_parallelism")


@pulumi.output_type
class GetMigrationGoldenGateServiceDetailSourceContainerDbCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetMigrationGoldenGateServiceDetailSourceContainerDbCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMigrationGoldenGateServiceDetailSourceDbCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetMigrationGoldenGateServiceDetailSourceDbCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMigrationGoldenGateServiceDetailTargetDbCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetMigrationGoldenGateServiceDetailTargetDbCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMigrationIncludeObjectResult(dict):
    def __init__(__self__, *,
                 is_omit_excluded_table_from_replication: bool,
                 object: str,
                 owner: str,
                 type: str):
        """
        :param bool is_omit_excluded_table_from_replication: Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        :param str object: Name of the object (regular expression is allowed)
        :param str owner: Owner of the object (regular expression is allowed)
        :param str type: Migration type.
        """
        GetMigrationIncludeObjectResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_omit_excluded_table_from_replication=is_omit_excluded_table_from_replication,
            object=object,
            owner=owner,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_omit_excluded_table_from_replication: bool,
             object: str,
             owner: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("is_omit_excluded_table_from_replication", is_omit_excluded_table_from_replication)
        _setter("object", object)
        _setter("owner", owner)
        _setter("type", type)

    @property
    @pulumi.getter(name="isOmitExcludedTableFromReplication")
    def is_omit_excluded_table_from_replication(self) -> bool:
        """
        Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        """
        return pulumi.get(self, "is_omit_excluded_table_from_replication")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Migration type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMigrationObjectTypesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Object type name
        """
        GetMigrationObjectTypesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Object type name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionItemResult']):
        """
        :param Sequence['GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionItemArgs'] items: Items in collection.
        """
        GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionItemResult']:
        """
        Items in collection.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: Object type name
        """
        GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Object type name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetMigrationVaultDetailResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 key_id: str,
                 vault_id: str):
        """
        :param str compartment_id: OCID of the compartment where the secret containing the credentials will be created.
        :param str key_id: OCID of the vault encryption key
        :param str vault_id: OCID of the vault
        """
        GetMigrationVaultDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            key_id=key_id,
            vault_id=vault_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             key_id: str,
             vault_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("key_id", key_id)
        _setter("vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        OCID of the vault encryption key
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        OCID of the vault
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetMigrationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of directory object in database
        """
        GetMigrationsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of directory object in database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMigrationsMigrationCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetMigrationsMigrationCollectionItemResult']):
        GetMigrationsMigrationCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetMigrationsMigrationCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemResult(dict):
    def __init__(__self__, *,
                 advisor_settings: Sequence['outputs.GetMigrationsMigrationCollectionItemAdvisorSettingResult'],
                 agent_id: str,
                 compartment_id: str,
                 credentials_secret_id: str,
                 csv_text: str,
                 data_transfer_medium_details: Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailResult'],
                 data_transfer_medium_details_v2s: Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailsV2Result'],
                 datapump_settings: Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingResult'],
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 dump_transfer_details: Sequence['outputs.GetMigrationsMigrationCollectionItemDumpTransferDetailResult'],
                 exclude_objects: Sequence['outputs.GetMigrationsMigrationCollectionItemExcludeObjectResult'],
                 executing_job_id: str,
                 freeform_tags: Mapping[str, Any],
                 golden_gate_details: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailResult'],
                 golden_gate_service_details: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailResult'],
                 id: str,
                 include_objects: Sequence['outputs.GetMigrationsMigrationCollectionItemIncludeObjectResult'],
                 lifecycle_details: str,
                 source_container_database_connection_id: str,
                 source_database_connection_id: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 target_database_connection_id: str,
                 time_created: str,
                 time_last_migration: str,
                 time_updated: str,
                 type: str,
                 vault_details: Sequence['outputs.GetMigrationsMigrationCollectionItemVaultDetailResult'],
                 wait_after: str):
        """
        :param Sequence['GetMigrationsMigrationCollectionItemAdvisorSettingArgs'] advisor_settings: Optional Pre-Migration advisor settings.
        :param str agent_id: The OCID of the registered on-premises ODMS Agent. Only valid for Offline Migrations.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str credentials_secret_id: OCID of the Secret in the Oracle Cloud Infrastructure vault containing the Migration credentials. Used to store GoldenGate administrator user credentials.
        :param Sequence['GetMigrationsMigrationCollectionItemDataTransferMediumDetailArgs'] data_transfer_medium_details: Data Transfer Medium details for the Migration.
        :param Sequence['GetMigrationsMigrationCollectionItemDatapumpSettingArgs'] datapump_settings: Optional settings for Data Pump Export and Import jobs
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Sequence['GetMigrationsMigrationCollectionItemDumpTransferDetailArgs'] dump_transfer_details: Optional additional properties for dump transfer.
        :param Sequence['GetMigrationsMigrationCollectionItemExcludeObjectArgs'] exclude_objects: Database objects to exclude from migration. If 'includeObjects' are specified, only exclude object types can be specified with general wildcards (.*) for owner and objectName.
        :param str executing_job_id: OCID of the current ODMS Job in execution for the Migration, if any.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param Sequence['GetMigrationsMigrationCollectionItemGoldenGateDetailArgs'] golden_gate_details: Details about Oracle GoldenGate Microservices.
        :param Sequence['GetMigrationsMigrationCollectionItemGoldenGateServiceDetailArgs'] golden_gate_service_details: Details about Oracle GoldenGate GGS Deployment.
        :param str id: The OCID of the resource
        :param Sequence['GetMigrationsMigrationCollectionItemIncludeObjectArgs'] include_objects: Database objects to include from migration.
        :param str lifecycle_details: The lifecycle detailed status of the Migration.
        :param str source_container_database_connection_id: The OCID of the Source Container Database Connection.
        :param str source_database_connection_id: The OCID of the Source Database Connection.
        :param str state: The lifecycle state of the Migration.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str target_database_connection_id: The OCID of the Target Database Connection.
        :param str time_created: The time the Migration was created. An RFC3339 formatted datetime string.
        :param str time_last_migration: The time of last Migration. An RFC3339 formatted datetime string.
        :param str time_updated: The time of the last Migration details update. An RFC3339 formatted datetime string.
        :param str type: Migration type.
        :param Sequence['GetMigrationsMigrationCollectionItemVaultDetailArgs'] vault_details: Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        :param str wait_after: Name of a migration phase. The Job will wait after executing this phase until the Resume Job endpoint is called.
        """
        GetMigrationsMigrationCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            advisor_settings=advisor_settings,
            agent_id=agent_id,
            compartment_id=compartment_id,
            credentials_secret_id=credentials_secret_id,
            csv_text=csv_text,
            data_transfer_medium_details=data_transfer_medium_details,
            data_transfer_medium_details_v2s=data_transfer_medium_details_v2s,
            datapump_settings=datapump_settings,
            defined_tags=defined_tags,
            display_name=display_name,
            dump_transfer_details=dump_transfer_details,
            exclude_objects=exclude_objects,
            executing_job_id=executing_job_id,
            freeform_tags=freeform_tags,
            golden_gate_details=golden_gate_details,
            golden_gate_service_details=golden_gate_service_details,
            id=id,
            include_objects=include_objects,
            lifecycle_details=lifecycle_details,
            source_container_database_connection_id=source_container_database_connection_id,
            source_database_connection_id=source_database_connection_id,
            state=state,
            system_tags=system_tags,
            target_database_connection_id=target_database_connection_id,
            time_created=time_created,
            time_last_migration=time_last_migration,
            time_updated=time_updated,
            type=type,
            vault_details=vault_details,
            wait_after=wait_after,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             advisor_settings: Sequence['outputs.GetMigrationsMigrationCollectionItemAdvisorSettingResult'],
             agent_id: str,
             compartment_id: str,
             credentials_secret_id: str,
             csv_text: str,
             data_transfer_medium_details: Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailResult'],
             data_transfer_medium_details_v2s: Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailsV2Result'],
             datapump_settings: Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingResult'],
             defined_tags: Mapping[str, Any],
             display_name: str,
             dump_transfer_details: Sequence['outputs.GetMigrationsMigrationCollectionItemDumpTransferDetailResult'],
             exclude_objects: Sequence['outputs.GetMigrationsMigrationCollectionItemExcludeObjectResult'],
             executing_job_id: str,
             freeform_tags: Mapping[str, Any],
             golden_gate_details: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailResult'],
             golden_gate_service_details: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailResult'],
             id: str,
             include_objects: Sequence['outputs.GetMigrationsMigrationCollectionItemIncludeObjectResult'],
             lifecycle_details: str,
             source_container_database_connection_id: str,
             source_database_connection_id: str,
             state: str,
             system_tags: Mapping[str, Any],
             target_database_connection_id: str,
             time_created: str,
             time_last_migration: str,
             time_updated: str,
             type: str,
             vault_details: Sequence['outputs.GetMigrationsMigrationCollectionItemVaultDetailResult'],
             wait_after: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("advisor_settings", advisor_settings)
        _setter("agent_id", agent_id)
        _setter("compartment_id", compartment_id)
        _setter("credentials_secret_id", credentials_secret_id)
        _setter("csv_text", csv_text)
        _setter("data_transfer_medium_details", data_transfer_medium_details)
        _setter("data_transfer_medium_details_v2s", data_transfer_medium_details_v2s)
        _setter("datapump_settings", datapump_settings)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("dump_transfer_details", dump_transfer_details)
        _setter("exclude_objects", exclude_objects)
        _setter("executing_job_id", executing_job_id)
        _setter("freeform_tags", freeform_tags)
        _setter("golden_gate_details", golden_gate_details)
        _setter("golden_gate_service_details", golden_gate_service_details)
        _setter("id", id)
        _setter("include_objects", include_objects)
        _setter("lifecycle_details", lifecycle_details)
        _setter("source_container_database_connection_id", source_container_database_connection_id)
        _setter("source_database_connection_id", source_database_connection_id)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("target_database_connection_id", target_database_connection_id)
        _setter("time_created", time_created)
        _setter("time_last_migration", time_last_migration)
        _setter("time_updated", time_updated)
        _setter("type", type)
        _setter("vault_details", vault_details)
        _setter("wait_after", wait_after)

    @property
    @pulumi.getter(name="advisorSettings")
    def advisor_settings(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemAdvisorSettingResult']:
        """
        Optional Pre-Migration advisor settings.
        """
        return pulumi.get(self, "advisor_settings")

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> str:
        """
        The OCID of the registered on-premises ODMS Agent. Only valid for Offline Migrations.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="credentialsSecretId")
    def credentials_secret_id(self) -> str:
        """
        OCID of the Secret in the Oracle Cloud Infrastructure vault containing the Migration credentials. Used to store GoldenGate administrator user credentials.
        """
        return pulumi.get(self, "credentials_secret_id")

    @property
    @pulumi.getter(name="csvText")
    def csv_text(self) -> str:
        return pulumi.get(self, "csv_text")

    @property
    @pulumi.getter(name="dataTransferMediumDetails")
    def data_transfer_medium_details(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailResult']:
        """
        Data Transfer Medium details for the Migration.
        """
        return pulumi.get(self, "data_transfer_medium_details")

    @property
    @pulumi.getter(name="dataTransferMediumDetailsV2s")
    def data_transfer_medium_details_v2s(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailsV2Result']:
        return pulumi.get(self, "data_transfer_medium_details_v2s")

    @property
    @pulumi.getter(name="datapumpSettings")
    def datapump_settings(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingResult']:
        """
        Optional settings for Data Pump Export and Import jobs
        """
        return pulumi.get(self, "datapump_settings")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dumpTransferDetails")
    def dump_transfer_details(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemDumpTransferDetailResult']:
        """
        Optional additional properties for dump transfer.
        """
        return pulumi.get(self, "dump_transfer_details")

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemExcludeObjectResult']:
        """
        Database objects to exclude from migration. If 'includeObjects' are specified, only exclude object types can be specified with general wildcards (.*) for owner and objectName.
        """
        return pulumi.get(self, "exclude_objects")

    @property
    @pulumi.getter(name="executingJobId")
    def executing_job_id(self) -> str:
        """
        OCID of the current ODMS Job in execution for the Migration, if any.
        """
        return pulumi.get(self, "executing_job_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="goldenGateDetails")
    def golden_gate_details(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailResult']:
        """
        Details about Oracle GoldenGate Microservices.
        """
        return pulumi.get(self, "golden_gate_details")

    @property
    @pulumi.getter(name="goldenGateServiceDetails")
    def golden_gate_service_details(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailResult']:
        """
        Details about Oracle GoldenGate GGS Deployment.
        """
        return pulumi.get(self, "golden_gate_service_details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemIncludeObjectResult']:
        """
        Database objects to include from migration.
        """
        return pulumi.get(self, "include_objects")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        The lifecycle detailed status of the Migration.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="sourceContainerDatabaseConnectionId")
    def source_container_database_connection_id(self) -> str:
        """
        The OCID of the Source Container Database Connection.
        """
        return pulumi.get(self, "source_container_database_connection_id")

    @property
    @pulumi.getter(name="sourceDatabaseConnectionId")
    def source_database_connection_id(self) -> str:
        """
        The OCID of the Source Database Connection.
        """
        return pulumi.get(self, "source_database_connection_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the Migration.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetDatabaseConnectionId")
    def target_database_connection_id(self) -> str:
        """
        The OCID of the Target Database Connection.
        """
        return pulumi.get(self, "target_database_connection_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the Migration was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastMigration")
    def time_last_migration(self) -> str:
        """
        The time of last Migration. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_last_migration")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time of the last Migration details update. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Migration type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vaultDetails")
    def vault_details(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemVaultDetailResult']:
        """
        Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        """
        return pulumi.get(self, "vault_details")

    @property
    @pulumi.getter(name="waitAfter")
    def wait_after(self) -> str:
        """
        Name of a migration phase. The Job will wait after executing this phase until the Resume Job endpoint is called.
        """
        return pulumi.get(self, "wait_after")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemAdvisorSettingResult(dict):
    def __init__(__self__, *,
                 is_ignore_errors: bool,
                 is_skip_advisor: bool):
        """
        :param bool is_ignore_errors: True to not interrupt migration execution due to Pre-Migration Advisor errors. Default is false.
        :param bool is_skip_advisor: True to skip the Pre-Migration Advisor execution. Default is false.
        """
        GetMigrationsMigrationCollectionItemAdvisorSettingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_ignore_errors=is_ignore_errors,
            is_skip_advisor=is_skip_advisor,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_ignore_errors: bool,
             is_skip_advisor: bool,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("is_ignore_errors", is_ignore_errors)
        _setter("is_skip_advisor", is_skip_advisor)

    @property
    @pulumi.getter(name="isIgnoreErrors")
    def is_ignore_errors(self) -> bool:
        """
        True to not interrupt migration execution due to Pre-Migration Advisor errors. Default is false.
        """
        return pulumi.get(self, "is_ignore_errors")

    @property
    @pulumi.getter(name="isSkipAdvisor")
    def is_skip_advisor(self) -> bool:
        """
        True to skip the Pre-Migration Advisor execution. Default is false.
        """
        return pulumi.get(self, "is_skip_advisor")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemDataTransferMediumDetailResult(dict):
    def __init__(__self__, *,
                 database_link_details: Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailDatabaseLinkDetailResult'],
                 object_storage_details: Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailObjectStorageDetailResult']):
        """
        :param Sequence['GetMigrationsMigrationCollectionItemDataTransferMediumDetailDatabaseLinkDetailArgs'] database_link_details: Optional details for creating a network database link from Oracle Cloud Infrastructure database to on-premise database.
        :param Sequence['GetMigrationsMigrationCollectionItemDataTransferMediumDetailObjectStorageDetailArgs'] object_storage_details: In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        GetMigrationsMigrationCollectionItemDataTransferMediumDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            database_link_details=database_link_details,
            object_storage_details=object_storage_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             database_link_details: Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailDatabaseLinkDetailResult'],
             object_storage_details: Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailObjectStorageDetailResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("database_link_details", database_link_details)
        _setter("object_storage_details", object_storage_details)

    @property
    @pulumi.getter(name="databaseLinkDetails")
    def database_link_details(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailDatabaseLinkDetailResult']:
        """
        Optional details for creating a network database link from Oracle Cloud Infrastructure database to on-premise database.
        """
        return pulumi.get(self, "database_link_details")

    @property
    @pulumi.getter(name="objectStorageDetails")
    def object_storage_details(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailObjectStorageDetailResult']:
        """
        In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        return pulumi.get(self, "object_storage_details")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemDataTransferMediumDetailDatabaseLinkDetailResult(dict):
    def __init__(__self__, *,
                 name: str,
                 wallet_buckets: Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailDatabaseLinkDetailWalletBucketResult']):
        """
        :param str name: Name of directory object in database
        :param Sequence['GetMigrationsMigrationCollectionItemDataTransferMediumDetailDatabaseLinkDetailWalletBucketArgs'] wallet_buckets: In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        GetMigrationsMigrationCollectionItemDataTransferMediumDetailDatabaseLinkDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            wallet_buckets=wallet_buckets,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             wallet_buckets: Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailDatabaseLinkDetailWalletBucketResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("wallet_buckets", wallet_buckets)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of directory object in database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="walletBuckets")
    def wallet_buckets(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailDatabaseLinkDetailWalletBucketResult']:
        """
        In lieu of a network database link, Oracle Cloud Infrastructure Object Storage bucket will be used to store Data Pump dump files for the migration. Additionally, it can be specified alongside a database link data transfer medium.
        """
        return pulumi.get(self, "wallet_buckets")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemDataTransferMediumDetailDatabaseLinkDetailWalletBucketResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str):
        """
        :param str bucket: Bucket name.
        :param str namespace: Namespace name of the object store bucket.
        """
        GetMigrationsMigrationCollectionItemDataTransferMediumDetailDatabaseLinkDetailWalletBucketResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace name of the object store bucket.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemDataTransferMediumDetailObjectStorageDetailResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str):
        """
        :param str bucket: Bucket name.
        :param str namespace: Namespace name of the object store bucket.
        """
        GetMigrationsMigrationCollectionItemDataTransferMediumDetailObjectStorageDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace name of the object store bucket.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemDataTransferMediumDetailsV2Result(dict):
    def __init__(__self__, *,
                 access_key_id: str,
                 name: str,
                 object_storage_buckets: Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailsV2ObjectStorageBucketResult'],
                 region: str,
                 secret_access_key: str,
                 type: str):
        """
        :param str name: Name of directory object in database
        :param str type: Migration type.
        """
        GetMigrationsMigrationCollectionItemDataTransferMediumDetailsV2Result._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_key_id=access_key_id,
            name=name,
            object_storage_buckets=object_storage_buckets,
            region=region,
            secret_access_key=secret_access_key,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_key_id: str,
             name: str,
             object_storage_buckets: Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailsV2ObjectStorageBucketResult'],
             region: str,
             secret_access_key: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("access_key_id", access_key_id)
        _setter("name", name)
        _setter("object_storage_buckets", object_storage_buckets)
        _setter("region", region)
        _setter("secret_access_key", secret_access_key)
        _setter("type", type)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> str:
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of directory object in database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectStorageBuckets")
    def object_storage_buckets(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemDataTransferMediumDetailsV2ObjectStorageBucketResult']:
        return pulumi.get(self, "object_storage_buckets")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> str:
        return pulumi.get(self, "secret_access_key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Migration type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemDataTransferMediumDetailsV2ObjectStorageBucketResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str):
        """
        :param str bucket: Bucket name.
        :param str namespace: Namespace name of the object store bucket.
        """
        GetMigrationsMigrationCollectionItemDataTransferMediumDetailsV2ObjectStorageBucketResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            bucket=bucket,
            namespace=namespace,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             bucket: str,
             namespace: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("bucket", bucket)
        _setter("namespace", namespace)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace name of the object store bucket.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemDatapumpSettingResult(dict):
    def __init__(__self__, *,
                 data_pump_parameters: Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingDataPumpParameterResult'],
                 export_directory_objects: Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingExportDirectoryObjectResult'],
                 import_directory_objects: Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingImportDirectoryObjectResult'],
                 job_mode: str,
                 metadata_remaps: Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingMetadataRemapResult']):
        """
        :param Sequence['GetMigrationsMigrationCollectionItemDatapumpSettingDataPumpParameterArgs'] data_pump_parameters: Optional parameters for Data Pump Export and Import. Refer to [Configuring Optional Initial Load Advanced Settings](https://docs.us.oracle.com/en/cloud/paas/database-migration/dmsus/working-migration-resources.html#GUID-24BD3054-FDF8-48FF-8492-636C1D4B71ED)
        :param Sequence['GetMigrationsMigrationCollectionItemDatapumpSettingExportDirectoryObjectArgs'] export_directory_objects: Directory object details, used to define either import or export directory objects in Data Pump Settings.
        :param Sequence['GetMigrationsMigrationCollectionItemDatapumpSettingImportDirectoryObjectArgs'] import_directory_objects: Directory object details, used to define either import or export directory objects in Data Pump Settings.
        :param str job_mode: Data Pump job mode. Refer to [Data Pump Export Modes ](https://docs.oracle.com/en/database/oracle/oracle-database/19/sutil/oracle-data-pump-export-utility.html#GUID-8E497131-6B9B-4CC8-AA50-35F480CAC2C4)
        :param Sequence['GetMigrationsMigrationCollectionItemDatapumpSettingMetadataRemapArgs'] metadata_remaps: Defines remapping to be applied to objects as they are processed. Refer to [METADATA_REMAP Procedure ](https://docs.oracle.com/en/database/oracle/oracle-database/19/arpls/DBMS_DATAPUMP.html#GUID-0FC32790-91E6-4781-87A3-229DE024CB3D)
        """
        GetMigrationsMigrationCollectionItemDatapumpSettingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            data_pump_parameters=data_pump_parameters,
            export_directory_objects=export_directory_objects,
            import_directory_objects=import_directory_objects,
            job_mode=job_mode,
            metadata_remaps=metadata_remaps,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             data_pump_parameters: Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingDataPumpParameterResult'],
             export_directory_objects: Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingExportDirectoryObjectResult'],
             import_directory_objects: Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingImportDirectoryObjectResult'],
             job_mode: str,
             metadata_remaps: Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingMetadataRemapResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("data_pump_parameters", data_pump_parameters)
        _setter("export_directory_objects", export_directory_objects)
        _setter("import_directory_objects", import_directory_objects)
        _setter("job_mode", job_mode)
        _setter("metadata_remaps", metadata_remaps)

    @property
    @pulumi.getter(name="dataPumpParameters")
    def data_pump_parameters(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingDataPumpParameterResult']:
        """
        Optional parameters for Data Pump Export and Import. Refer to [Configuring Optional Initial Load Advanced Settings](https://docs.us.oracle.com/en/cloud/paas/database-migration/dmsus/working-migration-resources.html#GUID-24BD3054-FDF8-48FF-8492-636C1D4B71ED)
        """
        return pulumi.get(self, "data_pump_parameters")

    @property
    @pulumi.getter(name="exportDirectoryObjects")
    def export_directory_objects(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingExportDirectoryObjectResult']:
        """
        Directory object details, used to define either import or export directory objects in Data Pump Settings.
        """
        return pulumi.get(self, "export_directory_objects")

    @property
    @pulumi.getter(name="importDirectoryObjects")
    def import_directory_objects(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingImportDirectoryObjectResult']:
        """
        Directory object details, used to define either import or export directory objects in Data Pump Settings.
        """
        return pulumi.get(self, "import_directory_objects")

    @property
    @pulumi.getter(name="jobMode")
    def job_mode(self) -> str:
        """
        Data Pump job mode. Refer to [Data Pump Export Modes ](https://docs.oracle.com/en/database/oracle/oracle-database/19/sutil/oracle-data-pump-export-utility.html#GUID-8E497131-6B9B-4CC8-AA50-35F480CAC2C4)
        """
        return pulumi.get(self, "job_mode")

    @property
    @pulumi.getter(name="metadataRemaps")
    def metadata_remaps(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemDatapumpSettingMetadataRemapResult']:
        """
        Defines remapping to be applied to objects as they are processed. Refer to [METADATA_REMAP Procedure ](https://docs.oracle.com/en/database/oracle/oracle-database/19/arpls/DBMS_DATAPUMP.html#GUID-0FC32790-91E6-4781-87A3-229DE024CB3D)
        """
        return pulumi.get(self, "metadata_remaps")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemDatapumpSettingDataPumpParameterResult(dict):
    def __init__(__self__, *,
                 estimate: str,
                 exclude_parameters: Sequence[str],
                 export_parallelism_degree: int,
                 import_parallelism_degree: int,
                 is_cluster: bool,
                 table_exists_action: str):
        """
        :param str estimate: Estimate size of dumps that will be generated.
        :param Sequence[str] exclude_parameters: Exclude paratemers for Export and Import.
        :param int export_parallelism_degree: Maximum number of worker processes that can be used for a Data Pump Export job.
        :param int import_parallelism_degree: Maximum number of worker processes that can be used for a Data Pump Import job. For an Autonomous Database, ODMS will automatically query its CPU core count and set this property.
        :param bool is_cluster: Set to false to force Data Pump worker processes to run on one instance.
        :param str table_exists_action: IMPORT: Specifies the action to be performed when data is loaded into a preexisting table.
        """
        GetMigrationsMigrationCollectionItemDatapumpSettingDataPumpParameterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            estimate=estimate,
            exclude_parameters=exclude_parameters,
            export_parallelism_degree=export_parallelism_degree,
            import_parallelism_degree=import_parallelism_degree,
            is_cluster=is_cluster,
            table_exists_action=table_exists_action,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             estimate: str,
             exclude_parameters: Sequence[str],
             export_parallelism_degree: int,
             import_parallelism_degree: int,
             is_cluster: bool,
             table_exists_action: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("estimate", estimate)
        _setter("exclude_parameters", exclude_parameters)
        _setter("export_parallelism_degree", export_parallelism_degree)
        _setter("import_parallelism_degree", import_parallelism_degree)
        _setter("is_cluster", is_cluster)
        _setter("table_exists_action", table_exists_action)

    @property
    @pulumi.getter
    def estimate(self) -> str:
        """
        Estimate size of dumps that will be generated.
        """
        return pulumi.get(self, "estimate")

    @property
    @pulumi.getter(name="excludeParameters")
    def exclude_parameters(self) -> Sequence[str]:
        """
        Exclude paratemers for Export and Import.
        """
        return pulumi.get(self, "exclude_parameters")

    @property
    @pulumi.getter(name="exportParallelismDegree")
    def export_parallelism_degree(self) -> int:
        """
        Maximum number of worker processes that can be used for a Data Pump Export job.
        """
        return pulumi.get(self, "export_parallelism_degree")

    @property
    @pulumi.getter(name="importParallelismDegree")
    def import_parallelism_degree(self) -> int:
        """
        Maximum number of worker processes that can be used for a Data Pump Import job. For an Autonomous Database, ODMS will automatically query its CPU core count and set this property.
        """
        return pulumi.get(self, "import_parallelism_degree")

    @property
    @pulumi.getter(name="isCluster")
    def is_cluster(self) -> bool:
        """
        Set to false to force Data Pump worker processes to run on one instance.
        """
        return pulumi.get(self, "is_cluster")

    @property
    @pulumi.getter(name="tableExistsAction")
    def table_exists_action(self) -> str:
        """
        IMPORT: Specifies the action to be performed when data is loaded into a preexisting table.
        """
        return pulumi.get(self, "table_exists_action")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemDatapumpSettingExportDirectoryObjectResult(dict):
    def __init__(__self__, *,
                 name: str,
                 path: str):
        """
        :param str name: Name of directory object in database
        :param str path: Absolute path of directory on database server
        """
        GetMigrationsMigrationCollectionItemDatapumpSettingExportDirectoryObjectResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            path=path,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             path: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("path", path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of directory object in database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Absolute path of directory on database server
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemDatapumpSettingImportDirectoryObjectResult(dict):
    def __init__(__self__, *,
                 name: str,
                 path: str):
        """
        :param str name: Name of directory object in database
        :param str path: Absolute path of directory on database server
        """
        GetMigrationsMigrationCollectionItemDatapumpSettingImportDirectoryObjectResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            path=path,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             path: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("path", path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of directory object in database
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Absolute path of directory on database server
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemDatapumpSettingMetadataRemapResult(dict):
    def __init__(__self__, *,
                 new_value: str,
                 old_value: str,
                 type: str):
        """
        :param str new_value: Specifies the new value that oldValue should be translated into.
        :param str old_value: Specifies the value which needs to be reset.
        :param str type: Migration type.
        """
        GetMigrationsMigrationCollectionItemDatapumpSettingMetadataRemapResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            new_value=new_value,
            old_value=old_value,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             new_value: str,
             old_value: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("new_value", new_value)
        _setter("old_value", old_value)
        _setter("type", type)

    @property
    @pulumi.getter(name="newValue")
    def new_value(self) -> str:
        """
        Specifies the new value that oldValue should be translated into.
        """
        return pulumi.get(self, "new_value")

    @property
    @pulumi.getter(name="oldValue")
    def old_value(self) -> str:
        """
        Specifies the value which needs to be reset.
        """
        return pulumi.get(self, "old_value")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Migration type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemDumpTransferDetailResult(dict):
    def __init__(__self__, *,
                 shared_storage_mount_target_id: str,
                 sources: Sequence['outputs.GetMigrationsMigrationCollectionItemDumpTransferDetailSourceResult'],
                 targets: Sequence['outputs.GetMigrationsMigrationCollectionItemDumpTransferDetailTargetResult']):
        """
        :param Sequence['GetMigrationsMigrationCollectionItemDumpTransferDetailSourceArgs'] sources: Optional additional properties for dump transfer in source or target host. Default kind is CURL
        :param Sequence['GetMigrationsMigrationCollectionItemDumpTransferDetailTargetArgs'] targets: Optional additional properties for dump transfer in source or target host. Default kind is CURL
        """
        GetMigrationsMigrationCollectionItemDumpTransferDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            shared_storage_mount_target_id=shared_storage_mount_target_id,
            sources=sources,
            targets=targets,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             shared_storage_mount_target_id: str,
             sources: Sequence['outputs.GetMigrationsMigrationCollectionItemDumpTransferDetailSourceResult'],
             targets: Sequence['outputs.GetMigrationsMigrationCollectionItemDumpTransferDetailTargetResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("shared_storage_mount_target_id", shared_storage_mount_target_id)
        _setter("sources", sources)
        _setter("targets", targets)

    @property
    @pulumi.getter(name="sharedStorageMountTargetId")
    def shared_storage_mount_target_id(self) -> str:
        return pulumi.get(self, "shared_storage_mount_target_id")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemDumpTransferDetailSourceResult']:
        """
        Optional additional properties for dump transfer in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemDumpTransferDetailTargetResult']:
        """
        Optional additional properties for dump transfer in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemDumpTransferDetailSourceResult(dict):
    def __init__(__self__, *,
                 kind: str,
                 oci_home: str,
                 wallet_location: str):
        """
        :param str kind: Type of dump transfer to use during migration in source or target host. Default kind is CURL
        :param str oci_home: Path to the Oracle Cloud Infrastructure CLI installation in the node.
        :param str wallet_location: Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        GetMigrationsMigrationCollectionItemDumpTransferDetailSourceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kind=kind,
            oci_home=oci_home,
            wallet_location=wallet_location,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kind: str,
             oci_home: str,
             wallet_location: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("kind", kind)
        _setter("oci_home", oci_home)
        _setter("wallet_location", wallet_location)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of dump transfer to use during migration in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="ociHome")
    def oci_home(self) -> str:
        """
        Path to the Oracle Cloud Infrastructure CLI installation in the node.
        """
        return pulumi.get(self, "oci_home")

    @property
    @pulumi.getter(name="walletLocation")
    def wallet_location(self) -> str:
        """
        Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        return pulumi.get(self, "wallet_location")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemDumpTransferDetailTargetResult(dict):
    def __init__(__self__, *,
                 kind: str,
                 oci_home: str,
                 wallet_location: str):
        """
        :param str kind: Type of dump transfer to use during migration in source or target host. Default kind is CURL
        :param str oci_home: Path to the Oracle Cloud Infrastructure CLI installation in the node.
        :param str wallet_location: Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        GetMigrationsMigrationCollectionItemDumpTransferDetailTargetResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kind=kind,
            oci_home=oci_home,
            wallet_location=wallet_location,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kind: str,
             oci_home: str,
             wallet_location: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("kind", kind)
        _setter("oci_home", oci_home)
        _setter("wallet_location", wallet_location)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of dump transfer to use during migration in source or target host. Default kind is CURL
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="ociHome")
    def oci_home(self) -> str:
        """
        Path to the Oracle Cloud Infrastructure CLI installation in the node.
        """
        return pulumi.get(self, "oci_home")

    @property
    @pulumi.getter(name="walletLocation")
    def wallet_location(self) -> str:
        """
        Directory path to Oracle Cloud Infrastructure SSL wallet location on Db server node.
        """
        return pulumi.get(self, "wallet_location")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemExcludeObjectResult(dict):
    def __init__(__self__, *,
                 is_omit_excluded_table_from_replication: bool,
                 object: str,
                 owner: str,
                 type: str):
        """
        :param bool is_omit_excluded_table_from_replication: Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        :param str object: Name of the object (regular expression is allowed)
        :param str owner: Owner of the object (regular expression is allowed)
        :param str type: Migration type.
        """
        GetMigrationsMigrationCollectionItemExcludeObjectResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_omit_excluded_table_from_replication=is_omit_excluded_table_from_replication,
            object=object,
            owner=owner,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_omit_excluded_table_from_replication: bool,
             object: str,
             owner: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("is_omit_excluded_table_from_replication", is_omit_excluded_table_from_replication)
        _setter("object", object)
        _setter("owner", owner)
        _setter("type", type)

    @property
    @pulumi.getter(name="isOmitExcludedTableFromReplication")
    def is_omit_excluded_table_from_replication(self) -> bool:
        """
        Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        """
        return pulumi.get(self, "is_omit_excluded_table_from_replication")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Migration type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateDetailResult(dict):
    def __init__(__self__, *,
                 hubs: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubResult'],
                 settings: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailSettingResult']):
        """
        :param Sequence['GetMigrationsMigrationCollectionItemGoldenGateDetailHubArgs'] hubs: Details about Oracle GoldenGate Microservices.
        :param Sequence['GetMigrationsMigrationCollectionItemGoldenGateDetailSettingArgs'] settings: Optional settings for Oracle GoldenGate processes
        """
        GetMigrationsMigrationCollectionItemGoldenGateDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            hubs=hubs,
            settings=settings,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             hubs: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubResult'],
             settings: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailSettingResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("hubs", hubs)
        _setter("settings", settings)

    @property
    @pulumi.getter
    def hubs(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubResult']:
        """
        Details about Oracle GoldenGate Microservices.
        """
        return pulumi.get(self, "hubs")

    @property
    @pulumi.getter
    def settings(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailSettingResult']:
        """
        Optional settings for Oracle GoldenGate processes
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateDetailHubResult(dict):
    def __init__(__self__, *,
                 compute_id: str,
                 rest_admin_credentials: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubRestAdminCredentialResult'],
                 source_container_db_admin_credentials: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubSourceContainerDbAdminCredentialResult'],
                 source_db_admin_credentials: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubSourceDbAdminCredentialResult'],
                 source_microservices_deployment_name: str,
                 target_db_admin_credentials: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubTargetDbAdminCredentialResult'],
                 target_microservices_deployment_name: str,
                 url: str):
        """
        :param str compute_id: OCID of GoldenGate compute instance.
        :param Sequence['GetMigrationsMigrationCollectionItemGoldenGateDetailHubRestAdminCredentialArgs'] rest_admin_credentials: Database Administrator Credentials details.
        :param Sequence['GetMigrationsMigrationCollectionItemGoldenGateDetailHubSourceContainerDbAdminCredentialArgs'] source_container_db_admin_credentials: Database Administrator Credentials details.
        :param Sequence['GetMigrationsMigrationCollectionItemGoldenGateDetailHubSourceDbAdminCredentialArgs'] source_db_admin_credentials: Database Administrator Credentials details.
        :param str source_microservices_deployment_name: Name of GoldenGate deployment to operate on source database
        :param Sequence['GetMigrationsMigrationCollectionItemGoldenGateDetailHubTargetDbAdminCredentialArgs'] target_db_admin_credentials: Database Administrator Credentials details.
        :param str target_microservices_deployment_name: Name of GoldenGate deployment to operate on target database
        :param str url: Oracle GoldenGate hub's REST endpoint. Refer to https://docs.oracle.com/en/middleware/goldengate/core/19.1/securing/network.html#GUID-A709DA55-111D-455E-8942-C9BDD1E38CAA
        """
        GetMigrationsMigrationCollectionItemGoldenGateDetailHubResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compute_id=compute_id,
            rest_admin_credentials=rest_admin_credentials,
            source_container_db_admin_credentials=source_container_db_admin_credentials,
            source_db_admin_credentials=source_db_admin_credentials,
            source_microservices_deployment_name=source_microservices_deployment_name,
            target_db_admin_credentials=target_db_admin_credentials,
            target_microservices_deployment_name=target_microservices_deployment_name,
            url=url,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compute_id: str,
             rest_admin_credentials: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubRestAdminCredentialResult'],
             source_container_db_admin_credentials: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubSourceContainerDbAdminCredentialResult'],
             source_db_admin_credentials: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubSourceDbAdminCredentialResult'],
             source_microservices_deployment_name: str,
             target_db_admin_credentials: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubTargetDbAdminCredentialResult'],
             target_microservices_deployment_name: str,
             url: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compute_id", compute_id)
        _setter("rest_admin_credentials", rest_admin_credentials)
        _setter("source_container_db_admin_credentials", source_container_db_admin_credentials)
        _setter("source_db_admin_credentials", source_db_admin_credentials)
        _setter("source_microservices_deployment_name", source_microservices_deployment_name)
        _setter("target_db_admin_credentials", target_db_admin_credentials)
        _setter("target_microservices_deployment_name", target_microservices_deployment_name)
        _setter("url", url)

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> str:
        """
        OCID of GoldenGate compute instance.
        """
        return pulumi.get(self, "compute_id")

    @property
    @pulumi.getter(name="restAdminCredentials")
    def rest_admin_credentials(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubRestAdminCredentialResult']:
        """
        Database Administrator Credentials details.
        """
        return pulumi.get(self, "rest_admin_credentials")

    @property
    @pulumi.getter(name="sourceContainerDbAdminCredentials")
    def source_container_db_admin_credentials(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubSourceContainerDbAdminCredentialResult']:
        """
        Database Administrator Credentials details.
        """
        return pulumi.get(self, "source_container_db_admin_credentials")

    @property
    @pulumi.getter(name="sourceDbAdminCredentials")
    def source_db_admin_credentials(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubSourceDbAdminCredentialResult']:
        """
        Database Administrator Credentials details.
        """
        return pulumi.get(self, "source_db_admin_credentials")

    @property
    @pulumi.getter(name="sourceMicroservicesDeploymentName")
    def source_microservices_deployment_name(self) -> str:
        """
        Name of GoldenGate deployment to operate on source database
        """
        return pulumi.get(self, "source_microservices_deployment_name")

    @property
    @pulumi.getter(name="targetDbAdminCredentials")
    def target_db_admin_credentials(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailHubTargetDbAdminCredentialResult']:
        """
        Database Administrator Credentials details.
        """
        return pulumi.get(self, "target_db_admin_credentials")

    @property
    @pulumi.getter(name="targetMicroservicesDeploymentName")
    def target_microservices_deployment_name(self) -> str:
        """
        Name of GoldenGate deployment to operate on target database
        """
        return pulumi.get(self, "target_microservices_deployment_name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Oracle GoldenGate hub's REST endpoint. Refer to https://docs.oracle.com/en/middleware/goldengate/core/19.1/securing/network.html#GUID-A709DA55-111D-455E-8942-C9BDD1E38CAA
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateDetailHubRestAdminCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetMigrationsMigrationCollectionItemGoldenGateDetailHubRestAdminCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateDetailHubSourceContainerDbAdminCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetMigrationsMigrationCollectionItemGoldenGateDetailHubSourceContainerDbAdminCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateDetailHubSourceDbAdminCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetMigrationsMigrationCollectionItemGoldenGateDetailHubSourceDbAdminCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateDetailHubTargetDbAdminCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetMigrationsMigrationCollectionItemGoldenGateDetailHubTargetDbAdminCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateDetailSettingResult(dict):
    def __init__(__self__, *,
                 acceptable_lag: int,
                 extracts: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailSettingExtractResult'],
                 replicats: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailSettingReplicatResult']):
        """
        :param int acceptable_lag: ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        :param Sequence['GetMigrationsMigrationCollectionItemGoldenGateDetailSettingExtractArgs'] extracts: Parameters for Extract processes.
        :param Sequence['GetMigrationsMigrationCollectionItemGoldenGateDetailSettingReplicatArgs'] replicats: Parameters for Replicat processes.
        """
        GetMigrationsMigrationCollectionItemGoldenGateDetailSettingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            acceptable_lag=acceptable_lag,
            extracts=extracts,
            replicats=replicats,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             acceptable_lag: int,
             extracts: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailSettingExtractResult'],
             replicats: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailSettingReplicatResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("acceptable_lag", acceptable_lag)
        _setter("extracts", extracts)
        _setter("replicats", replicats)

    @property
    @pulumi.getter(name="acceptableLag")
    def acceptable_lag(self) -> int:
        """
        ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        """
        return pulumi.get(self, "acceptable_lag")

    @property
    @pulumi.getter
    def extracts(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailSettingExtractResult']:
        """
        Parameters for Extract processes.
        """
        return pulumi.get(self, "extracts")

    @property
    @pulumi.getter
    def replicats(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateDetailSettingReplicatResult']:
        """
        Parameters for Replicat processes.
        """
        return pulumi.get(self, "replicats")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateDetailSettingExtractResult(dict):
    def __init__(__self__, *,
                 long_trans_duration: int,
                 performance_profile: str):
        """
        :param int long_trans_duration: Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        :param str performance_profile: Extract performance.
        """
        GetMigrationsMigrationCollectionItemGoldenGateDetailSettingExtractResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            long_trans_duration=long_trans_duration,
            performance_profile=performance_profile,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             long_trans_duration: int,
             performance_profile: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("long_trans_duration", long_trans_duration)
        _setter("performance_profile", performance_profile)

    @property
    @pulumi.getter(name="longTransDuration")
    def long_trans_duration(self) -> int:
        """
        Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        """
        return pulumi.get(self, "long_trans_duration")

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> str:
        """
        Extract performance.
        """
        return pulumi.get(self, "performance_profile")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateDetailSettingReplicatResult(dict):
    def __init__(__self__, *,
                 map_parallelism: int,
                 max_apply_parallelism: int,
                 min_apply_parallelism: int,
                 performance_profile: str):
        """
        :param int map_parallelism: Number of threads used to read trail files (valid for Parallel Replicat)
        :param int max_apply_parallelism: Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        :param int min_apply_parallelism: Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        :param str performance_profile: Extract performance.
        """
        GetMigrationsMigrationCollectionItemGoldenGateDetailSettingReplicatResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            map_parallelism=map_parallelism,
            max_apply_parallelism=max_apply_parallelism,
            min_apply_parallelism=min_apply_parallelism,
            performance_profile=performance_profile,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             map_parallelism: int,
             max_apply_parallelism: int,
             min_apply_parallelism: int,
             performance_profile: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("map_parallelism", map_parallelism)
        _setter("max_apply_parallelism", max_apply_parallelism)
        _setter("min_apply_parallelism", min_apply_parallelism)
        _setter("performance_profile", performance_profile)

    @property
    @pulumi.getter(name="mapParallelism")
    def map_parallelism(self) -> int:
        """
        Number of threads used to read trail files (valid for Parallel Replicat)
        """
        return pulumi.get(self, "map_parallelism")

    @property
    @pulumi.getter(name="maxApplyParallelism")
    def max_apply_parallelism(self) -> int:
        """
        Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "max_apply_parallelism")

    @property
    @pulumi.getter(name="minApplyParallelism")
    def min_apply_parallelism(self) -> int:
        """
        Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "min_apply_parallelism")

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> str:
        """
        Extract performance.
        """
        return pulumi.get(self, "performance_profile")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateServiceDetailResult(dict):
    def __init__(__self__, *,
                 ggs_deployments: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailGgsDeploymentResult'],
                 settings: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingResult'],
                 source_container_db_credentials: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSourceContainerDbCredentialResult'],
                 source_db_credentials: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSourceDbCredentialResult'],
                 target_db_credentials: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailTargetDbCredentialResult']):
        """
        :param Sequence['GetMigrationsMigrationCollectionItemGoldenGateServiceDetailGgsDeploymentArgs'] ggs_deployments: Details about Oracle GoldenGate GGS Deployment.
        :param Sequence['GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingArgs'] settings: Optional settings for Oracle GoldenGate processes
        """
        GetMigrationsMigrationCollectionItemGoldenGateServiceDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ggs_deployments=ggs_deployments,
            settings=settings,
            source_container_db_credentials=source_container_db_credentials,
            source_db_credentials=source_db_credentials,
            target_db_credentials=target_db_credentials,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ggs_deployments: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailGgsDeploymentResult'],
             settings: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingResult'],
             source_container_db_credentials: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSourceContainerDbCredentialResult'],
             source_db_credentials: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSourceDbCredentialResult'],
             target_db_credentials: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailTargetDbCredentialResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("ggs_deployments", ggs_deployments)
        _setter("settings", settings)
        _setter("source_container_db_credentials", source_container_db_credentials)
        _setter("source_db_credentials", source_db_credentials)
        _setter("target_db_credentials", target_db_credentials)

    @property
    @pulumi.getter(name="ggsDeployments")
    def ggs_deployments(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailGgsDeploymentResult']:
        """
        Details about Oracle GoldenGate GGS Deployment.
        """
        return pulumi.get(self, "ggs_deployments")

    @property
    @pulumi.getter
    def settings(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingResult']:
        """
        Optional settings for Oracle GoldenGate processes
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="sourceContainerDbCredentials")
    def source_container_db_credentials(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSourceContainerDbCredentialResult']:
        return pulumi.get(self, "source_container_db_credentials")

    @property
    @pulumi.getter(name="sourceDbCredentials")
    def source_db_credentials(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSourceDbCredentialResult']:
        return pulumi.get(self, "source_db_credentials")

    @property
    @pulumi.getter(name="targetDbCredentials")
    def target_db_credentials(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailTargetDbCredentialResult']:
        return pulumi.get(self, "target_db_credentials")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateServiceDetailGgsDeploymentResult(dict):
    def __init__(__self__, *,
                 deployment_id: str,
                 ggs_admin_credentials_secret_id: str):
        """
        :param str deployment_id: OCID of a GoldenGate Deployment
        :param str ggs_admin_credentials_secret_id: OCID of a VaultSecret containing the Admin Credentials for the GGS Deployment
        """
        GetMigrationsMigrationCollectionItemGoldenGateServiceDetailGgsDeploymentResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            deployment_id=deployment_id,
            ggs_admin_credentials_secret_id=ggs_admin_credentials_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             deployment_id: str,
             ggs_admin_credentials_secret_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("deployment_id", deployment_id)
        _setter("ggs_admin_credentials_secret_id", ggs_admin_credentials_secret_id)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> str:
        """
        OCID of a GoldenGate Deployment
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="ggsAdminCredentialsSecretId")
    def ggs_admin_credentials_secret_id(self) -> str:
        """
        OCID of a VaultSecret containing the Admin Credentials for the GGS Deployment
        """
        return pulumi.get(self, "ggs_admin_credentials_secret_id")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingResult(dict):
    def __init__(__self__, *,
                 acceptable_lag: int,
                 extracts: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingExtractResult'],
                 replicats: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingReplicatResult']):
        """
        :param int acceptable_lag: ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        :param Sequence['GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingExtractArgs'] extracts: Parameters for Extract processes.
        :param Sequence['GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingReplicatArgs'] replicats: Parameters for Replicat processes.
        """
        GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            acceptable_lag=acceptable_lag,
            extracts=extracts,
            replicats=replicats,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             acceptable_lag: int,
             extracts: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingExtractResult'],
             replicats: Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingReplicatResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("acceptable_lag", acceptable_lag)
        _setter("extracts", extracts)
        _setter("replicats", replicats)

    @property
    @pulumi.getter(name="acceptableLag")
    def acceptable_lag(self) -> int:
        """
        ODMS will monitor GoldenGate end-to-end latency until the lag time is lower than the specified value in seconds.
        """
        return pulumi.get(self, "acceptable_lag")

    @property
    @pulumi.getter
    def extracts(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingExtractResult']:
        """
        Parameters for Extract processes.
        """
        return pulumi.get(self, "extracts")

    @property
    @pulumi.getter
    def replicats(self) -> Sequence['outputs.GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingReplicatResult']:
        """
        Parameters for Replicat processes.
        """
        return pulumi.get(self, "replicats")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingExtractResult(dict):
    def __init__(__self__, *,
                 long_trans_duration: int,
                 performance_profile: str):
        """
        :param int long_trans_duration: Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        :param str performance_profile: Extract performance.
        """
        GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingExtractResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            long_trans_duration=long_trans_duration,
            performance_profile=performance_profile,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             long_trans_duration: int,
             performance_profile: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("long_trans_duration", long_trans_duration)
        _setter("performance_profile", performance_profile)

    @property
    @pulumi.getter(name="longTransDuration")
    def long_trans_duration(self) -> int:
        """
        Length of time (in seconds) that a transaction can be open before Extract generates a warning message that the transaction is long-running. If not specified, Extract will not generate a warning on long-running transactions.
        """
        return pulumi.get(self, "long_trans_duration")

    @property
    @pulumi.getter(name="performanceProfile")
    def performance_profile(self) -> str:
        """
        Extract performance.
        """
        return pulumi.get(self, "performance_profile")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingReplicatResult(dict):
    def __init__(__self__, *,
                 map_parallelism: int,
                 max_apply_parallelism: int,
                 min_apply_parallelism: int):
        """
        :param int map_parallelism: Number of threads used to read trail files (valid for Parallel Replicat)
        :param int max_apply_parallelism: Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        :param int min_apply_parallelism: Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSettingReplicatResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            map_parallelism=map_parallelism,
            max_apply_parallelism=max_apply_parallelism,
            min_apply_parallelism=min_apply_parallelism,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             map_parallelism: int,
             max_apply_parallelism: int,
             min_apply_parallelism: int,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("map_parallelism", map_parallelism)
        _setter("max_apply_parallelism", max_apply_parallelism)
        _setter("min_apply_parallelism", min_apply_parallelism)

    @property
    @pulumi.getter(name="mapParallelism")
    def map_parallelism(self) -> int:
        """
        Number of threads used to read trail files (valid for Parallel Replicat)
        """
        return pulumi.get(self, "map_parallelism")

    @property
    @pulumi.getter(name="maxApplyParallelism")
    def max_apply_parallelism(self) -> int:
        """
        Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "max_apply_parallelism")

    @property
    @pulumi.getter(name="minApplyParallelism")
    def min_apply_parallelism(self) -> int:
        """
        Defines the range in which Replicat automatically adjusts its apply parallelism (valid for Parallel Replicat)
        """
        return pulumi.get(self, "min_apply_parallelism")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSourceContainerDbCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSourceContainerDbCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSourceDbCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetMigrationsMigrationCollectionItemGoldenGateServiceDetailSourceDbCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemGoldenGateServiceDetailTargetDbCredentialResult(dict):
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        :param str username: Administrator username
        """
        GetMigrationsMigrationCollectionItemGoldenGateServiceDetailTargetDbCredentialResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            password=password,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             password: str,
             username: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("password", password)
        _setter("username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Administrator username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemIncludeObjectResult(dict):
    def __init__(__self__, *,
                 is_omit_excluded_table_from_replication: bool,
                 object: str,
                 owner: str,
                 type: str):
        """
        :param bool is_omit_excluded_table_from_replication: Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        :param str object: Name of the object (regular expression is allowed)
        :param str owner: Owner of the object (regular expression is allowed)
        :param str type: Migration type.
        """
        GetMigrationsMigrationCollectionItemIncludeObjectResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_omit_excluded_table_from_replication=is_omit_excluded_table_from_replication,
            object=object,
            owner=owner,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_omit_excluded_table_from_replication: bool,
             object: str,
             owner: str,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("is_omit_excluded_table_from_replication", is_omit_excluded_table_from_replication)
        _setter("object", object)
        _setter("owner", owner)
        _setter("type", type)

    @property
    @pulumi.getter(name="isOmitExcludedTableFromReplication")
    def is_omit_excluded_table_from_replication(self) -> bool:
        """
        Whether an excluded table should be omitted from replication. Only valid for database objects that have are of type TABLE and that are included in the exludeObjects.
        """
        return pulumi.get(self, "is_omit_excluded_table_from_replication")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Migration type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMigrationsMigrationCollectionItemVaultDetailResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 key_id: str,
                 vault_id: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str key_id: OCID of the vault encryption key
        :param str vault_id: OCID of the vault
        """
        GetMigrationsMigrationCollectionItemVaultDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            key_id=key_id,
            vault_id=vault_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             key_id: str,
             vault_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("key_id", key_id)
        _setter("vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        OCID of the vault encryption key
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        OCID of the vault
        """
        return pulumi.get(self, "vault_id")


