# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SensitiveDataModelArgs', 'SensitiveDataModel']

@pulumi.input_type
class SensitiveDataModelArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 target_id: pulumi.Input[str],
                 app_suite_name: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[bool]] = None,
                 is_include_all_schemas: Optional[pulumi.Input[bool]] = None,
                 is_include_all_sensitive_types: Optional[pulumi.Input[bool]] = None,
                 is_sample_data_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a SensitiveDataModel resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where the sensitive data model should be created.
        :param pulumi.Input[str] target_id: (Updatable) The OCID of the reference target database to be associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] app_suite_name: (Updatable) The application suite name identifying a collection of applications. It's useful only if maintaining a sensitive data model for a suite of applications.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the sensitive data model.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the sensitive data model. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_app_defined_relation_discovery_enabled: (Updatable) Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        :param pulumi.Input[bool] is_include_all_schemas: Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used for data discovery.
        :param pulumi.Input[bool] is_include_all_sensitive_types: Indicates if all the existing sensitive types should be used by data discovery jobs. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        :param pulumi.Input[bool] is_sample_data_collection_enabled: (Updatable) Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas_for_discoveries: (Updatable) The schemas to be scanned by data discovery jobs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sensitive_type_ids_for_discoveries: (Updatable) The OCIDs of the sensitive types to be used by data discovery jobs. If OCID of a sensitive category is provided, all its child sensitive types are used for data discovery.
        """
        SensitiveDataModelArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            target_id=target_id,
            app_suite_name=app_suite_name,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            is_app_defined_relation_discovery_enabled=is_app_defined_relation_discovery_enabled,
            is_include_all_schemas=is_include_all_schemas,
            is_include_all_sensitive_types=is_include_all_sensitive_types,
            is_sample_data_collection_enabled=is_sample_data_collection_enabled,
            schemas_for_discoveries=schemas_for_discoveries,
            sensitive_type_ids_for_discoveries=sensitive_type_ids_for_discoveries,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             target_id: pulumi.Input[str],
             app_suite_name: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[bool]] = None,
             is_include_all_schemas: Optional[pulumi.Input[bool]] = None,
             is_include_all_sensitive_types: Optional[pulumi.Input[bool]] = None,
             is_sample_data_collection_enabled: Optional[pulumi.Input[bool]] = None,
             schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("target_id", target_id)
        if app_suite_name is not None:
            _setter("app_suite_name", app_suite_name)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if is_app_defined_relation_discovery_enabled is not None:
            _setter("is_app_defined_relation_discovery_enabled", is_app_defined_relation_discovery_enabled)
        if is_include_all_schemas is not None:
            _setter("is_include_all_schemas", is_include_all_schemas)
        if is_include_all_sensitive_types is not None:
            _setter("is_include_all_sensitive_types", is_include_all_sensitive_types)
        if is_sample_data_collection_enabled is not None:
            _setter("is_sample_data_collection_enabled", is_sample_data_collection_enabled)
        if schemas_for_discoveries is not None:
            _setter("schemas_for_discoveries", schemas_for_discoveries)
        if sensitive_type_ids_for_discoveries is not None:
            _setter("sensitive_type_ids_for_discoveries", sensitive_type_ids_for_discoveries)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment where the sensitive data model should be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the reference target database to be associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="appSuiteName")
    def app_suite_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The application suite name identifying a collection of applications. It's useful only if maintaining a sensitive data model for a suite of applications.
        """
        return pulumi.get(self, "app_suite_name")

    @app_suite_name.setter
    def app_suite_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_suite_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the sensitive data model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the sensitive data model. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAppDefinedRelationDiscoveryEnabled")
    def is_app_defined_relation_discovery_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        """
        return pulumi.get(self, "is_app_defined_relation_discovery_enabled")

    @is_app_defined_relation_discovery_enabled.setter
    def is_app_defined_relation_discovery_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_app_defined_relation_discovery_enabled", value)

    @property
    @pulumi.getter(name="isIncludeAllSchemas")
    def is_include_all_schemas(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used for data discovery.
        """
        return pulumi.get(self, "is_include_all_schemas")

    @is_include_all_schemas.setter
    def is_include_all_schemas(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_include_all_schemas", value)

    @property
    @pulumi.getter(name="isIncludeAllSensitiveTypes")
    def is_include_all_sensitive_types(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if all the existing sensitive types should be used by data discovery jobs. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        """
        return pulumi.get(self, "is_include_all_sensitive_types")

    @is_include_all_sensitive_types.setter
    def is_include_all_sensitive_types(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_include_all_sensitive_types", value)

    @property
    @pulumi.getter(name="isSampleDataCollectionEnabled")
    def is_sample_data_collection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        """
        return pulumi.get(self, "is_sample_data_collection_enabled")

    @is_sample_data_collection_enabled.setter
    def is_sample_data_collection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_sample_data_collection_enabled", value)

    @property
    @pulumi.getter(name="schemasForDiscoveries")
    def schemas_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The schemas to be scanned by data discovery jobs.
        """
        return pulumi.get(self, "schemas_for_discoveries")

    @schemas_for_discoveries.setter
    def schemas_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas_for_discoveries", value)

    @property
    @pulumi.getter(name="sensitiveTypeIdsForDiscoveries")
    def sensitive_type_ids_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The OCIDs of the sensitive types to be used by data discovery jobs. If OCID of a sensitive category is provided, all its child sensitive types are used for data discovery.
        """
        return pulumi.get(self, "sensitive_type_ids_for_discoveries")

    @sensitive_type_ids_for_discoveries.setter
    def sensitive_type_ids_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sensitive_type_ids_for_discoveries", value)


@pulumi.input_type
class _SensitiveDataModelState:
    def __init__(__self__, *,
                 app_suite_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[bool]] = None,
                 is_include_all_schemas: Optional[pulumi.Input[bool]] = None,
                 is_include_all_sensitive_types: Optional[pulumi.Input[bool]] = None,
                 is_sample_data_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SensitiveDataModel resources.
        :param pulumi.Input[str] app_suite_name: (Updatable) The application suite name identifying a collection of applications. It's useful only if maintaining a sensitive data model for a suite of applications.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where the sensitive data model should be created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the sensitive data model.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the sensitive data model. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_app_defined_relation_discovery_enabled: (Updatable) Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        :param pulumi.Input[bool] is_include_all_schemas: Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used for data discovery.
        :param pulumi.Input[bool] is_include_all_sensitive_types: Indicates if all the existing sensitive types should be used by data discovery jobs. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        :param pulumi.Input[bool] is_sample_data_collection_enabled: (Updatable) Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas_for_discoveries: (Updatable) The schemas to be scanned by data discovery jobs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sensitive_type_ids_for_discoveries: (Updatable) The OCIDs of the sensitive types to be used by data discovery jobs. If OCID of a sensitive category is provided, all its child sensitive types are used for data discovery.
        :param pulumi.Input[str] state: The current state of the sensitive data model.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_id: (Updatable) The OCID of the reference target database to be associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time the sensitive data model was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_updated: The date and time the sensitive data model was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        _SensitiveDataModelState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            app_suite_name=app_suite_name,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            is_app_defined_relation_discovery_enabled=is_app_defined_relation_discovery_enabled,
            is_include_all_schemas=is_include_all_schemas,
            is_include_all_sensitive_types=is_include_all_sensitive_types,
            is_sample_data_collection_enabled=is_sample_data_collection_enabled,
            schemas_for_discoveries=schemas_for_discoveries,
            sensitive_type_ids_for_discoveries=sensitive_type_ids_for_discoveries,
            state=state,
            system_tags=system_tags,
            target_id=target_id,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             app_suite_name: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[bool]] = None,
             is_include_all_schemas: Optional[pulumi.Input[bool]] = None,
             is_include_all_sensitive_types: Optional[pulumi.Input[bool]] = None,
             is_sample_data_collection_enabled: Optional[pulumi.Input[bool]] = None,
             schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             target_id: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if app_suite_name is not None:
            _setter("app_suite_name", app_suite_name)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if is_app_defined_relation_discovery_enabled is not None:
            _setter("is_app_defined_relation_discovery_enabled", is_app_defined_relation_discovery_enabled)
        if is_include_all_schemas is not None:
            _setter("is_include_all_schemas", is_include_all_schemas)
        if is_include_all_sensitive_types is not None:
            _setter("is_include_all_sensitive_types", is_include_all_sensitive_types)
        if is_sample_data_collection_enabled is not None:
            _setter("is_sample_data_collection_enabled", is_sample_data_collection_enabled)
        if schemas_for_discoveries is not None:
            _setter("schemas_for_discoveries", schemas_for_discoveries)
        if sensitive_type_ids_for_discoveries is not None:
            _setter("sensitive_type_ids_for_discoveries", sensitive_type_ids_for_discoveries)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if target_id is not None:
            _setter("target_id", target_id)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="appSuiteName")
    def app_suite_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The application suite name identifying a collection of applications. It's useful only if maintaining a sensitive data model for a suite of applications.
        """
        return pulumi.get(self, "app_suite_name")

    @app_suite_name.setter
    def app_suite_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_suite_name", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment where the sensitive data model should be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the sensitive data model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the sensitive data model. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAppDefinedRelationDiscoveryEnabled")
    def is_app_defined_relation_discovery_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        """
        return pulumi.get(self, "is_app_defined_relation_discovery_enabled")

    @is_app_defined_relation_discovery_enabled.setter
    def is_app_defined_relation_discovery_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_app_defined_relation_discovery_enabled", value)

    @property
    @pulumi.getter(name="isIncludeAllSchemas")
    def is_include_all_schemas(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used for data discovery.
        """
        return pulumi.get(self, "is_include_all_schemas")

    @is_include_all_schemas.setter
    def is_include_all_schemas(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_include_all_schemas", value)

    @property
    @pulumi.getter(name="isIncludeAllSensitiveTypes")
    def is_include_all_sensitive_types(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if all the existing sensitive types should be used by data discovery jobs. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        """
        return pulumi.get(self, "is_include_all_sensitive_types")

    @is_include_all_sensitive_types.setter
    def is_include_all_sensitive_types(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_include_all_sensitive_types", value)

    @property
    @pulumi.getter(name="isSampleDataCollectionEnabled")
    def is_sample_data_collection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        """
        return pulumi.get(self, "is_sample_data_collection_enabled")

    @is_sample_data_collection_enabled.setter
    def is_sample_data_collection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_sample_data_collection_enabled", value)

    @property
    @pulumi.getter(name="schemasForDiscoveries")
    def schemas_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The schemas to be scanned by data discovery jobs.
        """
        return pulumi.get(self, "schemas_for_discoveries")

    @schemas_for_discoveries.setter
    def schemas_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas_for_discoveries", value)

    @property
    @pulumi.getter(name="sensitiveTypeIdsForDiscoveries")
    def sensitive_type_ids_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The OCIDs of the sensitive types to be used by data discovery jobs. If OCID of a sensitive category is provided, all its child sensitive types are used for data discovery.
        """
        return pulumi.get(self, "sensitive_type_ids_for_discoveries")

    @sensitive_type_ids_for_discoveries.setter
    def sensitive_type_ids_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sensitive_type_ids_for_discoveries", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the sensitive data model.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the reference target database to be associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the sensitive data model was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the sensitive data model was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class SensitiveDataModel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_suite_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[bool]] = None,
                 is_include_all_schemas: Optional[pulumi.Input[bool]] = None,
                 is_include_all_sensitive_types: Optional[pulumi.Input[bool]] = None,
                 is_sample_data_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Sensitive Data Model resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new sensitive data model. If schemas and sensitive types are provided, it automatically runs data discovery
        and adds the discovered columns to the sensitive data model. Otherwise, it creates an empty sensitive data model
        that can be updated later.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sensitive_data_model = oci.data_safe.SensitiveDataModel("testSensitiveDataModel",
            compartment_id=var["compartment_id"],
            target_id=oci_cloud_guard_target["test_target"]["id"],
            app_suite_name=var["sensitive_data_model_app_suite_name"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["sensitive_data_model_description"],
            display_name=var["sensitive_data_model_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            is_app_defined_relation_discovery_enabled=var["sensitive_data_model_is_app_defined_relation_discovery_enabled"],
            is_include_all_schemas=var["sensitive_data_model_is_include_all_schemas"],
            is_include_all_sensitive_types=var["sensitive_data_model_is_include_all_sensitive_types"],
            is_sample_data_collection_enabled=var["sensitive_data_model_is_sample_data_collection_enabled"],
            schemas_for_discoveries=var["sensitive_data_model_schemas_for_discovery"],
            sensitive_type_ids_for_discoveries=var["sensitive_data_model_sensitive_type_ids_for_discovery"])
        ```

        ## Import

        SensitiveDataModels can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataSafe/sensitiveDataModel:SensitiveDataModel test_sensitive_data_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_suite_name: (Updatable) The application suite name identifying a collection of applications. It's useful only if maintaining a sensitive data model for a suite of applications.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where the sensitive data model should be created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the sensitive data model.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the sensitive data model. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_app_defined_relation_discovery_enabled: (Updatable) Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        :param pulumi.Input[bool] is_include_all_schemas: Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used for data discovery.
        :param pulumi.Input[bool] is_include_all_sensitive_types: Indicates if all the existing sensitive types should be used by data discovery jobs. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        :param pulumi.Input[bool] is_sample_data_collection_enabled: (Updatable) Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas_for_discoveries: (Updatable) The schemas to be scanned by data discovery jobs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sensitive_type_ids_for_discoveries: (Updatable) The OCIDs of the sensitive types to be used by data discovery jobs. If OCID of a sensitive category is provided, all its child sensitive types are used for data discovery.
        :param pulumi.Input[str] target_id: (Updatable) The OCID of the reference target database to be associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SensitiveDataModelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Sensitive Data Model resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new sensitive data model. If schemas and sensitive types are provided, it automatically runs data discovery
        and adds the discovered columns to the sensitive data model. Otherwise, it creates an empty sensitive data model
        that can be updated later.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sensitive_data_model = oci.data_safe.SensitiveDataModel("testSensitiveDataModel",
            compartment_id=var["compartment_id"],
            target_id=oci_cloud_guard_target["test_target"]["id"],
            app_suite_name=var["sensitive_data_model_app_suite_name"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["sensitive_data_model_description"],
            display_name=var["sensitive_data_model_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            is_app_defined_relation_discovery_enabled=var["sensitive_data_model_is_app_defined_relation_discovery_enabled"],
            is_include_all_schemas=var["sensitive_data_model_is_include_all_schemas"],
            is_include_all_sensitive_types=var["sensitive_data_model_is_include_all_sensitive_types"],
            is_sample_data_collection_enabled=var["sensitive_data_model_is_sample_data_collection_enabled"],
            schemas_for_discoveries=var["sensitive_data_model_schemas_for_discovery"],
            sensitive_type_ids_for_discoveries=var["sensitive_data_model_sensitive_type_ids_for_discovery"])
        ```

        ## Import

        SensitiveDataModels can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataSafe/sensitiveDataModel:SensitiveDataModel test_sensitive_data_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param SensitiveDataModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SensitiveDataModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            SensitiveDataModelArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_suite_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[bool]] = None,
                 is_include_all_schemas: Optional[pulumi.Input[bool]] = None,
                 is_include_all_sensitive_types: Optional[pulumi.Input[bool]] = None,
                 is_sample_data_collection_enabled: Optional[pulumi.Input[bool]] = None,
                 schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SensitiveDataModelArgs.__new__(SensitiveDataModelArgs)

            __props__.__dict__["app_suite_name"] = app_suite_name
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_app_defined_relation_discovery_enabled"] = is_app_defined_relation_discovery_enabled
            __props__.__dict__["is_include_all_schemas"] = is_include_all_schemas
            __props__.__dict__["is_include_all_sensitive_types"] = is_include_all_sensitive_types
            __props__.__dict__["is_sample_data_collection_enabled"] = is_sample_data_collection_enabled
            __props__.__dict__["schemas_for_discoveries"] = schemas_for_discoveries
            __props__.__dict__["sensitive_type_ids_for_discoveries"] = sensitive_type_ids_for_discoveries
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(SensitiveDataModel, __self__).__init__(
            'oci:DataSafe/sensitiveDataModel:SensitiveDataModel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_suite_name: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[bool]] = None,
            is_include_all_schemas: Optional[pulumi.Input[bool]] = None,
            is_include_all_sensitive_types: Optional[pulumi.Input[bool]] = None,
            is_sample_data_collection_enabled: Optional[pulumi.Input[bool]] = None,
            schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            target_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'SensitiveDataModel':
        """
        Get an existing SensitiveDataModel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_suite_name: (Updatable) The application suite name identifying a collection of applications. It's useful only if maintaining a sensitive data model for a suite of applications.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where the sensitive data model should be created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the sensitive data model.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the sensitive data model. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_app_defined_relation_discovery_enabled: (Updatable) Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        :param pulumi.Input[bool] is_include_all_schemas: Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used for data discovery.
        :param pulumi.Input[bool] is_include_all_sensitive_types: Indicates if all the existing sensitive types should be used by data discovery jobs. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        :param pulumi.Input[bool] is_sample_data_collection_enabled: (Updatable) Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas_for_discoveries: (Updatable) The schemas to be scanned by data discovery jobs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sensitive_type_ids_for_discoveries: (Updatable) The OCIDs of the sensitive types to be used by data discovery jobs. If OCID of a sensitive category is provided, all its child sensitive types are used for data discovery.
        :param pulumi.Input[str] state: The current state of the sensitive data model.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_id: (Updatable) The OCID of the reference target database to be associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time the sensitive data model was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_updated: The date and time the sensitive data model was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SensitiveDataModelState.__new__(_SensitiveDataModelState)

        __props__.__dict__["app_suite_name"] = app_suite_name
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_app_defined_relation_discovery_enabled"] = is_app_defined_relation_discovery_enabled
        __props__.__dict__["is_include_all_schemas"] = is_include_all_schemas
        __props__.__dict__["is_include_all_sensitive_types"] = is_include_all_sensitive_types
        __props__.__dict__["is_sample_data_collection_enabled"] = is_sample_data_collection_enabled
        __props__.__dict__["schemas_for_discoveries"] = schemas_for_discoveries
        __props__.__dict__["sensitive_type_ids_for_discoveries"] = sensitive_type_ids_for_discoveries
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return SensitiveDataModel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appSuiteName")
    def app_suite_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The application suite name identifying a collection of applications. It's useful only if maintaining a sensitive data model for a suite of applications.
        """
        return pulumi.get(self, "app_suite_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment where the sensitive data model should be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the sensitive data model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the sensitive data model. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isAppDefinedRelationDiscoveryEnabled")
    def is_app_defined_relation_discovery_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        """
        return pulumi.get(self, "is_app_defined_relation_discovery_enabled")

    @property
    @pulumi.getter(name="isIncludeAllSchemas")
    def is_include_all_schemas(self) -> pulumi.Output[bool]:
        """
        Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it's set to true, the schemasForDiscovery attribute is ignored and all schemas are used for data discovery.
        """
        return pulumi.get(self, "is_include_all_schemas")

    @property
    @pulumi.getter(name="isIncludeAllSensitiveTypes")
    def is_include_all_sensitive_types(self) -> pulumi.Output[bool]:
        """
        Indicates if all the existing sensitive types should be used by data discovery jobs. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        """
        return pulumi.get(self, "is_include_all_sensitive_types")

    @property
    @pulumi.getter(name="isSampleDataCollectionEnabled")
    def is_sample_data_collection_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        """
        return pulumi.get(self, "is_sample_data_collection_enabled")

    @property
    @pulumi.getter(name="schemasForDiscoveries")
    def schemas_for_discoveries(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The schemas to be scanned by data discovery jobs.
        """
        return pulumi.get(self, "schemas_for_discoveries")

    @property
    @pulumi.getter(name="sensitiveTypeIdsForDiscoveries")
    def sensitive_type_ids_for_discoveries(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The OCIDs of the sensitive types to be used by data discovery jobs. If OCID of a sensitive category is provided, all its child sensitive types are used for data discovery.
        """
        return pulumi.get(self, "sensitive_type_ids_for_discoveries")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the sensitive data model.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the reference target database to be associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the sensitive data model was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the sensitive data model was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

