# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRepositoryDiffsResult',
    'AwaitableGetRepositoryDiffsResult',
    'get_repository_diffs',
    'get_repository_diffs_output',
]

@pulumi.output_type
class GetRepositoryDiffsResult:
    """
    A collection of values returned by getRepositoryDiffs.
    """
    def __init__(__self__, base_version=None, diff_collections=None, filters=None, id=None, is_comparison_from_merge_base=None, repository_id=None, target_version=None):
        if base_version and not isinstance(base_version, str):
            raise TypeError("Expected argument 'base_version' to be a str")
        pulumi.set(__self__, "base_version", base_version)
        if diff_collections and not isinstance(diff_collections, list):
            raise TypeError("Expected argument 'diff_collections' to be a list")
        pulumi.set(__self__, "diff_collections", diff_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_comparison_from_merge_base and not isinstance(is_comparison_from_merge_base, bool):
            raise TypeError("Expected argument 'is_comparison_from_merge_base' to be a bool")
        pulumi.set(__self__, "is_comparison_from_merge_base", is_comparison_from_merge_base)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if target_version and not isinstance(target_version, str):
            raise TypeError("Expected argument 'target_version' to be a str")
        pulumi.set(__self__, "target_version", target_version)

    @property
    @pulumi.getter(name="baseVersion")
    def base_version(self) -> str:
        return pulumi.get(self, "base_version")

    @property
    @pulumi.getter(name="diffCollections")
    def diff_collections(self) -> Sequence['outputs.GetRepositoryDiffsDiffCollectionResult']:
        """
        The list of diff_collection.
        """
        return pulumi.get(self, "diff_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRepositoryDiffsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isComparisonFromMergeBase")
    def is_comparison_from_merge_base(self) -> Optional[bool]:
        return pulumi.get(self, "is_comparison_from_merge_base")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> str:
        return pulumi.get(self, "target_version")


class AwaitableGetRepositoryDiffsResult(GetRepositoryDiffsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryDiffsResult(
            base_version=self.base_version,
            diff_collections=self.diff_collections,
            filters=self.filters,
            id=self.id,
            is_comparison_from_merge_base=self.is_comparison_from_merge_base,
            repository_id=self.repository_id,
            target_version=self.target_version)


def get_repository_diffs(base_version: Optional[str] = None,
                         filters: Optional[Sequence[pulumi.InputType['GetRepositoryDiffsFilterArgs']]] = None,
                         is_comparison_from_merge_base: Optional[bool] = None,
                         repository_id: Optional[str] = None,
                         target_version: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryDiffsResult:
    """
    This data source provides the list of Repository Diffs in Oracle Cloud Infrastructure Devops service.

    Compares two revisions and lists the differences. Supports comparison between two references or commits.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_diffs = oci.DevOps.get_repository_diffs(base_version=var["repository_diff_base_version"],
        repository_id=oci_devops_repository["test_repository"]["id"],
        target_version=var["repository_diff_target_version"],
        is_comparison_from_merge_base=var["repository_diff_is_comparison_from_merge_base"])
    ```


    :param str base_version: The commit or reference name to compare changes against.
    :param bool is_comparison_from_merge_base: Boolean value to indicate whether to use merge base or most recent revision.
    :param str repository_id: Unique repository identifier.
    :param str target_version: The commit or reference name where changes are coming from.
    """
    __args__ = dict()
    __args__['baseVersion'] = base_version
    __args__['filters'] = filters
    __args__['isComparisonFromMergeBase'] = is_comparison_from_merge_base
    __args__['repositoryId'] = repository_id
    __args__['targetVersion'] = target_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepositoryDiffs:getRepositoryDiffs', __args__, opts=opts, typ=GetRepositoryDiffsResult).value

    return AwaitableGetRepositoryDiffsResult(
        base_version=pulumi.get(__ret__, 'base_version'),
        diff_collections=pulumi.get(__ret__, 'diff_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_comparison_from_merge_base=pulumi.get(__ret__, 'is_comparison_from_merge_base'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        target_version=pulumi.get(__ret__, 'target_version'))


@_utilities.lift_output_func(get_repository_diffs)
def get_repository_diffs_output(base_version: Optional[pulumi.Input[str]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetRepositoryDiffsFilterArgs']]]]] = None,
                                is_comparison_from_merge_base: Optional[pulumi.Input[Optional[bool]]] = None,
                                repository_id: Optional[pulumi.Input[str]] = None,
                                target_version: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRepositoryDiffsResult]:
    """
    This data source provides the list of Repository Diffs in Oracle Cloud Infrastructure Devops service.

    Compares two revisions and lists the differences. Supports comparison between two references or commits.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_diffs = oci.DevOps.get_repository_diffs(base_version=var["repository_diff_base_version"],
        repository_id=oci_devops_repository["test_repository"]["id"],
        target_version=var["repository_diff_target_version"],
        is_comparison_from_merge_base=var["repository_diff_is_comparison_from_merge_base"])
    ```


    :param str base_version: The commit or reference name to compare changes against.
    :param bool is_comparison_from_merge_base: Boolean value to indicate whether to use merge base or most recent revision.
    :param str repository_id: Unique repository identifier.
    :param str target_version: The commit or reference name where changes are coming from.
    """
    ...
