# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OutboundConnectorArgs', 'OutboundConnector']

@pulumi.input_type
class OutboundConnectorArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[str],
                 bind_distinguished_name: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 connector_type: pulumi.Input[str],
                 endpoints: pulumi.Input[Sequence[pulumi.Input['OutboundConnectorEndpointArgs']]],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 password_secret_id: Optional[pulumi.Input[str]] = None,
                 password_secret_version: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a OutboundConnector resource.
        :param pulumi.Input[str] availability_domain: The availability domain the outbound connector is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] bind_distinguished_name: The LDAP Distinguished Name of the bind account.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the outbound connector.
        :param pulumi.Input[str] connector_type: The account type of this outbound connector.
        :param pulumi.Input[Sequence[pulumi.Input['OutboundConnectorEndpointArgs']]] endpoints: Array of server endpoints to use when connecting with the LDAP bind account.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My outbound connector`
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] password_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the password for the LDAP bind account in the Vault.
        :param pulumi.Input[int] password_secret_version: Version of the password secret in the Vault to use.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        OutboundConnectorArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            bind_distinguished_name=bind_distinguished_name,
            compartment_id=compartment_id,
            connector_type=connector_type,
            endpoints=endpoints,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            password_secret_id=password_secret_id,
            password_secret_version=password_secret_version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: pulumi.Input[str],
             bind_distinguished_name: pulumi.Input[str],
             compartment_id: pulumi.Input[str],
             connector_type: pulumi.Input[str],
             endpoints: pulumi.Input[Sequence[pulumi.Input['OutboundConnectorEndpointArgs']]],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             password_secret_id: Optional[pulumi.Input[str]] = None,
             password_secret_version: Optional[pulumi.Input[int]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("availability_domain", availability_domain)
        _setter("bind_distinguished_name", bind_distinguished_name)
        _setter("compartment_id", compartment_id)
        _setter("connector_type", connector_type)
        _setter("endpoints", endpoints)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if password_secret_id is not None:
            _setter("password_secret_id", password_secret_id)
        if password_secret_version is not None:
            _setter("password_secret_version", password_secret_version)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[str]:
        """
        The availability domain the outbound connector is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="bindDistinguishedName")
    def bind_distinguished_name(self) -> pulumi.Input[str]:
        """
        The LDAP Distinguished Name of the bind account.
        """
        return pulumi.get(self, "bind_distinguished_name")

    @bind_distinguished_name.setter
    def bind_distinguished_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bind_distinguished_name", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the outbound connector.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> pulumi.Input[str]:
        """
        The account type of this outbound connector.
        """
        return pulumi.get(self, "connector_type")

    @connector_type.setter
    def connector_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "connector_type", value)

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Input[Sequence[pulumi.Input['OutboundConnectorEndpointArgs']]]:
        """
        Array of server endpoints to use when connecting with the LDAP bind account.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: pulumi.Input[Sequence[pulumi.Input['OutboundConnectorEndpointArgs']]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My outbound connector`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the password for the LDAP bind account in the Vault.
        """
        return pulumi.get(self, "password_secret_id")

    @password_secret_id.setter
    def password_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_secret_id", value)

    @property
    @pulumi.getter(name="passwordSecretVersion")
    def password_secret_version(self) -> Optional[pulumi.Input[int]]:
        """
        Version of the password secret in the Vault to use.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "password_secret_version")

    @password_secret_version.setter
    def password_secret_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "password_secret_version", value)


@pulumi.input_type
class _OutboundConnectorState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 bind_distinguished_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connector_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['OutboundConnectorEndpointArgs']]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 password_secret_id: Optional[pulumi.Input[str]] = None,
                 password_secret_version: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OutboundConnector resources.
        :param pulumi.Input[str] availability_domain: The availability domain the outbound connector is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] bind_distinguished_name: The LDAP Distinguished Name of the bind account.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the outbound connector.
        :param pulumi.Input[str] connector_type: The account type of this outbound connector.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My outbound connector`
        :param pulumi.Input[Sequence[pulumi.Input['OutboundConnectorEndpointArgs']]] endpoints: Array of server endpoints to use when connecting with the LDAP bind account.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] password_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the password for the LDAP bind account in the Vault.
        :param pulumi.Input[int] password_secret_version: Version of the password secret in the Vault to use.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of this outbound connector.
        :param pulumi.Input[str] time_created: The date and time the outbound connector was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        _OutboundConnectorState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            bind_distinguished_name=bind_distinguished_name,
            compartment_id=compartment_id,
            connector_type=connector_type,
            defined_tags=defined_tags,
            display_name=display_name,
            endpoints=endpoints,
            freeform_tags=freeform_tags,
            password_secret_id=password_secret_id,
            password_secret_version=password_secret_version,
            state=state,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: Optional[pulumi.Input[str]] = None,
             bind_distinguished_name: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             connector_type: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['OutboundConnectorEndpointArgs']]]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             password_secret_id: Optional[pulumi.Input[str]] = None,
             password_secret_version: Optional[pulumi.Input[int]] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if availability_domain is not None:
            _setter("availability_domain", availability_domain)
        if bind_distinguished_name is not None:
            _setter("bind_distinguished_name", bind_distinguished_name)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if connector_type is not None:
            _setter("connector_type", connector_type)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if endpoints is not None:
            _setter("endpoints", endpoints)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if password_secret_id is not None:
            _setter("password_secret_id", password_secret_id)
        if password_secret_version is not None:
            _setter("password_secret_version", password_secret_version)
        if state is not None:
            _setter("state", state)
        if time_created is not None:
            _setter("time_created", time_created)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain the outbound connector is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="bindDistinguishedName")
    def bind_distinguished_name(self) -> Optional[pulumi.Input[str]]:
        """
        The LDAP Distinguished Name of the bind account.
        """
        return pulumi.get(self, "bind_distinguished_name")

    @bind_distinguished_name.setter
    def bind_distinguished_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bind_distinguished_name", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the outbound connector.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> Optional[pulumi.Input[str]]:
        """
        The account type of this outbound connector.
        """
        return pulumi.get(self, "connector_type")

    @connector_type.setter
    def connector_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My outbound connector`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OutboundConnectorEndpointArgs']]]]:
        """
        Array of server endpoints to use when connecting with the LDAP bind account.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OutboundConnectorEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the password for the LDAP bind account in the Vault.
        """
        return pulumi.get(self, "password_secret_id")

    @password_secret_id.setter
    def password_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_secret_id", value)

    @property
    @pulumi.getter(name="passwordSecretVersion")
    def password_secret_version(self) -> Optional[pulumi.Input[int]]:
        """
        Version of the password secret in the Vault to use.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "password_secret_version")

    @password_secret_version.setter
    def password_secret_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "password_secret_version", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of this outbound connector.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the outbound connector was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class OutboundConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 bind_distinguished_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connector_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OutboundConnectorEndpointArgs']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 password_secret_id: Optional[pulumi.Input[str]] = None,
                 password_secret_version: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        This resource provides the Outbound Connector resource in Oracle Cloud Infrastructure File Storage service.

        Creates a new outbound connector in the specified compartment.
        You can associate an outbound connector with a mount target only when
        they exist in the same availability domain.

        For information about access control and compartments, see
        [Overview of the IAM
        Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        For information about availability domains, see [Regions and
        Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of availability domains, use the
        `ListAvailabilityDomains` operation in the Identity and Access
        Management Service API.

        All Oracle Cloud Infrastructure Services resources, including
        outbound connectors, get an Oracle-assigned, unique ID called an
        Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        When you create a resource, you can find its OCID in the response.
        You can also retrieve a resource's OCID by using a List API operation on that resource
        type, or by viewing the resource in the Console.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_outbound_connector = oci.file_storage.OutboundConnector("testOutboundConnector",
            availability_domain=var["outbound_connector_availability_domain"],
            bind_distinguished_name=var["outbound_connector_bind_distinguished_name"],
            compartment_id=var["compartment_id"],
            connector_type=var["outbound_connector_connector_type"],
            endpoints=[oci.file_storage.OutboundConnectorEndpointArgs(
                hostname=var["outbound_connector_endpoints_hostname"],
                port=var["outbound_connector_endpoints_port"],
            )],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["outbound_connector_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            password_secret_id=oci_vault_secret["test_secret"]["id"],
            password_secret_version=var["outbound_connector_password_secret_version"])
        ```

        ## Import

        OutboundConnectors can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:FileStorage/outboundConnector:OutboundConnector test_outbound_connector "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: The availability domain the outbound connector is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] bind_distinguished_name: The LDAP Distinguished Name of the bind account.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the outbound connector.
        :param pulumi.Input[str] connector_type: The account type of this outbound connector.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My outbound connector`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OutboundConnectorEndpointArgs']]]] endpoints: Array of server endpoints to use when connecting with the LDAP bind account.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] password_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the password for the LDAP bind account in the Vault.
        :param pulumi.Input[int] password_secret_version: Version of the password secret in the Vault to use.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OutboundConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Outbound Connector resource in Oracle Cloud Infrastructure File Storage service.

        Creates a new outbound connector in the specified compartment.
        You can associate an outbound connector with a mount target only when
        they exist in the same availability domain.

        For information about access control and compartments, see
        [Overview of the IAM
        Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        For information about availability domains, see [Regions and
        Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of availability domains, use the
        `ListAvailabilityDomains` operation in the Identity and Access
        Management Service API.

        All Oracle Cloud Infrastructure Services resources, including
        outbound connectors, get an Oracle-assigned, unique ID called an
        Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        When you create a resource, you can find its OCID in the response.
        You can also retrieve a resource's OCID by using a List API operation on that resource
        type, or by viewing the resource in the Console.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_outbound_connector = oci.file_storage.OutboundConnector("testOutboundConnector",
            availability_domain=var["outbound_connector_availability_domain"],
            bind_distinguished_name=var["outbound_connector_bind_distinguished_name"],
            compartment_id=var["compartment_id"],
            connector_type=var["outbound_connector_connector_type"],
            endpoints=[oci.file_storage.OutboundConnectorEndpointArgs(
                hostname=var["outbound_connector_endpoints_hostname"],
                port=var["outbound_connector_endpoints_port"],
            )],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=var["outbound_connector_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            password_secret_id=oci_vault_secret["test_secret"]["id"],
            password_secret_version=var["outbound_connector_password_secret_version"])
        ```

        ## Import

        OutboundConnectors can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:FileStorage/outboundConnector:OutboundConnector test_outbound_connector "id"
        ```

        :param str resource_name: The name of the resource.
        :param OutboundConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OutboundConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            OutboundConnectorArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 bind_distinguished_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connector_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OutboundConnectorEndpointArgs']]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 password_secret_id: Optional[pulumi.Input[str]] = None,
                 password_secret_version: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OutboundConnectorArgs.__new__(OutboundConnectorArgs)

            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            if bind_distinguished_name is None and not opts.urn:
                raise TypeError("Missing required property 'bind_distinguished_name'")
            __props__.__dict__["bind_distinguished_name"] = bind_distinguished_name
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if connector_type is None and not opts.urn:
                raise TypeError("Missing required property 'connector_type'")
            __props__.__dict__["connector_type"] = connector_type
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            if endpoints is None and not opts.urn:
                raise TypeError("Missing required property 'endpoints'")
            __props__.__dict__["endpoints"] = endpoints
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["password_secret_id"] = password_secret_id
            __props__.__dict__["password_secret_version"] = password_secret_version
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(OutboundConnector, __self__).__init__(
            'oci:FileStorage/outboundConnector:OutboundConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            bind_distinguished_name: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            connector_type: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OutboundConnectorEndpointArgs']]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            password_secret_id: Optional[pulumi.Input[str]] = None,
            password_secret_version: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'OutboundConnector':
        """
        Get an existing OutboundConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: The availability domain the outbound connector is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] bind_distinguished_name: The LDAP Distinguished Name of the bind account.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the outbound connector.
        :param pulumi.Input[str] connector_type: The account type of this outbound connector.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My outbound connector`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OutboundConnectorEndpointArgs']]]] endpoints: Array of server endpoints to use when connecting with the LDAP bind account.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] password_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the password for the LDAP bind account in the Vault.
        :param pulumi.Input[int] password_secret_version: Version of the password secret in the Vault to use.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of this outbound connector.
        :param pulumi.Input[str] time_created: The date and time the outbound connector was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OutboundConnectorState.__new__(_OutboundConnectorState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["bind_distinguished_name"] = bind_distinguished_name
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connector_type"] = connector_type
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["password_secret_id"] = password_secret_id
        __props__.__dict__["password_secret_version"] = password_secret_version
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return OutboundConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The availability domain the outbound connector is in. May be unset as a blank or NULL value.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="bindDistinguishedName")
    def bind_distinguished_name(self) -> pulumi.Output[str]:
        """
        The LDAP Distinguished Name of the bind account.
        """
        return pulumi.get(self, "bind_distinguished_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the outbound connector.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> pulumi.Output[str]:
        """
        The account type of this outbound connector.
        """
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My outbound connector`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.OutboundConnectorEndpoint']]:
        """
        Array of server endpoints to use when connecting with the LDAP bind account.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the password for the LDAP bind account in the Vault.
        """
        return pulumi.get(self, "password_secret_id")

    @property
    @pulumi.getter(name="passwordSecretVersion")
    def password_secret_version(self) -> pulumi.Output[int]:
        """
        Version of the password secret in the Vault to use.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "password_secret_version")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of this outbound connector.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the outbound connector was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

