# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsAppArgs', 'DomainsApp']

@pulumi.input_type
class DomainsAppArgs:
    def __init__(__self__, *,
                 based_on_template: pulumi.Input['DomainsAppBasedOnTemplateArgs'],
                 display_name: pulumi.Input[str],
                 idcs_endpoint: pulumi.Input[str],
                 schemas: pulumi.Input[Sequence[pulumi.Input[str]]],
                 access_token_expiry: Optional[pulumi.Input[int]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 alias_apps: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAliasAppArgs']]]] = None,
                 all_url_schemes_allowed: Optional[pulumi.Input[bool]] = None,
                 allow_access_control: Optional[pulumi.Input[bool]] = None,
                 allow_offline: Optional[pulumi.Input[bool]] = None,
                 allowed_grants: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_scopes: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedScopeArgs']]]] = None,
                 allowed_tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedTagArgs']]]] = None,
                 app_icon: Optional[pulumi.Input[str]] = None,
                 app_signon_policy: Optional[pulumi.Input['DomainsAppAppSignonPolicyArgs']] = None,
                 app_thumbnail: Optional[pulumi.Input[str]] = None,
                 apps_network_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAppsNetworkPerimeterArgs']]]] = None,
                 as_opc_service: Optional[pulumi.Input['DomainsAppAsOpcServiceArgs']] = None,
                 attr_rendering_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAttrRenderingMetadataArgs']]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 bypass_consent: Optional[pulumi.Input[bool]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppCertificateArgs']]]] = None,
                 client_ip_checking: Optional[pulumi.Input[str]] = None,
                 client_type: Optional[pulumi.Input[str]] = None,
                 contact_email_address: Optional[pulumi.Input[str]] = None,
                 delegated_service_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_kmsi_token_authentication: Optional[pulumi.Input[bool]] = None,
                 error_page_url: Optional[pulumi.Input[str]] = None,
                 home_page_url: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 id_token_enc_algo: Optional[pulumi.Input[str]] = None,
                 identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdentityProviderArgs']]]] = None,
                 idp_policy: Optional[pulumi.Input['DomainsAppIdpPolicyArgs']] = None,
                 is_alias_app: Optional[pulumi.Input[bool]] = None,
                 is_enterprise_app: Optional[pulumi.Input[bool]] = None,
                 is_form_fill: Optional[pulumi.Input[bool]] = None,
                 is_kerberos_realm: Optional[pulumi.Input[bool]] = None,
                 is_login_target: Optional[pulumi.Input[bool]] = None,
                 is_mobile_target: Optional[pulumi.Input[bool]] = None,
                 is_multicloud_service_app: Optional[pulumi.Input[bool]] = None,
                 is_oauth_client: Optional[pulumi.Input[bool]] = None,
                 is_oauth_resource: Optional[pulumi.Input[bool]] = None,
                 is_obligation_capable: Optional[pulumi.Input[bool]] = None,
                 is_radius_app: Optional[pulumi.Input[bool]] = None,
                 is_saml_service_provider: Optional[pulumi.Input[bool]] = None,
                 is_unmanaged_app: Optional[pulumi.Input[bool]] = None,
                 is_web_tier_policy: Optional[pulumi.Input[bool]] = None,
                 landing_page_url: Optional[pulumi.Input[str]] = None,
                 linking_callback_url: Optional[pulumi.Input[str]] = None,
                 login_mechanism: Optional[pulumi.Input[str]] = None,
                 login_page_url: Optional[pulumi.Input[str]] = None,
                 logout_page_url: Optional[pulumi.Input[str]] = None,
                 logout_uri: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 privacy_policy_url: Optional[pulumi.Input[str]] = None,
                 product_logo_url: Optional[pulumi.Input[str]] = None,
                 product_name: Optional[pulumi.Input[str]] = None,
                 protectable_secondary_audiences: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppProtectableSecondaryAudienceArgs']]]] = None,
                 radius_policy: Optional[pulumi.Input['DomainsAppRadiusPolicyArgs']] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_token_expiry: Optional[pulumi.Input[int]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 saml_service_provider: Optional[pulumi.Input['DomainsAppSamlServiceProviderArgs']] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppScopeArgs']]]] = None,
                 secondary_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_params: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppServiceParamArgs']]]] = None,
                 service_type_urn: Optional[pulumi.Input[str]] = None,
                 service_type_version: Optional[pulumi.Input[str]] = None,
                 show_in_my_apps: Optional[pulumi.Input[bool]] = None,
                 signon_policy: Optional[pulumi.Input['DomainsAppSignonPolicyArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTagArgs']]]] = None,
                 terms_of_service_url: Optional[pulumi.Input[str]] = None,
                 terms_of_use: Optional[pulumi.Input['DomainsAppTermsOfUseArgs']] = None,
                 trust_policies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTrustPolicyArgs']]]] = None,
                 trust_scope: Optional[pulumi.Input[str]] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensiondbcs_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionenterprise_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionform_fill_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionmanagedapp_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionopc_service_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionradius_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionrequestable_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs']] = None):
        """
        The set of arguments for constructing a DomainsApp resource.
        :param pulumi.Input['DomainsAppBasedOnTemplateArgs'] based_on_template: (Updatable) Application template on which the application is based.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] display_name: (Updatable) Display name of the flatfile bundle configuration property. This attribute maps to \\"displayName\\" attribute in \\"ConfigurationProperty\\" in ICF.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] access_token_expiry: (Updatable) Access token expiry
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: dateTime
               * uniqueness: none
        :param pulumi.Input[bool] active: (Updatable) If true, this App is able to participate in runtime services, such as automatic-login, OAuth, and SAML. If false, all runtime services are disabled for this App, and only administrative operations can be performed.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppAliasAppArgs']]] alias_apps: (Updatable) Each value of this internal attribute refers to an Oracle Public Cloud infrastructure App on which this App depends.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] all_url_schemes_allowed: (Updatable) If true, indicates that the system should allow all URL-schemes within each value of the 'redirectUris' attribute.  Also indicates that the system should not attempt to confirm that each value of the 'redirectUris' attribute is a valid URI.  In particular, the system should not confirm that the domain component of the URI is a top-level domain and the system should not confirm that the hostname portion is a valid system that is reachable over the network.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] allow_access_control: (Updatable) If true, any managed App that is based on this template is checked for access control that is, access to this app is subject to successful authorization at SSO service, viz. app grants to start with.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] allow_offline: (Updatable) If true, indicates that the Refresh Token is allowed when this App acts as an OAuth Resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_grants: (Updatable) List of grant-types that this App is allowed to use when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_operations: (Updatable) OPTIONAL. Required only when this App acts as an OAuthClient. Supported values are 'introspect' and 'onBehalfOfUser'. The value 'introspect' allows the client to look inside the access-token. The value 'onBehalfOfUser' overrides how the client's privileges are combined with the privileges of the Subject User. Ordinarily, authorization calculates the set of effective privileges as the intersection of the client's privileges and the user's privileges. The value 'onBehalfOf' indicates that authorization should ignore the privileges of the client and use only the user's privileges to calculate the effective privileges.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedScopeArgs']]] allowed_scopes: (Updatable) A list of scopes (exposed by this App or by other Apps) that this App is allowed to access when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCompositeKey: [fqs]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedTagArgs']]] allowed_tags: (Updatable) A list of tags, acting as an OAuthClient, this App is allowed to access.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] app_icon: (Updatable) Application icon.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsAppAppSignonPolicyArgs'] app_signon_policy: (Updatable) App Sign-on Policy.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] app_thumbnail: (Updatable) Application thumbnail.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppAppsNetworkPerimeterArgs']]] apps_network_perimeters: (Updatable) Network Perimeter
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input['DomainsAppAsOpcServiceArgs'] as_opc_service: (Updatable) OPCService facet of the application.
               
               **Deprecated Since: 17.3.4**
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppAttrRenderingMetadataArgs']]] attr_rendering_metadatas: (Updatable) Label for the attribute to be shown in the UI.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] audience: (Updatable) The base URI for all of the scopes defined in this App. The value of 'audience' is combined with the 'value' of each scope to form an 'fqs' or fully qualified scope.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[bool] bypass_consent: (Updatable) If true, indicates that consent should be skipped for all scopes
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppCertificateArgs']]] certificates: (Updatable) Each value of this attribute represent a certificate that this App uses when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [certAlias]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] client_ip_checking: (Updatable) Network Perimeters checking mode
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] client_type: (Updatable) Specifies the type of access that this App has when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] contact_email_address: (Updatable) Contact Email Address
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegated_service_names: (Updatable) Service Names allow to use Oracle Cloud Infrastructure signature for client authentication instead of client credentials
               
               **Added In:** 2207040824
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) The description of the AppRole.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] disable_kmsi_token_authentication: (Updatable) Indicates whether the application is allowed to be access using kmsi token.
               
               **Added In:** 2111190457
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: always
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] error_page_url: (Updatable) This attribute specifies the URL of the page to which an application will redirect an end-user in case of error.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] home_page_url: (Updatable) Home Page URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] icon: (Updatable) URL of application icon.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
               * uniqueness: none
        :param pulumi.Input[str] id_token_enc_algo: (Updatable) Encryption Alogrithm to use for encrypting ID token.
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppIdentityProviderArgs']]] identity_providers: (Updatable) A list of IdentityProvider assigned to app. A user trying to access this app will be automatically redirected to configured IdP during the authentication phase, before being able to access App.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
        :param pulumi.Input['DomainsAppIdpPolicyArgs'] idp_policy: (Updatable) IDP Policy.
               
               **Added In:** 18.1.2
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[bool] is_alias_app: If true, this App is an AliasApp and it cannot be granted to an end-user directly.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: always
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_enterprise_app: (Updatable) If true, this app acts as Enterprise app with Authentication and URL Authz policy.
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_form_fill: (Updatable) If true, this application acts as FormFill Application
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_kerberos_realm: (Updatable) If true, indicates that this App supports Kerberos Authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_login_target: (Updatable) If true, this App allows runtime services to log end users into this App automatically.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_mobile_target: (Updatable) If true, indicates that the App should be visible in each end-user's mobile application.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_multicloud_service_app: (Updatable) If true, indicates the app is used for multicloud service integration.
               
               **Added In:** 2301202328
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_oauth_client: (Updatable) If true, this application acts as an OAuth Client
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_oauth_resource: (Updatable) If true, indicates that this application acts as an OAuth Resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_obligation_capable: (Updatable) This flag indicates if the App is capable of validating obligations with the token for allowing access to the App.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_radius_app: (Updatable) If true, this application acts as an Radius App
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_saml_service_provider: (Updatable) If true, then this App acts as a SAML Service Provider.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_unmanaged_app: If true, indicates that this application accepts an Oracle Cloud Identity Service User as a login-identity (does not require an account) and relies for authorization on the User's memberships in AppRoles.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_web_tier_policy: (Updatable) If true, the webtier policy is active
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] landing_page_url: (Updatable) The URL of the landing page for this App, which is the first page that an end user should see if runtime services log that end user in to this App automatically.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] linking_callback_url: (Updatable) This attribute specifies the callback URL for the social linking operation.
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] login_mechanism: (Updatable) The protocol that runtime services will use to log end users in to this App automatically. If 'OIDC', then runtime services use the OpenID Connect protocol. If 'SAML', then runtime services use Security Assertion Markup Language protocol.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] login_page_url: (Updatable) This attribute specifies the URL of the page that the App uses when an end-user signs in to that App.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] logout_page_url: (Updatable) This attribute specifies the URL of the page that the App uses when an end-user signs out.
               
               **Added In:** 17.4.2
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] logout_uri: (Updatable) OAuth will use this URI to logout if this App wants to participate in SSO, and if this App's session gets cleared as part of global logout. Note: This attribute is used only if this App acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] name: (Updatable) The attribute represents the name of the attribute that will be used in the Security Assertion Markup Language (SAML) assertion
               
               **Deprecated Since: 18.2.2**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * idcsValuePersistedInOtherAttribute: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_logout_redirect_uris: (Updatable) Each value of this attribute is the URI of a landing page within this App. It is used only when this App, acting as an OAuthClient, initiates the logout flow and wants to be redirected back to one of its landing pages.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] privacy_policy_url: (Updatable) Privacy Policy URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] product_logo_url: (Updatable) Application Logo URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] product_name: (Updatable) Product Name
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppProtectableSecondaryAudienceArgs']]] protectable_secondary_audiences: (Updatable) A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.
               
               **Added In:** 18.2.2
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsAppRadiusPolicyArgs'] radius_policy: (Updatable) RADIUS Policy assigned to this application.
               
               **Added In:** 2209070044
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[str]]] redirect_uris: (Updatable) OPTIONAL. Each value is a URI within this App. This attribute is required when this App acts as an OAuthClient and is involved in three-legged flows (authorization-code flows).
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] refresh_token_expiry: (Updatable) Expiry-time in seconds for a Refresh Token.  Any token that allows access to this App, once refreshed, will expire after the specified duration.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input['DomainsAppSamlServiceProviderArgs'] saml_service_provider: (Updatable) An attribute that refers to the SAML Service Provider that runtime services will use to log an end user in to this App automatically. Note that this will be used only if the loginMechanism is 'SAML'.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppScopeArgs']]] scopes: (Updatable) Scopes defined by this App. Used when this App acts as an OAuth Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secondary_audiences: (Updatable) A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.
               
               **Deprecated Since: 18.2.6**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppServiceParamArgs']]] service_params: (Updatable) Custom attribute that is required to compute other attribute values during app creation.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: always
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] service_type_urn: (Updatable) This Uniform Resource Name (URN) value identifies the type of Oracle Public Cloud service of which this app is an instance.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] service_type_version: (Updatable) This value specifies the version of the Oracle Public Cloud service of which this App is an instance
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] show_in_my_apps: (Updatable) If true, this app will be displayed in the MyApps page of each end-user who has access to the App.
               
               **Added In:** 18.1.2
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input['DomainsAppSignonPolicyArgs'] signon_policy: (Updatable) Sign-on Policy.
               
               **Deprecated Since: 17.3.4**
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] terms_of_service_url: (Updatable) Terms of Service URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsAppTermsOfUseArgs'] terms_of_use: (Updatable) Terms Of Use.
               
               **Added In:** 18.2.6
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppTrustPolicyArgs']]] trust_policies: (Updatable) Trust Policies.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] trust_scope: (Updatable) Indicates the scope of trust for this App when acting as an OAuthClient. A value of 'Explicit' indicates that the App is allowed to access only the scopes of OAuthResources that are explicitly specified as 'allowedScopes'. A value of 'Account' indicates that the App is allowed implicitly to access any scope of any OAuthResource within the same Oracle Cloud Account. A value of 'Tags' indicates that the App is allowed to access any scope of any OAuthResource with a matching tag within the same Oracle Cloud Account. A value of 'Default' indicates that the Tenant default trust scope configured in the Tenant Settings is used.
               
               **Added In:** 17.4.2
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs'] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs'] urnietfparamsscimschemasoracleidcsextensiondbcs_app: (Updatable) This extension provides attributes for database service facet of an App
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs'] urnietfparamsscimschemasoracleidcsextensionenterprise_app_app: (Updatable) This extension defines the Enterprise App related attributes.
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs'] urnietfparamsscimschemasoracleidcsextensionform_fill_app_app: (Updatable) This extension provides attributes for Form-Fill facet of App
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs'] urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template: (Updatable) This extension provides attributes for Form-Fill facet of AppTemplate
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs'] urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app: (Updatable) Kerberos Realm
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs'] urnietfparamsscimschemasoracleidcsextensionmanagedapp_app: (Updatable) Managed App
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs'] urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app: (Updatable) This extension defines attributes specific to Apps that represent instances of Multicloud Service App
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs'] urnietfparamsscimschemasoracleidcsextensionopc_service_app: (Updatable) This extension defines attributes specific to Apps that represent instances of an Oracle Public Cloud (OPC) service.
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs'] urnietfparamsscimschemasoracleidcsextensionradius_app_app: (Updatable) This extension defines attributes specific to Apps that represent instances of Radius App.
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs'] urnietfparamsscimschemasoracleidcsextensionrequestable_app: (Updatable) Requestable App
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs'] urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app: (Updatable) This extension defines attributes related to the Service Providers configuration.
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs'] urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app: (Updatable) WebTier Policy
        """
        DomainsAppArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            based_on_template=based_on_template,
            display_name=display_name,
            idcs_endpoint=idcs_endpoint,
            schemas=schemas,
            access_token_expiry=access_token_expiry,
            active=active,
            alias_apps=alias_apps,
            all_url_schemes_allowed=all_url_schemes_allowed,
            allow_access_control=allow_access_control,
            allow_offline=allow_offline,
            allowed_grants=allowed_grants,
            allowed_operations=allowed_operations,
            allowed_scopes=allowed_scopes,
            allowed_tags=allowed_tags,
            app_icon=app_icon,
            app_signon_policy=app_signon_policy,
            app_thumbnail=app_thumbnail,
            apps_network_perimeters=apps_network_perimeters,
            as_opc_service=as_opc_service,
            attr_rendering_metadatas=attr_rendering_metadatas,
            attribute_sets=attribute_sets,
            attributes=attributes,
            audience=audience,
            authorization=authorization,
            bypass_consent=bypass_consent,
            certificates=certificates,
            client_ip_checking=client_ip_checking,
            client_type=client_type,
            contact_email_address=contact_email_address,
            delegated_service_names=delegated_service_names,
            description=description,
            disable_kmsi_token_authentication=disable_kmsi_token_authentication,
            error_page_url=error_page_url,
            home_page_url=home_page_url,
            icon=icon,
            id_token_enc_algo=id_token_enc_algo,
            identity_providers=identity_providers,
            idp_policy=idp_policy,
            is_alias_app=is_alias_app,
            is_enterprise_app=is_enterprise_app,
            is_form_fill=is_form_fill,
            is_kerberos_realm=is_kerberos_realm,
            is_login_target=is_login_target,
            is_mobile_target=is_mobile_target,
            is_multicloud_service_app=is_multicloud_service_app,
            is_oauth_client=is_oauth_client,
            is_oauth_resource=is_oauth_resource,
            is_obligation_capable=is_obligation_capable,
            is_radius_app=is_radius_app,
            is_saml_service_provider=is_saml_service_provider,
            is_unmanaged_app=is_unmanaged_app,
            is_web_tier_policy=is_web_tier_policy,
            landing_page_url=landing_page_url,
            linking_callback_url=linking_callback_url,
            login_mechanism=login_mechanism,
            login_page_url=login_page_url,
            logout_page_url=logout_page_url,
            logout_uri=logout_uri,
            name=name,
            ocid=ocid,
            post_logout_redirect_uris=post_logout_redirect_uris,
            privacy_policy_url=privacy_policy_url,
            product_logo_url=product_logo_url,
            product_name=product_name,
            protectable_secondary_audiences=protectable_secondary_audiences,
            radius_policy=radius_policy,
            redirect_uris=redirect_uris,
            refresh_token_expiry=refresh_token_expiry,
            resource_type_schema_version=resource_type_schema_version,
            saml_service_provider=saml_service_provider,
            scopes=scopes,
            secondary_audiences=secondary_audiences,
            service_params=service_params,
            service_type_urn=service_type_urn,
            service_type_version=service_type_version,
            show_in_my_apps=show_in_my_apps,
            signon_policy=signon_policy,
            tags=tags,
            terms_of_service_url=terms_of_service_url,
            terms_of_use=terms_of_use,
            trust_policies=trust_policies,
            trust_scope=trust_scope,
            urnietfparamsscimschemasoracleidcsextension_oci_tags=urnietfparamsscimschemasoracleidcsextension_oci_tags,
            urnietfparamsscimschemasoracleidcsextensiondbcs_app=urnietfparamsscimschemasoracleidcsextensiondbcs_app,
            urnietfparamsscimschemasoracleidcsextensionenterprise_app_app=urnietfparamsscimschemasoracleidcsextensionenterprise_app_app,
            urnietfparamsscimschemasoracleidcsextensionform_fill_app_app=urnietfparamsscimschemasoracleidcsextensionform_fill_app_app,
            urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template=urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template,
            urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app=urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app,
            urnietfparamsscimschemasoracleidcsextensionmanagedapp_app=urnietfparamsscimschemasoracleidcsextensionmanagedapp_app,
            urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app=urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app,
            urnietfparamsscimschemasoracleidcsextensionopc_service_app=urnietfparamsscimschemasoracleidcsextensionopc_service_app,
            urnietfparamsscimschemasoracleidcsextensionradius_app_app=urnietfparamsscimschemasoracleidcsextensionradius_app_app,
            urnietfparamsscimschemasoracleidcsextensionrequestable_app=urnietfparamsscimschemasoracleidcsextensionrequestable_app,
            urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app=urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app,
            urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app=urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             based_on_template: pulumi.Input['DomainsAppBasedOnTemplateArgs'],
             display_name: pulumi.Input[str],
             idcs_endpoint: pulumi.Input[str],
             schemas: pulumi.Input[Sequence[pulumi.Input[str]]],
             access_token_expiry: Optional[pulumi.Input[int]] = None,
             active: Optional[pulumi.Input[bool]] = None,
             alias_apps: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAliasAppArgs']]]] = None,
             all_url_schemes_allowed: Optional[pulumi.Input[bool]] = None,
             allow_access_control: Optional[pulumi.Input[bool]] = None,
             allow_offline: Optional[pulumi.Input[bool]] = None,
             allowed_grants: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             allowed_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             allowed_scopes: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedScopeArgs']]]] = None,
             allowed_tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedTagArgs']]]] = None,
             app_icon: Optional[pulumi.Input[str]] = None,
             app_signon_policy: Optional[pulumi.Input['DomainsAppAppSignonPolicyArgs']] = None,
             app_thumbnail: Optional[pulumi.Input[str]] = None,
             apps_network_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAppsNetworkPerimeterArgs']]]] = None,
             as_opc_service: Optional[pulumi.Input['DomainsAppAsOpcServiceArgs']] = None,
             attr_rendering_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAttrRenderingMetadataArgs']]]] = None,
             attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             attributes: Optional[pulumi.Input[str]] = None,
             audience: Optional[pulumi.Input[str]] = None,
             authorization: Optional[pulumi.Input[str]] = None,
             bypass_consent: Optional[pulumi.Input[bool]] = None,
             certificates: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppCertificateArgs']]]] = None,
             client_ip_checking: Optional[pulumi.Input[str]] = None,
             client_type: Optional[pulumi.Input[str]] = None,
             contact_email_address: Optional[pulumi.Input[str]] = None,
             delegated_service_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             disable_kmsi_token_authentication: Optional[pulumi.Input[bool]] = None,
             error_page_url: Optional[pulumi.Input[str]] = None,
             home_page_url: Optional[pulumi.Input[str]] = None,
             icon: Optional[pulumi.Input[str]] = None,
             id_token_enc_algo: Optional[pulumi.Input[str]] = None,
             identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdentityProviderArgs']]]] = None,
             idp_policy: Optional[pulumi.Input['DomainsAppIdpPolicyArgs']] = None,
             is_alias_app: Optional[pulumi.Input[bool]] = None,
             is_enterprise_app: Optional[pulumi.Input[bool]] = None,
             is_form_fill: Optional[pulumi.Input[bool]] = None,
             is_kerberos_realm: Optional[pulumi.Input[bool]] = None,
             is_login_target: Optional[pulumi.Input[bool]] = None,
             is_mobile_target: Optional[pulumi.Input[bool]] = None,
             is_multicloud_service_app: Optional[pulumi.Input[bool]] = None,
             is_oauth_client: Optional[pulumi.Input[bool]] = None,
             is_oauth_resource: Optional[pulumi.Input[bool]] = None,
             is_obligation_capable: Optional[pulumi.Input[bool]] = None,
             is_radius_app: Optional[pulumi.Input[bool]] = None,
             is_saml_service_provider: Optional[pulumi.Input[bool]] = None,
             is_unmanaged_app: Optional[pulumi.Input[bool]] = None,
             is_web_tier_policy: Optional[pulumi.Input[bool]] = None,
             landing_page_url: Optional[pulumi.Input[str]] = None,
             linking_callback_url: Optional[pulumi.Input[str]] = None,
             login_mechanism: Optional[pulumi.Input[str]] = None,
             login_page_url: Optional[pulumi.Input[str]] = None,
             logout_page_url: Optional[pulumi.Input[str]] = None,
             logout_uri: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             ocid: Optional[pulumi.Input[str]] = None,
             post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             privacy_policy_url: Optional[pulumi.Input[str]] = None,
             product_logo_url: Optional[pulumi.Input[str]] = None,
             product_name: Optional[pulumi.Input[str]] = None,
             protectable_secondary_audiences: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppProtectableSecondaryAudienceArgs']]]] = None,
             radius_policy: Optional[pulumi.Input['DomainsAppRadiusPolicyArgs']] = None,
             redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             refresh_token_expiry: Optional[pulumi.Input[int]] = None,
             resource_type_schema_version: Optional[pulumi.Input[str]] = None,
             saml_service_provider: Optional[pulumi.Input['DomainsAppSamlServiceProviderArgs']] = None,
             scopes: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppScopeArgs']]]] = None,
             secondary_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             service_params: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppServiceParamArgs']]]] = None,
             service_type_urn: Optional[pulumi.Input[str]] = None,
             service_type_version: Optional[pulumi.Input[str]] = None,
             show_in_my_apps: Optional[pulumi.Input[bool]] = None,
             signon_policy: Optional[pulumi.Input['DomainsAppSignonPolicyArgs']] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTagArgs']]]] = None,
             terms_of_service_url: Optional[pulumi.Input[str]] = None,
             terms_of_use: Optional[pulumi.Input['DomainsAppTermsOfUseArgs']] = None,
             trust_policies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTrustPolicyArgs']]]] = None,
             trust_scope: Optional[pulumi.Input[str]] = None,
             urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensiondbcs_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionenterprise_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionform_fill_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionmanagedapp_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionopc_service_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionradius_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionrequestable_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("based_on_template", based_on_template)
        _setter("display_name", display_name)
        _setter("idcs_endpoint", idcs_endpoint)
        _setter("schemas", schemas)
        if access_token_expiry is not None:
            _setter("access_token_expiry", access_token_expiry)
        if active is not None:
            _setter("active", active)
        if alias_apps is not None:
            _setter("alias_apps", alias_apps)
        if all_url_schemes_allowed is not None:
            _setter("all_url_schemes_allowed", all_url_schemes_allowed)
        if allow_access_control is not None:
            _setter("allow_access_control", allow_access_control)
        if allow_offline is not None:
            _setter("allow_offline", allow_offline)
        if allowed_grants is not None:
            _setter("allowed_grants", allowed_grants)
        if allowed_operations is not None:
            _setter("allowed_operations", allowed_operations)
        if allowed_scopes is not None:
            _setter("allowed_scopes", allowed_scopes)
        if allowed_tags is not None:
            _setter("allowed_tags", allowed_tags)
        if app_icon is not None:
            _setter("app_icon", app_icon)
        if app_signon_policy is not None:
            _setter("app_signon_policy", app_signon_policy)
        if app_thumbnail is not None:
            _setter("app_thumbnail", app_thumbnail)
        if apps_network_perimeters is not None:
            _setter("apps_network_perimeters", apps_network_perimeters)
        if as_opc_service is not None:
            _setter("as_opc_service", as_opc_service)
        if attr_rendering_metadatas is not None:
            _setter("attr_rendering_metadatas", attr_rendering_metadatas)
        if attribute_sets is not None:
            _setter("attribute_sets", attribute_sets)
        if attributes is not None:
            _setter("attributes", attributes)
        if audience is not None:
            _setter("audience", audience)
        if authorization is not None:
            _setter("authorization", authorization)
        if bypass_consent is not None:
            _setter("bypass_consent", bypass_consent)
        if certificates is not None:
            _setter("certificates", certificates)
        if client_ip_checking is not None:
            _setter("client_ip_checking", client_ip_checking)
        if client_type is not None:
            _setter("client_type", client_type)
        if contact_email_address is not None:
            _setter("contact_email_address", contact_email_address)
        if delegated_service_names is not None:
            _setter("delegated_service_names", delegated_service_names)
        if description is not None:
            _setter("description", description)
        if disable_kmsi_token_authentication is not None:
            _setter("disable_kmsi_token_authentication", disable_kmsi_token_authentication)
        if error_page_url is not None:
            _setter("error_page_url", error_page_url)
        if home_page_url is not None:
            _setter("home_page_url", home_page_url)
        if icon is not None:
            _setter("icon", icon)
        if id_token_enc_algo is not None:
            _setter("id_token_enc_algo", id_token_enc_algo)
        if identity_providers is not None:
            _setter("identity_providers", identity_providers)
        if idp_policy is not None:
            _setter("idp_policy", idp_policy)
        if is_alias_app is not None:
            _setter("is_alias_app", is_alias_app)
        if is_enterprise_app is not None:
            _setter("is_enterprise_app", is_enterprise_app)
        if is_form_fill is not None:
            _setter("is_form_fill", is_form_fill)
        if is_kerberos_realm is not None:
            _setter("is_kerberos_realm", is_kerberos_realm)
        if is_login_target is not None:
            _setter("is_login_target", is_login_target)
        if is_mobile_target is not None:
            _setter("is_mobile_target", is_mobile_target)
        if is_multicloud_service_app is not None:
            _setter("is_multicloud_service_app", is_multicloud_service_app)
        if is_oauth_client is not None:
            _setter("is_oauth_client", is_oauth_client)
        if is_oauth_resource is not None:
            _setter("is_oauth_resource", is_oauth_resource)
        if is_obligation_capable is not None:
            _setter("is_obligation_capable", is_obligation_capable)
        if is_radius_app is not None:
            _setter("is_radius_app", is_radius_app)
        if is_saml_service_provider is not None:
            _setter("is_saml_service_provider", is_saml_service_provider)
        if is_unmanaged_app is not None:
            _setter("is_unmanaged_app", is_unmanaged_app)
        if is_web_tier_policy is not None:
            _setter("is_web_tier_policy", is_web_tier_policy)
        if landing_page_url is not None:
            _setter("landing_page_url", landing_page_url)
        if linking_callback_url is not None:
            _setter("linking_callback_url", linking_callback_url)
        if login_mechanism is not None:
            _setter("login_mechanism", login_mechanism)
        if login_page_url is not None:
            _setter("login_page_url", login_page_url)
        if logout_page_url is not None:
            _setter("logout_page_url", logout_page_url)
        if logout_uri is not None:
            _setter("logout_uri", logout_uri)
        if name is not None:
            _setter("name", name)
        if ocid is not None:
            _setter("ocid", ocid)
        if post_logout_redirect_uris is not None:
            _setter("post_logout_redirect_uris", post_logout_redirect_uris)
        if privacy_policy_url is not None:
            _setter("privacy_policy_url", privacy_policy_url)
        if product_logo_url is not None:
            _setter("product_logo_url", product_logo_url)
        if product_name is not None:
            _setter("product_name", product_name)
        if protectable_secondary_audiences is not None:
            _setter("protectable_secondary_audiences", protectable_secondary_audiences)
        if radius_policy is not None:
            _setter("radius_policy", radius_policy)
        if redirect_uris is not None:
            _setter("redirect_uris", redirect_uris)
        if refresh_token_expiry is not None:
            _setter("refresh_token_expiry", refresh_token_expiry)
        if resource_type_schema_version is not None:
            _setter("resource_type_schema_version", resource_type_schema_version)
        if saml_service_provider is not None:
            _setter("saml_service_provider", saml_service_provider)
        if scopes is not None:
            _setter("scopes", scopes)
        if secondary_audiences is not None:
            _setter("secondary_audiences", secondary_audiences)
        if service_params is not None:
            _setter("service_params", service_params)
        if service_type_urn is not None:
            _setter("service_type_urn", service_type_urn)
        if service_type_version is not None:
            _setter("service_type_version", service_type_version)
        if show_in_my_apps is not None:
            _setter("show_in_my_apps", show_in_my_apps)
        if signon_policy is not None:
            _setter("signon_policy", signon_policy)
        if tags is not None:
            _setter("tags", tags)
        if terms_of_service_url is not None:
            _setter("terms_of_service_url", terms_of_service_url)
        if terms_of_use is not None:
            _setter("terms_of_use", terms_of_use)
        if trust_policies is not None:
            _setter("trust_policies", trust_policies)
        if trust_scope is not None:
            _setter("trust_scope", trust_scope)
        if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None:
            _setter("urnietfparamsscimschemasoracleidcsextension_oci_tags", urnietfparamsscimschemasoracleidcsextension_oci_tags)
        if urnietfparamsscimschemasoracleidcsextensiondbcs_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensiondbcs_app", urnietfparamsscimschemasoracleidcsextensiondbcs_app)
        if urnietfparamsscimschemasoracleidcsextensionenterprise_app_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionenterprise_app_app", urnietfparamsscimschemasoracleidcsextensionenterprise_app_app)
        if urnietfparamsscimschemasoracleidcsextensionform_fill_app_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionform_fill_app_app", urnietfparamsscimschemasoracleidcsextensionform_fill_app_app)
        if urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template", urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template)
        if urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app", urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app)
        if urnietfparamsscimschemasoracleidcsextensionmanagedapp_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionmanagedapp_app", urnietfparamsscimschemasoracleidcsextensionmanagedapp_app)
        if urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app", urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app)
        if urnietfparamsscimschemasoracleidcsextensionopc_service_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionopc_service_app", urnietfparamsscimschemasoracleidcsextensionopc_service_app)
        if urnietfparamsscimschemasoracleidcsextensionradius_app_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionradius_app_app", urnietfparamsscimschemasoracleidcsextensionradius_app_app)
        if urnietfparamsscimschemasoracleidcsextensionrequestable_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionrequestable_app", urnietfparamsscimschemasoracleidcsextensionrequestable_app)
        if urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app", urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app)
        if urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app", urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app)

    @property
    @pulumi.getter(name="basedOnTemplate")
    def based_on_template(self) -> pulumi.Input['DomainsAppBasedOnTemplateArgs']:
        """
        (Updatable) Application template on which the application is based.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "based_on_template")

    @based_on_template.setter
    def based_on_template(self, value: pulumi.Input['DomainsAppBasedOnTemplateArgs']):
        pulumi.set(self, "based_on_template", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Display name of the flatfile bundle configuration property. This attribute maps to \\"displayName\\" attribute in \\"ConfigurationProperty\\" in ICF.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="accessTokenExpiry")
    def access_token_expiry(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Access token expiry

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: dateTime
        * uniqueness: none
        """
        return pulumi.get(self, "access_token_expiry")

    @access_token_expiry.setter
    def access_token_expiry(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "access_token_expiry", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this App is able to participate in runtime services, such as automatic-login, OAuth, and SAML. If false, all runtime services are disabled for this App, and only administrative operations can be performed.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="aliasApps")
    def alias_apps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAliasAppArgs']]]]:
        """
        (Updatable) Each value of this internal attribute refers to an Oracle Public Cloud infrastructure App on which this App depends.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "alias_apps")

    @alias_apps.setter
    def alias_apps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAliasAppArgs']]]]):
        pulumi.set(self, "alias_apps", value)

    @property
    @pulumi.getter(name="allUrlSchemesAllowed")
    def all_url_schemes_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the system should allow all URL-schemes within each value of the 'redirectUris' attribute.  Also indicates that the system should not attempt to confirm that each value of the 'redirectUris' attribute is a valid URI.  In particular, the system should not confirm that the domain component of the URI is a top-level domain and the system should not confirm that the hostname portion is a valid system that is reachable over the network.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "all_url_schemes_allowed")

    @all_url_schemes_allowed.setter
    def all_url_schemes_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_url_schemes_allowed", value)

    @property
    @pulumi.getter(name="allowAccessControl")
    def allow_access_control(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, any managed App that is based on this template is checked for access control that is, access to this app is subject to successful authorization at SSO service, viz. app grants to start with.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "allow_access_control")

    @allow_access_control.setter
    def allow_access_control(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_access_control", value)

    @property
    @pulumi.getter(name="allowOffline")
    def allow_offline(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the Refresh Token is allowed when this App acts as an OAuth Resource.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "allow_offline")

    @allow_offline.setter
    def allow_offline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_offline", value)

    @property
    @pulumi.getter(name="allowedGrants")
    def allowed_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of grant-types that this App is allowed to use when it acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_grants")

    @allowed_grants.setter
    def allowed_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_grants", value)

    @property
    @pulumi.getter(name="allowedOperations")
    def allowed_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) OPTIONAL. Required only when this App acts as an OAuthClient. Supported values are 'introspect' and 'onBehalfOfUser'. The value 'introspect' allows the client to look inside the access-token. The value 'onBehalfOfUser' overrides how the client's privileges are combined with the privileges of the Subject User. Ordinarily, authorization calculates the set of effective privileges as the intersection of the client's privileges and the user's privileges. The value 'onBehalfOf' indicates that authorization should ignore the privileges of the client and use only the user's privileges to calculate the effective privileges.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_operations")

    @allowed_operations.setter
    def allowed_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_operations", value)

    @property
    @pulumi.getter(name="allowedScopes")
    def allowed_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedScopeArgs']]]]:
        """
        (Updatable) A list of scopes (exposed by this App or by other Apps) that this App is allowed to access when it acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsCompositeKey: [fqs]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_scopes")

    @allowed_scopes.setter
    def allowed_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedScopeArgs']]]]):
        pulumi.set(self, "allowed_scopes", value)

    @property
    @pulumi.getter(name="allowedTags")
    def allowed_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedTagArgs']]]]:
        """
        (Updatable) A list of tags, acting as an OAuthClient, this App is allowed to access.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_tags")

    @allowed_tags.setter
    def allowed_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedTagArgs']]]]):
        pulumi.set(self, "allowed_tags", value)

    @property
    @pulumi.getter(name="appIcon")
    def app_icon(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Application icon.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "app_icon")

    @app_icon.setter
    def app_icon(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_icon", value)

    @property
    @pulumi.getter(name="appSignonPolicy")
    def app_signon_policy(self) -> Optional[pulumi.Input['DomainsAppAppSignonPolicyArgs']]:
        """
        (Updatable) App Sign-on Policy.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "app_signon_policy")

    @app_signon_policy.setter
    def app_signon_policy(self, value: Optional[pulumi.Input['DomainsAppAppSignonPolicyArgs']]):
        pulumi.set(self, "app_signon_policy", value)

    @property
    @pulumi.getter(name="appThumbnail")
    def app_thumbnail(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Application thumbnail.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "app_thumbnail")

    @app_thumbnail.setter
    def app_thumbnail(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_thumbnail", value)

    @property
    @pulumi.getter(name="appsNetworkPerimeters")
    def apps_network_perimeters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAppsNetworkPerimeterArgs']]]]:
        """
        (Updatable) Network Perimeter

        **Added In:** 2010242156

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "apps_network_perimeters")

    @apps_network_perimeters.setter
    def apps_network_perimeters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAppsNetworkPerimeterArgs']]]]):
        pulumi.set(self, "apps_network_perimeters", value)

    @property
    @pulumi.getter(name="asOpcService")
    def as_opc_service(self) -> Optional[pulumi.Input['DomainsAppAsOpcServiceArgs']]:
        """
        (Updatable) OPCService facet of the application.

        **Deprecated Since: 17.3.4**

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "as_opc_service")

    @as_opc_service.setter
    def as_opc_service(self, value: Optional[pulumi.Input['DomainsAppAsOpcServiceArgs']]):
        pulumi.set(self, "as_opc_service", value)

    @property
    @pulumi.getter(name="attrRenderingMetadatas")
    def attr_rendering_metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAttrRenderingMetadataArgs']]]]:
        """
        (Updatable) Label for the attribute to be shown in the UI.

        **SCIM++ Properties:**
        * idcsCompositeKey: [name]
        * idcsSearchable: false
        * multiValued: true
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "attr_rendering_metadatas")

    @attr_rendering_metadatas.setter
    def attr_rendering_metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAttrRenderingMetadataArgs']]]]):
        pulumi.set(self, "attr_rendering_metadatas", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base URI for all of the scopes defined in this App. The value of 'audience' is combined with the 'value' of each scope to form an 'fqs' or fully qualified scope.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="bypassConsent")
    def bypass_consent(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that consent should be skipped for all scopes

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "bypass_consent")

    @bypass_consent.setter
    def bypass_consent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bypass_consent", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppCertificateArgs']]]]:
        """
        (Updatable) Each value of this attribute represent a certificate that this App uses when it acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [certAlias]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter(name="clientIpChecking")
    def client_ip_checking(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Network Perimeters checking mode

        **Added In:** 2010242156

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "client_ip_checking")

    @client_ip_checking.setter
    def client_ip_checking(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_ip_checking", value)

    @property
    @pulumi.getter(name="clientType")
    def client_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies the type of access that this App has when it acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "client_type")

    @client_type.setter
    def client_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_type", value)

    @property
    @pulumi.getter(name="contactEmailAddress")
    def contact_email_address(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Contact Email Address

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "contact_email_address")

    @contact_email_address.setter
    def contact_email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contact_email_address", value)

    @property
    @pulumi.getter(name="delegatedServiceNames")
    def delegated_service_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Service Names allow to use Oracle Cloud Infrastructure signature for client authentication instead of client credentials

        **Added In:** 2207040824

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "delegated_service_names")

    @delegated_service_names.setter
    def delegated_service_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delegated_service_names", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the AppRole.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableKmsiTokenAuthentication")
    def disable_kmsi_token_authentication(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether the application is allowed to be access using kmsi token.

        **Added In:** 2111190457

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: always
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "disable_kmsi_token_authentication")

    @disable_kmsi_token_authentication.setter
    def disable_kmsi_token_authentication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_kmsi_token_authentication", value)

    @property
    @pulumi.getter(name="errorPageUrl")
    def error_page_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This attribute specifies the URL of the page to which an application will redirect an end-user in case of error.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "error_page_url")

    @error_page_url.setter
    def error_page_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_page_url", value)

    @property
    @pulumi.getter(name="homePageUrl")
    def home_page_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Home Page URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "home_page_url")

    @home_page_url.setter
    def home_page_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "home_page_url", value)

    @property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) URL of application icon.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: reference
        * uniqueness: none
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon", value)

    @property
    @pulumi.getter(name="idTokenEncAlgo")
    def id_token_enc_algo(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Encryption Alogrithm to use for encrypting ID token.

        **Added In:** 2010242156

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "id_token_enc_algo")

    @id_token_enc_algo.setter
    def id_token_enc_algo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id_token_enc_algo", value)

    @property
    @pulumi.getter(name="identityProviders")
    def identity_providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdentityProviderArgs']]]]:
        """
        (Updatable) A list of IdentityProvider assigned to app. A user trying to access this app will be automatically redirected to configured IdP during the authentication phase, before being able to access App.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        """
        return pulumi.get(self, "identity_providers")

    @identity_providers.setter
    def identity_providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdentityProviderArgs']]]]):
        pulumi.set(self, "identity_providers", value)

    @property
    @pulumi.getter(name="idpPolicy")
    def idp_policy(self) -> Optional[pulumi.Input['DomainsAppIdpPolicyArgs']]:
        """
        (Updatable) IDP Policy.

        **Added In:** 18.1.2

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idp_policy")

    @idp_policy.setter
    def idp_policy(self, value: Optional[pulumi.Input['DomainsAppIdpPolicyArgs']]):
        pulumi.set(self, "idp_policy", value)

    @property
    @pulumi.getter(name="isAliasApp")
    def is_alias_app(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, this App is an AliasApp and it cannot be granted to an end-user directly.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: always
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_alias_app")

    @is_alias_app.setter
    def is_alias_app(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_alias_app", value)

    @property
    @pulumi.getter(name="isEnterpriseApp")
    def is_enterprise_app(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this app acts as Enterprise app with Authentication and URL Authz policy.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_enterprise_app")

    @is_enterprise_app.setter
    def is_enterprise_app(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enterprise_app", value)

    @property
    @pulumi.getter(name="isFormFill")
    def is_form_fill(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this application acts as FormFill Application

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_form_fill")

    @is_form_fill.setter
    def is_form_fill(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_form_fill", value)

    @property
    @pulumi.getter(name="isKerberosRealm")
    def is_kerberos_realm(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that this App supports Kerberos Authentication

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_kerberos_realm")

    @is_kerberos_realm.setter
    def is_kerberos_realm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_kerberos_realm", value)

    @property
    @pulumi.getter(name="isLoginTarget")
    def is_login_target(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this App allows runtime services to log end users into this App automatically.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_login_target")

    @is_login_target.setter
    def is_login_target(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_login_target", value)

    @property
    @pulumi.getter(name="isMobileTarget")
    def is_mobile_target(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the App should be visible in each end-user's mobile application.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_mobile_target")

    @is_mobile_target.setter
    def is_mobile_target(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_mobile_target", value)

    @property
    @pulumi.getter(name="isMulticloudServiceApp")
    def is_multicloud_service_app(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates the app is used for multicloud service integration.

        **Added In:** 2301202328

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_multicloud_service_app")

    @is_multicloud_service_app.setter
    def is_multicloud_service_app(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_multicloud_service_app", value)

    @property
    @pulumi.getter(name="isOauthClient")
    def is_oauth_client(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this application acts as an OAuth Client

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_oauth_client")

    @is_oauth_client.setter
    def is_oauth_client(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_oauth_client", value)

    @property
    @pulumi.getter(name="isOauthResource")
    def is_oauth_resource(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that this application acts as an OAuth Resource.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_oauth_resource")

    @is_oauth_resource.setter
    def is_oauth_resource(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_oauth_resource", value)

    @property
    @pulumi.getter(name="isObligationCapable")
    def is_obligation_capable(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) This flag indicates if the App is capable of validating obligations with the token for allowing access to the App.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_obligation_capable")

    @is_obligation_capable.setter
    def is_obligation_capable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_obligation_capable", value)

    @property
    @pulumi.getter(name="isRadiusApp")
    def is_radius_app(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this application acts as an Radius App

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_radius_app")

    @is_radius_app.setter
    def is_radius_app(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_radius_app", value)

    @property
    @pulumi.getter(name="isSamlServiceProvider")
    def is_saml_service_provider(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, then this App acts as a SAML Service Provider.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_saml_service_provider")

    @is_saml_service_provider.setter
    def is_saml_service_provider(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_saml_service_provider", value)

    @property
    @pulumi.getter(name="isUnmanagedApp")
    def is_unmanaged_app(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, indicates that this application accepts an Oracle Cloud Identity Service User as a login-identity (does not require an account) and relies for authorization on the User's memberships in AppRoles.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_unmanaged_app")

    @is_unmanaged_app.setter
    def is_unmanaged_app(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_unmanaged_app", value)

    @property
    @pulumi.getter(name="isWebTierPolicy")
    def is_web_tier_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, the webtier policy is active

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_web_tier_policy")

    @is_web_tier_policy.setter
    def is_web_tier_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_web_tier_policy", value)

    @property
    @pulumi.getter(name="landingPageUrl")
    def landing_page_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The URL of the landing page for this App, which is the first page that an end user should see if runtime services log that end user in to this App automatically.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "landing_page_url")

    @landing_page_url.setter
    def landing_page_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "landing_page_url", value)

    @property
    @pulumi.getter(name="linkingCallbackUrl")
    def linking_callback_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This attribute specifies the callback URL for the social linking operation.

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "linking_callback_url")

    @linking_callback_url.setter
    def linking_callback_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_callback_url", value)

    @property
    @pulumi.getter(name="loginMechanism")
    def login_mechanism(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The protocol that runtime services will use to log end users in to this App automatically. If 'OIDC', then runtime services use the OpenID Connect protocol. If 'SAML', then runtime services use Security Assertion Markup Language protocol.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "login_mechanism")

    @login_mechanism.setter
    def login_mechanism(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_mechanism", value)

    @property
    @pulumi.getter(name="loginPageUrl")
    def login_page_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This attribute specifies the URL of the page that the App uses when an end-user signs in to that App.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "login_page_url")

    @login_page_url.setter
    def login_page_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_page_url", value)

    @property
    @pulumi.getter(name="logoutPageUrl")
    def logout_page_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This attribute specifies the URL of the page that the App uses when an end-user signs out.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_page_url")

    @logout_page_url.setter
    def logout_page_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_page_url", value)

    @property
    @pulumi.getter(name="logoutUri")
    def logout_uri(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OAuth will use this URI to logout if this App wants to participate in SSO, and if this App's session gets cleared as part of global logout. Note: This attribute is used only if this App acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_uri")

    @logout_uri.setter
    def logout_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_uri", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The attribute represents the name of the attribute that will be used in the Security Assertion Markup Language (SAML) assertion

        **Deprecated Since: 18.2.2**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * idcsValuePersistedInOtherAttribute: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="postLogoutRedirectUris")
    def post_logout_redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Each value of this attribute is the URI of a landing page within this App. It is used only when this App, acting as an OAuthClient, initiates the logout flow and wants to be redirected back to one of its landing pages.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "post_logout_redirect_uris")

    @post_logout_redirect_uris.setter
    def post_logout_redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "post_logout_redirect_uris", value)

    @property
    @pulumi.getter(name="privacyPolicyUrl")
    def privacy_policy_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Privacy Policy URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "privacy_policy_url")

    @privacy_policy_url.setter
    def privacy_policy_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "privacy_policy_url", value)

    @property
    @pulumi.getter(name="productLogoUrl")
    def product_logo_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Application Logo URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "product_logo_url")

    @product_logo_url.setter
    def product_logo_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_logo_url", value)

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Product Name

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "product_name")

    @product_name.setter
    def product_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_name", value)

    @property
    @pulumi.getter(name="protectableSecondaryAudiences")
    def protectable_secondary_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppProtectableSecondaryAudienceArgs']]]]:
        """
        (Updatable) A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.

        **Added In:** 18.2.2

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "protectable_secondary_audiences")

    @protectable_secondary_audiences.setter
    def protectable_secondary_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppProtectableSecondaryAudienceArgs']]]]):
        pulumi.set(self, "protectable_secondary_audiences", value)

    @property
    @pulumi.getter(name="radiusPolicy")
    def radius_policy(self) -> Optional[pulumi.Input['DomainsAppRadiusPolicyArgs']]:
        """
        (Updatable) RADIUS Policy assigned to this application.

        **Added In:** 2209070044

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "radius_policy")

    @radius_policy.setter
    def radius_policy(self, value: Optional[pulumi.Input['DomainsAppRadiusPolicyArgs']]):
        pulumi.set(self, "radius_policy", value)

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) OPTIONAL. Each value is a URI within this App. This attribute is required when this App acts as an OAuthClient and is involved in three-legged flows (authorization-code flows).

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "redirect_uris")

    @redirect_uris.setter
    def redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "redirect_uris", value)

    @property
    @pulumi.getter(name="refreshTokenExpiry")
    def refresh_token_expiry(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Expiry-time in seconds for a Refresh Token.  Any token that allows access to this App, once refreshed, will expire after the specified duration.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "refresh_token_expiry")

    @refresh_token_expiry.setter
    def refresh_token_expiry(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "refresh_token_expiry", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter(name="samlServiceProvider")
    def saml_service_provider(self) -> Optional[pulumi.Input['DomainsAppSamlServiceProviderArgs']]:
        """
        (Updatable) An attribute that refers to the SAML Service Provider that runtime services will use to log an end user in to this App automatically. Note that this will be used only if the loginMechanism is 'SAML'.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "saml_service_provider")

    @saml_service_provider.setter
    def saml_service_provider(self, value: Optional[pulumi.Input['DomainsAppSamlServiceProviderArgs']]):
        pulumi.set(self, "saml_service_provider", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppScopeArgs']]]]:
        """
        (Updatable) Scopes defined by this App. Used when this App acts as an OAuth Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppScopeArgs']]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="secondaryAudiences")
    def secondary_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.

        **Deprecated Since: 18.2.6**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "secondary_audiences")

    @secondary_audiences.setter
    def secondary_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "secondary_audiences", value)

    @property
    @pulumi.getter(name="serviceParams")
    def service_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppServiceParamArgs']]]]:
        """
        (Updatable) Custom attribute that is required to compute other attribute values during app creation.

        **SCIM++ Properties:**
        * idcsCompositeKey: [name]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: always
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "service_params")

    @service_params.setter
    def service_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppServiceParamArgs']]]]):
        pulumi.set(self, "service_params", value)

    @property
    @pulumi.getter(name="serviceTypeUrn")
    def service_type_urn(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This Uniform Resource Name (URN) value identifies the type of Oracle Public Cloud service of which this app is an instance.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "service_type_urn")

    @service_type_urn.setter
    def service_type_urn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type_urn", value)

    @property
    @pulumi.getter(name="serviceTypeVersion")
    def service_type_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This value specifies the version of the Oracle Public Cloud service of which this App is an instance

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "service_type_version")

    @service_type_version.setter
    def service_type_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type_version", value)

    @property
    @pulumi.getter(name="showInMyApps")
    def show_in_my_apps(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this app will be displayed in the MyApps page of each end-user who has access to the App.

        **Added In:** 18.1.2

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "show_in_my_apps")

    @show_in_my_apps.setter
    def show_in_my_apps(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "show_in_my_apps", value)

    @property
    @pulumi.getter(name="signonPolicy")
    def signon_policy(self) -> Optional[pulumi.Input['DomainsAppSignonPolicyArgs']]:
        """
        (Updatable) Sign-on Policy.

        **Deprecated Since: 17.3.4**

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "signon_policy")

    @signon_policy.setter
    def signon_policy(self, value: Optional[pulumi.Input['DomainsAppSignonPolicyArgs']]):
        pulumi.set(self, "signon_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="termsOfServiceUrl")
    def terms_of_service_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Terms of Service URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "terms_of_service_url")

    @terms_of_service_url.setter
    def terms_of_service_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "terms_of_service_url", value)

    @property
    @pulumi.getter(name="termsOfUse")
    def terms_of_use(self) -> Optional[pulumi.Input['DomainsAppTermsOfUseArgs']]:
        """
        (Updatable) Terms Of Use.

        **Added In:** 18.2.6

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "terms_of_use")

    @terms_of_use.setter
    def terms_of_use(self, value: Optional[pulumi.Input['DomainsAppTermsOfUseArgs']]):
        pulumi.set(self, "terms_of_use", value)

    @property
    @pulumi.getter(name="trustPolicies")
    def trust_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTrustPolicyArgs']]]]:
        """
        (Updatable) Trust Policies.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "trust_policies")

    @trust_policies.setter
    def trust_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTrustPolicyArgs']]]]):
        pulumi.set(self, "trust_policies", value)

    @property
    @pulumi.getter(name="trustScope")
    def trust_scope(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Indicates the scope of trust for this App when acting as an OAuthClient. A value of 'Explicit' indicates that the App is allowed to access only the scopes of OAuthResources that are explicitly specified as 'allowedScopes'. A value of 'Account' indicates that the App is allowed implicitly to access any scope of any OAuthResource within the same Oracle Cloud Account. A value of 'Tags' indicates that the App is allowed to access any scope of any OAuthResource with a matching tag within the same Oracle Cloud Account. A value of 'Default' indicates that the Tenant default trust scope configured in the Tenant Settings is used.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "trust_scope")

    @trust_scope.setter
    def trust_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trust_scope", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionOciTags")
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]:
        """
        (Updatable) Oracle Cloud Infrastructure Tags.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags")

    @urnietfparamsscimschemasoracleidcsextension_oci_tags.setter
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiondbcsApp")
    def urnietfparamsscimschemasoracleidcsextensiondbcs_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs']]:
        """
        (Updatable) This extension provides attributes for database service facet of an App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiondbcs_app")

    @urnietfparamsscimschemasoracleidcsextensiondbcs_app.setter
    def urnietfparamsscimschemasoracleidcsextensiondbcs_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensiondbcs_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionenterpriseAppApp")
    def urnietfparamsscimschemasoracleidcsextensionenterprise_app_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs']]:
        """
        (Updatable) This extension defines the Enterprise App related attributes.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionenterprise_app_app")

    @urnietfparamsscimschemasoracleidcsextensionenterprise_app_app.setter
    def urnietfparamsscimschemasoracleidcsextensionenterprise_app_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionenterprise_app_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionformFillAppApp")
    def urnietfparamsscimschemasoracleidcsextensionform_fill_app_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs']]:
        """
        (Updatable) This extension provides attributes for Form-Fill facet of App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionform_fill_app_app")

    @urnietfparamsscimschemasoracleidcsextensionform_fill_app_app.setter
    def urnietfparamsscimschemasoracleidcsextensionform_fill_app_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionform_fill_app_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplate")
    def urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs']]:
        """
        (Updatable) This extension provides attributes for Form-Fill facet of AppTemplate
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template")

    @urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template.setter
    def urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionkerberosRealmApp")
    def urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs']]:
        """
        (Updatable) Kerberos Realm
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app")

    @urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app.setter
    def urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionmanagedappApp")
    def urnietfparamsscimschemasoracleidcsextensionmanagedapp_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs']]:
        """
        (Updatable) Managed App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionmanagedapp_app")

    @urnietfparamsscimschemasoracleidcsextensionmanagedapp_app.setter
    def urnietfparamsscimschemasoracleidcsextensionmanagedapp_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionmanagedapp_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppApp")
    def urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs']]:
        """
        (Updatable) This extension defines attributes specific to Apps that represent instances of Multicloud Service App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app")

    @urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app.setter
    def urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionopcServiceApp")
    def urnietfparamsscimschemasoracleidcsextensionopc_service_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs']]:
        """
        (Updatable) This extension defines attributes specific to Apps that represent instances of an Oracle Public Cloud (OPC) service.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionopc_service_app")

    @urnietfparamsscimschemasoracleidcsextensionopc_service_app.setter
    def urnietfparamsscimschemasoracleidcsextensionopc_service_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionopc_service_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionradiusAppApp")
    def urnietfparamsscimschemasoracleidcsextensionradius_app_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs']]:
        """
        (Updatable) This extension defines attributes specific to Apps that represent instances of Radius App.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionradius_app_app")

    @urnietfparamsscimschemasoracleidcsextensionradius_app_app.setter
    def urnietfparamsscimschemasoracleidcsextensionradius_app_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionradius_app_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionrequestableApp")
    def urnietfparamsscimschemasoracleidcsextensionrequestable_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs']]:
        """
        (Updatable) Requestable App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionrequestable_app")

    @urnietfparamsscimschemasoracleidcsextensionrequestable_app.setter
    def urnietfparamsscimschemasoracleidcsextensionrequestable_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionrequestable_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsamlServiceProviderApp")
    def urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs']]:
        """
        (Updatable) This extension defines attributes related to the Service Providers configuration.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app")

    @urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app.setter
    def urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionwebTierPolicyApp")
    def urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs']]:
        """
        (Updatable) WebTier Policy
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app")

    @urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app.setter
    def urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app", value)


@pulumi.input_type
class _DomainsAppState:
    def __init__(__self__, *,
                 access_token_expiry: Optional[pulumi.Input[int]] = None,
                 accounts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAccountArgs']]]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 admin_roles: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAdminRoleArgs']]]] = None,
                 alias_apps: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAliasAppArgs']]]] = None,
                 all_url_schemes_allowed: Optional[pulumi.Input[bool]] = None,
                 allow_access_control: Optional[pulumi.Input[bool]] = None,
                 allow_offline: Optional[pulumi.Input[bool]] = None,
                 allowed_grants: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_scopes: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedScopeArgs']]]] = None,
                 allowed_tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedTagArgs']]]] = None,
                 app_icon: Optional[pulumi.Input[str]] = None,
                 app_signon_policy: Optional[pulumi.Input['DomainsAppAppSignonPolicyArgs']] = None,
                 app_thumbnail: Optional[pulumi.Input[str]] = None,
                 apps_network_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAppsNetworkPerimeterArgs']]]] = None,
                 as_opc_service: Optional[pulumi.Input['DomainsAppAsOpcServiceArgs']] = None,
                 attr_rendering_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAttrRenderingMetadataArgs']]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 based_on_template: Optional[pulumi.Input['DomainsAppBasedOnTemplateArgs']] = None,
                 bypass_consent: Optional[pulumi.Input[bool]] = None,
                 callback_service_url: Optional[pulumi.Input[str]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppCertificateArgs']]]] = None,
                 client_ip_checking: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 client_type: Optional[pulumi.Input[str]] = None,
                 cloud_control_properties: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppCloudControlPropertyArgs']]]] = None,
                 compartment_ocid: Optional[pulumi.Input[str]] = None,
                 contact_email_address: Optional[pulumi.Input[str]] = None,
                 delegated_service_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 delete_in_progress: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_kmsi_token_authentication: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain_ocid: Optional[pulumi.Input[str]] = None,
                 editable_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppEditableAttributeArgs']]]] = None,
                 error_page_url: Optional[pulumi.Input[str]] = None,
                 granted_app_roles: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppGrantedAppRoleArgs']]]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppGrantArgs']]]] = None,
                 hashed_client_secret: Optional[pulumi.Input[str]] = None,
                 home_page_url: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 id_token_enc_algo: Optional[pulumi.Input[str]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdentityProviderArgs']]]] = None,
                 idp_policy: Optional[pulumi.Input['DomainsAppIdpPolicyArgs']] = None,
                 infrastructure: Optional[pulumi.Input[bool]] = None,
                 is_alias_app: Optional[pulumi.Input[bool]] = None,
                 is_database_service: Optional[pulumi.Input[bool]] = None,
                 is_enterprise_app: Optional[pulumi.Input[bool]] = None,
                 is_form_fill: Optional[pulumi.Input[bool]] = None,
                 is_kerberos_realm: Optional[pulumi.Input[bool]] = None,
                 is_login_target: Optional[pulumi.Input[bool]] = None,
                 is_managed_app: Optional[pulumi.Input[bool]] = None,
                 is_mobile_target: Optional[pulumi.Input[bool]] = None,
                 is_multicloud_service_app: Optional[pulumi.Input[bool]] = None,
                 is_oauth_client: Optional[pulumi.Input[bool]] = None,
                 is_oauth_resource: Optional[pulumi.Input[bool]] = None,
                 is_obligation_capable: Optional[pulumi.Input[bool]] = None,
                 is_opc_service: Optional[pulumi.Input[bool]] = None,
                 is_radius_app: Optional[pulumi.Input[bool]] = None,
                 is_saml_service_provider: Optional[pulumi.Input[bool]] = None,
                 is_unmanaged_app: Optional[pulumi.Input[bool]] = None,
                 is_web_tier_policy: Optional[pulumi.Input[bool]] = None,
                 landing_page_url: Optional[pulumi.Input[str]] = None,
                 linking_callback_url: Optional[pulumi.Input[str]] = None,
                 login_mechanism: Optional[pulumi.Input[str]] = None,
                 login_page_url: Optional[pulumi.Input[str]] = None,
                 logout_page_url: Optional[pulumi.Input[str]] = None,
                 logout_uri: Optional[pulumi.Input[str]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppMetaArgs']]]] = None,
                 meter_as_opc_service: Optional[pulumi.Input[bool]] = None,
                 migrated: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 privacy_policy_url: Optional[pulumi.Input[str]] = None,
                 product_logo_url: Optional[pulumi.Input[str]] = None,
                 product_name: Optional[pulumi.Input[str]] = None,
                 protectable_secondary_audiences: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppProtectableSecondaryAudienceArgs']]]] = None,
                 radius_policy: Optional[pulumi.Input['DomainsAppRadiusPolicyArgs']] = None,
                 ready_to_upgrade: Optional[pulumi.Input[bool]] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_token_expiry: Optional[pulumi.Input[int]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 saml_service_provider: Optional[pulumi.Input['DomainsAppSamlServiceProviderArgs']] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppScopeArgs']]]] = None,
                 secondary_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_params: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppServiceParamArgs']]]] = None,
                 service_type_urn: Optional[pulumi.Input[str]] = None,
                 service_type_version: Optional[pulumi.Input[str]] = None,
                 show_in_my_apps: Optional[pulumi.Input[bool]] = None,
                 signon_policy: Optional[pulumi.Input['DomainsAppSignonPolicyArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[str]] = None,
                 terms_of_service_url: Optional[pulumi.Input[str]] = None,
                 terms_of_use: Optional[pulumi.Input['DomainsAppTermsOfUseArgs']] = None,
                 trust_policies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTrustPolicyArgs']]]] = None,
                 trust_scope: Optional[pulumi.Input[str]] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensiondbcs_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionenterprise_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionform_fill_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionmanagedapp_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionopc_service_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionradius_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionrequestable_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs']] = None,
                 user_roles: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppUserRoleArgs']]]] = None):
        """
        Input properties used for looking up and filtering DomainsApp resources.
        :param pulumi.Input[int] access_token_expiry: (Updatable) Access token expiry
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: dateTime
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppAccountArgs']]] accounts: (Updatable) Accounts of App
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] active: (Updatable) If true, this App is able to participate in runtime services, such as automatic-login, OAuth, and SAML. If false, all runtime services are disabled for this App, and only administrative operations can be performed.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppAdminRoleArgs']]] admin_roles: (Updatable) A list of AppRoles defined by this UnmanagedApp. Membership in each of these AppRoles confers administrative privilege within this App.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppAliasAppArgs']]] alias_apps: (Updatable) Each value of this internal attribute refers to an Oracle Public Cloud infrastructure App on which this App depends.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] all_url_schemes_allowed: (Updatable) If true, indicates that the system should allow all URL-schemes within each value of the 'redirectUris' attribute.  Also indicates that the system should not attempt to confirm that each value of the 'redirectUris' attribute is a valid URI.  In particular, the system should not confirm that the domain component of the URI is a top-level domain and the system should not confirm that the hostname portion is a valid system that is reachable over the network.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] allow_access_control: (Updatable) If true, any managed App that is based on this template is checked for access control that is, access to this app is subject to successful authorization at SSO service, viz. app grants to start with.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] allow_offline: (Updatable) If true, indicates that the Refresh Token is allowed when this App acts as an OAuth Resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_grants: (Updatable) List of grant-types that this App is allowed to use when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_operations: (Updatable) OPTIONAL. Required only when this App acts as an OAuthClient. Supported values are 'introspect' and 'onBehalfOfUser'. The value 'introspect' allows the client to look inside the access-token. The value 'onBehalfOfUser' overrides how the client's privileges are combined with the privileges of the Subject User. Ordinarily, authorization calculates the set of effective privileges as the intersection of the client's privileges and the user's privileges. The value 'onBehalfOf' indicates that authorization should ignore the privileges of the client and use only the user's privileges to calculate the effective privileges.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedScopeArgs']]] allowed_scopes: (Updatable) A list of scopes (exposed by this App or by other Apps) that this App is allowed to access when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCompositeKey: [fqs]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedTagArgs']]] allowed_tags: (Updatable) A list of tags, acting as an OAuthClient, this App is allowed to access.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] app_icon: (Updatable) Application icon.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsAppAppSignonPolicyArgs'] app_signon_policy: (Updatable) App Sign-on Policy.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] app_thumbnail: (Updatable) Application thumbnail.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppAppsNetworkPerimeterArgs']]] apps_network_perimeters: (Updatable) Network Perimeter
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input['DomainsAppAsOpcServiceArgs'] as_opc_service: (Updatable) OPCService facet of the application.
               
               **Deprecated Since: 17.3.4**
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppAttrRenderingMetadataArgs']]] attr_rendering_metadatas: (Updatable) Label for the attribute to be shown in the UI.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] audience: (Updatable) The base URI for all of the scopes defined in this App. The value of 'audience' is combined with the 'value' of each scope to form an 'fqs' or fully qualified scope.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input['DomainsAppBasedOnTemplateArgs'] based_on_template: (Updatable) Application template on which the application is based.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[bool] bypass_consent: (Updatable) If true, indicates that consent should be skipped for all scopes
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] callback_service_url: (Updatable) Callback Service URL
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppCertificateArgs']]] certificates: (Updatable) Each value of this attribute represent a certificate that this App uses when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [certAlias]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] client_ip_checking: (Updatable) Network Perimeters checking mode
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] client_secret: (Updatable) This value is the credential of this App, which this App supplies as a password when this App authenticates to the Oracle Public Cloud infrastructure. This value is also the client secret of this App when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * idcsSensitive: none
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] client_type: (Updatable) Specifies the type of access that this App has when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppCloudControlPropertyArgs']]] cloud_control_properties: (Updatable) A collection of arbitrary properties that scope the privileges of a cloud-control App.
               
               **Added In:** 18.4.2
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] contact_email_address: (Updatable) Contact Email Address
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegated_service_names: (Updatable) Service Names allow to use Oracle Cloud Infrastructure signature for client authentication instead of client credentials
               
               **Added In:** 2207040824
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) The description of the AppRole.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] disable_kmsi_token_authentication: (Updatable) Indicates whether the application is allowed to be access using kmsi token.
               
               **Added In:** 2111190457
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: always
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] display_name: (Updatable) Display name of the flatfile bundle configuration property. This attribute maps to \\"displayName\\" attribute in \\"ConfigurationProperty\\" in ICF.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppEditableAttributeArgs']]] editable_attributes: (Updatable) App attributes editable by subject
               
               **Added In:** 18.2.6
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] error_page_url: (Updatable) This attribute specifies the URL of the page to which an application will redirect an end-user in case of error.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppGrantedAppRoleArgs']]] granted_app_roles: (Updatable) A list of AppRoles that are granted to this App (and that are defined by other Apps). Within the Oracle Public Cloud infrastructure, this allows AppID-based association. Such an association allows this App to act as a consumer and thus to access resources of another App that acts as a producer.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppGrantArgs']]] grants: (Updatable) Grants assigned to the app
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] hashed_client_secret: (Updatable) Hashed Client Secret. This hash-value is used to verify the 'clientSecret' credential of this App
               
               **Added In:** 2106240046
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * idcsSensitive: hash_sc
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] home_page_url: (Updatable) Home Page URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] icon: (Updatable) URL of application icon.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
               * uniqueness: none
        :param pulumi.Input[str] id_token_enc_algo: (Updatable) Encryption Alogrithm to use for encrypting ID token.
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppIdentityProviderArgs']]] identity_providers: (Updatable) A list of IdentityProvider assigned to app. A user trying to access this app will be automatically redirected to configured IdP during the authentication phase, before being able to access App.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
        :param pulumi.Input['DomainsAppIdpPolicyArgs'] idp_policy: (Updatable) IDP Policy.
               
               **Added In:** 18.1.2
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[bool] infrastructure: (Updatable) If true, this App is an internal infrastructure App.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_alias_app: If true, this App is an AliasApp and it cannot be granted to an end-user directly.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: always
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_database_service: (Updatable) If true, this application acts as database service Application
               
               **Added In:** 18.2.2
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * type: boolean
        :param pulumi.Input[bool] is_enterprise_app: (Updatable) If true, this app acts as Enterprise app with Authentication and URL Authz policy.
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_form_fill: (Updatable) If true, this application acts as FormFill Application
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_kerberos_realm: (Updatable) If true, indicates that this App supports Kerberos Authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_login_target: (Updatable) If true, this App allows runtime services to log end users into this App automatically.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_managed_app: (Updatable) If true, indicates that access to this App requires an account. That is, in order to log in to the App, a User must use an application-specific identity that is maintained in the remote identity-repository of that App.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_mobile_target: (Updatable) If true, indicates that the App should be visible in each end-user's mobile application.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_multicloud_service_app: (Updatable) If true, indicates the app is used for multicloud service integration.
               
               **Added In:** 2301202328
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_oauth_client: (Updatable) If true, this application acts as an OAuth Client
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_oauth_resource: (Updatable) If true, indicates that this application acts as an OAuth Resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_obligation_capable: (Updatable) This flag indicates if the App is capable of validating obligations with the token for allowing access to the App.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_opc_service: (Updatable) If true, this application is an Oracle Public Cloud service-instance.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_radius_app: (Updatable) If true, this application acts as an Radius App
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_saml_service_provider: (Updatable) If true, then this App acts as a SAML Service Provider.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_unmanaged_app: If true, indicates that this application accepts an Oracle Cloud Identity Service User as a login-identity (does not require an account) and relies for authorization on the User's memberships in AppRoles.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_web_tier_policy: (Updatable) If true, the webtier policy is active
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] landing_page_url: (Updatable) The URL of the landing page for this App, which is the first page that an end user should see if runtime services log that end user in to this App automatically.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] linking_callback_url: (Updatable) This attribute specifies the callback URL for the social linking operation.
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] login_mechanism: (Updatable) The protocol that runtime services will use to log end users in to this App automatically. If 'OIDC', then runtime services use the OpenID Connect protocol. If 'SAML', then runtime services use Security Assertion Markup Language protocol.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] login_page_url: (Updatable) This attribute specifies the URL of the page that the App uses when an end-user signs in to that App.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] logout_page_url: (Updatable) This attribute specifies the URL of the page that the App uses when an end-user signs out.
               
               **Added In:** 17.4.2
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] logout_uri: (Updatable) OAuth will use this URI to logout if this App wants to participate in SSO, and if this App's session gets cleared as part of global logout. Note: This attribute is used only if this App acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[bool] meter_as_opc_service: (Updatable) Indicates whether the application is billed as an OPCService. If true, customer is not billed for runtime operations of the app.
               
               **Added In:** 18.4.2
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: always
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] migrated: (Updatable) If true, this App was migrated from an earlier version of Oracle Public Cloud infrastructure (and may therefore require special handling from runtime services such as OAuth or SAML). If false, this App requires no special handling from runtime services.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] name: (Updatable) The attribute represents the name of the attribute that will be used in the Security Assertion Markup Language (SAML) assertion
               
               **Deprecated Since: 18.2.2**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * idcsValuePersistedInOtherAttribute: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_logout_redirect_uris: (Updatable) Each value of this attribute is the URI of a landing page within this App. It is used only when this App, acting as an OAuthClient, initiates the logout flow and wants to be redirected back to one of its landing pages.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] privacy_policy_url: (Updatable) Privacy Policy URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] product_logo_url: (Updatable) Application Logo URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] product_name: (Updatable) Product Name
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppProtectableSecondaryAudienceArgs']]] protectable_secondary_audiences: (Updatable) A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.
               
               **Added In:** 18.2.2
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input['DomainsAppRadiusPolicyArgs'] radius_policy: (Updatable) RADIUS Policy assigned to this application.
               
               **Added In:** 2209070044
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[bool] ready_to_upgrade: (Updatable) If true, this App requires an upgrade and mandates attention from application administrator. The flag is used by UI to indicate this app is ready to upgrade.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] redirect_uris: (Updatable) OPTIONAL. Each value is a URI within this App. This attribute is required when this App acts as an OAuthClient and is involved in three-legged flows (authorization-code flows).
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] refresh_token_expiry: (Updatable) Expiry-time in seconds for a Refresh Token.  Any token that allows access to this App, once refreshed, will expire after the specified duration.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input['DomainsAppSamlServiceProviderArgs'] saml_service_provider: (Updatable) An attribute that refers to the SAML Service Provider that runtime services will use to log an end user in to this App automatically. Note that this will be used only if the loginMechanism is 'SAML'.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppScopeArgs']]] scopes: (Updatable) Scopes defined by this App. Used when this App acts as an OAuth Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secondary_audiences: (Updatable) A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.
               
               **Deprecated Since: 18.2.6**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppServiceParamArgs']]] service_params: (Updatable) Custom attribute that is required to compute other attribute values during app creation.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: always
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] service_type_urn: (Updatable) This Uniform Resource Name (URN) value identifies the type of Oracle Public Cloud service of which this app is an instance.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] service_type_version: (Updatable) This value specifies the version of the Oracle Public Cloud service of which this App is an instance
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] show_in_my_apps: (Updatable) If true, this app will be displayed in the MyApps page of each end-user who has access to the App.
               
               **Added In:** 18.1.2
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input['DomainsAppSignonPolicyArgs'] signon_policy: (Updatable) Sign-on Policy.
               
               **Deprecated Since: 17.3.4**
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] terms_of_service_url: (Updatable) Terms of Service URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsAppTermsOfUseArgs'] terms_of_use: (Updatable) Terms Of Use.
               
               **Added In:** 18.2.6
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppTrustPolicyArgs']]] trust_policies: (Updatable) Trust Policies.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] trust_scope: (Updatable) Indicates the scope of trust for this App when acting as an OAuthClient. A value of 'Explicit' indicates that the App is allowed to access only the scopes of OAuthResources that are explicitly specified as 'allowedScopes'. A value of 'Account' indicates that the App is allowed implicitly to access any scope of any OAuthResource within the same Oracle Cloud Account. A value of 'Tags' indicates that the App is allowed to access any scope of any OAuthResource with a matching tag within the same Oracle Cloud Account. A value of 'Default' indicates that the Tenant default trust scope configured in the Tenant Settings is used.
               
               **Added In:** 17.4.2
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs'] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs'] urnietfparamsscimschemasoracleidcsextensiondbcs_app: (Updatable) This extension provides attributes for database service facet of an App
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs'] urnietfparamsscimschemasoracleidcsextensionenterprise_app_app: (Updatable) This extension defines the Enterprise App related attributes.
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs'] urnietfparamsscimschemasoracleidcsextensionform_fill_app_app: (Updatable) This extension provides attributes for Form-Fill facet of App
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs'] urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template: (Updatable) This extension provides attributes for Form-Fill facet of AppTemplate
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs'] urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app: (Updatable) Kerberos Realm
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs'] urnietfparamsscimschemasoracleidcsextensionmanagedapp_app: (Updatable) Managed App
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs'] urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app: (Updatable) This extension defines attributes specific to Apps that represent instances of Multicloud Service App
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs'] urnietfparamsscimschemasoracleidcsextensionopc_service_app: (Updatable) This extension defines attributes specific to Apps that represent instances of an Oracle Public Cloud (OPC) service.
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs'] urnietfparamsscimschemasoracleidcsextensionradius_app_app: (Updatable) This extension defines attributes specific to Apps that represent instances of Radius App.
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs'] urnietfparamsscimschemasoracleidcsextensionrequestable_app: (Updatable) Requestable App
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs'] urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app: (Updatable) This extension defines attributes related to the Service Providers configuration.
        :param pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs'] urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app: (Updatable) WebTier Policy
        :param pulumi.Input[Sequence[pulumi.Input['DomainsAppUserRoleArgs']]] user_roles: (Updatable) A list of AppRoles defined by this UnmanagedApp. Membership in each of these AppRoles confers end-user privilege within this App.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
        """
        _DomainsAppState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_token_expiry=access_token_expiry,
            accounts=accounts,
            active=active,
            admin_roles=admin_roles,
            alias_apps=alias_apps,
            all_url_schemes_allowed=all_url_schemes_allowed,
            allow_access_control=allow_access_control,
            allow_offline=allow_offline,
            allowed_grants=allowed_grants,
            allowed_operations=allowed_operations,
            allowed_scopes=allowed_scopes,
            allowed_tags=allowed_tags,
            app_icon=app_icon,
            app_signon_policy=app_signon_policy,
            app_thumbnail=app_thumbnail,
            apps_network_perimeters=apps_network_perimeters,
            as_opc_service=as_opc_service,
            attr_rendering_metadatas=attr_rendering_metadatas,
            attribute_sets=attribute_sets,
            attributes=attributes,
            audience=audience,
            authorization=authorization,
            based_on_template=based_on_template,
            bypass_consent=bypass_consent,
            callback_service_url=callback_service_url,
            certificates=certificates,
            client_ip_checking=client_ip_checking,
            client_secret=client_secret,
            client_type=client_type,
            cloud_control_properties=cloud_control_properties,
            compartment_ocid=compartment_ocid,
            contact_email_address=contact_email_address,
            delegated_service_names=delegated_service_names,
            delete_in_progress=delete_in_progress,
            description=description,
            disable_kmsi_token_authentication=disable_kmsi_token_authentication,
            display_name=display_name,
            domain_ocid=domain_ocid,
            editable_attributes=editable_attributes,
            error_page_url=error_page_url,
            granted_app_roles=granted_app_roles,
            grants=grants,
            hashed_client_secret=hashed_client_secret,
            home_page_url=home_page_url,
            icon=icon,
            id_token_enc_algo=id_token_enc_algo,
            idcs_created_bies=idcs_created_bies,
            idcs_endpoint=idcs_endpoint,
            idcs_last_modified_bies=idcs_last_modified_bies,
            idcs_last_upgraded_in_release=idcs_last_upgraded_in_release,
            idcs_prevented_operations=idcs_prevented_operations,
            identity_providers=identity_providers,
            idp_policy=idp_policy,
            infrastructure=infrastructure,
            is_alias_app=is_alias_app,
            is_database_service=is_database_service,
            is_enterprise_app=is_enterprise_app,
            is_form_fill=is_form_fill,
            is_kerberos_realm=is_kerberos_realm,
            is_login_target=is_login_target,
            is_managed_app=is_managed_app,
            is_mobile_target=is_mobile_target,
            is_multicloud_service_app=is_multicloud_service_app,
            is_oauth_client=is_oauth_client,
            is_oauth_resource=is_oauth_resource,
            is_obligation_capable=is_obligation_capable,
            is_opc_service=is_opc_service,
            is_radius_app=is_radius_app,
            is_saml_service_provider=is_saml_service_provider,
            is_unmanaged_app=is_unmanaged_app,
            is_web_tier_policy=is_web_tier_policy,
            landing_page_url=landing_page_url,
            linking_callback_url=linking_callback_url,
            login_mechanism=login_mechanism,
            login_page_url=login_page_url,
            logout_page_url=logout_page_url,
            logout_uri=logout_uri,
            metas=metas,
            meter_as_opc_service=meter_as_opc_service,
            migrated=migrated,
            name=name,
            ocid=ocid,
            post_logout_redirect_uris=post_logout_redirect_uris,
            privacy_policy_url=privacy_policy_url,
            product_logo_url=product_logo_url,
            product_name=product_name,
            protectable_secondary_audiences=protectable_secondary_audiences,
            radius_policy=radius_policy,
            ready_to_upgrade=ready_to_upgrade,
            redirect_uris=redirect_uris,
            refresh_token_expiry=refresh_token_expiry,
            resource_type_schema_version=resource_type_schema_version,
            saml_service_provider=saml_service_provider,
            schemas=schemas,
            scopes=scopes,
            secondary_audiences=secondary_audiences,
            service_params=service_params,
            service_type_urn=service_type_urn,
            service_type_version=service_type_version,
            show_in_my_apps=show_in_my_apps,
            signon_policy=signon_policy,
            tags=tags,
            tenancy_ocid=tenancy_ocid,
            terms_of_service_url=terms_of_service_url,
            terms_of_use=terms_of_use,
            trust_policies=trust_policies,
            trust_scope=trust_scope,
            urnietfparamsscimschemasoracleidcsextension_oci_tags=urnietfparamsscimschemasoracleidcsextension_oci_tags,
            urnietfparamsscimschemasoracleidcsextensiondbcs_app=urnietfparamsscimschemasoracleidcsextensiondbcs_app,
            urnietfparamsscimschemasoracleidcsextensionenterprise_app_app=urnietfparamsscimschemasoracleidcsextensionenterprise_app_app,
            urnietfparamsscimschemasoracleidcsextensionform_fill_app_app=urnietfparamsscimschemasoracleidcsextensionform_fill_app_app,
            urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template=urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template,
            urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app=urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app,
            urnietfparamsscimschemasoracleidcsextensionmanagedapp_app=urnietfparamsscimschemasoracleidcsextensionmanagedapp_app,
            urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app=urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app,
            urnietfparamsscimschemasoracleidcsextensionopc_service_app=urnietfparamsscimschemasoracleidcsextensionopc_service_app,
            urnietfparamsscimschemasoracleidcsextensionradius_app_app=urnietfparamsscimschemasoracleidcsextensionradius_app_app,
            urnietfparamsscimschemasoracleidcsextensionrequestable_app=urnietfparamsscimschemasoracleidcsextensionrequestable_app,
            urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app=urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app,
            urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app=urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app,
            user_roles=user_roles,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_token_expiry: Optional[pulumi.Input[int]] = None,
             accounts: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAccountArgs']]]] = None,
             active: Optional[pulumi.Input[bool]] = None,
             admin_roles: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAdminRoleArgs']]]] = None,
             alias_apps: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAliasAppArgs']]]] = None,
             all_url_schemes_allowed: Optional[pulumi.Input[bool]] = None,
             allow_access_control: Optional[pulumi.Input[bool]] = None,
             allow_offline: Optional[pulumi.Input[bool]] = None,
             allowed_grants: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             allowed_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             allowed_scopes: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedScopeArgs']]]] = None,
             allowed_tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedTagArgs']]]] = None,
             app_icon: Optional[pulumi.Input[str]] = None,
             app_signon_policy: Optional[pulumi.Input['DomainsAppAppSignonPolicyArgs']] = None,
             app_thumbnail: Optional[pulumi.Input[str]] = None,
             apps_network_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAppsNetworkPerimeterArgs']]]] = None,
             as_opc_service: Optional[pulumi.Input['DomainsAppAsOpcServiceArgs']] = None,
             attr_rendering_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAttrRenderingMetadataArgs']]]] = None,
             attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             attributes: Optional[pulumi.Input[str]] = None,
             audience: Optional[pulumi.Input[str]] = None,
             authorization: Optional[pulumi.Input[str]] = None,
             based_on_template: Optional[pulumi.Input['DomainsAppBasedOnTemplateArgs']] = None,
             bypass_consent: Optional[pulumi.Input[bool]] = None,
             callback_service_url: Optional[pulumi.Input[str]] = None,
             certificates: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppCertificateArgs']]]] = None,
             client_ip_checking: Optional[pulumi.Input[str]] = None,
             client_secret: Optional[pulumi.Input[str]] = None,
             client_type: Optional[pulumi.Input[str]] = None,
             cloud_control_properties: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppCloudControlPropertyArgs']]]] = None,
             compartment_ocid: Optional[pulumi.Input[str]] = None,
             contact_email_address: Optional[pulumi.Input[str]] = None,
             delegated_service_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             delete_in_progress: Optional[pulumi.Input[bool]] = None,
             description: Optional[pulumi.Input[str]] = None,
             disable_kmsi_token_authentication: Optional[pulumi.Input[bool]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             domain_ocid: Optional[pulumi.Input[str]] = None,
             editable_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppEditableAttributeArgs']]]] = None,
             error_page_url: Optional[pulumi.Input[str]] = None,
             granted_app_roles: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppGrantedAppRoleArgs']]]] = None,
             grants: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppGrantArgs']]]] = None,
             hashed_client_secret: Optional[pulumi.Input[str]] = None,
             home_page_url: Optional[pulumi.Input[str]] = None,
             icon: Optional[pulumi.Input[str]] = None,
             id_token_enc_algo: Optional[pulumi.Input[str]] = None,
             idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdcsCreatedByArgs']]]] = None,
             idcs_endpoint: Optional[pulumi.Input[str]] = None,
             idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdcsLastModifiedByArgs']]]] = None,
             idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
             idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdentityProviderArgs']]]] = None,
             idp_policy: Optional[pulumi.Input['DomainsAppIdpPolicyArgs']] = None,
             infrastructure: Optional[pulumi.Input[bool]] = None,
             is_alias_app: Optional[pulumi.Input[bool]] = None,
             is_database_service: Optional[pulumi.Input[bool]] = None,
             is_enterprise_app: Optional[pulumi.Input[bool]] = None,
             is_form_fill: Optional[pulumi.Input[bool]] = None,
             is_kerberos_realm: Optional[pulumi.Input[bool]] = None,
             is_login_target: Optional[pulumi.Input[bool]] = None,
             is_managed_app: Optional[pulumi.Input[bool]] = None,
             is_mobile_target: Optional[pulumi.Input[bool]] = None,
             is_multicloud_service_app: Optional[pulumi.Input[bool]] = None,
             is_oauth_client: Optional[pulumi.Input[bool]] = None,
             is_oauth_resource: Optional[pulumi.Input[bool]] = None,
             is_obligation_capable: Optional[pulumi.Input[bool]] = None,
             is_opc_service: Optional[pulumi.Input[bool]] = None,
             is_radius_app: Optional[pulumi.Input[bool]] = None,
             is_saml_service_provider: Optional[pulumi.Input[bool]] = None,
             is_unmanaged_app: Optional[pulumi.Input[bool]] = None,
             is_web_tier_policy: Optional[pulumi.Input[bool]] = None,
             landing_page_url: Optional[pulumi.Input[str]] = None,
             linking_callback_url: Optional[pulumi.Input[str]] = None,
             login_mechanism: Optional[pulumi.Input[str]] = None,
             login_page_url: Optional[pulumi.Input[str]] = None,
             logout_page_url: Optional[pulumi.Input[str]] = None,
             logout_uri: Optional[pulumi.Input[str]] = None,
             metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppMetaArgs']]]] = None,
             meter_as_opc_service: Optional[pulumi.Input[bool]] = None,
             migrated: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             ocid: Optional[pulumi.Input[str]] = None,
             post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             privacy_policy_url: Optional[pulumi.Input[str]] = None,
             product_logo_url: Optional[pulumi.Input[str]] = None,
             product_name: Optional[pulumi.Input[str]] = None,
             protectable_secondary_audiences: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppProtectableSecondaryAudienceArgs']]]] = None,
             radius_policy: Optional[pulumi.Input['DomainsAppRadiusPolicyArgs']] = None,
             ready_to_upgrade: Optional[pulumi.Input[bool]] = None,
             redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             refresh_token_expiry: Optional[pulumi.Input[int]] = None,
             resource_type_schema_version: Optional[pulumi.Input[str]] = None,
             saml_service_provider: Optional[pulumi.Input['DomainsAppSamlServiceProviderArgs']] = None,
             schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             scopes: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppScopeArgs']]]] = None,
             secondary_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             service_params: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppServiceParamArgs']]]] = None,
             service_type_urn: Optional[pulumi.Input[str]] = None,
             service_type_version: Optional[pulumi.Input[str]] = None,
             show_in_my_apps: Optional[pulumi.Input[bool]] = None,
             signon_policy: Optional[pulumi.Input['DomainsAppSignonPolicyArgs']] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTagArgs']]]] = None,
             tenancy_ocid: Optional[pulumi.Input[str]] = None,
             terms_of_service_url: Optional[pulumi.Input[str]] = None,
             terms_of_use: Optional[pulumi.Input['DomainsAppTermsOfUseArgs']] = None,
             trust_policies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTrustPolicyArgs']]]] = None,
             trust_scope: Optional[pulumi.Input[str]] = None,
             urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensiondbcs_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionenterprise_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionform_fill_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionmanagedapp_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionopc_service_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionradius_app_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionrequestable_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs']] = None,
             urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs']] = None,
             user_roles: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppUserRoleArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if access_token_expiry is not None:
            _setter("access_token_expiry", access_token_expiry)
        if accounts is not None:
            _setter("accounts", accounts)
        if active is not None:
            _setter("active", active)
        if admin_roles is not None:
            _setter("admin_roles", admin_roles)
        if alias_apps is not None:
            _setter("alias_apps", alias_apps)
        if all_url_schemes_allowed is not None:
            _setter("all_url_schemes_allowed", all_url_schemes_allowed)
        if allow_access_control is not None:
            _setter("allow_access_control", allow_access_control)
        if allow_offline is not None:
            _setter("allow_offline", allow_offline)
        if allowed_grants is not None:
            _setter("allowed_grants", allowed_grants)
        if allowed_operations is not None:
            _setter("allowed_operations", allowed_operations)
        if allowed_scopes is not None:
            _setter("allowed_scopes", allowed_scopes)
        if allowed_tags is not None:
            _setter("allowed_tags", allowed_tags)
        if app_icon is not None:
            _setter("app_icon", app_icon)
        if app_signon_policy is not None:
            _setter("app_signon_policy", app_signon_policy)
        if app_thumbnail is not None:
            _setter("app_thumbnail", app_thumbnail)
        if apps_network_perimeters is not None:
            _setter("apps_network_perimeters", apps_network_perimeters)
        if as_opc_service is not None:
            _setter("as_opc_service", as_opc_service)
        if attr_rendering_metadatas is not None:
            _setter("attr_rendering_metadatas", attr_rendering_metadatas)
        if attribute_sets is not None:
            _setter("attribute_sets", attribute_sets)
        if attributes is not None:
            _setter("attributes", attributes)
        if audience is not None:
            _setter("audience", audience)
        if authorization is not None:
            _setter("authorization", authorization)
        if based_on_template is not None:
            _setter("based_on_template", based_on_template)
        if bypass_consent is not None:
            _setter("bypass_consent", bypass_consent)
        if callback_service_url is not None:
            _setter("callback_service_url", callback_service_url)
        if certificates is not None:
            _setter("certificates", certificates)
        if client_ip_checking is not None:
            _setter("client_ip_checking", client_ip_checking)
        if client_secret is not None:
            _setter("client_secret", client_secret)
        if client_type is not None:
            _setter("client_type", client_type)
        if cloud_control_properties is not None:
            _setter("cloud_control_properties", cloud_control_properties)
        if compartment_ocid is not None:
            _setter("compartment_ocid", compartment_ocid)
        if contact_email_address is not None:
            _setter("contact_email_address", contact_email_address)
        if delegated_service_names is not None:
            _setter("delegated_service_names", delegated_service_names)
        if delete_in_progress is not None:
            _setter("delete_in_progress", delete_in_progress)
        if description is not None:
            _setter("description", description)
        if disable_kmsi_token_authentication is not None:
            _setter("disable_kmsi_token_authentication", disable_kmsi_token_authentication)
        if display_name is not None:
            _setter("display_name", display_name)
        if domain_ocid is not None:
            _setter("domain_ocid", domain_ocid)
        if editable_attributes is not None:
            _setter("editable_attributes", editable_attributes)
        if error_page_url is not None:
            _setter("error_page_url", error_page_url)
        if granted_app_roles is not None:
            _setter("granted_app_roles", granted_app_roles)
        if grants is not None:
            _setter("grants", grants)
        if hashed_client_secret is not None:
            _setter("hashed_client_secret", hashed_client_secret)
        if home_page_url is not None:
            _setter("home_page_url", home_page_url)
        if icon is not None:
            _setter("icon", icon)
        if id_token_enc_algo is not None:
            _setter("id_token_enc_algo", id_token_enc_algo)
        if idcs_created_bies is not None:
            _setter("idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            _setter("idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            _setter("idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            _setter("idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            _setter("idcs_prevented_operations", idcs_prevented_operations)
        if identity_providers is not None:
            _setter("identity_providers", identity_providers)
        if idp_policy is not None:
            _setter("idp_policy", idp_policy)
        if infrastructure is not None:
            _setter("infrastructure", infrastructure)
        if is_alias_app is not None:
            _setter("is_alias_app", is_alias_app)
        if is_database_service is not None:
            _setter("is_database_service", is_database_service)
        if is_enterprise_app is not None:
            _setter("is_enterprise_app", is_enterprise_app)
        if is_form_fill is not None:
            _setter("is_form_fill", is_form_fill)
        if is_kerberos_realm is not None:
            _setter("is_kerberos_realm", is_kerberos_realm)
        if is_login_target is not None:
            _setter("is_login_target", is_login_target)
        if is_managed_app is not None:
            _setter("is_managed_app", is_managed_app)
        if is_mobile_target is not None:
            _setter("is_mobile_target", is_mobile_target)
        if is_multicloud_service_app is not None:
            _setter("is_multicloud_service_app", is_multicloud_service_app)
        if is_oauth_client is not None:
            _setter("is_oauth_client", is_oauth_client)
        if is_oauth_resource is not None:
            _setter("is_oauth_resource", is_oauth_resource)
        if is_obligation_capable is not None:
            _setter("is_obligation_capable", is_obligation_capable)
        if is_opc_service is not None:
            _setter("is_opc_service", is_opc_service)
        if is_radius_app is not None:
            _setter("is_radius_app", is_radius_app)
        if is_saml_service_provider is not None:
            _setter("is_saml_service_provider", is_saml_service_provider)
        if is_unmanaged_app is not None:
            _setter("is_unmanaged_app", is_unmanaged_app)
        if is_web_tier_policy is not None:
            _setter("is_web_tier_policy", is_web_tier_policy)
        if landing_page_url is not None:
            _setter("landing_page_url", landing_page_url)
        if linking_callback_url is not None:
            _setter("linking_callback_url", linking_callback_url)
        if login_mechanism is not None:
            _setter("login_mechanism", login_mechanism)
        if login_page_url is not None:
            _setter("login_page_url", login_page_url)
        if logout_page_url is not None:
            _setter("logout_page_url", logout_page_url)
        if logout_uri is not None:
            _setter("logout_uri", logout_uri)
        if metas is not None:
            _setter("metas", metas)
        if meter_as_opc_service is not None:
            _setter("meter_as_opc_service", meter_as_opc_service)
        if migrated is not None:
            _setter("migrated", migrated)
        if name is not None:
            _setter("name", name)
        if ocid is not None:
            _setter("ocid", ocid)
        if post_logout_redirect_uris is not None:
            _setter("post_logout_redirect_uris", post_logout_redirect_uris)
        if privacy_policy_url is not None:
            _setter("privacy_policy_url", privacy_policy_url)
        if product_logo_url is not None:
            _setter("product_logo_url", product_logo_url)
        if product_name is not None:
            _setter("product_name", product_name)
        if protectable_secondary_audiences is not None:
            _setter("protectable_secondary_audiences", protectable_secondary_audiences)
        if radius_policy is not None:
            _setter("radius_policy", radius_policy)
        if ready_to_upgrade is not None:
            _setter("ready_to_upgrade", ready_to_upgrade)
        if redirect_uris is not None:
            _setter("redirect_uris", redirect_uris)
        if refresh_token_expiry is not None:
            _setter("refresh_token_expiry", refresh_token_expiry)
        if resource_type_schema_version is not None:
            _setter("resource_type_schema_version", resource_type_schema_version)
        if saml_service_provider is not None:
            _setter("saml_service_provider", saml_service_provider)
        if schemas is not None:
            _setter("schemas", schemas)
        if scopes is not None:
            _setter("scopes", scopes)
        if secondary_audiences is not None:
            _setter("secondary_audiences", secondary_audiences)
        if service_params is not None:
            _setter("service_params", service_params)
        if service_type_urn is not None:
            _setter("service_type_urn", service_type_urn)
        if service_type_version is not None:
            _setter("service_type_version", service_type_version)
        if show_in_my_apps is not None:
            _setter("show_in_my_apps", show_in_my_apps)
        if signon_policy is not None:
            _setter("signon_policy", signon_policy)
        if tags is not None:
            _setter("tags", tags)
        if tenancy_ocid is not None:
            _setter("tenancy_ocid", tenancy_ocid)
        if terms_of_service_url is not None:
            _setter("terms_of_service_url", terms_of_service_url)
        if terms_of_use is not None:
            _setter("terms_of_use", terms_of_use)
        if trust_policies is not None:
            _setter("trust_policies", trust_policies)
        if trust_scope is not None:
            _setter("trust_scope", trust_scope)
        if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None:
            _setter("urnietfparamsscimschemasoracleidcsextension_oci_tags", urnietfparamsscimschemasoracleidcsextension_oci_tags)
        if urnietfparamsscimschemasoracleidcsextensiondbcs_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensiondbcs_app", urnietfparamsscimschemasoracleidcsextensiondbcs_app)
        if urnietfparamsscimschemasoracleidcsextensionenterprise_app_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionenterprise_app_app", urnietfparamsscimschemasoracleidcsextensionenterprise_app_app)
        if urnietfparamsscimschemasoracleidcsextensionform_fill_app_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionform_fill_app_app", urnietfparamsscimschemasoracleidcsextensionform_fill_app_app)
        if urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template", urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template)
        if urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app", urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app)
        if urnietfparamsscimschemasoracleidcsextensionmanagedapp_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionmanagedapp_app", urnietfparamsscimschemasoracleidcsextensionmanagedapp_app)
        if urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app", urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app)
        if urnietfparamsscimschemasoracleidcsextensionopc_service_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionopc_service_app", urnietfparamsscimschemasoracleidcsextensionopc_service_app)
        if urnietfparamsscimschemasoracleidcsextensionradius_app_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionradius_app_app", urnietfparamsscimschemasoracleidcsextensionradius_app_app)
        if urnietfparamsscimschemasoracleidcsextensionrequestable_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionrequestable_app", urnietfparamsscimschemasoracleidcsextensionrequestable_app)
        if urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app", urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app)
        if urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app is not None:
            _setter("urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app", urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app)
        if user_roles is not None:
            _setter("user_roles", user_roles)

    @property
    @pulumi.getter(name="accessTokenExpiry")
    def access_token_expiry(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Access token expiry

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: dateTime
        * uniqueness: none
        """
        return pulumi.get(self, "access_token_expiry")

    @access_token_expiry.setter
    def access_token_expiry(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "access_token_expiry", value)

    @property
    @pulumi.getter
    def accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAccountArgs']]]]:
        """
        (Updatable) Accounts of App

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "accounts")

    @accounts.setter
    def accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAccountArgs']]]]):
        pulumi.set(self, "accounts", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this App is able to participate in runtime services, such as automatic-login, OAuth, and SAML. If false, all runtime services are disabled for this App, and only administrative operations can be performed.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="adminRoles")
    def admin_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAdminRoleArgs']]]]:
        """
        (Updatable) A list of AppRoles defined by this UnmanagedApp. Membership in each of these AppRoles confers administrative privilege within this App.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        """
        return pulumi.get(self, "admin_roles")

    @admin_roles.setter
    def admin_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAdminRoleArgs']]]]):
        pulumi.set(self, "admin_roles", value)

    @property
    @pulumi.getter(name="aliasApps")
    def alias_apps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAliasAppArgs']]]]:
        """
        (Updatable) Each value of this internal attribute refers to an Oracle Public Cloud infrastructure App on which this App depends.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "alias_apps")

    @alias_apps.setter
    def alias_apps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAliasAppArgs']]]]):
        pulumi.set(self, "alias_apps", value)

    @property
    @pulumi.getter(name="allUrlSchemesAllowed")
    def all_url_schemes_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the system should allow all URL-schemes within each value of the 'redirectUris' attribute.  Also indicates that the system should not attempt to confirm that each value of the 'redirectUris' attribute is a valid URI.  In particular, the system should not confirm that the domain component of the URI is a top-level domain and the system should not confirm that the hostname portion is a valid system that is reachable over the network.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "all_url_schemes_allowed")

    @all_url_schemes_allowed.setter
    def all_url_schemes_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_url_schemes_allowed", value)

    @property
    @pulumi.getter(name="allowAccessControl")
    def allow_access_control(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, any managed App that is based on this template is checked for access control that is, access to this app is subject to successful authorization at SSO service, viz. app grants to start with.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "allow_access_control")

    @allow_access_control.setter
    def allow_access_control(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_access_control", value)

    @property
    @pulumi.getter(name="allowOffline")
    def allow_offline(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the Refresh Token is allowed when this App acts as an OAuth Resource.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "allow_offline")

    @allow_offline.setter
    def allow_offline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_offline", value)

    @property
    @pulumi.getter(name="allowedGrants")
    def allowed_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of grant-types that this App is allowed to use when it acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_grants")

    @allowed_grants.setter
    def allowed_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_grants", value)

    @property
    @pulumi.getter(name="allowedOperations")
    def allowed_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) OPTIONAL. Required only when this App acts as an OAuthClient. Supported values are 'introspect' and 'onBehalfOfUser'. The value 'introspect' allows the client to look inside the access-token. The value 'onBehalfOfUser' overrides how the client's privileges are combined with the privileges of the Subject User. Ordinarily, authorization calculates the set of effective privileges as the intersection of the client's privileges and the user's privileges. The value 'onBehalfOf' indicates that authorization should ignore the privileges of the client and use only the user's privileges to calculate the effective privileges.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_operations")

    @allowed_operations.setter
    def allowed_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_operations", value)

    @property
    @pulumi.getter(name="allowedScopes")
    def allowed_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedScopeArgs']]]]:
        """
        (Updatable) A list of scopes (exposed by this App or by other Apps) that this App is allowed to access when it acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsCompositeKey: [fqs]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_scopes")

    @allowed_scopes.setter
    def allowed_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedScopeArgs']]]]):
        pulumi.set(self, "allowed_scopes", value)

    @property
    @pulumi.getter(name="allowedTags")
    def allowed_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedTagArgs']]]]:
        """
        (Updatable) A list of tags, acting as an OAuthClient, this App is allowed to access.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_tags")

    @allowed_tags.setter
    def allowed_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAllowedTagArgs']]]]):
        pulumi.set(self, "allowed_tags", value)

    @property
    @pulumi.getter(name="appIcon")
    def app_icon(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Application icon.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "app_icon")

    @app_icon.setter
    def app_icon(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_icon", value)

    @property
    @pulumi.getter(name="appSignonPolicy")
    def app_signon_policy(self) -> Optional[pulumi.Input['DomainsAppAppSignonPolicyArgs']]:
        """
        (Updatable) App Sign-on Policy.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "app_signon_policy")

    @app_signon_policy.setter
    def app_signon_policy(self, value: Optional[pulumi.Input['DomainsAppAppSignonPolicyArgs']]):
        pulumi.set(self, "app_signon_policy", value)

    @property
    @pulumi.getter(name="appThumbnail")
    def app_thumbnail(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Application thumbnail.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "app_thumbnail")

    @app_thumbnail.setter
    def app_thumbnail(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_thumbnail", value)

    @property
    @pulumi.getter(name="appsNetworkPerimeters")
    def apps_network_perimeters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAppsNetworkPerimeterArgs']]]]:
        """
        (Updatable) Network Perimeter

        **Added In:** 2010242156

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "apps_network_perimeters")

    @apps_network_perimeters.setter
    def apps_network_perimeters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAppsNetworkPerimeterArgs']]]]):
        pulumi.set(self, "apps_network_perimeters", value)

    @property
    @pulumi.getter(name="asOpcService")
    def as_opc_service(self) -> Optional[pulumi.Input['DomainsAppAsOpcServiceArgs']]:
        """
        (Updatable) OPCService facet of the application.

        **Deprecated Since: 17.3.4**

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "as_opc_service")

    @as_opc_service.setter
    def as_opc_service(self, value: Optional[pulumi.Input['DomainsAppAsOpcServiceArgs']]):
        pulumi.set(self, "as_opc_service", value)

    @property
    @pulumi.getter(name="attrRenderingMetadatas")
    def attr_rendering_metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAttrRenderingMetadataArgs']]]]:
        """
        (Updatable) Label for the attribute to be shown in the UI.

        **SCIM++ Properties:**
        * idcsCompositeKey: [name]
        * idcsSearchable: false
        * multiValued: true
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "attr_rendering_metadatas")

    @attr_rendering_metadatas.setter
    def attr_rendering_metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppAttrRenderingMetadataArgs']]]]):
        pulumi.set(self, "attr_rendering_metadatas", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base URI for all of the scopes defined in this App. The value of 'audience' is combined with the 'value' of each scope to form an 'fqs' or fully qualified scope.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="basedOnTemplate")
    def based_on_template(self) -> Optional[pulumi.Input['DomainsAppBasedOnTemplateArgs']]:
        """
        (Updatable) Application template on which the application is based.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "based_on_template")

    @based_on_template.setter
    def based_on_template(self, value: Optional[pulumi.Input['DomainsAppBasedOnTemplateArgs']]):
        pulumi.set(self, "based_on_template", value)

    @property
    @pulumi.getter(name="bypassConsent")
    def bypass_consent(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that consent should be skipped for all scopes

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "bypass_consent")

    @bypass_consent.setter
    def bypass_consent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bypass_consent", value)

    @property
    @pulumi.getter(name="callbackServiceUrl")
    def callback_service_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Callback Service URL

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "callback_service_url")

    @callback_service_url.setter
    def callback_service_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "callback_service_url", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppCertificateArgs']]]]:
        """
        (Updatable) Each value of this attribute represent a certificate that this App uses when it acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [certAlias]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter(name="clientIpChecking")
    def client_ip_checking(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Network Perimeters checking mode

        **Added In:** 2010242156

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "client_ip_checking")

    @client_ip_checking.setter
    def client_ip_checking(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_ip_checking", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This value is the credential of this App, which this App supplies as a password when this App authenticates to the Oracle Public Cloud infrastructure. This value is also the client secret of this App when it acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * idcsSensitive: none
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="clientType")
    def client_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies the type of access that this App has when it acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "client_type")

    @client_type.setter
    def client_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_type", value)

    @property
    @pulumi.getter(name="cloudControlProperties")
    def cloud_control_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppCloudControlPropertyArgs']]]]:
        """
        (Updatable) A collection of arbitrary properties that scope the privileges of a cloud-control App.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
        * idcsCompositeKey: [name]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "cloud_control_properties")

    @cloud_control_properties.setter
    def cloud_control_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppCloudControlPropertyArgs']]]]):
        pulumi.set(self, "cloud_control_properties", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="contactEmailAddress")
    def contact_email_address(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Contact Email Address

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "contact_email_address")

    @contact_email_address.setter
    def contact_email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contact_email_address", value)

    @property
    @pulumi.getter(name="delegatedServiceNames")
    def delegated_service_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Service Names allow to use Oracle Cloud Infrastructure signature for client authentication instead of client credentials

        **Added In:** 2207040824

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "delegated_service_names")

    @delegated_service_names.setter
    def delegated_service_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delegated_service_names", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the AppRole.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableKmsiTokenAuthentication")
    def disable_kmsi_token_authentication(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether the application is allowed to be access using kmsi token.

        **Added In:** 2111190457

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: always
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "disable_kmsi_token_authentication")

    @disable_kmsi_token_authentication.setter
    def disable_kmsi_token_authentication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_kmsi_token_authentication", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Display name of the flatfile bundle configuration property. This attribute maps to \\"displayName\\" attribute in \\"ConfigurationProperty\\" in ICF.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter(name="editableAttributes")
    def editable_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppEditableAttributeArgs']]]]:
        """
        (Updatable) App attributes editable by subject

        **Added In:** 18.2.6

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [name]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "editable_attributes")

    @editable_attributes.setter
    def editable_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppEditableAttributeArgs']]]]):
        pulumi.set(self, "editable_attributes", value)

    @property
    @pulumi.getter(name="errorPageUrl")
    def error_page_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This attribute specifies the URL of the page to which an application will redirect an end-user in case of error.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "error_page_url")

    @error_page_url.setter
    def error_page_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_page_url", value)

    @property
    @pulumi.getter(name="grantedAppRoles")
    def granted_app_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppGrantedAppRoleArgs']]]]:
        """
        (Updatable) A list of AppRoles that are granted to this App (and that are defined by other Apps). Within the Oracle Public Cloud infrastructure, this allows AppID-based association. Such an association allows this App to act as a consumer and thus to access resources of another App that acts as a producer.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "granted_app_roles")

    @granted_app_roles.setter
    def granted_app_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppGrantedAppRoleArgs']]]]):
        pulumi.set(self, "granted_app_roles", value)

    @property
    @pulumi.getter
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppGrantArgs']]]]:
        """
        (Updatable) Grants assigned to the app

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppGrantArgs']]]]):
        pulumi.set(self, "grants", value)

    @property
    @pulumi.getter(name="hashedClientSecret")
    def hashed_client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Hashed Client Secret. This hash-value is used to verify the 'clientSecret' credential of this App

        **Added In:** 2106240046

        **SCIM++ Properties:**
        * idcsSearchable: false
        * idcsSensitive: hash_sc
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "hashed_client_secret")

    @hashed_client_secret.setter
    def hashed_client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hashed_client_secret", value)

    @property
    @pulumi.getter(name="homePageUrl")
    def home_page_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Home Page URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "home_page_url")

    @home_page_url.setter
    def home_page_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "home_page_url", value)

    @property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) URL of application icon.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: reference
        * uniqueness: none
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon", value)

    @property
    @pulumi.getter(name="idTokenEncAlgo")
    def id_token_enc_algo(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Encryption Alogrithm to use for encrypting ID token.

        **Added In:** 2010242156

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "id_token_enc_algo")

    @id_token_enc_algo.setter
    def id_token_enc_algo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id_token_enc_algo", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter(name="identityProviders")
    def identity_providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdentityProviderArgs']]]]:
        """
        (Updatable) A list of IdentityProvider assigned to app. A user trying to access this app will be automatically redirected to configured IdP during the authentication phase, before being able to access App.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        """
        return pulumi.get(self, "identity_providers")

    @identity_providers.setter
    def identity_providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppIdentityProviderArgs']]]]):
        pulumi.set(self, "identity_providers", value)

    @property
    @pulumi.getter(name="idpPolicy")
    def idp_policy(self) -> Optional[pulumi.Input['DomainsAppIdpPolicyArgs']]:
        """
        (Updatable) IDP Policy.

        **Added In:** 18.1.2

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idp_policy")

    @idp_policy.setter
    def idp_policy(self, value: Optional[pulumi.Input['DomainsAppIdpPolicyArgs']]):
        pulumi.set(self, "idp_policy", value)

    @property
    @pulumi.getter
    def infrastructure(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this App is an internal infrastructure App.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "infrastructure")

    @infrastructure.setter
    def infrastructure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "infrastructure", value)

    @property
    @pulumi.getter(name="isAliasApp")
    def is_alias_app(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, this App is an AliasApp and it cannot be granted to an end-user directly.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: always
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_alias_app")

    @is_alias_app.setter
    def is_alias_app(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_alias_app", value)

    @property
    @pulumi.getter(name="isDatabaseService")
    def is_database_service(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this application acts as database service Application

        **Added In:** 18.2.2

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * type: boolean
        """
        return pulumi.get(self, "is_database_service")

    @is_database_service.setter
    def is_database_service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_database_service", value)

    @property
    @pulumi.getter(name="isEnterpriseApp")
    def is_enterprise_app(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this app acts as Enterprise app with Authentication and URL Authz policy.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_enterprise_app")

    @is_enterprise_app.setter
    def is_enterprise_app(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enterprise_app", value)

    @property
    @pulumi.getter(name="isFormFill")
    def is_form_fill(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this application acts as FormFill Application

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_form_fill")

    @is_form_fill.setter
    def is_form_fill(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_form_fill", value)

    @property
    @pulumi.getter(name="isKerberosRealm")
    def is_kerberos_realm(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that this App supports Kerberos Authentication

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_kerberos_realm")

    @is_kerberos_realm.setter
    def is_kerberos_realm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_kerberos_realm", value)

    @property
    @pulumi.getter(name="isLoginTarget")
    def is_login_target(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this App allows runtime services to log end users into this App automatically.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_login_target")

    @is_login_target.setter
    def is_login_target(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_login_target", value)

    @property
    @pulumi.getter(name="isManagedApp")
    def is_managed_app(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that access to this App requires an account. That is, in order to log in to the App, a User must use an application-specific identity that is maintained in the remote identity-repository of that App.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_managed_app")

    @is_managed_app.setter
    def is_managed_app(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_managed_app", value)

    @property
    @pulumi.getter(name="isMobileTarget")
    def is_mobile_target(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that the App should be visible in each end-user's mobile application.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_mobile_target")

    @is_mobile_target.setter
    def is_mobile_target(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_mobile_target", value)

    @property
    @pulumi.getter(name="isMulticloudServiceApp")
    def is_multicloud_service_app(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates the app is used for multicloud service integration.

        **Added In:** 2301202328

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_multicloud_service_app")

    @is_multicloud_service_app.setter
    def is_multicloud_service_app(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_multicloud_service_app", value)

    @property
    @pulumi.getter(name="isOauthClient")
    def is_oauth_client(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this application acts as an OAuth Client

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_oauth_client")

    @is_oauth_client.setter
    def is_oauth_client(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_oauth_client", value)

    @property
    @pulumi.getter(name="isOauthResource")
    def is_oauth_resource(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, indicates that this application acts as an OAuth Resource.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_oauth_resource")

    @is_oauth_resource.setter
    def is_oauth_resource(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_oauth_resource", value)

    @property
    @pulumi.getter(name="isObligationCapable")
    def is_obligation_capable(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) This flag indicates if the App is capable of validating obligations with the token for allowing access to the App.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_obligation_capable")

    @is_obligation_capable.setter
    def is_obligation_capable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_obligation_capable", value)

    @property
    @pulumi.getter(name="isOpcService")
    def is_opc_service(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this application is an Oracle Public Cloud service-instance.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_opc_service")

    @is_opc_service.setter
    def is_opc_service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_opc_service", value)

    @property
    @pulumi.getter(name="isRadiusApp")
    def is_radius_app(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this application acts as an Radius App

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_radius_app")

    @is_radius_app.setter
    def is_radius_app(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_radius_app", value)

    @property
    @pulumi.getter(name="isSamlServiceProvider")
    def is_saml_service_provider(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, then this App acts as a SAML Service Provider.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_saml_service_provider")

    @is_saml_service_provider.setter
    def is_saml_service_provider(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_saml_service_provider", value)

    @property
    @pulumi.getter(name="isUnmanagedApp")
    def is_unmanaged_app(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, indicates that this application accepts an Oracle Cloud Identity Service User as a login-identity (does not require an account) and relies for authorization on the User's memberships in AppRoles.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_unmanaged_app")

    @is_unmanaged_app.setter
    def is_unmanaged_app(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_unmanaged_app", value)

    @property
    @pulumi.getter(name="isWebTierPolicy")
    def is_web_tier_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, the webtier policy is active

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_web_tier_policy")

    @is_web_tier_policy.setter
    def is_web_tier_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_web_tier_policy", value)

    @property
    @pulumi.getter(name="landingPageUrl")
    def landing_page_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The URL of the landing page for this App, which is the first page that an end user should see if runtime services log that end user in to this App automatically.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "landing_page_url")

    @landing_page_url.setter
    def landing_page_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "landing_page_url", value)

    @property
    @pulumi.getter(name="linkingCallbackUrl")
    def linking_callback_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This attribute specifies the callback URL for the social linking operation.

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "linking_callback_url")

    @linking_callback_url.setter
    def linking_callback_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_callback_url", value)

    @property
    @pulumi.getter(name="loginMechanism")
    def login_mechanism(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The protocol that runtime services will use to log end users in to this App automatically. If 'OIDC', then runtime services use the OpenID Connect protocol. If 'SAML', then runtime services use Security Assertion Markup Language protocol.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "login_mechanism")

    @login_mechanism.setter
    def login_mechanism(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_mechanism", value)

    @property
    @pulumi.getter(name="loginPageUrl")
    def login_page_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This attribute specifies the URL of the page that the App uses when an end-user signs in to that App.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "login_page_url")

    @login_page_url.setter
    def login_page_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_page_url", value)

    @property
    @pulumi.getter(name="logoutPageUrl")
    def logout_page_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This attribute specifies the URL of the page that the App uses when an end-user signs out.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_page_url")

    @logout_page_url.setter
    def logout_page_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_page_url", value)

    @property
    @pulumi.getter(name="logoutUri")
    def logout_uri(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OAuth will use this URI to logout if this App wants to participate in SSO, and if this App's session gets cleared as part of global logout. Note: This attribute is used only if this App acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_uri")

    @logout_uri.setter
    def logout_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_uri", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter(name="meterAsOpcService")
    def meter_as_opc_service(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates whether the application is billed as an OPCService. If true, customer is not billed for runtime operations of the app.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: always
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "meter_as_opc_service")

    @meter_as_opc_service.setter
    def meter_as_opc_service(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "meter_as_opc_service", value)

    @property
    @pulumi.getter
    def migrated(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this App was migrated from an earlier version of Oracle Public Cloud infrastructure (and may therefore require special handling from runtime services such as OAuth or SAML). If false, this App requires no special handling from runtime services.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "migrated")

    @migrated.setter
    def migrated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "migrated", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The attribute represents the name of the attribute that will be used in the Security Assertion Markup Language (SAML) assertion

        **Deprecated Since: 18.2.2**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * idcsValuePersistedInOtherAttribute: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="postLogoutRedirectUris")
    def post_logout_redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Each value of this attribute is the URI of a landing page within this App. It is used only when this App, acting as an OAuthClient, initiates the logout flow and wants to be redirected back to one of its landing pages.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "post_logout_redirect_uris")

    @post_logout_redirect_uris.setter
    def post_logout_redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "post_logout_redirect_uris", value)

    @property
    @pulumi.getter(name="privacyPolicyUrl")
    def privacy_policy_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Privacy Policy URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "privacy_policy_url")

    @privacy_policy_url.setter
    def privacy_policy_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "privacy_policy_url", value)

    @property
    @pulumi.getter(name="productLogoUrl")
    def product_logo_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Application Logo URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "product_logo_url")

    @product_logo_url.setter
    def product_logo_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_logo_url", value)

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Product Name

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "product_name")

    @product_name.setter
    def product_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_name", value)

    @property
    @pulumi.getter(name="protectableSecondaryAudiences")
    def protectable_secondary_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppProtectableSecondaryAudienceArgs']]]]:
        """
        (Updatable) A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.

        **Added In:** 18.2.2

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "protectable_secondary_audiences")

    @protectable_secondary_audiences.setter
    def protectable_secondary_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppProtectableSecondaryAudienceArgs']]]]):
        pulumi.set(self, "protectable_secondary_audiences", value)

    @property
    @pulumi.getter(name="radiusPolicy")
    def radius_policy(self) -> Optional[pulumi.Input['DomainsAppRadiusPolicyArgs']]:
        """
        (Updatable) RADIUS Policy assigned to this application.

        **Added In:** 2209070044

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "radius_policy")

    @radius_policy.setter
    def radius_policy(self, value: Optional[pulumi.Input['DomainsAppRadiusPolicyArgs']]):
        pulumi.set(self, "radius_policy", value)

    @property
    @pulumi.getter(name="readyToUpgrade")
    def ready_to_upgrade(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this App requires an upgrade and mandates attention from application administrator. The flag is used by UI to indicate this app is ready to upgrade.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "ready_to_upgrade")

    @ready_to_upgrade.setter
    def ready_to_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ready_to_upgrade", value)

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) OPTIONAL. Each value is a URI within this App. This attribute is required when this App acts as an OAuthClient and is involved in three-legged flows (authorization-code flows).

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "redirect_uris")

    @redirect_uris.setter
    def redirect_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "redirect_uris", value)

    @property
    @pulumi.getter(name="refreshTokenExpiry")
    def refresh_token_expiry(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Expiry-time in seconds for a Refresh Token.  Any token that allows access to this App, once refreshed, will expire after the specified duration.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "refresh_token_expiry")

    @refresh_token_expiry.setter
    def refresh_token_expiry(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "refresh_token_expiry", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter(name="samlServiceProvider")
    def saml_service_provider(self) -> Optional[pulumi.Input['DomainsAppSamlServiceProviderArgs']]:
        """
        (Updatable) An attribute that refers to the SAML Service Provider that runtime services will use to log an end user in to this App automatically. Note that this will be used only if the loginMechanism is 'SAML'.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "saml_service_provider")

    @saml_service_provider.setter
    def saml_service_provider(self, value: Optional[pulumi.Input['DomainsAppSamlServiceProviderArgs']]):
        pulumi.set(self, "saml_service_provider", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppScopeArgs']]]]:
        """
        (Updatable) Scopes defined by this App. Used when this App acts as an OAuth Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppScopeArgs']]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="secondaryAudiences")
    def secondary_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.

        **Deprecated Since: 18.2.6**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "secondary_audiences")

    @secondary_audiences.setter
    def secondary_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "secondary_audiences", value)

    @property
    @pulumi.getter(name="serviceParams")
    def service_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppServiceParamArgs']]]]:
        """
        (Updatable) Custom attribute that is required to compute other attribute values during app creation.

        **SCIM++ Properties:**
        * idcsCompositeKey: [name]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: always
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "service_params")

    @service_params.setter
    def service_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppServiceParamArgs']]]]):
        pulumi.set(self, "service_params", value)

    @property
    @pulumi.getter(name="serviceTypeUrn")
    def service_type_urn(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This Uniform Resource Name (URN) value identifies the type of Oracle Public Cloud service of which this app is an instance.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "service_type_urn")

    @service_type_urn.setter
    def service_type_urn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type_urn", value)

    @property
    @pulumi.getter(name="serviceTypeVersion")
    def service_type_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This value specifies the version of the Oracle Public Cloud service of which this App is an instance

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "service_type_version")

    @service_type_version.setter
    def service_type_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type_version", value)

    @property
    @pulumi.getter(name="showInMyApps")
    def show_in_my_apps(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If true, this app will be displayed in the MyApps page of each end-user who has access to the App.

        **Added In:** 18.1.2

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "show_in_my_apps")

    @show_in_my_apps.setter
    def show_in_my_apps(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "show_in_my_apps", value)

    @property
    @pulumi.getter(name="signonPolicy")
    def signon_policy(self) -> Optional[pulumi.Input['DomainsAppSignonPolicyArgs']]:
        """
        (Updatable) Sign-on Policy.

        **Deprecated Since: 17.3.4**

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "signon_policy")

    @signon_policy.setter
    def signon_policy(self, value: Optional[pulumi.Input['DomainsAppSignonPolicyArgs']]):
        pulumi.set(self, "signon_policy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_ocid", value)

    @property
    @pulumi.getter(name="termsOfServiceUrl")
    def terms_of_service_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Terms of Service URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "terms_of_service_url")

    @terms_of_service_url.setter
    def terms_of_service_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "terms_of_service_url", value)

    @property
    @pulumi.getter(name="termsOfUse")
    def terms_of_use(self) -> Optional[pulumi.Input['DomainsAppTermsOfUseArgs']]:
        """
        (Updatable) Terms Of Use.

        **Added In:** 18.2.6

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "terms_of_use")

    @terms_of_use.setter
    def terms_of_use(self, value: Optional[pulumi.Input['DomainsAppTermsOfUseArgs']]):
        pulumi.set(self, "terms_of_use", value)

    @property
    @pulumi.getter(name="trustPolicies")
    def trust_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTrustPolicyArgs']]]]:
        """
        (Updatable) Trust Policies.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "trust_policies")

    @trust_policies.setter
    def trust_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppTrustPolicyArgs']]]]):
        pulumi.set(self, "trust_policies", value)

    @property
    @pulumi.getter(name="trustScope")
    def trust_scope(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Indicates the scope of trust for this App when acting as an OAuthClient. A value of 'Explicit' indicates that the App is allowed to access only the scopes of OAuthResources that are explicitly specified as 'allowedScopes'. A value of 'Account' indicates that the App is allowed implicitly to access any scope of any OAuthResource within the same Oracle Cloud Account. A value of 'Tags' indicates that the App is allowed to access any scope of any OAuthResource with a matching tag within the same Oracle Cloud Account. A value of 'Default' indicates that the Tenant default trust scope configured in the Tenant Settings is used.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "trust_scope")

    @trust_scope.setter
    def trust_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trust_scope", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionOciTags")
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]:
        """
        (Updatable) Oracle Cloud Infrastructure Tags.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags")

    @urnietfparamsscimschemasoracleidcsextension_oci_tags.setter
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiondbcsApp")
    def urnietfparamsscimschemasoracleidcsextensiondbcs_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs']]:
        """
        (Updatable) This extension provides attributes for database service facet of an App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiondbcs_app")

    @urnietfparamsscimschemasoracleidcsextensiondbcs_app.setter
    def urnietfparamsscimschemasoracleidcsextensiondbcs_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensiondbcs_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionenterpriseAppApp")
    def urnietfparamsscimschemasoracleidcsextensionenterprise_app_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs']]:
        """
        (Updatable) This extension defines the Enterprise App related attributes.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionenterprise_app_app")

    @urnietfparamsscimschemasoracleidcsextensionenterprise_app_app.setter
    def urnietfparamsscimschemasoracleidcsextensionenterprise_app_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionenterprise_app_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionformFillAppApp")
    def urnietfparamsscimschemasoracleidcsextensionform_fill_app_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs']]:
        """
        (Updatable) This extension provides attributes for Form-Fill facet of App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionform_fill_app_app")

    @urnietfparamsscimschemasoracleidcsextensionform_fill_app_app.setter
    def urnietfparamsscimschemasoracleidcsextensionform_fill_app_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionform_fill_app_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplate")
    def urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs']]:
        """
        (Updatable) This extension provides attributes for Form-Fill facet of AppTemplate
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template")

    @urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template.setter
    def urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionkerberosRealmApp")
    def urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs']]:
        """
        (Updatable) Kerberos Realm
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app")

    @urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app.setter
    def urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionmanagedappApp")
    def urnietfparamsscimschemasoracleidcsextensionmanagedapp_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs']]:
        """
        (Updatable) Managed App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionmanagedapp_app")

    @urnietfparamsscimschemasoracleidcsextensionmanagedapp_app.setter
    def urnietfparamsscimschemasoracleidcsextensionmanagedapp_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionmanagedapp_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppApp")
    def urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs']]:
        """
        (Updatable) This extension defines attributes specific to Apps that represent instances of Multicloud Service App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app")

    @urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app.setter
    def urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionopcServiceApp")
    def urnietfparamsscimschemasoracleidcsextensionopc_service_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs']]:
        """
        (Updatable) This extension defines attributes specific to Apps that represent instances of an Oracle Public Cloud (OPC) service.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionopc_service_app")

    @urnietfparamsscimschemasoracleidcsextensionopc_service_app.setter
    def urnietfparamsscimschemasoracleidcsextensionopc_service_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionopc_service_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionradiusAppApp")
    def urnietfparamsscimschemasoracleidcsextensionradius_app_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs']]:
        """
        (Updatable) This extension defines attributes specific to Apps that represent instances of Radius App.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionradius_app_app")

    @urnietfparamsscimschemasoracleidcsextensionradius_app_app.setter
    def urnietfparamsscimschemasoracleidcsextensionradius_app_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionradius_app_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionrequestableApp")
    def urnietfparamsscimschemasoracleidcsextensionrequestable_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs']]:
        """
        (Updatable) Requestable App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionrequestable_app")

    @urnietfparamsscimschemasoracleidcsextensionrequestable_app.setter
    def urnietfparamsscimschemasoracleidcsextensionrequestable_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionrequestable_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsamlServiceProviderApp")
    def urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs']]:
        """
        (Updatable) This extension defines attributes related to the Service Providers configuration.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app")

    @urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app.setter
    def urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionwebTierPolicyApp")
    def urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app(self) -> Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs']]:
        """
        (Updatable) WebTier Policy
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app")

    @urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app.setter
    def urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app(self, value: Optional[pulumi.Input['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app", value)

    @property
    @pulumi.getter(name="userRoles")
    def user_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppUserRoleArgs']]]]:
        """
        (Updatable) A list of AppRoles defined by this UnmanagedApp. Membership in each of these AppRoles confers end-user privilege within this App.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        """
        return pulumi.get(self, "user_roles")

    @user_roles.setter
    def user_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsAppUserRoleArgs']]]]):
        pulumi.set(self, "user_roles", value)


class DomainsApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_expiry: Optional[pulumi.Input[int]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 alias_apps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAliasAppArgs']]]]] = None,
                 all_url_schemes_allowed: Optional[pulumi.Input[bool]] = None,
                 allow_access_control: Optional[pulumi.Input[bool]] = None,
                 allow_offline: Optional[pulumi.Input[bool]] = None,
                 allowed_grants: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAllowedScopeArgs']]]]] = None,
                 allowed_tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAllowedTagArgs']]]]] = None,
                 app_icon: Optional[pulumi.Input[str]] = None,
                 app_signon_policy: Optional[pulumi.Input[pulumi.InputType['DomainsAppAppSignonPolicyArgs']]] = None,
                 app_thumbnail: Optional[pulumi.Input[str]] = None,
                 apps_network_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAppsNetworkPerimeterArgs']]]]] = None,
                 as_opc_service: Optional[pulumi.Input[pulumi.InputType['DomainsAppAsOpcServiceArgs']]] = None,
                 attr_rendering_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAttrRenderingMetadataArgs']]]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 based_on_template: Optional[pulumi.Input[pulumi.InputType['DomainsAppBasedOnTemplateArgs']]] = None,
                 bypass_consent: Optional[pulumi.Input[bool]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppCertificateArgs']]]]] = None,
                 client_ip_checking: Optional[pulumi.Input[str]] = None,
                 client_type: Optional[pulumi.Input[str]] = None,
                 contact_email_address: Optional[pulumi.Input[str]] = None,
                 delegated_service_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_kmsi_token_authentication: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 error_page_url: Optional[pulumi.Input[str]] = None,
                 home_page_url: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 id_token_enc_algo: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppIdentityProviderArgs']]]]] = None,
                 idp_policy: Optional[pulumi.Input[pulumi.InputType['DomainsAppIdpPolicyArgs']]] = None,
                 is_alias_app: Optional[pulumi.Input[bool]] = None,
                 is_enterprise_app: Optional[pulumi.Input[bool]] = None,
                 is_form_fill: Optional[pulumi.Input[bool]] = None,
                 is_kerberos_realm: Optional[pulumi.Input[bool]] = None,
                 is_login_target: Optional[pulumi.Input[bool]] = None,
                 is_mobile_target: Optional[pulumi.Input[bool]] = None,
                 is_multicloud_service_app: Optional[pulumi.Input[bool]] = None,
                 is_oauth_client: Optional[pulumi.Input[bool]] = None,
                 is_oauth_resource: Optional[pulumi.Input[bool]] = None,
                 is_obligation_capable: Optional[pulumi.Input[bool]] = None,
                 is_radius_app: Optional[pulumi.Input[bool]] = None,
                 is_saml_service_provider: Optional[pulumi.Input[bool]] = None,
                 is_unmanaged_app: Optional[pulumi.Input[bool]] = None,
                 is_web_tier_policy: Optional[pulumi.Input[bool]] = None,
                 landing_page_url: Optional[pulumi.Input[str]] = None,
                 linking_callback_url: Optional[pulumi.Input[str]] = None,
                 login_mechanism: Optional[pulumi.Input[str]] = None,
                 login_page_url: Optional[pulumi.Input[str]] = None,
                 logout_page_url: Optional[pulumi.Input[str]] = None,
                 logout_uri: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 privacy_policy_url: Optional[pulumi.Input[str]] = None,
                 product_logo_url: Optional[pulumi.Input[str]] = None,
                 product_name: Optional[pulumi.Input[str]] = None,
                 protectable_secondary_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppProtectableSecondaryAudienceArgs']]]]] = None,
                 radius_policy: Optional[pulumi.Input[pulumi.InputType['DomainsAppRadiusPolicyArgs']]] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_token_expiry: Optional[pulumi.Input[int]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 saml_service_provider: Optional[pulumi.Input[pulumi.InputType['DomainsAppSamlServiceProviderArgs']]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppScopeArgs']]]]] = None,
                 secondary_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_params: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppServiceParamArgs']]]]] = None,
                 service_type_urn: Optional[pulumi.Input[str]] = None,
                 service_type_version: Optional[pulumi.Input[str]] = None,
                 show_in_my_apps: Optional[pulumi.Input[bool]] = None,
                 signon_policy: Optional[pulumi.Input[pulumi.InputType['DomainsAppSignonPolicyArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppTagArgs']]]]] = None,
                 terms_of_service_url: Optional[pulumi.Input[str]] = None,
                 terms_of_use: Optional[pulumi.Input[pulumi.InputType['DomainsAppTermsOfUseArgs']]] = None,
                 trust_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppTrustPolicyArgs']]]]] = None,
                 trust_scope: Optional[pulumi.Input[str]] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensiondbcs_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionenterprise_app_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionform_fill_app_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionmanagedapp_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionopc_service_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionradius_app_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionrequestable_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs']]] = None,
                 __props__=None):
        """
        This resource provides the App resource in Oracle Cloud Infrastructure Identity Domains service.

        Create an App

        ## Import

        Apps can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Identity/domainsApp:DomainsApp test_app "idcsEndpoint/{idcsEndpoint}/apps/{appId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] access_token_expiry: (Updatable) Access token expiry
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: dateTime
               * uniqueness: none
        :param pulumi.Input[bool] active: (Updatable) If true, this App is able to participate in runtime services, such as automatic-login, OAuth, and SAML. If false, all runtime services are disabled for this App, and only administrative operations can be performed.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAliasAppArgs']]]] alias_apps: (Updatable) Each value of this internal attribute refers to an Oracle Public Cloud infrastructure App on which this App depends.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] all_url_schemes_allowed: (Updatable) If true, indicates that the system should allow all URL-schemes within each value of the 'redirectUris' attribute.  Also indicates that the system should not attempt to confirm that each value of the 'redirectUris' attribute is a valid URI.  In particular, the system should not confirm that the domain component of the URI is a top-level domain and the system should not confirm that the hostname portion is a valid system that is reachable over the network.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] allow_access_control: (Updatable) If true, any managed App that is based on this template is checked for access control that is, access to this app is subject to successful authorization at SSO service, viz. app grants to start with.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] allow_offline: (Updatable) If true, indicates that the Refresh Token is allowed when this App acts as an OAuth Resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_grants: (Updatable) List of grant-types that this App is allowed to use when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_operations: (Updatable) OPTIONAL. Required only when this App acts as an OAuthClient. Supported values are 'introspect' and 'onBehalfOfUser'. The value 'introspect' allows the client to look inside the access-token. The value 'onBehalfOfUser' overrides how the client's privileges are combined with the privileges of the Subject User. Ordinarily, authorization calculates the set of effective privileges as the intersection of the client's privileges and the user's privileges. The value 'onBehalfOf' indicates that authorization should ignore the privileges of the client and use only the user's privileges to calculate the effective privileges.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAllowedScopeArgs']]]] allowed_scopes: (Updatable) A list of scopes (exposed by this App or by other Apps) that this App is allowed to access when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCompositeKey: [fqs]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAllowedTagArgs']]]] allowed_tags: (Updatable) A list of tags, acting as an OAuthClient, this App is allowed to access.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] app_icon: (Updatable) Application icon.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsAppAppSignonPolicyArgs']] app_signon_policy: (Updatable) App Sign-on Policy.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] app_thumbnail: (Updatable) Application thumbnail.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAppsNetworkPerimeterArgs']]]] apps_network_perimeters: (Updatable) Network Perimeter
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[pulumi.InputType['DomainsAppAsOpcServiceArgs']] as_opc_service: (Updatable) OPCService facet of the application.
               
               **Deprecated Since: 17.3.4**
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAttrRenderingMetadataArgs']]]] attr_rendering_metadatas: (Updatable) Label for the attribute to be shown in the UI.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] audience: (Updatable) The base URI for all of the scopes defined in this App. The value of 'audience' is combined with the 'value' of each scope to form an 'fqs' or fully qualified scope.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[pulumi.InputType['DomainsAppBasedOnTemplateArgs']] based_on_template: (Updatable) Application template on which the application is based.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[bool] bypass_consent: (Updatable) If true, indicates that consent should be skipped for all scopes
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppCertificateArgs']]]] certificates: (Updatable) Each value of this attribute represent a certificate that this App uses when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [certAlias]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] client_ip_checking: (Updatable) Network Perimeters checking mode
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] client_type: (Updatable) Specifies the type of access that this App has when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] contact_email_address: (Updatable) Contact Email Address
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegated_service_names: (Updatable) Service Names allow to use Oracle Cloud Infrastructure signature for client authentication instead of client credentials
               
               **Added In:** 2207040824
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) The description of the AppRole.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] disable_kmsi_token_authentication: (Updatable) Indicates whether the application is allowed to be access using kmsi token.
               
               **Added In:** 2111190457
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: always
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] display_name: (Updatable) Display name of the flatfile bundle configuration property. This attribute maps to \\"displayName\\" attribute in \\"ConfigurationProperty\\" in ICF.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] error_page_url: (Updatable) This attribute specifies the URL of the page to which an application will redirect an end-user in case of error.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] home_page_url: (Updatable) Home Page URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] icon: (Updatable) URL of application icon.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
               * uniqueness: none
        :param pulumi.Input[str] id_token_enc_algo: (Updatable) Encryption Alogrithm to use for encrypting ID token.
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppIdentityProviderArgs']]]] identity_providers: (Updatable) A list of IdentityProvider assigned to app. A user trying to access this app will be automatically redirected to configured IdP during the authentication phase, before being able to access App.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
        :param pulumi.Input[pulumi.InputType['DomainsAppIdpPolicyArgs']] idp_policy: (Updatable) IDP Policy.
               
               **Added In:** 18.1.2
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[bool] is_alias_app: If true, this App is an AliasApp and it cannot be granted to an end-user directly.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: always
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_enterprise_app: (Updatable) If true, this app acts as Enterprise app with Authentication and URL Authz policy.
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_form_fill: (Updatable) If true, this application acts as FormFill Application
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_kerberos_realm: (Updatable) If true, indicates that this App supports Kerberos Authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_login_target: (Updatable) If true, this App allows runtime services to log end users into this App automatically.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_mobile_target: (Updatable) If true, indicates that the App should be visible in each end-user's mobile application.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_multicloud_service_app: (Updatable) If true, indicates the app is used for multicloud service integration.
               
               **Added In:** 2301202328
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_oauth_client: (Updatable) If true, this application acts as an OAuth Client
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_oauth_resource: (Updatable) If true, indicates that this application acts as an OAuth Resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_obligation_capable: (Updatable) This flag indicates if the App is capable of validating obligations with the token for allowing access to the App.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_radius_app: (Updatable) If true, this application acts as an Radius App
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_saml_service_provider: (Updatable) If true, then this App acts as a SAML Service Provider.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_unmanaged_app: If true, indicates that this application accepts an Oracle Cloud Identity Service User as a login-identity (does not require an account) and relies for authorization on the User's memberships in AppRoles.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_web_tier_policy: (Updatable) If true, the webtier policy is active
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] landing_page_url: (Updatable) The URL of the landing page for this App, which is the first page that an end user should see if runtime services log that end user in to this App automatically.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] linking_callback_url: (Updatable) This attribute specifies the callback URL for the social linking operation.
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] login_mechanism: (Updatable) The protocol that runtime services will use to log end users in to this App automatically. If 'OIDC', then runtime services use the OpenID Connect protocol. If 'SAML', then runtime services use Security Assertion Markup Language protocol.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] login_page_url: (Updatable) This attribute specifies the URL of the page that the App uses when an end-user signs in to that App.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] logout_page_url: (Updatable) This attribute specifies the URL of the page that the App uses when an end-user signs out.
               
               **Added In:** 17.4.2
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] logout_uri: (Updatable) OAuth will use this URI to logout if this App wants to participate in SSO, and if this App's session gets cleared as part of global logout. Note: This attribute is used only if this App acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] name: (Updatable) The attribute represents the name of the attribute that will be used in the Security Assertion Markup Language (SAML) assertion
               
               **Deprecated Since: 18.2.2**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * idcsValuePersistedInOtherAttribute: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_logout_redirect_uris: (Updatable) Each value of this attribute is the URI of a landing page within this App. It is used only when this App, acting as an OAuthClient, initiates the logout flow and wants to be redirected back to one of its landing pages.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] privacy_policy_url: (Updatable) Privacy Policy URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] product_logo_url: (Updatable) Application Logo URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] product_name: (Updatable) Product Name
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppProtectableSecondaryAudienceArgs']]]] protectable_secondary_audiences: (Updatable) A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.
               
               **Added In:** 18.2.2
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsAppRadiusPolicyArgs']] radius_policy: (Updatable) RADIUS Policy assigned to this application.
               
               **Added In:** 2209070044
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[str]]] redirect_uris: (Updatable) OPTIONAL. Each value is a URI within this App. This attribute is required when this App acts as an OAuthClient and is involved in three-legged flows (authorization-code flows).
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] refresh_token_expiry: (Updatable) Expiry-time in seconds for a Refresh Token.  Any token that allows access to this App, once refreshed, will expire after the specified duration.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[pulumi.InputType['DomainsAppSamlServiceProviderArgs']] saml_service_provider: (Updatable) An attribute that refers to the SAML Service Provider that runtime services will use to log an end user in to this App automatically. Note that this will be used only if the loginMechanism is 'SAML'.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppScopeArgs']]]] scopes: (Updatable) Scopes defined by this App. Used when this App acts as an OAuth Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secondary_audiences: (Updatable) A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.
               
               **Deprecated Since: 18.2.6**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppServiceParamArgs']]]] service_params: (Updatable) Custom attribute that is required to compute other attribute values during app creation.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: always
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] service_type_urn: (Updatable) This Uniform Resource Name (URN) value identifies the type of Oracle Public Cloud service of which this app is an instance.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] service_type_version: (Updatable) This value specifies the version of the Oracle Public Cloud service of which this App is an instance
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] show_in_my_apps: (Updatable) If true, this app will be displayed in the MyApps page of each end-user who has access to the App.
               
               **Added In:** 18.1.2
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsAppSignonPolicyArgs']] signon_policy: (Updatable) Sign-on Policy.
               
               **Deprecated Since: 17.3.4**
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppTagArgs']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] terms_of_service_url: (Updatable) Terms of Service URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsAppTermsOfUseArgs']] terms_of_use: (Updatable) Terms Of Use.
               
               **Added In:** 18.2.6
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppTrustPolicyArgs']]]] trust_policies: (Updatable) Trust Policies.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] trust_scope: (Updatable) Indicates the scope of trust for this App when acting as an OAuthClient. A value of 'Explicit' indicates that the App is allowed to access only the scopes of OAuthResources that are explicitly specified as 'allowedScopes'. A value of 'Account' indicates that the App is allowed implicitly to access any scope of any OAuthResource within the same Oracle Cloud Account. A value of 'Tags' indicates that the App is allowed to access any scope of any OAuthResource with a matching tag within the same Oracle Cloud Account. A value of 'Default' indicates that the Tenant default trust scope configured in the Tenant Settings is used.
               
               **Added In:** 17.4.2
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs']] urnietfparamsscimschemasoracleidcsextensiondbcs_app: (Updatable) This extension provides attributes for database service facet of an App
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs']] urnietfparamsscimschemasoracleidcsextensionenterprise_app_app: (Updatable) This extension defines the Enterprise App related attributes.
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs']] urnietfparamsscimschemasoracleidcsextensionform_fill_app_app: (Updatable) This extension provides attributes for Form-Fill facet of App
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs']] urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template: (Updatable) This extension provides attributes for Form-Fill facet of AppTemplate
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs']] urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app: (Updatable) Kerberos Realm
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs']] urnietfparamsscimschemasoracleidcsextensionmanagedapp_app: (Updatable) Managed App
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs']] urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app: (Updatable) This extension defines attributes specific to Apps that represent instances of Multicloud Service App
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs']] urnietfparamsscimschemasoracleidcsextensionopc_service_app: (Updatable) This extension defines attributes specific to Apps that represent instances of an Oracle Public Cloud (OPC) service.
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs']] urnietfparamsscimschemasoracleidcsextensionradius_app_app: (Updatable) This extension defines attributes specific to Apps that represent instances of Radius App.
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs']] urnietfparamsscimschemasoracleidcsextensionrequestable_app: (Updatable) Requestable App
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs']] urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app: (Updatable) This extension defines attributes related to the Service Providers configuration.
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs']] urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app: (Updatable) WebTier Policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the App resource in Oracle Cloud Infrastructure Identity Domains service.

        Create an App

        ## Import

        Apps can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Identity/domainsApp:DomainsApp test_app "idcsEndpoint/{idcsEndpoint}/apps/{appId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            DomainsAppArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_expiry: Optional[pulumi.Input[int]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 alias_apps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAliasAppArgs']]]]] = None,
                 all_url_schemes_allowed: Optional[pulumi.Input[bool]] = None,
                 allow_access_control: Optional[pulumi.Input[bool]] = None,
                 allow_offline: Optional[pulumi.Input[bool]] = None,
                 allowed_grants: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAllowedScopeArgs']]]]] = None,
                 allowed_tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAllowedTagArgs']]]]] = None,
                 app_icon: Optional[pulumi.Input[str]] = None,
                 app_signon_policy: Optional[pulumi.Input[pulumi.InputType['DomainsAppAppSignonPolicyArgs']]] = None,
                 app_thumbnail: Optional[pulumi.Input[str]] = None,
                 apps_network_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAppsNetworkPerimeterArgs']]]]] = None,
                 as_opc_service: Optional[pulumi.Input[pulumi.InputType['DomainsAppAsOpcServiceArgs']]] = None,
                 attr_rendering_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAttrRenderingMetadataArgs']]]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 based_on_template: Optional[pulumi.Input[pulumi.InputType['DomainsAppBasedOnTemplateArgs']]] = None,
                 bypass_consent: Optional[pulumi.Input[bool]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppCertificateArgs']]]]] = None,
                 client_ip_checking: Optional[pulumi.Input[str]] = None,
                 client_type: Optional[pulumi.Input[str]] = None,
                 contact_email_address: Optional[pulumi.Input[str]] = None,
                 delegated_service_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_kmsi_token_authentication: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 error_page_url: Optional[pulumi.Input[str]] = None,
                 home_page_url: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 id_token_enc_algo: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppIdentityProviderArgs']]]]] = None,
                 idp_policy: Optional[pulumi.Input[pulumi.InputType['DomainsAppIdpPolicyArgs']]] = None,
                 is_alias_app: Optional[pulumi.Input[bool]] = None,
                 is_enterprise_app: Optional[pulumi.Input[bool]] = None,
                 is_form_fill: Optional[pulumi.Input[bool]] = None,
                 is_kerberos_realm: Optional[pulumi.Input[bool]] = None,
                 is_login_target: Optional[pulumi.Input[bool]] = None,
                 is_mobile_target: Optional[pulumi.Input[bool]] = None,
                 is_multicloud_service_app: Optional[pulumi.Input[bool]] = None,
                 is_oauth_client: Optional[pulumi.Input[bool]] = None,
                 is_oauth_resource: Optional[pulumi.Input[bool]] = None,
                 is_obligation_capable: Optional[pulumi.Input[bool]] = None,
                 is_radius_app: Optional[pulumi.Input[bool]] = None,
                 is_saml_service_provider: Optional[pulumi.Input[bool]] = None,
                 is_unmanaged_app: Optional[pulumi.Input[bool]] = None,
                 is_web_tier_policy: Optional[pulumi.Input[bool]] = None,
                 landing_page_url: Optional[pulumi.Input[str]] = None,
                 linking_callback_url: Optional[pulumi.Input[str]] = None,
                 login_mechanism: Optional[pulumi.Input[str]] = None,
                 login_page_url: Optional[pulumi.Input[str]] = None,
                 logout_page_url: Optional[pulumi.Input[str]] = None,
                 logout_uri: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 privacy_policy_url: Optional[pulumi.Input[str]] = None,
                 product_logo_url: Optional[pulumi.Input[str]] = None,
                 product_name: Optional[pulumi.Input[str]] = None,
                 protectable_secondary_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppProtectableSecondaryAudienceArgs']]]]] = None,
                 radius_policy: Optional[pulumi.Input[pulumi.InputType['DomainsAppRadiusPolicyArgs']]] = None,
                 redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_token_expiry: Optional[pulumi.Input[int]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 saml_service_provider: Optional[pulumi.Input[pulumi.InputType['DomainsAppSamlServiceProviderArgs']]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppScopeArgs']]]]] = None,
                 secondary_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_params: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppServiceParamArgs']]]]] = None,
                 service_type_urn: Optional[pulumi.Input[str]] = None,
                 service_type_version: Optional[pulumi.Input[str]] = None,
                 show_in_my_apps: Optional[pulumi.Input[bool]] = None,
                 signon_policy: Optional[pulumi.Input[pulumi.InputType['DomainsAppSignonPolicyArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppTagArgs']]]]] = None,
                 terms_of_service_url: Optional[pulumi.Input[str]] = None,
                 terms_of_use: Optional[pulumi.Input[pulumi.InputType['DomainsAppTermsOfUseArgs']]] = None,
                 trust_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppTrustPolicyArgs']]]]] = None,
                 trust_scope: Optional[pulumi.Input[str]] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensiondbcs_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionenterprise_app_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionform_fill_app_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionmanagedapp_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionopc_service_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionradius_app_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionrequestable_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsAppArgs.__new__(DomainsAppArgs)

            __props__.__dict__["access_token_expiry"] = access_token_expiry
            __props__.__dict__["active"] = active
            __props__.__dict__["alias_apps"] = alias_apps
            __props__.__dict__["all_url_schemes_allowed"] = all_url_schemes_allowed
            __props__.__dict__["allow_access_control"] = allow_access_control
            __props__.__dict__["allow_offline"] = allow_offline
            __props__.__dict__["allowed_grants"] = allowed_grants
            __props__.__dict__["allowed_operations"] = allowed_operations
            __props__.__dict__["allowed_scopes"] = allowed_scopes
            __props__.__dict__["allowed_tags"] = allowed_tags
            __props__.__dict__["app_icon"] = app_icon
            if app_signon_policy is not None and not isinstance(app_signon_policy, DomainsAppAppSignonPolicyArgs):
                app_signon_policy = app_signon_policy or {}
                def _setter(key, value):
                    app_signon_policy[key] = value
                DomainsAppAppSignonPolicyArgs._configure(_setter, **app_signon_policy)
            __props__.__dict__["app_signon_policy"] = app_signon_policy
            __props__.__dict__["app_thumbnail"] = app_thumbnail
            __props__.__dict__["apps_network_perimeters"] = apps_network_perimeters
            if as_opc_service is not None and not isinstance(as_opc_service, DomainsAppAsOpcServiceArgs):
                as_opc_service = as_opc_service or {}
                def _setter(key, value):
                    as_opc_service[key] = value
                DomainsAppAsOpcServiceArgs._configure(_setter, **as_opc_service)
            __props__.__dict__["as_opc_service"] = as_opc_service
            __props__.__dict__["attr_rendering_metadatas"] = attr_rendering_metadatas
            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["audience"] = audience
            __props__.__dict__["authorization"] = authorization
            if based_on_template is not None and not isinstance(based_on_template, DomainsAppBasedOnTemplateArgs):
                based_on_template = based_on_template or {}
                def _setter(key, value):
                    based_on_template[key] = value
                DomainsAppBasedOnTemplateArgs._configure(_setter, **based_on_template)
            if based_on_template is None and not opts.urn:
                raise TypeError("Missing required property 'based_on_template'")
            __props__.__dict__["based_on_template"] = based_on_template
            __props__.__dict__["bypass_consent"] = bypass_consent
            __props__.__dict__["certificates"] = certificates
            __props__.__dict__["client_ip_checking"] = client_ip_checking
            __props__.__dict__["client_type"] = client_type
            __props__.__dict__["contact_email_address"] = contact_email_address
            __props__.__dict__["delegated_service_names"] = delegated_service_names
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_kmsi_token_authentication"] = disable_kmsi_token_authentication
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["error_page_url"] = error_page_url
            __props__.__dict__["home_page_url"] = home_page_url
            __props__.__dict__["icon"] = icon
            __props__.__dict__["id_token_enc_algo"] = id_token_enc_algo
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            __props__.__dict__["identity_providers"] = identity_providers
            if idp_policy is not None and not isinstance(idp_policy, DomainsAppIdpPolicyArgs):
                idp_policy = idp_policy or {}
                def _setter(key, value):
                    idp_policy[key] = value
                DomainsAppIdpPolicyArgs._configure(_setter, **idp_policy)
            __props__.__dict__["idp_policy"] = idp_policy
            __props__.__dict__["is_alias_app"] = is_alias_app
            __props__.__dict__["is_enterprise_app"] = is_enterprise_app
            __props__.__dict__["is_form_fill"] = is_form_fill
            __props__.__dict__["is_kerberos_realm"] = is_kerberos_realm
            __props__.__dict__["is_login_target"] = is_login_target
            __props__.__dict__["is_mobile_target"] = is_mobile_target
            __props__.__dict__["is_multicloud_service_app"] = is_multicloud_service_app
            __props__.__dict__["is_oauth_client"] = is_oauth_client
            __props__.__dict__["is_oauth_resource"] = is_oauth_resource
            __props__.__dict__["is_obligation_capable"] = is_obligation_capable
            __props__.__dict__["is_radius_app"] = is_radius_app
            __props__.__dict__["is_saml_service_provider"] = is_saml_service_provider
            __props__.__dict__["is_unmanaged_app"] = is_unmanaged_app
            __props__.__dict__["is_web_tier_policy"] = is_web_tier_policy
            __props__.__dict__["landing_page_url"] = landing_page_url
            __props__.__dict__["linking_callback_url"] = linking_callback_url
            __props__.__dict__["login_mechanism"] = login_mechanism
            __props__.__dict__["login_page_url"] = login_page_url
            __props__.__dict__["logout_page_url"] = logout_page_url
            __props__.__dict__["logout_uri"] = logout_uri
            __props__.__dict__["name"] = name
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["post_logout_redirect_uris"] = post_logout_redirect_uris
            __props__.__dict__["privacy_policy_url"] = privacy_policy_url
            __props__.__dict__["product_logo_url"] = product_logo_url
            __props__.__dict__["product_name"] = product_name
            __props__.__dict__["protectable_secondary_audiences"] = protectable_secondary_audiences
            if radius_policy is not None and not isinstance(radius_policy, DomainsAppRadiusPolicyArgs):
                radius_policy = radius_policy or {}
                def _setter(key, value):
                    radius_policy[key] = value
                DomainsAppRadiusPolicyArgs._configure(_setter, **radius_policy)
            __props__.__dict__["radius_policy"] = radius_policy
            __props__.__dict__["redirect_uris"] = redirect_uris
            __props__.__dict__["refresh_token_expiry"] = refresh_token_expiry
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if saml_service_provider is not None and not isinstance(saml_service_provider, DomainsAppSamlServiceProviderArgs):
                saml_service_provider = saml_service_provider or {}
                def _setter(key, value):
                    saml_service_provider[key] = value
                DomainsAppSamlServiceProviderArgs._configure(_setter, **saml_service_provider)
            __props__.__dict__["saml_service_provider"] = saml_service_provider
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["secondary_audiences"] = secondary_audiences
            __props__.__dict__["service_params"] = service_params
            __props__.__dict__["service_type_urn"] = service_type_urn
            __props__.__dict__["service_type_version"] = service_type_version
            __props__.__dict__["show_in_my_apps"] = show_in_my_apps
            if signon_policy is not None and not isinstance(signon_policy, DomainsAppSignonPolicyArgs):
                signon_policy = signon_policy or {}
                def _setter(key, value):
                    signon_policy[key] = value
                DomainsAppSignonPolicyArgs._configure(_setter, **signon_policy)
            __props__.__dict__["signon_policy"] = signon_policy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["terms_of_service_url"] = terms_of_service_url
            if terms_of_use is not None and not isinstance(terms_of_use, DomainsAppTermsOfUseArgs):
                terms_of_use = terms_of_use or {}
                def _setter(key, value):
                    terms_of_use[key] = value
                DomainsAppTermsOfUseArgs._configure(_setter, **terms_of_use)
            __props__.__dict__["terms_of_use"] = terms_of_use
            __props__.__dict__["trust_policies"] = trust_policies
            __props__.__dict__["trust_scope"] = trust_scope
            if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None and not isinstance(urnietfparamsscimschemasoracleidcsextension_oci_tags, DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs):
                urnietfparamsscimschemasoracleidcsextension_oci_tags = urnietfparamsscimschemasoracleidcsextension_oci_tags or {}
                def _setter(key, value):
                    urnietfparamsscimschemasoracleidcsextension_oci_tags[key] = value
                DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs._configure(_setter, **urnietfparamsscimschemasoracleidcsextension_oci_tags)
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextension_oci_tags"] = urnietfparamsscimschemasoracleidcsextension_oci_tags
            if urnietfparamsscimschemasoracleidcsextensiondbcs_app is not None and not isinstance(urnietfparamsscimschemasoracleidcsextensiondbcs_app, DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs):
                urnietfparamsscimschemasoracleidcsextensiondbcs_app = urnietfparamsscimschemasoracleidcsextensiondbcs_app or {}
                def _setter(key, value):
                    urnietfparamsscimschemasoracleidcsextensiondbcs_app[key] = value
                DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs._configure(_setter, **urnietfparamsscimschemasoracleidcsextensiondbcs_app)
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensiondbcs_app"] = urnietfparamsscimschemasoracleidcsextensiondbcs_app
            if urnietfparamsscimschemasoracleidcsextensionenterprise_app_app is not None and not isinstance(urnietfparamsscimschemasoracleidcsextensionenterprise_app_app, DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs):
                urnietfparamsscimschemasoracleidcsextensionenterprise_app_app = urnietfparamsscimschemasoracleidcsextensionenterprise_app_app or {}
                def _setter(key, value):
                    urnietfparamsscimschemasoracleidcsextensionenterprise_app_app[key] = value
                DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs._configure(_setter, **urnietfparamsscimschemasoracleidcsextensionenterprise_app_app)
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionenterprise_app_app"] = urnietfparamsscimschemasoracleidcsextensionenterprise_app_app
            if urnietfparamsscimschemasoracleidcsextensionform_fill_app_app is not None and not isinstance(urnietfparamsscimschemasoracleidcsextensionform_fill_app_app, DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs):
                urnietfparamsscimschemasoracleidcsextensionform_fill_app_app = urnietfparamsscimschemasoracleidcsextensionform_fill_app_app or {}
                def _setter(key, value):
                    urnietfparamsscimschemasoracleidcsextensionform_fill_app_app[key] = value
                DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs._configure(_setter, **urnietfparamsscimschemasoracleidcsextensionform_fill_app_app)
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionform_fill_app_app"] = urnietfparamsscimschemasoracleidcsextensionform_fill_app_app
            if urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template is not None and not isinstance(urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template, DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs):
                urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template = urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template or {}
                def _setter(key, value):
                    urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template[key] = value
                DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs._configure(_setter, **urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template)
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template"] = urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template
            if urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app is not None and not isinstance(urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app, DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs):
                urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app = urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app or {}
                def _setter(key, value):
                    urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app[key] = value
                DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs._configure(_setter, **urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app)
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app"] = urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app
            if urnietfparamsscimschemasoracleidcsextensionmanagedapp_app is not None and not isinstance(urnietfparamsscimschemasoracleidcsextensionmanagedapp_app, DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs):
                urnietfparamsscimschemasoracleidcsextensionmanagedapp_app = urnietfparamsscimschemasoracleidcsextensionmanagedapp_app or {}
                def _setter(key, value):
                    urnietfparamsscimschemasoracleidcsextensionmanagedapp_app[key] = value
                DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs._configure(_setter, **urnietfparamsscimschemasoracleidcsextensionmanagedapp_app)
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionmanagedapp_app"] = urnietfparamsscimschemasoracleidcsextensionmanagedapp_app
            if urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app is not None and not isinstance(urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app, DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs):
                urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app = urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app or {}
                def _setter(key, value):
                    urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app[key] = value
                DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs._configure(_setter, **urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app)
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app"] = urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app
            if urnietfparamsscimschemasoracleidcsextensionopc_service_app is not None and not isinstance(urnietfparamsscimschemasoracleidcsextensionopc_service_app, DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs):
                urnietfparamsscimschemasoracleidcsextensionopc_service_app = urnietfparamsscimschemasoracleidcsextensionopc_service_app or {}
                def _setter(key, value):
                    urnietfparamsscimschemasoracleidcsextensionopc_service_app[key] = value
                DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs._configure(_setter, **urnietfparamsscimschemasoracleidcsextensionopc_service_app)
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionopc_service_app"] = urnietfparamsscimschemasoracleidcsextensionopc_service_app
            if urnietfparamsscimschemasoracleidcsextensionradius_app_app is not None and not isinstance(urnietfparamsscimschemasoracleidcsextensionradius_app_app, DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs):
                urnietfparamsscimschemasoracleidcsextensionradius_app_app = urnietfparamsscimschemasoracleidcsextensionradius_app_app or {}
                def _setter(key, value):
                    urnietfparamsscimschemasoracleidcsextensionradius_app_app[key] = value
                DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs._configure(_setter, **urnietfparamsscimschemasoracleidcsextensionradius_app_app)
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionradius_app_app"] = urnietfparamsscimschemasoracleidcsextensionradius_app_app
            if urnietfparamsscimschemasoracleidcsextensionrequestable_app is not None and not isinstance(urnietfparamsscimschemasoracleidcsextensionrequestable_app, DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs):
                urnietfparamsscimschemasoracleidcsextensionrequestable_app = urnietfparamsscimschemasoracleidcsextensionrequestable_app or {}
                def _setter(key, value):
                    urnietfparamsscimschemasoracleidcsextensionrequestable_app[key] = value
                DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs._configure(_setter, **urnietfparamsscimschemasoracleidcsextensionrequestable_app)
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionrequestable_app"] = urnietfparamsscimschemasoracleidcsextensionrequestable_app
            if urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app is not None and not isinstance(urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app, DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs):
                urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app = urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app or {}
                def _setter(key, value):
                    urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app[key] = value
                DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs._configure(_setter, **urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app)
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app"] = urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app
            if urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app is not None and not isinstance(urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app, DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs):
                urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app = urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app or {}
                def _setter(key, value):
                    urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app[key] = value
                DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs._configure(_setter, **urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app)
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app"] = urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app
            __props__.__dict__["accounts"] = None
            __props__.__dict__["admin_roles"] = None
            __props__.__dict__["callback_service_url"] = None
            __props__.__dict__["client_secret"] = None
            __props__.__dict__["cloud_control_properties"] = None
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["editable_attributes"] = None
            __props__.__dict__["granted_app_roles"] = None
            __props__.__dict__["grants"] = None
            __props__.__dict__["hashed_client_secret"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["infrastructure"] = None
            __props__.__dict__["is_database_service"] = None
            __props__.__dict__["is_managed_app"] = None
            __props__.__dict__["is_opc_service"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["meter_as_opc_service"] = None
            __props__.__dict__["migrated"] = None
            __props__.__dict__["ready_to_upgrade"] = None
            __props__.__dict__["tenancy_ocid"] = None
            __props__.__dict__["user_roles"] = None
        super(DomainsApp, __self__).__init__(
            'oci:Identity/domainsApp:DomainsApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token_expiry: Optional[pulumi.Input[int]] = None,
            accounts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAccountArgs']]]]] = None,
            active: Optional[pulumi.Input[bool]] = None,
            admin_roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAdminRoleArgs']]]]] = None,
            alias_apps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAliasAppArgs']]]]] = None,
            all_url_schemes_allowed: Optional[pulumi.Input[bool]] = None,
            allow_access_control: Optional[pulumi.Input[bool]] = None,
            allow_offline: Optional[pulumi.Input[bool]] = None,
            allowed_grants: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAllowedScopeArgs']]]]] = None,
            allowed_tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAllowedTagArgs']]]]] = None,
            app_icon: Optional[pulumi.Input[str]] = None,
            app_signon_policy: Optional[pulumi.Input[pulumi.InputType['DomainsAppAppSignonPolicyArgs']]] = None,
            app_thumbnail: Optional[pulumi.Input[str]] = None,
            apps_network_perimeters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAppsNetworkPerimeterArgs']]]]] = None,
            as_opc_service: Optional[pulumi.Input[pulumi.InputType['DomainsAppAsOpcServiceArgs']]] = None,
            attr_rendering_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAttrRenderingMetadataArgs']]]]] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            attributes: Optional[pulumi.Input[str]] = None,
            audience: Optional[pulumi.Input[str]] = None,
            authorization: Optional[pulumi.Input[str]] = None,
            based_on_template: Optional[pulumi.Input[pulumi.InputType['DomainsAppBasedOnTemplateArgs']]] = None,
            bypass_consent: Optional[pulumi.Input[bool]] = None,
            callback_service_url: Optional[pulumi.Input[str]] = None,
            certificates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppCertificateArgs']]]]] = None,
            client_ip_checking: Optional[pulumi.Input[str]] = None,
            client_secret: Optional[pulumi.Input[str]] = None,
            client_type: Optional[pulumi.Input[str]] = None,
            cloud_control_properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppCloudControlPropertyArgs']]]]] = None,
            compartment_ocid: Optional[pulumi.Input[str]] = None,
            contact_email_address: Optional[pulumi.Input[str]] = None,
            delegated_service_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            delete_in_progress: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disable_kmsi_token_authentication: Optional[pulumi.Input[bool]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            domain_ocid: Optional[pulumi.Input[str]] = None,
            editable_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppEditableAttributeArgs']]]]] = None,
            error_page_url: Optional[pulumi.Input[str]] = None,
            granted_app_roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppGrantedAppRoleArgs']]]]] = None,
            grants: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppGrantArgs']]]]] = None,
            hashed_client_secret: Optional[pulumi.Input[str]] = None,
            home_page_url: Optional[pulumi.Input[str]] = None,
            icon: Optional[pulumi.Input[str]] = None,
            id_token_enc_algo: Optional[pulumi.Input[str]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppIdcsCreatedByArgs']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppIdcsLastModifiedByArgs']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppIdentityProviderArgs']]]]] = None,
            idp_policy: Optional[pulumi.Input[pulumi.InputType['DomainsAppIdpPolicyArgs']]] = None,
            infrastructure: Optional[pulumi.Input[bool]] = None,
            is_alias_app: Optional[pulumi.Input[bool]] = None,
            is_database_service: Optional[pulumi.Input[bool]] = None,
            is_enterprise_app: Optional[pulumi.Input[bool]] = None,
            is_form_fill: Optional[pulumi.Input[bool]] = None,
            is_kerberos_realm: Optional[pulumi.Input[bool]] = None,
            is_login_target: Optional[pulumi.Input[bool]] = None,
            is_managed_app: Optional[pulumi.Input[bool]] = None,
            is_mobile_target: Optional[pulumi.Input[bool]] = None,
            is_multicloud_service_app: Optional[pulumi.Input[bool]] = None,
            is_oauth_client: Optional[pulumi.Input[bool]] = None,
            is_oauth_resource: Optional[pulumi.Input[bool]] = None,
            is_obligation_capable: Optional[pulumi.Input[bool]] = None,
            is_opc_service: Optional[pulumi.Input[bool]] = None,
            is_radius_app: Optional[pulumi.Input[bool]] = None,
            is_saml_service_provider: Optional[pulumi.Input[bool]] = None,
            is_unmanaged_app: Optional[pulumi.Input[bool]] = None,
            is_web_tier_policy: Optional[pulumi.Input[bool]] = None,
            landing_page_url: Optional[pulumi.Input[str]] = None,
            linking_callback_url: Optional[pulumi.Input[str]] = None,
            login_mechanism: Optional[pulumi.Input[str]] = None,
            login_page_url: Optional[pulumi.Input[str]] = None,
            logout_page_url: Optional[pulumi.Input[str]] = None,
            logout_uri: Optional[pulumi.Input[str]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppMetaArgs']]]]] = None,
            meter_as_opc_service: Optional[pulumi.Input[bool]] = None,
            migrated: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            ocid: Optional[pulumi.Input[str]] = None,
            post_logout_redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            privacy_policy_url: Optional[pulumi.Input[str]] = None,
            product_logo_url: Optional[pulumi.Input[str]] = None,
            product_name: Optional[pulumi.Input[str]] = None,
            protectable_secondary_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppProtectableSecondaryAudienceArgs']]]]] = None,
            radius_policy: Optional[pulumi.Input[pulumi.InputType['DomainsAppRadiusPolicyArgs']]] = None,
            ready_to_upgrade: Optional[pulumi.Input[bool]] = None,
            redirect_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            refresh_token_expiry: Optional[pulumi.Input[int]] = None,
            resource_type_schema_version: Optional[pulumi.Input[str]] = None,
            saml_service_provider: Optional[pulumi.Input[pulumi.InputType['DomainsAppSamlServiceProviderArgs']]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppScopeArgs']]]]] = None,
            secondary_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            service_params: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppServiceParamArgs']]]]] = None,
            service_type_urn: Optional[pulumi.Input[str]] = None,
            service_type_version: Optional[pulumi.Input[str]] = None,
            show_in_my_apps: Optional[pulumi.Input[bool]] = None,
            signon_policy: Optional[pulumi.Input[pulumi.InputType['DomainsAppSignonPolicyArgs']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppTagArgs']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[str]] = None,
            terms_of_service_url: Optional[pulumi.Input[str]] = None,
            terms_of_use: Optional[pulumi.Input[pulumi.InputType['DomainsAppTermsOfUseArgs']]] = None,
            trust_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppTrustPolicyArgs']]]]] = None,
            trust_scope: Optional[pulumi.Input[str]] = None,
            urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensiondbcs_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionenterprise_app_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionform_fill_app_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionmanagedapp_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionopc_service_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionradius_app_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionrequestable_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app: Optional[pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs']]] = None,
            user_roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppUserRoleArgs']]]]] = None) -> 'DomainsApp':
        """
        Get an existing DomainsApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] access_token_expiry: (Updatable) Access token expiry
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: dateTime
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAccountArgs']]]] accounts: (Updatable) Accounts of App
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] active: (Updatable) If true, this App is able to participate in runtime services, such as automatic-login, OAuth, and SAML. If false, all runtime services are disabled for this App, and only administrative operations can be performed.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAdminRoleArgs']]]] admin_roles: (Updatable) A list of AppRoles defined by this UnmanagedApp. Membership in each of these AppRoles confers administrative privilege within this App.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAliasAppArgs']]]] alias_apps: (Updatable) Each value of this internal attribute refers to an Oracle Public Cloud infrastructure App on which this App depends.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] all_url_schemes_allowed: (Updatable) If true, indicates that the system should allow all URL-schemes within each value of the 'redirectUris' attribute.  Also indicates that the system should not attempt to confirm that each value of the 'redirectUris' attribute is a valid URI.  In particular, the system should not confirm that the domain component of the URI is a top-level domain and the system should not confirm that the hostname portion is a valid system that is reachable over the network.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] allow_access_control: (Updatable) If true, any managed App that is based on this template is checked for access control that is, access to this app is subject to successful authorization at SSO service, viz. app grants to start with.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] allow_offline: (Updatable) If true, indicates that the Refresh Token is allowed when this App acts as an OAuth Resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_grants: (Updatable) List of grant-types that this App is allowed to use when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_operations: (Updatable) OPTIONAL. Required only when this App acts as an OAuthClient. Supported values are 'introspect' and 'onBehalfOfUser'. The value 'introspect' allows the client to look inside the access-token. The value 'onBehalfOfUser' overrides how the client's privileges are combined with the privileges of the Subject User. Ordinarily, authorization calculates the set of effective privileges as the intersection of the client's privileges and the user's privileges. The value 'onBehalfOf' indicates that authorization should ignore the privileges of the client and use only the user's privileges to calculate the effective privileges.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAllowedScopeArgs']]]] allowed_scopes: (Updatable) A list of scopes (exposed by this App or by other Apps) that this App is allowed to access when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCompositeKey: [fqs]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAllowedTagArgs']]]] allowed_tags: (Updatable) A list of tags, acting as an OAuthClient, this App is allowed to access.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] app_icon: (Updatable) Application icon.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsAppAppSignonPolicyArgs']] app_signon_policy: (Updatable) App Sign-on Policy.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] app_thumbnail: (Updatable) Application thumbnail.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAppsNetworkPerimeterArgs']]]] apps_network_perimeters: (Updatable) Network Perimeter
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[pulumi.InputType['DomainsAppAsOpcServiceArgs']] as_opc_service: (Updatable) OPCService facet of the application.
               
               **Deprecated Since: 17.3.4**
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppAttrRenderingMetadataArgs']]]] attr_rendering_metadatas: (Updatable) Label for the attribute to be shown in the UI.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] audience: (Updatable) The base URI for all of the scopes defined in this App. The value of 'audience' is combined with the 'value' of each scope to form an 'fqs' or fully qualified scope.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[pulumi.InputType['DomainsAppBasedOnTemplateArgs']] based_on_template: (Updatable) Application template on which the application is based.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[bool] bypass_consent: (Updatable) If true, indicates that consent should be skipped for all scopes
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] callback_service_url: (Updatable) Callback Service URL
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppCertificateArgs']]]] certificates: (Updatable) Each value of this attribute represent a certificate that this App uses when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [certAlias]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] client_ip_checking: (Updatable) Network Perimeters checking mode
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] client_secret: (Updatable) This value is the credential of this App, which this App supplies as a password when this App authenticates to the Oracle Public Cloud infrastructure. This value is also the client secret of this App when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * idcsSensitive: none
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] client_type: (Updatable) Specifies the type of access that this App has when it acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppCloudControlPropertyArgs']]]] cloud_control_properties: (Updatable) A collection of arbitrary properties that scope the privileges of a cloud-control App.
               
               **Added In:** 18.4.2
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] contact_email_address: (Updatable) Contact Email Address
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delegated_service_names: (Updatable) Service Names allow to use Oracle Cloud Infrastructure signature for client authentication instead of client credentials
               
               **Added In:** 2207040824
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) The description of the AppRole.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] disable_kmsi_token_authentication: (Updatable) Indicates whether the application is allowed to be access using kmsi token.
               
               **Added In:** 2111190457
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: always
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] display_name: (Updatable) Display name of the flatfile bundle configuration property. This attribute maps to \\"displayName\\" attribute in \\"ConfigurationProperty\\" in ICF.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppEditableAttributeArgs']]]] editable_attributes: (Updatable) App attributes editable by subject
               
               **Added In:** 18.2.6
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] error_page_url: (Updatable) This attribute specifies the URL of the page to which an application will redirect an end-user in case of error.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppGrantedAppRoleArgs']]]] granted_app_roles: (Updatable) A list of AppRoles that are granted to this App (and that are defined by other Apps). Within the Oracle Public Cloud infrastructure, this allows AppID-based association. Such an association allows this App to act as a consumer and thus to access resources of another App that acts as a producer.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppGrantArgs']]]] grants: (Updatable) Grants assigned to the app
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] hashed_client_secret: (Updatable) Hashed Client Secret. This hash-value is used to verify the 'clientSecret' credential of this App
               
               **Added In:** 2106240046
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * idcsSensitive: hash_sc
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] home_page_url: (Updatable) Home Page URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] icon: (Updatable) URL of application icon.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
               * uniqueness: none
        :param pulumi.Input[str] id_token_enc_algo: (Updatable) Encryption Alogrithm to use for encrypting ID token.
               
               **Added In:** 2010242156
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppIdcsCreatedByArgs']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppIdcsLastModifiedByArgs']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppIdentityProviderArgs']]]] identity_providers: (Updatable) A list of IdentityProvider assigned to app. A user trying to access this app will be automatically redirected to configured IdP during the authentication phase, before being able to access App.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
        :param pulumi.Input[pulumi.InputType['DomainsAppIdpPolicyArgs']] idp_policy: (Updatable) IDP Policy.
               
               **Added In:** 18.1.2
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[bool] infrastructure: (Updatable) If true, this App is an internal infrastructure App.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_alias_app: If true, this App is an AliasApp and it cannot be granted to an end-user directly.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: always
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_database_service: (Updatable) If true, this application acts as database service Application
               
               **Added In:** 18.2.2
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * type: boolean
        :param pulumi.Input[bool] is_enterprise_app: (Updatable) If true, this app acts as Enterprise app with Authentication and URL Authz policy.
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_form_fill: (Updatable) If true, this application acts as FormFill Application
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_kerberos_realm: (Updatable) If true, indicates that this App supports Kerberos Authentication
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_login_target: (Updatable) If true, this App allows runtime services to log end users into this App automatically.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_managed_app: (Updatable) If true, indicates that access to this App requires an account. That is, in order to log in to the App, a User must use an application-specific identity that is maintained in the remote identity-repository of that App.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_mobile_target: (Updatable) If true, indicates that the App should be visible in each end-user's mobile application.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_multicloud_service_app: (Updatable) If true, indicates the app is used for multicloud service integration.
               
               **Added In:** 2301202328
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_oauth_client: (Updatable) If true, this application acts as an OAuth Client
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_oauth_resource: (Updatable) If true, indicates that this application acts as an OAuth Resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_obligation_capable: (Updatable) This flag indicates if the App is capable of validating obligations with the token for allowing access to the App.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_opc_service: (Updatable) If true, this application is an Oracle Public Cloud service-instance.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_radius_app: (Updatable) If true, this application acts as an Radius App
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_saml_service_provider: (Updatable) If true, then this App acts as a SAML Service Provider.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_unmanaged_app: If true, indicates that this application accepts an Oracle Cloud Identity Service User as a login-identity (does not require an account) and relies for authorization on the User's memberships in AppRoles.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] is_web_tier_policy: (Updatable) If true, the webtier policy is active
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] landing_page_url: (Updatable) The URL of the landing page for this App, which is the first page that an end user should see if runtime services log that end user in to this App automatically.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] linking_callback_url: (Updatable) This attribute specifies the callback URL for the social linking operation.
               
               **Added In:** 18.2.4
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] login_mechanism: (Updatable) The protocol that runtime services will use to log end users in to this App automatically. If 'OIDC', then runtime services use the OpenID Connect protocol. If 'SAML', then runtime services use Security Assertion Markup Language protocol.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] login_page_url: (Updatable) This attribute specifies the URL of the page that the App uses when an end-user signs in to that App.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] logout_page_url: (Updatable) This attribute specifies the URL of the page that the App uses when an end-user signs out.
               
               **Added In:** 17.4.2
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] logout_uri: (Updatable) OAuth will use this URI to logout if this App wants to participate in SSO, and if this App's session gets cleared as part of global logout. Note: This attribute is used only if this App acts as an OAuthClient.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppMetaArgs']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[bool] meter_as_opc_service: (Updatable) Indicates whether the application is billed as an OPCService. If true, customer is not billed for runtime operations of the app.
               
               **Added In:** 18.4.2
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: always
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] migrated: (Updatable) If true, this App was migrated from an earlier version of Oracle Public Cloud infrastructure (and may therefore require special handling from runtime services such as OAuth or SAML). If false, this App requires no special handling from runtime services.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] name: (Updatable) The attribute represents the name of the attribute that will be used in the Security Assertion Markup Language (SAML) assertion
               
               **Deprecated Since: 18.2.2**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * idcsValuePersistedInOtherAttribute: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[Sequence[pulumi.Input[str]]] post_logout_redirect_uris: (Updatable) Each value of this attribute is the URI of a landing page within this App. It is used only when this App, acting as an OAuthClient, initiates the logout flow and wants to be redirected back to one of its landing pages.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] privacy_policy_url: (Updatable) Privacy Policy URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] product_logo_url: (Updatable) Application Logo URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] product_name: (Updatable) Product Name
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppProtectableSecondaryAudienceArgs']]]] protectable_secondary_audiences: (Updatable) A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.
               
               **Added In:** 18.2.2
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsAppRadiusPolicyArgs']] radius_policy: (Updatable) RADIUS Policy assigned to this application.
               
               **Added In:** 2209070044
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[bool] ready_to_upgrade: (Updatable) If true, this App requires an upgrade and mandates attention from application administrator. The flag is used by UI to indicate this app is ready to upgrade.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] redirect_uris: (Updatable) OPTIONAL. Each value is a URI within this App. This attribute is required when this App acts as an OAuthClient and is involved in three-legged flows (authorization-code flows).
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[int] refresh_token_expiry: (Updatable) Expiry-time in seconds for a Refresh Token.  Any token that allows access to this App, once refreshed, will expire after the specified duration.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: integer
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[pulumi.InputType['DomainsAppSamlServiceProviderArgs']] saml_service_provider: (Updatable) An attribute that refers to the SAML Service Provider that runtime services will use to log an end user in to this App automatically. Note that this will be used only if the loginMechanism is 'SAML'.
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppScopeArgs']]]] scopes: (Updatable) Scopes defined by this App. Used when this App acts as an OAuth Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secondary_audiences: (Updatable) A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.
               
               **Deprecated Since: 18.2.6**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppServiceParamArgs']]]] service_params: (Updatable) Custom attribute that is required to compute other attribute values during app creation.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [name]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: always
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] service_type_urn: (Updatable) This Uniform Resource Name (URN) value identifies the type of Oracle Public Cloud service of which this app is an instance.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] service_type_version: (Updatable) This value specifies the version of the Oracle Public Cloud service of which this App is an instance
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] show_in_my_apps: (Updatable) If true, this app will be displayed in the MyApps page of each end-user who has access to the App.
               
               **Added In:** 18.1.2
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsAppSignonPolicyArgs']] signon_policy: (Updatable) Sign-on Policy.
               
               **Deprecated Since: 17.3.4**
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppTagArgs']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] terms_of_service_url: (Updatable) Terms of Service URL
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsAppTermsOfUseArgs']] terms_of_use: (Updatable) Terms Of Use.
               
               **Added In:** 18.2.6
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppTrustPolicyArgs']]]] trust_policies: (Updatable) Trust Policies.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] trust_scope: (Updatable) Indicates the scope of trust for this App when acting as an OAuthClient. A value of 'Explicit' indicates that the App is allowed to access only the scopes of OAuthResources that are explicitly specified as 'allowedScopes'. A value of 'Account' indicates that the App is allowed implicitly to access any scope of any OAuthResource within the same Oracle Cloud Account. A value of 'Tags' indicates that the App is allowed to access any scope of any OAuthResource with a matching tag within the same Oracle Cloud Account. A value of 'Default' indicates that the Tenant default trust scope configured in the Tenant Settings is used.
               
               **Added In:** 17.4.2
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsAppArgs']] urnietfparamsscimschemasoracleidcsextensiondbcs_app: (Updatable) This extension provides attributes for database service facet of an App
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppAppArgs']] urnietfparamsscimschemasoracleidcsextensionenterprise_app_app: (Updatable) This extension defines the Enterprise App related attributes.
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppAppArgs']] urnietfparamsscimschemasoracleidcsextensionform_fill_app_app: (Updatable) This extension provides attributes for Form-Fill facet of App
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplateArgs']] urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template: (Updatable) This extension provides attributes for Form-Fill facet of AppTemplate
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmAppArgs']] urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app: (Updatable) Kerberos Realm
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappAppArgs']] urnietfparamsscimschemasoracleidcsextensionmanagedapp_app: (Updatable) Managed App
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppAppArgs']] urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app: (Updatable) This extension defines attributes specific to Apps that represent instances of Multicloud Service App
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceAppArgs']] urnietfparamsscimschemasoracleidcsextensionopc_service_app: (Updatable) This extension defines attributes specific to Apps that represent instances of an Oracle Public Cloud (OPC) service.
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppAppArgs']] urnietfparamsscimschemasoracleidcsextensionradius_app_app: (Updatable) This extension defines attributes specific to Apps that represent instances of Radius App.
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableAppArgs']] urnietfparamsscimschemasoracleidcsextensionrequestable_app: (Updatable) Requestable App
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderAppArgs']] urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app: (Updatable) This extension defines attributes related to the Service Providers configuration.
        :param pulumi.Input[pulumi.InputType['DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyAppArgs']] urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app: (Updatable) WebTier Policy
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsAppUserRoleArgs']]]] user_roles: (Updatable) A list of AppRoles defined by this UnmanagedApp. Membership in each of these AppRoles confers end-user privilege within this App.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsAppState.__new__(_DomainsAppState)

        __props__.__dict__["access_token_expiry"] = access_token_expiry
        __props__.__dict__["accounts"] = accounts
        __props__.__dict__["active"] = active
        __props__.__dict__["admin_roles"] = admin_roles
        __props__.__dict__["alias_apps"] = alias_apps
        __props__.__dict__["all_url_schemes_allowed"] = all_url_schemes_allowed
        __props__.__dict__["allow_access_control"] = allow_access_control
        __props__.__dict__["allow_offline"] = allow_offline
        __props__.__dict__["allowed_grants"] = allowed_grants
        __props__.__dict__["allowed_operations"] = allowed_operations
        __props__.__dict__["allowed_scopes"] = allowed_scopes
        __props__.__dict__["allowed_tags"] = allowed_tags
        __props__.__dict__["app_icon"] = app_icon
        __props__.__dict__["app_signon_policy"] = app_signon_policy
        __props__.__dict__["app_thumbnail"] = app_thumbnail
        __props__.__dict__["apps_network_perimeters"] = apps_network_perimeters
        __props__.__dict__["as_opc_service"] = as_opc_service
        __props__.__dict__["attr_rendering_metadatas"] = attr_rendering_metadatas
        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["audience"] = audience
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["based_on_template"] = based_on_template
        __props__.__dict__["bypass_consent"] = bypass_consent
        __props__.__dict__["callback_service_url"] = callback_service_url
        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["client_ip_checking"] = client_ip_checking
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["client_type"] = client_type
        __props__.__dict__["cloud_control_properties"] = cloud_control_properties
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["contact_email_address"] = contact_email_address
        __props__.__dict__["delegated_service_names"] = delegated_service_names
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_kmsi_token_authentication"] = disable_kmsi_token_authentication
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["editable_attributes"] = editable_attributes
        __props__.__dict__["error_page_url"] = error_page_url
        __props__.__dict__["granted_app_roles"] = granted_app_roles
        __props__.__dict__["grants"] = grants
        __props__.__dict__["hashed_client_secret"] = hashed_client_secret
        __props__.__dict__["home_page_url"] = home_page_url
        __props__.__dict__["icon"] = icon
        __props__.__dict__["id_token_enc_algo"] = id_token_enc_algo
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["identity_providers"] = identity_providers
        __props__.__dict__["idp_policy"] = idp_policy
        __props__.__dict__["infrastructure"] = infrastructure
        __props__.__dict__["is_alias_app"] = is_alias_app
        __props__.__dict__["is_database_service"] = is_database_service
        __props__.__dict__["is_enterprise_app"] = is_enterprise_app
        __props__.__dict__["is_form_fill"] = is_form_fill
        __props__.__dict__["is_kerberos_realm"] = is_kerberos_realm
        __props__.__dict__["is_login_target"] = is_login_target
        __props__.__dict__["is_managed_app"] = is_managed_app
        __props__.__dict__["is_mobile_target"] = is_mobile_target
        __props__.__dict__["is_multicloud_service_app"] = is_multicloud_service_app
        __props__.__dict__["is_oauth_client"] = is_oauth_client
        __props__.__dict__["is_oauth_resource"] = is_oauth_resource
        __props__.__dict__["is_obligation_capable"] = is_obligation_capable
        __props__.__dict__["is_opc_service"] = is_opc_service
        __props__.__dict__["is_radius_app"] = is_radius_app
        __props__.__dict__["is_saml_service_provider"] = is_saml_service_provider
        __props__.__dict__["is_unmanaged_app"] = is_unmanaged_app
        __props__.__dict__["is_web_tier_policy"] = is_web_tier_policy
        __props__.__dict__["landing_page_url"] = landing_page_url
        __props__.__dict__["linking_callback_url"] = linking_callback_url
        __props__.__dict__["login_mechanism"] = login_mechanism
        __props__.__dict__["login_page_url"] = login_page_url
        __props__.__dict__["logout_page_url"] = logout_page_url
        __props__.__dict__["logout_uri"] = logout_uri
        __props__.__dict__["metas"] = metas
        __props__.__dict__["meter_as_opc_service"] = meter_as_opc_service
        __props__.__dict__["migrated"] = migrated
        __props__.__dict__["name"] = name
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["post_logout_redirect_uris"] = post_logout_redirect_uris
        __props__.__dict__["privacy_policy_url"] = privacy_policy_url
        __props__.__dict__["product_logo_url"] = product_logo_url
        __props__.__dict__["product_name"] = product_name
        __props__.__dict__["protectable_secondary_audiences"] = protectable_secondary_audiences
        __props__.__dict__["radius_policy"] = radius_policy
        __props__.__dict__["ready_to_upgrade"] = ready_to_upgrade
        __props__.__dict__["redirect_uris"] = redirect_uris
        __props__.__dict__["refresh_token_expiry"] = refresh_token_expiry
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["saml_service_provider"] = saml_service_provider
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["secondary_audiences"] = secondary_audiences
        __props__.__dict__["service_params"] = service_params
        __props__.__dict__["service_type_urn"] = service_type_urn
        __props__.__dict__["service_type_version"] = service_type_version
        __props__.__dict__["show_in_my_apps"] = show_in_my_apps
        __props__.__dict__["signon_policy"] = signon_policy
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        __props__.__dict__["terms_of_service_url"] = terms_of_service_url
        __props__.__dict__["terms_of_use"] = terms_of_use
        __props__.__dict__["trust_policies"] = trust_policies
        __props__.__dict__["trust_scope"] = trust_scope
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextension_oci_tags"] = urnietfparamsscimschemasoracleidcsextension_oci_tags
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensiondbcs_app"] = urnietfparamsscimschemasoracleidcsextensiondbcs_app
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionenterprise_app_app"] = urnietfparamsscimschemasoracleidcsextensionenterprise_app_app
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionform_fill_app_app"] = urnietfparamsscimschemasoracleidcsextensionform_fill_app_app
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template"] = urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app"] = urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionmanagedapp_app"] = urnietfparamsscimschemasoracleidcsextensionmanagedapp_app
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app"] = urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionopc_service_app"] = urnietfparamsscimschemasoracleidcsextensionopc_service_app
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionradius_app_app"] = urnietfparamsscimschemasoracleidcsextensionradius_app_app
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionrequestable_app"] = urnietfparamsscimschemasoracleidcsextensionrequestable_app
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app"] = urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app"] = urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app
        __props__.__dict__["user_roles"] = user_roles
        return DomainsApp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessTokenExpiry")
    def access_token_expiry(self) -> pulumi.Output[int]:
        """
        (Updatable) Access token expiry

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: dateTime
        * uniqueness: none
        """
        return pulumi.get(self, "access_token_expiry")

    @property
    @pulumi.getter
    def accounts(self) -> pulumi.Output[Sequence['outputs.DomainsAppAccount']]:
        """
        (Updatable) Accounts of App

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "accounts")

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, this App is able to participate in runtime services, such as automatic-login, OAuth, and SAML. If false, all runtime services are disabled for this App, and only administrative operations can be performed.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="adminRoles")
    def admin_roles(self) -> pulumi.Output[Sequence['outputs.DomainsAppAdminRole']]:
        """
        (Updatable) A list of AppRoles defined by this UnmanagedApp. Membership in each of these AppRoles confers administrative privilege within this App.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        """
        return pulumi.get(self, "admin_roles")

    @property
    @pulumi.getter(name="aliasApps")
    def alias_apps(self) -> pulumi.Output[Sequence['outputs.DomainsAppAliasApp']]:
        """
        (Updatable) Each value of this internal attribute refers to an Oracle Public Cloud infrastructure App on which this App depends.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "alias_apps")

    @property
    @pulumi.getter(name="allUrlSchemesAllowed")
    def all_url_schemes_allowed(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that the system should allow all URL-schemes within each value of the 'redirectUris' attribute.  Also indicates that the system should not attempt to confirm that each value of the 'redirectUris' attribute is a valid URI.  In particular, the system should not confirm that the domain component of the URI is a top-level domain and the system should not confirm that the hostname portion is a valid system that is reachable over the network.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "all_url_schemes_allowed")

    @property
    @pulumi.getter(name="allowAccessControl")
    def allow_access_control(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, any managed App that is based on this template is checked for access control that is, access to this app is subject to successful authorization at SSO service, viz. app grants to start with.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "allow_access_control")

    @property
    @pulumi.getter(name="allowOffline")
    def allow_offline(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that the Refresh Token is allowed when this App acts as an OAuth Resource.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "allow_offline")

    @property
    @pulumi.getter(name="allowedGrants")
    def allowed_grants(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) List of grant-types that this App is allowed to use when it acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_grants")

    @property
    @pulumi.getter(name="allowedOperations")
    def allowed_operations(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) OPTIONAL. Required only when this App acts as an OAuthClient. Supported values are 'introspect' and 'onBehalfOfUser'. The value 'introspect' allows the client to look inside the access-token. The value 'onBehalfOfUser' overrides how the client's privileges are combined with the privileges of the Subject User. Ordinarily, authorization calculates the set of effective privileges as the intersection of the client's privileges and the user's privileges. The value 'onBehalfOf' indicates that authorization should ignore the privileges of the client and use only the user's privileges to calculate the effective privileges.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_operations")

    @property
    @pulumi.getter(name="allowedScopes")
    def allowed_scopes(self) -> pulumi.Output[Sequence['outputs.DomainsAppAllowedScope']]:
        """
        (Updatable) A list of scopes (exposed by this App or by other Apps) that this App is allowed to access when it acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsCompositeKey: [fqs]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_scopes")

    @property
    @pulumi.getter(name="allowedTags")
    def allowed_tags(self) -> pulumi.Output[Sequence['outputs.DomainsAppAllowedTag']]:
        """
        (Updatable) A list of tags, acting as an OAuthClient, this App is allowed to access.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "allowed_tags")

    @property
    @pulumi.getter(name="appIcon")
    def app_icon(self) -> pulumi.Output[str]:
        """
        (Updatable) Application icon.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "app_icon")

    @property
    @pulumi.getter(name="appSignonPolicy")
    def app_signon_policy(self) -> pulumi.Output['outputs.DomainsAppAppSignonPolicy']:
        """
        (Updatable) App Sign-on Policy.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "app_signon_policy")

    @property
    @pulumi.getter(name="appThumbnail")
    def app_thumbnail(self) -> pulumi.Output[str]:
        """
        (Updatable) Application thumbnail.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "app_thumbnail")

    @property
    @pulumi.getter(name="appsNetworkPerimeters")
    def apps_network_perimeters(self) -> pulumi.Output[Sequence['outputs.DomainsAppAppsNetworkPerimeter']]:
        """
        (Updatable) Network Perimeter

        **Added In:** 2010242156

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "apps_network_perimeters")

    @property
    @pulumi.getter(name="asOpcService")
    def as_opc_service(self) -> pulumi.Output['outputs.DomainsAppAsOpcService']:
        """
        (Updatable) OPCService facet of the application.

        **Deprecated Since: 17.3.4**

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "as_opc_service")

    @property
    @pulumi.getter(name="attrRenderingMetadatas")
    def attr_rendering_metadatas(self) -> pulumi.Output[Sequence['outputs.DomainsAppAttrRenderingMetadata']]:
        """
        (Updatable) Label for the attribute to be shown in the UI.

        **SCIM++ Properties:**
        * idcsCompositeKey: [name]
        * idcsSearchable: false
        * multiValued: true
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "attr_rendering_metadatas")

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def audience(self) -> pulumi.Output[str]:
        """
        (Updatable) The base URI for all of the scopes defined in this App. The value of 'audience' is combined with the 'value' of each scope to form an 'fqs' or fully qualified scope.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="basedOnTemplate")
    def based_on_template(self) -> pulumi.Output['outputs.DomainsAppBasedOnTemplate']:
        """
        (Updatable) Application template on which the application is based.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "based_on_template")

    @property
    @pulumi.getter(name="bypassConsent")
    def bypass_consent(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that consent should be skipped for all scopes

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "bypass_consent")

    @property
    @pulumi.getter(name="callbackServiceUrl")
    def callback_service_url(self) -> pulumi.Output[str]:
        """
        (Updatable) Callback Service URL

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "callback_service_url")

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Sequence['outputs.DomainsAppCertificate']]:
        """
        (Updatable) Each value of this attribute represent a certificate that this App uses when it acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [certAlias]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="clientIpChecking")
    def client_ip_checking(self) -> pulumi.Output[str]:
        """
        (Updatable) Network Perimeters checking mode

        **Added In:** 2010242156

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "client_ip_checking")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[str]:
        """
        (Updatable) This value is the credential of this App, which this App supplies as a password when this App authenticates to the Oracle Public Cloud infrastructure. This value is also the client secret of this App when it acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * idcsSensitive: none
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="clientType")
    def client_type(self) -> pulumi.Output[str]:
        """
        (Updatable) Specifies the type of access that this App has when it acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "client_type")

    @property
    @pulumi.getter(name="cloudControlProperties")
    def cloud_control_properties(self) -> pulumi.Output[Sequence['outputs.DomainsAppCloudControlProperty']]:
        """
        (Updatable) A collection of arbitrary properties that scope the privileges of a cloud-control App.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
        * idcsCompositeKey: [name]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "cloud_control_properties")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="contactEmailAddress")
    def contact_email_address(self) -> pulumi.Output[str]:
        """
        (Updatable) Contact Email Address

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "contact_email_address")

    @property
    @pulumi.getter(name="delegatedServiceNames")
    def delegated_service_names(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Service Names allow to use Oracle Cloud Infrastructure signature for client authentication instead of client credentials

        **Added In:** 2207040824

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "delegated_service_names")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the AppRole.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableKmsiTokenAuthentication")
    def disable_kmsi_token_authentication(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates whether the application is allowed to be access using kmsi token.

        **Added In:** 2111190457

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: always
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "disable_kmsi_token_authentication")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Display name of the flatfile bundle configuration property. This attribute maps to \\"displayName\\" attribute in \\"ConfigurationProperty\\" in ICF.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter(name="editableAttributes")
    def editable_attributes(self) -> pulumi.Output[Sequence['outputs.DomainsAppEditableAttribute']]:
        """
        (Updatable) App attributes editable by subject

        **Added In:** 18.2.6

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [name]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "editable_attributes")

    @property
    @pulumi.getter(name="errorPageUrl")
    def error_page_url(self) -> pulumi.Output[str]:
        """
        (Updatable) This attribute specifies the URL of the page to which an application will redirect an end-user in case of error.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "error_page_url")

    @property
    @pulumi.getter(name="grantedAppRoles")
    def granted_app_roles(self) -> pulumi.Output[Sequence['outputs.DomainsAppGrantedAppRole']]:
        """
        (Updatable) A list of AppRoles that are granted to this App (and that are defined by other Apps). Within the Oracle Public Cloud infrastructure, this allows AppID-based association. Such an association allows this App to act as a consumer and thus to access resources of another App that acts as a producer.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "granted_app_roles")

    @property
    @pulumi.getter
    def grants(self) -> pulumi.Output[Sequence['outputs.DomainsAppGrant']]:
        """
        (Updatable) Grants assigned to the app

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "grants")

    @property
    @pulumi.getter(name="hashedClientSecret")
    def hashed_client_secret(self) -> pulumi.Output[str]:
        """
        (Updatable) Hashed Client Secret. This hash-value is used to verify the 'clientSecret' credential of this App

        **Added In:** 2106240046

        **SCIM++ Properties:**
        * idcsSearchable: false
        * idcsSensitive: hash_sc
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "hashed_client_secret")

    @property
    @pulumi.getter(name="homePageUrl")
    def home_page_url(self) -> pulumi.Output[str]:
        """
        (Updatable) Home Page URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "home_page_url")

    @property
    @pulumi.getter
    def icon(self) -> pulumi.Output[str]:
        """
        (Updatable) URL of application icon.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: reference
        * uniqueness: none
        """
        return pulumi.get(self, "icon")

    @property
    @pulumi.getter(name="idTokenEncAlgo")
    def id_token_enc_algo(self) -> pulumi.Output[str]:
        """
        (Updatable) Encryption Alogrithm to use for encrypting ID token.

        **Added In:** 2010242156

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "id_token_enc_algo")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsAppIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsAppIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="identityProviders")
    def identity_providers(self) -> pulumi.Output[Sequence['outputs.DomainsAppIdentityProvider']]:
        """
        (Updatable) A list of IdentityProvider assigned to app. A user trying to access this app will be automatically redirected to configured IdP during the authentication phase, before being able to access App.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        """
        return pulumi.get(self, "identity_providers")

    @property
    @pulumi.getter(name="idpPolicy")
    def idp_policy(self) -> pulumi.Output['outputs.DomainsAppIdpPolicy']:
        """
        (Updatable) IDP Policy.

        **Added In:** 18.1.2

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idp_policy")

    @property
    @pulumi.getter
    def infrastructure(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, this App is an internal infrastructure App.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "infrastructure")

    @property
    @pulumi.getter(name="isAliasApp")
    def is_alias_app(self) -> pulumi.Output[bool]:
        """
        If true, this App is an AliasApp and it cannot be granted to an end-user directly.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: always
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_alias_app")

    @property
    @pulumi.getter(name="isDatabaseService")
    def is_database_service(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, this application acts as database service Application

        **Added In:** 18.2.2

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * type: boolean
        """
        return pulumi.get(self, "is_database_service")

    @property
    @pulumi.getter(name="isEnterpriseApp")
    def is_enterprise_app(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, this app acts as Enterprise app with Authentication and URL Authz policy.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_enterprise_app")

    @property
    @pulumi.getter(name="isFormFill")
    def is_form_fill(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, this application acts as FormFill Application

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_form_fill")

    @property
    @pulumi.getter(name="isKerberosRealm")
    def is_kerberos_realm(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that this App supports Kerberos Authentication

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_kerberos_realm")

    @property
    @pulumi.getter(name="isLoginTarget")
    def is_login_target(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, this App allows runtime services to log end users into this App automatically.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_login_target")

    @property
    @pulumi.getter(name="isManagedApp")
    def is_managed_app(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that access to this App requires an account. That is, in order to log in to the App, a User must use an application-specific identity that is maintained in the remote identity-repository of that App.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_managed_app")

    @property
    @pulumi.getter(name="isMobileTarget")
    def is_mobile_target(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that the App should be visible in each end-user's mobile application.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_mobile_target")

    @property
    @pulumi.getter(name="isMulticloudServiceApp")
    def is_multicloud_service_app(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates the app is used for multicloud service integration.

        **Added In:** 2301202328

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_multicloud_service_app")

    @property
    @pulumi.getter(name="isOauthClient")
    def is_oauth_client(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, this application acts as an OAuth Client

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_oauth_client")

    @property
    @pulumi.getter(name="isOauthResource")
    def is_oauth_resource(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, indicates that this application acts as an OAuth Resource.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_oauth_resource")

    @property
    @pulumi.getter(name="isObligationCapable")
    def is_obligation_capable(self) -> pulumi.Output[bool]:
        """
        (Updatable) This flag indicates if the App is capable of validating obligations with the token for allowing access to the App.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_obligation_capable")

    @property
    @pulumi.getter(name="isOpcService")
    def is_opc_service(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, this application is an Oracle Public Cloud service-instance.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_opc_service")

    @property
    @pulumi.getter(name="isRadiusApp")
    def is_radius_app(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, this application acts as an Radius App

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_radius_app")

    @property
    @pulumi.getter(name="isSamlServiceProvider")
    def is_saml_service_provider(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, then this App acts as a SAML Service Provider.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_saml_service_provider")

    @property
    @pulumi.getter(name="isUnmanagedApp")
    def is_unmanaged_app(self) -> pulumi.Output[bool]:
        """
        If true, indicates that this application accepts an Oracle Cloud Identity Service User as a login-identity (does not require an account) and relies for authorization on the User's memberships in AppRoles.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_unmanaged_app")

    @property
    @pulumi.getter(name="isWebTierPolicy")
    def is_web_tier_policy(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, the webtier policy is active

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "is_web_tier_policy")

    @property
    @pulumi.getter(name="landingPageUrl")
    def landing_page_url(self) -> pulumi.Output[str]:
        """
        (Updatable) The URL of the landing page for this App, which is the first page that an end user should see if runtime services log that end user in to this App automatically.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "landing_page_url")

    @property
    @pulumi.getter(name="linkingCallbackUrl")
    def linking_callback_url(self) -> pulumi.Output[str]:
        """
        (Updatable) This attribute specifies the callback URL for the social linking operation.

        **Added In:** 18.2.4

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "linking_callback_url")

    @property
    @pulumi.getter(name="loginMechanism")
    def login_mechanism(self) -> pulumi.Output[str]:
        """
        (Updatable) The protocol that runtime services will use to log end users in to this App automatically. If 'OIDC', then runtime services use the OpenID Connect protocol. If 'SAML', then runtime services use Security Assertion Markup Language protocol.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "login_mechanism")

    @property
    @pulumi.getter(name="loginPageUrl")
    def login_page_url(self) -> pulumi.Output[str]:
        """
        (Updatable) This attribute specifies the URL of the page that the App uses when an end-user signs in to that App.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "login_page_url")

    @property
    @pulumi.getter(name="logoutPageUrl")
    def logout_page_url(self) -> pulumi.Output[str]:
        """
        (Updatable) This attribute specifies the URL of the page that the App uses when an end-user signs out.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_page_url")

    @property
    @pulumi.getter(name="logoutUri")
    def logout_uri(self) -> pulumi.Output[str]:
        """
        (Updatable) OAuth will use this URI to logout if this App wants to participate in SSO, and if this App's session gets cleared as part of global logout. Note: This attribute is used only if this App acts as an OAuthClient.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_uri")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsAppMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter(name="meterAsOpcService")
    def meter_as_opc_service(self) -> pulumi.Output[bool]:
        """
        (Updatable) Indicates whether the application is billed as an OPCService. If true, customer is not billed for runtime operations of the app.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: always
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "meter_as_opc_service")

    @property
    @pulumi.getter
    def migrated(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, this App was migrated from an earlier version of Oracle Public Cloud infrastructure (and may therefore require special handling from runtime services such as OAuth or SAML). If false, this App requires no special handling from runtime services.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "migrated")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Updatable) The attribute represents the name of the attribute that will be used in the Security Assertion Markup Language (SAML) assertion

        **Deprecated Since: 18.2.2**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * idcsValuePersistedInOtherAttribute: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="postLogoutRedirectUris")
    def post_logout_redirect_uris(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Each value of this attribute is the URI of a landing page within this App. It is used only when this App, acting as an OAuthClient, initiates the logout flow and wants to be redirected back to one of its landing pages.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "post_logout_redirect_uris")

    @property
    @pulumi.getter(name="privacyPolicyUrl")
    def privacy_policy_url(self) -> pulumi.Output[str]:
        """
        (Updatable) Privacy Policy URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "privacy_policy_url")

    @property
    @pulumi.getter(name="productLogoUrl")
    def product_logo_url(self) -> pulumi.Output[str]:
        """
        (Updatable) Application Logo URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "product_logo_url")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Product Name

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="protectableSecondaryAudiences")
    def protectable_secondary_audiences(self) -> pulumi.Output[Sequence['outputs.DomainsAppProtectableSecondaryAudience']]:
        """
        (Updatable) A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.

        **Added In:** 18.2.2

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "protectable_secondary_audiences")

    @property
    @pulumi.getter(name="radiusPolicy")
    def radius_policy(self) -> pulumi.Output['outputs.DomainsAppRadiusPolicy']:
        """
        (Updatable) RADIUS Policy assigned to this application.

        **Added In:** 2209070044

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "radius_policy")

    @property
    @pulumi.getter(name="readyToUpgrade")
    def ready_to_upgrade(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, this App requires an upgrade and mandates attention from application administrator. The flag is used by UI to indicate this app is ready to upgrade.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "ready_to_upgrade")

    @property
    @pulumi.getter(name="redirectUris")
    def redirect_uris(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) OPTIONAL. Each value is a URI within this App. This attribute is required when this App acts as an OAuthClient and is involved in three-legged flows (authorization-code flows).

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "redirect_uris")

    @property
    @pulumi.getter(name="refreshTokenExpiry")
    def refresh_token_expiry(self) -> pulumi.Output[int]:
        """
        (Updatable) Expiry-time in seconds for a Refresh Token.  Any token that allows access to this App, once refreshed, will expire after the specified duration.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: integer
        * uniqueness: none
        """
        return pulumi.get(self, "refresh_token_expiry")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter(name="samlServiceProvider")
    def saml_service_provider(self) -> pulumi.Output['outputs.DomainsAppSamlServiceProvider']:
        """
        (Updatable) An attribute that refers to the SAML Service Provider that runtime services will use to log an end user in to this App automatically. Note that this will be used only if the loginMechanism is 'SAML'.

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "saml_service_provider")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence['outputs.DomainsAppScope']]:
        """
        (Updatable) Scopes defined by this App. Used when this App acts as an OAuth Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="secondaryAudiences")
    def secondary_audiences(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) A list of secondary audiences--additional URIs to be added automatically to any OAuth token that allows access to this App. Note: This attribute is used mainly for backward compatibility in certain Oracle Public Cloud Apps.

        **Deprecated Since: 18.2.6**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "secondary_audiences")

    @property
    @pulumi.getter(name="serviceParams")
    def service_params(self) -> pulumi.Output[Sequence['outputs.DomainsAppServiceParam']]:
        """
        (Updatable) Custom attribute that is required to compute other attribute values during app creation.

        **SCIM++ Properties:**
        * idcsCompositeKey: [name]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: always
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "service_params")

    @property
    @pulumi.getter(name="serviceTypeUrn")
    def service_type_urn(self) -> pulumi.Output[str]:
        """
        (Updatable) This Uniform Resource Name (URN) value identifies the type of Oracle Public Cloud service of which this app is an instance.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "service_type_urn")

    @property
    @pulumi.getter(name="serviceTypeVersion")
    def service_type_version(self) -> pulumi.Output[str]:
        """
        (Updatable) This value specifies the version of the Oracle Public Cloud service of which this App is an instance

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "service_type_version")

    @property
    @pulumi.getter(name="showInMyApps")
    def show_in_my_apps(self) -> pulumi.Output[bool]:
        """
        (Updatable) If true, this app will be displayed in the MyApps page of each end-user who has access to the App.

        **Added In:** 18.1.2

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "show_in_my_apps")

    @property
    @pulumi.getter(name="signonPolicy")
    def signon_policy(self) -> pulumi.Output['outputs.DomainsAppSignonPolicy']:
        """
        (Updatable) Sign-on Policy.

        **Deprecated Since: 17.3.4**

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "signon_policy")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsAppTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter(name="termsOfServiceUrl")
    def terms_of_service_url(self) -> pulumi.Output[str]:
        """
        (Updatable) Terms of Service URL

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "terms_of_service_url")

    @property
    @pulumi.getter(name="termsOfUse")
    def terms_of_use(self) -> pulumi.Output['outputs.DomainsAppTermsOfUse']:
        """
        (Updatable) Terms Of Use.

        **Added In:** 18.2.6

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "terms_of_use")

    @property
    @pulumi.getter(name="trustPolicies")
    def trust_policies(self) -> pulumi.Output[Sequence['outputs.DomainsAppTrustPolicy']]:
        """
        (Updatable) Trust Policies.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "trust_policies")

    @property
    @pulumi.getter(name="trustScope")
    def trust_scope(self) -> pulumi.Output[str]:
        """
        (Updatable) Indicates the scope of trust for this App when acting as an OAuthClient. A value of 'Explicit' indicates that the App is allowed to access only the scopes of OAuthResources that are explicitly specified as 'allowedScopes'. A value of 'Account' indicates that the App is allowed implicitly to access any scope of any OAuthResource within the same Oracle Cloud Account. A value of 'Tags' indicates that the App is allowed to access any scope of any OAuthResource with a matching tag within the same Oracle Cloud Account. A value of 'Default' indicates that the Tenant default trust scope configured in the Tenant Settings is used.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "trust_scope")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionOciTags")
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self) -> pulumi.Output['outputs.DomainsAppUrnietfparamsscimschemasoracleidcsextensionOciTags']:
        """
        (Updatable) Oracle Cloud Infrastructure Tags.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiondbcsApp")
    def urnietfparamsscimschemasoracleidcsextensiondbcs_app(self) -> pulumi.Output['outputs.DomainsAppUrnietfparamsscimschemasoracleidcsextensiondbcsApp']:
        """
        (Updatable) This extension provides attributes for database service facet of an App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiondbcs_app")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionenterpriseAppApp")
    def urnietfparamsscimschemasoracleidcsextensionenterprise_app_app(self) -> pulumi.Output['outputs.DomainsAppUrnietfparamsscimschemasoracleidcsextensionenterpriseAppApp']:
        """
        (Updatable) This extension defines the Enterprise App related attributes.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionenterprise_app_app")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionformFillAppApp")
    def urnietfparamsscimschemasoracleidcsextensionform_fill_app_app(self) -> pulumi.Output['outputs.DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppApp']:
        """
        (Updatable) This extension provides attributes for Form-Fill facet of App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionform_fill_app_app")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplate")
    def urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template(self) -> pulumi.Output['outputs.DomainsAppUrnietfparamsscimschemasoracleidcsextensionformFillAppTemplateAppTemplate']:
        """
        (Updatable) This extension provides attributes for Form-Fill facet of AppTemplate
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionform_fill_app_template_app_template")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionkerberosRealmApp")
    def urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app(self) -> pulumi.Output['outputs.DomainsAppUrnietfparamsscimschemasoracleidcsextensionkerberosRealmApp']:
        """
        (Updatable) Kerberos Realm
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionkerberos_realm_app")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionmanagedappApp")
    def urnietfparamsscimschemasoracleidcsextensionmanagedapp_app(self) -> pulumi.Output['outputs.DomainsAppUrnietfparamsscimschemasoracleidcsextensionmanagedappApp']:
        """
        (Updatable) Managed App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionmanagedapp_app")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppApp")
    def urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app(self) -> pulumi.Output['outputs.DomainsAppUrnietfparamsscimschemasoracleidcsextensionmulticloudServiceAppApp']:
        """
        (Updatable) This extension defines attributes specific to Apps that represent instances of Multicloud Service App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionmulticloud_service_app_app")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionopcServiceApp")
    def urnietfparamsscimschemasoracleidcsextensionopc_service_app(self) -> pulumi.Output['outputs.DomainsAppUrnietfparamsscimschemasoracleidcsextensionopcServiceApp']:
        """
        (Updatable) This extension defines attributes specific to Apps that represent instances of an Oracle Public Cloud (OPC) service.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionopc_service_app")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionradiusAppApp")
    def urnietfparamsscimschemasoracleidcsextensionradius_app_app(self) -> pulumi.Output['outputs.DomainsAppUrnietfparamsscimschemasoracleidcsextensionradiusAppApp']:
        """
        (Updatable) This extension defines attributes specific to Apps that represent instances of Radius App.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionradius_app_app")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionrequestableApp")
    def urnietfparamsscimschemasoracleidcsextensionrequestable_app(self) -> pulumi.Output['outputs.DomainsAppUrnietfparamsscimschemasoracleidcsextensionrequestableApp']:
        """
        (Updatable) Requestable App
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionrequestable_app")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsamlServiceProviderApp")
    def urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app(self) -> pulumi.Output['outputs.DomainsAppUrnietfparamsscimschemasoracleidcsextensionsamlServiceProviderApp']:
        """
        (Updatable) This extension defines attributes related to the Service Providers configuration.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsaml_service_provider_app")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionwebTierPolicyApp")
    def urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app(self) -> pulumi.Output['outputs.DomainsAppUrnietfparamsscimschemasoracleidcsextensionwebTierPolicyApp']:
        """
        (Updatable) WebTier Policy
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionweb_tier_policy_app")

    @property
    @pulumi.getter(name="userRoles")
    def user_roles(self) -> pulumi.Output[Sequence['outputs.DomainsAppUserRole']]:
        """
        (Updatable) A list of AppRoles defined by this UnmanagedApp. Membership in each of these AppRoles confers end-user privilege within this App.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        """
        return pulumi.get(self, "user_roles")

