# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetLogAnalyticsResourceCategoriesListResult',
    'AwaitableGetLogAnalyticsResourceCategoriesListResult',
    'get_log_analytics_resource_categories_list',
    'get_log_analytics_resource_categories_list_output',
]

@pulumi.output_type
class GetLogAnalyticsResourceCategoriesListResult:
    """
    A collection of values returned by getLogAnalyticsResourceCategoriesList.
    """
    def __init__(__self__, categories=None, id=None, items=None, namespace=None, resource_categories=None, resource_ids=None, resource_types=None):
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if resource_categories and not isinstance(resource_categories, str):
            raise TypeError("Expected argument 'resource_categories' to be a str")
        pulumi.set(__self__, "resource_categories", resource_categories)
        if resource_ids and not isinstance(resource_ids, str):
            raise TypeError("Expected argument 'resource_ids' to be a str")
        pulumi.set(__self__, "resource_ids", resource_ids)
        if resource_types and not isinstance(resource_types, str):
            raise TypeError("Expected argument 'resource_types' to be a str")
        pulumi.set(__self__, "resource_types", resource_types)

    @property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.GetLogAnalyticsResourceCategoriesListCategoryResult']:
        """
        An array of categories. The array contents include detailed information about the distinct set of categories assigned to all the listed resources under items.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetLogAnalyticsResourceCategoriesListItemResult']:
        """
        A list of resources and their category assignments
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="resourceCategories")
    def resource_categories(self) -> Optional[str]:
        return pulumi.get(self, "resource_categories")

    @property
    @pulumi.getter(name="resourceIds")
    def resource_ids(self) -> Optional[str]:
        return pulumi.get(self, "resource_ids")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[str]:
        return pulumi.get(self, "resource_types")


class AwaitableGetLogAnalyticsResourceCategoriesListResult(GetLogAnalyticsResourceCategoriesListResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsResourceCategoriesListResult(
            categories=self.categories,
            id=self.id,
            items=self.items,
            namespace=self.namespace,
            resource_categories=self.resource_categories,
            resource_ids=self.resource_ids,
            resource_types=self.resource_types)


def get_log_analytics_resource_categories_list(namespace: Optional[str] = None,
                                               resource_categories: Optional[str] = None,
                                               resource_ids: Optional[str] = None,
                                               resource_types: Optional[str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsResourceCategoriesListResult:
    """
    This data source provides details about Resource Categories in Oracle Cloud Infrastructure Log Analytics service.

    Returns a list of resources and their category assignments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_resource_categories_list = oci.LogAnalytics.get_log_analytics_resource_categories_list(namespace=var["log_analytics_resource_categories_list_namespace"],
        resource_ids=var["log_analytics_resource_categories_list_resource_ids"],
        resource_types=var["log_analytics_resource_categories_list_resource_types"],
        resource_categories=var["log_analytics_resource_categories_list_resource_categories"])
    ```


    :param str namespace: The Logging Analytics namespace used for the request.
    :param str resource_categories: A comma-separated list of category names used for filtering
    :param str resource_ids: A comma-separated list of resource unique identifiers used for filtering. Only resources with matching unique identifiers will be returned.
    :param str resource_types: A comma-separated list of resource types used for filtering. Only resources of the types specified will be returned. Examples include SOURCE, PARSER, LOOKUP, etc.
    """
    __args__ = dict()
    __args__['namespace'] = namespace
    __args__['resourceCategories'] = resource_categories
    __args__['resourceIds'] = resource_ids
    __args__['resourceTypes'] = resource_types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsResourceCategoriesList:getLogAnalyticsResourceCategoriesList', __args__, opts=opts, typ=GetLogAnalyticsResourceCategoriesListResult).value

    return AwaitableGetLogAnalyticsResourceCategoriesListResult(
        categories=pulumi.get(__ret__, 'categories'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        namespace=pulumi.get(__ret__, 'namespace'),
        resource_categories=pulumi.get(__ret__, 'resource_categories'),
        resource_ids=pulumi.get(__ret__, 'resource_ids'),
        resource_types=pulumi.get(__ret__, 'resource_types'))


@_utilities.lift_output_func(get_log_analytics_resource_categories_list)
def get_log_analytics_resource_categories_list_output(namespace: Optional[pulumi.Input[str]] = None,
                                                      resource_categories: Optional[pulumi.Input[Optional[str]]] = None,
                                                      resource_ids: Optional[pulumi.Input[Optional[str]]] = None,
                                                      resource_types: Optional[pulumi.Input[Optional[str]]] = None,
                                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLogAnalyticsResourceCategoriesListResult]:
    """
    This data source provides details about Resource Categories in Oracle Cloud Infrastructure Log Analytics service.

    Returns a list of resources and their category assignments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_resource_categories_list = oci.LogAnalytics.get_log_analytics_resource_categories_list(namespace=var["log_analytics_resource_categories_list_namespace"],
        resource_ids=var["log_analytics_resource_categories_list_resource_ids"],
        resource_types=var["log_analytics_resource_categories_list_resource_types"],
        resource_categories=var["log_analytics_resource_categories_list_resource_categories"])
    ```


    :param str namespace: The Logging Analytics namespace used for the request.
    :param str resource_categories: A comma-separated list of category names used for filtering
    :param str resource_ids: A comma-separated list of resource unique identifiers used for filtering. Only resources with matching unique identifiers will be returned.
    :param str resource_types: A comma-separated list of resource types used for filtering. Only resources of the types specified will be returned. Examples include SOURCE, PARSER, LOOKUP, etc.
    """
    ...
