# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNamespaceIngestTimeRuleResult',
    'AwaitableGetNamespaceIngestTimeRuleResult',
    'get_namespace_ingest_time_rule',
    'get_namespace_ingest_time_rule_output',
]

@pulumi.output_type
class GetNamespaceIngestTimeRuleResult:
    """
    A collection of values returned by getNamespaceIngestTimeRule.
    """
    def __init__(__self__, actions=None, compartment_id=None, conditions=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, ingest_time_rule_id=None, is_enabled=None, namespace=None, state=None, time_created=None, time_updated=None):
        if actions and not isinstance(actions, list):
            raise TypeError("Expected argument 'actions' to be a list")
        pulumi.set(__self__, "actions", actions)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ingest_time_rule_id and not isinstance(ingest_time_rule_id, str):
            raise TypeError("Expected argument 'ingest_time_rule_id' to be a str")
        pulumi.set(__self__, "ingest_time_rule_id", ingest_time_rule_id)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetNamespaceIngestTimeRuleActionResult']:
        """
        The action(s) to be performed if the ingest time rule condition(s) are satisfied.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetNamespaceIngestTimeRuleConditionResult']:
        """
        The condition(s) to evaluate for an ingest time rule.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description for this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The ingest time rule display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The log analytics entity OCID. This ID is a reference used by log analytics features and it represents a resource that is provisioned and managed by the customer on their premises or on the cloud.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ingestTimeRuleId")
    def ingest_time_rule_id(self) -> str:
        return pulumi.get(self, "ingest_time_rule_id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        A flag indicating whether or not the ingest time rule is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace of the extracted metric. A valid value starts with an alphabetical character and includes only alphanumeric characters and underscores (_).
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the ingest time rule.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetNamespaceIngestTimeRuleResult(GetNamespaceIngestTimeRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespaceIngestTimeRuleResult(
            actions=self.actions,
            compartment_id=self.compartment_id,
            conditions=self.conditions,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            ingest_time_rule_id=self.ingest_time_rule_id,
            is_enabled=self.is_enabled,
            namespace=self.namespace,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_namespace_ingest_time_rule(ingest_time_rule_id: Optional[str] = None,
                                   namespace: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespaceIngestTimeRuleResult:
    """
    This data source provides details about a specific Namespace Ingest Time Rule resource in Oracle Cloud Infrastructure Log Analytics service.

    Gets detailed information about the specified ingest time rule such as description, defined tags, and free-form tags.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_ingest_time_rule = oci.LogAnalytics.get_namespace_ingest_time_rule(ingest_time_rule_id=oci_events_rule["test_rule"]["id"],
        namespace=var["namespace_ingest_time_rule_namespace"])
    ```


    :param str ingest_time_rule_id: Unique ocid of the ingest time rule.
    :param str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['ingestTimeRuleId'] = ingest_time_rule_id
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getNamespaceIngestTimeRule:getNamespaceIngestTimeRule', __args__, opts=opts, typ=GetNamespaceIngestTimeRuleResult).value

    return AwaitableGetNamespaceIngestTimeRuleResult(
        actions=pulumi.get(__ret__, 'actions'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        conditions=pulumi.get(__ret__, 'conditions'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        ingest_time_rule_id=pulumi.get(__ret__, 'ingest_time_rule_id'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        namespace=pulumi.get(__ret__, 'namespace'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_namespace_ingest_time_rule)
def get_namespace_ingest_time_rule_output(ingest_time_rule_id: Optional[pulumi.Input[str]] = None,
                                          namespace: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNamespaceIngestTimeRuleResult]:
    """
    This data source provides details about a specific Namespace Ingest Time Rule resource in Oracle Cloud Infrastructure Log Analytics service.

    Gets detailed information about the specified ingest time rule such as description, defined tags, and free-form tags.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_namespace_ingest_time_rule = oci.LogAnalytics.get_namespace_ingest_time_rule(ingest_time_rule_id=oci_events_rule["test_rule"]["id"],
        namespace=var["namespace_ingest_time_rule_namespace"])
    ```


    :param str ingest_time_rule_id: Unique ocid of the ingest time rule.
    :param str namespace: The Logging Analytics namespace used for the request.
    """
    ...
