# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'MediaAssetMediaAssetTagArgs',
    'MediaAssetMetadataArgs',
    'MediaWorkflowJobOutputArgs',
    'MediaWorkflowJobTaskLifecycleStateArgs',
    'MediaWorkflowTaskArgs',
    'StreamCdnConfigConfigArgs',
    'StreamPackagingConfigEncryptionArgs',
    'GetMediaAssetsFilterArgs',
    'GetMediaWorkflowConfigurationsFilterArgs',
    'GetMediaWorkflowJobFactsFilterArgs',
    'GetMediaWorkflowJobsFilterArgs',
    'GetMediaWorkflowsFilterArgs',
    'GetStreamCdnConfigsFilterArgs',
    'GetStreamDistributionChannelsFilterArgs',
    'GetStreamPackagingConfigsFilterArgs',
]

@pulumi.input_type
class MediaAssetMediaAssetTagArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] value: (Updatable) Tag of the MediaAsset.
        :param pulumi.Input[str] type: (Updatable) The type of the media asset.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        MediaAssetMediaAssetTagArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            value=value,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             value: pulumi.Input[str],
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("value", value)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        (Updatable) Tag of the MediaAsset.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of the media asset.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MediaAssetMetadataArgs:
    def __init__(__self__, *,
                 metadata: pulumi.Input[str]):
        """
        :param pulumi.Input[str] metadata: (Updatable) JSON string containing the technial metadata for the media asset.
        """
        MediaAssetMetadataArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            metadata=metadata,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             metadata: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("metadata", metadata)

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Input[str]:
        """
        (Updatable) JSON string containing the technial metadata for the media asset.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: pulumi.Input[str]):
        pulumi.set(self, "metadata", value)


@pulumi.input_type
class MediaWorkflowJobOutputArgs:
    def __init__(__self__, *,
                 asset_type: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] asset_type: Type of job output.
        :param pulumi.Input[str] bucket: The bucket name of the job output.
        :param pulumi.Input[str] id: The ID associated with the job output.
        :param pulumi.Input[str] namespace: The namespace name of the job output.
        :param pulumi.Input[str] object: The object name of the job output.
        """
        MediaWorkflowJobOutputArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            asset_type=asset_type,
            bucket=bucket,
            id=id,
            namespace=namespace,
            object=object,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             asset_type: Optional[pulumi.Input[str]] = None,
             bucket: Optional[pulumi.Input[str]] = None,
             id: Optional[pulumi.Input[str]] = None,
             namespace: Optional[pulumi.Input[str]] = None,
             object: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if asset_type is not None:
            _setter("asset_type", asset_type)
        if bucket is not None:
            _setter("bucket", bucket)
        if id is not None:
            _setter("id", id)
        if namespace is not None:
            _setter("namespace", namespace)
        if object is not None:
            _setter("object", object)

    @property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of job output.
        """
        return pulumi.get(self, "asset_type")

    @asset_type.setter
    def asset_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_type", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The bucket name of the job output.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID associated with the job output.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace name of the job output.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        The object name of the job output.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class MediaWorkflowJobTaskLifecycleStateArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: Unique key within a MediaWorkflowJob for the task.
        :param pulumi.Input[str] lifecycle_details: The lifecycle details of MediaWorkflowJob task.
        :param pulumi.Input[str] state: The current state of the MediaWorkflowJob task.
        """
        MediaWorkflowJobTaskLifecycleStateArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            lifecycle_details=lifecycle_details,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: Optional[pulumi.Input[str]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if key is not None:
            _setter("key", key)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if state is not None:
            _setter("state", state)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Unique key within a MediaWorkflowJob for the task.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        The lifecycle details of MediaWorkflowJob task.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the MediaWorkflowJob task.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class MediaWorkflowTaskArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 parameters: pulumi.Input[str],
                 type: pulumi.Input[str],
                 version: pulumi.Input[str],
                 enable_parameter_reference: Optional[pulumi.Input[str]] = None,
                 enable_when_referenced_parameter_equals: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 prerequisites: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] key: (Updatable) A unique identifier for this task within its workflow. Keys are used to reference a task within workflows and MediaWorkflowJobs. Tasks are referenced as prerequisites and to track output and state.
        :param pulumi.Input[str] parameters: (Updatable) Data specifiying how this task is to be run. The data is a JSON object that must conform to the JSON Schema specified by the parameters of the MediaWorkflowTaskDeclaration this task references. The parameters may contain values or references to other parameters.
        :param pulumi.Input[str] type: (Updatable) The type of process to run at this task. Refers to the name of a MediaWorkflowTaskDeclaration.
        :param pulumi.Input[str] version: (Updatable) The version of the MediaWorkflowTaskDeclaration.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] enable_parameter_reference: (Updatable) Allows this task to be conditionally enabled.  If no value or a blank value is given, the task is unconditionally enbled.  Otherwise the given string specifies a parameter of the job created for this task's workflow using the JSON pointer syntax. The JSON pointer is validated when a job is created from the workflow of this task.
        :param pulumi.Input[Mapping[str, Any]] enable_when_referenced_parameter_equals: (Updatable) Used in conjunction with enableParameterReference to conditionally enable a task.  When a job is created from the workflow of this task, the task will only be enabled if the value of the parameter specified by enableParameterReference is equal to the value of this property. This property must be prenset if and only if a enableParameterReference is given. The value is a JSON node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prerequisites: (Updatable) Keys to the other tasks in this workflow that must be completed before execution of this task can begin.
        """
        MediaWorkflowTaskArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            parameters=parameters,
            type=type,
            version=version,
            enable_parameter_reference=enable_parameter_reference,
            enable_when_referenced_parameter_equals=enable_when_referenced_parameter_equals,
            prerequisites=prerequisites,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: pulumi.Input[str],
             parameters: pulumi.Input[str],
             type: pulumi.Input[str],
             version: pulumi.Input[str],
             enable_parameter_reference: Optional[pulumi.Input[str]] = None,
             enable_when_referenced_parameter_equals: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             prerequisites: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("key", key)
        _setter("parameters", parameters)
        _setter("type", type)
        _setter("version", version)
        if enable_parameter_reference is not None:
            _setter("enable_parameter_reference", enable_parameter_reference)
        if enable_when_referenced_parameter_equals is not None:
            _setter("enable_when_referenced_parameter_equals", enable_when_referenced_parameter_equals)
        if prerequisites is not None:
            _setter("prerequisites", prerequisites)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        (Updatable) A unique identifier for this task within its workflow. Keys are used to reference a task within workflows and MediaWorkflowJobs. Tasks are referenced as prerequisites and to track output and state.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input[str]:
        """
        (Updatable) Data specifiying how this task is to be run. The data is a JSON object that must conform to the JSON Schema specified by the parameters of the MediaWorkflowTaskDeclaration this task references. The parameters may contain values or references to other parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of process to run at this task. Refers to the name of a MediaWorkflowTaskDeclaration.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        (Updatable) The version of the MediaWorkflowTaskDeclaration.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="enableParameterReference")
    def enable_parameter_reference(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Allows this task to be conditionally enabled.  If no value or a blank value is given, the task is unconditionally enbled.  Otherwise the given string specifies a parameter of the job created for this task's workflow using the JSON pointer syntax. The JSON pointer is validated when a job is created from the workflow of this task.
        """
        return pulumi.get(self, "enable_parameter_reference")

    @enable_parameter_reference.setter
    def enable_parameter_reference(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_parameter_reference", value)

    @property
    @pulumi.getter(name="enableWhenReferencedParameterEquals")
    def enable_when_referenced_parameter_equals(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Used in conjunction with enableParameterReference to conditionally enable a task.  When a job is created from the workflow of this task, the task will only be enabled if the value of the parameter specified by enableParameterReference is equal to the value of this property. This property must be prenset if and only if a enableParameterReference is given. The value is a JSON node.
        """
        return pulumi.get(self, "enable_when_referenced_parameter_equals")

    @enable_when_referenced_parameter_equals.setter
    def enable_when_referenced_parameter_equals(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "enable_when_referenced_parameter_equals", value)

    @property
    @pulumi.getter
    def prerequisites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Keys to the other tasks in this workflow that must be completed before execution of this task can begin.
        """
        return pulumi.get(self, "prerequisites")

    @prerequisites.setter
    def prerequisites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prerequisites", value)


@pulumi.input_type
class StreamCdnConfigConfigArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 edge_hostname: Optional[pulumi.Input[str]] = None,
                 edge_path_prefix: Optional[pulumi.Input[str]] = None,
                 edge_token_key: Optional[pulumi.Input[str]] = None,
                 edge_token_salt: Optional[pulumi.Input[str]] = None,
                 is_edge_token_auth: Optional[pulumi.Input[bool]] = None,
                 origin_auth_secret_key_a: Optional[pulumi.Input[str]] = None,
                 origin_auth_secret_key_b: Optional[pulumi.Input[str]] = None,
                 origin_auth_secret_key_nonce_a: Optional[pulumi.Input[str]] = None,
                 origin_auth_secret_key_nonce_b: Optional[pulumi.Input[str]] = None,
                 origin_auth_sign_encryption: Optional[pulumi.Input[str]] = None,
                 origin_auth_sign_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: (Updatable) The name of the CDN configuration type.
        :param pulumi.Input[str] edge_hostname: (Updatable) The hostname of the CDN edge server to use when building CDN URLs.
        :param pulumi.Input[str] edge_path_prefix: (Updatable) The path to prepend when building CDN URLs.
        :param pulumi.Input[str] edge_token_key: (Updatable) The encryption key to use for edge token authentication.
        :param pulumi.Input[str] edge_token_salt: (Updatable) Salt to use when encrypting authentication token.
        :param pulumi.Input[bool] is_edge_token_auth: (Updatable) Whether token authentication should be used at the CDN edge.
        :param pulumi.Input[str] origin_auth_secret_key_a: (Updatable) The shared secret key A, two for errorless key rotation.
        :param pulumi.Input[str] origin_auth_secret_key_b: (Updatable) The shared secret key B, two for errorless key rotation.
        :param pulumi.Input[str] origin_auth_secret_key_nonce_a: (Updatable) Nonce identifier for originAuthSecretKeyA (used to determine key used to sign).
        :param pulumi.Input[str] origin_auth_secret_key_nonce_b: (Updatable) Nonce identifier for originAuthSecretKeyB (used to determine key used to sign).
        :param pulumi.Input[str] origin_auth_sign_encryption: (Updatable) The type of encryption used to compute the signature.
        :param pulumi.Input[str] origin_auth_sign_type: (Updatable) The type of data used to compute the signature.
        """
        StreamCdnConfigConfigArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            edge_hostname=edge_hostname,
            edge_path_prefix=edge_path_prefix,
            edge_token_key=edge_token_key,
            edge_token_salt=edge_token_salt,
            is_edge_token_auth=is_edge_token_auth,
            origin_auth_secret_key_a=origin_auth_secret_key_a,
            origin_auth_secret_key_b=origin_auth_secret_key_b,
            origin_auth_secret_key_nonce_a=origin_auth_secret_key_nonce_a,
            origin_auth_secret_key_nonce_b=origin_auth_secret_key_nonce_b,
            origin_auth_sign_encryption=origin_auth_sign_encryption,
            origin_auth_sign_type=origin_auth_sign_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: pulumi.Input[str],
             edge_hostname: Optional[pulumi.Input[str]] = None,
             edge_path_prefix: Optional[pulumi.Input[str]] = None,
             edge_token_key: Optional[pulumi.Input[str]] = None,
             edge_token_salt: Optional[pulumi.Input[str]] = None,
             is_edge_token_auth: Optional[pulumi.Input[bool]] = None,
             origin_auth_secret_key_a: Optional[pulumi.Input[str]] = None,
             origin_auth_secret_key_b: Optional[pulumi.Input[str]] = None,
             origin_auth_secret_key_nonce_a: Optional[pulumi.Input[str]] = None,
             origin_auth_secret_key_nonce_b: Optional[pulumi.Input[str]] = None,
             origin_auth_sign_encryption: Optional[pulumi.Input[str]] = None,
             origin_auth_sign_type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("type", type)
        if edge_hostname is not None:
            _setter("edge_hostname", edge_hostname)
        if edge_path_prefix is not None:
            _setter("edge_path_prefix", edge_path_prefix)
        if edge_token_key is not None:
            _setter("edge_token_key", edge_token_key)
        if edge_token_salt is not None:
            _setter("edge_token_salt", edge_token_salt)
        if is_edge_token_auth is not None:
            _setter("is_edge_token_auth", is_edge_token_auth)
        if origin_auth_secret_key_a is not None:
            _setter("origin_auth_secret_key_a", origin_auth_secret_key_a)
        if origin_auth_secret_key_b is not None:
            _setter("origin_auth_secret_key_b", origin_auth_secret_key_b)
        if origin_auth_secret_key_nonce_a is not None:
            _setter("origin_auth_secret_key_nonce_a", origin_auth_secret_key_nonce_a)
        if origin_auth_secret_key_nonce_b is not None:
            _setter("origin_auth_secret_key_nonce_b", origin_auth_secret_key_nonce_b)
        if origin_auth_sign_encryption is not None:
            _setter("origin_auth_sign_encryption", origin_auth_sign_encryption)
        if origin_auth_sign_type is not None:
            _setter("origin_auth_sign_type", origin_auth_sign_type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) The name of the CDN configuration type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="edgeHostname")
    def edge_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The hostname of the CDN edge server to use when building CDN URLs.
        """
        return pulumi.get(self, "edge_hostname")

    @edge_hostname.setter
    def edge_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edge_hostname", value)

    @property
    @pulumi.getter(name="edgePathPrefix")
    def edge_path_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The path to prepend when building CDN URLs.
        """
        return pulumi.get(self, "edge_path_prefix")

    @edge_path_prefix.setter
    def edge_path_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edge_path_prefix", value)

    @property
    @pulumi.getter(name="edgeTokenKey")
    def edge_token_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The encryption key to use for edge token authentication.
        """
        return pulumi.get(self, "edge_token_key")

    @edge_token_key.setter
    def edge_token_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edge_token_key", value)

    @property
    @pulumi.getter(name="edgeTokenSalt")
    def edge_token_salt(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Salt to use when encrypting authentication token.
        """
        return pulumi.get(self, "edge_token_salt")

    @edge_token_salt.setter
    def edge_token_salt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edge_token_salt", value)

    @property
    @pulumi.getter(name="isEdgeTokenAuth")
    def is_edge_token_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether token authentication should be used at the CDN edge.
        """
        return pulumi.get(self, "is_edge_token_auth")

    @is_edge_token_auth.setter
    def is_edge_token_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_edge_token_auth", value)

    @property
    @pulumi.getter(name="originAuthSecretKeyA")
    def origin_auth_secret_key_a(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The shared secret key A, two for errorless key rotation.
        """
        return pulumi.get(self, "origin_auth_secret_key_a")

    @origin_auth_secret_key_a.setter
    def origin_auth_secret_key_a(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_auth_secret_key_a", value)

    @property
    @pulumi.getter(name="originAuthSecretKeyB")
    def origin_auth_secret_key_b(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The shared secret key B, two for errorless key rotation.
        """
        return pulumi.get(self, "origin_auth_secret_key_b")

    @origin_auth_secret_key_b.setter
    def origin_auth_secret_key_b(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_auth_secret_key_b", value)

    @property
    @pulumi.getter(name="originAuthSecretKeyNonceA")
    def origin_auth_secret_key_nonce_a(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Nonce identifier for originAuthSecretKeyA (used to determine key used to sign).
        """
        return pulumi.get(self, "origin_auth_secret_key_nonce_a")

    @origin_auth_secret_key_nonce_a.setter
    def origin_auth_secret_key_nonce_a(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_auth_secret_key_nonce_a", value)

    @property
    @pulumi.getter(name="originAuthSecretKeyNonceB")
    def origin_auth_secret_key_nonce_b(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Nonce identifier for originAuthSecretKeyB (used to determine key used to sign).
        """
        return pulumi.get(self, "origin_auth_secret_key_nonce_b")

    @origin_auth_secret_key_nonce_b.setter
    def origin_auth_secret_key_nonce_b(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_auth_secret_key_nonce_b", value)

    @property
    @pulumi.getter(name="originAuthSignEncryption")
    def origin_auth_sign_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of encryption used to compute the signature.
        """
        return pulumi.get(self, "origin_auth_sign_encryption")

    @origin_auth_sign_encryption.setter
    def origin_auth_sign_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_auth_sign_encryption", value)

    @property
    @pulumi.getter(name="originAuthSignType")
    def origin_auth_sign_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of data used to compute the signature.
        """
        return pulumi.get(self, "origin_auth_sign_type")

    @origin_auth_sign_type.setter
    def origin_auth_sign_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "origin_auth_sign_type", value)


@pulumi.input_type
class StreamPackagingConfigEncryptionArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[str],
                 kms_key_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] algorithm: The encryption algorithm for the stream packaging configuration.
        :param pulumi.Input[str] kms_key_id: The identifier of the customer managed Vault KMS symmetric encryption key (null if Oracle managed).
        """
        StreamPackagingConfigEncryptionArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            algorithm=algorithm,
            kms_key_id=kms_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             algorithm: pulumi.Input[str],
             kms_key_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("algorithm", algorithm)
        if kms_key_id is not None:
            _setter("kms_key_id", kms_key_id)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[str]:
        """
        The encryption algorithm for the stream packaging configuration.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[str]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the customer managed Vault KMS symmetric encryption key (null if Oracle managed).
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)


@pulumi.input_type
class GetMediaAssetsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetMediaAssetsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetMediaWorkflowConfigurationsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetMediaWorkflowConfigurationsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetMediaWorkflowJobFactsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Unique name. It is read-only and generated for the fact.
        """
        GetMediaWorkflowJobFactsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name. It is read-only and generated for the fact.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetMediaWorkflowJobsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetMediaWorkflowJobsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetMediaWorkflowsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetMediaWorkflowsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetStreamCdnConfigsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetStreamCdnConfigsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetStreamDistributionChannelsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetStreamDistributionChannelsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetStreamPackagingConfigsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetStreamPackagingConfigsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


