# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'SubscriptionRedeemableUserItem',
    'GetResourceQuotasFilterResult',
    'GetResourceQuotasResourceQuotumCollectionResult',
    'GetResourceQuotasResourceQuotumCollectionItemResult',
    'GetResourcesFilterResult',
    'GetResourcesResourcesCollectionResult',
    'GetResourcesResourcesCollectionItemResult',
    'GetResourcesResourcesCollectionItemSkusResult',
    'GetSubscriptionProductItemResult',
    'GetSubscriptionProductsFilterResult',
    'GetSubscriptionProductsProductCollectionResult',
    'GetSubscriptionProductsProductCollectionItemResult',
    'GetSubscriptionProductsProductCollectionItemItemResult',
    'GetSubscriptionRedeemableUserItemResult',
    'GetSubscriptionRedeemableUsersFilterResult',
    'GetSubscriptionRedeemableUsersRedeemableUserCollectionResult',
    'GetSubscriptionRedeemableUsersRedeemableUserCollectionItemResult',
    'GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemResult',
    'GetSubscriptionRedemptionItemResult',
    'GetSubscriptionRedemptionsFilterResult',
    'GetSubscriptionRedemptionsRedemptionCollectionResult',
    'GetSubscriptionRedemptionsRedemptionCollectionItemResult',
    'GetSubscriptionRedemptionsRedemptionCollectionItemItemResult',
    'GetSubscriptionRewardItemResult',
    'GetSubscriptionRewardSummaryResult',
    'GetSubscriptionRewardsFilterResult',
    'GetSubscriptionRewardsRewardCollectionResult',
    'GetSubscriptionRewardsRewardCollectionItemResult',
    'GetSubscriptionRewardsRewardCollectionItemItemResult',
    'GetSubscriptionRewardsRewardCollectionItemSummaryResult',
    'GetUsagelimitsFilterResult',
    'GetUsagelimitsUsageLimitCollectionResult',
    'GetUsagelimitsUsageLimitCollectionItemResult',
]

@pulumi.output_type
class SubscriptionRedeemableUserItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailId":
            suggest = "email_id"
        elif key == "firstName":
            suggest = "first_name"
        elif key == "lastName":
            suggest = "last_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubscriptionRedeemableUserItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubscriptionRedeemableUserItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubscriptionRedeemableUserItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_id: str,
                 first_name: Optional[str] = None,
                 last_name: Optional[str] = None):
        """
        :param str email_id: The email ID for a user that can redeem rewards.
        :param str first_name: The first name of the user that can redeem rewards.
        :param str last_name: The last name of the user that can redeem rewards.
        """
        SubscriptionRedeemableUserItem._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            email_id=email_id,
            first_name=first_name,
            last_name=last_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             email_id: str,
             first_name: Optional[str] = None,
             last_name: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("email_id", email_id)
        if first_name is not None:
            _setter("first_name", first_name)
        if last_name is not None:
            _setter("last_name", last_name)

    @property
    @pulumi.getter(name="emailId")
    def email_id(self) -> str:
        """
        The email ID for a user that can redeem rewards.
        """
        return pulumi.get(self, "email_id")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[str]:
        """
        The first name of the user that can redeem rewards.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[str]:
        """
        The last name of the user that can redeem rewards.
        """
        return pulumi.get(self, "last_name")


@pulumi.output_type
class GetResourceQuotasFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The resource name.
        """
        GetResourceQuotasFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetResourceQuotasResourceQuotumCollectionResult(dict):
    def __init__(__self__, *,
                 is_allowed: bool,
                 items: Sequence['outputs.GetResourceQuotasResourceQuotumCollectionItemResult']):
        """
        :param bool is_allowed: Used to indicate if further quota consumption isAllowed.
        :param Sequence['GetResourceQuotasResourceQuotumCollectionItemArgs'] items: The list of resource quota details.
        """
        GetResourceQuotasResourceQuotumCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_allowed=is_allowed,
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_allowed: bool,
             items: Sequence['outputs.GetResourceQuotasResourceQuotumCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("is_allowed", is_allowed)
        _setter("items", items)

    @property
    @pulumi.getter(name="isAllowed")
    def is_allowed(self) -> bool:
        """
        Used to indicate if further quota consumption isAllowed.
        """
        return pulumi.get(self, "is_allowed")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetResourceQuotasResourceQuotumCollectionItemResult']:
        """
        The list of resource quota details.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetResourceQuotasResourceQuotumCollectionItemResult(dict):
    def __init__(__self__, *,
                 affected_resource: str,
                 balance: float,
                 is_allowed: bool,
                 is_dependency: bool,
                 is_overage: bool,
                 name: str,
                 purchased_limit: float,
                 service: str):
        """
        :param str affected_resource: The affected resource name.
        :param float balance: The quota balance.
        :param bool is_allowed: Used to indicate if further quota consumption isAllowed.
        :param bool is_dependency: Used to indicate any resource dependencies.
        :param bool is_overage: Used to indicate if overages are incurred.
        :param str name: The resource name.
        :param float purchased_limit: The purchased quota limit.
        :param str service: The service name.
        """
        GetResourceQuotasResourceQuotumCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            affected_resource=affected_resource,
            balance=balance,
            is_allowed=is_allowed,
            is_dependency=is_dependency,
            is_overage=is_overage,
            name=name,
            purchased_limit=purchased_limit,
            service=service,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             affected_resource: str,
             balance: float,
             is_allowed: bool,
             is_dependency: bool,
             is_overage: bool,
             name: str,
             purchased_limit: float,
             service: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("affected_resource", affected_resource)
        _setter("balance", balance)
        _setter("is_allowed", is_allowed)
        _setter("is_dependency", is_dependency)
        _setter("is_overage", is_overage)
        _setter("name", name)
        _setter("purchased_limit", purchased_limit)
        _setter("service", service)

    @property
    @pulumi.getter(name="affectedResource")
    def affected_resource(self) -> str:
        """
        The affected resource name.
        """
        return pulumi.get(self, "affected_resource")

    @property
    @pulumi.getter
    def balance(self) -> float:
        """
        The quota balance.
        """
        return pulumi.get(self, "balance")

    @property
    @pulumi.getter(name="isAllowed")
    def is_allowed(self) -> bool:
        """
        Used to indicate if further quota consumption isAllowed.
        """
        return pulumi.get(self, "is_allowed")

    @property
    @pulumi.getter(name="isDependency")
    def is_dependency(self) -> bool:
        """
        Used to indicate any resource dependencies.
        """
        return pulumi.get(self, "is_dependency")

    @property
    @pulumi.getter(name="isOverage")
    def is_overage(self) -> bool:
        """
        Used to indicate if overages are incurred.
        """
        return pulumi.get(self, "is_overage")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="purchasedLimit")
    def purchased_limit(self) -> float:
        """
        The purchased quota limit.
        """
        return pulumi.get(self, "purchased_limit")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The service name.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GetResourcesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of the resource.
        """
        GetResourcesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetResourcesResourcesCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetResourcesResourcesCollectionItemResult']):
        """
        :param Sequence['GetResourcesResourcesCollectionItemArgs'] items: The list of resource details for a service.
        """
        GetResourcesResourcesCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetResourcesResourcesCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetResourcesResourcesCollectionItemResult']:
        """
        The list of resource details for a service.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetResourcesResourcesCollectionItemResult(dict):
    def __init__(__self__, *,
                 child_resources: Sequence[str],
                 daily_unit_display_name: str,
                 description: str,
                 hourly_unit_display_name: str,
                 instance_type: str,
                 is_purchased: bool,
                 name: str,
                 raw_unit_display_name: str,
                 servicename: str,
                 skuses: Sequence['outputs.GetResourcesResourcesCollectionItemSkusResult'],
                 usage_data_type: str):
        """
        :param Sequence[str] child_resources: The details of any child resources.
        :param str daily_unit_display_name: Units to be used for daily aggregated data.
        :param str description: Description of the resource.
        :param str hourly_unit_display_name: Units to be used for hourly aggregated data.
        :param str instance_type: Instance type for the resource.
        :param bool is_purchased: Indicates if the SKU was purchased
        :param str name: Name of the resource.
        :param str raw_unit_display_name: Default units to use when unspecified.
        :param str servicename: Name of the service.
        :param Sequence['GetResourcesResourcesCollectionItemSkusArgs'] skuses: The details of resource Skus.
        :param str usage_data_type: Usage data type of the resource.
        """
        GetResourcesResourcesCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            child_resources=child_resources,
            daily_unit_display_name=daily_unit_display_name,
            description=description,
            hourly_unit_display_name=hourly_unit_display_name,
            instance_type=instance_type,
            is_purchased=is_purchased,
            name=name,
            raw_unit_display_name=raw_unit_display_name,
            servicename=servicename,
            skuses=skuses,
            usage_data_type=usage_data_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             child_resources: Sequence[str],
             daily_unit_display_name: str,
             description: str,
             hourly_unit_display_name: str,
             instance_type: str,
             is_purchased: bool,
             name: str,
             raw_unit_display_name: str,
             servicename: str,
             skuses: Sequence['outputs.GetResourcesResourcesCollectionItemSkusResult'],
             usage_data_type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("child_resources", child_resources)
        _setter("daily_unit_display_name", daily_unit_display_name)
        _setter("description", description)
        _setter("hourly_unit_display_name", hourly_unit_display_name)
        _setter("instance_type", instance_type)
        _setter("is_purchased", is_purchased)
        _setter("name", name)
        _setter("raw_unit_display_name", raw_unit_display_name)
        _setter("servicename", servicename)
        _setter("skuses", skuses)
        _setter("usage_data_type", usage_data_type)

    @property
    @pulumi.getter(name="childResources")
    def child_resources(self) -> Sequence[str]:
        """
        The details of any child resources.
        """
        return pulumi.get(self, "child_resources")

    @property
    @pulumi.getter(name="dailyUnitDisplayName")
    def daily_unit_display_name(self) -> str:
        """
        Units to be used for daily aggregated data.
        """
        return pulumi.get(self, "daily_unit_display_name")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="hourlyUnitDisplayName")
    def hourly_unit_display_name(self) -> str:
        """
        Units to be used for hourly aggregated data.
        """
        return pulumi.get(self, "hourly_unit_display_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Instance type for the resource.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="isPurchased")
    def is_purchased(self) -> bool:
        """
        Indicates if the SKU was purchased
        """
        return pulumi.get(self, "is_purchased")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rawUnitDisplayName")
    def raw_unit_display_name(self) -> str:
        """
        Default units to use when unspecified.
        """
        return pulumi.get(self, "raw_unit_display_name")

    @property
    @pulumi.getter
    def servicename(self) -> str:
        """
        Name of the service.
        """
        return pulumi.get(self, "servicename")

    @property
    @pulumi.getter
    def skuses(self) -> Sequence['outputs.GetResourcesResourcesCollectionItemSkusResult']:
        """
        The details of resource Skus.
        """
        return pulumi.get(self, "skuses")

    @property
    @pulumi.getter(name="usageDataType")
    def usage_data_type(self) -> str:
        """
        Usage data type of the resource.
        """
        return pulumi.get(self, "usage_data_type")


@pulumi.output_type
class GetResourcesResourcesCollectionItemSkusResult(dict):
    def __init__(__self__, *,
                 cloud_credit_type: str,
                 sku_id: str,
                 sku_type: str):
        """
        :param str cloud_credit_type: The cloud credit type for the resource.
        :param str sku_id: The Sku Id for the resource.
        :param str sku_type: The Sku type for the resource.
        """
        GetResourcesResourcesCollectionItemSkusResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cloud_credit_type=cloud_credit_type,
            sku_id=sku_id,
            sku_type=sku_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cloud_credit_type: str,
             sku_id: str,
             sku_type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("cloud_credit_type", cloud_credit_type)
        _setter("sku_id", sku_id)
        _setter("sku_type", sku_type)

    @property
    @pulumi.getter(name="cloudCreditType")
    def cloud_credit_type(self) -> str:
        """
        The cloud credit type for the resource.
        """
        return pulumi.get(self, "cloud_credit_type")

    @property
    @pulumi.getter(name="skuId")
    def sku_id(self) -> str:
        """
        The Sku Id for the resource.
        """
        return pulumi.get(self, "sku_id")

    @property
    @pulumi.getter(name="skuType")
    def sku_type(self) -> str:
        """
        The Sku type for the resource.
        """
        return pulumi.get(self, "sku_type")


@pulumi.output_type
class GetSubscriptionProductItemResult(dict):
    def __init__(__self__, *,
                 earned_rewards: float,
                 is_eligible_to_earn_rewards: bool,
                 product_name: str,
                 product_number: str,
                 usage_amount: float):
        """
        :param float earned_rewards: The earned rewards for the product.
        :param bool is_eligible_to_earn_rewards: The boolean parameter to indicate if the product is eligible to earn rewards.
        :param str product_name: The rate card product name.
        :param str product_number: The rate card product number.
        :param float usage_amount: The rate card product usage amount.
        """
        GetSubscriptionProductItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            earned_rewards=earned_rewards,
            is_eligible_to_earn_rewards=is_eligible_to_earn_rewards,
            product_name=product_name,
            product_number=product_number,
            usage_amount=usage_amount,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             earned_rewards: float,
             is_eligible_to_earn_rewards: bool,
             product_name: str,
             product_number: str,
             usage_amount: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("earned_rewards", earned_rewards)
        _setter("is_eligible_to_earn_rewards", is_eligible_to_earn_rewards)
        _setter("product_name", product_name)
        _setter("product_number", product_number)
        _setter("usage_amount", usage_amount)

    @property
    @pulumi.getter(name="earnedRewards")
    def earned_rewards(self) -> float:
        """
        The earned rewards for the product.
        """
        return pulumi.get(self, "earned_rewards")

    @property
    @pulumi.getter(name="isEligibleToEarnRewards")
    def is_eligible_to_earn_rewards(self) -> bool:
        """
        The boolean parameter to indicate if the product is eligible to earn rewards.
        """
        return pulumi.get(self, "is_eligible_to_earn_rewards")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> str:
        """
        The rate card product name.
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="productNumber")
    def product_number(self) -> str:
        """
        The rate card product number.
        """
        return pulumi.get(self, "product_number")

    @property
    @pulumi.getter(name="usageAmount")
    def usage_amount(self) -> float:
        """
        The rate card product usage amount.
        """
        return pulumi.get(self, "usage_amount")


@pulumi.output_type
class GetSubscriptionProductsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetSubscriptionProductsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionProductsProductCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionProductsProductCollectionItemResult']):
        """
        :param Sequence['GetSubscriptionProductsProductCollectionItemArgs'] items: The list of product rewards summaries.
        """
        GetSubscriptionProductsProductCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetSubscriptionProductsProductCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionProductsProductCollectionItemResult']:
        """
        The list of product rewards summaries.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionProductsProductCollectionItemResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionProductsProductCollectionItemItemResult']):
        """
        :param Sequence['GetSubscriptionProductsProductCollectionItemItemArgs'] items: The list of product rewards summaries.
        """
        GetSubscriptionProductsProductCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetSubscriptionProductsProductCollectionItemItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionProductsProductCollectionItemItemResult']:
        """
        The list of product rewards summaries.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionProductsProductCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 earned_rewards: float,
                 is_eligible_to_earn_rewards: bool,
                 product_name: str,
                 product_number: str,
                 usage_amount: float):
        """
        :param float earned_rewards: The earned rewards for the product.
        :param bool is_eligible_to_earn_rewards: The boolean parameter to indicate if the product is eligible to earn rewards.
        :param str product_name: The rate card product name.
        :param str product_number: The rate card product number.
        :param float usage_amount: The rate card product usage amount.
        """
        GetSubscriptionProductsProductCollectionItemItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            earned_rewards=earned_rewards,
            is_eligible_to_earn_rewards=is_eligible_to_earn_rewards,
            product_name=product_name,
            product_number=product_number,
            usage_amount=usage_amount,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             earned_rewards: float,
             is_eligible_to_earn_rewards: bool,
             product_name: str,
             product_number: str,
             usage_amount: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("earned_rewards", earned_rewards)
        _setter("is_eligible_to_earn_rewards", is_eligible_to_earn_rewards)
        _setter("product_name", product_name)
        _setter("product_number", product_number)
        _setter("usage_amount", usage_amount)

    @property
    @pulumi.getter(name="earnedRewards")
    def earned_rewards(self) -> float:
        """
        The earned rewards for the product.
        """
        return pulumi.get(self, "earned_rewards")

    @property
    @pulumi.getter(name="isEligibleToEarnRewards")
    def is_eligible_to_earn_rewards(self) -> bool:
        """
        The boolean parameter to indicate if the product is eligible to earn rewards.
        """
        return pulumi.get(self, "is_eligible_to_earn_rewards")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> str:
        """
        The rate card product name.
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="productNumber")
    def product_number(self) -> str:
        """
        The rate card product number.
        """
        return pulumi.get(self, "product_number")

    @property
    @pulumi.getter(name="usageAmount")
    def usage_amount(self) -> float:
        """
        The rate card product usage amount.
        """
        return pulumi.get(self, "usage_amount")


@pulumi.output_type
class GetSubscriptionRedeemableUserItemResult(dict):
    def __init__(__self__, *,
                 email_id: str,
                 first_name: str,
                 last_name: str):
        """
        :param str email_id: The email ID of the user that can redeem rewards.
        :param str first_name: The first name of the user that can redeem rewards.
        :param str last_name: The last name of the user that can redeem rewards.
        """
        GetSubscriptionRedeemableUserItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            email_id=email_id,
            first_name=first_name,
            last_name=last_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             email_id: str,
             first_name: str,
             last_name: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("email_id", email_id)
        _setter("first_name", first_name)
        _setter("last_name", last_name)

    @property
    @pulumi.getter(name="emailId")
    def email_id(self) -> str:
        """
        The email ID of the user that can redeem rewards.
        """
        return pulumi.get(self, "email_id")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        """
        The first name of the user that can redeem rewards.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        """
        The last name of the user that can redeem rewards.
        """
        return pulumi.get(self, "last_name")


@pulumi.output_type
class GetSubscriptionRedeemableUsersFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetSubscriptionRedeemableUsersFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionRedeemableUsersRedeemableUserCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRedeemableUsersRedeemableUserCollectionItemResult']):
        """
        :param Sequence['GetSubscriptionRedeemableUsersRedeemableUserCollectionItemArgs'] items: The list of user summary that can redeem rewards.
        """
        GetSubscriptionRedeemableUsersRedeemableUserCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetSubscriptionRedeemableUsersRedeemableUserCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRedeemableUsersRedeemableUserCollectionItemResult']:
        """
        The list of user summary that can redeem rewards.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionRedeemableUsersRedeemableUserCollectionItemResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemResult'],
                 subscription_id: str,
                 tenancy_id: str,
                 user_id: str):
        """
        :param Sequence['GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemArgs'] items: The list of user summary that can redeem rewards.
        :param str subscription_id: The subscription ID for which rewards information is requested for.
        :param str tenancy_id: The OCID of the tenancy.
        """
        GetSubscriptionRedeemableUsersRedeemableUserCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
            subscription_id=subscription_id,
            tenancy_id=tenancy_id,
            user_id=user_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemResult'],
             subscription_id: str,
             tenancy_id: str,
             user_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)
        _setter("subscription_id", subscription_id)
        _setter("tenancy_id", tenancy_id)
        _setter("user_id", user_id)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemResult']:
        """
        The list of user summary that can redeem rewards.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        The subscription ID for which rewards information is requested for.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        The OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 email_id: str,
                 first_name: str,
                 last_name: str):
        """
        :param str email_id: The email ID of the user that can redeem rewards.
        :param str first_name: The first name of the user that can redeem rewards.
        :param str last_name: The last name of the user that can redeem rewards.
        """
        GetSubscriptionRedeemableUsersRedeemableUserCollectionItemItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            email_id=email_id,
            first_name=first_name,
            last_name=last_name,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             email_id: str,
             first_name: str,
             last_name: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("email_id", email_id)
        _setter("first_name", first_name)
        _setter("last_name", last_name)

    @property
    @pulumi.getter(name="emailId")
    def email_id(self) -> str:
        """
        The email ID of the user that can redeem rewards.
        """
        return pulumi.get(self, "email_id")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        """
        The first name of the user that can redeem rewards.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        """
        The last name of the user that can redeem rewards.
        """
        return pulumi.get(self, "last_name")


@pulumi.output_type
class GetSubscriptionRedemptionItemResult(dict):
    def __init__(__self__, *,
                 base_rewards: float,
                 fx_rate: float,
                 invoice_currency: str,
                 invoice_number: str,
                 invoice_total_amount: float,
                 redeemed_rewards: float,
                 redemption_code: str,
                 redemption_email: str,
                 time_invoiced: str,
                 time_redeemed: str):
        """
        :param float base_rewards: It provides the redeemed rewards in base/subscription currency.
        :param float fx_rate: It provides the fxRate between invoice currency and subscription currency.
        :param str invoice_currency: The currency associated with invoice.
        :param str invoice_number: It provides the invoice number against the redemption.
        :param float invoice_total_amount: It provides the invoice total amount of given redemption.
        :param float redeemed_rewards: It provides the redeemed rewards in invoice currency.
        :param str redemption_code: The redemption code used in the Billing Center during the reward redemption process.
        :param str redemption_email: It provides the redemption email id.
        :param str time_invoiced: It provides the invoice date.
        :param str time_redeemed: It provides redeem date.
        """
        GetSubscriptionRedemptionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            base_rewards=base_rewards,
            fx_rate=fx_rate,
            invoice_currency=invoice_currency,
            invoice_number=invoice_number,
            invoice_total_amount=invoice_total_amount,
            redeemed_rewards=redeemed_rewards,
            redemption_code=redemption_code,
            redemption_email=redemption_email,
            time_invoiced=time_invoiced,
            time_redeemed=time_redeemed,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             base_rewards: float,
             fx_rate: float,
             invoice_currency: str,
             invoice_number: str,
             invoice_total_amount: float,
             redeemed_rewards: float,
             redemption_code: str,
             redemption_email: str,
             time_invoiced: str,
             time_redeemed: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("base_rewards", base_rewards)
        _setter("fx_rate", fx_rate)
        _setter("invoice_currency", invoice_currency)
        _setter("invoice_number", invoice_number)
        _setter("invoice_total_amount", invoice_total_amount)
        _setter("redeemed_rewards", redeemed_rewards)
        _setter("redemption_code", redemption_code)
        _setter("redemption_email", redemption_email)
        _setter("time_invoiced", time_invoiced)
        _setter("time_redeemed", time_redeemed)

    @property
    @pulumi.getter(name="baseRewards")
    def base_rewards(self) -> float:
        """
        It provides the redeemed rewards in base/subscription currency.
        """
        return pulumi.get(self, "base_rewards")

    @property
    @pulumi.getter(name="fxRate")
    def fx_rate(self) -> float:
        """
        It provides the fxRate between invoice currency and subscription currency.
        """
        return pulumi.get(self, "fx_rate")

    @property
    @pulumi.getter(name="invoiceCurrency")
    def invoice_currency(self) -> str:
        """
        The currency associated with invoice.
        """
        return pulumi.get(self, "invoice_currency")

    @property
    @pulumi.getter(name="invoiceNumber")
    def invoice_number(self) -> str:
        """
        It provides the invoice number against the redemption.
        """
        return pulumi.get(self, "invoice_number")

    @property
    @pulumi.getter(name="invoiceTotalAmount")
    def invoice_total_amount(self) -> float:
        """
        It provides the invoice total amount of given redemption.
        """
        return pulumi.get(self, "invoice_total_amount")

    @property
    @pulumi.getter(name="redeemedRewards")
    def redeemed_rewards(self) -> float:
        """
        It provides the redeemed rewards in invoice currency.
        """
        return pulumi.get(self, "redeemed_rewards")

    @property
    @pulumi.getter(name="redemptionCode")
    def redemption_code(self) -> str:
        """
        The redemption code used in the Billing Center during the reward redemption process.
        """
        return pulumi.get(self, "redemption_code")

    @property
    @pulumi.getter(name="redemptionEmail")
    def redemption_email(self) -> str:
        """
        It provides the redemption email id.
        """
        return pulumi.get(self, "redemption_email")

    @property
    @pulumi.getter(name="timeInvoiced")
    def time_invoiced(self) -> str:
        """
        It provides the invoice date.
        """
        return pulumi.get(self, "time_invoiced")

    @property
    @pulumi.getter(name="timeRedeemed")
    def time_redeemed(self) -> str:
        """
        It provides redeem date.
        """
        return pulumi.get(self, "time_redeemed")


@pulumi.output_type
class GetSubscriptionRedemptionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetSubscriptionRedemptionsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionRedemptionsRedemptionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRedemptionsRedemptionCollectionItemResult']):
        """
        :param Sequence['GetSubscriptionRedemptionsRedemptionCollectionItemArgs'] items: The list of redemption summary.
        """
        GetSubscriptionRedemptionsRedemptionCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetSubscriptionRedemptionsRedemptionCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRedemptionsRedemptionCollectionItemResult']:
        """
        The list of redemption summary.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionRedemptionsRedemptionCollectionItemResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRedemptionsRedemptionCollectionItemItemResult']):
        """
        :param Sequence['GetSubscriptionRedemptionsRedemptionCollectionItemItemArgs'] items: The list of redemption summary.
        """
        GetSubscriptionRedemptionsRedemptionCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetSubscriptionRedemptionsRedemptionCollectionItemItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRedemptionsRedemptionCollectionItemItemResult']:
        """
        The list of redemption summary.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionRedemptionsRedemptionCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 base_rewards: float,
                 fx_rate: float,
                 invoice_currency: str,
                 invoice_number: str,
                 invoice_total_amount: float,
                 redeemed_rewards: float,
                 redemption_code: str,
                 redemption_email: str,
                 time_invoiced: str,
                 time_redeemed: str):
        """
        :param float base_rewards: It provides the redeemed rewards in base/subscription currency.
        :param float fx_rate: It provides the fxRate between invoice currency and subscription currency.
        :param str invoice_currency: The currency associated with invoice.
        :param str invoice_number: It provides the invoice number against the redemption.
        :param float invoice_total_amount: It provides the invoice total amount of given redemption.
        :param float redeemed_rewards: It provides the redeemed rewards in invoice currency.
        :param str redemption_code: The redemption code used in the Billing Center during the reward redemption process.
        :param str redemption_email: It provides the redemption email id.
        :param str time_invoiced: It provides the invoice date.
        :param str time_redeemed: It provides redeem date.
        """
        GetSubscriptionRedemptionsRedemptionCollectionItemItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            base_rewards=base_rewards,
            fx_rate=fx_rate,
            invoice_currency=invoice_currency,
            invoice_number=invoice_number,
            invoice_total_amount=invoice_total_amount,
            redeemed_rewards=redeemed_rewards,
            redemption_code=redemption_code,
            redemption_email=redemption_email,
            time_invoiced=time_invoiced,
            time_redeemed=time_redeemed,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             base_rewards: float,
             fx_rate: float,
             invoice_currency: str,
             invoice_number: str,
             invoice_total_amount: float,
             redeemed_rewards: float,
             redemption_code: str,
             redemption_email: str,
             time_invoiced: str,
             time_redeemed: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("base_rewards", base_rewards)
        _setter("fx_rate", fx_rate)
        _setter("invoice_currency", invoice_currency)
        _setter("invoice_number", invoice_number)
        _setter("invoice_total_amount", invoice_total_amount)
        _setter("redeemed_rewards", redeemed_rewards)
        _setter("redemption_code", redemption_code)
        _setter("redemption_email", redemption_email)
        _setter("time_invoiced", time_invoiced)
        _setter("time_redeemed", time_redeemed)

    @property
    @pulumi.getter(name="baseRewards")
    def base_rewards(self) -> float:
        """
        It provides the redeemed rewards in base/subscription currency.
        """
        return pulumi.get(self, "base_rewards")

    @property
    @pulumi.getter(name="fxRate")
    def fx_rate(self) -> float:
        """
        It provides the fxRate between invoice currency and subscription currency.
        """
        return pulumi.get(self, "fx_rate")

    @property
    @pulumi.getter(name="invoiceCurrency")
    def invoice_currency(self) -> str:
        """
        The currency associated with invoice.
        """
        return pulumi.get(self, "invoice_currency")

    @property
    @pulumi.getter(name="invoiceNumber")
    def invoice_number(self) -> str:
        """
        It provides the invoice number against the redemption.
        """
        return pulumi.get(self, "invoice_number")

    @property
    @pulumi.getter(name="invoiceTotalAmount")
    def invoice_total_amount(self) -> float:
        """
        It provides the invoice total amount of given redemption.
        """
        return pulumi.get(self, "invoice_total_amount")

    @property
    @pulumi.getter(name="redeemedRewards")
    def redeemed_rewards(self) -> float:
        """
        It provides the redeemed rewards in invoice currency.
        """
        return pulumi.get(self, "redeemed_rewards")

    @property
    @pulumi.getter(name="redemptionCode")
    def redemption_code(self) -> str:
        """
        The redemption code used in the Billing Center during the reward redemption process.
        """
        return pulumi.get(self, "redemption_code")

    @property
    @pulumi.getter(name="redemptionEmail")
    def redemption_email(self) -> str:
        """
        It provides the redemption email id.
        """
        return pulumi.get(self, "redemption_email")

    @property
    @pulumi.getter(name="timeInvoiced")
    def time_invoiced(self) -> str:
        """
        It provides the invoice date.
        """
        return pulumi.get(self, "time_invoiced")

    @property
    @pulumi.getter(name="timeRedeemed")
    def time_redeemed(self) -> str:
        """
        It provides redeem date.
        """
        return pulumi.get(self, "time_redeemed")


@pulumi.output_type
class GetSubscriptionRewardItemResult(dict):
    def __init__(__self__, *,
                 available_rewards: float,
                 earned_rewards: float,
                 eligible_usage_amount: float,
                 ineligible_usage_amount: float,
                 is_manual: bool,
                 redeemed_rewards: float,
                 time_rewards_earned: str,
                 time_rewards_expired: str,
                 time_usage_ended: str,
                 time_usage_started: str,
                 usage_amount: float,
                 usage_period_key: str):
        """
        :param float available_rewards: The number of rewards available for a specific usage period.
        :param float earned_rewards: The number of rewards earned for the specific usage period.
        :param float eligible_usage_amount: The eligible usage amount for the usage period.
        :param float ineligible_usage_amount: The ineligible usage amount for the usage period.
        :param bool is_manual: The boolean parameter to indicate whether or not the available rewards are manually posted.
        :param float redeemed_rewards: The number of rewards redeemed for a specific month.
        :param str time_rewards_earned: The date and time when rewards accrue.
        :param str time_rewards_expired: The date and time when rewards expire.
        :param str time_usage_ended: The end date and time for the usage period.
        :param str time_usage_started: The start date and time for the usage period.
        :param float usage_amount: The usage amount for the usage period.
        :param str usage_period_key: The usage period ID.
        """
        GetSubscriptionRewardItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            available_rewards=available_rewards,
            earned_rewards=earned_rewards,
            eligible_usage_amount=eligible_usage_amount,
            ineligible_usage_amount=ineligible_usage_amount,
            is_manual=is_manual,
            redeemed_rewards=redeemed_rewards,
            time_rewards_earned=time_rewards_earned,
            time_rewards_expired=time_rewards_expired,
            time_usage_ended=time_usage_ended,
            time_usage_started=time_usage_started,
            usage_amount=usage_amount,
            usage_period_key=usage_period_key,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             available_rewards: float,
             earned_rewards: float,
             eligible_usage_amount: float,
             ineligible_usage_amount: float,
             is_manual: bool,
             redeemed_rewards: float,
             time_rewards_earned: str,
             time_rewards_expired: str,
             time_usage_ended: str,
             time_usage_started: str,
             usage_amount: float,
             usage_period_key: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("available_rewards", available_rewards)
        _setter("earned_rewards", earned_rewards)
        _setter("eligible_usage_amount", eligible_usage_amount)
        _setter("ineligible_usage_amount", ineligible_usage_amount)
        _setter("is_manual", is_manual)
        _setter("redeemed_rewards", redeemed_rewards)
        _setter("time_rewards_earned", time_rewards_earned)
        _setter("time_rewards_expired", time_rewards_expired)
        _setter("time_usage_ended", time_usage_ended)
        _setter("time_usage_started", time_usage_started)
        _setter("usage_amount", usage_amount)
        _setter("usage_period_key", usage_period_key)

    @property
    @pulumi.getter(name="availableRewards")
    def available_rewards(self) -> float:
        """
        The number of rewards available for a specific usage period.
        """
        return pulumi.get(self, "available_rewards")

    @property
    @pulumi.getter(name="earnedRewards")
    def earned_rewards(self) -> float:
        """
        The number of rewards earned for the specific usage period.
        """
        return pulumi.get(self, "earned_rewards")

    @property
    @pulumi.getter(name="eligibleUsageAmount")
    def eligible_usage_amount(self) -> float:
        """
        The eligible usage amount for the usage period.
        """
        return pulumi.get(self, "eligible_usage_amount")

    @property
    @pulumi.getter(name="ineligibleUsageAmount")
    def ineligible_usage_amount(self) -> float:
        """
        The ineligible usage amount for the usage period.
        """
        return pulumi.get(self, "ineligible_usage_amount")

    @property
    @pulumi.getter(name="isManual")
    def is_manual(self) -> bool:
        """
        The boolean parameter to indicate whether or not the available rewards are manually posted.
        """
        return pulumi.get(self, "is_manual")

    @property
    @pulumi.getter(name="redeemedRewards")
    def redeemed_rewards(self) -> float:
        """
        The number of rewards redeemed for a specific month.
        """
        return pulumi.get(self, "redeemed_rewards")

    @property
    @pulumi.getter(name="timeRewardsEarned")
    def time_rewards_earned(self) -> str:
        """
        The date and time when rewards accrue.
        """
        return pulumi.get(self, "time_rewards_earned")

    @property
    @pulumi.getter(name="timeRewardsExpired")
    def time_rewards_expired(self) -> str:
        """
        The date and time when rewards expire.
        """
        return pulumi.get(self, "time_rewards_expired")

    @property
    @pulumi.getter(name="timeUsageEnded")
    def time_usage_ended(self) -> str:
        """
        The end date and time for the usage period.
        """
        return pulumi.get(self, "time_usage_ended")

    @property
    @pulumi.getter(name="timeUsageStarted")
    def time_usage_started(self) -> str:
        """
        The start date and time for the usage period.
        """
        return pulumi.get(self, "time_usage_started")

    @property
    @pulumi.getter(name="usageAmount")
    def usage_amount(self) -> float:
        """
        The usage amount for the usage period.
        """
        return pulumi.get(self, "usage_amount")

    @property
    @pulumi.getter(name="usagePeriodKey")
    def usage_period_key(self) -> str:
        """
        The usage period ID.
        """
        return pulumi.get(self, "usage_period_key")


@pulumi.output_type
class GetSubscriptionRewardSummaryResult(dict):
    def __init__(__self__, *,
                 currency: str,
                 redemption_code: str,
                 rewards_rate: float,
                 subscription_id: str,
                 tenancy_id: str,
                 total_rewards_available: float):
        """
        :param str currency: The currency unit for the reward amount.
        :param str redemption_code: The redemption code used in the Billing Center during the reward redemption process.
        :param float rewards_rate: The current Rewards percentage in decimal format.
        :param str subscription_id: The subscription ID for which rewards information is requested for.
        :param str tenancy_id: The OCID of the tenancy.
        :param float total_rewards_available: The total number of available rewards for a given subscription ID.
        """
        GetSubscriptionRewardSummaryResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            currency=currency,
            redemption_code=redemption_code,
            rewards_rate=rewards_rate,
            subscription_id=subscription_id,
            tenancy_id=tenancy_id,
            total_rewards_available=total_rewards_available,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             currency: str,
             redemption_code: str,
             rewards_rate: float,
             subscription_id: str,
             tenancy_id: str,
             total_rewards_available: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("currency", currency)
        _setter("redemption_code", redemption_code)
        _setter("rewards_rate", rewards_rate)
        _setter("subscription_id", subscription_id)
        _setter("tenancy_id", tenancy_id)
        _setter("total_rewards_available", total_rewards_available)

    @property
    @pulumi.getter
    def currency(self) -> str:
        """
        The currency unit for the reward amount.
        """
        return pulumi.get(self, "currency")

    @property
    @pulumi.getter(name="redemptionCode")
    def redemption_code(self) -> str:
        """
        The redemption code used in the Billing Center during the reward redemption process.
        """
        return pulumi.get(self, "redemption_code")

    @property
    @pulumi.getter(name="rewardsRate")
    def rewards_rate(self) -> float:
        """
        The current Rewards percentage in decimal format.
        """
        return pulumi.get(self, "rewards_rate")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        The subscription ID for which rewards information is requested for.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        The OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="totalRewardsAvailable")
    def total_rewards_available(self) -> float:
        """
        The total number of available rewards for a given subscription ID.
        """
        return pulumi.get(self, "total_rewards_available")


@pulumi.output_type
class GetSubscriptionRewardsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetSubscriptionRewardsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionRewardsRewardCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemResult']):
        """
        :param Sequence['GetSubscriptionRewardsRewardCollectionItemArgs'] items: The monthly summary of rewards.
        """
        GetSubscriptionRewardsRewardCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemResult']:
        """
        The monthly summary of rewards.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionRewardsRewardCollectionItemResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemItemResult'],
                 summaries: Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemSummaryResult']):
        """
        :param Sequence['GetSubscriptionRewardsRewardCollectionItemItemArgs'] items: The monthly summary of rewards.
        :param Sequence['GetSubscriptionRewardsRewardCollectionItemSummaryArgs'] summaries: The overall monthly reward summary.
        """
        GetSubscriptionRewardsRewardCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
            summaries=summaries,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemItemResult'],
             summaries: Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemSummaryResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)
        _setter("summaries", summaries)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemItemResult']:
        """
        The monthly summary of rewards.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def summaries(self) -> Sequence['outputs.GetSubscriptionRewardsRewardCollectionItemSummaryResult']:
        """
        The overall monthly reward summary.
        """
        return pulumi.get(self, "summaries")


@pulumi.output_type
class GetSubscriptionRewardsRewardCollectionItemItemResult(dict):
    def __init__(__self__, *,
                 available_rewards: float,
                 earned_rewards: float,
                 eligible_usage_amount: float,
                 ineligible_usage_amount: float,
                 is_manual: bool,
                 redeemed_rewards: float,
                 time_rewards_earned: str,
                 time_rewards_expired: str,
                 time_usage_ended: str,
                 time_usage_started: str,
                 usage_amount: float,
                 usage_period_key: str):
        """
        :param float available_rewards: The number of rewards available for a specific usage period.
        :param float earned_rewards: The number of rewards earned for the specific usage period.
        :param float eligible_usage_amount: The eligible usage amount for the usage period.
        :param float ineligible_usage_amount: The ineligible usage amount for the usage period.
        :param bool is_manual: The boolean parameter to indicate whether or not the available rewards are manually posted.
        :param float redeemed_rewards: The number of rewards redeemed for a specific month.
        :param str time_rewards_earned: The date and time when rewards accrue.
        :param str time_rewards_expired: The date and time when rewards expire.
        :param str time_usage_ended: The end date and time for the usage period.
        :param str time_usage_started: The start date and time for the usage period.
        :param float usage_amount: The usage amount for the usage period.
        :param str usage_period_key: The usage period ID.
        """
        GetSubscriptionRewardsRewardCollectionItemItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            available_rewards=available_rewards,
            earned_rewards=earned_rewards,
            eligible_usage_amount=eligible_usage_amount,
            ineligible_usage_amount=ineligible_usage_amount,
            is_manual=is_manual,
            redeemed_rewards=redeemed_rewards,
            time_rewards_earned=time_rewards_earned,
            time_rewards_expired=time_rewards_expired,
            time_usage_ended=time_usage_ended,
            time_usage_started=time_usage_started,
            usage_amount=usage_amount,
            usage_period_key=usage_period_key,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             available_rewards: float,
             earned_rewards: float,
             eligible_usage_amount: float,
             ineligible_usage_amount: float,
             is_manual: bool,
             redeemed_rewards: float,
             time_rewards_earned: str,
             time_rewards_expired: str,
             time_usage_ended: str,
             time_usage_started: str,
             usage_amount: float,
             usage_period_key: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("available_rewards", available_rewards)
        _setter("earned_rewards", earned_rewards)
        _setter("eligible_usage_amount", eligible_usage_amount)
        _setter("ineligible_usage_amount", ineligible_usage_amount)
        _setter("is_manual", is_manual)
        _setter("redeemed_rewards", redeemed_rewards)
        _setter("time_rewards_earned", time_rewards_earned)
        _setter("time_rewards_expired", time_rewards_expired)
        _setter("time_usage_ended", time_usage_ended)
        _setter("time_usage_started", time_usage_started)
        _setter("usage_amount", usage_amount)
        _setter("usage_period_key", usage_period_key)

    @property
    @pulumi.getter(name="availableRewards")
    def available_rewards(self) -> float:
        """
        The number of rewards available for a specific usage period.
        """
        return pulumi.get(self, "available_rewards")

    @property
    @pulumi.getter(name="earnedRewards")
    def earned_rewards(self) -> float:
        """
        The number of rewards earned for the specific usage period.
        """
        return pulumi.get(self, "earned_rewards")

    @property
    @pulumi.getter(name="eligibleUsageAmount")
    def eligible_usage_amount(self) -> float:
        """
        The eligible usage amount for the usage period.
        """
        return pulumi.get(self, "eligible_usage_amount")

    @property
    @pulumi.getter(name="ineligibleUsageAmount")
    def ineligible_usage_amount(self) -> float:
        """
        The ineligible usage amount for the usage period.
        """
        return pulumi.get(self, "ineligible_usage_amount")

    @property
    @pulumi.getter(name="isManual")
    def is_manual(self) -> bool:
        """
        The boolean parameter to indicate whether or not the available rewards are manually posted.
        """
        return pulumi.get(self, "is_manual")

    @property
    @pulumi.getter(name="redeemedRewards")
    def redeemed_rewards(self) -> float:
        """
        The number of rewards redeemed for a specific month.
        """
        return pulumi.get(self, "redeemed_rewards")

    @property
    @pulumi.getter(name="timeRewardsEarned")
    def time_rewards_earned(self) -> str:
        """
        The date and time when rewards accrue.
        """
        return pulumi.get(self, "time_rewards_earned")

    @property
    @pulumi.getter(name="timeRewardsExpired")
    def time_rewards_expired(self) -> str:
        """
        The date and time when rewards expire.
        """
        return pulumi.get(self, "time_rewards_expired")

    @property
    @pulumi.getter(name="timeUsageEnded")
    def time_usage_ended(self) -> str:
        """
        The end date and time for the usage period.
        """
        return pulumi.get(self, "time_usage_ended")

    @property
    @pulumi.getter(name="timeUsageStarted")
    def time_usage_started(self) -> str:
        """
        The start date and time for the usage period.
        """
        return pulumi.get(self, "time_usage_started")

    @property
    @pulumi.getter(name="usageAmount")
    def usage_amount(self) -> float:
        """
        The usage amount for the usage period.
        """
        return pulumi.get(self, "usage_amount")

    @property
    @pulumi.getter(name="usagePeriodKey")
    def usage_period_key(self) -> str:
        """
        The usage period ID.
        """
        return pulumi.get(self, "usage_period_key")


@pulumi.output_type
class GetSubscriptionRewardsRewardCollectionItemSummaryResult(dict):
    def __init__(__self__, *,
                 currency: str,
                 redemption_code: str,
                 rewards_rate: float,
                 subscription_id: str,
                 tenancy_id: str,
                 total_rewards_available: float):
        """
        :param str currency: The currency unit for the reward amount.
        :param str redemption_code: The redemption code used in the Billing Center during the reward redemption process.
        :param float rewards_rate: The current Rewards percentage in decimal format.
        :param str subscription_id: The subscription ID for which rewards information is requested for.
        :param str tenancy_id: The OCID of the tenancy.
        :param float total_rewards_available: The total number of available rewards for a given subscription ID.
        """
        GetSubscriptionRewardsRewardCollectionItemSummaryResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            currency=currency,
            redemption_code=redemption_code,
            rewards_rate=rewards_rate,
            subscription_id=subscription_id,
            tenancy_id=tenancy_id,
            total_rewards_available=total_rewards_available,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             currency: str,
             redemption_code: str,
             rewards_rate: float,
             subscription_id: str,
             tenancy_id: str,
             total_rewards_available: float,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("currency", currency)
        _setter("redemption_code", redemption_code)
        _setter("rewards_rate", rewards_rate)
        _setter("subscription_id", subscription_id)
        _setter("tenancy_id", tenancy_id)
        _setter("total_rewards_available", total_rewards_available)

    @property
    @pulumi.getter
    def currency(self) -> str:
        """
        The currency unit for the reward amount.
        """
        return pulumi.get(self, "currency")

    @property
    @pulumi.getter(name="redemptionCode")
    def redemption_code(self) -> str:
        """
        The redemption code used in the Billing Center during the reward redemption process.
        """
        return pulumi.get(self, "redemption_code")

    @property
    @pulumi.getter(name="rewardsRate")
    def rewards_rate(self) -> float:
        """
        The current Rewards percentage in decimal format.
        """
        return pulumi.get(self, "rewards_rate")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        The subscription ID for which rewards information is requested for.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        The OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="totalRewardsAvailable")
    def total_rewards_available(self) -> float:
        """
        The total number of available rewards for a given subscription ID.
        """
        return pulumi.get(self, "total_rewards_available")


@pulumi.output_type
class GetUsagelimitsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetUsagelimitsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetUsagelimitsUsageLimitCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetUsagelimitsUsageLimitCollectionItemResult']):
        """
        :param Sequence['GetUsagelimitsUsageLimitCollectionItemArgs'] items: The list of usage limits.
        """
        GetUsagelimitsUsageLimitCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetUsagelimitsUsageLimitCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetUsagelimitsUsageLimitCollectionItemResult']:
        """
        The list of usage limits.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetUsagelimitsUsageLimitCollectionItemResult(dict):
    def __init__(__self__, *,
                 action: str,
                 alert_level: float,
                 created_by: str,
                 entitlement_id: str,
                 id: str,
                 limit: str,
                 limit_type: str,
                 max_hard_limit: str,
                 modified_by: str,
                 resource_name: str,
                 service_name: str,
                 sku_part_id: str,
                 state: str,
                 time_created: str,
                 time_modified: str,
                 value_type: str):
        """
        :param str action: The action when usage limit is hit
        :param float alert_level: The alert level of the usage limit
        :param str created_by: The user who created the limit
        :param str entitlement_id: Entitlement ID of the usage limit
        :param str id: The usage limit ID
        :param str limit_type: Hard or soft limit. Hard limits lead to breaches, soft to alerts.
        :param str max_hard_limit: The maximum hard limit set for the usage limit
        :param str modified_by: The user who modified the limit
        :param str resource_name: The resource for which the limit is defined
        :param str service_name: The service for which the limit is defined
        :param str sku_part_id: The SKU for which the usage limit is set
        :param str state: The usage limit lifecycle state.
        :param str time_created: Time when the usage limit was created
        :param str time_modified: Time when the usage limit was modified
        :param str value_type: The value type of the usage limit
        """
        GetUsagelimitsUsageLimitCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action=action,
            alert_level=alert_level,
            created_by=created_by,
            entitlement_id=entitlement_id,
            id=id,
            limit=limit,
            limit_type=limit_type,
            max_hard_limit=max_hard_limit,
            modified_by=modified_by,
            resource_name=resource_name,
            service_name=service_name,
            sku_part_id=sku_part_id,
            state=state,
            time_created=time_created,
            time_modified=time_modified,
            value_type=value_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action: str,
             alert_level: float,
             created_by: str,
             entitlement_id: str,
             id: str,
             limit: str,
             limit_type: str,
             max_hard_limit: str,
             modified_by: str,
             resource_name: str,
             service_name: str,
             sku_part_id: str,
             state: str,
             time_created: str,
             time_modified: str,
             value_type: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("action", action)
        _setter("alert_level", alert_level)
        _setter("created_by", created_by)
        _setter("entitlement_id", entitlement_id)
        _setter("id", id)
        _setter("limit", limit)
        _setter("limit_type", limit_type)
        _setter("max_hard_limit", max_hard_limit)
        _setter("modified_by", modified_by)
        _setter("resource_name", resource_name)
        _setter("service_name", service_name)
        _setter("sku_part_id", sku_part_id)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_modified", time_modified)
        _setter("value_type", value_type)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action when usage limit is hit
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="alertLevel")
    def alert_level(self) -> float:
        """
        The alert level of the usage limit
        """
        return pulumi.get(self, "alert_level")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The user who created the limit
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="entitlementId")
    def entitlement_id(self) -> str:
        """
        Entitlement ID of the usage limit
        """
        return pulumi.get(self, "entitlement_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The usage limit ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def limit(self) -> str:
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter(name="limitType")
    def limit_type(self) -> str:
        """
        Hard or soft limit. Hard limits lead to breaches, soft to alerts.
        """
        return pulumi.get(self, "limit_type")

    @property
    @pulumi.getter(name="maxHardLimit")
    def max_hard_limit(self) -> str:
        """
        The maximum hard limit set for the usage limit
        """
        return pulumi.get(self, "max_hard_limit")

    @property
    @pulumi.getter(name="modifiedBy")
    def modified_by(self) -> str:
        """
        The user who modified the limit
        """
        return pulumi.get(self, "modified_by")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        The resource for which the limit is defined
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The service for which the limit is defined
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="skuPartId")
    def sku_part_id(self) -> str:
        """
        The SKU for which the usage limit is set
        """
        return pulumi.get(self, "sku_part_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The usage limit lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time when the usage limit was created
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> str:
        """
        Time when the usage limit was modified
        """
        return pulumi.get(self, "time_modified")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        The value type of the usage limit
        """
        return pulumi.get(self, "value_type")


