# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'SecretSecretContent',
    'SecretSecretRule',
    'GetSecretSecretContentResult',
    'GetSecretSecretRuleResult',
    'GetSecretsFilterResult',
    'GetSecretsSecretResult',
    'GetSecretsSecretSecretContentResult',
    'GetSecretsSecretSecretRuleResult',
]

@pulumi.output_type
class SecretSecretContent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretSecretContent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretSecretContent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretSecretContent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 content_type: str,
                 name: Optional[str] = None,
                 stage: Optional[str] = None):
        """
        :param str content: (Updatable) The base64-encoded content of the secret.
        :param str content_type: (Updatable) content type . Example `BASE64` .
        :param str name: (Updatable) Names should be unique within a secret. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        :param str stage: (Updatable) The rotation state of the secret content. The default is `CURRENT`, meaning that the secret is currently in use. A secret version that you mark as `PENDING` is staged and available for use, but you don't yet want to rotate it into current, active use. For example, you might create or update a secret and mark its rotation state as `PENDING` if you haven't yet updated the secret on the target system. When creating a secret, only the value `CURRENT` is applicable, although the value `LATEST` is also automatically applied. When updating  a secret, you can specify a version's rotation state as either `CURRENT` or `PENDING`.
        """
        SecretSecretContent._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            content_type=content_type,
            name=name,
            stage=stage,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: str,
             content_type: str,
             name: Optional[str] = None,
             stage: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("content", content)
        _setter("content_type", content_type)
        if name is not None:
            _setter("name", name)
        if stage is not None:
            _setter("stage", stage)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        (Updatable) The base64-encoded content of the secret.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        (Updatable) content type . Example `BASE64` .
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) Names should be unique within a secret. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def stage(self) -> Optional[str]:
        """
        (Updatable) The rotation state of the secret content. The default is `CURRENT`, meaning that the secret is currently in use. A secret version that you mark as `PENDING` is staged and available for use, but you don't yet want to rotate it into current, active use. For example, you might create or update a secret and mark its rotation state as `PENDING` if you haven't yet updated the secret on the target system. When creating a secret, only the value `CURRENT` is applicable, although the value `LATEST` is also automatically applied. When updating  a secret, you can specify a version's rotation state as either `CURRENT` or `PENDING`.
        """
        return pulumi.get(self, "stage")


@pulumi.output_type
class SecretSecretRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleType":
            suggest = "rule_type"
        elif key == "isEnforcedOnDeletedSecretVersions":
            suggest = "is_enforced_on_deleted_secret_versions"
        elif key == "isSecretContentRetrievalBlockedOnExpiry":
            suggest = "is_secret_content_retrieval_blocked_on_expiry"
        elif key == "secretVersionExpiryInterval":
            suggest = "secret_version_expiry_interval"
        elif key == "timeOfAbsoluteExpiry":
            suggest = "time_of_absolute_expiry"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretSecretRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretSecretRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretSecretRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule_type: str,
                 is_enforced_on_deleted_secret_versions: Optional[bool] = None,
                 is_secret_content_retrieval_blocked_on_expiry: Optional[bool] = None,
                 secret_version_expiry_interval: Optional[str] = None,
                 time_of_absolute_expiry: Optional[str] = None):
        """
        :param str rule_type: (Updatable) The type of rule, which either controls when the secret contents expire or whether they can be reused.
        :param bool is_enforced_on_deleted_secret_versions: (Updatable) A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        :param bool is_secret_content_retrieval_blocked_on_expiry: (Updatable) A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        :param str secret_version_expiry_interval: (Updatable) A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. No enforcement mechanism exists at this time, but audit logs record the expiration on the appropriate date, according to the time interval specified in the rule. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        :param str time_of_absolute_expiry: (Updatable) An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
        SecretSecretRule._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            rule_type=rule_type,
            is_enforced_on_deleted_secret_versions=is_enforced_on_deleted_secret_versions,
            is_secret_content_retrieval_blocked_on_expiry=is_secret_content_retrieval_blocked_on_expiry,
            secret_version_expiry_interval=secret_version_expiry_interval,
            time_of_absolute_expiry=time_of_absolute_expiry,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             rule_type: str,
             is_enforced_on_deleted_secret_versions: Optional[bool] = None,
             is_secret_content_retrieval_blocked_on_expiry: Optional[bool] = None,
             secret_version_expiry_interval: Optional[str] = None,
             time_of_absolute_expiry: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("rule_type", rule_type)
        if is_enforced_on_deleted_secret_versions is not None:
            _setter("is_enforced_on_deleted_secret_versions", is_enforced_on_deleted_secret_versions)
        if is_secret_content_retrieval_blocked_on_expiry is not None:
            _setter("is_secret_content_retrieval_blocked_on_expiry", is_secret_content_retrieval_blocked_on_expiry)
        if secret_version_expiry_interval is not None:
            _setter("secret_version_expiry_interval", secret_version_expiry_interval)
        if time_of_absolute_expiry is not None:
            _setter("time_of_absolute_expiry", time_of_absolute_expiry)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        (Updatable) The type of rule, which either controls when the secret contents expire or whether they can be reused.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter(name="isEnforcedOnDeletedSecretVersions")
    def is_enforced_on_deleted_secret_versions(self) -> Optional[bool]:
        """
        (Updatable) A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        """
        return pulumi.get(self, "is_enforced_on_deleted_secret_versions")

    @property
    @pulumi.getter(name="isSecretContentRetrievalBlockedOnExpiry")
    def is_secret_content_retrieval_blocked_on_expiry(self) -> Optional[bool]:
        """
        (Updatable) A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        """
        return pulumi.get(self, "is_secret_content_retrieval_blocked_on_expiry")

    @property
    @pulumi.getter(name="secretVersionExpiryInterval")
    def secret_version_expiry_interval(self) -> Optional[str]:
        """
        (Updatable) A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. No enforcement mechanism exists at this time, but audit logs record the expiration on the appropriate date, according to the time interval specified in the rule. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        """
        return pulumi.get(self, "secret_version_expiry_interval")

    @property
    @pulumi.getter(name="timeOfAbsoluteExpiry")
    def time_of_absolute_expiry(self) -> Optional[str]:
        """
        (Updatable) An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_absolute_expiry")


@pulumi.output_type
class GetSecretSecretContentResult(dict):
    def __init__(__self__, *,
                 content: str,
                 content_type: str,
                 name: str,
                 stage: str):
        GetSecretSecretContentResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            content_type=content_type,
            name=name,
            stage=stage,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: str,
             content_type: str,
             name: str,
             stage: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("content", content)
        _setter("content_type", content_type)
        _setter("name", name)
        _setter("stage", stage)

    @property
    @pulumi.getter
    def content(self) -> str:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def stage(self) -> str:
        return pulumi.get(self, "stage")


@pulumi.output_type
class GetSecretSecretRuleResult(dict):
    def __init__(__self__, *,
                 is_enforced_on_deleted_secret_versions: bool,
                 is_secret_content_retrieval_blocked_on_expiry: bool,
                 rule_type: str,
                 secret_version_expiry_interval: str,
                 time_of_absolute_expiry: str):
        """
        :param bool is_enforced_on_deleted_secret_versions: A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        :param bool is_secret_content_retrieval_blocked_on_expiry: A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        :param str rule_type: The type of rule, which either controls when the secret contents expire or whether they can be reused.
        :param str secret_version_expiry_interval: A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. No enforcement mechanism exists at this time, but audit logs record the expiration on the appropriate date, according to the time interval specified in the rule. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        :param str time_of_absolute_expiry: An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
        GetSecretSecretRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_enforced_on_deleted_secret_versions=is_enforced_on_deleted_secret_versions,
            is_secret_content_retrieval_blocked_on_expiry=is_secret_content_retrieval_blocked_on_expiry,
            rule_type=rule_type,
            secret_version_expiry_interval=secret_version_expiry_interval,
            time_of_absolute_expiry=time_of_absolute_expiry,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_enforced_on_deleted_secret_versions: bool,
             is_secret_content_retrieval_blocked_on_expiry: bool,
             rule_type: str,
             secret_version_expiry_interval: str,
             time_of_absolute_expiry: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("is_enforced_on_deleted_secret_versions", is_enforced_on_deleted_secret_versions)
        _setter("is_secret_content_retrieval_blocked_on_expiry", is_secret_content_retrieval_blocked_on_expiry)
        _setter("rule_type", rule_type)
        _setter("secret_version_expiry_interval", secret_version_expiry_interval)
        _setter("time_of_absolute_expiry", time_of_absolute_expiry)

    @property
    @pulumi.getter(name="isEnforcedOnDeletedSecretVersions")
    def is_enforced_on_deleted_secret_versions(self) -> bool:
        """
        A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        """
        return pulumi.get(self, "is_enforced_on_deleted_secret_versions")

    @property
    @pulumi.getter(name="isSecretContentRetrievalBlockedOnExpiry")
    def is_secret_content_retrieval_blocked_on_expiry(self) -> bool:
        """
        A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        """
        return pulumi.get(self, "is_secret_content_retrieval_blocked_on_expiry")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The type of rule, which either controls when the secret contents expire or whether they can be reused.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter(name="secretVersionExpiryInterval")
    def secret_version_expiry_interval(self) -> str:
        """
        A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. No enforcement mechanism exists at this time, but audit logs record the expiration on the appropriate date, according to the time interval specified in the rule. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        """
        return pulumi.get(self, "secret_version_expiry_interval")

    @property
    @pulumi.getter(name="timeOfAbsoluteExpiry")
    def time_of_absolute_expiry(self) -> str:
        """
        An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_absolute_expiry")


@pulumi.output_type
class GetSecretsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The secret name.
        """
        GetSecretsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The secret name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSecretsSecretResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 current_version_number: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 key_id: str,
                 lifecycle_details: str,
                 metadata: Mapping[str, Any],
                 secret_contents: Sequence['outputs.GetSecretsSecretSecretContentResult'],
                 secret_name: str,
                 secret_rules: Sequence['outputs.GetSecretsSecretSecretRuleResult'],
                 state: str,
                 time_created: str,
                 time_of_current_version_expiry: str,
                 time_of_deletion: str,
                 vault_id: str):
        """
        :param str compartment_id: The OCID of the compartment.
        :param str current_version_number: The version number of the secret version that's currently in use.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str description: A brief description of the secret. Avoid entering confidential information.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the secret.
        :param str key_id: The OCID of the master encryption key that is used to encrypt the secret.
        :param str lifecycle_details: Additional information about the current lifecycle state of the secret.
        :param Mapping[str, Any] metadata: Additional metadata that you can use to provide context about how to use the secret or during rotation or other administrative tasks. For example, for a secret that you use to connect to a database, the additional metadata might specify the connection endpoint and the connection string. Provide additional metadata as key-value pairs.
        :param str secret_name: The user-friendly name of the secret. Avoid entering confidential information.
        :param Sequence['GetSecretsSecretSecretRuleArgs'] secret_rules: A list of rules that control how the secret is used and managed.
        :param str state: A filter that returns only resources that match the specified lifecycle state. The state value is case-insensitive.
        :param str time_created: A property indicating when the secret was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param str time_of_current_version_expiry: An optional property indicating when the current secret version will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param str time_of_deletion: An optional property indicating when to delete the secret, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param str vault_id: The OCID of the vault.
        """
        GetSecretsSecretResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            current_version_number=current_version_number,
            defined_tags=defined_tags,
            description=description,
            freeform_tags=freeform_tags,
            id=id,
            key_id=key_id,
            lifecycle_details=lifecycle_details,
            metadata=metadata,
            secret_contents=secret_contents,
            secret_name=secret_name,
            secret_rules=secret_rules,
            state=state,
            time_created=time_created,
            time_of_current_version_expiry=time_of_current_version_expiry,
            time_of_deletion=time_of_deletion,
            vault_id=vault_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             current_version_number: str,
             defined_tags: Mapping[str, Any],
             description: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             key_id: str,
             lifecycle_details: str,
             metadata: Mapping[str, Any],
             secret_contents: Sequence['outputs.GetSecretsSecretSecretContentResult'],
             secret_name: str,
             secret_rules: Sequence['outputs.GetSecretsSecretSecretRuleResult'],
             state: str,
             time_created: str,
             time_of_current_version_expiry: str,
             time_of_deletion: str,
             vault_id: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("compartment_id", compartment_id)
        _setter("current_version_number", current_version_number)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("key_id", key_id)
        _setter("lifecycle_details", lifecycle_details)
        _setter("metadata", metadata)
        _setter("secret_contents", secret_contents)
        _setter("secret_name", secret_name)
        _setter("secret_rules", secret_rules)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("time_of_current_version_expiry", time_of_current_version_expiry)
        _setter("time_of_deletion", time_of_deletion)
        _setter("vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="currentVersionNumber")
    def current_version_number(self) -> str:
        """
        The version number of the secret version that's currently in use.
        """
        return pulumi.get(self, "current_version_number")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A brief description of the secret. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the secret.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        The OCID of the master encryption key that is used to encrypt the secret.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state of the secret.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, Any]:
        """
        Additional metadata that you can use to provide context about how to use the secret or during rotation or other administrative tasks. For example, for a secret that you use to connect to a database, the additional metadata might specify the connection endpoint and the connection string. Provide additional metadata as key-value pairs.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="secretContents")
    def secret_contents(self) -> Sequence['outputs.GetSecretsSecretSecretContentResult']:
        return pulumi.get(self, "secret_contents")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> str:
        """
        The user-friendly name of the secret. Avoid entering confidential information.
        """
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter(name="secretRules")
    def secret_rules(self) -> Sequence['outputs.GetSecretsSecretSecretRuleResult']:
        """
        A list of rules that control how the secret is used and managed.
        """
        return pulumi.get(self, "secret_rules")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter that returns only resources that match the specified lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        A property indicating when the secret was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfCurrentVersionExpiry")
    def time_of_current_version_expiry(self) -> str:
        """
        An optional property indicating when the current secret version will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_current_version_expiry")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        An optional property indicating when to delete the secret, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The OCID of the vault.
        """
        return pulumi.get(self, "vault_id")


@pulumi.output_type
class GetSecretsSecretSecretContentResult(dict):
    def __init__(__self__, *,
                 content: str,
                 content_type: str,
                 name: str,
                 stage: str):
        """
        :param str name: The secret name.
        """
        GetSecretsSecretSecretContentResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            content_type=content_type,
            name=name,
            stage=stage,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: str,
             content_type: str,
             name: str,
             stage: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("content", content)
        _setter("content_type", content_type)
        _setter("name", name)
        _setter("stage", stage)

    @property
    @pulumi.getter
    def content(self) -> str:
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The secret name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def stage(self) -> str:
        return pulumi.get(self, "stage")


@pulumi.output_type
class GetSecretsSecretSecretRuleResult(dict):
    def __init__(__self__, *,
                 is_enforced_on_deleted_secret_versions: bool,
                 is_secret_content_retrieval_blocked_on_expiry: bool,
                 rule_type: str,
                 secret_version_expiry_interval: str,
                 time_of_absolute_expiry: str):
        """
        :param bool is_enforced_on_deleted_secret_versions: A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        :param bool is_secret_content_retrieval_blocked_on_expiry: A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        :param str rule_type: The type of rule, which either controls when the secret contents expire or whether they can be reused.
        :param str secret_version_expiry_interval: A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. No enforcement mechanism exists at this time, but audit logs record the expiration on the appropriate date, according to the time interval specified in the rule. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        :param str time_of_absolute_expiry: An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
        GetSecretsSecretSecretRuleResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_enforced_on_deleted_secret_versions=is_enforced_on_deleted_secret_versions,
            is_secret_content_retrieval_blocked_on_expiry=is_secret_content_retrieval_blocked_on_expiry,
            rule_type=rule_type,
            secret_version_expiry_interval=secret_version_expiry_interval,
            time_of_absolute_expiry=time_of_absolute_expiry,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_enforced_on_deleted_secret_versions: bool,
             is_secret_content_retrieval_blocked_on_expiry: bool,
             rule_type: str,
             secret_version_expiry_interval: str,
             time_of_absolute_expiry: str,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("is_enforced_on_deleted_secret_versions", is_enforced_on_deleted_secret_versions)
        _setter("is_secret_content_retrieval_blocked_on_expiry", is_secret_content_retrieval_blocked_on_expiry)
        _setter("rule_type", rule_type)
        _setter("secret_version_expiry_interval", secret_version_expiry_interval)
        _setter("time_of_absolute_expiry", time_of_absolute_expiry)

    @property
    @pulumi.getter(name="isEnforcedOnDeletedSecretVersions")
    def is_enforced_on_deleted_secret_versions(self) -> bool:
        """
        A property indicating whether the rule is applied even if the secret version with the content you are trying to reuse was deleted.
        """
        return pulumi.get(self, "is_enforced_on_deleted_secret_versions")

    @property
    @pulumi.getter(name="isSecretContentRetrievalBlockedOnExpiry")
    def is_secret_content_retrieval_blocked_on_expiry(self) -> bool:
        """
        A property indicating whether to block retrieval of the secret content, on expiry. The default is false. If the secret has already expired and you would like to retrieve the secret contents, you need to edit the secret rule to disable this property, to allow reading the secret content.
        """
        return pulumi.get(self, "is_secret_content_retrieval_blocked_on_expiry")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> str:
        """
        The type of rule, which either controls when the secret contents expire or whether they can be reused.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter(name="secretVersionExpiryInterval")
    def secret_version_expiry_interval(self) -> str:
        """
        A property indicating how long the secret contents will be considered valid, expressed in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) format. The secret needs to be updated when the secret content expires. No enforcement mechanism exists at this time, but audit logs record the expiration on the appropriate date, according to the time interval specified in the rule. The timer resets after you update the secret contents. The minimum value is 1 day and the maximum value is 90 days for this property. Currently, only intervals expressed in days are supported. For example, pass `P3D` to have the secret version expire every 3 days.
        """
        return pulumi.get(self, "secret_version_expiry_interval")

    @property
    @pulumi.getter(name="timeOfAbsoluteExpiry")
    def time_of_absolute_expiry(self) -> str:
        """
        An optional property indicating the absolute time when this secret will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. The minimum number of days from current time is 1 day and the maximum number of days from current time is 365 days. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_absolute_expiry")


