# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List


class Config(TeaModel):
    """
    Model for initing client
    """
    def __init__(
        self,
        access_key_id: str = None,
        access_key_secret: str = None,
        security_token: str = None,
        protocol: str = None,
        read_timeout: int = None,
        connect_timeout: int = None,
        http_proxy: str = None,
        https_proxy: str = None,
        endpoint: str = None,
        no_proxy: str = None,
        max_idle_conns: int = None,
        user_agent: str = None,
        socks_5proxy: str = None,
        socks_5net_work: str = None,
        max_idle_time_millis: int = None,
        keep_alive_duration_millis: int = None,
        max_requests: int = None,
        max_requests_per_host: int = None,
    ):
        # accesskey id
        self.access_key_id = access_key_id
        # accesskey secret
        self.access_key_secret = access_key_secret
        # security token
        self.security_token = security_token
        # http protocol
        self.protocol = protocol
        # read timeout
        self.read_timeout = read_timeout
        # connect timeout
        self.connect_timeout = connect_timeout
        # http proxy
        self.http_proxy = http_proxy
        # https proxy
        self.https_proxy = https_proxy
        # endpoint
        self.endpoint = endpoint
        # proxy white list
        self.no_proxy = no_proxy
        # max idle conns
        self.max_idle_conns = max_idle_conns
        # user agent
        self.user_agent = user_agent
        # socks5 proxy
        self.socks_5proxy = socks_5proxy
        # socks5 network
        self.socks_5net_work = socks_5net_work
        # 长链接最大空闲时长
        self.max_idle_time_millis = max_idle_time_millis
        # 长链接最大连接时长
        self.keep_alive_duration_millis = keep_alive_duration_millis
        # 最大连接数（长链接最大总数）
        self.max_requests = max_requests
        # 每个目标主机的最大连接数（分主机域名的长链接最大总数
        self.max_requests_per_host = max_requests_per_host

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.access_key_id is not None:
            result['accessKeyId'] = self.access_key_id
        if self.access_key_secret is not None:
            result['accessKeySecret'] = self.access_key_secret
        if self.security_token is not None:
            result['securityToken'] = self.security_token
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.read_timeout is not None:
            result['readTimeout'] = self.read_timeout
        if self.connect_timeout is not None:
            result['connectTimeout'] = self.connect_timeout
        if self.http_proxy is not None:
            result['httpProxy'] = self.http_proxy
        if self.https_proxy is not None:
            result['httpsProxy'] = self.https_proxy
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        if self.no_proxy is not None:
            result['noProxy'] = self.no_proxy
        if self.max_idle_conns is not None:
            result['maxIdleConns'] = self.max_idle_conns
        if self.user_agent is not None:
            result['userAgent'] = self.user_agent
        if self.socks_5proxy is not None:
            result['socks5Proxy'] = self.socks_5proxy
        if self.socks_5net_work is not None:
            result['socks5NetWork'] = self.socks_5net_work
        if self.max_idle_time_millis is not None:
            result['maxIdleTimeMillis'] = self.max_idle_time_millis
        if self.keep_alive_duration_millis is not None:
            result['keepAliveDurationMillis'] = self.keep_alive_duration_millis
        if self.max_requests is not None:
            result['maxRequests'] = self.max_requests
        if self.max_requests_per_host is not None:
            result['maxRequestsPerHost'] = self.max_requests_per_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessKeyId') is not None:
            self.access_key_id = m.get('accessKeyId')
        if m.get('accessKeySecret') is not None:
            self.access_key_secret = m.get('accessKeySecret')
        if m.get('securityToken') is not None:
            self.security_token = m.get('securityToken')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('readTimeout') is not None:
            self.read_timeout = m.get('readTimeout')
        if m.get('connectTimeout') is not None:
            self.connect_timeout = m.get('connectTimeout')
        if m.get('httpProxy') is not None:
            self.http_proxy = m.get('httpProxy')
        if m.get('httpsProxy') is not None:
            self.https_proxy = m.get('httpsProxy')
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        if m.get('noProxy') is not None:
            self.no_proxy = m.get('noProxy')
        if m.get('maxIdleConns') is not None:
            self.max_idle_conns = m.get('maxIdleConns')
        if m.get('userAgent') is not None:
            self.user_agent = m.get('userAgent')
        if m.get('socks5Proxy') is not None:
            self.socks_5proxy = m.get('socks5Proxy')
        if m.get('socks5NetWork') is not None:
            self.socks_5net_work = m.get('socks5NetWork')
        if m.get('maxIdleTimeMillis') is not None:
            self.max_idle_time_millis = m.get('maxIdleTimeMillis')
        if m.get('keepAliveDurationMillis') is not None:
            self.keep_alive_duration_millis = m.get('keepAliveDurationMillis')
        if m.get('maxRequests') is not None:
            self.max_requests = m.get('maxRequests')
        if m.get('maxRequestsPerHost') is not None:
            self.max_requests_per_host = m.get('maxRequestsPerHost')
        return self


class VoucherTestOne(TeaModel):
    def __init__(
        self,
        voucher_test_one_long: int = None,
        voucher_test_one_string: str = None,
        voucher_test_one_int: int = None,
        voucher_test_one_date: str = None,
        voucher_test_one_integer: int = None,
        voucher_test_one_boolean: bool = None,
    ):
        # 测试Long
        self.voucher_test_one_long = voucher_test_one_long
        # 测试String
        self.voucher_test_one_string = voucher_test_one_string
        # 测试Int
        self.voucher_test_one_int = voucher_test_one_int
        # 测试Date
        self.voucher_test_one_date = voucher_test_one_date
        # 测试Integer
        self.voucher_test_one_integer = voucher_test_one_integer
        # 测试Boolean
        self.voucher_test_one_boolean = voucher_test_one_boolean

    def validate(self):
        self.validate_required(self.voucher_test_one_long, 'voucher_test_one_long')
        if self.voucher_test_one_long is not None:
            self.validate_maximum(self.voucher_test_one_long, 'voucher_test_one_long', 10)
            self.validate_minimum(self.voucher_test_one_long, 'voucher_test_one_long', 0)
        self.validate_required(self.voucher_test_one_string, 'voucher_test_one_string')
        if self.voucher_test_one_string is not None:
            self.validate_max_length(self.voucher_test_one_string, 'voucher_test_one_string', 10)
        self.validate_required(self.voucher_test_one_int, 'voucher_test_one_int')
        self.validate_required(self.voucher_test_one_date, 'voucher_test_one_date')
        if self.voucher_test_one_date is not None:
            self.validate_pattern(self.voucher_test_one_date, 'voucher_test_one_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.voucher_test_one_integer, 'voucher_test_one_integer')
        if self.voucher_test_one_integer is not None:
            self.validate_maximum(self.voucher_test_one_integer, 'voucher_test_one_integer', 10)
            self.validate_minimum(self.voucher_test_one_integer, 'voucher_test_one_integer', 0)
        self.validate_required(self.voucher_test_one_boolean, 'voucher_test_one_boolean')

    def to_map(self):
        result = dict()
        if self.voucher_test_one_long is not None:
            result['voucher_test_one_long'] = self.voucher_test_one_long
        if self.voucher_test_one_string is not None:
            result['voucher_test_one_string'] = self.voucher_test_one_string
        if self.voucher_test_one_int is not None:
            result['voucher_test_one_int'] = self.voucher_test_one_int
        if self.voucher_test_one_date is not None:
            result['voucher_test_one_date'] = self.voucher_test_one_date
        if self.voucher_test_one_integer is not None:
            result['voucher_test_one_integer'] = self.voucher_test_one_integer
        if self.voucher_test_one_boolean is not None:
            result['voucher_test_one_boolean'] = self.voucher_test_one_boolean
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('voucher_test_one_long') is not None:
            self.voucher_test_one_long = m.get('voucher_test_one_long')
        if m.get('voucher_test_one_string') is not None:
            self.voucher_test_one_string = m.get('voucher_test_one_string')
        if m.get('voucher_test_one_int') is not None:
            self.voucher_test_one_int = m.get('voucher_test_one_int')
        if m.get('voucher_test_one_date') is not None:
            self.voucher_test_one_date = m.get('voucher_test_one_date')
        if m.get('voucher_test_one_integer') is not None:
            self.voucher_test_one_integer = m.get('voucher_test_one_integer')
        if m.get('voucher_test_one_boolean') is not None:
            self.voucher_test_one_boolean = m.get('voucher_test_one_boolean')
        return self


class PayTariffInfo(TeaModel):
    def __init__(
        self,
        order_no: str = None,
        pay_tariff_code: str = None,
        pay_tariff_project: str = None,
        pay_tariff_desc: str = None,
        currency: str = None,
        price_including_tax: str = None,
        booking_no: str = None,
        bkg_no: str = None,
    ):
        # 托运单号 [业务必填]
        self.order_no = order_no
        # 应付资费项code [业务必填]
        # 
        # 
        self.pay_tariff_code = pay_tariff_code
        # 应付资费项项目 [业务必填]
        # 
        # 
        self.pay_tariff_project = pay_tariff_project
        # 资费项中文描述 [业务必填]
        # 
        # 
        self.pay_tariff_desc = pay_tariff_desc
        # 币种 [业务必填]
        self.currency = currency
        # 资费项含税价 [业务必填]
        # 
        # 
        self.price_including_tax = price_including_tax
        # 订舱单唯一性标识 [业务必填]
        self.booking_no = booking_no
        # 订舱单 [业务必填]
        self.bkg_no = bkg_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.pay_tariff_code is not None:
            result['pay_tariff_code'] = self.pay_tariff_code
        if self.pay_tariff_project is not None:
            result['pay_tariff_project'] = self.pay_tariff_project
        if self.pay_tariff_desc is not None:
            result['pay_tariff_desc'] = self.pay_tariff_desc
        if self.currency is not None:
            result['currency'] = self.currency
        if self.price_including_tax is not None:
            result['price_including_tax'] = self.price_including_tax
        if self.booking_no is not None:
            result['booking_no'] = self.booking_no
        if self.bkg_no is not None:
            result['bkg_no'] = self.bkg_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('pay_tariff_code') is not None:
            self.pay_tariff_code = m.get('pay_tariff_code')
        if m.get('pay_tariff_project') is not None:
            self.pay_tariff_project = m.get('pay_tariff_project')
        if m.get('pay_tariff_desc') is not None:
            self.pay_tariff_desc = m.get('pay_tariff_desc')
        if m.get('currency') is not None:
            self.currency = m.get('currency')
        if m.get('price_including_tax') is not None:
            self.price_including_tax = m.get('price_including_tax')
        if m.get('booking_no') is not None:
            self.booking_no = m.get('booking_no')
        if m.get('bkg_no') is not None:
            self.bkg_no = m.get('bkg_no')
        return self


class PersonLoss(TeaModel):
    def __init__(
        self,
        person_injured_condition: str = None,
        person_injured_name: str = None,
        person_loss_estimate_amount: str = None,
    ):
        # 伤情，HOSPITALIZE-住院，CLINIC-门诊，DEATH-死亡，ALLOWANCE-津贴
        self.person_injured_condition = person_injured_condition
        # 伤者姓名
        self.person_injured_name = person_injured_name
        # 损失预估，单位（元），最多支持2位小数
        self.person_loss_estimate_amount = person_loss_estimate_amount

    def validate(self):
        self.validate_required(self.person_injured_condition, 'person_injured_condition')
        if self.person_injured_condition is not None:
            self.validate_max_length(self.person_injured_condition, 'person_injured_condition', 50)
        self.validate_required(self.person_injured_name, 'person_injured_name')
        if self.person_injured_name is not None:
            self.validate_max_length(self.person_injured_name, 'person_injured_name', 200)

    def to_map(self):
        result = dict()
        if self.person_injured_condition is not None:
            result['person_injured_condition'] = self.person_injured_condition
        if self.person_injured_name is not None:
            result['person_injured_name'] = self.person_injured_name
        if self.person_loss_estimate_amount is not None:
            result['person_loss_estimate_amount'] = self.person_loss_estimate_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('person_injured_condition') is not None:
            self.person_injured_condition = m.get('person_injured_condition')
        if m.get('person_injured_name') is not None:
            self.person_injured_name = m.get('person_injured_name')
        if m.get('person_loss_estimate_amount') is not None:
            self.person_loss_estimate_amount = m.get('person_loss_estimate_amount')
        return self


class ContainerInfo(TeaModel):
    def __init__(
        self,
        booking_no: str = None,
        container_id: str = None,
        container_no: str = None,
        container_type: str = None,
    ):
        # 订舱单唯一标识
        self.booking_no = booking_no
        # 集装箱唯一标识
        self.container_id = container_id
        # 箱号
        self.container_no = container_no
        # 箱型
        self.container_type = container_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.booking_no is not None:
            result['booking_no'] = self.booking_no
        if self.container_id is not None:
            result['container_id'] = self.container_id
        if self.container_no is not None:
            result['container_no'] = self.container_no
        if self.container_type is not None:
            result['container_type'] = self.container_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('booking_no') is not None:
            self.booking_no = m.get('booking_no')
        if m.get('container_id') is not None:
            self.container_id = m.get('container_id')
        if m.get('container_no') is not None:
            self.container_no = m.get('container_no')
        if m.get('container_type') is not None:
            self.container_type = m.get('container_type')
        return self


class MasterBlContainerParam(TeaModel):
    def __init__(
        self,
        action: str = None,
        container_id: str = None,
        container_no: str = None,
    ):
        # 操作动作,为空为新增或更新，UPDATE为更新，DELETE为删除
        self.action = action
        # 集装箱ID
        self.container_id = container_id
        # 箱号
        self.container_no = container_no

    def validate(self):
        self.validate_required(self.container_id, 'container_id')

    def to_map(self):
        result = dict()
        if self.action is not None:
            result['action'] = self.action
        if self.container_id is not None:
            result['container_id'] = self.container_id
        if self.container_no is not None:
            result['container_no'] = self.container_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('container_id') is not None:
            self.container_id = m.get('container_id')
        if m.get('container_no') is not None:
            self.container_no = m.get('container_no')
        return self


class ScpTicketIssueData(TeaModel):
    def __init__(
        self,
        did: str = None,
        issue_id: str = None,
    ):
        # 凭证对应的司机/货主的did
        self.did = did
        # 
        # 凭证id
        self.issue_id = issue_id

    def validate(self):
        self.validate_required(self.did, 'did')
        self.validate_required(self.issue_id, 'issue_id')

    def to_map(self):
        result = dict()
        if self.did is not None:
            result['did'] = self.did
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('did') is not None:
            self.did = m.get('did')
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        return self


class CustomsOrderBookingParam(TeaModel):
    def __init__(
        self,
        action: str = None,
        booking_no: str = None,
    ):
        # 操作动作,为空为新增或更新，UPDATE为更新，DELETE为删除
        self.action = action
        # 订舱单号
        self.booking_no = booking_no

    def validate(self):
        self.validate_required(self.booking_no, 'booking_no')

    def to_map(self):
        result = dict()
        if self.action is not None:
            result['action'] = self.action
        if self.booking_no is not None:
            result['booking_no'] = self.booking_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('booking_no') is not None:
            self.booking_no = m.get('booking_no')
        return self


class EblStatusDeatil(TeaModel):
    def __init__(
        self,
        current_ebl_status: str = None,
        ebl_no: str = None,
        next_ebl_status: str = None,
    ):
        # 当前提单状态
        self.current_ebl_status = current_ebl_status
        # 电子提单编号
        self.ebl_no = ebl_no
        # 下一个提单状态
        self.next_ebl_status = next_ebl_status

    def validate(self):
        self.validate_required(self.current_ebl_status, 'current_ebl_status')
        self.validate_required(self.ebl_no, 'ebl_no')
        self.validate_required(self.next_ebl_status, 'next_ebl_status')

    def to_map(self):
        result = dict()
        if self.current_ebl_status is not None:
            result['current_ebl_status'] = self.current_ebl_status
        if self.ebl_no is not None:
            result['ebl_no'] = self.ebl_no
        if self.next_ebl_status is not None:
            result['next_ebl_status'] = self.next_ebl_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('current_ebl_status') is not None:
            self.current_ebl_status = m.get('current_ebl_status')
        if m.get('ebl_no') is not None:
            self.ebl_no = m.get('ebl_no')
        if m.get('next_ebl_status') is not None:
            self.next_ebl_status = m.get('next_ebl_status')
        return self


class IssueIdInfo(TeaModel):
    def __init__(
        self,
        issue_id: str = None,
        out_biz_no: str = None,
        contract_id: str = None,
        waybill_id: str = None,
        pay_order: str = None,
        ticket_amt: str = None,
        issue_date: str = None,
        expire_date: str = None,
        status: int = None,
        err_msg: str = None,
    ):
        # 信用流转凭证
        self.issue_id = issue_id
        # 全局唯一业务号
        self.out_biz_no = out_biz_no
        # 合同号（预留）
        self.contract_id = contract_id
        # 发行信用流转的运单号
        self.waybill_id = waybill_id
        # 支付订单
        self.pay_order = pay_order
        # 凭证金额
        self.ticket_amt = ticket_amt
        # 信用凭证发起时间
        self.issue_date = issue_date
        # 信用凭证到期时间
        self.expire_date = expire_date
        # 发行结果状态 -1:发行失败状态， 0:未完成状态， 1:已发行状态
        self.status = status
        # 失败原因信息
        self.err_msg = err_msg

    def validate(self):
        self.validate_required(self.issue_id, 'issue_id')
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.waybill_id, 'waybill_id')
        self.validate_required(self.pay_order, 'pay_order')
        self.validate_required(self.ticket_amt, 'ticket_amt')
        self.validate_required(self.issue_date, 'issue_date')
        self.validate_required(self.expire_date, 'expire_date')
        self.validate_required(self.status, 'status')
        self.validate_required(self.err_msg, 'err_msg')

    def to_map(self):
        result = dict()
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.contract_id is not None:
            result['contract_id'] = self.contract_id
        if self.waybill_id is not None:
            result['waybill_id'] = self.waybill_id
        if self.pay_order is not None:
            result['pay_order'] = self.pay_order
        if self.ticket_amt is not None:
            result['ticket_amt'] = self.ticket_amt
        if self.issue_date is not None:
            result['issue_date'] = self.issue_date
        if self.expire_date is not None:
            result['expire_date'] = self.expire_date
        if self.status is not None:
            result['status'] = self.status
        if self.err_msg is not None:
            result['err_msg'] = self.err_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('contract_id') is not None:
            self.contract_id = m.get('contract_id')
        if m.get('waybill_id') is not None:
            self.waybill_id = m.get('waybill_id')
        if m.get('pay_order') is not None:
            self.pay_order = m.get('pay_order')
        if m.get('ticket_amt') is not None:
            self.ticket_amt = m.get('ticket_amt')
        if m.get('issue_date') is not None:
            self.issue_date = m.get('issue_date')
        if m.get('expire_date') is not None:
            self.expire_date = m.get('expire_date')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('err_msg') is not None:
            self.err_msg = m.get('err_msg')
        return self


class PayTariffInvoiceParam(TeaModel):
    def __init__(
        self,
        action: str = None,
        invoice_amount: str = None,
        pay_tariff_amount: str = None,
        pay_tariff_code: str = None,
        pay_tariff_invoice_code: str = None,
    ):
        # 操作动作,为空为新增或更新，UPDATE为更新，DELETE为删除
        self.action = action
        # 发票金额 业务必填
        self.invoice_amount = invoice_amount
        # 资费项金额 业务必填
        self.pay_tariff_amount = pay_tariff_amount
        # 资费单据编号 业务必填
        self.pay_tariff_code = pay_tariff_code
        # 资费项发票code
        self.pay_tariff_invoice_code = pay_tariff_invoice_code

    def validate(self):
        self.validate_required(self.pay_tariff_invoice_code, 'pay_tariff_invoice_code')

    def to_map(self):
        result = dict()
        if self.action is not None:
            result['action'] = self.action
        if self.invoice_amount is not None:
            result['invoice_amount'] = self.invoice_amount
        if self.pay_tariff_amount is not None:
            result['pay_tariff_amount'] = self.pay_tariff_amount
        if self.pay_tariff_code is not None:
            result['pay_tariff_code'] = self.pay_tariff_code
        if self.pay_tariff_invoice_code is not None:
            result['pay_tariff_invoice_code'] = self.pay_tariff_invoice_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('invoice_amount') is not None:
            self.invoice_amount = m.get('invoice_amount')
        if m.get('pay_tariff_amount') is not None:
            self.pay_tariff_amount = m.get('pay_tariff_amount')
        if m.get('pay_tariff_code') is not None:
            self.pay_tariff_code = m.get('pay_tariff_code')
        if m.get('pay_tariff_invoice_code') is not None:
            self.pay_tariff_invoice_code = m.get('pay_tariff_invoice_code')
        return self


class BookingNoInfo(TeaModel):
    def __init__(
        self,
        booking_no: str = None,
        bkg_no: str = None,
    ):
        # 订舱单唯一标识
        self.booking_no = booking_no
        # 订舱号
        self.bkg_no = bkg_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.booking_no is not None:
            result['booking_no'] = self.booking_no
        if self.bkg_no is not None:
            result['bkg_no'] = self.bkg_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('booking_no') is not None:
            self.booking_no = m.get('booking_no')
        if m.get('bkg_no') is not None:
            self.bkg_no = m.get('bkg_no')
        return self


class ReceiptTariffInfo(TeaModel):
    def __init__(
        self,
        order_no: str = None,
        receipt_tariff_code: str = None,
        receipt_tariff_project: str = None,
        receipt_tariff_desc: str = None,
        currency: str = None,
        price_including_tax: str = None,
        booking_no: str = None,
        bkg_no: str = None,
    ):
        # 托运单号 [业务必填]
        self.order_no = order_no
        # 应收资费项code [业务必填]
        # 
        # 
        self.receipt_tariff_code = receipt_tariff_code
        # 应收资费项项目 [业务必填]
        self.receipt_tariff_project = receipt_tariff_project
        # 资费项中文描述 [业务必填]
        # 
        # 
        self.receipt_tariff_desc = receipt_tariff_desc
        # 币种 [业务必填]
        self.currency = currency
        # 资费项含税价 [业务必填]
        # 
        # 
        self.price_including_tax = price_including_tax
        # 订舱单唯一标识 [业务必填]
        self.booking_no = booking_no
        # 订舱号 [业务必填]
        self.bkg_no = bkg_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.order_no is not None:
            result['order_no'] = self.order_no
        if self.receipt_tariff_code is not None:
            result['receipt_tariff_code'] = self.receipt_tariff_code
        if self.receipt_tariff_project is not None:
            result['receipt_tariff_project'] = self.receipt_tariff_project
        if self.receipt_tariff_desc is not None:
            result['receipt_tariff_desc'] = self.receipt_tariff_desc
        if self.currency is not None:
            result['currency'] = self.currency
        if self.price_including_tax is not None:
            result['price_including_tax'] = self.price_including_tax
        if self.booking_no is not None:
            result['booking_no'] = self.booking_no
        if self.bkg_no is not None:
            result['bkg_no'] = self.bkg_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('order_no') is not None:
            self.order_no = m.get('order_no')
        if m.get('receipt_tariff_code') is not None:
            self.receipt_tariff_code = m.get('receipt_tariff_code')
        if m.get('receipt_tariff_project') is not None:
            self.receipt_tariff_project = m.get('receipt_tariff_project')
        if m.get('receipt_tariff_desc') is not None:
            self.receipt_tariff_desc = m.get('receipt_tariff_desc')
        if m.get('currency') is not None:
            self.currency = m.get('currency')
        if m.get('price_including_tax') is not None:
            self.price_including_tax = m.get('price_including_tax')
        if m.get('booking_no') is not None:
            self.booking_no = m.get('booking_no')
        if m.get('bkg_no') is not None:
            self.bkg_no = m.get('bkg_no')
        return self


class HouseBlBookingParam(TeaModel):
    def __init__(
        self,
        action: str = None,
        booking_no: str = None,
    ):
        # 操作动作,为空为新增或更新，UPDATE为更新，DELETE为删除
        self.action = action
        # 订舱单号
        self.booking_no = booking_no

    def validate(self):
        self.validate_required(self.booking_no, 'booking_no')

    def to_map(self):
        result = dict()
        if self.action is not None:
            result['action'] = self.action
        if self.booking_no is not None:
            result['booking_no'] = self.booking_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('booking_no') is not None:
            self.booking_no = m.get('booking_no')
        return self


class InventoryCargo(TeaModel):
    def __init__(
        self,
        inventory_index: int = None,
        sku: str = None,
        cargo_name: str = None,
        cargo_weight: str = None,
        cargo_dimensions: str = None,
        cargo_worth: str = None,
        current_inventory_cargo_num: int = None,
        customer_code: str = None,
        policy_no: str = None,
        stockin_date: str = None,
        timezone: str = None,
    ):
        # 序号，在同一次库存申报请求中，序号保持不重复，不能小于等于0
        self.inventory_index = inventory_index
        # sku品名
        self.sku = sku
        # 商品名称
        # 
        self.cargo_name = cargo_name
        # 商品单品重量(kg)
        self.cargo_weight = cargo_weight
        # 商品外扩长宽高(cm)
        self.cargo_dimensions = cargo_dimensions
        # 商品单品货物价值(元),最多支持2位小数
        self.cargo_worth = cargo_worth
        # 当前库存货物数量
        self.current_inventory_cargo_num = current_inventory_cargo_num
        # 客户代码
        # 
        self.customer_code = customer_code
        # 关联保单号,需要仓储CP做拆分计算
        self.policy_no = policy_no
        # 入库时间, yyyy-MM-dd HH:mm:ss，需要仓储CP做拆分计算
        # 
        self.stockin_date = stockin_date
        # 时区,仓储CP上报入库时间所属的时区
        self.timezone = timezone

    def validate(self):
        self.validate_required(self.inventory_index, 'inventory_index')
        self.validate_required(self.sku, 'sku')
        if self.sku is not None:
            self.validate_max_length(self.sku, 'sku', 200)
        if self.cargo_name is not None:
            self.validate_max_length(self.cargo_name, 'cargo_name', 200)
        if self.cargo_weight is not None:
            self.validate_max_length(self.cargo_weight, 'cargo_weight', 50)
        if self.cargo_dimensions is not None:
            self.validate_max_length(self.cargo_dimensions, 'cargo_dimensions', 200)
        if self.cargo_worth is not None:
            self.validate_max_length(self.cargo_worth, 'cargo_worth', 30)
        self.validate_required(self.current_inventory_cargo_num, 'current_inventory_cargo_num')
        self.validate_required(self.customer_code, 'customer_code')
        if self.customer_code is not None:
            self.validate_max_length(self.customer_code, 'customer_code', 50)
        if self.policy_no is not None:
            self.validate_max_length(self.policy_no, 'policy_no', 64)
        if self.timezone is not None:
            self.validate_max_length(self.timezone, 'timezone', 16)

    def to_map(self):
        result = dict()
        if self.inventory_index is not None:
            result['inventory_index'] = self.inventory_index
        if self.sku is not None:
            result['sku'] = self.sku
        if self.cargo_name is not None:
            result['cargo_name'] = self.cargo_name
        if self.cargo_weight is not None:
            result['cargo_weight'] = self.cargo_weight
        if self.cargo_dimensions is not None:
            result['cargo_dimensions'] = self.cargo_dimensions
        if self.cargo_worth is not None:
            result['cargo_worth'] = self.cargo_worth
        if self.current_inventory_cargo_num is not None:
            result['current_inventory_cargo_num'] = self.current_inventory_cargo_num
        if self.customer_code is not None:
            result['customer_code'] = self.customer_code
        if self.policy_no is not None:
            result['policy_no'] = self.policy_no
        if self.stockin_date is not None:
            result['stockin_date'] = self.stockin_date
        if self.timezone is not None:
            result['timezone'] = self.timezone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('inventory_index') is not None:
            self.inventory_index = m.get('inventory_index')
        if m.get('sku') is not None:
            self.sku = m.get('sku')
        if m.get('cargo_name') is not None:
            self.cargo_name = m.get('cargo_name')
        if m.get('cargo_weight') is not None:
            self.cargo_weight = m.get('cargo_weight')
        if m.get('cargo_dimensions') is not None:
            self.cargo_dimensions = m.get('cargo_dimensions')
        if m.get('cargo_worth') is not None:
            self.cargo_worth = m.get('cargo_worth')
        if m.get('current_inventory_cargo_num') is not None:
            self.current_inventory_cargo_num = m.get('current_inventory_cargo_num')
        if m.get('customer_code') is not None:
            self.customer_code = m.get('customer_code')
        if m.get('policy_no') is not None:
            self.policy_no = m.get('policy_no')
        if m.get('stockin_date') is not None:
            self.stockin_date = m.get('stockin_date')
        if m.get('timezone') is not None:
            self.timezone = m.get('timezone')
        return self


class SoNotifyBookingParam(TeaModel):
    def __init__(
        self,
        action: str = None,
        booking_no: str = None,
        carrier: str = None,
        container_params: str = None,
        customs_clearance: int = None,
        cy: str = None,
        cy_closing: int = None,
        etd: int = None,
        port: str = None,
        si_closing: int = None,
        vessel: str = None,
        voyage: str = None,
    ):
        # 操作动作,为空为新增或更新，UPDATE为更新，DELETE为删除
        self.action = action
        # 订舱单号
        self.booking_no = booking_no
        # 船公司  业务必填
        self.carrier = carrier
        # 箱型箱量 json格式 业务必填
        # [{"containerVolume":"33","containerType":"22"}]
        # containerVolume--箱量 业务必填
        # containerType--箱型 业务必填
        self.container_params = container_params
        # 截关时间
        self.customs_clearance = customs_clearance
        # 场站
        self.cy = cy
        # 截港时间
        self.cy_closing = cy_closing
        # 预计船期
        self.etd = etd
        # 港口
        self.port = port
        # 截单时间
        self.si_closing = si_closing
        # 船名  业务必填
        self.vessel = vessel
        # 航次 业务必填
        self.voyage = voyage

    def validate(self):
        self.validate_required(self.booking_no, 'booking_no')

    def to_map(self):
        result = dict()
        if self.action is not None:
            result['action'] = self.action
        if self.booking_no is not None:
            result['booking_no'] = self.booking_no
        if self.carrier is not None:
            result['carrier'] = self.carrier
        if self.container_params is not None:
            result['container_params'] = self.container_params
        if self.customs_clearance is not None:
            result['customs_clearance'] = self.customs_clearance
        if self.cy is not None:
            result['cy'] = self.cy
        if self.cy_closing is not None:
            result['cy_closing'] = self.cy_closing
        if self.etd is not None:
            result['etd'] = self.etd
        if self.port is not None:
            result['port'] = self.port
        if self.si_closing is not None:
            result['si_closing'] = self.si_closing
        if self.vessel is not None:
            result['vessel'] = self.vessel
        if self.voyage is not None:
            result['voyage'] = self.voyage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('booking_no') is not None:
            self.booking_no = m.get('booking_no')
        if m.get('carrier') is not None:
            self.carrier = m.get('carrier')
        if m.get('container_params') is not None:
            self.container_params = m.get('container_params')
        if m.get('customs_clearance') is not None:
            self.customs_clearance = m.get('customs_clearance')
        if m.get('cy') is not None:
            self.cy = m.get('cy')
        if m.get('cy_closing') is not None:
            self.cy_closing = m.get('cy_closing')
        if m.get('etd') is not None:
            self.etd = m.get('etd')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('si_closing') is not None:
            self.si_closing = m.get('si_closing')
        if m.get('vessel') is not None:
            self.vessel = m.get('vessel')
        if m.get('voyage') is not None:
            self.voyage = m.get('voyage')
        return self


class AuthParty(TeaModel):
    def __init__(
        self,
        sign_party_name: str = None,
        sign_party_cert_type: str = None,
        sign_party_cert_num: str = None,
        sign_result: str = None,
        sign_fail_reason: str = None,
        sign_time: str = None,
    ):
        # 签署方名称
        self.sign_party_name = sign_party_name
        # 签署方证件类型，可以填写的枚举类：IDENTIFICATION_CARD，表示身份证
        self.sign_party_cert_type = sign_party_cert_type
        # 签署方证件号码
        self.sign_party_cert_num = sign_party_cert_num
        # 签署结果（必填，FINISH,FAIL,REFUSE三者选一，分别表示签署完成、失败和拒签）
        self.sign_result = sign_result
        # 签署失败或拒签原因（失败或拒签时必填）
        self.sign_fail_reason = sign_fail_reason
        # 签署时间(13位毫秒时间戳)
        self.sign_time = sign_time

    def validate(self):
        self.validate_required(self.sign_party_name, 'sign_party_name')
        self.validate_required(self.sign_party_cert_type, 'sign_party_cert_type')
        self.validate_required(self.sign_party_cert_num, 'sign_party_cert_num')
        self.validate_required(self.sign_result, 'sign_result')
        self.validate_required(self.sign_time, 'sign_time')

    def to_map(self):
        result = dict()
        if self.sign_party_name is not None:
            result['sign_party_name'] = self.sign_party_name
        if self.sign_party_cert_type is not None:
            result['sign_party_cert_type'] = self.sign_party_cert_type
        if self.sign_party_cert_num is not None:
            result['sign_party_cert_num'] = self.sign_party_cert_num
        if self.sign_result is not None:
            result['sign_result'] = self.sign_result
        if self.sign_fail_reason is not None:
            result['sign_fail_reason'] = self.sign_fail_reason
        if self.sign_time is not None:
            result['sign_time'] = self.sign_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sign_party_name') is not None:
            self.sign_party_name = m.get('sign_party_name')
        if m.get('sign_party_cert_type') is not None:
            self.sign_party_cert_type = m.get('sign_party_cert_type')
        if m.get('sign_party_cert_num') is not None:
            self.sign_party_cert_num = m.get('sign_party_cert_num')
        if m.get('sign_result') is not None:
            self.sign_result = m.get('sign_result')
        if m.get('sign_fail_reason') is not None:
            self.sign_fail_reason = m.get('sign_fail_reason')
        if m.get('sign_time') is not None:
            self.sign_time = m.get('sign_time')
        return self


class EblStatusDetail(TeaModel):
    def __init__(
        self,
        current_ebl_status: str = None,
        ebl_no: str = None,
        next_ebl_status: str = None,
    ):
        # 当前提单状态
        self.current_ebl_status = current_ebl_status
        # 电子提单编号
        self.ebl_no = ebl_no
        # 下一个提单状态
        self.next_ebl_status = next_ebl_status

    def validate(self):
        self.validate_required(self.current_ebl_status, 'current_ebl_status')
        self.validate_required(self.ebl_no, 'ebl_no')
        self.validate_required(self.next_ebl_status, 'next_ebl_status')

    def to_map(self):
        result = dict()
        if self.current_ebl_status is not None:
            result['current_ebl_status'] = self.current_ebl_status
        if self.ebl_no is not None:
            result['ebl_no'] = self.ebl_no
        if self.next_ebl_status is not None:
            result['next_ebl_status'] = self.next_ebl_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('current_ebl_status') is not None:
            self.current_ebl_status = m.get('current_ebl_status')
        if m.get('ebl_no') is not None:
            self.ebl_no = m.get('ebl_no')
        if m.get('next_ebl_status') is not None:
            self.next_ebl_status = m.get('next_ebl_status')
        return self


class InsureBaseInfo(TeaModel):
    def __init__(
        self,
        tbr_name: str = None,
        tbr_id_no: str = None,
        tbr_id_type: str = None,
        tbr_tel: str = None,
        tbr_addr: str = None,
        tbr_email: str = None,
        bbr_name: str = None,
        bbr_id_type: str = None,
        bbr_id_no: str = None,
        bbr_tel: str = None,
        bbr_addr: str = None,
        pre_mium: str = None,
        eff_date: str = None,
        term_date: str = None,
        idenrify_period_start: str = None,
        identify_period_end: str = None,
    ):
        # 投保人姓名
        self.tbr_name = tbr_name
        # 投保人证件号
        self.tbr_id_no = tbr_id_no
        # 投保人证件类型
        self.tbr_id_type = tbr_id_type
        # 投保人联系电话
        self.tbr_tel = tbr_tel
        # 投保人地址
        self.tbr_addr = tbr_addr
        # 投保人邮箱
        self.tbr_email = tbr_email
        # 被保险人姓名
        self.bbr_name = bbr_name
        # 被保险人证件类型
        self.bbr_id_type = bbr_id_type
        # 被保险人证件号码
        self.bbr_id_no = bbr_id_no
        # 被保险人联系电话
        self.bbr_tel = bbr_tel
        # 被保险人地址
        self.bbr_addr = bbr_addr
        # 含税保费(元)，小数点两位
        self.pre_mium = pre_mium
        # 保险起期
        self.eff_date = eff_date
        # 保险止期
        self.term_date = term_date
        # 投保人证件类型有效起期
        self.idenrify_period_start = idenrify_period_start
        # 投保人证件类型有效止期
        self.identify_period_end = identify_period_end

    def validate(self):
        self.validate_required(self.tbr_name, 'tbr_name')
        self.validate_required(self.tbr_id_no, 'tbr_id_no')
        self.validate_required(self.tbr_id_type, 'tbr_id_type')
        self.validate_required(self.tbr_tel, 'tbr_tel')
        self.validate_required(self.tbr_email, 'tbr_email')
        self.validate_required(self.bbr_name, 'bbr_name')
        self.validate_required(self.bbr_id_type, 'bbr_id_type')
        self.validate_required(self.bbr_id_no, 'bbr_id_no')
        self.validate_required(self.bbr_tel, 'bbr_tel')
        self.validate_required(self.pre_mium, 'pre_mium')
        self.validate_required(self.eff_date, 'eff_date')
        if self.eff_date is not None:
            self.validate_pattern(self.eff_date, 'eff_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.term_date, 'term_date')
        if self.term_date is not None:
            self.validate_pattern(self.term_date, 'term_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.idenrify_period_start is not None:
            self.validate_pattern(self.idenrify_period_start, 'idenrify_period_start', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.identify_period_end is not None:
            self.validate_pattern(self.identify_period_end, 'identify_period_end', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.tbr_name is not None:
            result['tbr_name'] = self.tbr_name
        if self.tbr_id_no is not None:
            result['tbr_id_no'] = self.tbr_id_no
        if self.tbr_id_type is not None:
            result['tbr_id_type'] = self.tbr_id_type
        if self.tbr_tel is not None:
            result['tbr_tel'] = self.tbr_tel
        if self.tbr_addr is not None:
            result['tbr_addr'] = self.tbr_addr
        if self.tbr_email is not None:
            result['tbr_email'] = self.tbr_email
        if self.bbr_name is not None:
            result['bbr_name'] = self.bbr_name
        if self.bbr_id_type is not None:
            result['bbr_id_type'] = self.bbr_id_type
        if self.bbr_id_no is not None:
            result['bbr_id_no'] = self.bbr_id_no
        if self.bbr_tel is not None:
            result['bbr_tel'] = self.bbr_tel
        if self.bbr_addr is not None:
            result['bbr_addr'] = self.bbr_addr
        if self.pre_mium is not None:
            result['pre_mium'] = self.pre_mium
        if self.eff_date is not None:
            result['eff_date'] = self.eff_date
        if self.term_date is not None:
            result['term_date'] = self.term_date
        if self.idenrify_period_start is not None:
            result['idenrify_period_start'] = self.idenrify_period_start
        if self.identify_period_end is not None:
            result['identify_period_end'] = self.identify_period_end
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tbr_name') is not None:
            self.tbr_name = m.get('tbr_name')
        if m.get('tbr_id_no') is not None:
            self.tbr_id_no = m.get('tbr_id_no')
        if m.get('tbr_id_type') is not None:
            self.tbr_id_type = m.get('tbr_id_type')
        if m.get('tbr_tel') is not None:
            self.tbr_tel = m.get('tbr_tel')
        if m.get('tbr_addr') is not None:
            self.tbr_addr = m.get('tbr_addr')
        if m.get('tbr_email') is not None:
            self.tbr_email = m.get('tbr_email')
        if m.get('bbr_name') is not None:
            self.bbr_name = m.get('bbr_name')
        if m.get('bbr_id_type') is not None:
            self.bbr_id_type = m.get('bbr_id_type')
        if m.get('bbr_id_no') is not None:
            self.bbr_id_no = m.get('bbr_id_no')
        if m.get('bbr_tel') is not None:
            self.bbr_tel = m.get('bbr_tel')
        if m.get('bbr_addr') is not None:
            self.bbr_addr = m.get('bbr_addr')
        if m.get('pre_mium') is not None:
            self.pre_mium = m.get('pre_mium')
        if m.get('eff_date') is not None:
            self.eff_date = m.get('eff_date')
        if m.get('term_date') is not None:
            self.term_date = m.get('term_date')
        if m.get('idenrify_period_start') is not None:
            self.idenrify_period_start = m.get('idenrify_period_start')
        if m.get('identify_period_end') is not None:
            self.identify_period_end = m.get('identify_period_end')
        return self


class PfVoucherCheckResult(TeaModel):
    def __init__(
        self,
        voucher_id: str = None,
        voucher_category: str = None,
        status: str = None,
    ):
        # 凭证id
        self.voucher_id = voucher_id
        # 凭证类型
        self.voucher_category = voucher_category
        # 状态；PASS:通过，NO_PASS 未通过
        self.status = status

    def validate(self):
        self.validate_required(self.voucher_id, 'voucher_id')
        self.validate_required(self.voucher_category, 'voucher_category')
        self.validate_required(self.status, 'status')

    def to_map(self):
        result = dict()
        if self.voucher_id is not None:
            result['voucher_id'] = self.voucher_id
        if self.voucher_category is not None:
            result['voucher_category'] = self.voucher_category
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('voucher_id') is not None:
            self.voucher_id = m.get('voucher_id')
        if m.get('voucher_category') is not None:
            self.voucher_category = m.get('voucher_category')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class UploadFinancingParam(TeaModel):
    def __init__(
        self,
        booking_count: int = None,
        code: str = None,
        end_date: str = None,
        forwarder_did: str = None,
        start_date: str = None,
        teu: int = None,
        amounts: str = None,
    ):
        # 订舱单量（票）
        self.booking_count = booking_count
        # 唯一标识
        self.code = code
        # 结束日期
        self.end_date = end_date
        # 货代did
        self.forwarder_did = forwarder_did
        # 开始日期
        self.start_date = start_date
        # 箱量【数量，不区分箱型，20GP是1TEU，40GP是2TEU】
        self.teu = teu
        # 运输总额
        self.amounts = amounts

    def validate(self):
        self.validate_required(self.booking_count, 'booking_count')
        self.validate_required(self.code, 'code')
        self.validate_required(self.end_date, 'end_date')
        self.validate_required(self.forwarder_did, 'forwarder_did')
        self.validate_required(self.start_date, 'start_date')
        self.validate_required(self.teu, 'teu')
        self.validate_required(self.amounts, 'amounts')

    def to_map(self):
        result = dict()
        if self.booking_count is not None:
            result['booking_count'] = self.booking_count
        if self.code is not None:
            result['code'] = self.code
        if self.end_date is not None:
            result['end_date'] = self.end_date
        if self.forwarder_did is not None:
            result['forwarder_did'] = self.forwarder_did
        if self.start_date is not None:
            result['start_date'] = self.start_date
        if self.teu is not None:
            result['teu'] = self.teu
        if self.amounts is not None:
            result['amounts'] = self.amounts
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('booking_count') is not None:
            self.booking_count = m.get('booking_count')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('end_date') is not None:
            self.end_date = m.get('end_date')
        if m.get('forwarder_did') is not None:
            self.forwarder_did = m.get('forwarder_did')
        if m.get('start_date') is not None:
            self.start_date = m.get('start_date')
        if m.get('teu') is not None:
            self.teu = m.get('teu')
        if m.get('amounts') is not None:
            self.amounts = m.get('amounts')
        return self


class TxDto(TeaModel):
    def __init__(
        self,
        tx_code: str = None,
        data_type: str = None,
    ):
        # 链上凭证
        self.tx_code = tx_code
        # 链上存储结构对应类型
        self.data_type = data_type

    def validate(self):
        self.validate_required(self.tx_code, 'tx_code')
        self.validate_required(self.data_type, 'data_type')

    def to_map(self):
        result = dict()
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        if self.data_type is not None:
            result['data_type'] = self.data_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        if m.get('data_type') is not None:
            self.data_type = m.get('data_type')
        return self


class LogisticLocation(TeaModel):
    def __init__(
        self,
        address: str = None,
        city_code: str = None,
        lat: str = None,
        lon: str = None,
        track_time: int = None,
    ):
        # 结构化地址信息,规则遵循：国家、省份、城市、区县、城镇、乡村、街道、门牌号码、屋邨、大厦
        self.address = address
        # 行政区划代码
        self.city_code = city_code
        # 纬度
        # 
        self.lat = lat
        # 经度
        self.lon = lon
        # 轨迹时间戳
        self.track_time = track_time

    def validate(self):
        self.validate_required(self.lat, 'lat')
        self.validate_required(self.lon, 'lon')
        self.validate_required(self.track_time, 'track_time')

    def to_map(self):
        result = dict()
        if self.address is not None:
            result['address'] = self.address
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.lat is not None:
            result['lat'] = self.lat
        if self.lon is not None:
            result['lon'] = self.lon
        if self.track_time is not None:
            result['track_time'] = self.track_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('lat') is not None:
            self.lat = m.get('lat')
        if m.get('lon') is not None:
            self.lon = m.get('lon')
        if m.get('track_time') is not None:
            self.track_time = m.get('track_time')
        return self


class UserIssueId(TeaModel):
    def __init__(
        self,
        issue_id: str = None,
        balance_amt: str = None,
    ):
        # 凭证id
        self.issue_id = issue_id
        # 凭证余额
        self.balance_amt = balance_amt

    def validate(self):
        self.validate_required(self.issue_id, 'issue_id')
        self.validate_required(self.balance_amt, 'balance_amt')

    def to_map(self):
        result = dict()
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.balance_amt is not None:
            result['balance_amt'] = self.balance_amt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('balance_amt') is not None:
            self.balance_amt = m.get('balance_amt')
        return self


class EblDeatil(TeaModel):
    def __init__(
        self,
        ebl_copy_pdf_file_hash: str = None,
        ebl_copy_pdf_file_id: str = None,
        ebl_no: str = None,
    ):
        # 电子提单copy文件hash
        self.ebl_copy_pdf_file_hash = ebl_copy_pdf_file_hash
        # 电子提单copy文件id
        self.ebl_copy_pdf_file_id = ebl_copy_pdf_file_id
        # 电子提单编号
        self.ebl_no = ebl_no

    def validate(self):
        self.validate_required(self.ebl_copy_pdf_file_hash, 'ebl_copy_pdf_file_hash')
        self.validate_required(self.ebl_copy_pdf_file_id, 'ebl_copy_pdf_file_id')
        self.validate_required(self.ebl_no, 'ebl_no')

    def to_map(self):
        result = dict()
        if self.ebl_copy_pdf_file_hash is not None:
            result['ebl_copy_pdf_file_hash'] = self.ebl_copy_pdf_file_hash
        if self.ebl_copy_pdf_file_id is not None:
            result['ebl_copy_pdf_file_id'] = self.ebl_copy_pdf_file_id
        if self.ebl_no is not None:
            result['ebl_no'] = self.ebl_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ebl_copy_pdf_file_hash') is not None:
            self.ebl_copy_pdf_file_hash = m.get('ebl_copy_pdf_file_hash')
        if m.get('ebl_copy_pdf_file_id') is not None:
            self.ebl_copy_pdf_file_id = m.get('ebl_copy_pdf_file_id')
        if m.get('ebl_no') is not None:
            self.ebl_no = m.get('ebl_no')
        return self


class StockinCargo(TeaModel):
    def __init__(
        self,
        stockin_index: int = None,
        sku: str = None,
        cargo_name: str = None,
        cargo_weight: str = None,
        cargo_dimensions: str = None,
        cargo_worth: str = None,
        container_no: str = None,
        actual_stockin_num: int = None,
    ):
        # 入库序号，在同一次入库请求中，入库序号保持不重复，不能小于0
        self.stockin_index = stockin_index
        # sku品名
        # 
        self.sku = sku
        # 商品名称
        self.cargo_name = cargo_name
        # 商品单品重量(kg)
        self.cargo_weight = cargo_weight
        # 商品外扩长宽高(cm)
        self.cargo_dimensions = cargo_dimensions
        # 商品单品货物价值(元),，最多支持2位小数
        self.cargo_worth = cargo_worth
        # 箱号
        self.container_no = container_no
        # 实际入库件数
        self.actual_stockin_num = actual_stockin_num

    def validate(self):
        self.validate_required(self.stockin_index, 'stockin_index')
        self.validate_required(self.sku, 'sku')
        if self.sku is not None:
            self.validate_max_length(self.sku, 'sku', 200)
        if self.cargo_name is not None:
            self.validate_max_length(self.cargo_name, 'cargo_name', 200)
        if self.cargo_weight is not None:
            self.validate_max_length(self.cargo_weight, 'cargo_weight', 50)
        if self.cargo_dimensions is not None:
            self.validate_max_length(self.cargo_dimensions, 'cargo_dimensions', 200)
        if self.cargo_worth is not None:
            self.validate_max_length(self.cargo_worth, 'cargo_worth', 30)
        if self.container_no is not None:
            self.validate_max_length(self.container_no, 'container_no', 50)
        self.validate_required(self.actual_stockin_num, 'actual_stockin_num')

    def to_map(self):
        result = dict()
        if self.stockin_index is not None:
            result['stockin_index'] = self.stockin_index
        if self.sku is not None:
            result['sku'] = self.sku
        if self.cargo_name is not None:
            result['cargo_name'] = self.cargo_name
        if self.cargo_weight is not None:
            result['cargo_weight'] = self.cargo_weight
        if self.cargo_dimensions is not None:
            result['cargo_dimensions'] = self.cargo_dimensions
        if self.cargo_worth is not None:
            result['cargo_worth'] = self.cargo_worth
        if self.container_no is not None:
            result['container_no'] = self.container_no
        if self.actual_stockin_num is not None:
            result['actual_stockin_num'] = self.actual_stockin_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('stockin_index') is not None:
            self.stockin_index = m.get('stockin_index')
        if m.get('sku') is not None:
            self.sku = m.get('sku')
        if m.get('cargo_name') is not None:
            self.cargo_name = m.get('cargo_name')
        if m.get('cargo_weight') is not None:
            self.cargo_weight = m.get('cargo_weight')
        if m.get('cargo_dimensions') is not None:
            self.cargo_dimensions = m.get('cargo_dimensions')
        if m.get('cargo_worth') is not None:
            self.cargo_worth = m.get('cargo_worth')
        if m.get('container_no') is not None:
            self.container_no = m.get('container_no')
        if m.get('actual_stockin_num') is not None:
            self.actual_stockin_num = m.get('actual_stockin_num')
        return self


class CarLoss(TeaModel):
    def __init__(
        self,
        car_mark: str = None,
        car_owner_name: str = None,
        car_owner_contact: str = None,
        car_vin_no: str = None,
        car_loss_estimate_amount: str = None,
    ):
        # 车牌号，车牌号和车架号至少填一个
        self.car_mark = car_mark
        # 车主姓名
        self.car_owner_name = car_owner_name
        # 车主联系方式
        self.car_owner_contact = car_owner_contact
        # 车架号，车牌号和车架号至少填一个
        self.car_vin_no = car_vin_no
        # 损失预估，单位（元），最多支持2位小数
        self.car_loss_estimate_amount = car_loss_estimate_amount

    def validate(self):
        if self.car_mark is not None:
            self.validate_max_length(self.car_mark, 'car_mark', 20)
        if self.car_owner_name is not None:
            self.validate_max_length(self.car_owner_name, 'car_owner_name', 200)
        if self.car_owner_contact is not None:
            self.validate_max_length(self.car_owner_contact, 'car_owner_contact', 20)
        if self.car_vin_no is not None:
            self.validate_max_length(self.car_vin_no, 'car_vin_no', 100)
        self.validate_required(self.car_loss_estimate_amount, 'car_loss_estimate_amount')

    def to_map(self):
        result = dict()
        if self.car_mark is not None:
            result['car_mark'] = self.car_mark
        if self.car_owner_name is not None:
            result['car_owner_name'] = self.car_owner_name
        if self.car_owner_contact is not None:
            result['car_owner_contact'] = self.car_owner_contact
        if self.car_vin_no is not None:
            result['car_vin_no'] = self.car_vin_no
        if self.car_loss_estimate_amount is not None:
            result['car_loss_estimate_amount'] = self.car_loss_estimate_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('car_mark') is not None:
            self.car_mark = m.get('car_mark')
        if m.get('car_owner_name') is not None:
            self.car_owner_name = m.get('car_owner_name')
        if m.get('car_owner_contact') is not None:
            self.car_owner_contact = m.get('car_owner_contact')
        if m.get('car_vin_no') is not None:
            self.car_vin_no = m.get('car_vin_no')
        if m.get('car_loss_estimate_amount') is not None:
            self.car_loss_estimate_amount = m.get('car_loss_estimate_amount')
        return self


class StatementInfo(TeaModel):
    def __init__(
        self,
        batch_id: str = None,
        out_biz_no: str = None,
        issue_id: str = None,
        contract_id: str = None,
        waybill_id: str = None,
        pay_order: str = None,
        credit_limit: str = None,
        state_type: str = None,
        state_msg: str = None,
        from_did: str = None,
        to_did: str = None,
        issue_date: str = None,
        expire_date: str = None,
    ):
        # 信用流转批次号
        self.batch_id = batch_id
        # 全局唯一业务号
        self.out_biz_no = out_biz_no
        # 信用流转凭证
        self.issue_id = issue_id
        # 合同号（预留）
        self.contract_id = contract_id
        # 发行信用流转的运单号
        self.waybill_id = waybill_id
        # 发行信用流转的支付单号
        self.pay_order = pay_order
        # 金额信息
        self.credit_limit = credit_limit
        # 流水类型
        self.state_type = state_type
        # 流水类型说明
        self.state_msg = state_msg
        # 凭证来源方did
        self.from_did = from_did
        # 凭证流转方did
        self.to_did = to_did
        # 信用凭证发起时间
        self.issue_date = issue_date
        # 信用凭证到期时间
        self.expire_date = expire_date

    def validate(self):
        self.validate_required(self.batch_id, 'batch_id')
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.issue_id, 'issue_id')
        self.validate_required(self.waybill_id, 'waybill_id')
        self.validate_required(self.pay_order, 'pay_order')
        self.validate_required(self.credit_limit, 'credit_limit')
        self.validate_required(self.state_type, 'state_type')
        self.validate_required(self.state_msg, 'state_msg')
        self.validate_required(self.from_did, 'from_did')
        self.validate_required(self.to_did, 'to_did')
        self.validate_required(self.issue_date, 'issue_date')
        self.validate_required(self.expire_date, 'expire_date')

    def to_map(self):
        result = dict()
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.contract_id is not None:
            result['contract_id'] = self.contract_id
        if self.waybill_id is not None:
            result['waybill_id'] = self.waybill_id
        if self.pay_order is not None:
            result['pay_order'] = self.pay_order
        if self.credit_limit is not None:
            result['credit_limit'] = self.credit_limit
        if self.state_type is not None:
            result['state_type'] = self.state_type
        if self.state_msg is not None:
            result['state_msg'] = self.state_msg
        if self.from_did is not None:
            result['from_did'] = self.from_did
        if self.to_did is not None:
            result['to_did'] = self.to_did
        if self.issue_date is not None:
            result['issue_date'] = self.issue_date
        if self.expire_date is not None:
            result['expire_date'] = self.expire_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('contract_id') is not None:
            self.contract_id = m.get('contract_id')
        if m.get('waybill_id') is not None:
            self.waybill_id = m.get('waybill_id')
        if m.get('pay_order') is not None:
            self.pay_order = m.get('pay_order')
        if m.get('credit_limit') is not None:
            self.credit_limit = m.get('credit_limit')
        if m.get('state_type') is not None:
            self.state_type = m.get('state_type')
        if m.get('state_msg') is not None:
            self.state_msg = m.get('state_msg')
        if m.get('from_did') is not None:
            self.from_did = m.get('from_did')
        if m.get('to_did') is not None:
            self.to_did = m.get('to_did')
        if m.get('issue_date') is not None:
            self.issue_date = m.get('issue_date')
        if m.get('expire_date') is not None:
            self.expire_date = m.get('expire_date')
        return self


class MainItemAdd(TeaModel):
    def __init__(
        self,
        main_item_add_code: str = None,
        main_item_add_content: str = None,
    ):
        # 附加条款代码-参考保司提供样例
        self.main_item_add_code = main_item_add_code
        # 附加条款内容-参考保司提供样例
        self.main_item_add_content = main_item_add_content

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.main_item_add_code is not None:
            result['main_item_add_code'] = self.main_item_add_code
        if self.main_item_add_content is not None:
            result['main_item_add_content'] = self.main_item_add_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('main_item_add_code') is not None:
            self.main_item_add_code = m.get('main_item_add_code')
        if m.get('main_item_add_content') is not None:
            self.main_item_add_content = m.get('main_item_add_content')
        return self


class MasterBlBookingParam(TeaModel):
    def __init__(
        self,
        action: str = None,
        booking_no: str = None,
    ):
        # 操作动作,为空为新增或更新，UPDATE为更新，DELETE为删除
        self.action = action
        # 订舱单号
        self.booking_no = booking_no

    def validate(self):
        self.validate_required(self.booking_no, 'booking_no')

    def to_map(self):
        result = dict()
        if self.action is not None:
            result['action'] = self.action
        if self.booking_no is not None:
            result['booking_no'] = self.booking_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('booking_no') is not None:
            self.booking_no = m.get('booking_no')
        return self


class FinishWaybillOrderReq(TeaModel):
    def __init__(
        self,
        all_freight: str = None,
        back_fee: str = None,
        consignor_freight_amount: str = None,
        freight_incr: str = None,
        loss_fee: str = None,
        platform_did: str = None,
        tax_waybill_id: str = None,
    ):
        # 运费
        self.all_freight = all_freight
        # 回单押金
        self.back_fee = back_fee
        # 货主支付运费金额
        self.consignor_freight_amount = consignor_freight_amount
        # 运费增项
        self.freight_incr = freight_incr
        # 运费扣减
        self.loss_fee = loss_fee
        # 平台did
        self.platform_did = platform_did
        # 运单id
        self.tax_waybill_id = tax_waybill_id

    def validate(self):
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')

    def to_map(self):
        result = dict()
        if self.all_freight is not None:
            result['all_freight'] = self.all_freight
        if self.back_fee is not None:
            result['back_fee'] = self.back_fee
        if self.consignor_freight_amount is not None:
            result['consignor_freight_amount'] = self.consignor_freight_amount
        if self.freight_incr is not None:
            result['freight_incr'] = self.freight_incr
        if self.loss_fee is not None:
            result['loss_fee'] = self.loss_fee
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('all_freight') is not None:
            self.all_freight = m.get('all_freight')
        if m.get('back_fee') is not None:
            self.back_fee = m.get('back_fee')
        if m.get('consignor_freight_amount') is not None:
            self.consignor_freight_amount = m.get('consignor_freight_amount')
        if m.get('freight_incr') is not None:
            self.freight_incr = m.get('freight_incr')
        if m.get('loss_fee') is not None:
            self.loss_fee = m.get('loss_fee')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        return self


class SaasIssueApplyInfo(TeaModel):
    def __init__(
        self,
        cargo_order: str = None,
        contract_id: str = None,
        out_biz_no: str = None,
        pay_order: str = None,
        waybill_id: str = None,
        driver_did: str = None,
        freight: str = None,
        expire_date: str = None,
    ):
        # 货源订单
        self.cargo_order = cargo_order
        # 合同号
        self.contract_id = contract_id
        # 全局唯一业务单号
        self.out_biz_no = out_biz_no
        # 支付单号
        self.pay_order = pay_order
        # 运单号
        self.waybill_id = waybill_id
        # 司机did
        self.driver_did = driver_did
        # 发行费
        self.freight = freight
        # 到期时间戳
        self.expire_date = expire_date

    def validate(self):
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.pay_order, 'pay_order')
        self.validate_required(self.waybill_id, 'waybill_id')
        self.validate_required(self.driver_did, 'driver_did')
        self.validate_required(self.freight, 'freight')
        self.validate_required(self.expire_date, 'expire_date')

    def to_map(self):
        result = dict()
        if self.cargo_order is not None:
            result['cargo_order'] = self.cargo_order
        if self.contract_id is not None:
            result['contract_id'] = self.contract_id
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.pay_order is not None:
            result['pay_order'] = self.pay_order
        if self.waybill_id is not None:
            result['waybill_id'] = self.waybill_id
        if self.driver_did is not None:
            result['driver_did'] = self.driver_did
        if self.freight is not None:
            result['freight'] = self.freight
        if self.expire_date is not None:
            result['expire_date'] = self.expire_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cargo_order') is not None:
            self.cargo_order = m.get('cargo_order')
        if m.get('contract_id') is not None:
            self.contract_id = m.get('contract_id')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('pay_order') is not None:
            self.pay_order = m.get('pay_order')
        if m.get('waybill_id') is not None:
            self.waybill_id = m.get('waybill_id')
        if m.get('driver_did') is not None:
            self.driver_did = m.get('driver_did')
        if m.get('freight') is not None:
            self.freight = m.get('freight')
        if m.get('expire_date') is not None:
            self.expire_date = m.get('expire_date')
        return self


class VehicleContainerParam(TeaModel):
    def __init__(
        self,
        action: str = None,
        container_id: str = None,
        container_no: str = None,
        seal_no: str = None,
    ):
        # 操作动作,为空为新增或更新，UPDATE为更新，DELETE为删除
        self.action = action
        # 集装箱ID
        self.container_id = container_id
        # 箱号
        self.container_no = container_no
        # 封号
        self.seal_no = seal_no

    def validate(self):
        self.validate_required(self.container_id, 'container_id')

    def to_map(self):
        result = dict()
        if self.action is not None:
            result['action'] = self.action
        if self.container_id is not None:
            result['container_id'] = self.container_id
        if self.container_no is not None:
            result['container_no'] = self.container_no
        if self.seal_no is not None:
            result['seal_no'] = self.seal_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('container_id') is not None:
            self.container_id = m.get('container_id')
        if m.get('container_no') is not None:
            self.container_no = m.get('container_no')
        if m.get('seal_no') is not None:
            self.seal_no = m.get('seal_no')
        return self


class IssueApplyInfoPlus(TeaModel):
    def __init__(
        self,
        booking_no: str = None,
        carrier_did: str = None,
        container_no: str = None,
        expire_date: str = None,
        issue_amt: str = None,
        out_biz_no: str = None,
        out_order_no: str = None,
        waybill_id: str = None,
    ):
        # 订单中的BookingNo，以英文逗号分割
        self.booking_no = booking_no
        # 船公司did
        self.carrier_did = carrier_did
        # BookingNo中的箱号，以英文逗号分割
        self.container_no = container_no
        # 到期时间戳
        self.expire_date = expire_date
        # 发行金额，精确到小数点后2位
        self.issue_amt = issue_amt
        # 全局唯一业务号
        self.out_biz_no = out_biz_no
        # 支付单号
        self.out_order_no = out_order_no
        # 运单订单id
        self.waybill_id = waybill_id

    def validate(self):
        self.validate_required(self.booking_no, 'booking_no')
        self.validate_required(self.carrier_did, 'carrier_did')
        self.validate_required(self.container_no, 'container_no')
        self.validate_required(self.expire_date, 'expire_date')
        self.validate_required(self.issue_amt, 'issue_amt')
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.out_order_no, 'out_order_no')
        self.validate_required(self.waybill_id, 'waybill_id')

    def to_map(self):
        result = dict()
        if self.booking_no is not None:
            result['booking_no'] = self.booking_no
        if self.carrier_did is not None:
            result['carrier_did'] = self.carrier_did
        if self.container_no is not None:
            result['container_no'] = self.container_no
        if self.expire_date is not None:
            result['expire_date'] = self.expire_date
        if self.issue_amt is not None:
            result['issue_amt'] = self.issue_amt
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.out_order_no is not None:
            result['out_order_no'] = self.out_order_no
        if self.waybill_id is not None:
            result['waybill_id'] = self.waybill_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('booking_no') is not None:
            self.booking_no = m.get('booking_no')
        if m.get('carrier_did') is not None:
            self.carrier_did = m.get('carrier_did')
        if m.get('container_no') is not None:
            self.container_no = m.get('container_no')
        if m.get('expire_date') is not None:
            self.expire_date = m.get('expire_date')
        if m.get('issue_amt') is not None:
            self.issue_amt = m.get('issue_amt')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('out_order_no') is not None:
            self.out_order_no = m.get('out_order_no')
        if m.get('waybill_id') is not None:
            self.waybill_id = m.get('waybill_id')
        return self


class HouseBlGoodsParam(TeaModel):
    def __init__(
        self,
        cargo_ready_date: int = None,
        dg_page_no: str = None,
        dg_type: str = None,
        flash_point: str = None,
        goods: str = None,
        goods_cn: str = None,
        goods_type: str = None,
        hs_codes: List[str] = None,
        marks: str = None,
        number: str = None,
        package_type: str = None,
        real_number: str = None,
        real_volume: str = None,
        real_weight: str = None,
        un_no: str = None,
        volume: str = None,
        weight: str = None,
    ):
        # 预计备货时间
        self.cargo_ready_date = cargo_ready_date
        # 危险品页号
        self.dg_page_no = dg_page_no
        # 危险品级别
        self.dg_type = dg_type
        # 危险品闪点
        self.flash_point = flash_point
        # 货物名称 业务必填
        self.goods = goods
        # 货物中文名
        self.goods_cn = goods_cn
        # 货物类型 业务必填
        self.goods_type = goods_type
        # HS CODE
        self.hs_codes = hs_codes
        # 唛头
        self.marks = marks
        # 件数 业务必填
        self.number = number
        # 包装类型
        self.package_type = package_type
        # 实际件数
        self.real_number = real_number
        # 实际体积
        self.real_volume = real_volume
        # 实际重量
        self.real_weight = real_weight
        # 危险品联合国编号
        self.un_no = un_no
        # 委托体积 业务必填
        self.volume = volume
        # 委托重量 业务必填
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.cargo_ready_date is not None:
            result['cargo_ready_date'] = self.cargo_ready_date
        if self.dg_page_no is not None:
            result['dg_page_no'] = self.dg_page_no
        if self.dg_type is not None:
            result['dg_type'] = self.dg_type
        if self.flash_point is not None:
            result['flash_point'] = self.flash_point
        if self.goods is not None:
            result['goods'] = self.goods
        if self.goods_cn is not None:
            result['goods_cn'] = self.goods_cn
        if self.goods_type is not None:
            result['goods_type'] = self.goods_type
        if self.hs_codes is not None:
            result['hs_codes'] = self.hs_codes
        if self.marks is not None:
            result['marks'] = self.marks
        if self.number is not None:
            result['number'] = self.number
        if self.package_type is not None:
            result['package_type'] = self.package_type
        if self.real_number is not None:
            result['real_number'] = self.real_number
        if self.real_volume is not None:
            result['real_volume'] = self.real_volume
        if self.real_weight is not None:
            result['real_weight'] = self.real_weight
        if self.un_no is not None:
            result['un_no'] = self.un_no
        if self.volume is not None:
            result['volume'] = self.volume
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cargo_ready_date') is not None:
            self.cargo_ready_date = m.get('cargo_ready_date')
        if m.get('dg_page_no') is not None:
            self.dg_page_no = m.get('dg_page_no')
        if m.get('dg_type') is not None:
            self.dg_type = m.get('dg_type')
        if m.get('flash_point') is not None:
            self.flash_point = m.get('flash_point')
        if m.get('goods') is not None:
            self.goods = m.get('goods')
        if m.get('goods_cn') is not None:
            self.goods_cn = m.get('goods_cn')
        if m.get('goods_type') is not None:
            self.goods_type = m.get('goods_type')
        if m.get('hs_codes') is not None:
            self.hs_codes = m.get('hs_codes')
        if m.get('marks') is not None:
            self.marks = m.get('marks')
        if m.get('number') is not None:
            self.number = m.get('number')
        if m.get('package_type') is not None:
            self.package_type = m.get('package_type')
        if m.get('real_number') is not None:
            self.real_number = m.get('real_number')
        if m.get('real_volume') is not None:
            self.real_volume = m.get('real_volume')
        if m.get('real_weight') is not None:
            self.real_weight = m.get('real_weight')
        if m.get('un_no') is not None:
            self.un_no = m.get('un_no')
        if m.get('volume') is not None:
            self.volume = m.get('volume')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class UploadOrderBooking(TeaModel):
    def __init__(
        self,
        booking_no: str = None,
        container_nos: str = None,
    ):
        # 订舱单号
        self.booking_no = booking_no
        # 集装箱号  json字符串上传
        self.container_nos = container_nos

    def validate(self):
        self.validate_required(self.booking_no, 'booking_no')
        self.validate_required(self.container_nos, 'container_nos')

    def to_map(self):
        result = dict()
        if self.booking_no is not None:
            result['booking_no'] = self.booking_no
        if self.container_nos is not None:
            result['container_nos'] = self.container_nos
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('booking_no') is not None:
            self.booking_no = m.get('booking_no')
        if m.get('container_nos') is not None:
            self.container_nos = m.get('container_nos')
        return self


class ContainerTypeInfo(TeaModel):
    def __init__(
        self,
        container_type: str = None,
        container_volume: str = None,
    ):
        # 箱型
        self.container_type = container_type
        # 箱量
        self.container_volume = container_volume

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.container_type is not None:
            result['container_type'] = self.container_type
        if self.container_volume is not None:
            result['container_volume'] = self.container_volume
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('container_type') is not None:
            self.container_type = m.get('container_type')
        if m.get('container_volume') is not None:
            self.container_volume = m.get('container_volume')
        return self


class VoucherResp(TeaModel):
    def __init__(
        self,
        msg: str = None,
    ):
        # 消息
        self.msg = msg

    def validate(self):
        self.validate_required(self.msg, 'msg')
        if self.msg is not None:
            self.validate_max_length(self.msg, 'msg', 10)

    def to_map(self):
        result = dict()
        if self.msg is not None:
            result['msg'] = self.msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        return self


class ContainerGoodsParam(TeaModel):
    def __init__(
        self,
        cargo_ready_date: int = None,
        dg_page_no: str = None,
        dg_type: str = None,
        flash_point: str = None,
        goods: str = None,
        goods_cn: str = None,
        goods_type: str = None,
        hs_codes: List[str] = None,
        marks: str = None,
        number: str = None,
        package_type: str = None,
        real_number: str = None,
        real_volume: str = None,
        real_weight: str = None,
        un_no: str = None,
        volume: str = None,
        weight: str = None,
    ):
        # 预计备货时间
        self.cargo_ready_date = cargo_ready_date
        # 危险品页号
        self.dg_page_no = dg_page_no
        # 危险品级别
        self.dg_type = dg_type
        # 危险品闪点
        self.flash_point = flash_point
        # 货物
        self.goods = goods
        # 货物中文名
        self.goods_cn = goods_cn
        # 货物类型 业务必填
        self.goods_type = goods_type
        # HS CODE
        self.hs_codes = hs_codes
        # 唛头
        self.marks = marks
        # 件数 业务必填
        self.number = number
        # 包装类型
        self.package_type = package_type
        # 实际件数
        self.real_number = real_number
        # 实际体积
        self.real_volume = real_volume
        # 实际重量
        self.real_weight = real_weight
        # 危险品联合国编号
        self.un_no = un_no
        # 体积 业务必填
        self.volume = volume
        # 毛重 业务必填
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.cargo_ready_date is not None:
            result['cargo_ready_date'] = self.cargo_ready_date
        if self.dg_page_no is not None:
            result['dg_page_no'] = self.dg_page_no
        if self.dg_type is not None:
            result['dg_type'] = self.dg_type
        if self.flash_point is not None:
            result['flash_point'] = self.flash_point
        if self.goods is not None:
            result['goods'] = self.goods
        if self.goods_cn is not None:
            result['goods_cn'] = self.goods_cn
        if self.goods_type is not None:
            result['goods_type'] = self.goods_type
        if self.hs_codes is not None:
            result['hs_codes'] = self.hs_codes
        if self.marks is not None:
            result['marks'] = self.marks
        if self.number is not None:
            result['number'] = self.number
        if self.package_type is not None:
            result['package_type'] = self.package_type
        if self.real_number is not None:
            result['real_number'] = self.real_number
        if self.real_volume is not None:
            result['real_volume'] = self.real_volume
        if self.real_weight is not None:
            result['real_weight'] = self.real_weight
        if self.un_no is not None:
            result['un_no'] = self.un_no
        if self.volume is not None:
            result['volume'] = self.volume
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cargo_ready_date') is not None:
            self.cargo_ready_date = m.get('cargo_ready_date')
        if m.get('dg_page_no') is not None:
            self.dg_page_no = m.get('dg_page_no')
        if m.get('dg_type') is not None:
            self.dg_type = m.get('dg_type')
        if m.get('flash_point') is not None:
            self.flash_point = m.get('flash_point')
        if m.get('goods') is not None:
            self.goods = m.get('goods')
        if m.get('goods_cn') is not None:
            self.goods_cn = m.get('goods_cn')
        if m.get('goods_type') is not None:
            self.goods_type = m.get('goods_type')
        if m.get('hs_codes') is not None:
            self.hs_codes = m.get('hs_codes')
        if m.get('marks') is not None:
            self.marks = m.get('marks')
        if m.get('number') is not None:
            self.number = m.get('number')
        if m.get('package_type') is not None:
            self.package_type = m.get('package_type')
        if m.get('real_number') is not None:
            self.real_number = m.get('real_number')
        if m.get('real_volume') is not None:
            self.real_volume = m.get('real_volume')
        if m.get('real_weight') is not None:
            self.real_weight = m.get('real_weight')
        if m.get('un_no') is not None:
            self.un_no = m.get('un_no')
        if m.get('volume') is not None:
            self.volume = m.get('volume')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class PayBillInvoiceParam(TeaModel):
    def __init__(
        self,
        pay_bill_invoice_code: str = None,
        pay_bill_order_code: str = None,
        pay_bill_amount: str = None,
        invoice_amount: str = None,
        action: str = None,
    ):
        # 账单发票code
        self.pay_bill_invoice_code = pay_bill_invoice_code
        # 账单编号
        self.pay_bill_order_code = pay_bill_order_code
        # 账单金额
        self.pay_bill_amount = pay_bill_amount
        # 发票金额
        self.invoice_amount = invoice_amount
        # 操作动作
        self.action = action

    def validate(self):
        self.validate_required(self.pay_bill_invoice_code, 'pay_bill_invoice_code')
        self.validate_required(self.pay_bill_order_code, 'pay_bill_order_code')
        self.validate_required(self.pay_bill_amount, 'pay_bill_amount')
        self.validate_required(self.invoice_amount, 'invoice_amount')

    def to_map(self):
        result = dict()
        if self.pay_bill_invoice_code is not None:
            result['pay_bill_invoice_code'] = self.pay_bill_invoice_code
        if self.pay_bill_order_code is not None:
            result['pay_bill_order_code'] = self.pay_bill_order_code
        if self.pay_bill_amount is not None:
            result['pay_bill_amount'] = self.pay_bill_amount
        if self.invoice_amount is not None:
            result['invoice_amount'] = self.invoice_amount
        if self.action is not None:
            result['action'] = self.action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('pay_bill_invoice_code') is not None:
            self.pay_bill_invoice_code = m.get('pay_bill_invoice_code')
        if m.get('pay_bill_order_code') is not None:
            self.pay_bill_order_code = m.get('pay_bill_order_code')
        if m.get('pay_bill_amount') is not None:
            self.pay_bill_amount = m.get('pay_bill_amount')
        if m.get('invoice_amount') is not None:
            self.invoice_amount = m.get('invoice_amount')
        if m.get('action') is not None:
            self.action = m.get('action')
        return self


class PayAmount(TeaModel):
    def __init__(
        self,
        amount: str = None,
        pay_type: str = None,
    ):
        # 支付金额（2位小数）
        self.amount = amount
        # 支付方式
        self.pay_type = pay_type

    def validate(self):
        self.validate_required(self.amount, 'amount')
        self.validate_required(self.pay_type, 'pay_type')

    def to_map(self):
        result = dict()
        if self.amount is not None:
            result['amount'] = self.amount
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('amount') is not None:
            self.amount = m.get('amount')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        return self


class PayBillTariffParam(TeaModel):
    def __init__(
        self,
        action: str = None,
        bill_amount: str = None,
        pay_bill_tariff_code: str = None,
        pay_tariff_amount: str = None,
        pay_tariff_code: str = None,
    ):
        # 操作动作,为空为新增或更新，UPDATE为更新，DELETE为删除
        self.action = action
        # 账单金额 业务必填
        self.bill_amount = bill_amount
        # 应付账单、应付资费项 多对多code
        self.pay_bill_tariff_code = pay_bill_tariff_code
        # 资费项金额 业务必填
        self.pay_tariff_amount = pay_tariff_amount
        # 应付资费项编号 业务必填
        self.pay_tariff_code = pay_tariff_code

    def validate(self):
        self.validate_required(self.pay_bill_tariff_code, 'pay_bill_tariff_code')

    def to_map(self):
        result = dict()
        if self.action is not None:
            result['action'] = self.action
        if self.bill_amount is not None:
            result['bill_amount'] = self.bill_amount
        if self.pay_bill_tariff_code is not None:
            result['pay_bill_tariff_code'] = self.pay_bill_tariff_code
        if self.pay_tariff_amount is not None:
            result['pay_tariff_amount'] = self.pay_tariff_amount
        if self.pay_tariff_code is not None:
            result['pay_tariff_code'] = self.pay_tariff_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('bill_amount') is not None:
            self.bill_amount = m.get('bill_amount')
        if m.get('pay_bill_tariff_code') is not None:
            self.pay_bill_tariff_code = m.get('pay_bill_tariff_code')
        if m.get('pay_tariff_amount') is not None:
            self.pay_tariff_amount = m.get('pay_tariff_amount')
        if m.get('pay_tariff_code') is not None:
            self.pay_tariff_code = m.get('pay_tariff_code')
        return self


class TrackCheckResult(TeaModel):
    def __init__(
        self,
        track_check_status: str = None,
        track_check_status_msg: str = None,
    ):
        # 轨迹核验状态code
        self.track_check_status = track_check_status
        # 轨迹核验结果描述
        self.track_check_status_msg = track_check_status_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.track_check_status is not None:
            result['track_check_status'] = self.track_check_status
        if self.track_check_status_msg is not None:
            result['track_check_status_msg'] = self.track_check_status_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('track_check_status') is not None:
            self.track_check_status = m.get('track_check_status')
        if m.get('track_check_status_msg') is not None:
            self.track_check_status_msg = m.get('track_check_status_msg')
        return self


class HouseBlContainerParam(TeaModel):
    def __init__(
        self,
        action: str = None,
        container_id: str = None,
        container_no: str = None,
    ):
        # 操作动作,为空为新增或更新，UPDATE为更新，DELETE为删除
        self.action = action
        # 集装箱ID
        self.container_id = container_id
        # 箱号
        self.container_no = container_no

    def validate(self):
        self.validate_required(self.container_id, 'container_id')

    def to_map(self):
        result = dict()
        if self.action is not None:
            result['action'] = self.action
        if self.container_id is not None:
            result['container_id'] = self.container_id
        if self.container_no is not None:
            result['container_no'] = self.container_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('container_id') is not None:
            self.container_id = m.get('container_id')
        if m.get('container_no') is not None:
            self.container_no = m.get('container_no')
        return self


class MasterBlGoodsParam(TeaModel):
    def __init__(
        self,
        cargo_ready_date: int = None,
        dg_page_no: str = None,
        dg_type: str = None,
        flash_point: str = None,
        goods: str = None,
        goods_cn: str = None,
        goods_type: str = None,
        gross_weight: str = None,
        hs_codes: List[str] = None,
        marks: str = None,
        number: str = None,
        package_type: str = None,
        real_number: str = None,
        real_volume: str = None,
        real_weight: str = None,
        un_no: str = None,
        volume: str = None,
        weight: str = None,
    ):
        # 预计备货时间
        self.cargo_ready_date = cargo_ready_date
        # 危险品页号
        self.dg_page_no = dg_page_no
        # 危险品级别
        self.dg_type = dg_type
        # 危险品闪点
        self.flash_point = flash_point
        # 货物名称 业务必填
        self.goods = goods
        # 货物中文名
        self.goods_cn = goods_cn
        # 货物类型 业务必填
        self.goods_type = goods_type
        # 毛重 业务必填
        self.gross_weight = gross_weight
        # HS CODE
        self.hs_codes = hs_codes
        # 唛头
        self.marks = marks
        # 件数 业务必填
        self.number = number
        # 包装类型
        self.package_type = package_type
        # 实际件数
        self.real_number = real_number
        # 实际体积
        self.real_volume = real_volume
        # 实际重量
        self.real_weight = real_weight
        # 危险品联合国编号
        self.un_no = un_no
        # 委托体积 业务必填
        self.volume = volume
        # 委托重量 业务必填
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.cargo_ready_date is not None:
            result['cargo_ready_date'] = self.cargo_ready_date
        if self.dg_page_no is not None:
            result['dg_page_no'] = self.dg_page_no
        if self.dg_type is not None:
            result['dg_type'] = self.dg_type
        if self.flash_point is not None:
            result['flash_point'] = self.flash_point
        if self.goods is not None:
            result['goods'] = self.goods
        if self.goods_cn is not None:
            result['goods_cn'] = self.goods_cn
        if self.goods_type is not None:
            result['goods_type'] = self.goods_type
        if self.gross_weight is not None:
            result['gross_weight'] = self.gross_weight
        if self.hs_codes is not None:
            result['hs_codes'] = self.hs_codes
        if self.marks is not None:
            result['marks'] = self.marks
        if self.number is not None:
            result['number'] = self.number
        if self.package_type is not None:
            result['package_type'] = self.package_type
        if self.real_number is not None:
            result['real_number'] = self.real_number
        if self.real_volume is not None:
            result['real_volume'] = self.real_volume
        if self.real_weight is not None:
            result['real_weight'] = self.real_weight
        if self.un_no is not None:
            result['un_no'] = self.un_no
        if self.volume is not None:
            result['volume'] = self.volume
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cargo_ready_date') is not None:
            self.cargo_ready_date = m.get('cargo_ready_date')
        if m.get('dg_page_no') is not None:
            self.dg_page_no = m.get('dg_page_no')
        if m.get('dg_type') is not None:
            self.dg_type = m.get('dg_type')
        if m.get('flash_point') is not None:
            self.flash_point = m.get('flash_point')
        if m.get('goods') is not None:
            self.goods = m.get('goods')
        if m.get('goods_cn') is not None:
            self.goods_cn = m.get('goods_cn')
        if m.get('goods_type') is not None:
            self.goods_type = m.get('goods_type')
        if m.get('gross_weight') is not None:
            self.gross_weight = m.get('gross_weight')
        if m.get('hs_codes') is not None:
            self.hs_codes = m.get('hs_codes')
        if m.get('marks') is not None:
            self.marks = m.get('marks')
        if m.get('number') is not None:
            self.number = m.get('number')
        if m.get('package_type') is not None:
            self.package_type = m.get('package_type')
        if m.get('real_number') is not None:
            self.real_number = m.get('real_number')
        if m.get('real_volume') is not None:
            self.real_volume = m.get('real_volume')
        if m.get('real_weight') is not None:
            self.real_weight = m.get('real_weight')
        if m.get('un_no') is not None:
            self.un_no = m.get('un_no')
        if m.get('volume') is not None:
            self.volume = m.get('volume')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class PaymentInfo(TeaModel):
    def __init__(
        self,
        receiver_account_name: str = None,
        receiver_account: str = None,
        receiver_account_type: str = None,
        receiver_certificate_no: str = None,
        receiver_certificate_type: str = None,
    ):
        # 收款账户名称
        self.receiver_account_name = receiver_account_name
        # 收款账户，支付宝账号
        self.receiver_account = receiver_account
        # 收款账户类型 ,1-个人账号，0-公司账号
        self.receiver_account_type = receiver_account_type
        # 收款人证件号码 ，账户类型为个人时，非空
        self.receiver_certificate_no = receiver_certificate_no
        # 收款人证件类型，01-身份证，02-护照，03-军官证，04-港澳通行证，05-驾驶证，06-港澳回乡证或台胞证，07-临时身份证，99-其他
        self.receiver_certificate_type = receiver_certificate_type

    def validate(self):
        self.validate_required(self.receiver_account_name, 'receiver_account_name')
        if self.receiver_account_name is not None:
            self.validate_max_length(self.receiver_account_name, 'receiver_account_name', 200)
        self.validate_required(self.receiver_account, 'receiver_account')
        if self.receiver_account is not None:
            self.validate_max_length(self.receiver_account, 'receiver_account', 50)
        self.validate_required(self.receiver_account_type, 'receiver_account_type')
        if self.receiver_account_type is not None:
            self.validate_max_length(self.receiver_account_type, 'receiver_account_type', 2)
        if self.receiver_certificate_no is not None:
            self.validate_max_length(self.receiver_certificate_no, 'receiver_certificate_no', 50)
        self.validate_required(self.receiver_certificate_type, 'receiver_certificate_type')
        if self.receiver_certificate_type is not None:
            self.validate_max_length(self.receiver_certificate_type, 'receiver_certificate_type', 2)

    def to_map(self):
        result = dict()
        if self.receiver_account_name is not None:
            result['receiver_account_name'] = self.receiver_account_name
        if self.receiver_account is not None:
            result['receiver_account'] = self.receiver_account
        if self.receiver_account_type is not None:
            result['receiver_account_type'] = self.receiver_account_type
        if self.receiver_certificate_no is not None:
            result['receiver_certificate_no'] = self.receiver_certificate_no
        if self.receiver_certificate_type is not None:
            result['receiver_certificate_type'] = self.receiver_certificate_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('receiver_account_name') is not None:
            self.receiver_account_name = m.get('receiver_account_name')
        if m.get('receiver_account') is not None:
            self.receiver_account = m.get('receiver_account')
        if m.get('receiver_account_type') is not None:
            self.receiver_account_type = m.get('receiver_account_type')
        if m.get('receiver_certificate_no') is not None:
            self.receiver_certificate_no = m.get('receiver_certificate_no')
        if m.get('receiver_certificate_type') is not None:
            self.receiver_certificate_type = m.get('receiver_certificate_type')
        return self


class CargoAmount(TeaModel):
    def __init__(
        self,
        amount: str = None,
        cargo_order: str = None,
    ):
        # 货运单对应金额（2位小数）
        self.amount = amount
        # 货源单号
        self.cargo_order = cargo_order

    def validate(self):
        self.validate_required(self.amount, 'amount')
        self.validate_required(self.cargo_order, 'cargo_order')

    def to_map(self):
        result = dict()
        if self.amount is not None:
            result['amount'] = self.amount
        if self.cargo_order is not None:
            result['cargo_order'] = self.cargo_order
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('amount') is not None:
            self.amount = m.get('amount')
        if m.get('cargo_order') is not None:
            self.cargo_order = m.get('cargo_order')
        return self


class IssueApplyInfo(TeaModel):
    def __init__(
        self,
        cargo_order: str = None,
        contract_id: str = None,
        expire_date: str = None,
        freight: str = None,
        out_biz_no: str = None,
        pay_order: str = None,
        waybill_id: str = None,
        driver_did: str = None,
    ):
        # 货源订单
        self.cargo_order = cargo_order
        # 合同号（预留）
        self.contract_id = contract_id
        # 凭证到期时间
        self.expire_date = expire_date
        # 支付单运费，运费最多精确到小数点后2位
        self.freight = freight
        # 全局唯一业务号
        self.out_biz_no = out_biz_no
        # 支付订单
        self.pay_order = pay_order
        # 运单id
        self.waybill_id = waybill_id
        # 司机did
        self.driver_did = driver_did

    def validate(self):
        self.validate_required(self.expire_date, 'expire_date')
        self.validate_required(self.freight, 'freight')
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.pay_order, 'pay_order')
        self.validate_required(self.waybill_id, 'waybill_id')

    def to_map(self):
        result = dict()
        if self.cargo_order is not None:
            result['cargo_order'] = self.cargo_order
        if self.contract_id is not None:
            result['contract_id'] = self.contract_id
        if self.expire_date is not None:
            result['expire_date'] = self.expire_date
        if self.freight is not None:
            result['freight'] = self.freight
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.pay_order is not None:
            result['pay_order'] = self.pay_order
        if self.waybill_id is not None:
            result['waybill_id'] = self.waybill_id
        if self.driver_did is not None:
            result['driver_did'] = self.driver_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cargo_order') is not None:
            self.cargo_order = m.get('cargo_order')
        if m.get('contract_id') is not None:
            self.contract_id = m.get('contract_id')
        if m.get('expire_date') is not None:
            self.expire_date = m.get('expire_date')
        if m.get('freight') is not None:
            self.freight = m.get('freight')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('pay_order') is not None:
            self.pay_order = m.get('pay_order')
        if m.get('waybill_id') is not None:
            self.waybill_id = m.get('waybill_id')
        if m.get('driver_did') is not None:
            self.driver_did = m.get('driver_did')
        return self


class AuthChainFile(TeaModel):
    def __init__(
        self,
        sign_file_hash: str = None,
        upload_chain_tx_code: str = None,
        baas_uniq_code: str = None,
        upload_chain_time: str = None,
        file_url: str = None,
        file_name: str = None,
    ):
        # 签署文件的hash值
        self.sign_file_hash = sign_file_hash
        # 上链事务唯一标识
        self.upload_chain_tx_code = upload_chain_tx_code
        # 蚂蚁区块链统一证据编号
        self.baas_uniq_code = baas_uniq_code
        # 上链时间(13位毫秒级时间戳)
        self.upload_chain_time = upload_chain_time
        # 上链文件下载链接
        self.file_url = file_url
        # 上链文件名称，要求包含扩展名。文件格式允许: pdf, txt, doc, docx
        self.file_name = file_name

    def validate(self):
        self.validate_required(self.sign_file_hash, 'sign_file_hash')
        self.validate_required(self.upload_chain_tx_code, 'upload_chain_tx_code')
        self.validate_required(self.baas_uniq_code, 'baas_uniq_code')
        self.validate_required(self.upload_chain_time, 'upload_chain_time')
        self.validate_required(self.file_url, 'file_url')
        self.validate_required(self.file_name, 'file_name')

    def to_map(self):
        result = dict()
        if self.sign_file_hash is not None:
            result['sign_file_hash'] = self.sign_file_hash
        if self.upload_chain_tx_code is not None:
            result['upload_chain_tx_code'] = self.upload_chain_tx_code
        if self.baas_uniq_code is not None:
            result['baas_uniq_code'] = self.baas_uniq_code
        if self.upload_chain_time is not None:
            result['upload_chain_time'] = self.upload_chain_time
        if self.file_url is not None:
            result['file_url'] = self.file_url
        if self.file_name is not None:
            result['file_name'] = self.file_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sign_file_hash') is not None:
            self.sign_file_hash = m.get('sign_file_hash')
        if m.get('upload_chain_tx_code') is not None:
            self.upload_chain_tx_code = m.get('upload_chain_tx_code')
        if m.get('baas_uniq_code') is not None:
            self.baas_uniq_code = m.get('baas_uniq_code')
        if m.get('upload_chain_time') is not None:
            self.upload_chain_time = m.get('upload_chain_time')
        if m.get('file_url') is not None:
            self.file_url = m.get('file_url')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        return self


class ScpTicketIssueDataParam(TeaModel):
    def __init__(
        self,
        issue_id: str = None,
        did: str = None,
    ):
        # 凭证id
        self.issue_id = issue_id
        # 凭证对应的司机/货主的did
        self.did = did

    def validate(self):
        self.validate_required(self.issue_id, 'issue_id')
        self.validate_required(self.did, 'did')

    def to_map(self):
        result = dict()
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.did is not None:
            result['did'] = self.did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('did') is not None:
            self.did = m.get('did')
        return self


class CargoLoss(TeaModel):
    def __init__(
        self,
        cargo_type: str = None,
        cargo_name: str = None,
        cargo_owner: str = None,
        cargo_loss_desc: str = None,
        cargo_loss_estimate_amount: str = None,
    ):
        # 物品类型
        self.cargo_type = cargo_type
        # 物品名称
        self.cargo_name = cargo_name
        # 物品所有人
        self.cargo_owner = cargo_owner
        # 物品损失描述
        self.cargo_loss_desc = cargo_loss_desc
        # 损失预估，单位（元），最多支持2位小数
        self.cargo_loss_estimate_amount = cargo_loss_estimate_amount

    def validate(self):
        if self.cargo_type is not None:
            self.validate_max_length(self.cargo_type, 'cargo_type', 200)
        self.validate_required(self.cargo_name, 'cargo_name')
        if self.cargo_name is not None:
            self.validate_max_length(self.cargo_name, 'cargo_name', 500)
        if self.cargo_owner is not None:
            self.validate_max_length(self.cargo_owner, 'cargo_owner', 200)
        if self.cargo_loss_desc is not None:
            self.validate_max_length(self.cargo_loss_desc, 'cargo_loss_desc', 500)
        self.validate_required(self.cargo_loss_estimate_amount, 'cargo_loss_estimate_amount')

    def to_map(self):
        result = dict()
        if self.cargo_type is not None:
            result['cargo_type'] = self.cargo_type
        if self.cargo_name is not None:
            result['cargo_name'] = self.cargo_name
        if self.cargo_owner is not None:
            result['cargo_owner'] = self.cargo_owner
        if self.cargo_loss_desc is not None:
            result['cargo_loss_desc'] = self.cargo_loss_desc
        if self.cargo_loss_estimate_amount is not None:
            result['cargo_loss_estimate_amount'] = self.cargo_loss_estimate_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cargo_type') is not None:
            self.cargo_type = m.get('cargo_type')
        if m.get('cargo_name') is not None:
            self.cargo_name = m.get('cargo_name')
        if m.get('cargo_owner') is not None:
            self.cargo_owner = m.get('cargo_owner')
        if m.get('cargo_loss_desc') is not None:
            self.cargo_loss_desc = m.get('cargo_loss_desc')
        if m.get('cargo_loss_estimate_amount') is not None:
            self.cargo_loss_estimate_amount = m.get('cargo_loss_estimate_amount')
        return self


class ReceiptBillTariffParam(TeaModel):
    def __init__(
        self,
        action: str = None,
        bill_amount: str = None,
        receipt_bill_tariff_code: str = None,
        receipt_tariff_amount: str = None,
        receipt_tariff_code: str = None,
    ):
        # 操作动作,为空为新增或更新，UPDATE为更新，DELETE为删除
        self.action = action
        # 账单金额 业务必填
        self.bill_amount = bill_amount
        # 应收账单 、应收资费项 多对多关联code
        self.receipt_bill_tariff_code = receipt_bill_tariff_code
        # 资费项金额 业务必填
        self.receipt_tariff_amount = receipt_tariff_amount
        # 应收资费项编号 业务必填
        self.receipt_tariff_code = receipt_tariff_code

    def validate(self):
        self.validate_required(self.receipt_bill_tariff_code, 'receipt_bill_tariff_code')

    def to_map(self):
        result = dict()
        if self.action is not None:
            result['action'] = self.action
        if self.bill_amount is not None:
            result['bill_amount'] = self.bill_amount
        if self.receipt_bill_tariff_code is not None:
            result['receipt_bill_tariff_code'] = self.receipt_bill_tariff_code
        if self.receipt_tariff_amount is not None:
            result['receipt_tariff_amount'] = self.receipt_tariff_amount
        if self.receipt_tariff_code is not None:
            result['receipt_tariff_code'] = self.receipt_tariff_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('bill_amount') is not None:
            self.bill_amount = m.get('bill_amount')
        if m.get('receipt_bill_tariff_code') is not None:
            self.receipt_bill_tariff_code = m.get('receipt_bill_tariff_code')
        if m.get('receipt_tariff_amount') is not None:
            self.receipt_tariff_amount = m.get('receipt_tariff_amount')
        if m.get('receipt_tariff_code') is not None:
            self.receipt_tariff_code = m.get('receipt_tariff_code')
        return self


class UploadOrderAmount(TeaModel):
    def __init__(
        self,
        currency: str = None,
        total_amount: str = None,
    ):
        # 币种
        self.currency = currency
        # 总金额
        self.total_amount = total_amount

    def validate(self):
        self.validate_required(self.currency, 'currency')
        self.validate_required(self.total_amount, 'total_amount')

    def to_map(self):
        result = dict()
        if self.currency is not None:
            result['currency'] = self.currency
        if self.total_amount is not None:
            result['total_amount'] = self.total_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('currency') is not None:
            self.currency = m.get('currency')
        if m.get('total_amount') is not None:
            self.total_amount = m.get('total_amount')
        return self


class ClaimInformation(TeaModel):
    def __init__(
        self,
        file_url: str = None,
        file_name: str = None,
    ):
        # 索赔资料地址url
        self.file_url = file_url
        # 文件名
        self.file_name = file_name

    def validate(self):
        self.validate_required(self.file_url, 'file_url')
        if self.file_url is not None:
            self.validate_max_length(self.file_url, 'file_url', 500)
        self.validate_required(self.file_name, 'file_name')
        if self.file_name is not None:
            self.validate_max_length(self.file_name, 'file_name', 200)

    def to_map(self):
        result = dict()
        if self.file_url is not None:
            result['file_url'] = self.file_url
        if self.file_name is not None:
            result['file_name'] = self.file_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('file_url') is not None:
            self.file_url = m.get('file_url')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        return self


class IssueTransferData(TeaModel):
    def __init__(
        self,
        issue_id: str = None,
        payer_did: str = None,
        rcv_did: str = None,
    ):
        # 凭证id
        self.issue_id = issue_id
        # 转出方did
        self.payer_did = payer_did
        # 接收方did
        self.rcv_did = rcv_did

    def validate(self):
        self.validate_required(self.issue_id, 'issue_id')
        self.validate_required(self.payer_did, 'payer_did')
        self.validate_required(self.rcv_did, 'rcv_did')

    def to_map(self):
        result = dict()
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.payer_did is not None:
            result['payer_did'] = self.payer_did
        if self.rcv_did is not None:
            result['rcv_did'] = self.rcv_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('payer_did') is not None:
            self.payer_did = m.get('payer_did')
        if m.get('rcv_did') is not None:
            self.rcv_did = m.get('rcv_did')
        return self


class EblDetail(TeaModel):
    def __init__(
        self,
        ebl_copy_pdf_file_hash: str = None,
        ebl_copy_pdf_file_id: str = None,
        ebl_no: str = None,
    ):
        # 电子提单copy文件hash
        self.ebl_copy_pdf_file_hash = ebl_copy_pdf_file_hash
        # 电子提单copy文件id
        self.ebl_copy_pdf_file_id = ebl_copy_pdf_file_id
        # 电子提单编号
        self.ebl_no = ebl_no

    def validate(self):
        self.validate_required(self.ebl_copy_pdf_file_hash, 'ebl_copy_pdf_file_hash')
        self.validate_required(self.ebl_copy_pdf_file_id, 'ebl_copy_pdf_file_id')
        self.validate_required(self.ebl_no, 'ebl_no')

    def to_map(self):
        result = dict()
        if self.ebl_copy_pdf_file_hash is not None:
            result['ebl_copy_pdf_file_hash'] = self.ebl_copy_pdf_file_hash
        if self.ebl_copy_pdf_file_id is not None:
            result['ebl_copy_pdf_file_id'] = self.ebl_copy_pdf_file_id
        if self.ebl_no is not None:
            result['ebl_no'] = self.ebl_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ebl_copy_pdf_file_hash') is not None:
            self.ebl_copy_pdf_file_hash = m.get('ebl_copy_pdf_file_hash')
        if m.get('ebl_copy_pdf_file_id') is not None:
            self.ebl_copy_pdf_file_id = m.get('ebl_copy_pdf_file_id')
        if m.get('ebl_no') is not None:
            self.ebl_no = m.get('ebl_no')
        return self


class UploadFileInfo(TeaModel):
    def __init__(
        self,
        file_id: str = None,
        file_hash: str = None,
    ):
        # 文件id
        self.file_id = file_id
        # 文件hash
        self.file_hash = file_hash

    def validate(self):
        self.validate_required(self.file_id, 'file_id')
        self.validate_required(self.file_hash, 'file_hash')

    def to_map(self):
        result = dict()
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.file_hash is not None:
            result['file_hash'] = self.file_hash
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('file_hash') is not None:
            self.file_hash = m.get('file_hash')
        return self


class MasterBlGoodsDto(TeaModel):
    def __init__(
        self,
        marks: str = None,
        goods: str = None,
        goods_type: str = None,
        package_type: str = None,
        number: str = None,
        weight: str = None,
        volume: str = None,
    ):
        # 唛头
        self.marks = marks
        # 货物
        self.goods = goods
        # 货物类型
        self.goods_type = goods_type
        # 包装类型
        self.package_type = package_type
        # 委托件数
        self.number = number
        # 委托重量
        self.weight = weight
        # 委托体积
        self.volume = volume

    def validate(self):
        self.validate_required(self.goods, 'goods')
        self.validate_required(self.goods_type, 'goods_type')
        self.validate_required(self.number, 'number')
        self.validate_required(self.weight, 'weight')
        self.validate_required(self.volume, 'volume')

    def to_map(self):
        result = dict()
        if self.marks is not None:
            result['marks'] = self.marks
        if self.goods is not None:
            result['goods'] = self.goods
        if self.goods_type is not None:
            result['goods_type'] = self.goods_type
        if self.package_type is not None:
            result['package_type'] = self.package_type
        if self.number is not None:
            result['number'] = self.number
        if self.weight is not None:
            result['weight'] = self.weight
        if self.volume is not None:
            result['volume'] = self.volume
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('marks') is not None:
            self.marks = m.get('marks')
        if m.get('goods') is not None:
            self.goods = m.get('goods')
        if m.get('goods_type') is not None:
            self.goods_type = m.get('goods_type')
        if m.get('package_type') is not None:
            self.package_type = m.get('package_type')
        if m.get('number') is not None:
            self.number = m.get('number')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        if m.get('volume') is not None:
            self.volume = m.get('volume')
        return self


class WaybillAmount(TeaModel):
    def __init__(
        self,
        amount: str = None,
        waybill_id: str = None,
    ):
        # 运单金额（2位小数）
        self.amount = amount
        # 运单号
        self.waybill_id = waybill_id

    def validate(self):
        self.validate_required(self.amount, 'amount')
        self.validate_required(self.waybill_id, 'waybill_id')

    def to_map(self):
        result = dict()
        if self.amount is not None:
            result['amount'] = self.amount
        if self.waybill_id is not None:
            result['waybill_id'] = self.waybill_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('amount') is not None:
            self.amount = m.get('amount')
        if m.get('waybill_id') is not None:
            self.waybill_id = m.get('waybill_id')
        return self


class InsureCarrierObjectInfo(TeaModel):
    def __init__(
        self,
        cp_model: str = None,
        frame_no: str = None,
        license_no: str = None,
        ton_nage: str = None,
        driv_per: str = None,
        run_no: str = None,
        ts_car_go: str = None,
    ):
        # 厂牌型号
        self.cp_model = cp_model
        # 车架号
        self.frame_no = frame_no
        # 车牌号码
        self.license_no = license_no
        # 吨位
        self.ton_nage = ton_nage
        # 行驶证车主
        self.driv_per = driv_per
        # 运营证号
        self.run_no = run_no
        # 运输货物
        self.ts_car_go = ts_car_go

    def validate(self):
        self.validate_required(self.cp_model, 'cp_model')
        self.validate_required(self.frame_no, 'frame_no')
        self.validate_required(self.license_no, 'license_no')
        self.validate_required(self.ton_nage, 'ton_nage')
        self.validate_required(self.driv_per, 'driv_per')
        self.validate_required(self.run_no, 'run_no')
        self.validate_required(self.ts_car_go, 'ts_car_go')

    def to_map(self):
        result = dict()
        if self.cp_model is not None:
            result['cp_model'] = self.cp_model
        if self.frame_no is not None:
            result['frame_no'] = self.frame_no
        if self.license_no is not None:
            result['license_no'] = self.license_no
        if self.ton_nage is not None:
            result['ton_nage'] = self.ton_nage
        if self.driv_per is not None:
            result['driv_per'] = self.driv_per
        if self.run_no is not None:
            result['run_no'] = self.run_no
        if self.ts_car_go is not None:
            result['ts_car_go'] = self.ts_car_go
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cp_model') is not None:
            self.cp_model = m.get('cp_model')
        if m.get('frame_no') is not None:
            self.frame_no = m.get('frame_no')
        if m.get('license_no') is not None:
            self.license_no = m.get('license_no')
        if m.get('ton_nage') is not None:
            self.ton_nage = m.get('ton_nage')
        if m.get('driv_per') is not None:
            self.driv_per = m.get('driv_per')
        if m.get('run_no') is not None:
            self.run_no = m.get('run_no')
        if m.get('ts_car_go') is not None:
            self.ts_car_go = m.get('ts_car_go')
        return self


class VoucherTestTwo(TeaModel):
    def __init__(
        self,
        voucher_test_two_boolean: bool = None,
        voucher_test_two_api_test_list: List[VoucherTestOne] = None,
        voucher_test_two_int: int = None,
        voucher_test_two_integer: int = None,
        voucher_test_two_date_list: List[str] = None,
        voucher_test_two_string: str = None,
        voucher_test_two_date: str = None,
        voucher_test_two_integer_list: List[int] = None,
        voucher_test_two_long: int = None,
        voucher_test_two_long_list: List[int] = None,
        voucher_test_two_string_list: List[str] = None,
        voucher_test_two_api_test_info: VoucherTestOne = None,
        voucher_test_two_boolean_list: List[bool] = None,
    ):
        # 测试Boolean
        self.voucher_test_two_boolean = voucher_test_two_boolean
        # 凭证列表_apiTestList
        self.voucher_test_two_api_test_list = voucher_test_two_api_test_list
        # 测试Int
        self.voucher_test_two_int = voucher_test_two_int
        # 测试Integer
        self.voucher_test_two_integer = voucher_test_two_integer
        # 凭证列表_dateList
        self.voucher_test_two_date_list = voucher_test_two_date_list
        # 测试String
        self.voucher_test_two_string = voucher_test_two_string
        # 测试Date
        self.voucher_test_two_date = voucher_test_two_date
        # 凭证列表_integerList
        self.voucher_test_two_integer_list = voucher_test_two_integer_list
        # 测试Long
        self.voucher_test_two_long = voucher_test_two_long
        # 凭证列表_longList
        self.voucher_test_two_long_list = voucher_test_two_long_list
        # 凭证列表_stringList
        self.voucher_test_two_string_list = voucher_test_two_string_list
        # 测试apiTestInfo
        self.voucher_test_two_api_test_info = voucher_test_two_api_test_info
        # 凭证列表_booleanList
        self.voucher_test_two_boolean_list = voucher_test_two_boolean_list

    def validate(self):
        self.validate_required(self.voucher_test_two_boolean, 'voucher_test_two_boolean')
        self.validate_required(self.voucher_test_two_api_test_list, 'voucher_test_two_api_test_list')
        if self.voucher_test_two_api_test_list:
            for k in self.voucher_test_two_api_test_list:
                if k:
                    k.validate()
        self.validate_required(self.voucher_test_two_int, 'voucher_test_two_int')
        self.validate_required(self.voucher_test_two_integer, 'voucher_test_two_integer')
        if self.voucher_test_two_integer is not None:
            self.validate_maximum(self.voucher_test_two_integer, 'voucher_test_two_integer', 10)
            self.validate_minimum(self.voucher_test_two_integer, 'voucher_test_two_integer', 0)
        self.validate_required(self.voucher_test_two_date_list, 'voucher_test_two_date_list')
        self.validate_required(self.voucher_test_two_string, 'voucher_test_two_string')
        if self.voucher_test_two_string is not None:
            self.validate_max_length(self.voucher_test_two_string, 'voucher_test_two_string', 10)
        self.validate_required(self.voucher_test_two_date, 'voucher_test_two_date')
        if self.voucher_test_two_date is not None:
            self.validate_pattern(self.voucher_test_two_date, 'voucher_test_two_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.voucher_test_two_integer_list, 'voucher_test_two_integer_list')
        self.validate_required(self.voucher_test_two_long, 'voucher_test_two_long')
        if self.voucher_test_two_long is not None:
            self.validate_maximum(self.voucher_test_two_long, 'voucher_test_two_long', 10)
            self.validate_minimum(self.voucher_test_two_long, 'voucher_test_two_long', 0)
        self.validate_required(self.voucher_test_two_long_list, 'voucher_test_two_long_list')
        self.validate_required(self.voucher_test_two_string_list, 'voucher_test_two_string_list')
        self.validate_required(self.voucher_test_two_api_test_info, 'voucher_test_two_api_test_info')
        if self.voucher_test_two_api_test_info:
            self.voucher_test_two_api_test_info.validate()
        self.validate_required(self.voucher_test_two_boolean_list, 'voucher_test_two_boolean_list')

    def to_map(self):
        result = dict()
        if self.voucher_test_two_boolean is not None:
            result['voucher_test_two_boolean'] = self.voucher_test_two_boolean
        result['voucher_test_two_api_test_list'] = []
        if self.voucher_test_two_api_test_list is not None:
            for k in self.voucher_test_two_api_test_list:
                result['voucher_test_two_api_test_list'].append(k.to_map() if k else None)
        if self.voucher_test_two_int is not None:
            result['voucher_test_two_int'] = self.voucher_test_two_int
        if self.voucher_test_two_integer is not None:
            result['voucher_test_two_integer'] = self.voucher_test_two_integer
        if self.voucher_test_two_date_list is not None:
            result['voucher_test_two_date_list'] = self.voucher_test_two_date_list
        if self.voucher_test_two_string is not None:
            result['voucher_test_two_string'] = self.voucher_test_two_string
        if self.voucher_test_two_date is not None:
            result['voucher_test_two_date'] = self.voucher_test_two_date
        if self.voucher_test_two_integer_list is not None:
            result['voucher_test_two_integer_list'] = self.voucher_test_two_integer_list
        if self.voucher_test_two_long is not None:
            result['voucher_test_two_long'] = self.voucher_test_two_long
        if self.voucher_test_two_long_list is not None:
            result['voucher_test_two_long_list'] = self.voucher_test_two_long_list
        if self.voucher_test_two_string_list is not None:
            result['voucher_test_two_string_list'] = self.voucher_test_two_string_list
        if self.voucher_test_two_api_test_info is not None:
            result['voucher_test_two_api_test_info'] = self.voucher_test_two_api_test_info.to_map()
        if self.voucher_test_two_boolean_list is not None:
            result['voucher_test_two_boolean_list'] = self.voucher_test_two_boolean_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('voucher_test_two_boolean') is not None:
            self.voucher_test_two_boolean = m.get('voucher_test_two_boolean')
        self.voucher_test_two_api_test_list = []
        if m.get('voucher_test_two_api_test_list') is not None:
            for k in m.get('voucher_test_two_api_test_list'):
                temp_model = VoucherTestOne()
                self.voucher_test_two_api_test_list.append(temp_model.from_map(k))
        if m.get('voucher_test_two_int') is not None:
            self.voucher_test_two_int = m.get('voucher_test_two_int')
        if m.get('voucher_test_two_integer') is not None:
            self.voucher_test_two_integer = m.get('voucher_test_two_integer')
        if m.get('voucher_test_two_date_list') is not None:
            self.voucher_test_two_date_list = m.get('voucher_test_two_date_list')
        if m.get('voucher_test_two_string') is not None:
            self.voucher_test_two_string = m.get('voucher_test_two_string')
        if m.get('voucher_test_two_date') is not None:
            self.voucher_test_two_date = m.get('voucher_test_two_date')
        if m.get('voucher_test_two_integer_list') is not None:
            self.voucher_test_two_integer_list = m.get('voucher_test_two_integer_list')
        if m.get('voucher_test_two_long') is not None:
            self.voucher_test_two_long = m.get('voucher_test_two_long')
        if m.get('voucher_test_two_long_list') is not None:
            self.voucher_test_two_long_list = m.get('voucher_test_two_long_list')
        if m.get('voucher_test_two_string_list') is not None:
            self.voucher_test_two_string_list = m.get('voucher_test_two_string_list')
        if m.get('voucher_test_two_api_test_info') is not None:
            temp_model = VoucherTestOne()
            self.voucher_test_two_api_test_info = temp_model.from_map(m['voucher_test_two_api_test_info'])
        if m.get('voucher_test_two_boolean_list') is not None:
            self.voucher_test_two_boolean_list = m.get('voucher_test_two_boolean_list')
        return self


class ReceiptTariffInvoiceParam(TeaModel):
    def __init__(
        self,
        action: str = None,
        invoice_amount: str = None,
        receipt_tariff_amount: str = None,
        receipt_tariff_code: str = None,
        receipt_tariff_invoice_code: str = None,
    ):
        # 操作动作,为空为新增或更新，UPDATE为更新，DELETE为删除
        self.action = action
        # 发票金额 业务必填
        self.invoice_amount = invoice_amount
        # 资费项金额 业务必填
        self.receipt_tariff_amount = receipt_tariff_amount
        # 资费单据编号 业务必填
        self.receipt_tariff_code = receipt_tariff_code
        # 资费项发票code
        self.receipt_tariff_invoice_code = receipt_tariff_invoice_code

    def validate(self):
        self.validate_required(self.receipt_tariff_invoice_code, 'receipt_tariff_invoice_code')

    def to_map(self):
        result = dict()
        if self.action is not None:
            result['action'] = self.action
        if self.invoice_amount is not None:
            result['invoice_amount'] = self.invoice_amount
        if self.receipt_tariff_amount is not None:
            result['receipt_tariff_amount'] = self.receipt_tariff_amount
        if self.receipt_tariff_code is not None:
            result['receipt_tariff_code'] = self.receipt_tariff_code
        if self.receipt_tariff_invoice_code is not None:
            result['receipt_tariff_invoice_code'] = self.receipt_tariff_invoice_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('invoice_amount') is not None:
            self.invoice_amount = m.get('invoice_amount')
        if m.get('receipt_tariff_amount') is not None:
            self.receipt_tariff_amount = m.get('receipt_tariff_amount')
        if m.get('receipt_tariff_code') is not None:
            self.receipt_tariff_code = m.get('receipt_tariff_code')
        if m.get('receipt_tariff_invoice_code') is not None:
            self.receipt_tariff_invoice_code = m.get('receipt_tariff_invoice_code')
        return self


class ContainerIdInfo(TeaModel):
    def __init__(
        self,
        container_id: str = None,
        container_no: str = None,
    ):
        # 箱子唯一标识
        self.container_id = container_id
        # 箱号
        self.container_no = container_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.container_id is not None:
            result['container_id'] = self.container_id
        if self.container_no is not None:
            result['container_no'] = self.container_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('container_id') is not None:
            self.container_id = m.get('container_id')
        if m.get('container_no') is not None:
            self.container_no = m.get('container_no')
        return self


class Document(TeaModel):
    def __init__(
        self,
        document_url: str = None,
        document_name: str = None,
    ):
        # 文档url
        self.document_url = document_url
        # 文档名称
        self.document_name = document_name

    def validate(self):
        self.validate_required(self.document_url, 'document_url')
        if self.document_url is not None:
            self.validate_max_length(self.document_url, 'document_url', 500)
        self.validate_required(self.document_name, 'document_name')
        if self.document_name is not None:
            self.validate_max_length(self.document_name, 'document_name', 200)

    def to_map(self):
        result = dict()
        if self.document_url is not None:
            result['document_url'] = self.document_url
        if self.document_name is not None:
            result['document_name'] = self.document_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('document_url') is not None:
            self.document_url = m.get('document_url')
        if m.get('document_name') is not None:
            self.document_name = m.get('document_name')
        return self


class GoodsInfo(TeaModel):
    def __init__(
        self,
        goods_id: str = None,
        marks: str = None,
        goods: str = None,
        goods_type: str = None,
        weight: str = None,
        number: str = None,
    ):
        # 货物ID [业务必填]
        self.goods_id = goods_id
        # 唛头
        # 
        # 
        self.marks = marks
        # 货物名称
        self.goods = goods
        # 货物类型
        self.goods_type = goods_type
        # 货物重量
        self.weight = weight
        # 件数
        self.number = number

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.goods_id is not None:
            result['goods_id'] = self.goods_id
        if self.marks is not None:
            result['marks'] = self.marks
        if self.goods is not None:
            result['goods'] = self.goods
        if self.goods_type is not None:
            result['goods_type'] = self.goods_type
        if self.weight is not None:
            result['weight'] = self.weight
        if self.number is not None:
            result['number'] = self.number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('goods_id') is not None:
            self.goods_id = m.get('goods_id')
        if m.get('marks') is not None:
            self.marks = m.get('marks')
        if m.get('goods') is not None:
            self.goods = m.get('goods')
        if m.get('goods_type') is not None:
            self.goods_type = m.get('goods_type')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        if m.get('number') is not None:
            self.number = m.get('number')
        return self


class PfCreditQuotaInfo(TeaModel):
    def __init__(
        self,
        cert_no: str = None,
        cert_type: str = None,
        credit_end: str = None,
        credit_start: str = None,
        quota_no: str = None,
        remaining_quota: str = None,
        remark: str = None,
        status: str = None,
        total_quota: str = None,
        update_time: str = None,
        total_pledge_quota: str = None,
        remain_pledge_quota: str = None,
    ):
        # 证件号
        self.cert_no = cert_no
        # 证件类型
        self.cert_type = cert_type
        # 授信到期日期
        self.credit_end = credit_end
        # 授信起始日期
        self.credit_start = credit_start
        # 额度编号
        self.quota_no = quota_no
        # 剩余额度
        self.remaining_quota = remaining_quota
        # SON:放款账号loanAccNo
        # 还款账号repayAcctNo
        self.remark = remark
        # 额度状态：
        # 0、停用 / 1、启用  /  2、冻结
        self.status = status
        # 授信额度
        self.total_quota = total_quota
        # 数据更新时间
        self.update_time = update_time
        # 总质押额度
        self.total_pledge_quota = total_pledge_quota
        # 剩余质押额度
        self.remain_pledge_quota = remain_pledge_quota

    def validate(self):
        self.validate_required(self.cert_no, 'cert_no')
        self.validate_required(self.cert_type, 'cert_type')
        self.validate_required(self.credit_end, 'credit_end')
        self.validate_required(self.credit_start, 'credit_start')
        self.validate_required(self.quota_no, 'quota_no')
        self.validate_required(self.remaining_quota, 'remaining_quota')
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.status, 'status')
        self.validate_required(self.total_quota, 'total_quota')
        self.validate_required(self.update_time, 'update_time')
        self.validate_required(self.total_pledge_quota, 'total_pledge_quota')
        self.validate_required(self.remain_pledge_quota, 'remain_pledge_quota')

    def to_map(self):
        result = dict()
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.cert_type is not None:
            result['cert_type'] = self.cert_type
        if self.credit_end is not None:
            result['credit_end'] = self.credit_end
        if self.credit_start is not None:
            result['credit_start'] = self.credit_start
        if self.quota_no is not None:
            result['quota_no'] = self.quota_no
        if self.remaining_quota is not None:
            result['remaining_quota'] = self.remaining_quota
        if self.remark is not None:
            result['remark'] = self.remark
        if self.status is not None:
            result['status'] = self.status
        if self.total_quota is not None:
            result['total_quota'] = self.total_quota
        if self.update_time is not None:
            result['update_time'] = self.update_time
        if self.total_pledge_quota is not None:
            result['total_pledge_quota'] = self.total_pledge_quota
        if self.remain_pledge_quota is not None:
            result['remain_pledge_quota'] = self.remain_pledge_quota
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('cert_type') is not None:
            self.cert_type = m.get('cert_type')
        if m.get('credit_end') is not None:
            self.credit_end = m.get('credit_end')
        if m.get('credit_start') is not None:
            self.credit_start = m.get('credit_start')
        if m.get('quota_no') is not None:
            self.quota_no = m.get('quota_no')
        if m.get('remaining_quota') is not None:
            self.remaining_quota = m.get('remaining_quota')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('total_quota') is not None:
            self.total_quota = m.get('total_quota')
        if m.get('update_time') is not None:
            self.update_time = m.get('update_time')
        if m.get('total_pledge_quota') is not None:
            self.total_pledge_quota = m.get('total_pledge_quota')
        if m.get('remain_pledge_quota') is not None:
            self.remain_pledge_quota = m.get('remain_pledge_quota')
        return self


class CreateReceivableBillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        test: AuthParty = None,
        status: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 测试
        self.test = test
        # 的撒
        self.status = status

    def validate(self):
        if self.test:
            self.test.validate()
        self.validate_required(self.status, 'status')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.test is not None:
            result['test'] = self.test.to_map()
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('test') is not None:
            temp_model = AuthParty()
            self.test = temp_model.from_map(m['test'])
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class CreateReceivableBillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_codes: List[TxDto] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回结果
        self.tx_codes = tx_codes

    def validate(self):
        if self.tx_codes:
            for k in self.tx_codes:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['tx_codes'] = []
        if self.tx_codes is not None:
            for k in self.tx_codes:
                result['tx_codes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.tx_codes = []
        if m.get('tx_codes') is not None:
            for k in m.get('tx_codes'):
                temp_model = TxDto()
                self.tx_codes.append(temp_model.from_map(k))
        return self


class CreateStandardVoucherRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        exist: bool = None,
        voucher_test_one: VoucherTestTwo = None,
        business_code: str = None,
        voucher_test_three: List[VoucherTestTwo] = None,
        issue_time: str = None,
        voucher_list: List[str] = None,
        amount_long: int = None,
        amount_int: int = None,
        voucher_test_two: VoucherTestTwo = None,
        boolean_list: List[bool] = None,
        date_list: List[str] = None,
        asset_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 账户是否存在
        self.exist = exist
        # 签署方
        self.voucher_test_one = voucher_test_one
        # 数据标识
        self.business_code = business_code
        # 凭证列表_apiTestList
        self.voucher_test_three = voucher_test_three
        # 发行时间
        self.issue_time = issue_time
        # 凭证列表_voucherList
        self.voucher_list = voucher_list
        # 发行金额_Long
        self.amount_long = amount_long
        # 发行金额_Integer
        self.amount_int = amount_int
        # 签署方
        self.voucher_test_two = voucher_test_two
        # 凭证列表_booleanList
        self.boolean_list = boolean_list
        # 凭证列表_dateList
        self.date_list = date_list
        # 资产类型
        self.asset_type = asset_type

    def validate(self):
        self.validate_required(self.exist, 'exist')
        self.validate_required(self.voucher_test_one, 'voucher_test_one')
        if self.voucher_test_one:
            self.voucher_test_one.validate()
        self.validate_required(self.business_code, 'business_code')
        if self.business_code is not None:
            self.validate_max_length(self.business_code, 'business_code', 10)
        self.validate_required(self.voucher_test_three, 'voucher_test_three')
        if self.voucher_test_three:
            for k in self.voucher_test_three:
                if k:
                    k.validate()
        self.validate_required(self.issue_time, 'issue_time')
        if self.issue_time is not None:
            self.validate_pattern(self.issue_time, 'issue_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.voucher_list, 'voucher_list')
        self.validate_required(self.amount_long, 'amount_long')
        if self.amount_long is not None:
            self.validate_maximum(self.amount_long, 'amount_long', 10)
            self.validate_minimum(self.amount_long, 'amount_long', 0)
        self.validate_required(self.amount_int, 'amount_int')
        if self.amount_int is not None:
            self.validate_maximum(self.amount_int, 'amount_int', 10)
            self.validate_minimum(self.amount_int, 'amount_int', 0)
        self.validate_required(self.voucher_test_two, 'voucher_test_two')
        if self.voucher_test_two:
            self.voucher_test_two.validate()
        self.validate_required(self.boolean_list, 'boolean_list')
        self.validate_required(self.date_list, 'date_list')
        self.validate_required(self.asset_type, 'asset_type')
        if self.asset_type is not None:
            self.validate_max_length(self.asset_type, 'asset_type', 10)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.exist is not None:
            result['exist'] = self.exist
        if self.voucher_test_one is not None:
            result['voucher_test_one'] = self.voucher_test_one.to_map()
        if self.business_code is not None:
            result['business_code'] = self.business_code
        result['voucher_test_three'] = []
        if self.voucher_test_three is not None:
            for k in self.voucher_test_three:
                result['voucher_test_three'].append(k.to_map() if k else None)
        if self.issue_time is not None:
            result['issue_time'] = self.issue_time
        if self.voucher_list is not None:
            result['voucher_list'] = self.voucher_list
        if self.amount_long is not None:
            result['amount_long'] = self.amount_long
        if self.amount_int is not None:
            result['amount_int'] = self.amount_int
        if self.voucher_test_two is not None:
            result['voucher_test_two'] = self.voucher_test_two.to_map()
        if self.boolean_list is not None:
            result['boolean_list'] = self.boolean_list
        if self.date_list is not None:
            result['date_list'] = self.date_list
        if self.asset_type is not None:
            result['asset_type'] = self.asset_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('exist') is not None:
            self.exist = m.get('exist')
        if m.get('voucher_test_one') is not None:
            temp_model = VoucherTestTwo()
            self.voucher_test_one = temp_model.from_map(m['voucher_test_one'])
        if m.get('business_code') is not None:
            self.business_code = m.get('business_code')
        self.voucher_test_three = []
        if m.get('voucher_test_three') is not None:
            for k in m.get('voucher_test_three'):
                temp_model = VoucherTestTwo()
                self.voucher_test_three.append(temp_model.from_map(k))
        if m.get('issue_time') is not None:
            self.issue_time = m.get('issue_time')
        if m.get('voucher_list') is not None:
            self.voucher_list = m.get('voucher_list')
        if m.get('amount_long') is not None:
            self.amount_long = m.get('amount_long')
        if m.get('amount_int') is not None:
            self.amount_int = m.get('amount_int')
        if m.get('voucher_test_two') is not None:
            temp_model = VoucherTestTwo()
            self.voucher_test_two = temp_model.from_map(m['voucher_test_two'])
        if m.get('boolean_list') is not None:
            self.boolean_list = m.get('boolean_list')
        if m.get('date_list') is not None:
            self.date_list = m.get('date_list')
        if m.get('asset_type') is not None:
            self.asset_type = m.get('asset_type')
        return self


class CreateStandardVoucherResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        voucher_resp: VoucherResp = None,
        code: str = None,
        voucher_resp_list: List[VoucherResp] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 凭证返回值_voucherResp
        self.voucher_resp = voucher_resp
        # 编码
        self.code = code
        # 凭证返回值_voucherRespList
        self.voucher_resp_list = voucher_resp_list

    def validate(self):
        self.validate_required(self.voucher_resp, 'voucher_resp')
        if self.voucher_resp:
            self.voucher_resp.validate()
        self.validate_required(self.code, 'code')
        self.validate_required(self.voucher_resp_list, 'voucher_resp_list')
        if self.voucher_resp_list:
            for k in self.voucher_resp_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.voucher_resp is not None:
            result['voucher_resp'] = self.voucher_resp.to_map()
        if self.code is not None:
            result['code'] = self.code
        result['voucher_resp_list'] = []
        if self.voucher_resp_list is not None:
            for k in self.voucher_resp_list:
                result['voucher_resp_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('voucher_resp') is not None:
            temp_model = VoucherResp()
            self.voucher_resp = temp_model.from_map(m['voucher_resp'])
        if m.get('code') is not None:
            self.code = m.get('code')
        self.voucher_resp_list = []
        if m.get('voucher_resp_list') is not None:
            for k in m.get('voucher_resp_list'):
                temp_model = VoucherResp()
                self.voucher_resp_list.append(temp_model.from_map(k))
        return self


class CreatePlatformDidRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        ep_cert_name: str = None,
        ep_cert_no: str = None,
        legal_person_cert_name: str = None,
        legal_person_cert_no: str = None,
        extension_info: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 企业名称
        self.ep_cert_name = ep_cert_name
        # 企业信用号码
        self.ep_cert_no = ep_cert_no
        # 企业法人姓名
        self.legal_person_cert_name = legal_person_cert_name
        # 企业法人身份证号码
        self.legal_person_cert_no = legal_person_cert_no
        # 扩展字段
        self.extension_info = extension_info

    def validate(self):
        self.validate_required(self.ep_cert_name, 'ep_cert_name')
        self.validate_required(self.ep_cert_no, 'ep_cert_no')
        self.validate_required(self.legal_person_cert_name, 'legal_person_cert_name')
        self.validate_required(self.legal_person_cert_no, 'legal_person_cert_no')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.ep_cert_name is not None:
            result['ep_cert_name'] = self.ep_cert_name
        if self.ep_cert_no is not None:
            result['ep_cert_no'] = self.ep_cert_no
        if self.legal_person_cert_name is not None:
            result['legal_person_cert_name'] = self.legal_person_cert_name
        if self.legal_person_cert_no is not None:
            result['legal_person_cert_no'] = self.legal_person_cert_no
        if self.extension_info is not None:
            result['extension_info'] = self.extension_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('ep_cert_name') is not None:
            self.ep_cert_name = m.get('ep_cert_name')
        if m.get('ep_cert_no') is not None:
            self.ep_cert_no = m.get('ep_cert_no')
        if m.get('legal_person_cert_name') is not None:
            self.legal_person_cert_name = m.get('legal_person_cert_name')
        if m.get('legal_person_cert_no') is not None:
            self.legal_person_cert_no = m.get('legal_person_cert_no')
        if m.get('extension_info') is not None:
            self.extension_info = m.get('extension_info')
        return self


class CreatePlatformDidResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        did: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 无车承运平台DIS
        self.did = did

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.did is not None:
            result['did'] = self.did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('did') is not None:
            self.did = m.get('did')
        return self


class CreateAgentDidRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        agent_did: str = None,
        ep_cert_name: str = None,
        ep_cert_no: str = None,
        extension_info: str = None,
        legal_person_cert_name: str = None,
        legal_person_cert_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 创建did的代理did
        self.agent_did = agent_did
        # 企业名称
        self.ep_cert_name = ep_cert_name
        # 企业信用号码
        self.ep_cert_no = ep_cert_no
        # 扩展字段
        self.extension_info = extension_info
        # 企业法人姓名
        self.legal_person_cert_name = legal_person_cert_name
        # 企业法人身份证号码
        self.legal_person_cert_no = legal_person_cert_no

    def validate(self):
        self.validate_required(self.agent_did, 'agent_did')
        self.validate_required(self.ep_cert_name, 'ep_cert_name')
        self.validate_required(self.ep_cert_no, 'ep_cert_no')
        self.validate_required(self.legal_person_cert_name, 'legal_person_cert_name')
        self.validate_required(self.legal_person_cert_no, 'legal_person_cert_no')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.agent_did is not None:
            result['agent_did'] = self.agent_did
        if self.ep_cert_name is not None:
            result['ep_cert_name'] = self.ep_cert_name
        if self.ep_cert_no is not None:
            result['ep_cert_no'] = self.ep_cert_no
        if self.extension_info is not None:
            result['extension_info'] = self.extension_info
        if self.legal_person_cert_name is not None:
            result['legal_person_cert_name'] = self.legal_person_cert_name
        if self.legal_person_cert_no is not None:
            result['legal_person_cert_no'] = self.legal_person_cert_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('agent_did') is not None:
            self.agent_did = m.get('agent_did')
        if m.get('ep_cert_name') is not None:
            self.ep_cert_name = m.get('ep_cert_name')
        if m.get('ep_cert_no') is not None:
            self.ep_cert_no = m.get('ep_cert_no')
        if m.get('extension_info') is not None:
            self.extension_info = m.get('extension_info')
        if m.get('legal_person_cert_name') is not None:
            self.legal_person_cert_name = m.get('legal_person_cert_name')
        if m.get('legal_person_cert_no') is not None:
            self.legal_person_cert_no = m.get('legal_person_cert_no')
        return self


class CreateAgentDidResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        did: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 无车承运平台did
        self.did = did

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.did is not None:
            result['did'] = self.did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('did') is not None:
            self.did = m.get('did')
        return self


class CreateConsignorDisRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        ep_cert_name: str = None,
        ep_cert_no: str = None,
        extension_info: str = None,
        legal_person_cert_name: str = None,
        legal_person_cert_no: str = None,
        platform_did: str = None,
        check_all: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 企业名称
        self.ep_cert_name = ep_cert_name
        # 企业信用号码
        self.ep_cert_no = ep_cert_no
        # 扩展字段
        self.extension_info = extension_info
        # 企业法人姓名
        self.legal_person_cert_name = legal_person_cert_name
        # 企业法人身份证号码
        self.legal_person_cert_no = legal_person_cert_no
        # 所属承运平台did
        self.platform_did = platform_did
        # 是否核验货主四要素，如果为true  法人姓名和法人身份证号为必填
        self.check_all = check_all

    def validate(self):
        self.validate_required(self.ep_cert_name, 'ep_cert_name')
        self.validate_required(self.ep_cert_no, 'ep_cert_no')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.check_all, 'check_all')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.ep_cert_name is not None:
            result['ep_cert_name'] = self.ep_cert_name
        if self.ep_cert_no is not None:
            result['ep_cert_no'] = self.ep_cert_no
        if self.extension_info is not None:
            result['extension_info'] = self.extension_info
        if self.legal_person_cert_name is not None:
            result['legal_person_cert_name'] = self.legal_person_cert_name
        if self.legal_person_cert_no is not None:
            result['legal_person_cert_no'] = self.legal_person_cert_no
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.check_all is not None:
            result['check_all'] = self.check_all
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('ep_cert_name') is not None:
            self.ep_cert_name = m.get('ep_cert_name')
        if m.get('ep_cert_no') is not None:
            self.ep_cert_no = m.get('ep_cert_no')
        if m.get('extension_info') is not None:
            self.extension_info = m.get('extension_info')
        if m.get('legal_person_cert_name') is not None:
            self.legal_person_cert_name = m.get('legal_person_cert_name')
        if m.get('legal_person_cert_no') is not None:
            self.legal_person_cert_no = m.get('legal_person_cert_no')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('check_all') is not None:
            self.check_all = m.get('check_all')
        return self


class CreateConsignorDisResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        did: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 货主did信息
        self.did = did

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.did is not None:
            result['did'] = self.did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('did') is not None:
            self.did = m.get('did')
        return self


class CreateDriverDisRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cert_no: str = None,
        extension_info: str = None,
        mobile: str = None,
        name: str = None,
        platform_did: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 司机身份证号码
        self.cert_no = cert_no
        # 扩展字段
        self.extension_info = extension_info
        # 司机手机号码
        self.mobile = mobile
        # 司机姓名
        self.name = name
        # 所属承运平台did
        self.platform_did = platform_did

    def validate(self):
        self.validate_required(self.cert_no, 'cert_no')
        self.validate_required(self.mobile, 'mobile')
        self.validate_required(self.name, 'name')
        self.validate_required(self.platform_did, 'platform_did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.extension_info is not None:
            result['extension_info'] = self.extension_info
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('extension_info') is not None:
            self.extension_info = m.get('extension_info')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        return self


class CreateDriverDisResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        did: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 司机did
        self.did = did

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.did is not None:
            result['did'] = self.did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('did') is not None:
            self.did = m.get('did')
        return self


class CreateCargoOrderRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        all_freight: str = None,
        cargo_business_code: str = None,
        cargo_code: str = None,
        cargo_insurance_money: str = None,
        cargo_name: str = None,
        cargo_order: str = None,
        cargo_type: str = None,
        cargo_unit: str = None,
        cargo_volume: str = None,
        consignor_did: str = None,
        delivery_place: str = None,
        loading_place: str = None,
        platform_did: str = None,
        start_time: int = None,
        user_phone: str = None,
        weight: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 运费
        self.all_freight = all_freight
        # 货物行业编码
        self.cargo_business_code = cargo_business_code
        # 货物商品编码
        self.cargo_code = cargo_code
        # 货运险金额
        self.cargo_insurance_money = cargo_insurance_money
        # 货物名称
        self.cargo_name = cargo_name
        # 货源单号
        self.cargo_order = cargo_order
        # 货物类型
        self.cargo_type = cargo_type
        # 货物单位
        self.cargo_unit = cargo_unit
        # 货物体积，单位（方）
        self.cargo_volume = cargo_volume
        # 货主did
        self.consignor_did = consignor_did
        # 卸货地，XX省-XX市-XX区
        self.delivery_place = delivery_place
        # 装货地，XX省-XX市-XX区
        self.loading_place = loading_place
        # 所属承运平台did
        self.platform_did = platform_did
        # 货源单创建时间
        self.start_time = start_time
        # 联系人电话
        self.user_phone = user_phone
        # 货物重量，单位（吨）
        self.weight = weight

    def validate(self):
        self.validate_required(self.all_freight, 'all_freight')
        self.validate_required(self.cargo_name, 'cargo_name')
        self.validate_required(self.cargo_order, 'cargo_order')
        self.validate_required(self.cargo_type, 'cargo_type')
        self.validate_required(self.consignor_did, 'consignor_did')
        self.validate_required(self.delivery_place, 'delivery_place')
        self.validate_required(self.loading_place, 'loading_place')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.weight, 'weight')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.all_freight is not None:
            result['all_freight'] = self.all_freight
        if self.cargo_business_code is not None:
            result['cargo_business_code'] = self.cargo_business_code
        if self.cargo_code is not None:
            result['cargo_code'] = self.cargo_code
        if self.cargo_insurance_money is not None:
            result['cargo_insurance_money'] = self.cargo_insurance_money
        if self.cargo_name is not None:
            result['cargo_name'] = self.cargo_name
        if self.cargo_order is not None:
            result['cargo_order'] = self.cargo_order
        if self.cargo_type is not None:
            result['cargo_type'] = self.cargo_type
        if self.cargo_unit is not None:
            result['cargo_unit'] = self.cargo_unit
        if self.cargo_volume is not None:
            result['cargo_volume'] = self.cargo_volume
        if self.consignor_did is not None:
            result['consignor_did'] = self.consignor_did
        if self.delivery_place is not None:
            result['delivery_place'] = self.delivery_place
        if self.loading_place is not None:
            result['loading_place'] = self.loading_place
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.user_phone is not None:
            result['user_phone'] = self.user_phone
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('all_freight') is not None:
            self.all_freight = m.get('all_freight')
        if m.get('cargo_business_code') is not None:
            self.cargo_business_code = m.get('cargo_business_code')
        if m.get('cargo_code') is not None:
            self.cargo_code = m.get('cargo_code')
        if m.get('cargo_insurance_money') is not None:
            self.cargo_insurance_money = m.get('cargo_insurance_money')
        if m.get('cargo_name') is not None:
            self.cargo_name = m.get('cargo_name')
        if m.get('cargo_order') is not None:
            self.cargo_order = m.get('cargo_order')
        if m.get('cargo_type') is not None:
            self.cargo_type = m.get('cargo_type')
        if m.get('cargo_unit') is not None:
            self.cargo_unit = m.get('cargo_unit')
        if m.get('cargo_volume') is not None:
            self.cargo_volume = m.get('cargo_volume')
        if m.get('consignor_did') is not None:
            self.consignor_did = m.get('consignor_did')
        if m.get('delivery_place') is not None:
            self.delivery_place = m.get('delivery_place')
        if m.get('loading_place') is not None:
            self.loading_place = m.get('loading_place')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('user_phone') is not None:
            self.user_phone = m.get('user_phone')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class CreateCargoOrderResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 货源链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class CreateCargoPayRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        bank_account_of_payee: str = None,
        bank_account_of_payer: str = None,
        bank_no: str = None,
        bank_of_payee: str = None,
        bank_of_payer: str = None,
        cargo_order: str = None,
        check_channel: str = None,
        currency: str = None,
        expense_type: str = None,
        payee: str = None,
        payer: str = None,
        payment: str = None,
        pay_check: bool = None,
        pay_did: str = None,
        pay_id: str = None,
        pay_note: str = None,
        pay_time: int = None,
        pay_type: str = None,
        recv_did: str = None,
        tax_waybill_ids: List[str] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 收款方银行账号
        self.bank_account_of_payee = bank_account_of_payee
        # 付款方银行账号,货主付款的开户银行账号
        self.bank_account_of_payer = bank_account_of_payer
        # 银行流水号
        self.bank_no = bank_no
        # 收款方开户行（平台收款）
        # 取值：
        # MYBank_CloudCapital_2,  ## 云资金2.0
        self.bank_of_payee = bank_of_payee
        # MYBank_CloudCapital_2,  ## 云资金2.0
        self.bank_of_payer = bank_of_payer
        # 货源单号
        self.cargo_order = cargo_order
        # 核验渠道，请按取值约束值填入。
        # 
        # YBank_CloudCapital_2,  ## 云资金2.0
        self.check_channel = check_channel
        # CNY、USD
        # 币种
        self.currency = currency
        # 费用类型 (运费、调度费、服务费)
        self.expense_type = expense_type
        # 收款方名称
        self.payee = payee
        # 付款方名称
        self.payer = payer
        # 费用金额
        self.payment = payment
        # 是否核验
        self.pay_check = pay_check
        # 付款方did
        self.pay_did = pay_did
        # 平台支付单号
        self.pay_id = pay_id
        # 支付备注
        self.pay_note = pay_note
        # 支付时间
        self.pay_time = pay_time
        # 支付类型
        self.pay_type = pay_type
        # 收款方did
        self.recv_did = recv_did
        # 支持关联单个运单和多个运单
        self.tax_waybill_ids = tax_waybill_ids

    def validate(self):
        self.validate_required(self.bank_no, 'bank_no')
        self.validate_required(self.cargo_order, 'cargo_order')
        self.validate_required(self.expense_type, 'expense_type')
        self.validate_required(self.payment, 'payment')
        self.validate_required(self.pay_did, 'pay_did')
        self.validate_required(self.pay_id, 'pay_id')
        self.validate_required(self.pay_time, 'pay_time')
        self.validate_required(self.recv_did, 'recv_did')
        self.validate_required(self.tax_waybill_ids, 'tax_waybill_ids')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.bank_account_of_payee is not None:
            result['bank_account_of_payee'] = self.bank_account_of_payee
        if self.bank_account_of_payer is not None:
            result['bank_account_of_payer'] = self.bank_account_of_payer
        if self.bank_no is not None:
            result['bank_no'] = self.bank_no
        if self.bank_of_payee is not None:
            result['bank_of_payee'] = self.bank_of_payee
        if self.bank_of_payer is not None:
            result['bank_of_payer'] = self.bank_of_payer
        if self.cargo_order is not None:
            result['cargo_order'] = self.cargo_order
        if self.check_channel is not None:
            result['check_channel'] = self.check_channel
        if self.currency is not None:
            result['currency'] = self.currency
        if self.expense_type is not None:
            result['expense_type'] = self.expense_type
        if self.payee is not None:
            result['payee'] = self.payee
        if self.payer is not None:
            result['payer'] = self.payer
        if self.payment is not None:
            result['payment'] = self.payment
        if self.pay_check is not None:
            result['pay_check'] = self.pay_check
        if self.pay_did is not None:
            result['pay_did'] = self.pay_did
        if self.pay_id is not None:
            result['pay_id'] = self.pay_id
        if self.pay_note is not None:
            result['pay_note'] = self.pay_note
        if self.pay_time is not None:
            result['pay_time'] = self.pay_time
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.recv_did is not None:
            result['recv_did'] = self.recv_did
        if self.tax_waybill_ids is not None:
            result['tax_waybill_ids'] = self.tax_waybill_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('bank_account_of_payee') is not None:
            self.bank_account_of_payee = m.get('bank_account_of_payee')
        if m.get('bank_account_of_payer') is not None:
            self.bank_account_of_payer = m.get('bank_account_of_payer')
        if m.get('bank_no') is not None:
            self.bank_no = m.get('bank_no')
        if m.get('bank_of_payee') is not None:
            self.bank_of_payee = m.get('bank_of_payee')
        if m.get('bank_of_payer') is not None:
            self.bank_of_payer = m.get('bank_of_payer')
        if m.get('cargo_order') is not None:
            self.cargo_order = m.get('cargo_order')
        if m.get('check_channel') is not None:
            self.check_channel = m.get('check_channel')
        if m.get('currency') is not None:
            self.currency = m.get('currency')
        if m.get('expense_type') is not None:
            self.expense_type = m.get('expense_type')
        if m.get('payee') is not None:
            self.payee = m.get('payee')
        if m.get('payer') is not None:
            self.payer = m.get('payer')
        if m.get('payment') is not None:
            self.payment = m.get('payment')
        if m.get('pay_check') is not None:
            self.pay_check = m.get('pay_check')
        if m.get('pay_did') is not None:
            self.pay_did = m.get('pay_did')
        if m.get('pay_id') is not None:
            self.pay_id = m.get('pay_id')
        if m.get('pay_note') is not None:
            self.pay_note = m.get('pay_note')
        if m.get('pay_time') is not None:
            self.pay_time = m.get('pay_time')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('recv_did') is not None:
            self.recv_did = m.get('recv_did')
        if m.get('tax_waybill_ids') is not None:
            self.tax_waybill_ids = m.get('tax_waybill_ids')
        return self


class CreateCargoPayResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 货源支付链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class CreateWaybillOrderRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        all_freight: str = None,
        back_fee: str = None,
        business_type: str = None,
        cargo_business_code: str = None,
        cargo_code: str = None,
        cargo_insurance_money: str = None,
        cargo_order: str = None,
        cargo_orders: List[str] = None,
        cargo_unit: str = None,
        cargo_volume: str = None,
        cargo_weight: str = None,
        cart_badge_color: str = None,
        cart_badge_no: str = None,
        car_captain_did: str = None,
        consignor_freight_amount: str = None,
        created_time: int = None,
        dest_doors_end_time: int = None,
        doors_city_code: str = None,
        doors_city_name: str = None,
        doors_county_code: str = None,
        doors_county_name: str = None,
        doors_division_code: str = None,
        doors_province_code: str = None,
        doors_province_name: str = None,
        drawee: str = None,
        drawee_tax_no: str = None,
        driver_did: str = None,
        driver_name: str = None,
        end_address: str = None,
        end_city_code: str = None,
        end_city_name: str = None,
        end_county_code: str = None,
        end_county_name: str = None,
        end_division_code: str = None,
        end_province_code: str = None,
        end_province_name: str = None,
        end_street_code: str = None,
        end_street_name: str = None,
        freight_incr: str = None,
        goods_amount: int = None,
        goods_amount_type: str = None,
        goods_name: str = None,
        id_card: str = None,
        loss_fee: str = None,
        mobile_no: str = None,
        partner_id: str = None,
        platform_did: str = None,
        prepayments: str = None,
        prepayments_buy_etc: str = None,
        prepayments_buy_gas: str = None,
        tax_waybill_id: str = None,
        prepayments_buy_oil: str = None,
        prepayments_etccard: str = None,
        prepayments_oilcard: str = None,
        present_amount_oil: str = None,
        start_address: str = None,
        start_city_code: str = None,
        start_city_name: str = None,
        start_county_code: str = None,
        start_county_name: str = None,
        start_division_code: str = None,
        start_province_code: str = None,
        start_province_name: str = None,
        start_street_code: str = None,
        start_street_name: str = None,
        start_time: int = None,
        truck_length: str = None,
        truck_type: str = None,
        unit_price: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 用户链上账户 与司机did 二选一填写
        self.account_id = account_id
        # 运费，单位（元），平台支付给司机的运费金额
        self.all_freight = all_freight
        # 回单押金
        self.back_fee = back_fee
        # 业务类型
        self.business_type = business_type
        # 货物行业编码
        self.cargo_business_code = cargo_business_code
        # 货物商品编码
        self.cargo_code = cargo_code
        # 货运险金额
        self.cargo_insurance_money = cargo_insurance_money
        # 货源单号，关联货主订单
        self.cargo_order = cargo_order
        # 货源单号数组
        self.cargo_orders = cargo_orders
        # 货物单位
        self.cargo_unit = cargo_unit
        # 货物体积，单位（方）
        self.cargo_volume = cargo_volume
        # 货物重量，单位（吨）
        self.cargo_weight = cargo_weight
        # 车牌颜色，黄色、蓝色、绿色
        self.cart_badge_color = cart_badge_color
        # 车牌号
        # 
        self.cart_badge_no = cart_badge_no
        # 承运商did
        self.car_captain_did = car_captain_did
        # 货主运费金额，单位（元），货主支付给平台的运费金额
        self.consignor_freight_amount = consignor_freight_amount
        # 建单时间，13位毫秒级时间戳
        # 
        self.created_time = created_time
        # 到达门点时间，13位毫秒级时间戳
        self.dest_doors_end_time = dest_doors_end_time
        # 门点城市CODE，6位区域行政编码
        self.doors_city_code = doors_city_code
        # 门点城市名称
        self.doors_city_name = doors_city_name
        # 门点区县CODE，6位区域行政编码
        self.doors_county_code = doors_county_code
        # 门点区县名称
        self.doors_county_name = doors_county_name
        # 门点行政区划代码
        self.doors_division_code = doors_division_code
        # 门点省份CODE，6位区域行政编码
        self.doors_province_code = doors_province_code
        # 门点省份名称
        self.doors_province_name = doors_province_name
        # 发货方名称
        # 
        self.drawee = drawee
        # 发货方纳税人识别号
        # 
        self.drawee_tax_no = drawee_tax_no
        # 司机分布式身份
        self.driver_did = driver_did
        # 司机姓名 已填司机分布式身份的情况下可不填
        # 
        self.driver_name = driver_name
        # 目的地详细地址
        self.end_address = end_address
        # 目的地城市CODE，6位区域行政编码
        # 
        self.end_city_code = end_city_code
        # 目的地城市名称
        # 
        self.end_city_name = end_city_name
        # 目的地区县CODE，6位区域行政编码
        self.end_county_code = end_county_code
        # 目的地区县名称
        # 
        self.end_county_name = end_county_name
        # 结束行政区划代码，12位区域行政编码，（长途运输须准确提供前6位，如不能提供后6位可补0；短途运输须准确提供12位）
        # 
        self.end_division_code = end_division_code
        # 目的地省份CODE，6位区域行政编码
        # 
        self.end_province_code = end_province_code
        # 目的地省份名称
        # 
        self.end_province_name = end_province_name
        # 目的地街道CODE，12区域行政编码
        self.end_street_code = end_street_code
        # 目的地街道名称
        self.end_street_name = end_street_name
        # 运费增项
        # 
        self.freight_incr = freight_incr
        # 货物数量
        # 
        self.goods_amount = goods_amount
        # 货物数量单位类型
        # 
        self.goods_amount_type = goods_amount_type
        # 货物名称
        # 
        self.goods_name = goods_name
        # 司机身份证号 已填司机分布式身份的情况下可不填
        self.id_card = id_card
        # 运费扣减
        # 
        self.loss_fee = loss_fee
        # 司机手机号 已填司机分布式身份的情况下可不填
        # 
        self.mobile_no = mobile_no
        # 系统识别id 网商识别号
        # 
        self.partner_id = partner_id
        # 无车承运平台分布式数字身份，缺省时为自己的分布式数字身份
        # 
        self.platform_did = platform_did
        # 预付款金额
        # 
        self.prepayments = prepayments
        # 线下预付ETC
        # 
        self.prepayments_buy_etc = prepayments_buy_etc
        # 线下气款金额
        # 
        self.prepayments_buy_gas = prepayments_buy_gas
        # 运单id
        # 
        self.tax_waybill_id = tax_waybill_id
        # 线下油款预付
        # 
        self.prepayments_buy_oil = prepayments_buy_oil
        # 预付ETC卡金额
        # 
        self.prepayments_etccard = prepayments_etccard
        # 预付油卡金额
        # 
        self.prepayments_oilcard = prepayments_oilcard
        # 油卡赠送金额
        # 
        self.present_amount_oil = present_amount_oil
        # 起始地详细地址
        self.start_address = start_address
        # 起始地城市CODE，6位区域行政编码
        self.start_city_code = start_city_code
        # 起始地城市名称
        # 
        self.start_city_name = start_city_name
        # 起始地区县CODE，6位区域行政编码
        self.start_county_code = start_county_code
        # 起始地区县名称
        # 
        self.start_county_name = start_county_name
        # 起始行政区划代码，12位区域行政编码（长途运输须准确提供前6位，如不能提供后6位可补0；短途运输须准确提供12位）
        # 
        self.start_division_code = start_division_code
        # 起始地省份CODE，6位区域行政编码
        self.start_province_code = start_province_code
        # 起始地省份名称
        # 
        self.start_province_name = start_province_name
        # 起始地街道CODE，12区域行政编码
        self.start_street_code = start_street_code
        # 起始地街道名称
        self.start_street_name = start_street_name
        # 起运时间戳，13位毫秒级时间戳
        self.start_time = start_time
        # 车长，可以填：不限车长或者1.8，2.7，3.8，4.2，5，6.2，6.8，7.7，8.2，8.7，9.6，11.7，12.5，13，13.7，15，16，17.5等不超过2位小数的数字
        self.truck_length = truck_length
        # 可以填：不限车型，平板，高栏，厢式，集装箱，自卸，冷藏，保温，高低板，面包车，棉被车，爬梯车，飞翼车
        self.truck_type = truck_type
        # 运输单价
        # 
        self.unit_price = unit_price

    def validate(self):
        self.validate_required(self.cart_badge_color, 'cart_badge_color')
        self.validate_required(self.cart_badge_no, 'cart_badge_no')
        self.validate_required(self.created_time, 'created_time')
        self.validate_required(self.drawee, 'drawee')
        self.validate_required(self.drawee_tax_no, 'drawee_tax_no')
        self.validate_required(self.driver_did, 'driver_did')
        self.validate_required(self.end_city_code, 'end_city_code')
        self.validate_required(self.end_city_name, 'end_city_name')
        self.validate_required(self.end_division_code, 'end_division_code')
        self.validate_required(self.end_province_code, 'end_province_code')
        self.validate_required(self.end_province_name, 'end_province_name')
        self.validate_required(self.goods_name, 'goods_name')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')
        self.validate_required(self.start_city_code, 'start_city_code')
        self.validate_required(self.start_city_name, 'start_city_name')
        self.validate_required(self.start_division_code, 'start_division_code')
        self.validate_required(self.start_province_code, 'start_province_code')
        self.validate_required(self.start_province_name, 'start_province_name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.all_freight is not None:
            result['all_freight'] = self.all_freight
        if self.back_fee is not None:
            result['back_fee'] = self.back_fee
        if self.business_type is not None:
            result['business_type'] = self.business_type
        if self.cargo_business_code is not None:
            result['cargo_business_code'] = self.cargo_business_code
        if self.cargo_code is not None:
            result['cargo_code'] = self.cargo_code
        if self.cargo_insurance_money is not None:
            result['cargo_insurance_money'] = self.cargo_insurance_money
        if self.cargo_order is not None:
            result['cargo_order'] = self.cargo_order
        if self.cargo_orders is not None:
            result['cargo_orders'] = self.cargo_orders
        if self.cargo_unit is not None:
            result['cargo_unit'] = self.cargo_unit
        if self.cargo_volume is not None:
            result['cargo_volume'] = self.cargo_volume
        if self.cargo_weight is not None:
            result['cargo_weight'] = self.cargo_weight
        if self.cart_badge_color is not None:
            result['cart_badge_color'] = self.cart_badge_color
        if self.cart_badge_no is not None:
            result['cart_badge_no'] = self.cart_badge_no
        if self.car_captain_did is not None:
            result['car_captain_did'] = self.car_captain_did
        if self.consignor_freight_amount is not None:
            result['consignor_freight_amount'] = self.consignor_freight_amount
        if self.created_time is not None:
            result['created_time'] = self.created_time
        if self.dest_doors_end_time is not None:
            result['dest_doors_end_time'] = self.dest_doors_end_time
        if self.doors_city_code is not None:
            result['doors_city_code'] = self.doors_city_code
        if self.doors_city_name is not None:
            result['doors_city_name'] = self.doors_city_name
        if self.doors_county_code is not None:
            result['doors_county_code'] = self.doors_county_code
        if self.doors_county_name is not None:
            result['doors_county_name'] = self.doors_county_name
        if self.doors_division_code is not None:
            result['doors_division_code'] = self.doors_division_code
        if self.doors_province_code is not None:
            result['doors_province_code'] = self.doors_province_code
        if self.doors_province_name is not None:
            result['doors_province_name'] = self.doors_province_name
        if self.drawee is not None:
            result['drawee'] = self.drawee
        if self.drawee_tax_no is not None:
            result['drawee_tax_no'] = self.drawee_tax_no
        if self.driver_did is not None:
            result['driver_did'] = self.driver_did
        if self.driver_name is not None:
            result['driver_name'] = self.driver_name
        if self.end_address is not None:
            result['end_address'] = self.end_address
        if self.end_city_code is not None:
            result['end_city_code'] = self.end_city_code
        if self.end_city_name is not None:
            result['end_city_name'] = self.end_city_name
        if self.end_county_code is not None:
            result['end_county_code'] = self.end_county_code
        if self.end_county_name is not None:
            result['end_county_name'] = self.end_county_name
        if self.end_division_code is not None:
            result['end_division_code'] = self.end_division_code
        if self.end_province_code is not None:
            result['end_province_code'] = self.end_province_code
        if self.end_province_name is not None:
            result['end_province_name'] = self.end_province_name
        if self.end_street_code is not None:
            result['end_street_code'] = self.end_street_code
        if self.end_street_name is not None:
            result['end_street_name'] = self.end_street_name
        if self.freight_incr is not None:
            result['freight_incr'] = self.freight_incr
        if self.goods_amount is not None:
            result['goods_amount'] = self.goods_amount
        if self.goods_amount_type is not None:
            result['goods_amount_type'] = self.goods_amount_type
        if self.goods_name is not None:
            result['goods_name'] = self.goods_name
        if self.id_card is not None:
            result['id_card'] = self.id_card
        if self.loss_fee is not None:
            result['loss_fee'] = self.loss_fee
        if self.mobile_no is not None:
            result['mobile_no'] = self.mobile_no
        if self.partner_id is not None:
            result['partner_id'] = self.partner_id
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.prepayments is not None:
            result['prepayments'] = self.prepayments
        if self.prepayments_buy_etc is not None:
            result['prepayments_buy_etc'] = self.prepayments_buy_etc
        if self.prepayments_buy_gas is not None:
            result['prepayments_buy_gas'] = self.prepayments_buy_gas
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        if self.prepayments_buy_oil is not None:
            result['prepayments_buy_oil'] = self.prepayments_buy_oil
        if self.prepayments_etccard is not None:
            result['prepayments_etccard'] = self.prepayments_etccard
        if self.prepayments_oilcard is not None:
            result['prepayments_oilcard'] = self.prepayments_oilcard
        if self.present_amount_oil is not None:
            result['present_amount_oil'] = self.present_amount_oil
        if self.start_address is not None:
            result['start_address'] = self.start_address
        if self.start_city_code is not None:
            result['start_city_code'] = self.start_city_code
        if self.start_city_name is not None:
            result['start_city_name'] = self.start_city_name
        if self.start_county_code is not None:
            result['start_county_code'] = self.start_county_code
        if self.start_county_name is not None:
            result['start_county_name'] = self.start_county_name
        if self.start_division_code is not None:
            result['start_division_code'] = self.start_division_code
        if self.start_province_code is not None:
            result['start_province_code'] = self.start_province_code
        if self.start_province_name is not None:
            result['start_province_name'] = self.start_province_name
        if self.start_street_code is not None:
            result['start_street_code'] = self.start_street_code
        if self.start_street_name is not None:
            result['start_street_name'] = self.start_street_name
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.truck_length is not None:
            result['truck_length'] = self.truck_length
        if self.truck_type is not None:
            result['truck_type'] = self.truck_type
        if self.unit_price is not None:
            result['unit_price'] = self.unit_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('all_freight') is not None:
            self.all_freight = m.get('all_freight')
        if m.get('back_fee') is not None:
            self.back_fee = m.get('back_fee')
        if m.get('business_type') is not None:
            self.business_type = m.get('business_type')
        if m.get('cargo_business_code') is not None:
            self.cargo_business_code = m.get('cargo_business_code')
        if m.get('cargo_code') is not None:
            self.cargo_code = m.get('cargo_code')
        if m.get('cargo_insurance_money') is not None:
            self.cargo_insurance_money = m.get('cargo_insurance_money')
        if m.get('cargo_order') is not None:
            self.cargo_order = m.get('cargo_order')
        if m.get('cargo_orders') is not None:
            self.cargo_orders = m.get('cargo_orders')
        if m.get('cargo_unit') is not None:
            self.cargo_unit = m.get('cargo_unit')
        if m.get('cargo_volume') is not None:
            self.cargo_volume = m.get('cargo_volume')
        if m.get('cargo_weight') is not None:
            self.cargo_weight = m.get('cargo_weight')
        if m.get('cart_badge_color') is not None:
            self.cart_badge_color = m.get('cart_badge_color')
        if m.get('cart_badge_no') is not None:
            self.cart_badge_no = m.get('cart_badge_no')
        if m.get('car_captain_did') is not None:
            self.car_captain_did = m.get('car_captain_did')
        if m.get('consignor_freight_amount') is not None:
            self.consignor_freight_amount = m.get('consignor_freight_amount')
        if m.get('created_time') is not None:
            self.created_time = m.get('created_time')
        if m.get('dest_doors_end_time') is not None:
            self.dest_doors_end_time = m.get('dest_doors_end_time')
        if m.get('doors_city_code') is not None:
            self.doors_city_code = m.get('doors_city_code')
        if m.get('doors_city_name') is not None:
            self.doors_city_name = m.get('doors_city_name')
        if m.get('doors_county_code') is not None:
            self.doors_county_code = m.get('doors_county_code')
        if m.get('doors_county_name') is not None:
            self.doors_county_name = m.get('doors_county_name')
        if m.get('doors_division_code') is not None:
            self.doors_division_code = m.get('doors_division_code')
        if m.get('doors_province_code') is not None:
            self.doors_province_code = m.get('doors_province_code')
        if m.get('doors_province_name') is not None:
            self.doors_province_name = m.get('doors_province_name')
        if m.get('drawee') is not None:
            self.drawee = m.get('drawee')
        if m.get('drawee_tax_no') is not None:
            self.drawee_tax_no = m.get('drawee_tax_no')
        if m.get('driver_did') is not None:
            self.driver_did = m.get('driver_did')
        if m.get('driver_name') is not None:
            self.driver_name = m.get('driver_name')
        if m.get('end_address') is not None:
            self.end_address = m.get('end_address')
        if m.get('end_city_code') is not None:
            self.end_city_code = m.get('end_city_code')
        if m.get('end_city_name') is not None:
            self.end_city_name = m.get('end_city_name')
        if m.get('end_county_code') is not None:
            self.end_county_code = m.get('end_county_code')
        if m.get('end_county_name') is not None:
            self.end_county_name = m.get('end_county_name')
        if m.get('end_division_code') is not None:
            self.end_division_code = m.get('end_division_code')
        if m.get('end_province_code') is not None:
            self.end_province_code = m.get('end_province_code')
        if m.get('end_province_name') is not None:
            self.end_province_name = m.get('end_province_name')
        if m.get('end_street_code') is not None:
            self.end_street_code = m.get('end_street_code')
        if m.get('end_street_name') is not None:
            self.end_street_name = m.get('end_street_name')
        if m.get('freight_incr') is not None:
            self.freight_incr = m.get('freight_incr')
        if m.get('goods_amount') is not None:
            self.goods_amount = m.get('goods_amount')
        if m.get('goods_amount_type') is not None:
            self.goods_amount_type = m.get('goods_amount_type')
        if m.get('goods_name') is not None:
            self.goods_name = m.get('goods_name')
        if m.get('id_card') is not None:
            self.id_card = m.get('id_card')
        if m.get('loss_fee') is not None:
            self.loss_fee = m.get('loss_fee')
        if m.get('mobile_no') is not None:
            self.mobile_no = m.get('mobile_no')
        if m.get('partner_id') is not None:
            self.partner_id = m.get('partner_id')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('prepayments') is not None:
            self.prepayments = m.get('prepayments')
        if m.get('prepayments_buy_etc') is not None:
            self.prepayments_buy_etc = m.get('prepayments_buy_etc')
        if m.get('prepayments_buy_gas') is not None:
            self.prepayments_buy_gas = m.get('prepayments_buy_gas')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        if m.get('prepayments_buy_oil') is not None:
            self.prepayments_buy_oil = m.get('prepayments_buy_oil')
        if m.get('prepayments_etccard') is not None:
            self.prepayments_etccard = m.get('prepayments_etccard')
        if m.get('prepayments_oilcard') is not None:
            self.prepayments_oilcard = m.get('prepayments_oilcard')
        if m.get('present_amount_oil') is not None:
            self.present_amount_oil = m.get('present_amount_oil')
        if m.get('start_address') is not None:
            self.start_address = m.get('start_address')
        if m.get('start_city_code') is not None:
            self.start_city_code = m.get('start_city_code')
        if m.get('start_city_name') is not None:
            self.start_city_name = m.get('start_city_name')
        if m.get('start_county_code') is not None:
            self.start_county_code = m.get('start_county_code')
        if m.get('start_county_name') is not None:
            self.start_county_name = m.get('start_county_name')
        if m.get('start_division_code') is not None:
            self.start_division_code = m.get('start_division_code')
        if m.get('start_province_code') is not None:
            self.start_province_code = m.get('start_province_code')
        if m.get('start_province_name') is not None:
            self.start_province_name = m.get('start_province_name')
        if m.get('start_street_code') is not None:
            self.start_street_code = m.get('start_street_code')
        if m.get('start_street_name') is not None:
            self.start_street_name = m.get('start_street_name')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('truck_length') is not None:
            self.truck_length = m.get('truck_length')
        if m.get('truck_type') is not None:
            self.truck_type = m.get('truck_type')
        if m.get('unit_price') is not None:
            self.unit_price = m.get('unit_price')
        return self


class CreateWaybillOrderResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class CreateWaybillPayRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        arrive_time: int = None,
        bank_sn: str = None,
        pay_amount: str = None,
        pay_bank_card_no: str = None,
        pay_bank_name: str = None,
        pay_check: bool = None,
        pay_did: str = None,
        pay_name: str = None,
        pay_time: int = None,
        pay_type_new: str = None,
        pay_way: str = None,
        platform_did: str = None,
        pos_info_id: str = None,
        real_pay_bank: str = None,
        real_pay_bank_card_no: str = None,
        real_pay_name: str = None,
        recv_bank_card_no: str = None,
        recv_bank_name: str = None,
        recv_did: str = None,
        recv_name: str = None,
        waybill_id: str = None,
        check_channel: str = None,
        currency: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 确认到账时间
        # 
        self.arrive_time = arrive_time
        # 关联银行流水号
        # 
        self.bank_sn = bank_sn
        # 付款金额
        # 
        self.pay_amount = pay_amount
        # 付款方银行账号
        # 
        self.pay_bank_card_no = pay_bank_card_no
        # 付款方开户行
        # 
        self.pay_bank_name = pay_bank_name
        # 是否核验
        self.pay_check = pay_check
        # 付款方did
        # 
        self.pay_did = pay_did
        # 付款方名称
        # 
        self.pay_name = pay_name
        # 付款时间戳
        # 
        self.pay_time = pay_time
        # 支付类型
        # 
        self.pay_type_new = pay_type_new
        # 支付方式
        # 
        self.pay_way = pay_way
        # 无车承运平台分布式数字身份，缺省为自己的分布式数字身份
        # 
        self.platform_did = platform_did
        # 支付订单ID
        # 
        self.pos_info_id = pos_info_id
        # 实际付款方开户行
        # 
        self.real_pay_bank = real_pay_bank
        # 实际付款方银行账号
        # 
        self.real_pay_bank_card_no = real_pay_bank_card_no
        # 实际付款方名称
        # 
        self.real_pay_name = real_pay_name
        # 收款方银行账号
        # 
        self.recv_bank_card_no = recv_bank_card_no
        # 收款方开户行
        # 
        self.recv_bank_name = recv_bank_name
        # 收款方did
        # 
        self.recv_did = recv_did
        # 收款方名称
        # 
        self.recv_name = recv_name
        # 关联的运单ID
        # 
        self.waybill_id = waybill_id
        # MYBank_CloudCapital_1,  ## 云资金1.0
        # MYBank_CloudCapital_2,  ## 云资金2.0
        self.check_channel = check_channel
        # CNY, USD
        self.currency = currency

    def validate(self):
        self.validate_required(self.arrive_time, 'arrive_time')
        self.validate_required(self.bank_sn, 'bank_sn')
        self.validate_required(self.pay_amount, 'pay_amount')
        self.validate_required(self.pay_bank_card_no, 'pay_bank_card_no')
        self.validate_required(self.pay_bank_name, 'pay_bank_name')
        self.validate_required(self.pay_did, 'pay_did')
        self.validate_required(self.pay_name, 'pay_name')
        self.validate_required(self.pay_time, 'pay_time')
        self.validate_required(self.pay_type_new, 'pay_type_new')
        self.validate_required(self.pay_way, 'pay_way')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.pos_info_id, 'pos_info_id')
        self.validate_required(self.real_pay_bank, 'real_pay_bank')
        self.validate_required(self.real_pay_bank_card_no, 'real_pay_bank_card_no')
        self.validate_required(self.real_pay_name, 'real_pay_name')
        self.validate_required(self.recv_bank_card_no, 'recv_bank_card_no')
        self.validate_required(self.recv_bank_name, 'recv_bank_name')
        self.validate_required(self.recv_did, 'recv_did')
        self.validate_required(self.recv_name, 'recv_name')
        self.validate_required(self.waybill_id, 'waybill_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.arrive_time is not None:
            result['arrive_time'] = self.arrive_time
        if self.bank_sn is not None:
            result['bank_sn'] = self.bank_sn
        if self.pay_amount is not None:
            result['pay_amount'] = self.pay_amount
        if self.pay_bank_card_no is not None:
            result['pay_bank_card_no'] = self.pay_bank_card_no
        if self.pay_bank_name is not None:
            result['pay_bank_name'] = self.pay_bank_name
        if self.pay_check is not None:
            result['pay_check'] = self.pay_check
        if self.pay_did is not None:
            result['pay_did'] = self.pay_did
        if self.pay_name is not None:
            result['pay_name'] = self.pay_name
        if self.pay_time is not None:
            result['pay_time'] = self.pay_time
        if self.pay_type_new is not None:
            result['pay_type_new'] = self.pay_type_new
        if self.pay_way is not None:
            result['pay_way'] = self.pay_way
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.pos_info_id is not None:
            result['pos_info_id'] = self.pos_info_id
        if self.real_pay_bank is not None:
            result['real_pay_bank'] = self.real_pay_bank
        if self.real_pay_bank_card_no is not None:
            result['real_pay_bank_card_no'] = self.real_pay_bank_card_no
        if self.real_pay_name is not None:
            result['real_pay_name'] = self.real_pay_name
        if self.recv_bank_card_no is not None:
            result['recv_bank_card_no'] = self.recv_bank_card_no
        if self.recv_bank_name is not None:
            result['recv_bank_name'] = self.recv_bank_name
        if self.recv_did is not None:
            result['recv_did'] = self.recv_did
        if self.recv_name is not None:
            result['recv_name'] = self.recv_name
        if self.waybill_id is not None:
            result['waybill_id'] = self.waybill_id
        if self.check_channel is not None:
            result['check_channel'] = self.check_channel
        if self.currency is not None:
            result['currency'] = self.currency
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('arrive_time') is not None:
            self.arrive_time = m.get('arrive_time')
        if m.get('bank_sn') is not None:
            self.bank_sn = m.get('bank_sn')
        if m.get('pay_amount') is not None:
            self.pay_amount = m.get('pay_amount')
        if m.get('pay_bank_card_no') is not None:
            self.pay_bank_card_no = m.get('pay_bank_card_no')
        if m.get('pay_bank_name') is not None:
            self.pay_bank_name = m.get('pay_bank_name')
        if m.get('pay_check') is not None:
            self.pay_check = m.get('pay_check')
        if m.get('pay_did') is not None:
            self.pay_did = m.get('pay_did')
        if m.get('pay_name') is not None:
            self.pay_name = m.get('pay_name')
        if m.get('pay_time') is not None:
            self.pay_time = m.get('pay_time')
        if m.get('pay_type_new') is not None:
            self.pay_type_new = m.get('pay_type_new')
        if m.get('pay_way') is not None:
            self.pay_way = m.get('pay_way')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('pos_info_id') is not None:
            self.pos_info_id = m.get('pos_info_id')
        if m.get('real_pay_bank') is not None:
            self.real_pay_bank = m.get('real_pay_bank')
        if m.get('real_pay_bank_card_no') is not None:
            self.real_pay_bank_card_no = m.get('real_pay_bank_card_no')
        if m.get('real_pay_name') is not None:
            self.real_pay_name = m.get('real_pay_name')
        if m.get('recv_bank_card_no') is not None:
            self.recv_bank_card_no = m.get('recv_bank_card_no')
        if m.get('recv_bank_name') is not None:
            self.recv_bank_name = m.get('recv_bank_name')
        if m.get('recv_did') is not None:
            self.recv_did = m.get('recv_did')
        if m.get('recv_name') is not None:
            self.recv_name = m.get('recv_name')
        if m.get('waybill_id') is not None:
            self.waybill_id = m.get('waybill_id')
        if m.get('check_channel') is not None:
            self.check_channel = m.get('check_channel')
        if m.get('currency') is not None:
            self.currency = m.get('currency')
        return self


class CreateWaybillPayResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        # 
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class ImportWaybillLocationRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        desc: str = None,
        location: List[LogisticLocation] = None,
        platform_did: str = None,
        tax_waybill_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 描述信息
        # 
        self.desc = desc
        # 运单轨迹信息
        self.location = location
        # 所属平台分布式数字身份，缺省时为自己的分布式数字身份
        # 
        self.platform_did = platform_did
        # 运单id
        # 
        self.tax_waybill_id = tax_waybill_id

    def validate(self):
        self.validate_required(self.location, 'location')
        if self.location:
            for k in self.location:
                if k:
                    k.validate()
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.desc is not None:
            result['desc'] = self.desc
        result['location'] = []
        if self.location is not None:
            for k in self.location:
                result['location'].append(k.to_map() if k else None)
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        self.location = []
        if m.get('location') is not None:
            for k in m.get('location'):
                temp_model = LogisticLocation()
                self.location.append(temp_model.from_map(k))
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        return self


class ImportWaybillLocationResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CreateWaybillBillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        drawee: str = None,
        drawee_tax_no: str = None,
        lzfpdm: str = None,
        lzfphm: str = None,
        open_time: int = None,
        platform_did: str = None,
        waybill_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 受票方名称
        # 
        self.drawee = drawee
        # 受票方纳税人识别号
        # 
        self.drawee_tax_no = drawee_tax_no
        # 发票代码
        # 
        self.lzfpdm = lzfpdm
        # 发票号码
        # 
        self.lzfphm = lzfphm
        # 开票时间戳
        # 
        self.open_time = open_time
        # 所属平台的分布式数字身份，缺省时为自己的分布式数字身份
        # 
        self.platform_did = platform_did
        # 关联的运单ID
        # 
        self.waybill_id = waybill_id

    def validate(self):
        self.validate_required(self.drawee, 'drawee')
        self.validate_required(self.drawee_tax_no, 'drawee_tax_no')
        self.validate_required(self.open_time, 'open_time')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.waybill_id, 'waybill_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.drawee is not None:
            result['drawee'] = self.drawee
        if self.drawee_tax_no is not None:
            result['drawee_tax_no'] = self.drawee_tax_no
        if self.lzfpdm is not None:
            result['lzfpdm'] = self.lzfpdm
        if self.lzfphm is not None:
            result['lzfphm'] = self.lzfphm
        if self.open_time is not None:
            result['open_time'] = self.open_time
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.waybill_id is not None:
            result['waybill_id'] = self.waybill_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('drawee') is not None:
            self.drawee = m.get('drawee')
        if m.get('drawee_tax_no') is not None:
            self.drawee_tax_no = m.get('drawee_tax_no')
        if m.get('lzfpdm') is not None:
            self.lzfpdm = m.get('lzfpdm')
        if m.get('lzfphm') is not None:
            self.lzfphm = m.get('lzfphm')
        if m.get('open_time') is not None:
            self.open_time = m.get('open_time')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('waybill_id') is not None:
            self.waybill_id = m.get('waybill_id')
        return self


class CreateWaybillBillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        # 
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class QueryWaybillStatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        platform_did: str = None,
        tax_waybill_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 无车承运平台分布式数字身份，缺省时为自己的分布式数字身份
        # 
        self.platform_did = platform_did
        # 运单ID
        # 
        self.tax_waybill_id = tax_waybill_id

    def validate(self):
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        return self


class QueryWaybillStatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        status: str = None,
        track_check_result: TrackCheckResult = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 运单状态
        # 
        self.status = status
        # 轨迹核验结果
        self.track_check_result = track_check_result

    def validate(self):
        if self.track_check_result:
            self.track_check_result.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.status is not None:
            result['status'] = self.status
        if self.track_check_result is not None:
            result['track_check_result'] = self.track_check_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('track_check_result') is not None:
            temp_model = TrackCheckResult()
            self.track_check_result = temp_model.from_map(m['track_check_result'])
        return self


class FinishWaybillOrderRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        all_freight: str = None,
        back_fee: str = None,
        business_type: str = None,
        cargo_business_code: str = None,
        cargo_code: str = None,
        cargo_insurance_money: str = None,
        cargo_order: str = None,
        cargo_unit: str = None,
        cargo_volume: str = None,
        cargo_weight: str = None,
        cart_badge_color: str = None,
        cart_badge_no: str = None,
        car_captain_did: str = None,
        consignor_freight_amount: str = None,
        created_time: int = None,
        dest_doors_end_time: int = None,
        doors_city_code: str = None,
        doors_city_name: str = None,
        doors_county_code: str = None,
        doors_county_name: str = None,
        doors_division_code: str = None,
        doors_province_code: str = None,
        doors_province_name: str = None,
        drawee: str = None,
        drawee_tax_no: str = None,
        driver_did: str = None,
        driver_name: str = None,
        end_address: str = None,
        end_city_code: str = None,
        end_city_name: str = None,
        end_county_code: str = None,
        end_county_name: str = None,
        end_division_code: str = None,
        end_province_code: str = None,
        end_province_name: str = None,
        end_street_code: str = None,
        end_street_name: str = None,
        end_time: int = None,
        freight_incr: str = None,
        goods_amount: int = None,
        goods_amount_type: str = None,
        goods_name: str = None,
        id_card: str = None,
        loss_fee: str = None,
        mobile_no: str = None,
        partner_id: str = None,
        pay_check: bool = None,
        platform_did: str = None,
        prepayments: str = None,
        prepayments_buy_etc: str = None,
        prepayments_buy_gas: str = None,
        prepayments_buy_oil: str = None,
        prepayments_etccard: str = None,
        prepayments_oilcard: str = None,
        present_amount_oil: str = None,
        start_address: str = None,
        start_city_code: str = None,
        start_city_name: str = None,
        start_county_code: str = None,
        start_county_name: str = None,
        start_division_code: str = None,
        start_province_code: str = None,
        start_province_name: str = None,
        start_street_code: str = None,
        start_street_name: str = None,
        start_time: int = None,
        tax_waybill_id: str = None,
        truck_length: str = None,
        truck_type: str = None,
        unit_price: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 链上账号 与司机did 二选一填写
        # 
        self.account_id = account_id
        # 运费，单位（元），平台支付给司机的运费
        self.all_freight = all_freight
        # 回单押金
        # 
        self.back_fee = back_fee
        # 业务类型
        self.business_type = business_type
        # 货物行业编码
        self.cargo_business_code = cargo_business_code
        # 货物商品编码
        self.cargo_code = cargo_code
        # 货物运费险
        self.cargo_insurance_money = cargo_insurance_money
        # 货源单号
        # 
        self.cargo_order = cargo_order
        # 货物单位
        self.cargo_unit = cargo_unit
        # 货物体积，单位（方）
        self.cargo_volume = cargo_volume
        # 货物重量，单位（吨）
        self.cargo_weight = cargo_weight
        # 车牌颜色，黄色、蓝色、绿色
        self.cart_badge_color = cart_badge_color
        # 车牌号
        # 
        self.cart_badge_no = cart_badge_no
        # 承运商did
        self.car_captain_did = car_captain_did
        # 货主运费金额，货主支付给平台的运费金额
        self.consignor_freight_amount = consignor_freight_amount
        # 建单时间，13位毫秒级时间戳
        self.created_time = created_time
        # 到达门点时间，13位毫秒级时间戳
        self.dest_doors_end_time = dest_doors_end_time
        # 门点城市CODE，6位区域行政编码
        self.doors_city_code = doors_city_code
        # 门点城市名称
        self.doors_city_name = doors_city_name
        # 门点区县CODE，6位区域行政编码
        self.doors_county_code = doors_county_code
        # 门点区县名称
        self.doors_county_name = doors_county_name
        # 门点行政区划代码，12位区域行政编码，（长途运输须准确提供前6位，如不能提供后6位可补0；短途运输须准确提供12位）
        self.doors_division_code = doors_division_code
        # 门点省份CODE，6位区域行政编
        self.doors_province_code = doors_province_code
        # 门点省份名称
        self.doors_province_name = doors_province_name
        # 发货方名称
        # 
        self.drawee = drawee
        # 发货方纳税人识别号
        # 
        self.drawee_tax_no = drawee_tax_no
        # 司机分布式数字身份
        # 
        self.driver_did = driver_did
        # 司机姓名 已填司机分布式身份的情况下可不填
        # 
        self.driver_name = driver_name
        # 目的地详细地址
        self.end_address = end_address
        # 目的地城市CODE，6位区域行政编
        self.end_city_code = end_city_code
        # 目的地城市名称
        # 
        self.end_city_name = end_city_name
        # 目的地区县CODE，6位区域行政编
        self.end_county_code = end_county_code
        # 目的地区县名称
        # 
        self.end_county_name = end_county_name
        # 结束行政区划代码 ，12位区域行政编，（长途运输须准确提供前6位，如不能提供后6位可补0；短途运输须准确提供12位）
        # 
        self.end_division_code = end_division_code
        # 目的地省份CODE，6位区域行政编
        # 
        self.end_province_code = end_province_code
        # 目的地省份名称
        # 
        self.end_province_name = end_province_name
        # 目的地街道CODE，12位行政区域编码
        self.end_street_code = end_street_code
        # 目的地街道名称
        self.end_street_name = end_street_name
        # 终结时间，13位毫秒级时间戳
        self.end_time = end_time
        # 运费增项
        # 
        self.freight_incr = freight_incr
        # 货物数量
        # 
        self.goods_amount = goods_amount
        # 货物数量单位类型
        # 
        self.goods_amount_type = goods_amount_type
        # 货物名称
        # 
        self.goods_name = goods_name
        # 司机身份证号 已填司机分布式身份的情况下可不填
        # 
        self.id_card = id_card
        # 运费扣减
        # 
        self.loss_fee = loss_fee
        # 司机手机号 已填司机分布式身份的情况下可不填
        # 
        self.mobile_no = mobile_no
        # 系统识别id 网商识别号
        # 
        self.partner_id = partner_id
        # 是否进行资金验证
        # 
        self.pay_check = pay_check
        # 无车承运平台分布式数字身份，缺省时为自己的分布式数字身份
        # 
        self.platform_did = platform_did
        # 预付款金额
        # 
        self.prepayments = prepayments
        # 线下预付ETC
        # 
        self.prepayments_buy_etc = prepayments_buy_etc
        # 线下气款金额
        # 
        self.prepayments_buy_gas = prepayments_buy_gas
        # 线下油款预付
        # 
        self.prepayments_buy_oil = prepayments_buy_oil
        # 预付ETC卡金额
        # 
        self.prepayments_etccard = prepayments_etccard
        # 预付油卡金额
        # 
        self.prepayments_oilcard = prepayments_oilcard
        # 油卡赠送金额
        # 
        self.present_amount_oil = present_amount_oil
        # 起始地详细地址
        self.start_address = start_address
        # 起始地CODE
        # ，6位区域行政编
        self.start_city_code = start_city_code
        # 起始地城市名称
        # 
        self.start_city_name = start_city_name
        # 起始地区县CODE
        # ，6位区域行政编
        self.start_county_code = start_county_code
        # 起始地区县名称
        # 
        self.start_county_name = start_county_name
        # 起始行政区划代码，12位区域行政编，（长途运输须准确提供前6位，如不能提供后6位可补0；短途运输须准确提供12位）
        # 
        self.start_division_code = start_division_code
        # 起始地省份CODE
        # ，6位区域行政编
        self.start_province_code = start_province_code
        # 起始地省份名称
        # 
        self.start_province_name = start_province_name
        # 起始地街道CODE，12位区域行政编
        self.start_street_code = start_street_code
        # 起始地街道名称
        self.start_street_name = start_street_name
        # 起运时间，13位毫秒级时间戳
        # 
        self.start_time = start_time
        # 运单ID
        # 
        self.tax_waybill_id = tax_waybill_id
        # 车长，可以填：不限车长或者1.8，2.7，3.8，4.2，5，6.2，6.8，7.7，8.2，8.7，9.6，11.7，12.5，13，13.7，15，16，17.5等不超过2位小数的数字
        self.truck_length = truck_length
        # 车型，可以填写：不限车型，平板，高栏，厢式，集装箱，自卸，冷藏，保温，高低板，面包车，棉被车，爬梯车，飞翼车
        self.truck_type = truck_type
        # 运输单价
        # 
        self.unit_price = unit_price

    def validate(self):
        self.validate_required(self.all_freight, 'all_freight')
        self.validate_required(self.cart_badge_color, 'cart_badge_color')
        self.validate_required(self.cart_badge_no, 'cart_badge_no')
        self.validate_required(self.consignor_freight_amount, 'consignor_freight_amount')
        self.validate_required(self.created_time, 'created_time')
        self.validate_required(self.drawee, 'drawee')
        self.validate_required(self.drawee_tax_no, 'drawee_tax_no')
        self.validate_required(self.driver_did, 'driver_did')
        self.validate_required(self.end_city_code, 'end_city_code')
        self.validate_required(self.end_city_name, 'end_city_name')
        self.validate_required(self.end_division_code, 'end_division_code')
        self.validate_required(self.end_province_code, 'end_province_code')
        self.validate_required(self.end_province_name, 'end_province_name')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.goods_name, 'goods_name')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.start_city_code, 'start_city_code')
        self.validate_required(self.start_city_name, 'start_city_name')
        self.validate_required(self.start_division_code, 'start_division_code')
        self.validate_required(self.start_province_code, 'start_province_code')
        self.validate_required(self.start_province_name, 'start_province_name')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.all_freight is not None:
            result['all_freight'] = self.all_freight
        if self.back_fee is not None:
            result['back_fee'] = self.back_fee
        if self.business_type is not None:
            result['business_type'] = self.business_type
        if self.cargo_business_code is not None:
            result['cargo_business_code'] = self.cargo_business_code
        if self.cargo_code is not None:
            result['cargo_code'] = self.cargo_code
        if self.cargo_insurance_money is not None:
            result['cargo_insurance_money'] = self.cargo_insurance_money
        if self.cargo_order is not None:
            result['cargo_order'] = self.cargo_order
        if self.cargo_unit is not None:
            result['cargo_unit'] = self.cargo_unit
        if self.cargo_volume is not None:
            result['cargo_volume'] = self.cargo_volume
        if self.cargo_weight is not None:
            result['cargo_weight'] = self.cargo_weight
        if self.cart_badge_color is not None:
            result['cart_badge_color'] = self.cart_badge_color
        if self.cart_badge_no is not None:
            result['cart_badge_no'] = self.cart_badge_no
        if self.car_captain_did is not None:
            result['car_captain_did'] = self.car_captain_did
        if self.consignor_freight_amount is not None:
            result['consignor_freight_amount'] = self.consignor_freight_amount
        if self.created_time is not None:
            result['created_time'] = self.created_time
        if self.dest_doors_end_time is not None:
            result['dest_doors_end_time'] = self.dest_doors_end_time
        if self.doors_city_code is not None:
            result['doors_city_code'] = self.doors_city_code
        if self.doors_city_name is not None:
            result['doors_city_name'] = self.doors_city_name
        if self.doors_county_code is not None:
            result['doors_county_code'] = self.doors_county_code
        if self.doors_county_name is not None:
            result['doors_county_name'] = self.doors_county_name
        if self.doors_division_code is not None:
            result['doors_division_code'] = self.doors_division_code
        if self.doors_province_code is not None:
            result['doors_province_code'] = self.doors_province_code
        if self.doors_province_name is not None:
            result['doors_province_name'] = self.doors_province_name
        if self.drawee is not None:
            result['drawee'] = self.drawee
        if self.drawee_tax_no is not None:
            result['drawee_tax_no'] = self.drawee_tax_no
        if self.driver_did is not None:
            result['driver_did'] = self.driver_did
        if self.driver_name is not None:
            result['driver_name'] = self.driver_name
        if self.end_address is not None:
            result['end_address'] = self.end_address
        if self.end_city_code is not None:
            result['end_city_code'] = self.end_city_code
        if self.end_city_name is not None:
            result['end_city_name'] = self.end_city_name
        if self.end_county_code is not None:
            result['end_county_code'] = self.end_county_code
        if self.end_county_name is not None:
            result['end_county_name'] = self.end_county_name
        if self.end_division_code is not None:
            result['end_division_code'] = self.end_division_code
        if self.end_province_code is not None:
            result['end_province_code'] = self.end_province_code
        if self.end_province_name is not None:
            result['end_province_name'] = self.end_province_name
        if self.end_street_code is not None:
            result['end_street_code'] = self.end_street_code
        if self.end_street_name is not None:
            result['end_street_name'] = self.end_street_name
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.freight_incr is not None:
            result['freight_incr'] = self.freight_incr
        if self.goods_amount is not None:
            result['goods_amount'] = self.goods_amount
        if self.goods_amount_type is not None:
            result['goods_amount_type'] = self.goods_amount_type
        if self.goods_name is not None:
            result['goods_name'] = self.goods_name
        if self.id_card is not None:
            result['id_card'] = self.id_card
        if self.loss_fee is not None:
            result['loss_fee'] = self.loss_fee
        if self.mobile_no is not None:
            result['mobile_no'] = self.mobile_no
        if self.partner_id is not None:
            result['partner_id'] = self.partner_id
        if self.pay_check is not None:
            result['pay_check'] = self.pay_check
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.prepayments is not None:
            result['prepayments'] = self.prepayments
        if self.prepayments_buy_etc is not None:
            result['prepayments_buy_etc'] = self.prepayments_buy_etc
        if self.prepayments_buy_gas is not None:
            result['prepayments_buy_gas'] = self.prepayments_buy_gas
        if self.prepayments_buy_oil is not None:
            result['prepayments_buy_oil'] = self.prepayments_buy_oil
        if self.prepayments_etccard is not None:
            result['prepayments_etccard'] = self.prepayments_etccard
        if self.prepayments_oilcard is not None:
            result['prepayments_oilcard'] = self.prepayments_oilcard
        if self.present_amount_oil is not None:
            result['present_amount_oil'] = self.present_amount_oil
        if self.start_address is not None:
            result['start_address'] = self.start_address
        if self.start_city_code is not None:
            result['start_city_code'] = self.start_city_code
        if self.start_city_name is not None:
            result['start_city_name'] = self.start_city_name
        if self.start_county_code is not None:
            result['start_county_code'] = self.start_county_code
        if self.start_county_name is not None:
            result['start_county_name'] = self.start_county_name
        if self.start_division_code is not None:
            result['start_division_code'] = self.start_division_code
        if self.start_province_code is not None:
            result['start_province_code'] = self.start_province_code
        if self.start_province_name is not None:
            result['start_province_name'] = self.start_province_name
        if self.start_street_code is not None:
            result['start_street_code'] = self.start_street_code
        if self.start_street_name is not None:
            result['start_street_name'] = self.start_street_name
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        if self.truck_length is not None:
            result['truck_length'] = self.truck_length
        if self.truck_type is not None:
            result['truck_type'] = self.truck_type
        if self.unit_price is not None:
            result['unit_price'] = self.unit_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('all_freight') is not None:
            self.all_freight = m.get('all_freight')
        if m.get('back_fee') is not None:
            self.back_fee = m.get('back_fee')
        if m.get('business_type') is not None:
            self.business_type = m.get('business_type')
        if m.get('cargo_business_code') is not None:
            self.cargo_business_code = m.get('cargo_business_code')
        if m.get('cargo_code') is not None:
            self.cargo_code = m.get('cargo_code')
        if m.get('cargo_insurance_money') is not None:
            self.cargo_insurance_money = m.get('cargo_insurance_money')
        if m.get('cargo_order') is not None:
            self.cargo_order = m.get('cargo_order')
        if m.get('cargo_unit') is not None:
            self.cargo_unit = m.get('cargo_unit')
        if m.get('cargo_volume') is not None:
            self.cargo_volume = m.get('cargo_volume')
        if m.get('cargo_weight') is not None:
            self.cargo_weight = m.get('cargo_weight')
        if m.get('cart_badge_color') is not None:
            self.cart_badge_color = m.get('cart_badge_color')
        if m.get('cart_badge_no') is not None:
            self.cart_badge_no = m.get('cart_badge_no')
        if m.get('car_captain_did') is not None:
            self.car_captain_did = m.get('car_captain_did')
        if m.get('consignor_freight_amount') is not None:
            self.consignor_freight_amount = m.get('consignor_freight_amount')
        if m.get('created_time') is not None:
            self.created_time = m.get('created_time')
        if m.get('dest_doors_end_time') is not None:
            self.dest_doors_end_time = m.get('dest_doors_end_time')
        if m.get('doors_city_code') is not None:
            self.doors_city_code = m.get('doors_city_code')
        if m.get('doors_city_name') is not None:
            self.doors_city_name = m.get('doors_city_name')
        if m.get('doors_county_code') is not None:
            self.doors_county_code = m.get('doors_county_code')
        if m.get('doors_county_name') is not None:
            self.doors_county_name = m.get('doors_county_name')
        if m.get('doors_division_code') is not None:
            self.doors_division_code = m.get('doors_division_code')
        if m.get('doors_province_code') is not None:
            self.doors_province_code = m.get('doors_province_code')
        if m.get('doors_province_name') is not None:
            self.doors_province_name = m.get('doors_province_name')
        if m.get('drawee') is not None:
            self.drawee = m.get('drawee')
        if m.get('drawee_tax_no') is not None:
            self.drawee_tax_no = m.get('drawee_tax_no')
        if m.get('driver_did') is not None:
            self.driver_did = m.get('driver_did')
        if m.get('driver_name') is not None:
            self.driver_name = m.get('driver_name')
        if m.get('end_address') is not None:
            self.end_address = m.get('end_address')
        if m.get('end_city_code') is not None:
            self.end_city_code = m.get('end_city_code')
        if m.get('end_city_name') is not None:
            self.end_city_name = m.get('end_city_name')
        if m.get('end_county_code') is not None:
            self.end_county_code = m.get('end_county_code')
        if m.get('end_county_name') is not None:
            self.end_county_name = m.get('end_county_name')
        if m.get('end_division_code') is not None:
            self.end_division_code = m.get('end_division_code')
        if m.get('end_province_code') is not None:
            self.end_province_code = m.get('end_province_code')
        if m.get('end_province_name') is not None:
            self.end_province_name = m.get('end_province_name')
        if m.get('end_street_code') is not None:
            self.end_street_code = m.get('end_street_code')
        if m.get('end_street_name') is not None:
            self.end_street_name = m.get('end_street_name')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('freight_incr') is not None:
            self.freight_incr = m.get('freight_incr')
        if m.get('goods_amount') is not None:
            self.goods_amount = m.get('goods_amount')
        if m.get('goods_amount_type') is not None:
            self.goods_amount_type = m.get('goods_amount_type')
        if m.get('goods_name') is not None:
            self.goods_name = m.get('goods_name')
        if m.get('id_card') is not None:
            self.id_card = m.get('id_card')
        if m.get('loss_fee') is not None:
            self.loss_fee = m.get('loss_fee')
        if m.get('mobile_no') is not None:
            self.mobile_no = m.get('mobile_no')
        if m.get('partner_id') is not None:
            self.partner_id = m.get('partner_id')
        if m.get('pay_check') is not None:
            self.pay_check = m.get('pay_check')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('prepayments') is not None:
            self.prepayments = m.get('prepayments')
        if m.get('prepayments_buy_etc') is not None:
            self.prepayments_buy_etc = m.get('prepayments_buy_etc')
        if m.get('prepayments_buy_gas') is not None:
            self.prepayments_buy_gas = m.get('prepayments_buy_gas')
        if m.get('prepayments_buy_oil') is not None:
            self.prepayments_buy_oil = m.get('prepayments_buy_oil')
        if m.get('prepayments_etccard') is not None:
            self.prepayments_etccard = m.get('prepayments_etccard')
        if m.get('prepayments_oilcard') is not None:
            self.prepayments_oilcard = m.get('prepayments_oilcard')
        if m.get('present_amount_oil') is not None:
            self.present_amount_oil = m.get('present_amount_oil')
        if m.get('start_address') is not None:
            self.start_address = m.get('start_address')
        if m.get('start_city_code') is not None:
            self.start_city_code = m.get('start_city_code')
        if m.get('start_city_name') is not None:
            self.start_city_name = m.get('start_city_name')
        if m.get('start_county_code') is not None:
            self.start_county_code = m.get('start_county_code')
        if m.get('start_county_name') is not None:
            self.start_county_name = m.get('start_county_name')
        if m.get('start_division_code') is not None:
            self.start_division_code = m.get('start_division_code')
        if m.get('start_province_code') is not None:
            self.start_province_code = m.get('start_province_code')
        if m.get('start_province_name') is not None:
            self.start_province_name = m.get('start_province_name')
        if m.get('start_street_code') is not None:
            self.start_street_code = m.get('start_street_code')
        if m.get('start_street_name') is not None:
            self.start_street_name = m.get('start_street_name')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        if m.get('truck_length') is not None:
            self.truck_length = m.get('truck_length')
        if m.get('truck_type') is not None:
            self.truck_type = m.get('truck_type')
        if m.get('unit_price') is not None:
            self.unit_price = m.get('unit_price')
        return self


class FinishWaybillOrderResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        # 
        # 
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class CreateCargoPayorderRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        bank_account_of_payee: str = None,
        bank_account_of_payer: str = None,
        bank_no: str = None,
        bank_of_payee: str = None,
        bank_of_payer: str = None,
        bill_id: str = None,
        cargo_order: str = None,
        check_channel: str = None,
        currency: str = None,
        expense_type: str = None,
        payee: str = None,
        payer: str = None,
        payment: str = None,
        pay_check: bool = None,
        pay_did: str = None,
        pay_id: str = None,
        pay_note: str = None,
        pay_time: int = None,
        pay_type: str = None,
        platform_did: str = None,
        recv_did: str = None,
        request_id: str = None,
        tax_waybill_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 收款方银行账号
        self.bank_account_of_payee = bank_account_of_payee
        # 付款方银行账号,货主付款的开户银行账号
        self.bank_account_of_payer = bank_account_of_payer
        # 银行流水号，云资金校验时 必传；
        # 
        self.bank_no = bank_no
        # 收款方开户行（平台收款）
        # 
        # MYBank_CloudCapital_2,  ## 云资金2.0
        # 
        # 
        self.bank_of_payee = bank_of_payee
        # 付款方开户行(货主付款)  取值
        # 
        # MYBank_CloudCapital_2,  ## 云资金2.0
        self.bank_of_payer = bank_of_payer
        # 账单编号
        self.bill_id = bill_id
        # 货源单号
        # 
        self.cargo_order = cargo_order
        # 核验渠道，请按取值约束值填入
        # MYBank_CloudCapital_2,  ## 云资金2.0
        self.check_channel = check_channel
        # 币种
        # 按下列取值：
        # CNY、USD
        # 
        # 
        self.currency = currency
        # 费用类型 (运费、调度费、服务费)
        # 
        self.expense_type = expense_type
        # 收款方名称
        self.payee = payee
        # 付款方名称
        self.payer = payer
        # 费用金额（运单维度）
        # 
        self.payment = payment
        # 是否核验
        self.pay_check = pay_check
        # 付款方did
        # 
        self.pay_did = pay_did
        # 支付单号
        # 
        self.pay_id = pay_id
        # 支付备注
        # 
        self.pay_note = pay_note
        # 支付时间
        # 
        self.pay_time = pay_time
        # 支付类型
        # 
        self.pay_type = pay_type
        # 所属平台did
        self.platform_did = platform_did
        # 收款方did
        self.recv_did = recv_did
        # 请求唯一标识
        self.request_id = request_id
        # 运单号
        self.tax_waybill_id = tax_waybill_id

    def validate(self):
        self.validate_required(self.cargo_order, 'cargo_order')
        self.validate_required(self.expense_type, 'expense_type')
        self.validate_required(self.payment, 'payment')
        self.validate_required(self.pay_did, 'pay_did')
        self.validate_required(self.pay_id, 'pay_id')
        self.validate_required(self.pay_time, 'pay_time')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.recv_did, 'recv_did')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.bank_account_of_payee is not None:
            result['bank_account_of_payee'] = self.bank_account_of_payee
        if self.bank_account_of_payer is not None:
            result['bank_account_of_payer'] = self.bank_account_of_payer
        if self.bank_no is not None:
            result['bank_no'] = self.bank_no
        if self.bank_of_payee is not None:
            result['bank_of_payee'] = self.bank_of_payee
        if self.bank_of_payer is not None:
            result['bank_of_payer'] = self.bank_of_payer
        if self.bill_id is not None:
            result['bill_id'] = self.bill_id
        if self.cargo_order is not None:
            result['cargo_order'] = self.cargo_order
        if self.check_channel is not None:
            result['check_channel'] = self.check_channel
        if self.currency is not None:
            result['currency'] = self.currency
        if self.expense_type is not None:
            result['expense_type'] = self.expense_type
        if self.payee is not None:
            result['payee'] = self.payee
        if self.payer is not None:
            result['payer'] = self.payer
        if self.payment is not None:
            result['payment'] = self.payment
        if self.pay_check is not None:
            result['pay_check'] = self.pay_check
        if self.pay_did is not None:
            result['pay_did'] = self.pay_did
        if self.pay_id is not None:
            result['pay_id'] = self.pay_id
        if self.pay_note is not None:
            result['pay_note'] = self.pay_note
        if self.pay_time is not None:
            result['pay_time'] = self.pay_time
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.recv_did is not None:
            result['recv_did'] = self.recv_did
        if self.request_id is not None:
            result['request_id'] = self.request_id
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('bank_account_of_payee') is not None:
            self.bank_account_of_payee = m.get('bank_account_of_payee')
        if m.get('bank_account_of_payer') is not None:
            self.bank_account_of_payer = m.get('bank_account_of_payer')
        if m.get('bank_no') is not None:
            self.bank_no = m.get('bank_no')
        if m.get('bank_of_payee') is not None:
            self.bank_of_payee = m.get('bank_of_payee')
        if m.get('bank_of_payer') is not None:
            self.bank_of_payer = m.get('bank_of_payer')
        if m.get('bill_id') is not None:
            self.bill_id = m.get('bill_id')
        if m.get('cargo_order') is not None:
            self.cargo_order = m.get('cargo_order')
        if m.get('check_channel') is not None:
            self.check_channel = m.get('check_channel')
        if m.get('currency') is not None:
            self.currency = m.get('currency')
        if m.get('expense_type') is not None:
            self.expense_type = m.get('expense_type')
        if m.get('payee') is not None:
            self.payee = m.get('payee')
        if m.get('payer') is not None:
            self.payer = m.get('payer')
        if m.get('payment') is not None:
            self.payment = m.get('payment')
        if m.get('pay_check') is not None:
            self.pay_check = m.get('pay_check')
        if m.get('pay_did') is not None:
            self.pay_did = m.get('pay_did')
        if m.get('pay_id') is not None:
            self.pay_id = m.get('pay_id')
        if m.get('pay_note') is not None:
            self.pay_note = m.get('pay_note')
        if m.get('pay_time') is not None:
            self.pay_time = m.get('pay_time')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('recv_did') is not None:
            self.recv_did = m.get('recv_did')
        if m.get('request_id') is not None:
            self.request_id = m.get('request_id')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        return self


class CreateCargoPayorderResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 货源支付链上凭证
        # 
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class SaveWaybillOrderRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        all_freight: str = None,
        back_fee: str = None,
        business_type: str = None,
        cargo_business_code: str = None,
        cargo_code: str = None,
        cargo_insurance_money: str = None,
        cargo_order: str = None,
        cargo_unit: str = None,
        cargo_volume: str = None,
        cargo_weight: str = None,
        cart_badge_color: str = None,
        cart_badge_no: str = None,
        car_captain_did: str = None,
        consignor_freight_amount: str = None,
        created_time: int = None,
        dest_doors_end_time: int = None,
        doors_city_code: str = None,
        doors_city_name: str = None,
        doors_county_code: str = None,
        doors_county_name: str = None,
        doors_division_code: str = None,
        doors_province_code: str = None,
        doors_province_name: str = None,
        drawee: str = None,
        drawee_tax_no: str = None,
        driver_did: str = None,
        driver_name: str = None,
        end_address: str = None,
        end_city_code: str = None,
        end_city_name: str = None,
        end_county_code: str = None,
        end_county_name: str = None,
        end_division_code: str = None,
        end_province_code: str = None,
        end_province_name: str = None,
        end_street_code: str = None,
        end_street_name: str = None,
        end_time: int = None,
        freight_incr: str = None,
        goods_amount: str = None,
        goods_amount_type: str = None,
        goods_name: str = None,
        id_card: str = None,
        loss_fee: str = None,
        mobile_no: str = None,
        partner_id: str = None,
        pay_check: bool = None,
        platform_did: str = None,
        prepayments: str = None,
        prepayments_buy_etc: str = None,
        prepayments_buy_gas: str = None,
        prepayments_buy_oil: str = None,
        prepayments_etccard: str = None,
        prepayments_oilcard: str = None,
        present_amount_oil: str = None,
        start_address: str = None,
        start_city_code: str = None,
        start_city_name: str = None,
        start_county_code: str = None,
        start_county_name: str = None,
        start_division_code: str = None,
        start_province_code: str = None,
        start_province_name: str = None,
        start_street_code: str = None,
        start_street_name: str = None,
        start_time: int = None,
        tax_waybill_id: str = None,
        truck_length: str = None,
        truck_type: str = None,
        unit_price: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 链上账号 与司机did 二选一填写
        # 
        self.account_id = account_id
        # 运费，单位（元），平台支付给司机的运费
        self.all_freight = all_freight
        # 回单押金
        # 
        self.back_fee = back_fee
        # 业务类型
        self.business_type = business_type
        # 货物行业编码
        # 
        self.cargo_business_code = cargo_business_code
        # 货物商品编码
        # 
        self.cargo_code = cargo_code
        # 货物运费险
        # 
        self.cargo_insurance_money = cargo_insurance_money
        # 货源单号
        # 
        self.cargo_order = cargo_order
        # 货物单位
        # 
        self.cargo_unit = cargo_unit
        # 货物体积，单位（方）
        # 
        self.cargo_volume = cargo_volume
        # 货物重量，单位（吨）
        self.cargo_weight = cargo_weight
        # 车牌颜色，黄色、蓝色、绿色
        self.cart_badge_color = cart_badge_color
        # 车牌号
        # 
        self.cart_badge_no = cart_badge_no
        # 承运商did
        self.car_captain_did = car_captain_did
        # 货主运费金额，货主支付给平台的运费
        # 
        self.consignor_freight_amount = consignor_freight_amount
        # 建单时间，13位毫秒级时间戳
        self.created_time = created_time
        # 到达门点时间，13位毫秒级时间戳
        self.dest_doors_end_time = dest_doors_end_time
        # 门点城市CODE，6位区域行政编码
        self.doors_city_code = doors_city_code
        # 门点城市名称
        self.doors_city_name = doors_city_name
        # 门点区县CODE，6位区域行政编码
        self.doors_county_code = doors_county_code
        # 门点区县名称
        self.doors_county_name = doors_county_name
        # 门点行政区划代码，12位区域行政编码（长途运输须准确提供前6位，如不能提供后6位可补0；短途运输须准确提供12位）
        self.doors_division_code = doors_division_code
        # 门点省份CODE，6位区域行政编码
        self.doors_province_code = doors_province_code
        # 门点省份名称
        self.doors_province_name = doors_province_name
        # 发货方名称
        # 
        self.drawee = drawee
        # 发货方纳税人识别号
        # 
        self.drawee_tax_no = drawee_tax_no
        # 司机分布式数字身份
        # 
        self.driver_did = driver_did
        # 司机姓名 已填司机分布式身份的情况下可不填
        # 
        self.driver_name = driver_name
        # 目的地详细地址
        self.end_address = end_address
        # 目的地城市CODE，6位区域行政编码
        # 
        self.end_city_code = end_city_code
        # 目的地城市名称
        # 
        self.end_city_name = end_city_name
        # 目的地区县CODE，6位区域行政编码
        self.end_county_code = end_county_code
        # 目的地区县名称
        # 
        self.end_county_name = end_county_name
        # 结束行政区划代码（长途运输须准确提供前6位，如不能提供后6位可补0；短途运输须准确提供12位）
        # 
        self.end_division_code = end_division_code
        # 目的地省份CODE，6位区域行政编码
        self.end_province_code = end_province_code
        # 目的地省份名称
        # 
        self.end_province_name = end_province_name
        # 目的地街道CODE，12位区域行政编码
        self.end_street_code = end_street_code
        # 目的地街道名称
        self.end_street_name = end_street_name
        # 运达时间，13位毫秒级时间戳
        self.end_time = end_time
        # 运费增项
        # 
        self.freight_incr = freight_incr
        # 货物数量
        # 
        self.goods_amount = goods_amount
        # 货物数量单位类型
        # 
        self.goods_amount_type = goods_amount_type
        # 货物名称
        # 
        self.goods_name = goods_name
        # 司机身份证号 已填司机分布式身份的情况下可不填
        # 
        self.id_card = id_card
        # 运费扣减
        # 
        self.loss_fee = loss_fee
        # 司机手机号 已填司机分布式身份的情况下可不填
        # 
        self.mobile_no = mobile_no
        # 系统识别id 网商识别号
        # 
        self.partner_id = partner_id
        # 是否进行资金验证
        # 
        self.pay_check = pay_check
        # 无车承运平台分布式数字身份，缺省时为自己的分布式数字身份
        # 
        self.platform_did = platform_did
        # 预付款金额
        # 
        self.prepayments = prepayments
        # 线下预付ETC
        # 
        self.prepayments_buy_etc = prepayments_buy_etc
        # 线下气款金额
        # 
        self.prepayments_buy_gas = prepayments_buy_gas
        # 线下油款预付
        # 
        self.prepayments_buy_oil = prepayments_buy_oil
        # 预付ETC卡金额
        # 
        self.prepayments_etccard = prepayments_etccard
        # 预付油卡金额
        # 
        self.prepayments_oilcard = prepayments_oilcard
        # 油卡赠送金额
        # 
        self.present_amount_oil = present_amount_oil
        # 起始地详细地址
        self.start_address = start_address
        # 起始地城市CODE，6位区域行政编码
        # 
        self.start_city_code = start_city_code
        # 起始地城市名称
        # 
        self.start_city_name = start_city_name
        # 起始地区县CODE，6位区域行政编码
        # 
        # 
        self.start_county_code = start_county_code
        # 起始地区县名称
        # 
        self.start_county_name = start_county_name
        # 起始行政区划代码（长途运输须准确提供前6位，如不能提供后6位可补0；短途运输须准确提供12位）
        # 
        self.start_division_code = start_division_code
        # 起始地省份CODE，6位区域行政编码
        # 
        # 
        self.start_province_code = start_province_code
        # 起始地省份名称
        # 
        self.start_province_name = start_province_name
        # 起始地街道CODE，12位区域行政编码
        self.start_street_code = start_street_code
        # 起始地街道名称
        self.start_street_name = start_street_name
        # 起运时间，13位毫秒级时间戳
        self.start_time = start_time
        # 运单ID
        # 
        self.tax_waybill_id = tax_waybill_id
        # 车长，可以填：不限车长或者1.8，2.7，3.8，4.2，5，6.2，6.8，7.7，8.2，8.7，9.6，11.7，12.5，13，13.7，15，16，17.5等不超过2位小数的数字
        self.truck_length = truck_length
        # 车型
        self.truck_type = truck_type
        # 运输单价
        # 
        self.unit_price = unit_price

    def validate(self):
        self.validate_required(self.all_freight, 'all_freight')
        self.validate_required(self.cart_badge_color, 'cart_badge_color')
        self.validate_required(self.cart_badge_no, 'cart_badge_no')
        self.validate_required(self.consignor_freight_amount, 'consignor_freight_amount')
        self.validate_required(self.created_time, 'created_time')
        self.validate_required(self.drawee, 'drawee')
        self.validate_required(self.drawee_tax_no, 'drawee_tax_no')
        self.validate_required(self.driver_did, 'driver_did')
        self.validate_required(self.end_city_code, 'end_city_code')
        self.validate_required(self.end_city_name, 'end_city_name')
        self.validate_required(self.end_division_code, 'end_division_code')
        self.validate_required(self.end_province_code, 'end_province_code')
        self.validate_required(self.end_province_name, 'end_province_name')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.goods_name, 'goods_name')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.start_city_code, 'start_city_code')
        self.validate_required(self.start_city_name, 'start_city_name')
        self.validate_required(self.start_division_code, 'start_division_code')
        self.validate_required(self.start_province_code, 'start_province_code')
        self.validate_required(self.start_province_name, 'start_province_name')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.all_freight is not None:
            result['all_freight'] = self.all_freight
        if self.back_fee is not None:
            result['back_fee'] = self.back_fee
        if self.business_type is not None:
            result['business_type'] = self.business_type
        if self.cargo_business_code is not None:
            result['cargo_business_code'] = self.cargo_business_code
        if self.cargo_code is not None:
            result['cargo_code'] = self.cargo_code
        if self.cargo_insurance_money is not None:
            result['cargo_insurance_money'] = self.cargo_insurance_money
        if self.cargo_order is not None:
            result['cargo_order'] = self.cargo_order
        if self.cargo_unit is not None:
            result['cargo_unit'] = self.cargo_unit
        if self.cargo_volume is not None:
            result['cargo_volume'] = self.cargo_volume
        if self.cargo_weight is not None:
            result['cargo_weight'] = self.cargo_weight
        if self.cart_badge_color is not None:
            result['cart_badge_color'] = self.cart_badge_color
        if self.cart_badge_no is not None:
            result['cart_badge_no'] = self.cart_badge_no
        if self.car_captain_did is not None:
            result['car_captain_did'] = self.car_captain_did
        if self.consignor_freight_amount is not None:
            result['consignor_freight_amount'] = self.consignor_freight_amount
        if self.created_time is not None:
            result['created_time'] = self.created_time
        if self.dest_doors_end_time is not None:
            result['dest_doors_end_time'] = self.dest_doors_end_time
        if self.doors_city_code is not None:
            result['doors_city_code'] = self.doors_city_code
        if self.doors_city_name is not None:
            result['doors_city_name'] = self.doors_city_name
        if self.doors_county_code is not None:
            result['doors_county_code'] = self.doors_county_code
        if self.doors_county_name is not None:
            result['doors_county_name'] = self.doors_county_name
        if self.doors_division_code is not None:
            result['doors_division_code'] = self.doors_division_code
        if self.doors_province_code is not None:
            result['doors_province_code'] = self.doors_province_code
        if self.doors_province_name is not None:
            result['doors_province_name'] = self.doors_province_name
        if self.drawee is not None:
            result['drawee'] = self.drawee
        if self.drawee_tax_no is not None:
            result['drawee_tax_no'] = self.drawee_tax_no
        if self.driver_did is not None:
            result['driver_did'] = self.driver_did
        if self.driver_name is not None:
            result['driver_name'] = self.driver_name
        if self.end_address is not None:
            result['end_address'] = self.end_address
        if self.end_city_code is not None:
            result['end_city_code'] = self.end_city_code
        if self.end_city_name is not None:
            result['end_city_name'] = self.end_city_name
        if self.end_county_code is not None:
            result['end_county_code'] = self.end_county_code
        if self.end_county_name is not None:
            result['end_county_name'] = self.end_county_name
        if self.end_division_code is not None:
            result['end_division_code'] = self.end_division_code
        if self.end_province_code is not None:
            result['end_province_code'] = self.end_province_code
        if self.end_province_name is not None:
            result['end_province_name'] = self.end_province_name
        if self.end_street_code is not None:
            result['end_street_code'] = self.end_street_code
        if self.end_street_name is not None:
            result['end_street_name'] = self.end_street_name
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.freight_incr is not None:
            result['freight_incr'] = self.freight_incr
        if self.goods_amount is not None:
            result['goods_amount'] = self.goods_amount
        if self.goods_amount_type is not None:
            result['goods_amount_type'] = self.goods_amount_type
        if self.goods_name is not None:
            result['goods_name'] = self.goods_name
        if self.id_card is not None:
            result['id_card'] = self.id_card
        if self.loss_fee is not None:
            result['loss_fee'] = self.loss_fee
        if self.mobile_no is not None:
            result['mobile_no'] = self.mobile_no
        if self.partner_id is not None:
            result['partner_id'] = self.partner_id
        if self.pay_check is not None:
            result['pay_check'] = self.pay_check
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.prepayments is not None:
            result['prepayments'] = self.prepayments
        if self.prepayments_buy_etc is not None:
            result['prepayments_buy_etc'] = self.prepayments_buy_etc
        if self.prepayments_buy_gas is not None:
            result['prepayments_buy_gas'] = self.prepayments_buy_gas
        if self.prepayments_buy_oil is not None:
            result['prepayments_buy_oil'] = self.prepayments_buy_oil
        if self.prepayments_etccard is not None:
            result['prepayments_etccard'] = self.prepayments_etccard
        if self.prepayments_oilcard is not None:
            result['prepayments_oilcard'] = self.prepayments_oilcard
        if self.present_amount_oil is not None:
            result['present_amount_oil'] = self.present_amount_oil
        if self.start_address is not None:
            result['start_address'] = self.start_address
        if self.start_city_code is not None:
            result['start_city_code'] = self.start_city_code
        if self.start_city_name is not None:
            result['start_city_name'] = self.start_city_name
        if self.start_county_code is not None:
            result['start_county_code'] = self.start_county_code
        if self.start_county_name is not None:
            result['start_county_name'] = self.start_county_name
        if self.start_division_code is not None:
            result['start_division_code'] = self.start_division_code
        if self.start_province_code is not None:
            result['start_province_code'] = self.start_province_code
        if self.start_province_name is not None:
            result['start_province_name'] = self.start_province_name
        if self.start_street_code is not None:
            result['start_street_code'] = self.start_street_code
        if self.start_street_name is not None:
            result['start_street_name'] = self.start_street_name
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        if self.truck_length is not None:
            result['truck_length'] = self.truck_length
        if self.truck_type is not None:
            result['truck_type'] = self.truck_type
        if self.unit_price is not None:
            result['unit_price'] = self.unit_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('all_freight') is not None:
            self.all_freight = m.get('all_freight')
        if m.get('back_fee') is not None:
            self.back_fee = m.get('back_fee')
        if m.get('business_type') is not None:
            self.business_type = m.get('business_type')
        if m.get('cargo_business_code') is not None:
            self.cargo_business_code = m.get('cargo_business_code')
        if m.get('cargo_code') is not None:
            self.cargo_code = m.get('cargo_code')
        if m.get('cargo_insurance_money') is not None:
            self.cargo_insurance_money = m.get('cargo_insurance_money')
        if m.get('cargo_order') is not None:
            self.cargo_order = m.get('cargo_order')
        if m.get('cargo_unit') is not None:
            self.cargo_unit = m.get('cargo_unit')
        if m.get('cargo_volume') is not None:
            self.cargo_volume = m.get('cargo_volume')
        if m.get('cargo_weight') is not None:
            self.cargo_weight = m.get('cargo_weight')
        if m.get('cart_badge_color') is not None:
            self.cart_badge_color = m.get('cart_badge_color')
        if m.get('cart_badge_no') is not None:
            self.cart_badge_no = m.get('cart_badge_no')
        if m.get('car_captain_did') is not None:
            self.car_captain_did = m.get('car_captain_did')
        if m.get('consignor_freight_amount') is not None:
            self.consignor_freight_amount = m.get('consignor_freight_amount')
        if m.get('created_time') is not None:
            self.created_time = m.get('created_time')
        if m.get('dest_doors_end_time') is not None:
            self.dest_doors_end_time = m.get('dest_doors_end_time')
        if m.get('doors_city_code') is not None:
            self.doors_city_code = m.get('doors_city_code')
        if m.get('doors_city_name') is not None:
            self.doors_city_name = m.get('doors_city_name')
        if m.get('doors_county_code') is not None:
            self.doors_county_code = m.get('doors_county_code')
        if m.get('doors_county_name') is not None:
            self.doors_county_name = m.get('doors_county_name')
        if m.get('doors_division_code') is not None:
            self.doors_division_code = m.get('doors_division_code')
        if m.get('doors_province_code') is not None:
            self.doors_province_code = m.get('doors_province_code')
        if m.get('doors_province_name') is not None:
            self.doors_province_name = m.get('doors_province_name')
        if m.get('drawee') is not None:
            self.drawee = m.get('drawee')
        if m.get('drawee_tax_no') is not None:
            self.drawee_tax_no = m.get('drawee_tax_no')
        if m.get('driver_did') is not None:
            self.driver_did = m.get('driver_did')
        if m.get('driver_name') is not None:
            self.driver_name = m.get('driver_name')
        if m.get('end_address') is not None:
            self.end_address = m.get('end_address')
        if m.get('end_city_code') is not None:
            self.end_city_code = m.get('end_city_code')
        if m.get('end_city_name') is not None:
            self.end_city_name = m.get('end_city_name')
        if m.get('end_county_code') is not None:
            self.end_county_code = m.get('end_county_code')
        if m.get('end_county_name') is not None:
            self.end_county_name = m.get('end_county_name')
        if m.get('end_division_code') is not None:
            self.end_division_code = m.get('end_division_code')
        if m.get('end_province_code') is not None:
            self.end_province_code = m.get('end_province_code')
        if m.get('end_province_name') is not None:
            self.end_province_name = m.get('end_province_name')
        if m.get('end_street_code') is not None:
            self.end_street_code = m.get('end_street_code')
        if m.get('end_street_name') is not None:
            self.end_street_name = m.get('end_street_name')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('freight_incr') is not None:
            self.freight_incr = m.get('freight_incr')
        if m.get('goods_amount') is not None:
            self.goods_amount = m.get('goods_amount')
        if m.get('goods_amount_type') is not None:
            self.goods_amount_type = m.get('goods_amount_type')
        if m.get('goods_name') is not None:
            self.goods_name = m.get('goods_name')
        if m.get('id_card') is not None:
            self.id_card = m.get('id_card')
        if m.get('loss_fee') is not None:
            self.loss_fee = m.get('loss_fee')
        if m.get('mobile_no') is not None:
            self.mobile_no = m.get('mobile_no')
        if m.get('partner_id') is not None:
            self.partner_id = m.get('partner_id')
        if m.get('pay_check') is not None:
            self.pay_check = m.get('pay_check')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('prepayments') is not None:
            self.prepayments = m.get('prepayments')
        if m.get('prepayments_buy_etc') is not None:
            self.prepayments_buy_etc = m.get('prepayments_buy_etc')
        if m.get('prepayments_buy_gas') is not None:
            self.prepayments_buy_gas = m.get('prepayments_buy_gas')
        if m.get('prepayments_buy_oil') is not None:
            self.prepayments_buy_oil = m.get('prepayments_buy_oil')
        if m.get('prepayments_etccard') is not None:
            self.prepayments_etccard = m.get('prepayments_etccard')
        if m.get('prepayments_oilcard') is not None:
            self.prepayments_oilcard = m.get('prepayments_oilcard')
        if m.get('present_amount_oil') is not None:
            self.present_amount_oil = m.get('present_amount_oil')
        if m.get('start_address') is not None:
            self.start_address = m.get('start_address')
        if m.get('start_city_code') is not None:
            self.start_city_code = m.get('start_city_code')
        if m.get('start_city_name') is not None:
            self.start_city_name = m.get('start_city_name')
        if m.get('start_county_code') is not None:
            self.start_county_code = m.get('start_county_code')
        if m.get('start_county_name') is not None:
            self.start_county_name = m.get('start_county_name')
        if m.get('start_division_code') is not None:
            self.start_division_code = m.get('start_division_code')
        if m.get('start_province_code') is not None:
            self.start_province_code = m.get('start_province_code')
        if m.get('start_province_name') is not None:
            self.start_province_name = m.get('start_province_name')
        if m.get('start_street_code') is not None:
            self.start_street_code = m.get('start_street_code')
        if m.get('start_street_name') is not None:
            self.start_street_name = m.get('start_street_name')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        if m.get('truck_length') is not None:
            self.truck_length = m.get('truck_length')
        if m.get('truck_type') is not None:
            self.truck_type = m.get('truck_type')
        if m.get('unit_price') is not None:
            self.unit_price = m.get('unit_price')
        return self


class SaveWaybillOrderResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        # 
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class CloseWaybillOrderRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        platform_did: str = None,
        tax_waybill_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 无车承运平台分布式数字身份
        self.platform_did = platform_did
        # 运单ID
        # 
        self.tax_waybill_id = tax_waybill_id

    def validate(self):
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        return self


class CloseWaybillOrderResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        # 
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class FinishFinanceWaybillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        all_freight: str = None,
        back_fee: str = None,
        consignor_freight_amount: str = None,
        freight_incr: str = None,
        loss_fee: str = None,
        platform_did: str = None,
        tax_waybill_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 运费
        self.all_freight = all_freight
        # 回单押金
        self.back_fee = back_fee
        # 货主支付运费金额
        self.consignor_freight_amount = consignor_freight_amount
        # 运费增项
        self.freight_incr = freight_incr
        # 运费扣减
        self.loss_fee = loss_fee
        # 无车承运平台分布式数字身份，缺省时为自己的分布式数字身份
        self.platform_did = platform_did
        # 运单id
        self.tax_waybill_id = tax_waybill_id

    def validate(self):
        self.validate_required(self.consignor_freight_amount, 'consignor_freight_amount')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.all_freight is not None:
            result['all_freight'] = self.all_freight
        if self.back_fee is not None:
            result['back_fee'] = self.back_fee
        if self.consignor_freight_amount is not None:
            result['consignor_freight_amount'] = self.consignor_freight_amount
        if self.freight_incr is not None:
            result['freight_incr'] = self.freight_incr
        if self.loss_fee is not None:
            result['loss_fee'] = self.loss_fee
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('all_freight') is not None:
            self.all_freight = m.get('all_freight')
        if m.get('back_fee') is not None:
            self.back_fee = m.get('back_fee')
        if m.get('consignor_freight_amount') is not None:
            self.consignor_freight_amount = m.get('consignor_freight_amount')
        if m.get('freight_incr') is not None:
            self.freight_incr = m.get('freight_incr')
        if m.get('loss_fee') is not None:
            self.loss_fee = m.get('loss_fee')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        return self


class FinishFinanceWaybillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class FinishFinanceTransportRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        all_freight: str = None,
        back_fee: str = None,
        consignor_freight_amount: str = None,
        dest_doors_end_time: int = None,
        end_time: int = None,
        freight_incr: str = None,
        loss_fee: str = None,
        platform_did: str = None,
        tax_waybill_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 运费
        self.all_freight = all_freight
        # 回单押金
        self.back_fee = back_fee
        # 货主支付运费金额
        self.consignor_freight_amount = consignor_freight_amount
        # 到达门点时间
        self.dest_doors_end_time = dest_doors_end_time
        # 终结时间
        self.end_time = end_time
        # 运费增项
        self.freight_incr = freight_incr
        # 运费扣减
        self.loss_fee = loss_fee
        # 无车承运平台分布式数字身份，缺省时为自己的分布式数字身份
        self.platform_did = platform_did
        # 运单id
        self.tax_waybill_id = tax_waybill_id

    def validate(self):
        self.validate_required(self.consignor_freight_amount, 'consignor_freight_amount')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.all_freight is not None:
            result['all_freight'] = self.all_freight
        if self.back_fee is not None:
            result['back_fee'] = self.back_fee
        if self.consignor_freight_amount is not None:
            result['consignor_freight_amount'] = self.consignor_freight_amount
        if self.dest_doors_end_time is not None:
            result['dest_doors_end_time'] = self.dest_doors_end_time
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.freight_incr is not None:
            result['freight_incr'] = self.freight_incr
        if self.loss_fee is not None:
            result['loss_fee'] = self.loss_fee
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('all_freight') is not None:
            self.all_freight = m.get('all_freight')
        if m.get('back_fee') is not None:
            self.back_fee = m.get('back_fee')
        if m.get('consignor_freight_amount') is not None:
            self.consignor_freight_amount = m.get('consignor_freight_amount')
        if m.get('dest_doors_end_time') is not None:
            self.dest_doors_end_time = m.get('dest_doors_end_time')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('freight_incr') is not None:
            self.freight_incr = m.get('freight_incr')
        if m.get('loss_fee') is not None:
            self.loss_fee = m.get('loss_fee')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        return self


class FinishFinanceTransportResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 货源支付链上凭证
        # 
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class UpdateFinanceWaybillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        all_freight: str = None,
        back_fee: str = None,
        business_type: str = None,
        cargo_business_code: str = None,
        cargo_code: str = None,
        cargo_insurance_money: str = None,
        cargo_order: str = None,
        cargo_unit: str = None,
        cargo_volume: str = None,
        cargo_weight: str = None,
        cart_badge_color: str = None,
        cart_badge_no: str = None,
        car_captain_did: str = None,
        consignor_freight_amount: str = None,
        created_time: int = None,
        dest_doors_end_time: str = None,
        doors_city_code: str = None,
        doors_city_name: str = None,
        doors_county_code: str = None,
        doors_county_name: str = None,
        doors_division_code: str = None,
        doors_province_code: str = None,
        doors_province_name: str = None,
        drawee: str = None,
        drawee_tax_no: str = None,
        driver_did: str = None,
        end_address: str = None,
        end_city_code: str = None,
        end_city_name: str = None,
        end_county_code: str = None,
        end_county_name: str = None,
        end_division_code: str = None,
        end_province_code: str = None,
        end_province_name: str = None,
        end_street_code: str = None,
        end_street_name: str = None,
        end_time: int = None,
        freight_incr: str = None,
        goods_amount: int = None,
        goods_amount_type: str = None,
        goods_name: str = None,
        loss_fee: str = None,
        partner_id: str = None,
        platform_did: str = None,
        prepayments: str = None,
        prepayments_buy_etc: str = None,
        prepayments_buy_gas: str = None,
        prepayments_buy_oil: str = None,
        prepayments_etccard: str = None,
        prepayments_oilcard: str = None,
        present_amount_oil: str = None,
        start_address: str = None,
        start_city_code: str = None,
        start_city_name: str = None,
        start_county_code: str = None,
        start_county_name: str = None,
        start_division_code: str = None,
        start_province_code: str = None,
        start_province_name: str = None,
        start_street_code: str = None,
        start_street_name: str = None,
        start_time: int = None,
        tax_waybill_id: str = None,
        truck_length: str = None,
        truck_type: str = None,
        unit_price: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 运费，单位（元），平台支付给司机的运费
        self.all_freight = all_freight
        # 回单押金
        self.back_fee = back_fee
        # 业务类型
        self.business_type = business_type
        # 货物行业编码
        self.cargo_business_code = cargo_business_code
        # 货物商品编码
        self.cargo_code = cargo_code
        # 货物运费险
        self.cargo_insurance_money = cargo_insurance_money
        # 货源单号
        self.cargo_order = cargo_order
        # 货物单位
        self.cargo_unit = cargo_unit
        # 货物体积，单位（方）
        self.cargo_volume = cargo_volume
        # 货物重量，单位（吨）
        self.cargo_weight = cargo_weight
        # 车牌颜色，黄色、蓝色、绿色
        self.cart_badge_color = cart_badge_color
        # 车牌号
        self.cart_badge_no = cart_badge_no
        # 承运商did
        self.car_captain_did = car_captain_did
        # 货主支付运费金额，货主支付给平台的运费金额
        self.consignor_freight_amount = consignor_freight_amount
        # 建单时间，13位毫秒级时间戳
        self.created_time = created_time
        # 到达门点时间，13位毫秒级时间戳
        self.dest_doors_end_time = dest_doors_end_time
        # 门点城市CODE，6位区域行政编码
        self.doors_city_code = doors_city_code
        # 门点城市名称
        self.doors_city_name = doors_city_name
        # 门点区县CODE，6位区域行政编码
        self.doors_county_code = doors_county_code
        # 门点区县名称
        self.doors_county_name = doors_county_name
        # 门点行政区划代码，12位区域行政编码，（长途运输须准确提供前6位，如不能提供后6位可补0；短途运输须准确提供12位）
        self.doors_division_code = doors_division_code
        # 门点省份CODE，6位行政区域编码
        self.doors_province_code = doors_province_code
        # 门点省份名称
        self.doors_province_name = doors_province_name
        # 发货方名称
        self.drawee = drawee
        # 发货方纳税人识别号
        self.drawee_tax_no = drawee_tax_no
        # 司机分布式数字身份
        self.driver_did = driver_did
        # 目的地详细地址
        self.end_address = end_address
        # 目的地城市CODE，6位区域行政编码
        self.end_city_code = end_city_code
        # 目的地城市名称
        self.end_city_name = end_city_name
        # 目的地区县CODE
        self.end_county_code = end_county_code
        # 目的地区县名称，6位区域行政编码
        self.end_county_name = end_county_name
        # 结束行政区划代码，12位区域行政编码，（长途运输须准确提供前6位，如不能提供后6位可补0；短途运输须准确提供12位）
        self.end_division_code = end_division_code
        # 目的地省份CODE，6位区域行政编码
        self.end_province_code = end_province_code
        # 目的地省份名称
        self.end_province_name = end_province_name
        # 目的地街道CODE，12位区域行政编码
        self.end_street_code = end_street_code
        # 目的地街道名称
        self.end_street_name = end_street_name
        # 终结时间，13位毫秒级时间戳
        self.end_time = end_time
        # 运费增项
        self.freight_incr = freight_incr
        # 货物数量
        self.goods_amount = goods_amount
        # 货物数量单位类型
        self.goods_amount_type = goods_amount_type
        # 货物名称
        self.goods_name = goods_name
        # 运费扣减
        self.loss_fee = loss_fee
        # 网商识别号
        self.partner_id = partner_id
        # 无车承运平台分布式数字身份，缺省时为自己的分布式数字身份
        # 
        self.platform_did = platform_did
        # 预付款金额
        self.prepayments = prepayments
        # 线下预付ETC
        self.prepayments_buy_etc = prepayments_buy_etc
        # 线下气款金额
        self.prepayments_buy_gas = prepayments_buy_gas
        # 线下油款预付
        self.prepayments_buy_oil = prepayments_buy_oil
        # 预付ETC卡金额
        self.prepayments_etccard = prepayments_etccard
        # 预付油卡金额
        self.prepayments_oilcard = prepayments_oilcard
        # 油卡赠送金额
        self.present_amount_oil = present_amount_oil
        # 起始地详细地址
        self.start_address = start_address
        # 起始地CODE，6位区域行政编码
        self.start_city_code = start_city_code
        # 起始地城市名称
        self.start_city_name = start_city_name
        # 起始地区县CODE，6位区域行政编码
        self.start_county_code = start_county_code
        # 起始地区县名称
        self.start_county_name = start_county_name
        # 起始行政区划代码，12位区域行政编码（长途运输须准确提供前6位，如不能提供后6位可补0；短途运输须准确提供12位）
        self.start_division_code = start_division_code
        # 起始地省份CODE，6位区域行政编码
        self.start_province_code = start_province_code
        # 起始地省份名称
        self.start_province_name = start_province_name
        # 起始地街道CODE，12位区域行政编码
        self.start_street_code = start_street_code
        # 起始地街道名称
        self.start_street_name = start_street_name
        # 起运时间戳，13位毫秒级时间戳
        self.start_time = start_time
        # 运单id
        self.tax_waybill_id = tax_waybill_id
        # 车长，可以填：不限车长或者1.8，2.7，3.8，4.2，5，6.2，6.8，7.7，8.2，8.7，9.6，11.7，12.5，13，13.7，15，16，17.5等不超过2位小数的数字
        self.truck_length = truck_length
        # 车型，可以填写：不限车型，平板，高栏，厢式，集装箱，自卸，冷藏，保温，高低板，面包车，棉被车，爬梯车，飞翼车
        self.truck_type = truck_type
        # 运输单价
        self.unit_price = unit_price

    def validate(self):
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.all_freight is not None:
            result['all_freight'] = self.all_freight
        if self.back_fee is not None:
            result['back_fee'] = self.back_fee
        if self.business_type is not None:
            result['business_type'] = self.business_type
        if self.cargo_business_code is not None:
            result['cargo_business_code'] = self.cargo_business_code
        if self.cargo_code is not None:
            result['cargo_code'] = self.cargo_code
        if self.cargo_insurance_money is not None:
            result['cargo_insurance_money'] = self.cargo_insurance_money
        if self.cargo_order is not None:
            result['cargo_order'] = self.cargo_order
        if self.cargo_unit is not None:
            result['cargo_unit'] = self.cargo_unit
        if self.cargo_volume is not None:
            result['cargo_volume'] = self.cargo_volume
        if self.cargo_weight is not None:
            result['cargo_weight'] = self.cargo_weight
        if self.cart_badge_color is not None:
            result['cart_badge_color'] = self.cart_badge_color
        if self.cart_badge_no is not None:
            result['cart_badge_no'] = self.cart_badge_no
        if self.car_captain_did is not None:
            result['car_captain_did'] = self.car_captain_did
        if self.consignor_freight_amount is not None:
            result['consignor_freight_amount'] = self.consignor_freight_amount
        if self.created_time is not None:
            result['created_time'] = self.created_time
        if self.dest_doors_end_time is not None:
            result['dest_doors_end_time'] = self.dest_doors_end_time
        if self.doors_city_code is not None:
            result['doors_city_code'] = self.doors_city_code
        if self.doors_city_name is not None:
            result['doors_city_name'] = self.doors_city_name
        if self.doors_county_code is not None:
            result['doors_county_code'] = self.doors_county_code
        if self.doors_county_name is not None:
            result['doors_county_name'] = self.doors_county_name
        if self.doors_division_code is not None:
            result['doors_division_code'] = self.doors_division_code
        if self.doors_province_code is not None:
            result['doors_province_code'] = self.doors_province_code
        if self.doors_province_name is not None:
            result['doors_province_name'] = self.doors_province_name
        if self.drawee is not None:
            result['drawee'] = self.drawee
        if self.drawee_tax_no is not None:
            result['drawee_tax_no'] = self.drawee_tax_no
        if self.driver_did is not None:
            result['driver_did'] = self.driver_did
        if self.end_address is not None:
            result['end_address'] = self.end_address
        if self.end_city_code is not None:
            result['end_city_code'] = self.end_city_code
        if self.end_city_name is not None:
            result['end_city_name'] = self.end_city_name
        if self.end_county_code is not None:
            result['end_county_code'] = self.end_county_code
        if self.end_county_name is not None:
            result['end_county_name'] = self.end_county_name
        if self.end_division_code is not None:
            result['end_division_code'] = self.end_division_code
        if self.end_province_code is not None:
            result['end_province_code'] = self.end_province_code
        if self.end_province_name is not None:
            result['end_province_name'] = self.end_province_name
        if self.end_street_code is not None:
            result['end_street_code'] = self.end_street_code
        if self.end_street_name is not None:
            result['end_street_name'] = self.end_street_name
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.freight_incr is not None:
            result['freight_incr'] = self.freight_incr
        if self.goods_amount is not None:
            result['goods_amount'] = self.goods_amount
        if self.goods_amount_type is not None:
            result['goods_amount_type'] = self.goods_amount_type
        if self.goods_name is not None:
            result['goods_name'] = self.goods_name
        if self.loss_fee is not None:
            result['loss_fee'] = self.loss_fee
        if self.partner_id is not None:
            result['partner_id'] = self.partner_id
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.prepayments is not None:
            result['prepayments'] = self.prepayments
        if self.prepayments_buy_etc is not None:
            result['prepayments_buy_etc'] = self.prepayments_buy_etc
        if self.prepayments_buy_gas is not None:
            result['prepayments_buy_gas'] = self.prepayments_buy_gas
        if self.prepayments_buy_oil is not None:
            result['prepayments_buy_oil'] = self.prepayments_buy_oil
        if self.prepayments_etccard is not None:
            result['prepayments_etccard'] = self.prepayments_etccard
        if self.prepayments_oilcard is not None:
            result['prepayments_oilcard'] = self.prepayments_oilcard
        if self.present_amount_oil is not None:
            result['present_amount_oil'] = self.present_amount_oil
        if self.start_address is not None:
            result['start_address'] = self.start_address
        if self.start_city_code is not None:
            result['start_city_code'] = self.start_city_code
        if self.start_city_name is not None:
            result['start_city_name'] = self.start_city_name
        if self.start_county_code is not None:
            result['start_county_code'] = self.start_county_code
        if self.start_county_name is not None:
            result['start_county_name'] = self.start_county_name
        if self.start_division_code is not None:
            result['start_division_code'] = self.start_division_code
        if self.start_province_code is not None:
            result['start_province_code'] = self.start_province_code
        if self.start_province_name is not None:
            result['start_province_name'] = self.start_province_name
        if self.start_street_code is not None:
            result['start_street_code'] = self.start_street_code
        if self.start_street_name is not None:
            result['start_street_name'] = self.start_street_name
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        if self.truck_length is not None:
            result['truck_length'] = self.truck_length
        if self.truck_type is not None:
            result['truck_type'] = self.truck_type
        if self.unit_price is not None:
            result['unit_price'] = self.unit_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('all_freight') is not None:
            self.all_freight = m.get('all_freight')
        if m.get('back_fee') is not None:
            self.back_fee = m.get('back_fee')
        if m.get('business_type') is not None:
            self.business_type = m.get('business_type')
        if m.get('cargo_business_code') is not None:
            self.cargo_business_code = m.get('cargo_business_code')
        if m.get('cargo_code') is not None:
            self.cargo_code = m.get('cargo_code')
        if m.get('cargo_insurance_money') is not None:
            self.cargo_insurance_money = m.get('cargo_insurance_money')
        if m.get('cargo_order') is not None:
            self.cargo_order = m.get('cargo_order')
        if m.get('cargo_unit') is not None:
            self.cargo_unit = m.get('cargo_unit')
        if m.get('cargo_volume') is not None:
            self.cargo_volume = m.get('cargo_volume')
        if m.get('cargo_weight') is not None:
            self.cargo_weight = m.get('cargo_weight')
        if m.get('cart_badge_color') is not None:
            self.cart_badge_color = m.get('cart_badge_color')
        if m.get('cart_badge_no') is not None:
            self.cart_badge_no = m.get('cart_badge_no')
        if m.get('car_captain_did') is not None:
            self.car_captain_did = m.get('car_captain_did')
        if m.get('consignor_freight_amount') is not None:
            self.consignor_freight_amount = m.get('consignor_freight_amount')
        if m.get('created_time') is not None:
            self.created_time = m.get('created_time')
        if m.get('dest_doors_end_time') is not None:
            self.dest_doors_end_time = m.get('dest_doors_end_time')
        if m.get('doors_city_code') is not None:
            self.doors_city_code = m.get('doors_city_code')
        if m.get('doors_city_name') is not None:
            self.doors_city_name = m.get('doors_city_name')
        if m.get('doors_county_code') is not None:
            self.doors_county_code = m.get('doors_county_code')
        if m.get('doors_county_name') is not None:
            self.doors_county_name = m.get('doors_county_name')
        if m.get('doors_division_code') is not None:
            self.doors_division_code = m.get('doors_division_code')
        if m.get('doors_province_code') is not None:
            self.doors_province_code = m.get('doors_province_code')
        if m.get('doors_province_name') is not None:
            self.doors_province_name = m.get('doors_province_name')
        if m.get('drawee') is not None:
            self.drawee = m.get('drawee')
        if m.get('drawee_tax_no') is not None:
            self.drawee_tax_no = m.get('drawee_tax_no')
        if m.get('driver_did') is not None:
            self.driver_did = m.get('driver_did')
        if m.get('end_address') is not None:
            self.end_address = m.get('end_address')
        if m.get('end_city_code') is not None:
            self.end_city_code = m.get('end_city_code')
        if m.get('end_city_name') is not None:
            self.end_city_name = m.get('end_city_name')
        if m.get('end_county_code') is not None:
            self.end_county_code = m.get('end_county_code')
        if m.get('end_county_name') is not None:
            self.end_county_name = m.get('end_county_name')
        if m.get('end_division_code') is not None:
            self.end_division_code = m.get('end_division_code')
        if m.get('end_province_code') is not None:
            self.end_province_code = m.get('end_province_code')
        if m.get('end_province_name') is not None:
            self.end_province_name = m.get('end_province_name')
        if m.get('end_street_code') is not None:
            self.end_street_code = m.get('end_street_code')
        if m.get('end_street_name') is not None:
            self.end_street_name = m.get('end_street_name')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('freight_incr') is not None:
            self.freight_incr = m.get('freight_incr')
        if m.get('goods_amount') is not None:
            self.goods_amount = m.get('goods_amount')
        if m.get('goods_amount_type') is not None:
            self.goods_amount_type = m.get('goods_amount_type')
        if m.get('goods_name') is not None:
            self.goods_name = m.get('goods_name')
        if m.get('loss_fee') is not None:
            self.loss_fee = m.get('loss_fee')
        if m.get('partner_id') is not None:
            self.partner_id = m.get('partner_id')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('prepayments') is not None:
            self.prepayments = m.get('prepayments')
        if m.get('prepayments_buy_etc') is not None:
            self.prepayments_buy_etc = m.get('prepayments_buy_etc')
        if m.get('prepayments_buy_gas') is not None:
            self.prepayments_buy_gas = m.get('prepayments_buy_gas')
        if m.get('prepayments_buy_oil') is not None:
            self.prepayments_buy_oil = m.get('prepayments_buy_oil')
        if m.get('prepayments_etccard') is not None:
            self.prepayments_etccard = m.get('prepayments_etccard')
        if m.get('prepayments_oilcard') is not None:
            self.prepayments_oilcard = m.get('prepayments_oilcard')
        if m.get('present_amount_oil') is not None:
            self.present_amount_oil = m.get('present_amount_oil')
        if m.get('start_address') is not None:
            self.start_address = m.get('start_address')
        if m.get('start_city_code') is not None:
            self.start_city_code = m.get('start_city_code')
        if m.get('start_city_name') is not None:
            self.start_city_name = m.get('start_city_name')
        if m.get('start_county_code') is not None:
            self.start_county_code = m.get('start_county_code')
        if m.get('start_county_name') is not None:
            self.start_county_name = m.get('start_county_name')
        if m.get('start_division_code') is not None:
            self.start_division_code = m.get('start_division_code')
        if m.get('start_province_code') is not None:
            self.start_province_code = m.get('start_province_code')
        if m.get('start_province_name') is not None:
            self.start_province_name = m.get('start_province_name')
        if m.get('start_street_code') is not None:
            self.start_street_code = m.get('start_street_code')
        if m.get('start_street_name') is not None:
            self.start_street_name = m.get('start_street_name')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        if m.get('truck_length') is not None:
            self.truck_length = m.get('truck_length')
        if m.get('truck_type') is not None:
            self.truck_type = m.get('truck_type')
        if m.get('unit_price') is not None:
            self.unit_price = m.get('unit_price')
        return self


class UpdateFinanceWaybillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 货源支付链上凭证
        # 
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class StartFinanceWaybillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cargo_insurance_money: str = None,
        cart_badge_color: str = None,
        cart_badge_no: str = None,
        car_captain_did: str = None,
        driver_did: str = None,
        platform_did: str = None,
        start_time: int = None,
        tax_waybill_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 货物运费险
        self.cargo_insurance_money = cargo_insurance_money
        # 车牌颜色
        self.cart_badge_color = cart_badge_color
        # 车牌号
        self.cart_badge_no = cart_badge_no
        # 承运商did
        self.car_captain_did = car_captain_did
        # 司机分布式数字身份
        self.driver_did = driver_did
        # 无车承运平台分布式数字身份，缺省时为自己的分布式数字身份
        self.platform_did = platform_did
        # 起运时间，13位毫秒级时间戳
        self.start_time = start_time
        # 运单id
        self.tax_waybill_id = tax_waybill_id

    def validate(self):
        self.validate_required(self.cart_badge_color, 'cart_badge_color')
        self.validate_required(self.cart_badge_no, 'cart_badge_no')
        self.validate_required(self.driver_did, 'driver_did')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cargo_insurance_money is not None:
            result['cargo_insurance_money'] = self.cargo_insurance_money
        if self.cart_badge_color is not None:
            result['cart_badge_color'] = self.cart_badge_color
        if self.cart_badge_no is not None:
            result['cart_badge_no'] = self.cart_badge_no
        if self.car_captain_did is not None:
            result['car_captain_did'] = self.car_captain_did
        if self.driver_did is not None:
            result['driver_did'] = self.driver_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cargo_insurance_money') is not None:
            self.cargo_insurance_money = m.get('cargo_insurance_money')
        if m.get('cart_badge_color') is not None:
            self.cart_badge_color = m.get('cart_badge_color')
        if m.get('cart_badge_no') is not None:
            self.cart_badge_no = m.get('cart_badge_no')
        if m.get('car_captain_did') is not None:
            self.car_captain_did = m.get('car_captain_did')
        if m.get('driver_did') is not None:
            self.driver_did = m.get('driver_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        return self


class StartFinanceWaybillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 货源支付链上凭证
        # 
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class CreateCaptainDisRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cert_no: str = None,
        extension_info: str = None,
        mobile: str = None,
        name: str = None,
        platform_did: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 身份证号码
        self.cert_no = cert_no
        # 扩展字段
        self.extension_info = extension_info
        # 手机号码
        self.mobile = mobile
        # 姓名
        self.name = name
        # 所属平台did
        self.platform_did = platform_did

    def validate(self):
        self.validate_required(self.cert_no, 'cert_no')
        self.validate_required(self.mobile, 'mobile')
        self.validate_required(self.name, 'name')
        self.validate_required(self.platform_did, 'platform_did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.extension_info is not None:
            result['extension_info'] = self.extension_info
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('extension_info') is not None:
            self.extension_info = m.get('extension_info')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        return self


class CreateCaptainDisResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        did: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 车队长did
        self.did = did

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.did is not None:
            result['did'] = self.did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('did') is not None:
            self.did = m.get('did')
        return self


class CreateCargowaybillBillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        bill_amount: str = None,
        bill_code: str = None,
        bill_create_time: int = None,
        bill_deadline: str = None,
        bill_payer_did: str = None,
        cargo_amounts: List[CargoAmount] = None,
        currency: str = None,
        pay_amounts: List[PayAmount] = None,
        platform_did: str = None,
        pre_consignor_pay_date: int = None,
        waybill_amounts: List[WaybillAmount] = None,
        deadline: int = None,
        waybill_upload_status: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 货主账单总额（两位小数）
        self.bill_amount = bill_amount
        # 账单code（唯一标识）
        self.bill_code = bill_code
        # 账单生成时间(毫秒)
        self.bill_create_time = bill_create_time
        # 账单期限，单位（天），需填写1到360之间的整数
        self.bill_deadline = bill_deadline
        # 付款方did
        self.bill_payer_did = bill_payer_did
        # 货源单号-货主运费列表
        self.cargo_amounts = cargo_amounts
        # 币种
        self.currency = currency
        # 货主支付方式-支付金额列表
        self.pay_amounts = pay_amounts
        # 平台did
        self.platform_did = platform_did
        # 预计货主付款日期
        self.pre_consignor_pay_date = pre_consignor_pay_date
        # 运单号-司机运费列表
        self.waybill_amounts = waybill_amounts
        # 账单到期日期
        self.deadline = deadline
        # 运单上传状态，可填写：已完成、未完成
        self.waybill_upload_status = waybill_upload_status

    def validate(self):
        self.validate_required(self.bill_amount, 'bill_amount')
        self.validate_required(self.bill_code, 'bill_code')
        self.validate_required(self.bill_create_time, 'bill_create_time')
        self.validate_required(self.bill_deadline, 'bill_deadline')
        self.validate_required(self.bill_payer_did, 'bill_payer_did')
        self.validate_required(self.cargo_amounts, 'cargo_amounts')
        if self.cargo_amounts:
            for k in self.cargo_amounts:
                if k:
                    k.validate()
        self.validate_required(self.currency, 'currency')
        self.validate_required(self.pay_amounts, 'pay_amounts')
        if self.pay_amounts:
            for k in self.pay_amounts:
                if k:
                    k.validate()
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.pre_consignor_pay_date, 'pre_consignor_pay_date')
        self.validate_required(self.waybill_amounts, 'waybill_amounts')
        if self.waybill_amounts:
            for k in self.waybill_amounts:
                if k:
                    k.validate()
        self.validate_required(self.deadline, 'deadline')
        self.validate_required(self.waybill_upload_status, 'waybill_upload_status')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.bill_amount is not None:
            result['bill_amount'] = self.bill_amount
        if self.bill_code is not None:
            result['bill_code'] = self.bill_code
        if self.bill_create_time is not None:
            result['bill_create_time'] = self.bill_create_time
        if self.bill_deadline is not None:
            result['bill_deadline'] = self.bill_deadline
        if self.bill_payer_did is not None:
            result['bill_payer_did'] = self.bill_payer_did
        result['cargo_amounts'] = []
        if self.cargo_amounts is not None:
            for k in self.cargo_amounts:
                result['cargo_amounts'].append(k.to_map() if k else None)
        if self.currency is not None:
            result['currency'] = self.currency
        result['pay_amounts'] = []
        if self.pay_amounts is not None:
            for k in self.pay_amounts:
                result['pay_amounts'].append(k.to_map() if k else None)
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.pre_consignor_pay_date is not None:
            result['pre_consignor_pay_date'] = self.pre_consignor_pay_date
        result['waybill_amounts'] = []
        if self.waybill_amounts is not None:
            for k in self.waybill_amounts:
                result['waybill_amounts'].append(k.to_map() if k else None)
        if self.deadline is not None:
            result['deadline'] = self.deadline
        if self.waybill_upload_status is not None:
            result['waybill_upload_status'] = self.waybill_upload_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('bill_amount') is not None:
            self.bill_amount = m.get('bill_amount')
        if m.get('bill_code') is not None:
            self.bill_code = m.get('bill_code')
        if m.get('bill_create_time') is not None:
            self.bill_create_time = m.get('bill_create_time')
        if m.get('bill_deadline') is not None:
            self.bill_deadline = m.get('bill_deadline')
        if m.get('bill_payer_did') is not None:
            self.bill_payer_did = m.get('bill_payer_did')
        self.cargo_amounts = []
        if m.get('cargo_amounts') is not None:
            for k in m.get('cargo_amounts'):
                temp_model = CargoAmount()
                self.cargo_amounts.append(temp_model.from_map(k))
        if m.get('currency') is not None:
            self.currency = m.get('currency')
        self.pay_amounts = []
        if m.get('pay_amounts') is not None:
            for k in m.get('pay_amounts'):
                temp_model = PayAmount()
                self.pay_amounts.append(temp_model.from_map(k))
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('pre_consignor_pay_date') is not None:
            self.pre_consignor_pay_date = m.get('pre_consignor_pay_date')
        self.waybill_amounts = []
        if m.get('waybill_amounts') is not None:
            for k in m.get('waybill_amounts'):
                temp_model = WaybillAmount()
                self.waybill_amounts.append(temp_model.from_map(k))
        if m.get('deadline') is not None:
            self.deadline = m.get('deadline')
        if m.get('waybill_upload_status') is not None:
            self.waybill_upload_status = m.get('waybill_upload_status')
        return self


class CreateCargowaybillBillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class ConfirmCargowaybillBillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        bill_amount: str = None,
        bill_code: str = None,
        bill_consignor_did: str = None,
        bill_sure_date: int = None,
        whether_settle: bool = None,
        platform_did: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 账单金额（两位小数）
        self.bill_amount = bill_amount
        # 账单code（账单唯一标识）
        self.bill_code = bill_code
        # 账单确认货主did
        self.bill_consignor_did = bill_consignor_did
        # 账单确认日期（毫秒）
        self.bill_sure_date = bill_sure_date
        # 是否结算
        self.whether_settle = whether_settle
        # 平台did
        self.platform_did = platform_did

    def validate(self):
        self.validate_required(self.bill_amount, 'bill_amount')
        self.validate_required(self.bill_code, 'bill_code')
        self.validate_required(self.bill_consignor_did, 'bill_consignor_did')
        self.validate_required(self.whether_settle, 'whether_settle')
        self.validate_required(self.platform_did, 'platform_did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.bill_amount is not None:
            result['bill_amount'] = self.bill_amount
        if self.bill_code is not None:
            result['bill_code'] = self.bill_code
        if self.bill_consignor_did is not None:
            result['bill_consignor_did'] = self.bill_consignor_did
        if self.bill_sure_date is not None:
            result['bill_sure_date'] = self.bill_sure_date
        if self.whether_settle is not None:
            result['whether_settle'] = self.whether_settle
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('bill_amount') is not None:
            self.bill_amount = m.get('bill_amount')
        if m.get('bill_code') is not None:
            self.bill_code = m.get('bill_code')
        if m.get('bill_consignor_did') is not None:
            self.bill_consignor_did = m.get('bill_consignor_did')
        if m.get('bill_sure_date') is not None:
            self.bill_sure_date = m.get('bill_sure_date')
        if m.get('whether_settle') is not None:
            self.whether_settle = m.get('whether_settle')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        return self


class ConfirmCargowaybillBillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class CreateCargowaybillBillsettleRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        platform_did: str = None,
        bill_code: str = None,
        settle_amount: str = None,
        settle_status: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 平台did
        self.platform_did = platform_did
        # 账单code（账单唯一标识）
        self.bill_code = bill_code
        # 结算金额（2位小数）
        self.settle_amount = settle_amount
        # 结算状态（只有2种状态：部分结算、已结清）
        self.settle_status = settle_status

    def validate(self):
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.bill_code, 'bill_code')
        self.validate_required(self.settle_amount, 'settle_amount')
        self.validate_required(self.settle_status, 'settle_status')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.bill_code is not None:
            result['bill_code'] = self.bill_code
        if self.settle_amount is not None:
            result['settle_amount'] = self.settle_amount
        if self.settle_status is not None:
            result['settle_status'] = self.settle_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('bill_code') is not None:
            self.bill_code = m.get('bill_code')
        if m.get('settle_amount') is not None:
            self.settle_amount = m.get('settle_amount')
        if m.get('settle_status') is not None:
            self.settle_status = m.get('settle_status')
        return self


class CreateCargowaybillBillsettleResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class UpdateWaybillorderPlatformdidRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        new_platform_did: str = None,
        old_platform_did: str = None,
        tax_waybill_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 新平台diid
        self.new_platform_did = new_platform_did
        # 老平台did
        self.old_platform_did = old_platform_did
        # 运单号
        self.tax_waybill_id = tax_waybill_id

    def validate(self):
        self.validate_required(self.new_platform_did, 'new_platform_did')
        self.validate_required(self.old_platform_did, 'old_platform_did')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.new_platform_did is not None:
            result['new_platform_did'] = self.new_platform_did
        if self.old_platform_did is not None:
            result['old_platform_did'] = self.old_platform_did
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('new_platform_did') is not None:
            self.new_platform_did = m.get('new_platform_did')
        if m.get('old_platform_did') is not None:
            self.old_platform_did = m.get('old_platform_did')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        return self


class UpdateWaybillorderPlatformdidResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class UpdateCargowaybillBillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        bill_amount: str = None,
        bill_code: str = None,
        bill_create_time: int = None,
        bill_deadline: str = None,
        bill_payer_did: str = None,
        cargo_amounts: List[CargoAmount] = None,
        currency: str = None,
        deadline: int = None,
        pay_amounts: List[PayAmount] = None,
        platform_did: str = None,
        pre_consignor_pay_date: int = None,
        waybill_amounts: List[WaybillAmount] = None,
        waybill_upload_status: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 货主账单总额（两位小数）
        self.bill_amount = bill_amount
        # 账单code（唯一标识）
        self.bill_code = bill_code
        # 账单生成时间(毫秒)
        self.bill_create_time = bill_create_time
        # 账单期限，单位（天），需填写1到360之间的整数
        self.bill_deadline = bill_deadline
        # 付款方did
        self.bill_payer_did = bill_payer_did
        # 货源单号-货主运费列表
        self.cargo_amounts = cargo_amounts
        # 币种
        self.currency = currency
        # 账单到期日期
        self.deadline = deadline
        # 货主支付方式-支付金额列表
        self.pay_amounts = pay_amounts
        # 平台did
        self.platform_did = platform_did
        # 预计货主付款日期
        self.pre_consignor_pay_date = pre_consignor_pay_date
        # 运单号-司机运费列表
        self.waybill_amounts = waybill_amounts
        # 运单上传状态，可填写：已完成、未完成
        self.waybill_upload_status = waybill_upload_status

    def validate(self):
        self.validate_required(self.bill_amount, 'bill_amount')
        self.validate_required(self.bill_code, 'bill_code')
        self.validate_required(self.bill_create_time, 'bill_create_time')
        self.validate_required(self.bill_deadline, 'bill_deadline')
        self.validate_required(self.bill_payer_did, 'bill_payer_did')
        self.validate_required(self.cargo_amounts, 'cargo_amounts')
        if self.cargo_amounts:
            for k in self.cargo_amounts:
                if k:
                    k.validate()
        self.validate_required(self.currency, 'currency')
        self.validate_required(self.deadline, 'deadline')
        self.validate_required(self.pay_amounts, 'pay_amounts')
        if self.pay_amounts:
            for k in self.pay_amounts:
                if k:
                    k.validate()
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.pre_consignor_pay_date, 'pre_consignor_pay_date')
        if self.waybill_amounts:
            for k in self.waybill_amounts:
                if k:
                    k.validate()
        self.validate_required(self.waybill_upload_status, 'waybill_upload_status')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.bill_amount is not None:
            result['bill_amount'] = self.bill_amount
        if self.bill_code is not None:
            result['bill_code'] = self.bill_code
        if self.bill_create_time is not None:
            result['bill_create_time'] = self.bill_create_time
        if self.bill_deadline is not None:
            result['bill_deadline'] = self.bill_deadline
        if self.bill_payer_did is not None:
            result['bill_payer_did'] = self.bill_payer_did
        result['cargo_amounts'] = []
        if self.cargo_amounts is not None:
            for k in self.cargo_amounts:
                result['cargo_amounts'].append(k.to_map() if k else None)
        if self.currency is not None:
            result['currency'] = self.currency
        if self.deadline is not None:
            result['deadline'] = self.deadline
        result['pay_amounts'] = []
        if self.pay_amounts is not None:
            for k in self.pay_amounts:
                result['pay_amounts'].append(k.to_map() if k else None)
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.pre_consignor_pay_date is not None:
            result['pre_consignor_pay_date'] = self.pre_consignor_pay_date
        result['waybill_amounts'] = []
        if self.waybill_amounts is not None:
            for k in self.waybill_amounts:
                result['waybill_amounts'].append(k.to_map() if k else None)
        if self.waybill_upload_status is not None:
            result['waybill_upload_status'] = self.waybill_upload_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('bill_amount') is not None:
            self.bill_amount = m.get('bill_amount')
        if m.get('bill_code') is not None:
            self.bill_code = m.get('bill_code')
        if m.get('bill_create_time') is not None:
            self.bill_create_time = m.get('bill_create_time')
        if m.get('bill_deadline') is not None:
            self.bill_deadline = m.get('bill_deadline')
        if m.get('bill_payer_did') is not None:
            self.bill_payer_did = m.get('bill_payer_did')
        self.cargo_amounts = []
        if m.get('cargo_amounts') is not None:
            for k in m.get('cargo_amounts'):
                temp_model = CargoAmount()
                self.cargo_amounts.append(temp_model.from_map(k))
        if m.get('currency') is not None:
            self.currency = m.get('currency')
        if m.get('deadline') is not None:
            self.deadline = m.get('deadline')
        self.pay_amounts = []
        if m.get('pay_amounts') is not None:
            for k in m.get('pay_amounts'):
                temp_model = PayAmount()
                self.pay_amounts.append(temp_model.from_map(k))
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('pre_consignor_pay_date') is not None:
            self.pre_consignor_pay_date = m.get('pre_consignor_pay_date')
        self.waybill_amounts = []
        if m.get('waybill_amounts') is not None:
            for k in m.get('waybill_amounts'):
                temp_model = WaybillAmount()
                self.waybill_amounts.append(temp_model.from_map(k))
        if m.get('waybill_upload_status') is not None:
            self.waybill_upload_status = m.get('waybill_upload_status')
        return self


class UpdateCargowaybillBillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class CreateDisDidRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cert_no: str = None,
        ep_cert_name: str = None,
        ep_cert_no: str = None,
        extension_info: str = None,
        legal_person_cert_name: str = None,
        legal_person_cert_no: str = None,
        mobile: str = None,
        name: str = None,
        organization_type: str = None,
        platform_did: str = None,
        role_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 个人身份证号。当组织类型为个人时，此字段为必填项
        self.cert_no = cert_no
        # 企业名称。当组织类型为企业时，此字段为必填项
        self.ep_cert_name = ep_cert_name
        # 企业信用号码。当组织类型为企业时，此字段为必填项
        self.ep_cert_no = ep_cert_no
        # 扩展字段
        self.extension_info = extension_info
        # 企业法人姓名。当申请企业类型网络货运平台或者子平台时，此字段为必填项
        self.legal_person_cert_name = legal_person_cert_name
        # 企业法人身份证号码。当申请企业类型网络货运平台或者子平台时，此字段为必填项
        self.legal_person_cert_no = legal_person_cert_no
        # 个人手机号码。当组织类型为个人时，此字段为必填项
        self.mobile = mobile
        # 个人姓名。当组织类型为个人时，此字段为必填项
        self.name = name
        # 组织类型。企业或者个人，二选一填入
        self.organization_type = organization_type
        # 所属平台did。如果为空时，表示创建根平台，允许申请网络货运平台或者3pl角色。创建除根平台外的其他身份时，所属平台did必须填写。
        self.platform_did = platform_did
        # 角色类型。
        # 当组织类型为个人时，可填角色：货主、司机、承运商；
        # 当组织类型为企业时，可填角色：网络货运平台、道路运输企业/3pl、货主、子平台、承运商、托盘方
        self.role_type = role_type

    def validate(self):
        self.validate_required(self.organization_type, 'organization_type')
        self.validate_required(self.role_type, 'role_type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.ep_cert_name is not None:
            result['ep_cert_name'] = self.ep_cert_name
        if self.ep_cert_no is not None:
            result['ep_cert_no'] = self.ep_cert_no
        if self.extension_info is not None:
            result['extension_info'] = self.extension_info
        if self.legal_person_cert_name is not None:
            result['legal_person_cert_name'] = self.legal_person_cert_name
        if self.legal_person_cert_no is not None:
            result['legal_person_cert_no'] = self.legal_person_cert_no
        if self.mobile is not None:
            result['mobile'] = self.mobile
        if self.name is not None:
            result['name'] = self.name
        if self.organization_type is not None:
            result['organization_type'] = self.organization_type
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.role_type is not None:
            result['role_type'] = self.role_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('ep_cert_name') is not None:
            self.ep_cert_name = m.get('ep_cert_name')
        if m.get('ep_cert_no') is not None:
            self.ep_cert_no = m.get('ep_cert_no')
        if m.get('extension_info') is not None:
            self.extension_info = m.get('extension_info')
        if m.get('legal_person_cert_name') is not None:
            self.legal_person_cert_name = m.get('legal_person_cert_name')
        if m.get('legal_person_cert_no') is not None:
            self.legal_person_cert_no = m.get('legal_person_cert_no')
        if m.get('mobile') is not None:
            self.mobile = m.get('mobile')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('organization_type') is not None:
            self.organization_type = m.get('organization_type')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('role_type') is not None:
            self.role_type = m.get('role_type')
        return self


class CreateDisDidResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        did: str = None,
        organization_type: str = None,
        role_types: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 分布式数字身份did
        self.did = did
        # 组织类型
        self.organization_type = organization_type
        # 现阶段此did下的所有授予的角色
        self.role_types = role_types

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.did is not None:
            result['did'] = self.did
        if self.organization_type is not None:
            result['organization_type'] = self.organization_type
        if self.role_types is not None:
            result['role_types'] = self.role_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('did') is not None:
            self.did = m.get('did')
        if m.get('organization_type') is not None:
            self.organization_type = m.get('organization_type')
        if m.get('role_types') is not None:
            self.role_types = m.get('role_types')
        return self


class UploadTransportContractRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        party_adid: str = None,
        contract_effective_date: str = None,
        contract_expires_date: str = None,
        file_infos: List[UploadFileInfo] = None,
        party_bdid: str = None,
        transport_contract_code: str = None,
        platform_did: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 合同甲方did，一般为合同甲方的链上数字身份
        self.party_adid = party_adid
        # 运输合同生效日期，格式要求yyyy-MM-dd
        self.contract_effective_date = contract_effective_date
        # 运输合同到期日期，要求格式yyyy-MM-dd
        self.contract_expires_date = contract_expires_date
        # 影像件文件信息列表，可以包含多个文件，每个文件需要有文件id和文件hash  (请求蚂蚁影像上传接口获取的文件id和文件hash)。影像文件格式要求：bmp,jpg,jpeg,gif,psd,png,tiff,tga,eps,pdf
        self.file_infos = file_infos
        # 合同乙方Did，一般为合同乙方的链上数字身份
        self.party_bdid = party_bdid
        # 运输合同编号
        self.transport_contract_code = transport_contract_code
        # 所属平台did
        self.platform_did = platform_did

    def validate(self):
        self.validate_required(self.party_adid, 'party_adid')
        self.validate_required(self.contract_effective_date, 'contract_effective_date')
        self.validate_required(self.contract_expires_date, 'contract_expires_date')
        self.validate_required(self.file_infos, 'file_infos')
        if self.file_infos:
            for k in self.file_infos:
                if k:
                    k.validate()
        self.validate_required(self.party_bdid, 'party_bdid')
        self.validate_required(self.transport_contract_code, 'transport_contract_code')
        self.validate_required(self.platform_did, 'platform_did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.party_adid is not None:
            result['party_a_did'] = self.party_adid
        if self.contract_effective_date is not None:
            result['contract_effective_date'] = self.contract_effective_date
        if self.contract_expires_date is not None:
            result['contract_expires_date'] = self.contract_expires_date
        result['file_infos'] = []
        if self.file_infos is not None:
            for k in self.file_infos:
                result['file_infos'].append(k.to_map() if k else None)
        if self.party_bdid is not None:
            result['party_b_did'] = self.party_bdid
        if self.transport_contract_code is not None:
            result['transport_contract_code'] = self.transport_contract_code
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('party_a_did') is not None:
            self.party_adid = m.get('party_a_did')
        if m.get('contract_effective_date') is not None:
            self.contract_effective_date = m.get('contract_effective_date')
        if m.get('contract_expires_date') is not None:
            self.contract_expires_date = m.get('contract_expires_date')
        self.file_infos = []
        if m.get('file_infos') is not None:
            for k in m.get('file_infos'):
                temp_model = UploadFileInfo()
                self.file_infos.append(temp_model.from_map(k))
        if m.get('party_b_did') is not None:
            self.party_bdid = m.get('party_b_did')
        if m.get('transport_contract_code') is not None:
            self.transport_contract_code = m.get('transport_contract_code')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        return self


class UploadTransportContractResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class UploadTransportRouteRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        end_address: str = None,
        end_detailed_address: str = None,
        start_address: str = None,
        start_detailed_address: str = None,
        third_party_logistics_did: str = None,
        transport_contract_code: str = None,
        transport_route_code: str = None,
        route_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 目的地省市区，要求格式 XX省-XX市-XX区，比如四川省-成都市-青白江区。当线路类型为STOCK_IN（即入库物流）时，此字段必填
        self.end_address = end_address
        # 目的地详细地址，街道村社区道路楼宇门牌号。当线路类型为STOCK_IN（即入库物流）时，此字段必填
        self.end_detailed_address = end_detailed_address
        # 起始地省市区，要求格式 XX省-XX市-XX区。比如浙江省-杭州市-余杭区。当线路类型为STOCK_OUT（即出库物流）时，此字段必填
        self.start_address = start_address
        # 起始地详细地址，街道村社区道路楼宇门牌号。当线路类型为STOCK_OUT（即出库物流）时，此字段必填
        self.start_detailed_address = start_detailed_address
        # 3plDid
        self.third_party_logistics_did = third_party_logistics_did
        # 运输合同编号
        self.transport_contract_code = transport_contract_code
        # 运输线路编码
        self.transport_route_code = transport_route_code
        # 线路类型，以下二选一填写（可填STOCK_OUT、STOCK_IN）。注：以上分别表示出库物流、入库物流
        self.route_type = route_type

    def validate(self):
        self.validate_required(self.third_party_logistics_did, 'third_party_logistics_did')
        self.validate_required(self.transport_contract_code, 'transport_contract_code')
        self.validate_required(self.transport_route_code, 'transport_route_code')
        self.validate_required(self.route_type, 'route_type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.end_address is not None:
            result['end_address'] = self.end_address
        if self.end_detailed_address is not None:
            result['end_detailed_address'] = self.end_detailed_address
        if self.start_address is not None:
            result['start_address'] = self.start_address
        if self.start_detailed_address is not None:
            result['start_detailed_address'] = self.start_detailed_address
        if self.third_party_logistics_did is not None:
            result['third_party_logistics_did'] = self.third_party_logistics_did
        if self.transport_contract_code is not None:
            result['transport_contract_code'] = self.transport_contract_code
        if self.transport_route_code is not None:
            result['transport_route_code'] = self.transport_route_code
        if self.route_type is not None:
            result['route_type'] = self.route_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('end_address') is not None:
            self.end_address = m.get('end_address')
        if m.get('end_detailed_address') is not None:
            self.end_detailed_address = m.get('end_detailed_address')
        if m.get('start_address') is not None:
            self.start_address = m.get('start_address')
        if m.get('start_detailed_address') is not None:
            self.start_detailed_address = m.get('start_detailed_address')
        if m.get('third_party_logistics_did') is not None:
            self.third_party_logistics_did = m.get('third_party_logistics_did')
        if m.get('transport_contract_code') is not None:
            self.transport_contract_code = m.get('transport_contract_code')
        if m.get('transport_route_code') is not None:
            self.transport_route_code = m.get('transport_route_code')
        if m.get('route_type') is not None:
            self.route_type = m.get('route_type')
        return self


class UploadTransportRouteResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class CreateTransportWaybillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        all_freight: str = None,
        cargo_name: str = None,
        cargo_volume: str = None,
        cargo_weight: str = None,
        carrier_did: str = None,
        car_badge_color: str = None,
        car_badge_no: str = None,
        consignor_did: str = None,
        create_time: int = None,
        driver_did: str = None,
        end_address: str = None,
        end_detailed_address: str = None,
        goods_amount: int = None,
        goods_amount_type: str = None,
        start_address: str = None,
        start_detailed_address: str = None,
        tax_waybill_id: str = None,
        third_party_logistics_did: str = None,
        transport_contract_code: str = None,
        transport_route_code: str = None,
        pallet_did: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 运费，3pl支付给下承运商的运费金额，单位（元），要求格式为不超过二位小数
        self.all_freight = all_freight
        # 货物名称
        self.cargo_name = cargo_name
        # 货物体积，单位（方）。货物重量、货物体积二选一填写
        self.cargo_volume = cargo_volume
        # 货物重量，单位（吨）。货物重量、货物体积二选一填写
        self.cargo_weight = cargo_weight
        # 下游承运商did，一般为下一级承运商数字身份
        self.carrier_did = carrier_did
        # 车牌颜色，需填写黄色、蓝色、绿色中的一种
        self.car_badge_color = car_badge_color
        # 车牌号，承运车牌号
        self.car_badge_no = car_badge_no
        # 货主did，一般为合同甲方的链上数字身份
        self.consignor_did = consignor_did
        # 创建时间，13位毫秒级时间戳
        self.create_time = create_time
        # 实际承运司机did，实际承运司机的链上数字身份
        self.driver_did = driver_did
        # 目的地省市区，要求格式 XX省-XX市-XX区，比如四川省-成都市-青白江区
        self.end_address = end_address
        # 目的地详细地址，街道村社区道路楼宇门牌号
        self.end_detailed_address = end_detailed_address
        # 货物数量
        self.goods_amount = goods_amount
        # 货物数量单位类型
        self.goods_amount_type = goods_amount_type
        # 起始地省市区，要求格式 XX省-XX市-XX区。比如浙江省-杭州市-余杭区
        self.start_address = start_address
        # 起始地详细地址，街道村社区道路楼宇门牌号
        self.start_detailed_address = start_detailed_address
        # 客户系统内运单编号
        self.tax_waybill_id = tax_waybill_id
        # 3plDid，一般为合同乙方的链上数字身份
        self.third_party_logistics_did = third_party_logistics_did
        # 所属合同编号
        self.transport_contract_code = transport_contract_code
        # 所属运输线路编码
        self.transport_route_code = transport_route_code
        # 托盘方did
        self.pallet_did = pallet_did

    def validate(self):
        self.validate_required(self.all_freight, 'all_freight')
        self.validate_required(self.cargo_name, 'cargo_name')
        self.validate_required(self.carrier_did, 'carrier_did')
        self.validate_required(self.car_badge_color, 'car_badge_color')
        self.validate_required(self.car_badge_no, 'car_badge_no')
        self.validate_required(self.consignor_did, 'consignor_did')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.driver_did, 'driver_did')
        self.validate_required(self.end_address, 'end_address')
        self.validate_required(self.end_detailed_address, 'end_detailed_address')
        self.validate_required(self.start_address, 'start_address')
        self.validate_required(self.start_detailed_address, 'start_detailed_address')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')
        self.validate_required(self.third_party_logistics_did, 'third_party_logistics_did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.all_freight is not None:
            result['all_freight'] = self.all_freight
        if self.cargo_name is not None:
            result['cargo_name'] = self.cargo_name
        if self.cargo_volume is not None:
            result['cargo_volume'] = self.cargo_volume
        if self.cargo_weight is not None:
            result['cargo_weight'] = self.cargo_weight
        if self.carrier_did is not None:
            result['carrier_did'] = self.carrier_did
        if self.car_badge_color is not None:
            result['car_badge_color'] = self.car_badge_color
        if self.car_badge_no is not None:
            result['car_badge_no'] = self.car_badge_no
        if self.consignor_did is not None:
            result['consignor_did'] = self.consignor_did
        if self.create_time is not None:
            result['create_time'] = self.create_time
        if self.driver_did is not None:
            result['driver_did'] = self.driver_did
        if self.end_address is not None:
            result['end_address'] = self.end_address
        if self.end_detailed_address is not None:
            result['end_detailed_address'] = self.end_detailed_address
        if self.goods_amount is not None:
            result['goods_amount'] = self.goods_amount
        if self.goods_amount_type is not None:
            result['goods_amount_type'] = self.goods_amount_type
        if self.start_address is not None:
            result['start_address'] = self.start_address
        if self.start_detailed_address is not None:
            result['start_detailed_address'] = self.start_detailed_address
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        if self.third_party_logistics_did is not None:
            result['third_party_logistics_did'] = self.third_party_logistics_did
        if self.transport_contract_code is not None:
            result['transport_contract_code'] = self.transport_contract_code
        if self.transport_route_code is not None:
            result['transport_route_code'] = self.transport_route_code
        if self.pallet_did is not None:
            result['pallet_did'] = self.pallet_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('all_freight') is not None:
            self.all_freight = m.get('all_freight')
        if m.get('cargo_name') is not None:
            self.cargo_name = m.get('cargo_name')
        if m.get('cargo_volume') is not None:
            self.cargo_volume = m.get('cargo_volume')
        if m.get('cargo_weight') is not None:
            self.cargo_weight = m.get('cargo_weight')
        if m.get('carrier_did') is not None:
            self.carrier_did = m.get('carrier_did')
        if m.get('car_badge_color') is not None:
            self.car_badge_color = m.get('car_badge_color')
        if m.get('car_badge_no') is not None:
            self.car_badge_no = m.get('car_badge_no')
        if m.get('consignor_did') is not None:
            self.consignor_did = m.get('consignor_did')
        if m.get('create_time') is not None:
            self.create_time = m.get('create_time')
        if m.get('driver_did') is not None:
            self.driver_did = m.get('driver_did')
        if m.get('end_address') is not None:
            self.end_address = m.get('end_address')
        if m.get('end_detailed_address') is not None:
            self.end_detailed_address = m.get('end_detailed_address')
        if m.get('goods_amount') is not None:
            self.goods_amount = m.get('goods_amount')
        if m.get('goods_amount_type') is not None:
            self.goods_amount_type = m.get('goods_amount_type')
        if m.get('start_address') is not None:
            self.start_address = m.get('start_address')
        if m.get('start_detailed_address') is not None:
            self.start_detailed_address = m.get('start_detailed_address')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        if m.get('third_party_logistics_did') is not None:
            self.third_party_logistics_did = m.get('third_party_logistics_did')
        if m.get('transport_contract_code') is not None:
            self.transport_contract_code = m.get('transport_contract_code')
        if m.get('transport_route_code') is not None:
            self.transport_route_code = m.get('transport_route_code')
        if m.get('pallet_did') is not None:
            self.pallet_did = m.get('pallet_did')
        return self


class CreateTransportWaybillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class UpdateWaybillActionRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        operate_action: str = None,
        operate_action_time: int = None,
        tax_waybill_id: str = None,
        third_party_logistics_did: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 操作类型，以下二选一填写：运单起运、运输完成
        self.operate_action = operate_action
        # 运单起运或运输完成的时间，要求为13位毫秒级时间戳
        self.operate_action_time = operate_action_time
        # 客户系统内运单编号
        self.tax_waybill_id = tax_waybill_id
        # 3plDid，一般为合同乙方的链上数字身份
        self.third_party_logistics_did = third_party_logistics_did

    def validate(self):
        self.validate_required(self.operate_action, 'operate_action')
        self.validate_required(self.operate_action_time, 'operate_action_time')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')
        self.validate_required(self.third_party_logistics_did, 'third_party_logistics_did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.operate_action is not None:
            result['operate_action'] = self.operate_action
        if self.operate_action_time is not None:
            result['operate_action_time'] = self.operate_action_time
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        if self.third_party_logistics_did is not None:
            result['third_party_logistics_did'] = self.third_party_logistics_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('operate_action') is not None:
            self.operate_action = m.get('operate_action')
        if m.get('operate_action_time') is not None:
            self.operate_action_time = m.get('operate_action_time')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        if m.get('third_party_logistics_did') is not None:
            self.third_party_logistics_did = m.get('third_party_logistics_did')
        return self


class UpdateWaybillActionResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class UpdateTransportWaybillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        all_freight: str = None,
        cargo_name: str = None,
        cargo_volume: str = None,
        cargo_weight: str = None,
        carrier_did: str = None,
        car_badge_color: str = None,
        car_badge_no: str = None,
        consignor_did: str = None,
        create_time: int = None,
        driver_did: str = None,
        end_address: str = None,
        end_detailed_address: str = None,
        end_time: int = None,
        goods_amount: int = None,
        goods_amount_type: str = None,
        start_address: str = None,
        start_detailed_address: str = None,
        start_time: int = None,
        tax_waybill_id: str = None,
        third_party_logistics_did: str = None,
        transport_contract_code: str = None,
        transport_route_code: str = None,
        pallet_did: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 运费，3pl支付给下承运商的运费金额，单位（元），要求格式为不超过二位小数
        self.all_freight = all_freight
        # 货物名称
        self.cargo_name = cargo_name
        # 单位（方），货物体积
        self.cargo_volume = cargo_volume
        # 单位（吨），货物重量
        self.cargo_weight = cargo_weight
        # 下游承运商did，一般为下一级承运商数字身份
        self.carrier_did = carrier_did
        # 车牌颜色，需填写黄色、蓝色、绿色中的一种
        self.car_badge_color = car_badge_color
        # 车牌号，承运车牌号
        self.car_badge_no = car_badge_no
        # 货主did，一般为合同甲方的链上数字身份
        self.consignor_did = consignor_did
        # 创建时间，13位毫秒级时间戳
        self.create_time = create_time
        # 实际承运司机did，实际承运司机的链上数字身份
        self.driver_did = driver_did
        # 目的地省市区，要求格式 XX省-XX市-XX区，比如四川省-成都市-青白江区
        self.end_address = end_address
        # 目的地详细地址，街道村社区道路楼宇门牌号
        self.end_detailed_address = end_detailed_address
        # 到达时间，13位毫秒级时间戳
        self.end_time = end_time
        # 货物数量
        self.goods_amount = goods_amount
        # 货物数量单位类型
        self.goods_amount_type = goods_amount_type
        # 起始地省市区，要求格式 XX省-XX市-XX区。比如浙江省-杭州市-余杭区
        self.start_address = start_address
        # 起始地详细地址，街道村社区道路楼宇门牌号
        self.start_detailed_address = start_detailed_address
        # 起运时间，13位毫秒级时间戳
        self.start_time = start_time
        # 客户系统内运单编号
        self.tax_waybill_id = tax_waybill_id
        # 3plDid，一般为合同乙方的链上数字身份
        self.third_party_logistics_did = third_party_logistics_did
        # 所属合同编号
        self.transport_contract_code = transport_contract_code
        # 所属运输线路编码
        self.transport_route_code = transport_route_code
        # 托盘方did
        self.pallet_did = pallet_did

    def validate(self):
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')
        self.validate_required(self.third_party_logistics_did, 'third_party_logistics_did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.all_freight is not None:
            result['all_freight'] = self.all_freight
        if self.cargo_name is not None:
            result['cargo_name'] = self.cargo_name
        if self.cargo_volume is not None:
            result['cargo_volume'] = self.cargo_volume
        if self.cargo_weight is not None:
            result['cargo_weight'] = self.cargo_weight
        if self.carrier_did is not None:
            result['carrier_did'] = self.carrier_did
        if self.car_badge_color is not None:
            result['car_badge_color'] = self.car_badge_color
        if self.car_badge_no is not None:
            result['car_badge_no'] = self.car_badge_no
        if self.consignor_did is not None:
            result['consignor_did'] = self.consignor_did
        if self.create_time is not None:
            result['create_time'] = self.create_time
        if self.driver_did is not None:
            result['driver_did'] = self.driver_did
        if self.end_address is not None:
            result['end_address'] = self.end_address
        if self.end_detailed_address is not None:
            result['end_detailed_address'] = self.end_detailed_address
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.goods_amount is not None:
            result['goods_amount'] = self.goods_amount
        if self.goods_amount_type is not None:
            result['goods_amount_type'] = self.goods_amount_type
        if self.start_address is not None:
            result['start_address'] = self.start_address
        if self.start_detailed_address is not None:
            result['start_detailed_address'] = self.start_detailed_address
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        if self.third_party_logistics_did is not None:
            result['third_party_logistics_did'] = self.third_party_logistics_did
        if self.transport_contract_code is not None:
            result['transport_contract_code'] = self.transport_contract_code
        if self.transport_route_code is not None:
            result['transport_route_code'] = self.transport_route_code
        if self.pallet_did is not None:
            result['pallet_did'] = self.pallet_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('all_freight') is not None:
            self.all_freight = m.get('all_freight')
        if m.get('cargo_name') is not None:
            self.cargo_name = m.get('cargo_name')
        if m.get('cargo_volume') is not None:
            self.cargo_volume = m.get('cargo_volume')
        if m.get('cargo_weight') is not None:
            self.cargo_weight = m.get('cargo_weight')
        if m.get('carrier_did') is not None:
            self.carrier_did = m.get('carrier_did')
        if m.get('car_badge_color') is not None:
            self.car_badge_color = m.get('car_badge_color')
        if m.get('car_badge_no') is not None:
            self.car_badge_no = m.get('car_badge_no')
        if m.get('consignor_did') is not None:
            self.consignor_did = m.get('consignor_did')
        if m.get('create_time') is not None:
            self.create_time = m.get('create_time')
        if m.get('driver_did') is not None:
            self.driver_did = m.get('driver_did')
        if m.get('end_address') is not None:
            self.end_address = m.get('end_address')
        if m.get('end_detailed_address') is not None:
            self.end_detailed_address = m.get('end_detailed_address')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('goods_amount') is not None:
            self.goods_amount = m.get('goods_amount')
        if m.get('goods_amount_type') is not None:
            self.goods_amount_type = m.get('goods_amount_type')
        if m.get('start_address') is not None:
            self.start_address = m.get('start_address')
        if m.get('start_detailed_address') is not None:
            self.start_detailed_address = m.get('start_detailed_address')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        if m.get('third_party_logistics_did') is not None:
            self.third_party_logistics_did = m.get('third_party_logistics_did')
        if m.get('transport_contract_code') is not None:
            self.transport_contract_code = m.get('transport_contract_code')
        if m.get('transport_route_code') is not None:
            self.transport_route_code = m.get('transport_route_code')
        if m.get('pallet_did') is not None:
            self.pallet_did = m.get('pallet_did')
        return self


class UpdateTransportWaybillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class UploadTransportReceiptRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        consignor_did: str = None,
        file_info: UploadFileInfo = None,
        receipt_id: str = None,
        tax_waybill_id: str = None,
        third_party_logistics_did: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 货主did，一般为合同甲方的链上数字身份
        self.consignor_did = consignor_did
        # 请求蚂蚁影像上传接口上传文件获取的文件id和文件hash信息。影像文件格式：bmp,jpg,jpeg,gif,psd,png,tiff,tga,eps,pdf
        self.file_info = file_info
        # 回单id，客户编辑的唯一回单编码
        self.receipt_id = receipt_id
        # 客户系统内运单编号
        self.tax_waybill_id = tax_waybill_id
        # 3plDid，一般为合同乙方的链上数字身份
        self.third_party_logistics_did = third_party_logistics_did

    def validate(self):
        self.validate_required(self.consignor_did, 'consignor_did')
        self.validate_required(self.file_info, 'file_info')
        if self.file_info:
            self.file_info.validate()
        self.validate_required(self.receipt_id, 'receipt_id')
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')
        self.validate_required(self.third_party_logistics_did, 'third_party_logistics_did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.consignor_did is not None:
            result['consignor_did'] = self.consignor_did
        if self.file_info is not None:
            result['file_info'] = self.file_info.to_map()
        if self.receipt_id is not None:
            result['receipt_id'] = self.receipt_id
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        if self.third_party_logistics_did is not None:
            result['third_party_logistics_did'] = self.third_party_logistics_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('consignor_did') is not None:
            self.consignor_did = m.get('consignor_did')
        if m.get('file_info') is not None:
            temp_model = UploadFileInfo()
            self.file_info = temp_model.from_map(m['file_info'])
        if m.get('receipt_id') is not None:
            self.receipt_id = m.get('receipt_id')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        if m.get('third_party_logistics_did') is not None:
            self.third_party_logistics_did = m.get('third_party_logistics_did')
        return self


class UploadTransportReceiptResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class CreateBillReceivablebillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        bill_amount: str = None,
        bill_create_time: int = None,
        bill_deadline: int = None,
        bill_id: str = None,
        bill_payee_did: str = None,
        bill_payer_did: str = None,
        bill_start_time: int = None,
        contract_code: str = None,
        deadline: int = None,
        waybill_ids: List[str] = None,
        platform_did: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 账单总金额，单位（元），周期内应向发货方收取的运费总金额，不超过2位小数的数字
        self.bill_amount = bill_amount
        # 账单生成时间，13位毫秒级时间戳
        self.bill_create_time = bill_create_time
        # 账单期限，单位（天），合同约定的结算周期，需填写1到360的整数
        self.bill_deadline = bill_deadline
        # 账单id，客户生成的账单唯一编号
        self.bill_id = bill_id
        # 收款方did，账单的收款方数字身份
        self.bill_payee_did = bill_payee_did
        # 付款方did，账单的付款方数字身份
        self.bill_payer_did = bill_payer_did
        # 账单起始日期，13位毫秒级时间戳
        self.bill_start_time = bill_start_time
        # 关联合同编号，账单关联的合同编号，如为合同物流请填写
        # 
        self.contract_code = contract_code
        # 账单到期日期，13位毫秒级时间戳
        self.deadline = deadline
        # 账单关联运单号数组，元素个数不能超过1000个
        self.waybill_ids = waybill_ids
        # 所属平台did
        self.platform_did = platform_did

    def validate(self):
        self.validate_required(self.bill_amount, 'bill_amount')
        self.validate_required(self.bill_create_time, 'bill_create_time')
        self.validate_required(self.bill_deadline, 'bill_deadline')
        self.validate_required(self.bill_id, 'bill_id')
        self.validate_required(self.bill_payee_did, 'bill_payee_did')
        self.validate_required(self.bill_payer_did, 'bill_payer_did')
        self.validate_required(self.bill_start_time, 'bill_start_time')
        self.validate_required(self.deadline, 'deadline')
        self.validate_required(self.waybill_ids, 'waybill_ids')
        self.validate_required(self.platform_did, 'platform_did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.bill_amount is not None:
            result['bill_amount'] = self.bill_amount
        if self.bill_create_time is not None:
            result['bill_create_time'] = self.bill_create_time
        if self.bill_deadline is not None:
            result['bill_deadline'] = self.bill_deadline
        if self.bill_id is not None:
            result['bill_id'] = self.bill_id
        if self.bill_payee_did is not None:
            result['bill_payee_did'] = self.bill_payee_did
        if self.bill_payer_did is not None:
            result['bill_payer_did'] = self.bill_payer_did
        if self.bill_start_time is not None:
            result['bill_start_time'] = self.bill_start_time
        if self.contract_code is not None:
            result['contract_code'] = self.contract_code
        if self.deadline is not None:
            result['deadline'] = self.deadline
        if self.waybill_ids is not None:
            result['waybill_ids'] = self.waybill_ids
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('bill_amount') is not None:
            self.bill_amount = m.get('bill_amount')
        if m.get('bill_create_time') is not None:
            self.bill_create_time = m.get('bill_create_time')
        if m.get('bill_deadline') is not None:
            self.bill_deadline = m.get('bill_deadline')
        if m.get('bill_id') is not None:
            self.bill_id = m.get('bill_id')
        if m.get('bill_payee_did') is not None:
            self.bill_payee_did = m.get('bill_payee_did')
        if m.get('bill_payer_did') is not None:
            self.bill_payer_did = m.get('bill_payer_did')
        if m.get('bill_start_time') is not None:
            self.bill_start_time = m.get('bill_start_time')
        if m.get('contract_code') is not None:
            self.contract_code = m.get('contract_code')
        if m.get('deadline') is not None:
            self.deadline = m.get('deadline')
        if m.get('waybill_ids') is not None:
            self.waybill_ids = m.get('waybill_ids')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        return self


class CreateBillReceivablebillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class UpdateReceivablebillStatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        bill_id: str = None,
        bill_payee_did: str = None,
        update_status: str = None,
        update_status_time: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 账单id，客户生成的账单唯一编号
        self.bill_id = bill_id
        # 收款方did，账单的收款方数字身份
        self.bill_payee_did = bill_payee_did
        # 账单后续所可能产生的状态，以下三选一填写：账单确认、部分结算、已结清
        # 
        # 
        self.update_status = update_status
        # 更新状态时间，13位毫秒级时间戳
        self.update_status_time = update_status_time

    def validate(self):
        self.validate_required(self.bill_id, 'bill_id')
        self.validate_required(self.bill_payee_did, 'bill_payee_did')
        self.validate_required(self.update_status, 'update_status')
        self.validate_required(self.update_status_time, 'update_status_time')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.bill_id is not None:
            result['bill_id'] = self.bill_id
        if self.bill_payee_did is not None:
            result['bill_payee_did'] = self.bill_payee_did
        if self.update_status is not None:
            result['update_status'] = self.update_status
        if self.update_status_time is not None:
            result['update_status_time'] = self.update_status_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('bill_id') is not None:
            self.bill_id = m.get('bill_id')
        if m.get('bill_payee_did') is not None:
            self.bill_payee_did = m.get('bill_payee_did')
        if m.get('update_status') is not None:
            self.update_status = m.get('update_status')
        if m.get('update_status_time') is not None:
            self.update_status_time = m.get('update_status_time')
        return self


class UpdateReceivablebillStatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class UpdateBillReceivablebillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        bill_amount: str = None,
        bill_create_time: int = None,
        bill_deadline: int = None,
        bill_id: str = None,
        bill_payee_did: str = None,
        bill_payer_did: str = None,
        bill_start_time: int = None,
        contract_code: str = None,
        deadline: int = None,
        waybill_ids: List[str] = None,
        platform_did: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 账单总金额，单位（元），周期内应向发货方收取的运费总金额，不超过2位小数的数字
        self.bill_amount = bill_amount
        # 账单生成时间，13位毫秒级时间戳
        self.bill_create_time = bill_create_time
        # 账单期限，单位（天），合同约定的结算周期，需填写1到360的整数
        self.bill_deadline = bill_deadline
        # 账单id，客户生成的账单唯一编号
        self.bill_id = bill_id
        # 收款方did，账单的收款方数字身份
        self.bill_payee_did = bill_payee_did
        # 付款方did，账单的付款方数字身份
        self.bill_payer_did = bill_payer_did
        # 账单起始日期，13位毫秒级时间戳
        self.bill_start_time = bill_start_time
        # 关联合同编号，账单关联的合同编号，如为合同物流请填写
        self.contract_code = contract_code
        # 账单到期日期，13位毫秒级时间戳
        self.deadline = deadline
        # 账单关联运单号数组，元素个数不能超过1000个
        self.waybill_ids = waybill_ids
        # 所属平台did
        self.platform_did = platform_did

    def validate(self):
        self.validate_required(self.bill_id, 'bill_id')
        self.validate_required(self.bill_payee_did, 'bill_payee_did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.bill_amount is not None:
            result['bill_amount'] = self.bill_amount
        if self.bill_create_time is not None:
            result['bill_create_time'] = self.bill_create_time
        if self.bill_deadline is not None:
            result['bill_deadline'] = self.bill_deadline
        if self.bill_id is not None:
            result['bill_id'] = self.bill_id
        if self.bill_payee_did is not None:
            result['bill_payee_did'] = self.bill_payee_did
        if self.bill_payer_did is not None:
            result['bill_payer_did'] = self.bill_payer_did
        if self.bill_start_time is not None:
            result['bill_start_time'] = self.bill_start_time
        if self.contract_code is not None:
            result['contract_code'] = self.contract_code
        if self.deadline is not None:
            result['deadline'] = self.deadline
        if self.waybill_ids is not None:
            result['waybill_ids'] = self.waybill_ids
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('bill_amount') is not None:
            self.bill_amount = m.get('bill_amount')
        if m.get('bill_create_time') is not None:
            self.bill_create_time = m.get('bill_create_time')
        if m.get('bill_deadline') is not None:
            self.bill_deadline = m.get('bill_deadline')
        if m.get('bill_id') is not None:
            self.bill_id = m.get('bill_id')
        if m.get('bill_payee_did') is not None:
            self.bill_payee_did = m.get('bill_payee_did')
        if m.get('bill_payer_did') is not None:
            self.bill_payer_did = m.get('bill_payer_did')
        if m.get('bill_start_time') is not None:
            self.bill_start_time = m.get('bill_start_time')
        if m.get('contract_code') is not None:
            self.contract_code = m.get('contract_code')
        if m.get('deadline') is not None:
            self.deadline = m.get('deadline')
        if m.get('waybill_ids') is not None:
            self.waybill_ids = m.get('waybill_ids')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        return self


class UpdateBillReceivablebillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class CreateHighwayInvoiceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        invoice_no: str = None,
        invoice_code: str = None,
        verify_code: str = None,
        payee_did: str = None,
        payer_did: str = None,
        invoice_contains_tax: str = None,
        invoice_without_tax: str = None,
        invoice_date: str = None,
        invoice_type: str = None,
        file_id: str = None,
        file_hash: str = None,
        platform_did: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 发票号码，8位发票号码
        self.invoice_no = invoice_no
        # 发票代码，10位或者12位发票代码
        self.invoice_code = invoice_code
        # 发票校验码后6位
        self.verify_code = verify_code
        # 收款方did，出票方，需要出票收钱的
        self.payee_did = payee_did
        # 付款方did，收票方，需要收票付钱的
        self.payer_did = payer_did
        # 发票含税金额， 不超过2位小数的数字
        self.invoice_contains_tax = invoice_contains_tax
        # 发票不含税金额，不超过2位小数的数字
        self.invoice_without_tax = invoice_without_tax
        # 开票日期，格式为yyyy-mm-dd
        self.invoice_date = invoice_date
        # 发票类型，以下二选一填写：应收发票、应付发票
        self.invoice_type = invoice_type
        # 影像件ID，发票上传蚂蚁oss的文件ID。注意：影像件id和影像件hash，必须都填写或都不填，不可只填其中一项
        self.file_id = file_id
        # 影像件hash，上传蚂蚁oss的文件hash。注意：影像件id和影像件hash，必须都填写或都不填，不可只填其中一项
        self.file_hash = file_hash
        # 发票归属平台did，用以区分是哪家平台/企业的发票
        self.platform_did = platform_did
        # 发票种类，以下四选一填写（可填VAT_SPECIAL_INVOICE、VAT_NORMAL_INVOICE、VAT_ROLL_INVOICE、ELECTRONIC_INVOICE）。注：以上分别表示增值税专票、增值税普票、增值税卷票、电子发票
        self.type = type

    def validate(self):
        self.validate_required(self.invoice_no, 'invoice_no')
        self.validate_required(self.invoice_code, 'invoice_code')
        self.validate_required(self.payee_did, 'payee_did')
        self.validate_required(self.payer_did, 'payer_did')
        self.validate_required(self.invoice_contains_tax, 'invoice_contains_tax')
        self.validate_required(self.invoice_without_tax, 'invoice_without_tax')
        self.validate_required(self.invoice_date, 'invoice_date')
        self.validate_required(self.invoice_type, 'invoice_type')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.invoice_no is not None:
            result['invoice_no'] = self.invoice_no
        if self.invoice_code is not None:
            result['invoice_code'] = self.invoice_code
        if self.verify_code is not None:
            result['verify_code'] = self.verify_code
        if self.payee_did is not None:
            result['payee_did'] = self.payee_did
        if self.payer_did is not None:
            result['payer_did'] = self.payer_did
        if self.invoice_contains_tax is not None:
            result['invoice_contains_tax'] = self.invoice_contains_tax
        if self.invoice_without_tax is not None:
            result['invoice_without_tax'] = self.invoice_without_tax
        if self.invoice_date is not None:
            result['invoice_date'] = self.invoice_date
        if self.invoice_type is not None:
            result['invoice_type'] = self.invoice_type
        if self.file_id is not None:
            result['file_id'] = self.file_id
        if self.file_hash is not None:
            result['file_hash'] = self.file_hash
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('invoice_no') is not None:
            self.invoice_no = m.get('invoice_no')
        if m.get('invoice_code') is not None:
            self.invoice_code = m.get('invoice_code')
        if m.get('verify_code') is not None:
            self.verify_code = m.get('verify_code')
        if m.get('payee_did') is not None:
            self.payee_did = m.get('payee_did')
        if m.get('payer_did') is not None:
            self.payer_did = m.get('payer_did')
        if m.get('invoice_contains_tax') is not None:
            self.invoice_contains_tax = m.get('invoice_contains_tax')
        if m.get('invoice_without_tax') is not None:
            self.invoice_without_tax = m.get('invoice_without_tax')
        if m.get('invoice_date') is not None:
            self.invoice_date = m.get('invoice_date')
        if m.get('invoice_type') is not None:
            self.invoice_type = m.get('invoice_type')
        if m.get('file_id') is not None:
            self.file_id = m.get('file_id')
        if m.get('file_hash') is not None:
            self.file_hash = m.get('file_hash')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CreateHighwayInvoiceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class QueryWaybillInfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        tax_waybill_id: str = None,
        did: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 运单id
        self.tax_waybill_id = tax_waybill_id
        # 填写无车承运平台did或者3plDid
        self.did = did

    def validate(self):
        self.validate_required(self.tax_waybill_id, 'tax_waybill_id')
        self.validate_required(self.did, 'did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.tax_waybill_id is not None:
            result['tax_waybill_id'] = self.tax_waybill_id
        if self.did is not None:
            result['did'] = self.did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('tax_waybill_id') is not None:
            self.tax_waybill_id = m.get('tax_waybill_id')
        if m.get('did') is not None:
            self.did = m.get('did')
        return self


class QueryWaybillInfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        waybill: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # json串形式的运单信息
        self.waybill = waybill

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.waybill is not None:
            result['waybill'] = self.waybill
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('waybill') is not None:
            self.waybill = m.get('waybill')
        return self


class CreateBillReceivablebillnodetailRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        bill_amount: str = None,
        bill_create_time: int = None,
        bill_deadline: int = None,
        bill_id: str = None,
        bill_payee_did: str = None,
        bill_payer_did: str = None,
        bill_start_time: int = None,
        contract_code: str = None,
        deadline: int = None,
        platform_did: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 账单总金额，单位（元），周期内应向发货方收取的运费总金额，不超过2位小数的数字
        self.bill_amount = bill_amount
        # 账单生成时间，13位毫秒级时间戳
        self.bill_create_time = bill_create_time
        # 账单期限，单位（天），合同约定的结算周期
        self.bill_deadline = bill_deadline
        # 账单id，客户生成的账单唯一编号
        self.bill_id = bill_id
        # 收款方did，账单的收款方数字身份
        self.bill_payee_did = bill_payee_did
        # 付款方did，账单的付款方数字身份
        self.bill_payer_did = bill_payer_did
        # 账单起始日期，13位毫秒级时间戳
        self.bill_start_time = bill_start_time
        # 关联合同编号，账单关联的合同编号，如为合同物流请填写
        self.contract_code = contract_code
        # 账单到期日期，13位毫秒级时间戳
        self.deadline = deadline
        # 所属平台did
        self.platform_did = platform_did

    def validate(self):
        self.validate_required(self.bill_amount, 'bill_amount')
        self.validate_required(self.bill_create_time, 'bill_create_time')
        self.validate_required(self.bill_deadline, 'bill_deadline')
        self.validate_required(self.bill_id, 'bill_id')
        self.validate_required(self.bill_payee_did, 'bill_payee_did')
        self.validate_required(self.bill_payer_did, 'bill_payer_did')
        self.validate_required(self.bill_start_time, 'bill_start_time')
        self.validate_required(self.deadline, 'deadline')
        self.validate_required(self.platform_did, 'platform_did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.bill_amount is not None:
            result['bill_amount'] = self.bill_amount
        if self.bill_create_time is not None:
            result['bill_create_time'] = self.bill_create_time
        if self.bill_deadline is not None:
            result['bill_deadline'] = self.bill_deadline
        if self.bill_id is not None:
            result['bill_id'] = self.bill_id
        if self.bill_payee_did is not None:
            result['bill_payee_did'] = self.bill_payee_did
        if self.bill_payer_did is not None:
            result['bill_payer_did'] = self.bill_payer_did
        if self.bill_start_time is not None:
            result['bill_start_time'] = self.bill_start_time
        if self.contract_code is not None:
            result['contract_code'] = self.contract_code
        if self.deadline is not None:
            result['deadline'] = self.deadline
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('bill_amount') is not None:
            self.bill_amount = m.get('bill_amount')
        if m.get('bill_create_time') is not None:
            self.bill_create_time = m.get('bill_create_time')
        if m.get('bill_deadline') is not None:
            self.bill_deadline = m.get('bill_deadline')
        if m.get('bill_id') is not None:
            self.bill_id = m.get('bill_id')
        if m.get('bill_payee_did') is not None:
            self.bill_payee_did = m.get('bill_payee_did')
        if m.get('bill_payer_did') is not None:
            self.bill_payer_did = m.get('bill_payer_did')
        if m.get('bill_start_time') is not None:
            self.bill_start_time = m.get('bill_start_time')
        if m.get('contract_code') is not None:
            self.contract_code = m.get('contract_code')
        if m.get('deadline') is not None:
            self.deadline = m.get('deadline')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        return self


class CreateBillReceivablebillnodetailResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_code: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 链上凭证
        self.tx_code = tx_code

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_code is not None:
            result['tx_code'] = self.tx_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_code') is not None:
            self.tx_code = m.get('tx_code')
        return self


class SaveTrailerCorpRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        company_name: str = None,
        social_credit_code: str = None,
        channel_company_name: str = None,
        channel_social_credit_code: str = None,
        entry_date: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 企业名称
        self.company_name = company_name
        # 企业统一社会信用代码
        self.social_credit_code = social_credit_code
        # 渠道企业名称
        self.channel_company_name = channel_company_name
        # 渠道企业信用代码
        self.channel_social_credit_code = channel_social_credit_code
        # 企业入驻渠道日期
        self.entry_date = entry_date

    def validate(self):
        self.validate_required(self.company_name, 'company_name')
        self.validate_required(self.social_credit_code, 'social_credit_code')
        self.validate_required(self.channel_company_name, 'channel_company_name')
        self.validate_required(self.channel_social_credit_code, 'channel_social_credit_code')
        self.validate_required(self.entry_date, 'entry_date')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.company_name is not None:
            result['company_name'] = self.company_name
        if self.social_credit_code is not None:
            result['social_credit_code'] = self.social_credit_code
        if self.channel_company_name is not None:
            result['channel_company_name'] = self.channel_company_name
        if self.channel_social_credit_code is not None:
            result['channel_social_credit_code'] = self.channel_social_credit_code
        if self.entry_date is not None:
            result['entry_date'] = self.entry_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('company_name') is not None:
            self.company_name = m.get('company_name')
        if m.get('social_credit_code') is not None:
            self.social_credit_code = m.get('social_credit_code')
        if m.get('channel_company_name') is not None:
            self.channel_company_name = m.get('channel_company_name')
        if m.get('channel_social_credit_code') is not None:
            self.channel_social_credit_code = m.get('channel_social_credit_code')
        if m.get('entry_date') is not None:
            self.entry_date = m.get('entry_date')
        return self


class SaveTrailerCorpResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回结果
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class SaveTrailerTransportRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        company_name: str = None,
        social_credit_code: str = None,
        transport_month: str = None,
        transport_container_quantity: int = None,
        freight_total_amount: str = None,
        transport_driver_quantity: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 企业名称
        self.company_name = company_name
        # 企业统一社会信用代码
        self.social_credit_code = social_credit_code
        # 运营数据.月份
        self.transport_month = transport_month
        # 运营数据.运输箱量
        self.transport_container_quantity = transport_container_quantity
        # 运营数据.运费总额
        self.freight_total_amount = freight_total_amount
        # 运营数据.运输司机量
        self.transport_driver_quantity = transport_driver_quantity

    def validate(self):
        self.validate_required(self.company_name, 'company_name')
        self.validate_required(self.social_credit_code, 'social_credit_code')
        self.validate_required(self.transport_month, 'transport_month')
        self.validate_required(self.freight_total_amount, 'freight_total_amount')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.company_name is not None:
            result['company_name'] = self.company_name
        if self.social_credit_code is not None:
            result['social_credit_code'] = self.social_credit_code
        if self.transport_month is not None:
            result['transport_month'] = self.transport_month
        if self.transport_container_quantity is not None:
            result['transport_container_quantity'] = self.transport_container_quantity
        if self.freight_total_amount is not None:
            result['freight_total_amount'] = self.freight_total_amount
        if self.transport_driver_quantity is not None:
            result['transport_driver_quantity'] = self.transport_driver_quantity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('company_name') is not None:
            self.company_name = m.get('company_name')
        if m.get('social_credit_code') is not None:
            self.social_credit_code = m.get('social_credit_code')
        if m.get('transport_month') is not None:
            self.transport_month = m.get('transport_month')
        if m.get('transport_container_quantity') is not None:
            self.transport_container_quantity = m.get('transport_container_quantity')
        if m.get('freight_total_amount') is not None:
            self.freight_total_amount = m.get('freight_total_amount')
        if m.get('transport_driver_quantity') is not None:
            self.transport_driver_quantity = m.get('transport_driver_quantity')
        return self


class SaveTrailerTransportResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 上传结果
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class QueryBusinessInstancestatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        instance_tenant: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id
        # 实例对应的租户id
        self.instance_tenant = instance_tenant

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.instance_tenant, 'instance_tenant')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.instance_tenant is not None:
            result['instance_tenant'] = self.instance_tenant
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('instance_tenant') is not None:
            self.instance_tenant = m.get('instance_tenant')
        return self


class QueryBusinessInstancestatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        instance_id: str = None,
        instance_tenant: str = None,
        instance_status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 实例id
        self.instance_id = instance_id
        # 实例对应的租户id
        self.instance_tenant = instance_tenant
        # STARTED---运行中
        # STOPPED--已停服
        # RELEASED--已释放
        self.instance_status = instance_status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.instance_tenant is not None:
            result['instance_tenant'] = self.instance_tenant
        if self.instance_status is not None:
            result['instance_status'] = self.instance_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('instance_tenant') is not None:
            self.instance_tenant = m.get('instance_tenant')
        if m.get('instance_status') is not None:
            self.instance_status = m.get('instance_status')
        return self


class OpenCreditDriverRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        callback_url: str = None,
        driver_did: str = None,
        group_platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 司机云资金商户ID
        self.account_id = account_id
        # 开通结果回调url
        self.callback_url = callback_url
        # 司机分布式数字身份
        self.driver_did = driver_did
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 产品id 目前填写 PRODUCT_MYBANK
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.callback_url, 'callback_url')
        self.validate_required(self.driver_did, 'driver_did')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.driver_did is not None:
            result['driver_did'] = self.driver_did
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('driver_did') is not None:
            self.driver_did = m.get('driver_did')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class OpenCreditDriverResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        apply_id: str = None,
        sign_url: str = None,
        status: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 签署开通申请id
        self.apply_id = apply_id
        # 协议签署开通url
        self.sign_url = sign_url
        # 签署状态
        # -1:签署开通失败, 0:未签署开通, 1:已签署开通
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.sign_url is not None:
            result['sign_url'] = self.sign_url
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('sign_url') is not None:
            self.sign_url = m.get('sign_url')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class QueryCreditDriverRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        apply_id: str = None,
        did: str = None,
        group_platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 申请id
        self.apply_id = apply_id
        # 司机分布式数字身份
        self.did = did
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 产品id  目前填写PRODUCT_MYBANK
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.did, 'did')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.did is not None:
            result['did'] = self.did
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('did') is not None:
            self.did = m.get('did')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class QueryCreditDriverResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        query_msg: str = None,
        status: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 开通失败信息
        self.query_msg = query_msg
        # 开通状态
        # -1:失败状态， 0:未完成状态， 1:已完成状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.query_msg is not None:
            result['query_msg'] = self.query_msg
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('query_msg') is not None:
            self.query_msg = m.get('query_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class QueryCreditConsignorRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        apply_id: str = None,
        did: str = None,
        group_platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 申请id
        self.apply_id = apply_id
        # 货主分布式数字身份
        self.did = did
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 产品id
        # A模式： PRODUCT_MYBANK,
        # A+模式： PRODUCT_MYBANK_A_PLUS,
        # B模式： PRODUCT_MYBANK_B,
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.did, 'did')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.did is not None:
            result['did'] = self.did
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('did') is not None:
            self.did = m.get('did')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class QueryCreditConsignorResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        query_msg: str = None,
        status: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 开通失败信息
        self.query_msg = query_msg
        # 开通状态
        # -1:失败状态， 0:未完成状态， 1:已完成状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.query_msg is not None:
            result['query_msg'] = self.query_msg
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('query_msg') is not None:
            self.query_msg = m.get('query_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class QueryCreditBalanceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        consignor_did: str = None,
        freight: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 货主分布式数字身份
        self.consignor_did = consignor_did
        # 支付单运费，运费最多精确到小数点后2位
        self.freight = freight
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id
        # A模式：PRODUCT_MYBANK,
        # A+模式：PRODUCT_MYBANK_A_PLUS,
        # B模式：PRODUCT_MYBANK_B,
        # 
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.consignor_did, 'consignor_did')
        self.validate_required(self.freight, 'freight')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.consignor_did is not None:
            result['consignor_did'] = self.consignor_did
        if self.freight is not None:
            result['freight'] = self.freight
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('consignor_did') is not None:
            self.consignor_did = m.get('consignor_did')
        if m.get('freight') is not None:
            self.freight = m.get('freight')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class QueryCreditBalanceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        has_balance: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否有信用流转额度
        self.has_balance = has_balance

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.has_balance is not None:
            result['has_balance'] = self.has_balance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('has_balance') is not None:
            self.has_balance = m.get('has_balance')
        return self


class UploadCreditIssueRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        batch_id: str = None,
        callback_url: str = None,
        consignor_did: str = None,
        group_platform_did: str = None,
        issue_apply_infos: List[IssueApplyInfo] = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 批次号
        self.batch_id = batch_id
        # 发行结果回调url
        self.callback_url = callback_url
        # 货主分布式数字身份
        self.consignor_did = consignor_did
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 发行信用流转信息列表
        self.issue_apply_infos = issue_apply_infos
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id 目前填PRODUCT_MYBANK
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.batch_id, 'batch_id')
        self.validate_required(self.callback_url, 'callback_url')
        self.validate_required(self.consignor_did, 'consignor_did')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.issue_apply_infos, 'issue_apply_infos')
        if self.issue_apply_infos:
            for k in self.issue_apply_infos:
                if k:
                    k.validate()
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.consignor_did is not None:
            result['consignor_did'] = self.consignor_did
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        result['issue_apply_infos'] = []
        if self.issue_apply_infos is not None:
            for k in self.issue_apply_infos:
                result['issue_apply_infos'].append(k.to_map() if k else None)
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('consignor_did') is not None:
            self.consignor_did = m.get('consignor_did')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        self.issue_apply_infos = []
        if m.get('issue_apply_infos') is not None:
            for k in m.get('issue_apply_infos'):
                temp_model = IssueApplyInfo()
                self.issue_apply_infos.append(temp_model.from_map(k))
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class UploadCreditIssueResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        batch_id: str = None,
        batch_id_status: int = None,
        issue_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 批次号
        self.batch_id = batch_id
        # 批次状态
        self.batch_id_status = batch_id_status
        # 发行url
        self.issue_url = issue_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.batch_id_status is not None:
            result['batch_id_status'] = self.batch_id_status
        if self.issue_url is not None:
            result['issue_url'] = self.issue_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('batch_id_status') is not None:
            self.batch_id_status = m.get('batch_id_status')
        if m.get('issue_url') is not None:
            self.issue_url = m.get('issue_url')
        return self


class QueryCreditIssuebatchstatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        batch_id: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 批次号
        self.batch_id = batch_id
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id
        # A模式：PRODUCT_MYBANK，
        # A+模式：PRODUCT_MYBANK_A_PLUS，
        # A模式：PRODUCT_MYBANK_B，
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.batch_id, 'batch_id')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class QueryCreditIssuebatchstatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        batch_id: str = None,
        batch_status: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 批次号
        self.batch_id = batch_id
        # 批次状态
        self.batch_status = batch_status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.batch_status is not None:
            result['batch_status'] = self.batch_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('batch_status') is not None:
            self.batch_status = m.get('batch_status')
        return self


class CancelCreditIssuebatchRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        batch_id: str = None,
        consignor_did: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 批次号
        self.batch_id = batch_id
        # 货主分布式数字身份
        self.consignor_did = consignor_did
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id
        # A模式：PRODUCT_MYBANK，
        # A+模式：PRODUCT_MYBANK_A_PLUS，
        # B模式：PRODUCT_MYBANK_B
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.batch_id, 'batch_id')
        self.validate_required(self.consignor_did, 'consignor_did')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.consignor_did is not None:
            result['consignor_did'] = self.consignor_did
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('consignor_did') is not None:
            self.consignor_did = m.get('consignor_did')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class CancelCreditIssuebatchResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        batch_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 批次号
        self.batch_id = batch_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        return self


class QueryCreditIssuebyidRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        batch_id: str = None,
        group_platform_did: str = None,
        issued_only: bool = None,
        issue_id: str = None,
        page_num: int = None,
        page_size: int = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 信用流转发行批次号
        self.batch_id = batch_id
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 是否只返回已发行凭证信息
        self.issued_only = issued_only
        # 信用流转发行凭证Id
        self.issue_id = issue_id
        # 页数 从1开始
        self.page_num = page_num
        # 每页显示数量 不超过100
        self.page_size = page_size
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id
        # A模式：PRODUCT_MYBANK，
        # A+模式：PRODUCT_MYBANK_A_PLUS，
        # B模式：PRODUCT_MYBANK_B
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.batch_id, 'batch_id')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.issued_only, 'issued_only')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.issued_only is not None:
            result['issued_only'] = self.issued_only
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('issued_only') is not None:
            self.issued_only = m.get('issued_only')
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class QueryCreditIssuebyidResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        batch_id: str = None,
        batch_id_status: str = None,
        did: str = None,
        issue_ids: List[IssueIdInfo] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 信用流转批次号
        self.batch_id = batch_id
        # 批次状态
        self.batch_id_status = batch_id_status
        # 凭证发行者did
        self.did = did
        # 发行凭证列表
        self.issue_ids = issue_ids
        # 页数 从1开始
        self.page_num = page_num
        # 每页显示数量
        self.page_size = page_size
        # 数据总量
        self.total_count = total_count

    def validate(self):
        if self.issue_ids:
            for k in self.issue_ids:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.batch_id_status is not None:
            result['batch_id_status'] = self.batch_id_status
        if self.did is not None:
            result['did'] = self.did
        result['issue_ids'] = []
        if self.issue_ids is not None:
            for k in self.issue_ids:
                result['issue_ids'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('batch_id_status') is not None:
            self.batch_id_status = m.get('batch_id_status')
        if m.get('did') is not None:
            self.did = m.get('did')
        self.issue_ids = []
        if m.get('issue_ids') is not None:
            for k in m.get('issue_ids'):
                temp_model = IssueIdInfo()
                self.issue_ids.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class QueryCreditIssuebytimeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        did: str = None,
        end_date: str = None,
        group_platform_did: str = None,
        issued_only: bool = None,
        page_num: int = None,
        page_size: int = None,
        platform_did: str = None,
        product_id: str = None,
        start_date: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 指定查询者分布式数字身份
        self.did = did
        # 查询截止时间
        self.end_date = end_date
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 是否只返回已发行凭证信息
        self.issued_only = issued_only
        # 页数 从1开始
        self.page_num = page_num
        # 每页显示数量 不超过100
        self.page_size = page_size
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id 目前填PRODUCT_MYBANK
        self.product_id = product_id
        # 查询起始时间
        self.start_date = start_date

    def validate(self):
        self.validate_required(self.did, 'did')
        self.validate_required(self.end_date, 'end_date')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.issued_only, 'issued_only')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.start_date, 'start_date')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.did is not None:
            result['did'] = self.did
        if self.end_date is not None:
            result['end_date'] = self.end_date
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.issued_only is not None:
            result['issued_only'] = self.issued_only
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.start_date is not None:
            result['start_date'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('did') is not None:
            self.did = m.get('did')
        if m.get('end_date') is not None:
            self.end_date = m.get('end_date')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('issued_only') is not None:
            self.issued_only = m.get('issued_only')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('start_date') is not None:
            self.start_date = m.get('start_date')
        return self


class QueryCreditIssuebytimeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        batch_id: str = None,
        batch_id_status: int = None,
        did: str = None,
        issue_ids: List[IssueIdInfo] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 信用流转批次号
        self.batch_id = batch_id
        # 批次状态
        self.batch_id_status = batch_id_status
        # 凭证发行者did
        self.did = did
        # 凭证列表
        self.issue_ids = issue_ids
        # 页数 从1开始
        self.page_num = page_num
        # 每页显示数量
        self.page_size = page_size
        # 数据总量
        self.total_count = total_count

    def validate(self):
        if self.issue_ids:
            for k in self.issue_ids:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.batch_id_status is not None:
            result['batch_id_status'] = self.batch_id_status
        if self.did is not None:
            result['did'] = self.did
        result['issue_ids'] = []
        if self.issue_ids is not None:
            for k in self.issue_ids:
                result['issue_ids'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('batch_id_status') is not None:
            self.batch_id_status = m.get('batch_id_status')
        if m.get('did') is not None:
            self.did = m.get('did')
        self.issue_ids = []
        if m.get('issue_ids') is not None:
            for k in m.get('issue_ids'):
                temp_model = IssueIdInfo()
                self.issue_ids.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class QueryCreditUserissueRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        did: str = None,
        group_platform_did: str = None,
        page_num: int = None,
        page_size: int = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 被查询方分布式数字身份
        self.did = did
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 页数
        self.page_num = page_num
        # 每页显示的最大条数
        self.page_size = page_size
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id
        # A模式：PRODUCT_MYBANK， A+模式：PRODUCT_MYBANK_A_PLUS， B模式：PRODUCT_MYBANK_B
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.did, 'did')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.did is not None:
            result['did'] = self.did
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('did') is not None:
            self.did = m.get('did')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class QueryCreditUserissueResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        did: str = None,
        issue_ids: List[UserIssueId] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 凭证所有者分布式数字身份
        self.did = did
        # 信用流转凭证列表
        self.issue_ids = issue_ids
        # 页数
        self.page_num = page_num
        # 每页显示最大条数
        self.page_size = page_size
        # 总数
        self.total_count = total_count

    def validate(self):
        if self.issue_ids:
            for k in self.issue_ids:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.did is not None:
            result['did'] = self.did
        result['issue_ids'] = []
        if self.issue_ids is not None:
            for k in self.issue_ids:
                result['issue_ids'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('did') is not None:
            self.did = m.get('did')
        self.issue_ids = []
        if m.get('issue_ids') is not None:
            for k in m.get('issue_ids'):
                temp_model = UserIssueId()
                self.issue_ids.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class QueryCreditStatementRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        did: str = None,
        end_date: str = None,
        group_platform_did: str = None,
        page_num: int = None,
        page_size: int = None,
        platform_did: str = None,
        product_id: str = None,
        start_date: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需查询对象分布式数字身份不能为空
        self.did = did
        # 查询截止时间
        self.end_date = end_date
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 页数 从1开始
        self.page_num = page_num
        # 每页显示数量 最多100
        self.page_size = page_size
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id
        # A模式：PRODUCT_MYBANK， A+模式：PRODUCT_MYBANK_A_PLUS， B模式：PRODUCT_MYBANK_B
        self.product_id = product_id
        # 查询起始时间
        self.start_date = start_date

    def validate(self):
        self.validate_required(self.did, 'did')
        self.validate_required(self.end_date, 'end_date')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.page_num, 'page_num')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.start_date, 'start_date')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.did is not None:
            result['did'] = self.did
        if self.end_date is not None:
            result['end_date'] = self.end_date
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.start_date is not None:
            result['start_date'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('did') is not None:
            self.did = m.get('did')
        if m.get('end_date') is not None:
            self.end_date = m.get('end_date')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('start_date') is not None:
            self.start_date = m.get('start_date')
        return self


class QueryCreditStatementResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        page_num: int = None,
        page_size: int = None,
        statement_infos: List[StatementInfo] = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 页数 从1开始
        self.page_num = page_num
        # 每页显示数量
        self.page_size = page_size
        # 流水列表
        self.statement_infos = statement_infos
        # 数据总量
        self.total_count = total_count

    def validate(self):
        if self.statement_infos:
            for k in self.statement_infos:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['statement_infos'] = []
        if self.statement_infos is not None:
            for k in self.statement_infos:
                result['statement_infos'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.statement_infos = []
        if m.get('statement_infos') is not None:
            for k in m.get('statement_infos'):
                temp_model = StatementInfo()
                self.statement_infos.append(temp_model.from_map(k))
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class CreateCreditIssuetransferRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        callback_url: str = None,
        group_platform_did: str = None,
        issue_id: str = None,
        out_biz_no: str = None,
        payee_did: str = None,
        payer_did: str = None,
        platform_did: str = None,
        product_id: str = None,
        tx_amt: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 转让结果回调url
        self.callback_url = callback_url
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 信用流转凭证
        self.issue_id = issue_id
        # 全局业务号，保证唯一性，如拆分转让业务单号
        self.out_biz_no = out_biz_no
        # 转入方分布式数字身份
        self.payee_did = payee_did
        # 转出方分布式数字身份
        self.payer_did = payer_did
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id 目前使用PRODUCT_MYBANK
        self.product_id = product_id
        # 转让金额
        self.tx_amt = tx_amt

    def validate(self):
        self.validate_required(self.callback_url, 'callback_url')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.issue_id, 'issue_id')
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.payee_did, 'payee_did')
        self.validate_required(self.payer_did, 'payer_did')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.tx_amt, 'tx_amt')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.payee_did is not None:
            result['payee_did'] = self.payee_did
        if self.payer_did is not None:
            result['payer_did'] = self.payer_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.tx_amt is not None:
            result['tx_amt'] = self.tx_amt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('payee_did') is not None:
            self.payee_did = m.get('payee_did')
        if m.get('payer_did') is not None:
            self.payer_did = m.get('payer_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('tx_amt') is not None:
            self.tx_amt = m.get('tx_amt')
        return self


class CreateCreditIssuetransferResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success_apply_amt: str = None,
        out_biz_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 转让申请成功金额
        self.success_apply_amt = success_apply_amt
        # 请求时传入的全局业务号
        self.out_biz_no = out_biz_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success_apply_amt is not None:
            result['success_apply_amt'] = self.success_apply_amt
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success_apply_amt') is not None:
            self.success_apply_amt = m.get('success_apply_amt')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        return self


class QueryCreditIssuetransferRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group_platform_did: str = None,
        out_biz_no: str = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 全局业务号，保证唯一性，如拆分转让业务单号
        self.out_biz_no = out_biz_no
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id 目前使用PRODUCT_MYBANK
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class QueryCreditIssuetransferResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        err_msg: str = None,
        fail_amt: str = None,
        issue_id: str = None,
        out_biz_no: str = None,
        payee_did: str = None,
        payer_did: str = None,
        product_id: str = None,
        status: int = None,
        success_amt: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 错误信息
        self.err_msg = err_msg
        # 转让失败金额
        self.fail_amt = fail_amt
        # 信用凭证号
        self.issue_id = issue_id
        # 请求时传入的全局业务号
        self.out_biz_no = out_biz_no
        # 转入方分布式数字身份
        self.payee_did = payee_did
        # 转出方分布式数字身份
        self.payer_did = payer_did
        # 产品id
        self.product_id = product_id
        # 转让结果状态 -1:转让失败状态， 0:转让未完成状态， 1:转让部分成功状态，2:转让成功状态
        self.status = status
        # 转让成功金额
        self.success_amt = success_amt

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.err_msg is not None:
            result['err_msg'] = self.err_msg
        if self.fail_amt is not None:
            result['fail_amt'] = self.fail_amt
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.payee_did is not None:
            result['payee_did'] = self.payee_did
        if self.payer_did is not None:
            result['payer_did'] = self.payer_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.status is not None:
            result['status'] = self.status
        if self.success_amt is not None:
            result['success_amt'] = self.success_amt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('err_msg') is not None:
            self.err_msg = m.get('err_msg')
        if m.get('fail_amt') is not None:
            self.fail_amt = m.get('fail_amt')
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('payee_did') is not None:
            self.payee_did = m.get('payee_did')
        if m.get('payer_did') is not None:
            self.payer_did = m.get('payer_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('success_amt') is not None:
            self.success_amt = m.get('success_amt')
        return self


class CreateCreditIssuefinanceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        callback_url: str = None,
        group_platform_did: str = None,
        issue_id: str = None,
        loaner_did: str = None,
        out_biz_no: str = None,
        platform_did: str = None,
        product_id: str = None,
        tx_amt: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 转让结果回调url
        self.callback_url = callback_url
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 信用流转凭证
        self.issue_id = issue_id
        # 融资申请方分布式数字身份
        self.loaner_did = loaner_did
        # 全局业务号，保证唯一性，如融资业务单号
        self.out_biz_no = out_biz_no
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id
        # A模式：PRODUCT_MYBANK， A+模式：PRODUCT_MYBANK_A_PLUS， B模式：PRODUCT_MYBANK_B
        self.product_id = product_id
        # 融资金额
        self.tx_amt = tx_amt

    def validate(self):
        self.validate_required(self.callback_url, 'callback_url')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.issue_id, 'issue_id')
        self.validate_required(self.loaner_did, 'loaner_did')
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.tx_amt, 'tx_amt')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.loaner_did is not None:
            result['loaner_did'] = self.loaner_did
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.tx_amt is not None:
            result['tx_amt'] = self.tx_amt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('loaner_did') is not None:
            self.loaner_did = m.get('loaner_did')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('tx_amt') is not None:
            self.tx_amt = m.get('tx_amt')
        return self


class CreateCreditIssuefinanceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        fail_apply_amt: str = None,
        out_biz_no: str = None,
        success_apply_amt: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 融资申请失败，回转至无车承运平台金额
        self.fail_apply_amt = fail_apply_amt
        # 请求时传入的全局业务号
        self.out_biz_no = out_biz_no
        # 融资申请成功金额
        self.success_apply_amt = success_apply_amt

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.fail_apply_amt is not None:
            result['fail_apply_amt'] = self.fail_apply_amt
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.success_apply_amt is not None:
            result['success_apply_amt'] = self.success_apply_amt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('fail_apply_amt') is not None:
            self.fail_apply_amt = m.get('fail_apply_amt')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('success_apply_amt') is not None:
            self.success_apply_amt = m.get('success_apply_amt')
        return self


class QueryCreditIssuefinanceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group_platform_did: str = None,
        loaner_did: str = None,
        out_biz_no: str = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 融资申请方分布式数字身份
        self.loaner_did = loaner_did
        # 全局业务号，保证唯一性，如融资业务单号
        self.out_biz_no = out_biz_no
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id
        # A模式：PRODUCT_MYBANK， A+模式：PRODUCT_MYBANK_A_PLUS， B模式：PRODUCT_MYBANK_B
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.loaner_did, 'loaner_did')
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.loaner_did is not None:
            result['loaner_did'] = self.loaner_did
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('loaner_did') is not None:
            self.loaner_did = m.get('loaner_did')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class QueryCreditIssuefinanceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        err_msg: str = None,
        fail_amt: str = None,
        fail_transfer_amt: str = None,
        out_biz_no: str = None,
        status: int = None,
        success_amt: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 错误信息
        self.err_msg = err_msg
        # 融资失败，回转至无车承运平台失败金额
        self.fail_amt = fail_amt
        # 融资失败，回转至无车承运平台成功金额
        self.fail_transfer_amt = fail_transfer_amt
        # 请求时传入的全局业务号
        self.out_biz_no = out_biz_no
        # 融资结果状态 -1:融资未完成， 0:融资完成， 1:融资全部失败，逆流转回平台全部成功，2:融资部分成功，逆流转回平台全部成功，3:逆流转回平台发生失败，需人工介入
        self.status = status
        # 融资成功金额
        self.success_amt = success_amt

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.err_msg is not None:
            result['err_msg'] = self.err_msg
        if self.fail_amt is not None:
            result['fail_amt'] = self.fail_amt
        if self.fail_transfer_amt is not None:
            result['fail_transfer_amt'] = self.fail_transfer_amt
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.status is not None:
            result['status'] = self.status
        if self.success_amt is not None:
            result['success_amt'] = self.success_amt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('err_msg') is not None:
            self.err_msg = m.get('err_msg')
        if m.get('fail_amt') is not None:
            self.fail_amt = m.get('fail_amt')
        if m.get('fail_transfer_amt') is not None:
            self.fail_transfer_amt = m.get('fail_transfer_amt')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('success_amt') is not None:
            self.success_amt = m.get('success_amt')
        return self


class QueryCreditIssuereceivableRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group_platform_did: str = None,
        issue_id: str = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 信用凭证id
        self.issue_id = issue_id
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # PRODUCT_MYBANK  、PRODUCT_MYBANK_B
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.issue_id, 'issue_id')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class QueryCreditIssuereceivableResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        clear_amt: str = None,
        compensate_amt: str = None,
        err_msg: str = None,
        finish_date: str = None,
        has_compensate: bool = None,
        issue_id: str = None,
        out_biz_no: str = None,
        out_order_no: str = None,
        product_id: str = None,
        status: int = None,
        total_amt: str = None,
        type: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 已清分金额
        self.clear_amt = clear_amt
        # 代偿金额
        self.compensate_amt = compensate_amt
        # 错误信息
        self.err_msg = err_msg
        # 完成日期 long类型字符串
        self.finish_date = finish_date
        # 是否代偿,true为代偿，false为不代偿
        self.has_compensate = has_compensate
        # 信用凭证id
        self.issue_id = issue_id
        # 全局唯一业务号
        self.out_biz_no = out_biz_no
        # 外部订单号，也就是凭证发行时传递的支付订单
        self.out_order_no = out_order_no
        # 产品id--PRODUCT_MYBANK 、PRODUCT_MYBANK_B;
        self.product_id = product_id
        # 清分结果状态--- 0：未清分， 1：清分完成
        self.status = status
        # 凭证总金额
        self.total_amt = total_amt
        # 清分类型--主动清分 、 到期清分
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.clear_amt is not None:
            result['clear_amt'] = self.clear_amt
        if self.compensate_amt is not None:
            result['compensate_amt'] = self.compensate_amt
        if self.err_msg is not None:
            result['err_msg'] = self.err_msg
        if self.finish_date is not None:
            result['finish_date'] = self.finish_date
        if self.has_compensate is not None:
            result['has_compensate'] = self.has_compensate
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.out_order_no is not None:
            result['out_order_no'] = self.out_order_no
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.status is not None:
            result['status'] = self.status
        if self.total_amt is not None:
            result['total_amt'] = self.total_amt
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('clear_amt') is not None:
            self.clear_amt = m.get('clear_amt')
        if m.get('compensate_amt') is not None:
            self.compensate_amt = m.get('compensate_amt')
        if m.get('err_msg') is not None:
            self.err_msg = m.get('err_msg')
        if m.get('finish_date') is not None:
            self.finish_date = m.get('finish_date')
        if m.get('has_compensate') is not None:
            self.has_compensate = m.get('has_compensate')
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('out_order_no') is not None:
            self.out_order_no = m.get('out_order_no')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('total_amt') is not None:
            self.total_amt = m.get('total_amt')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class QueryCreditIssueamountRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        did: str = None,
        group_platform_did: str = None,
        issue_id: str = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 指定查询者分布式数字身份
        self.did = did
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 信用凭证id
        self.issue_id = issue_id
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id 目前填写PRODUCT_MYBANK
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.did, 'did')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.issue_id, 'issue_id')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.did is not None:
            result['did'] = self.did
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('did') is not None:
            self.did = m.get('did')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class QueryCreditIssueamountResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        balance_amt: str = None,
        cash_amt: str = None,
        debt_int_amt: str = None,
        debt_prin_amt: str = None,
        debt_total_amt: str = None,
        expire_date: str = None,
        freeze_amt: str = None,
        issue_id: str = None,
        paid_int_amt: str = None,
        ticket_amt: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 剩余金额
        self.balance_amt = balance_amt
        # 已清分金额
        self.cash_amt = cash_amt
        # 欠的滞纳金金额
        self.debt_int_amt = debt_int_amt
        # 欠款本金金额
        self.debt_prin_amt = debt_prin_amt
        # 该凭证下的总欠款金额
        self.debt_total_amt = debt_total_amt
        # 信用凭证到期时间
        self.expire_date = expire_date
        # 冻结的金额
        self.freeze_amt = freeze_amt
        # 信用凭证id
        self.issue_id = issue_id
        # 累计已还滞纳金金额
        self.paid_int_amt = paid_int_amt
        # 凭证总金额
        self.ticket_amt = ticket_amt

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.balance_amt is not None:
            result['balance_amt'] = self.balance_amt
        if self.cash_amt is not None:
            result['cash_amt'] = self.cash_amt
        if self.debt_int_amt is not None:
            result['debt_int_amt'] = self.debt_int_amt
        if self.debt_prin_amt is not None:
            result['debt_prin_amt'] = self.debt_prin_amt
        if self.debt_total_amt is not None:
            result['debt_total_amt'] = self.debt_total_amt
        if self.expire_date is not None:
            result['expire_date'] = self.expire_date
        if self.freeze_amt is not None:
            result['freeze_amt'] = self.freeze_amt
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.paid_int_amt is not None:
            result['paid_int_amt'] = self.paid_int_amt
        if self.ticket_amt is not None:
            result['ticket_amt'] = self.ticket_amt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('balance_amt') is not None:
            self.balance_amt = m.get('balance_amt')
        if m.get('cash_amt') is not None:
            self.cash_amt = m.get('cash_amt')
        if m.get('debt_int_amt') is not None:
            self.debt_int_amt = m.get('debt_int_amt')
        if m.get('debt_prin_amt') is not None:
            self.debt_prin_amt = m.get('debt_prin_amt')
        if m.get('debt_total_amt') is not None:
            self.debt_total_amt = m.get('debt_total_amt')
        if m.get('expire_date') is not None:
            self.expire_date = m.get('expire_date')
        if m.get('freeze_amt') is not None:
            self.freeze_amt = m.get('freeze_amt')
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('paid_int_amt') is not None:
            self.paid_int_amt = m.get('paid_int_amt')
        if m.get('ticket_amt') is not None:
            self.ticket_amt = m.get('ticket_amt')
        return self


class CallbackCreditCommonRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        msg_data: str = None,
        msg_method: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 回调数据，根据不同msg_method 返回不同结构
        self.msg_data = msg_data
        # 回调方法类型
        self.msg_method = msg_method

    def validate(self):
        self.validate_required(self.msg_data, 'msg_data')
        self.validate_required(self.msg_method, 'msg_method')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.msg_data is not None:
            result['msg_data'] = self.msg_data
        if self.msg_method is not None:
            result['msg_method'] = self.msg_method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('msg_data') is not None:
            self.msg_data = m.get('msg_data')
        if m.get('msg_method') is not None:
            self.msg_method = m.get('msg_method')
        return self


class CallbackCreditCommonResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        received: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否已接收
        self.received = received

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.received is not None:
            result['received'] = self.received
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('received') is not None:
            self.received = m.get('received')
        return self


class ApplyCreditIssueclearRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        apply_date: int = None,
        clear_amt: str = None,
        clear_did: str = None,
        ext_info: str = None,
        group_platform_did: str = None,
        issue_id: str = None,
        out_biz_no: str = None,
        out_order_no: str = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 申请日期，不输入则是当前时间
        self.apply_date = apply_date
        # 清分金额，当前只支持全额清分，不填就是默认全额清分
        self.clear_amt = clear_amt
        # 主动清分方分布式数字身份
        self.clear_did = clear_did
        # 扩展字段
        self.ext_info = ext_info
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 凭证id
        self.issue_id = issue_id
        # 全局唯一业务流水号
        self.out_biz_no = out_biz_no
        # 外部订单号，此为支付单号
        self.out_order_no = out_order_no
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id
        # A模式：PRODUCT_MYBANK， A+模式：PRODUCT_MYBANK_A_PLUS， B模式：PRODUCT_MYBANK_B
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.clear_did, 'clear_did')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.issue_id, 'issue_id')
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.out_order_no, 'out_order_no')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.apply_date is not None:
            result['apply_date'] = self.apply_date
        if self.clear_amt is not None:
            result['clear_amt'] = self.clear_amt
        if self.clear_did is not None:
            result['clear_did'] = self.clear_did
        if self.ext_info is not None:
            result['ext_info'] = self.ext_info
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.out_order_no is not None:
            result['out_order_no'] = self.out_order_no
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('apply_date') is not None:
            self.apply_date = m.get('apply_date')
        if m.get('clear_amt') is not None:
            self.clear_amt = m.get('clear_amt')
        if m.get('clear_did') is not None:
            self.clear_did = m.get('clear_did')
        if m.get('ext_info') is not None:
            self.ext_info = m.get('ext_info')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('out_order_no') is not None:
            self.out_order_no = m.get('out_order_no')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class ApplyCreditIssueclearResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        out_biz_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 全局唯一业务流水号
        self.out_biz_no = out_biz_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        return self


class SendCreditProxyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        apply_method: str = None,
        apply_data: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 代理请求方法名
        self.apply_method = apply_method
        # 代理请求数据
        self.apply_data = apply_data

    def validate(self):
        self.validate_required(self.apply_method, 'apply_method')
        self.validate_required(self.apply_data, 'apply_data')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.apply_method is not None:
            result['apply_method'] = self.apply_method
        if self.apply_data is not None:
            result['apply_data'] = self.apply_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('apply_method') is not None:
            self.apply_method = m.get('apply_method')
        if m.get('apply_data') is not None:
            self.apply_data = m.get('apply_data')
        return self


class SendCreditProxyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class CheckCreditWaybillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        product_id: str = None,
        waybill_list: List[str] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 业务发起方分布式数字身
        self.platform_did = platform_did
        # 产品id
        # A模式：PRODUCT_MYBANK， A+模式：PRODUCT_MYBANK_A_PLUS， B模式：PRODUCT_MYBANK_B
        self.product_id = product_id
        # 运单列表
        self.waybill_list = waybill_list

    def validate(self):
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.waybill_list, 'waybill_list')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.waybill_list is not None:
            result['waybill_list'] = self.waybill_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('waybill_list') is not None:
            self.waybill_list = m.get('waybill_list')
        return self


class CheckCreditWaybillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        check_result: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 核验结果列表,  格式为 运单号:核验状态， 核验状态包含  0:运单未知状态   1:通过   2:不通过   3:未核验   4:没有指定信息
        self.check_result = check_result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.check_result is not None:
            result['check_result'] = self.check_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('check_result') is not None:
            self.check_result = m.get('check_result')
        return self


class ReopenCreditDriverRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        product_id: str = None,
        group_platform_did: str = None,
        driver_did: str = None,
        account_id: str = None,
        callback_url: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 产品id
        self.product_id = product_id
        # 集团平台did
        self.group_platform_did = group_platform_did
        # 司机did
        self.driver_did = driver_did
        # 云资金商户id
        self.account_id = account_id
        # 回调地址
        self.callback_url = callback_url

    def validate(self):
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.driver_did, 'driver_did')
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.callback_url, 'callback_url')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.driver_did is not None:
            result['driver_did'] = self.driver_did
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('driver_did') is not None:
            self.driver_did = m.get('driver_did')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        return self


class ReopenCreditDriverResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        apply_id: str = None,
        status: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 申请id
        self.apply_id = apply_id
        # 会员注册状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class UploadCreditAuthorizationRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        consignor_cert_no: str = None,
        consignor_did: str = None,
        consignor_name: str = None,
        consignor_platform_account: str = None,
        expire_date: str = None,
        group_platform_did: str = None,
        has_authorization_clause: bool = None,
        platform_cert_no: str = None,
        platform_did: str = None,
        platform_name: str = None,
        protocol_img_id: str = None,
        protocol_name: str = None,
        protocol_no: str = None,
        sign_date: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 签署货主统一社会信用代码
        self.consignor_cert_no = consignor_cert_no
        # 签署货主did
        self.consignor_did = consignor_did
        # 签署货主企业名称
        self.consignor_name = consignor_name
        # 授权的货主平台账号
        self.consignor_platform_account = consignor_platform_account
        # 协议到期日
        self.expire_date = expire_date
        # 集团平台did
        self.group_platform_did = group_platform_did
        # 是否包含账号授权条款
        self.has_authorization_clause = has_authorization_clause
        # 签署子公司统一社会信用代码
        self.platform_cert_no = platform_cert_no
        # 签署子公司did
        self.platform_did = platform_did
        # 签署子公司企业名称
        # 
        self.platform_name = platform_name
        # 线下协议影像件id与文件哈希, 多id以逗号分隔, 最多支持10个
        self.protocol_img_id = protocol_img_id
        # 协议名称
        self.protocol_name = protocol_name
        # 线下协议编号
        self.protocol_no = protocol_no
        # 签署时间
        self.sign_date = sign_date
        # 产品id
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.consignor_cert_no, 'consignor_cert_no')
        self.validate_required(self.consignor_did, 'consignor_did')
        self.validate_required(self.consignor_name, 'consignor_name')
        self.validate_required(self.consignor_platform_account, 'consignor_platform_account')
        self.validate_required(self.expire_date, 'expire_date')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.has_authorization_clause, 'has_authorization_clause')
        self.validate_required(self.platform_cert_no, 'platform_cert_no')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.platform_name, 'platform_name')
        self.validate_required(self.protocol_img_id, 'protocol_img_id')
        self.validate_required(self.protocol_name, 'protocol_name')
        self.validate_required(self.protocol_no, 'protocol_no')
        self.validate_required(self.sign_date, 'sign_date')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.consignor_cert_no is not None:
            result['consignor_cert_no'] = self.consignor_cert_no
        if self.consignor_did is not None:
            result['consignor_did'] = self.consignor_did
        if self.consignor_name is not None:
            result['consignor_name'] = self.consignor_name
        if self.consignor_platform_account is not None:
            result['consignor_platform_account'] = self.consignor_platform_account
        if self.expire_date is not None:
            result['expire_date'] = self.expire_date
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.has_authorization_clause is not None:
            result['has_authorization_clause'] = self.has_authorization_clause
        if self.platform_cert_no is not None:
            result['platform_cert_no'] = self.platform_cert_no
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.platform_name is not None:
            result['platform_name'] = self.platform_name
        if self.protocol_img_id is not None:
            result['protocol_img_id'] = self.protocol_img_id
        if self.protocol_name is not None:
            result['protocol_name'] = self.protocol_name
        if self.protocol_no is not None:
            result['protocol_no'] = self.protocol_no
        if self.sign_date is not None:
            result['sign_date'] = self.sign_date
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('consignor_cert_no') is not None:
            self.consignor_cert_no = m.get('consignor_cert_no')
        if m.get('consignor_did') is not None:
            self.consignor_did = m.get('consignor_did')
        if m.get('consignor_name') is not None:
            self.consignor_name = m.get('consignor_name')
        if m.get('consignor_platform_account') is not None:
            self.consignor_platform_account = m.get('consignor_platform_account')
        if m.get('expire_date') is not None:
            self.expire_date = m.get('expire_date')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('has_authorization_clause') is not None:
            self.has_authorization_clause = m.get('has_authorization_clause')
        if m.get('platform_cert_no') is not None:
            self.platform_cert_no = m.get('platform_cert_no')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('platform_name') is not None:
            self.platform_name = m.get('platform_name')
        if m.get('protocol_img_id') is not None:
            self.protocol_img_id = m.get('protocol_img_id')
        if m.get('protocol_name') is not None:
            self.protocol_name = m.get('protocol_name')
        if m.get('protocol_no') is not None:
            self.protocol_no = m.get('protocol_no')
        if m.get('sign_date') is not None:
            self.sign_date = m.get('sign_date')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class UploadCreditAuthorizationResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_hash: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 协议链上地址
        self.tx_hash = tx_hash

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        return self


class UploadCreditConfirmRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        confirm_date: str = None,
        confirm_no: str = None,
        consignor_did: str = None,
        consignor_platform_account: str = None,
        expire_date: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        protocol_name: str = None,
        protocol_pdf_id: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 货主云资金商户id
        self.account_id = account_id
        # 确认时间
        self.confirm_date = confirm_date
        # 应收转让通知编号
        self.confirm_no = confirm_no
        # 签署货主did
        self.consignor_did = consignor_did
        # 签署的货主平台账号
        self.consignor_platform_account = consignor_platform_account
        # 协议到期日
        self.expire_date = expire_date
        # 集团平台did
        self.group_platform_did = group_platform_did
        # 签署子公司did
        self.platform_did = platform_did
        # 协议名称
        self.protocol_name = protocol_name
        # 协议PDF文件, 多个文件可用逗号分隔, 最多10个
        self.protocol_pdf_id = protocol_pdf_id
        # 产品id
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.confirm_date, 'confirm_date')
        self.validate_required(self.confirm_no, 'confirm_no')
        self.validate_required(self.consignor_did, 'consignor_did')
        self.validate_required(self.consignor_platform_account, 'consignor_platform_account')
        self.validate_required(self.expire_date, 'expire_date')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.protocol_name, 'protocol_name')
        self.validate_required(self.protocol_pdf_id, 'protocol_pdf_id')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.confirm_date is not None:
            result['confirm_date'] = self.confirm_date
        if self.confirm_no is not None:
            result['confirm_no'] = self.confirm_no
        if self.consignor_did is not None:
            result['consignor_did'] = self.consignor_did
        if self.consignor_platform_account is not None:
            result['consignor_platform_account'] = self.consignor_platform_account
        if self.expire_date is not None:
            result['expire_date'] = self.expire_date
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.protocol_name is not None:
            result['protocol_name'] = self.protocol_name
        if self.protocol_pdf_id is not None:
            result['protocol_pdf_id'] = self.protocol_pdf_id
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('confirm_date') is not None:
            self.confirm_date = m.get('confirm_date')
        if m.get('confirm_no') is not None:
            self.confirm_no = m.get('confirm_no')
        if m.get('consignor_did') is not None:
            self.consignor_did = m.get('consignor_did')
        if m.get('consignor_platform_account') is not None:
            self.consignor_platform_account = m.get('consignor_platform_account')
        if m.get('expire_date') is not None:
            self.expire_date = m.get('expire_date')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('protocol_name') is not None:
            self.protocol_name = m.get('protocol_name')
        if m.get('protocol_pdf_id') is not None:
            self.protocol_pdf_id = m.get('protocol_pdf_id')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class UploadCreditConfirmResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        tx_hash: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 协议链上地址
        self.tx_hash = tx_hash

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.tx_hash is not None:
            result['tx_hash'] = self.tx_hash
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('tx_hash') is not None:
            self.tx_hash = m.get('tx_hash')
        return self


class BatchcreateCreditmodeIssueRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        batch_id: str = None,
        callback_url: str = None,
        group_platform_did: str = None,
        issue_apply_infos: List[IssueApplyInfo] = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 批次id
        self.batch_id = batch_id
        # 回调地址
        self.callback_url = callback_url
        # 集团平台分布式数字身份
        self.group_platform_did = group_platform_did
        # 发行列表
        self.issue_apply_infos = issue_apply_infos
        # 业务平台方分布式数字身份
        self.platform_did = platform_did
        # 产品id
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.batch_id, 'batch_id')
        self.validate_required(self.callback_url, 'callback_url')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.issue_apply_infos, 'issue_apply_infos')
        if self.issue_apply_infos:
            for k in self.issue_apply_infos:
                if k:
                    k.validate()
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        result['issue_apply_infos'] = []
        if self.issue_apply_infos is not None:
            for k in self.issue_apply_infos:
                result['issue_apply_infos'].append(k.to_map() if k else None)
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        self.issue_apply_infos = []
        if m.get('issue_apply_infos') is not None:
            for k in m.get('issue_apply_infos'):
                temp_model = IssueApplyInfo()
                self.issue_apply_infos.append(temp_model.from_map(k))
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class BatchcreateCreditmodeIssueResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        batch_id: str = None,
        batch_status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 批次id
        self.batch_id = batch_id
        # 批次状态
        self.batch_status = batch_status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.batch_status is not None:
            result['batch_status'] = self.batch_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('batch_status') is not None:
            self.batch_status = m.get('batch_status')
        return self


class ApplyCreditmodeIssueclearRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        product_id: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        clear_did: str = None,
        issue_id: str = None,
        out_biz_no: str = None,
        out_order_no: str = None,
        clear_amt: str = None,
        mode_type: str = None,
        apply_date: str = None,
        ext_info: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 产品id
        self.product_id = product_id
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 业务平台方分布式数字身份
        self.platform_did = platform_did
        # 主动清分方分布式数字身份
        self.clear_did = clear_did
        # 凭证id
        self.issue_id = issue_id
        # 全局业务号
        self.out_biz_no = out_biz_no
        # 支付单号
        self.out_order_no = out_order_no
        # 清分金额
        self.clear_amt = clear_amt
        # 模式  B:b模式
        self.mode_type = mode_type
        # 申请日期
        self.apply_date = apply_date
        # 扩展字段
        self.ext_info = ext_info

    def validate(self):
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.clear_did, 'clear_did')
        self.validate_required(self.issue_id, 'issue_id')
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.out_order_no, 'out_order_no')
        self.validate_required(self.mode_type, 'mode_type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.clear_did is not None:
            result['clear_did'] = self.clear_did
        if self.issue_id is not None:
            result['issue_id'] = self.issue_id
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.out_order_no is not None:
            result['out_order_no'] = self.out_order_no
        if self.clear_amt is not None:
            result['clear_amt'] = self.clear_amt
        if self.mode_type is not None:
            result['mode_type'] = self.mode_type
        if self.apply_date is not None:
            result['apply_date'] = self.apply_date
        if self.ext_info is not None:
            result['ext_info'] = self.ext_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('clear_did') is not None:
            self.clear_did = m.get('clear_did')
        if m.get('issue_id') is not None:
            self.issue_id = m.get('issue_id')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('out_order_no') is not None:
            self.out_order_no = m.get('out_order_no')
        if m.get('clear_amt') is not None:
            self.clear_amt = m.get('clear_amt')
        if m.get('mode_type') is not None:
            self.mode_type = m.get('mode_type')
        if m.get('apply_date') is not None:
            self.apply_date = m.get('apply_date')
        if m.get('ext_info') is not None:
            self.ext_info = m.get('ext_info')
        return self


class ApplyCreditmodeIssueclearResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        out_biz_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 全局业务号
        self.out_biz_no = out_biz_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        return self


class UploadCreditIssuebysaasRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        batch_id: str = None,
        callback_url: str = None,
        group_platform_did: str = None,
        issue_apply_infos: List[SaasIssueApplyInfo] = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 批次id
        self.batch_id = batch_id
        # 发行结果回调地址
        self.callback_url = callback_url
        # 集团平台did
        self.group_platform_did = group_platform_did
        # 发行信息
        self.issue_apply_infos = issue_apply_infos
        # 凭证发行方did
        self.platform_did = platform_did
        # 产品id
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.batch_id, 'batch_id')
        self.validate_required(self.callback_url, 'callback_url')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.issue_apply_infos, 'issue_apply_infos')
        if self.issue_apply_infos:
            for k in self.issue_apply_infos:
                if k:
                    k.validate()
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        result['issue_apply_infos'] = []
        if self.issue_apply_infos is not None:
            for k in self.issue_apply_infos:
                result['issue_apply_infos'].append(k.to_map() if k else None)
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        self.issue_apply_infos = []
        if m.get('issue_apply_infos') is not None:
            for k in m.get('issue_apply_infos'):
                temp_model = SaasIssueApplyInfo()
                self.issue_apply_infos.append(temp_model.from_map(k))
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class UploadCreditIssuebysaasResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        batch_id: str = None,
        batch_status: int = None,
        issue_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 批次id
        self.batch_id = batch_id
        # 批次状态
        self.batch_status = batch_status
        # 发行url
        self.issue_url = issue_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.batch_status is not None:
            result['batch_status'] = self.batch_status
        if self.issue_url is not None:
            result['issue_url'] = self.issue_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('batch_status') is not None:
            self.batch_status = m.get('batch_status')
        if m.get('issue_url') is not None:
            self.issue_url = m.get('issue_url')
        return self


class CancelCreditIssuebatchbysaasRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        batch_id: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 批次号
        self.batch_id = batch_id
        # 集团平台did
        self.group_platform_did = group_platform_did
        # 凭证发行方did
        self.platform_did = platform_did
        # 产品id
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.batch_id, 'batch_id')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class CancelCreditIssuebatchbysaasResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        batch_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 批次id
        self.batch_id = batch_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        return self


class QueryCreditBalancebysaasRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        product_id: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        freight: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 产品id
        self.product_id = product_id
        # 集团平台did
        self.group_platform_did = group_platform_did
        # 查询者did
        self.platform_did = platform_did
        # 发行金额
        self.freight = freight

    def validate(self):
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.freight, 'freight')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.freight is not None:
            result['freight'] = self.freight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('freight') is not None:
            self.freight = m.get('freight')
        return self


class QueryCreditBalancebysaasResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        has_balance: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否有信用流转额度
        self.has_balance = has_balance

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.has_balance is not None:
            result['has_balance'] = self.has_balance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('has_balance') is not None:
            self.has_balance = m.get('has_balance')
        return self


class GetCreditIssuescpticketRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        apply_id: str = None,
        callback_url: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        product_id: str = None,
        scp_ticket_issue_data: List[ScpTicketIssueData] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 申请唯一流水号
        self.apply_id = apply_id
        # 回调地址
        self.callback_url = callback_url
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 业务发起方分布式数字身
        self.platform_did = platform_did
        # 产品id
        self.product_id = product_id
        # 电子回单查询凭证数据
        self.scp_ticket_issue_data = scp_ticket_issue_data

    def validate(self):
        self.validate_required(self.apply_id, 'apply_id')
        self.validate_required(self.callback_url, 'callback_url')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.scp_ticket_issue_data, 'scp_ticket_issue_data')
        if self.scp_ticket_issue_data:
            for k in self.scp_ticket_issue_data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        result['scp_ticket_issue_data'] = []
        if self.scp_ticket_issue_data is not None:
            for k in self.scp_ticket_issue_data:
                result['scp_ticket_issue_data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        self.scp_ticket_issue_data = []
        if m.get('scp_ticket_issue_data') is not None:
            for k in m.get('scp_ticket_issue_data'):
                temp_model = ScpTicketIssueData()
                self.scp_ticket_issue_data.append(temp_model.from_map(k))
        return self


class GetCreditIssuescpticketResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        apply_id: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 申请唯一流水号
        self.apply_id = apply_id
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 业务发起方分布式数字身
        self.platform_did = platform_did
        # 产品id
        self.product_id = product_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class QueryCreditIssuescpticketresultRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        apply_id: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 申请唯一流水号
        self.apply_id = apply_id
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 业务发起方分布式数字身
        self.platform_did = platform_did
        # 产品id
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.apply_id, 'apply_id')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class QueryCreditIssuescpticketresultResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        apply_id: str = None,
        file_download_url: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        product_id: str = None,
        status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 申请唯一流水号
        self.apply_id = apply_id
        # 电子回单下载地址,链接有有效期
        self.file_download_url = file_download_url
        # 集团平台方分布式数字身份
        # 
        self.group_platform_did = group_platform_did
        # 业务发起方分布式数字身
        self.platform_did = platform_did
        # 产品id
        # 
        self.product_id = product_id
        # 状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.file_download_url is not None:
            result['file_download_url'] = self.file_download_url
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('file_download_url') is not None:
            self.file_download_url = m.get('file_download_url')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class UploadCreditAplusissueRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        batch_id: str = None,
        callback_url: str = None,
        consignor_did: str = None,
        easy_finance: bool = None,
        group_platform_did: str = None,
        issue_apply_infos: List[IssueApplyInfoPlus] = None,
        platform_did: str = None,
        product_id: str = None,
        login_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 批次id
        self.batch_id = batch_id
        # 发行结果信息回调地址
        self.callback_url = callback_url
        # 货代did
        self.consignor_did = consignor_did
        # 发行时直接进行快速提现：true ，
        # 发行后自主触发提现：false （默认）
        self.easy_finance = easy_finance
        # 集团平台did
        self.group_platform_did = group_platform_did
        # 发行信息列表
        self.issue_apply_infos = issue_apply_infos
        # 业务承接方did
        self.platform_did = platform_did
        # 产品id
        self.product_id = product_id
        # 登录模式，返回的发行url指定使用何种模式登录。ORG:企业支付宝登录（缺省时默认ORG模式），USER_ACCOUNT:个人支付宝登录。
        self.login_type = login_type

    def validate(self):
        self.validate_required(self.batch_id, 'batch_id')
        self.validate_required(self.callback_url, 'callback_url')
        self.validate_required(self.consignor_did, 'consignor_did')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.issue_apply_infos, 'issue_apply_infos')
        if self.issue_apply_infos:
            for k in self.issue_apply_infos:
                if k:
                    k.validate()
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.consignor_did is not None:
            result['consignor_did'] = self.consignor_did
        if self.easy_finance is not None:
            result['easy_finance'] = self.easy_finance
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        result['issue_apply_infos'] = []
        if self.issue_apply_infos is not None:
            for k in self.issue_apply_infos:
                result['issue_apply_infos'].append(k.to_map() if k else None)
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.login_type is not None:
            result['login_type'] = self.login_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('consignor_did') is not None:
            self.consignor_did = m.get('consignor_did')
        if m.get('easy_finance') is not None:
            self.easy_finance = m.get('easy_finance')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        self.issue_apply_infos = []
        if m.get('issue_apply_infos') is not None:
            for k in m.get('issue_apply_infos'):
                temp_model = IssueApplyInfoPlus()
                self.issue_apply_infos.append(temp_model.from_map(k))
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('login_type') is not None:
            self.login_type = m.get('login_type')
        return self


class UploadCreditAplusissueResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        batch_id: str = None,
        batch_id_status: int = None,
        issue_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 批次id
        self.batch_id = batch_id
        # 批次状态 -1:失效， 0:初始化完成，1:进行中，2:部分成功，3:成功
        self.batch_id_status = batch_id_status
        # 凭证发行跳转url
        self.issue_url = issue_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.batch_id_status is not None:
            result['batch_id_status'] = self.batch_id_status
        if self.issue_url is not None:
            result['issue_url'] = self.issue_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('batch_id_status') is not None:
            self.batch_id_status = m.get('batch_id_status')
        if m.get('issue_url') is not None:
            self.issue_url = m.get('issue_url')
        return self


class QueryCreditCreditamountRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 集团平台did
        self.group_platform_did = group_platform_did
        # 平台did
        self.platform_did = platform_did
        # 产品ID
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class QueryCreditCreditamountResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        credit_amount: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 可用额度
        self.credit_amount = credit_amount
        # 集团平台did
        self.group_platform_did = group_platform_did
        # 平台did
        self.platform_did = platform_did
        # 产品ID
        self.product_id = product_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.credit_amount is not None:
            result['credit_amount'] = self.credit_amount
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('credit_amount') is not None:
            self.credit_amount = m.get('credit_amount')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class CreateCreditCommonsignRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_id: str = None,
        account_type: str = None,
        bank_cnaps: str = None,
        bank_name: str = None,
        callback_url: str = None,
        driving_license: str = None,
        driving_license_file_id: str = None,
        group_platform_did: str = None,
        legal_name: str = None,
        product_id: str = None,
        sign_did: str = None,
        vehicle_license: str = None,
        vehicle_license_file_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 账户号，account_type=ACCOUNT_BANK_NO时填写外部银行卡号， account_type=ACCOUNT_CLOUD_FUND时填写云资金商户ID
        self.account_id = account_id
        # 账户类型，ACCOUNT_BANK_NO:外部银行卡，ACCOUNT_CLOUD_FUND:云资金商户ID
        self.account_type = account_type
        # 开户行联行号，当帐户类型为ACCOUNT_BANK_NO时必填
        self.bank_cnaps = bank_cnaps
        # 开户行名称，当帐户类型为ACCOUNT_BANK_NO时必填
        self.bank_name = bank_name
        # 签约结果回调地址
        self.callback_url = callback_url
        # 驾驶证号码，当帐户类型为ACCOUNT_BANK_NO且签约方sign_did类型为个人时必填
        self.driving_license = driving_license
        # 驾驶证影像件ID，当帐户类型为ACCOUNT_BANK_NO且签约方sign_did类型为个人时必填
        self.driving_license_file_id = driving_license_file_id
        # 集团平台did
        self.group_platform_did = group_platform_did
        # 法定代表人名称，签约方sign_did类型为企业时必填
        self.legal_name = legal_name
        # 产品id
        self.product_id = product_id
        # 签约方did
        self.sign_did = sign_did
        # 行驶证号码，当帐户类型为ACCOUNT_BANK_NO且签约方sign_did类型为个人时必填
        self.vehicle_license = vehicle_license
        # 行驶证影像件ID，当帐户类型为ACCOUNT_BANK_NO且签约方sign_did类型为个人时必填
        self.vehicle_license_file_id = vehicle_license_file_id

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.account_type, 'account_type')
        self.validate_required(self.callback_url, 'callback_url')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.sign_did, 'sign_did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_id is not None:
            result['account_id'] = self.account_id
        if self.account_type is not None:
            result['account_type'] = self.account_type
        if self.bank_cnaps is not None:
            result['bank_cnaps'] = self.bank_cnaps
        if self.bank_name is not None:
            result['bank_name'] = self.bank_name
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.driving_license is not None:
            result['driving_license'] = self.driving_license
        if self.driving_license_file_id is not None:
            result['driving_license_file_id'] = self.driving_license_file_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.legal_name is not None:
            result['legal_name'] = self.legal_name
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.sign_did is not None:
            result['sign_did'] = self.sign_did
        if self.vehicle_license is not None:
            result['vehicle_license'] = self.vehicle_license
        if self.vehicle_license_file_id is not None:
            result['vehicle_license_file_id'] = self.vehicle_license_file_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_id') is not None:
            self.account_id = m.get('account_id')
        if m.get('account_type') is not None:
            self.account_type = m.get('account_type')
        if m.get('bank_cnaps') is not None:
            self.bank_cnaps = m.get('bank_cnaps')
        if m.get('bank_name') is not None:
            self.bank_name = m.get('bank_name')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('driving_license') is not None:
            self.driving_license = m.get('driving_license')
        if m.get('driving_license_file_id') is not None:
            self.driving_license_file_id = m.get('driving_license_file_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('legal_name') is not None:
            self.legal_name = m.get('legal_name')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('sign_did') is not None:
            self.sign_did = m.get('sign_did')
        if m.get('vehicle_license') is not None:
            self.vehicle_license = m.get('vehicle_license')
        if m.get('vehicle_license_file_id') is not None:
            self.vehicle_license_file_id = m.get('vehicle_license_file_id')
        return self


class CreateCreditCommonsignResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        apply_id: str = None,
        status: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 申请id
        self.apply_id = apply_id
        # 签约状态，-1:签约失败，0:未签约，1:已签约，2:签约中
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class QueryCreditCommonsignRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        product_id: str = None,
        group_platform_did: str = None,
        sign_did: str = None,
        apply_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 产品id
        self.product_id = product_id
        # 集团平台did
        self.group_platform_did = group_platform_did
        # 签约方did
        self.sign_did = sign_did
        # 申请id，不填则查询当前签约状态，填写则查询apply_id对应的签约申请结果
        self.apply_id = apply_id

    def validate(self):
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.sign_did, 'sign_did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.sign_did is not None:
            result['sign_did'] = self.sign_did
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('sign_did') is not None:
            self.sign_did = m.get('sign_did')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        return self


class QueryCreditCommonsignResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        status: int = None,
        query_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 签约结果，-1:签约失败，0:未签约，1:已签约，2:签约中
        self.status = status
        # 查询信息
        self.query_msg = query_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.status is not None:
            result['status'] = self.status
        if self.query_msg is not None:
            result['query_msg'] = self.query_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('query_msg') is not None:
            self.query_msg = m.get('query_msg')
        return self


class BatchcreateCreditIssueRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        product_id: str = None,
        group_platform_did: str = None,
        create_did: str = None,
        receive_did: str = None,
        batch_id: str = None,
        out_biz_no: str = None,
        pay_order: str = None,
        freight: str = None,
        easy_finance: bool = None,
        expire_date: str = None,
        callback_url: str = None,
        waybill_ids: List[str] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 产品id
        self.product_id = product_id
        # 集团平台did
        self.group_platform_did = group_platform_did
        # 凭证发行方分布式身份
        self.create_did = create_did
        # 凭证接收方分布式身份
        self.receive_did = receive_did
        # 批次id
        self.batch_id = batch_id
        # 全局业务唯一号
        self.out_biz_no = out_biz_no
        # 支付订单号
        self.pay_order = pay_order
        # 支付单运费总额，运费最多精确到小数点后2位
        self.freight = freight
        # 发行后自动贴现，true: 自动贴现，false: 不自动贴现 （默认）
        self.easy_finance = easy_finance
        # 凭证到期时间
        self.expire_date = expire_date
        # 发行结果回调地址
        self.callback_url = callback_url
        # 需合并发行的运单id列表
        self.waybill_ids = waybill_ids

    def validate(self):
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.create_did, 'create_did')
        self.validate_required(self.receive_did, 'receive_did')
        self.validate_required(self.batch_id, 'batch_id')
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.pay_order, 'pay_order')
        self.validate_required(self.freight, 'freight')
        self.validate_required(self.expire_date, 'expire_date')
        self.validate_required(self.callback_url, 'callback_url')
        self.validate_required(self.waybill_ids, 'waybill_ids')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.create_did is not None:
            result['create_did'] = self.create_did
        if self.receive_did is not None:
            result['receive_did'] = self.receive_did
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.pay_order is not None:
            result['pay_order'] = self.pay_order
        if self.freight is not None:
            result['freight'] = self.freight
        if self.easy_finance is not None:
            result['easy_finance'] = self.easy_finance
        if self.expire_date is not None:
            result['expire_date'] = self.expire_date
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.waybill_ids is not None:
            result['waybill_ids'] = self.waybill_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('create_did') is not None:
            self.create_did = m.get('create_did')
        if m.get('receive_did') is not None:
            self.receive_did = m.get('receive_did')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('pay_order') is not None:
            self.pay_order = m.get('pay_order')
        if m.get('freight') is not None:
            self.freight = m.get('freight')
        if m.get('easy_finance') is not None:
            self.easy_finance = m.get('easy_finance')
        if m.get('expire_date') is not None:
            self.expire_date = m.get('expire_date')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('waybill_ids') is not None:
            self.waybill_ids = m.get('waybill_ids')
        return self


class BatchcreateCreditIssueResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        batch_id: str = None,
        batch_status: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 批次id
        self.batch_id = batch_id
        # 批次状态
        self.batch_status = batch_status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.batch_status is not None:
            result['batch_status'] = self.batch_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('batch_status') is not None:
            self.batch_status = m.get('batch_status')
        return self


class UploadCreditIssuebatchRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        batch_id: str = None,
        callback_url: str = None,
        create_did: str = None,
        easy_finance: bool = None,
        expire_date: str = None,
        freight: str = None,
        group_platform_did: str = None,
        out_biz_no: str = None,
        pay_order: str = None,
        product_id: str = None,
        receive_did: str = None,
        waybill_ids: List[str] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 批次id
        self.batch_id = batch_id
        # 回调地址
        self.callback_url = callback_url
        # 凭证发行方did
        self.create_did = create_did
        # 发行后自动贴现，true: 自动贴现，false: 不自动贴现 （默认）
        self.easy_finance = easy_finance
        # 凭证到期时间
        self.expire_date = expire_date
        # 支付单运费总额，运费最多精确到小数点后2位
        self.freight = freight
        # 集团平台did
        self.group_platform_did = group_platform_did
        # 全局业务唯一编号
        self.out_biz_no = out_biz_no
        # 支付订单号
        self.pay_order = pay_order
        # 产品id
        self.product_id = product_id
        # 凭证接收方did
        self.receive_did = receive_did
        # 运单合并列表
        self.waybill_ids = waybill_ids

    def validate(self):
        self.validate_required(self.batch_id, 'batch_id')
        self.validate_required(self.callback_url, 'callback_url')
        self.validate_required(self.create_did, 'create_did')
        self.validate_required(self.expire_date, 'expire_date')
        self.validate_required(self.freight, 'freight')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.out_biz_no, 'out_biz_no')
        self.validate_required(self.pay_order, 'pay_order')
        self.validate_required(self.product_id, 'product_id')
        self.validate_required(self.receive_did, 'receive_did')
        self.validate_required(self.waybill_ids, 'waybill_ids')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.create_did is not None:
            result['create_did'] = self.create_did
        if self.easy_finance is not None:
            result['easy_finance'] = self.easy_finance
        if self.expire_date is not None:
            result['expire_date'] = self.expire_date
        if self.freight is not None:
            result['freight'] = self.freight
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.out_biz_no is not None:
            result['out_biz_no'] = self.out_biz_no
        if self.pay_order is not None:
            result['pay_order'] = self.pay_order
        if self.product_id is not None:
            result['product_id'] = self.product_id
        if self.receive_did is not None:
            result['receive_did'] = self.receive_did
        if self.waybill_ids is not None:
            result['waybill_ids'] = self.waybill_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('create_did') is not None:
            self.create_did = m.get('create_did')
        if m.get('easy_finance') is not None:
            self.easy_finance = m.get('easy_finance')
        if m.get('expire_date') is not None:
            self.expire_date = m.get('expire_date')
        if m.get('freight') is not None:
            self.freight = m.get('freight')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('out_biz_no') is not None:
            self.out_biz_no = m.get('out_biz_no')
        if m.get('pay_order') is not None:
            self.pay_order = m.get('pay_order')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        if m.get('receive_did') is not None:
            self.receive_did = m.get('receive_did')
        if m.get('waybill_ids') is not None:
            self.waybill_ids = m.get('waybill_ids')
        return self


class UploadCreditIssuebatchResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        batch_id: str = None,
        batch_status: int = None,
        issue_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 批次id
        self.batch_id = batch_id
        # 批次状态
        self.batch_status = batch_status
        # 发行链接
        self.issue_url = issue_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.batch_id is not None:
            result['batch_id'] = self.batch_id
        if self.batch_status is not None:
            result['batch_status'] = self.batch_status
        if self.issue_url is not None:
            result['issue_url'] = self.issue_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('batch_id') is not None:
            self.batch_id = m.get('batch_id')
        if m.get('batch_status') is not None:
            self.batch_status = m.get('batch_status')
        if m.get('issue_url') is not None:
            self.issue_url = m.get('issue_url')
        return self


class GetIssueTransferfileRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        apply_id: str = None,
        callback_url: str = None,
        group_platform_did: str = None,
        issue_transfer_datas: List[IssueTransferData] = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 申请唯一流水号
        self.apply_id = apply_id
        # 回调地址
        # 
        self.callback_url = callback_url
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 信用流转凭证集合，最大长度支持30
        self.issue_transfer_datas = issue_transfer_datas
        # 业务发起方分布式数字身份
        self.platform_did = platform_did
        # 产品id
        # 
        self.product_id = product_id

    def validate(self):
        self.validate_required(self.apply_id, 'apply_id')
        self.validate_required(self.callback_url, 'callback_url')
        self.validate_required(self.group_platform_did, 'group_platform_did')
        self.validate_required(self.issue_transfer_datas, 'issue_transfer_datas')
        if self.issue_transfer_datas:
            for k in self.issue_transfer_datas:
                if k:
                    k.validate()
        self.validate_required(self.platform_did, 'platform_did')
        self.validate_required(self.product_id, 'product_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.callback_url is not None:
            result['callback_url'] = self.callback_url
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        result['issue_transfer_datas'] = []
        if self.issue_transfer_datas is not None:
            for k in self.issue_transfer_datas:
                result['issue_transfer_datas'].append(k.to_map() if k else None)
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('callback_url') is not None:
            self.callback_url = m.get('callback_url')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        self.issue_transfer_datas = []
        if m.get('issue_transfer_datas') is not None:
            for k in m.get('issue_transfer_datas'):
                temp_model = IssueTransferData()
                self.issue_transfer_datas.append(temp_model.from_map(k))
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class GetIssueTransferfileResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        apply_id: str = None,
        group_platform_did: str = None,
        platform_did: str = None,
        product_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 申请唯一流水号
        self.apply_id = apply_id
        # 集团平台方分布式数字身份
        self.group_platform_did = group_platform_did
        # 业务发起方分布式数字身
        self.platform_did = platform_did
        # 产品id
        self.product_id = product_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.product_id is not None:
            result['product_id'] = self.product_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('product_id') is not None:
            self.product_id = m.get('product_id')
        return self


class ApplyInsurancepolicyZhonghuacaixianRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        bbr_addr: str = None,
        bbr_id_no: str = None,
        bbr_id_type: str = None,
        bbr_name: str = None,
        bbr_tel: str = None,
        carriage: str = None,
        car_go: str = None,
        cp_model: str = None,
        destination: str = None,
        driv_per: str = None,
        eff_date: str = None,
        engine_no: str = None,
        frame_no: str = None,
        group_platform_did: str = None,
        identify_period_end: str = None,
        identify_period_start: str = None,
        license_no: str = None,
        platform_did: str = None,
        run_no: str = None,
        start_place: str = None,
        tbr_addr: str = None,
        tbr_email: str = None,
        tbr_id_no: str = None,
        tbr_id_type: str = None,
        tbr_name: str = None,
        tbr_tel: str = None,
        term_date: str = None,
        ton_nage: str = None,
        trade_no: str = None,
        ts_car_go: str = None,
        waybill_id: str = None,
        weight: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 被保险人地址
        self.bbr_addr = bbr_addr
        # 被保险人证件号码
        self.bbr_id_no = bbr_id_no
        # 被保险人证件类型。按照如下值填写
        # 464001	身份证
        # 464002	护照
        # 464003	其他
        # 464004	组织机构代码
        # 464005	军人证
        # 464006	工商注册号码
        # 464007	统一社会信用代码
        # 464008	临时身份证
        # 464009	外国护照
        # 464010	中国人民武装警察身份证件
        # 464011	军官证
        # 464012	企业营业执照号码
        # 464013	统一社会信用代码（五证合一号码）
        # 464014	个体工商户营业执照号码
        # 464015	户口本
        # 464016	其他类境内个人身份有效证件
        # 464017	其他类境外个人身份有效证件
        # 464018	税务登记证
        # 464019	金融许可证号码
        # 464020	国家主管部门颁外国驻华机构批文号码
        # 464021	其他类境外机构代码
        self.bbr_id_type = bbr_id_type
        # 被保险人姓名
        self.bbr_name = bbr_name
        # 被保险人联系电话
        self.bbr_tel = bbr_tel
        # 运费,四舍五入精确到小数点两位。系统将根据运费和费率计算含税保费，计算的保费结果为四舍五入，精确到两位小数
        self.carriage = carriage
        # 货物名称
        self.car_go = car_go
        # 厂牌型号
        self.cp_model = cp_model
        # 目的地
        self.destination = destination
        # 行驶证车主
        self.driv_per = driv_per
        # 保险起期，精确到天；最短起保时间为次日0点，最长延时起保时间为次日0点后24h
        self.eff_date = eff_date
        # 发动机编号
        self.engine_no = engine_no
        # 车架号
        self.frame_no = frame_no
        # 运单所属集团分布式身份标识
        self.group_platform_did = group_platform_did
        # 投保人证件类型有效止期
        self.identify_period_end = identify_period_end
        # 投保人证件类型有效起期
        self.identify_period_start = identify_period_start
        # 车牌号码
        self.license_no = license_no
        # 运单所属平台分布式身份标识
        self.platform_did = platform_did
        # 运营证号
        self.run_no = run_no
        # 起运地
        self.start_place = start_place
        # 投保人地址
        self.tbr_addr = tbr_addr
        # 投保人邮箱
        self.tbr_email = tbr_email
        # 投保人证件号
        self.tbr_id_no = tbr_id_no
        # 投保人证件类型，按照如下状态进行填写
        # 464001	身份证
        # 464002	护照
        # 464003	其他
        # 464004	组织机构代码
        # 464005	军人证
        # 464006	工商注册号码
        # 464007	统一社会信用代码
        # 464008	临时身份证
        # 464009	外国护照
        # 464010	中国人民武装警察身份证件
        # 464011	军官证
        # 464012	企业营业执照号码
        # 464013	统一社会信用代码（五证合一号码）
        # 464014	个体工商户营业执照号码
        # 464015	户口本
        # 464016	其他类境内个人身份有效证件
        # 464017	其他类境外个人身份有效证件
        # 464018	税务登记证
        # 464019	金融许可证号码
        # 464020	国家主管部门颁外国驻华机构批文号码
        # 464021	其他类境外机构代码
        self.tbr_id_type = tbr_id_type
        # 投保人姓名
        self.tbr_name = tbr_name
        # 投保人联系电话
        self.tbr_tel = tbr_tel
        # 保险止期，保期时间间隔为1-30天。
        self.term_date = term_date
        # 吨位
        self.ton_nage = ton_nage
        # 交易流水号,全局唯一；格式为 yyyyMMdd+身份标识+其他编码。系统会根据该流水号做防重、幂等判断逻辑。当极端场景中，系统会返回处理中状态，客户端应该保持该流水号不变，并使用原来的请求再次发送请求，系统会根据幂等逻辑返回处理结果
        self.trade_no = trade_no
        # 运输货物
        self.ts_car_go = ts_car_go
        # 运单id。通过运单创建接口上传运单时指定的运单标识。系统会根据该标识查询运单相关信息做投保业务校验
        self.waybill_id = waybill_id
        # 重量
        self.weight = weight

    def validate(self):
        if self.bbr_addr is not None:
            self.validate_max_length(self.bbr_addr, 'bbr_addr', 80)
        self.validate_required(self.bbr_id_no, 'bbr_id_no')
        if self.bbr_id_no is not None:
            self.validate_max_length(self.bbr_id_no, 'bbr_id_no', 40)
        self.validate_required(self.bbr_id_type, 'bbr_id_type')
        if self.bbr_id_type is not None:
            self.validate_max_length(self.bbr_id_type, 'bbr_id_type', 40)
        self.validate_required(self.bbr_name, 'bbr_name')
        if self.bbr_name is not None:
            self.validate_max_length(self.bbr_name, 'bbr_name', 40)
        self.validate_required(self.bbr_tel, 'bbr_tel')
        if self.bbr_tel is not None:
            self.validate_max_length(self.bbr_tel, 'bbr_tel', 40)
        self.validate_required(self.carriage, 'carriage')
        if self.carriage is not None:
            self.validate_max_length(self.carriage, 'carriage', 20)
        self.validate_required(self.car_go, 'car_go')
        if self.car_go is not None:
            self.validate_max_length(self.car_go, 'car_go', 40)
        self.validate_required(self.cp_model, 'cp_model')
        if self.cp_model is not None:
            self.validate_max_length(self.cp_model, 'cp_model', 80)
        if self.destination is not None:
            self.validate_max_length(self.destination, 'destination', 200)
        self.validate_required(self.driv_per, 'driv_per')
        if self.driv_per is not None:
            self.validate_max_length(self.driv_per, 'driv_per', 40)
        self.validate_required(self.eff_date, 'eff_date')
        if self.eff_date is not None:
            self.validate_pattern(self.eff_date, 'eff_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.engine_no, 'engine_no')
        if self.engine_no is not None:
            self.validate_max_length(self.engine_no, 'engine_no', 40)
        self.validate_required(self.frame_no, 'frame_no')
        if self.frame_no is not None:
            self.validate_max_length(self.frame_no, 'frame_no', 40)
        self.validate_required(self.group_platform_did, 'group_platform_did')
        if self.group_platform_did is not None:
            self.validate_max_length(self.group_platform_did, 'group_platform_did', 80)
        if self.identify_period_end is not None:
            self.validate_pattern(self.identify_period_end, 'identify_period_end', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.identify_period_start is not None:
            self.validate_pattern(self.identify_period_start, 'identify_period_start', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.license_no, 'license_no')
        if self.license_no is not None:
            self.validate_max_length(self.license_no, 'license_no', 40)
        self.validate_required(self.platform_did, 'platform_did')
        if self.platform_did is not None:
            self.validate_max_length(self.platform_did, 'platform_did', 80)
        self.validate_required(self.run_no, 'run_no')
        if self.run_no is not None:
            self.validate_max_length(self.run_no, 'run_no', 40)
        if self.start_place is not None:
            self.validate_max_length(self.start_place, 'start_place', 200)
        if self.tbr_addr is not None:
            self.validate_max_length(self.tbr_addr, 'tbr_addr', 80)
        if self.tbr_email is not None:
            self.validate_max_length(self.tbr_email, 'tbr_email', 40)
        self.validate_required(self.tbr_id_no, 'tbr_id_no')
        if self.tbr_id_no is not None:
            self.validate_max_length(self.tbr_id_no, 'tbr_id_no', 40)
        self.validate_required(self.tbr_id_type, 'tbr_id_type')
        if self.tbr_id_type is not None:
            self.validate_max_length(self.tbr_id_type, 'tbr_id_type', 40)
        self.validate_required(self.tbr_name, 'tbr_name')
        if self.tbr_name is not None:
            self.validate_max_length(self.tbr_name, 'tbr_name', 40)
        self.validate_required(self.tbr_tel, 'tbr_tel')
        if self.tbr_tel is not None:
            self.validate_max_length(self.tbr_tel, 'tbr_tel', 40)
        self.validate_required(self.term_date, 'term_date')
        if self.term_date is not None:
            self.validate_pattern(self.term_date, 'term_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.ton_nage, 'ton_nage')
        if self.ton_nage is not None:
            self.validate_max_length(self.ton_nage, 'ton_nage', 20)
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 32)
        self.validate_required(self.ts_car_go, 'ts_car_go')
        if self.ts_car_go is not None:
            self.validate_max_length(self.ts_car_go, 'ts_car_go', 80)
        self.validate_required(self.waybill_id, 'waybill_id')
        if self.waybill_id is not None:
            self.validate_max_length(self.waybill_id, 'waybill_id', 128)
        if self.weight is not None:
            self.validate_max_length(self.weight, 'weight', 20)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.bbr_addr is not None:
            result['bbr_addr'] = self.bbr_addr
        if self.bbr_id_no is not None:
            result['bbr_id_no'] = self.bbr_id_no
        if self.bbr_id_type is not None:
            result['bbr_id_type'] = self.bbr_id_type
        if self.bbr_name is not None:
            result['bbr_name'] = self.bbr_name
        if self.bbr_tel is not None:
            result['bbr_tel'] = self.bbr_tel
        if self.carriage is not None:
            result['carriage'] = self.carriage
        if self.car_go is not None:
            result['car_go'] = self.car_go
        if self.cp_model is not None:
            result['cp_model'] = self.cp_model
        if self.destination is not None:
            result['destination'] = self.destination
        if self.driv_per is not None:
            result['driv_per'] = self.driv_per
        if self.eff_date is not None:
            result['eff_date'] = self.eff_date
        if self.engine_no is not None:
            result['engine_no'] = self.engine_no
        if self.frame_no is not None:
            result['frame_no'] = self.frame_no
        if self.group_platform_did is not None:
            result['group_platform_did'] = self.group_platform_did
        if self.identify_period_end is not None:
            result['identify_period_end'] = self.identify_period_end
        if self.identify_period_start is not None:
            result['identify_period_start'] = self.identify_period_start
        if self.license_no is not None:
            result['license_no'] = self.license_no
        if self.platform_did is not None:
            result['platform_did'] = self.platform_did
        if self.run_no is not None:
            result['run_no'] = self.run_no
        if self.start_place is not None:
            result['start_place'] = self.start_place
        if self.tbr_addr is not None:
            result['tbr_addr'] = self.tbr_addr
        if self.tbr_email is not None:
            result['tbr_email'] = self.tbr_email
        if self.tbr_id_no is not None:
            result['tbr_id_no'] = self.tbr_id_no
        if self.tbr_id_type is not None:
            result['tbr_id_type'] = self.tbr_id_type
        if self.tbr_name is not None:
            result['tbr_name'] = self.tbr_name
        if self.tbr_tel is not None:
            result['tbr_tel'] = self.tbr_tel
        if self.term_date is not None:
            result['term_date'] = self.term_date
        if self.ton_nage is not None:
            result['ton_nage'] = self.ton_nage
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.ts_car_go is not None:
            result['ts_car_go'] = self.ts_car_go
        if self.waybill_id is not None:
            result['waybill_id'] = self.waybill_id
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('bbr_addr') is not None:
            self.bbr_addr = m.get('bbr_addr')
        if m.get('bbr_id_no') is not None:
            self.bbr_id_no = m.get('bbr_id_no')
        if m.get('bbr_id_type') is not None:
            self.bbr_id_type = m.get('bbr_id_type')
        if m.get('bbr_name') is not None:
            self.bbr_name = m.get('bbr_name')
        if m.get('bbr_tel') is not None:
            self.bbr_tel = m.get('bbr_tel')
        if m.get('carriage') is not None:
            self.carriage = m.get('carriage')
        if m.get('car_go') is not None:
            self.car_go = m.get('car_go')
        if m.get('cp_model') is not None:
            self.cp_model = m.get('cp_model')
        if m.get('destination') is not None:
            self.destination = m.get('destination')
        if m.get('driv_per') is not None:
            self.driv_per = m.get('driv_per')
        if m.get('eff_date') is not None:
            self.eff_date = m.get('eff_date')
        if m.get('engine_no') is not None:
            self.engine_no = m.get('engine_no')
        if m.get('frame_no') is not None:
            self.frame_no = m.get('frame_no')
        if m.get('group_platform_did') is not None:
            self.group_platform_did = m.get('group_platform_did')
        if m.get('identify_period_end') is not None:
            self.identify_period_end = m.get('identify_period_end')
        if m.get('identify_period_start') is not None:
            self.identify_period_start = m.get('identify_period_start')
        if m.get('license_no') is not None:
            self.license_no = m.get('license_no')
        if m.get('platform_did') is not None:
            self.platform_did = m.get('platform_did')
        if m.get('run_no') is not None:
            self.run_no = m.get('run_no')
        if m.get('start_place') is not None:
            self.start_place = m.get('start_place')
        if m.get('tbr_addr') is not None:
            self.tbr_addr = m.get('tbr_addr')
        if m.get('tbr_email') is not None:
            self.tbr_email = m.get('tbr_email')
        if m.get('tbr_id_no') is not None:
            self.tbr_id_no = m.get('tbr_id_no')
        if m.get('tbr_id_type') is not None:
            self.tbr_id_type = m.get('tbr_id_type')
        if m.get('tbr_name') is not None:
            self.tbr_name = m.get('tbr_name')
        if m.get('tbr_tel') is not None:
            self.tbr_tel = m.get('tbr_tel')
        if m.get('term_date') is not None:
            self.term_date = m.get('term_date')
        if m.get('ton_nage') is not None:
            self.ton_nage = m.get('ton_nage')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('ts_car_go') is not None:
            self.ts_car_go = m.get('ts_car_go')
        if m.get('waybill_id') is not None:
            self.waybill_id = m.get('waybill_id')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class ApplyInsurancepolicyZhonghuacaixianResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        pol_no: str = None,
        pol_url: str = None,
        pre_mium: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 保单号
        self.pol_no = pol_no
        # 电子保单下载地址
        self.pol_url = pol_url
        # 含税保费
        self.pre_mium = pre_mium

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.pol_no is not None:
            result['pol_no'] = self.pol_no
        if self.pol_url is not None:
            result['pol_url'] = self.pol_url
        if self.pre_mium is not None:
            result['pre_mium'] = self.pre_mium
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('pol_no') is not None:
            self.pol_no = m.get('pol_no')
        if m.get('pol_url') is not None:
            self.pol_url = m.get('pol_url')
        if m.get('pre_mium') is not None:
            self.pre_mium = m.get('pre_mium')
        return self


class CancelInsurancepolicyZhonghuacaixianRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        pol_no: str = None,
        pre_mium: str = None,
        trade_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 保单号，投保成功后返回的
        self.pol_no = pol_no
        # 含税保费，精确到小数点后两位
        self.pre_mium = pre_mium
        # 全局唯一交易流水号
        self.trade_no = trade_no

    def validate(self):
        self.validate_required(self.pol_no, 'pol_no')
        if self.pol_no is not None:
            self.validate_max_length(self.pol_no, 'pol_no', 60)
        self.validate_required(self.pre_mium, 'pre_mium')
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 32)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.pol_no is not None:
            result['pol_no'] = self.pol_no
        if self.pre_mium is not None:
            result['pre_mium'] = self.pre_mium
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('pol_no') is not None:
            self.pol_no = m.get('pol_no')
        if m.get('pre_mium') is not None:
            self.pre_mium = m.get('pre_mium')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        return self


class CancelInsurancepolicyZhonghuacaixianResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        pol_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 退保成功的对应的保单号
        self.pol_no = pol_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.pol_no is not None:
            result['pol_no'] = self.pol_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('pol_no') is not None:
            self.pol_no = m.get('pol_no')
        return self


class PushInsurancenotifyClaimRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        category: str = None,
        content: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 通知类型：
        # claims_pay:理赔支付信息
        # claims_info: 理赔信息
        self.category = category
        # 通知内容
        self.content = content

    def validate(self):
        self.validate_required(self.category, 'category')
        if self.category is not None:
            self.validate_max_length(self.category, 'category', 16)
        self.validate_required(self.content, 'content')
        if self.content is not None:
            self.validate_max_length(self.content, 'content', 3000)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.category is not None:
            result['category'] = self.category
        if self.content is not None:
            result['content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('content') is not None:
            self.content = m.get('content')
        return self


class PushInsurancenotifyClaimResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 业务返回报文
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class ApplyInsuranceFileurlRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        file_name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 上传的文件名，要求文件名后缀必须以 _yyyyMMdd结尾
        self.file_name = file_name

    def validate(self):
        self.validate_required(self.file_name, 'file_name')
        if self.file_name is not None:
            self.validate_max_length(self.file_name, 'file_name', 80)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.file_name is not None:
            result['file_name'] = self.file_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        return self


class ApplyInsuranceFileurlResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        file_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 用于上传文件的连接
        self.file_url = file_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.file_url is not None:
            result['file_url'] = self.file_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('file_url') is not None:
            self.file_url = m.get('file_url')
        return self


class ApplyInsurancepolicyUniversalRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        account_bank_name: str = None,
        bank_account_information: str = None,
        bbr_addr: str = None,
        bbr_did: str = None,
        bbr_id_no: str = None,
        bbr_id_type: str = None,
        bbr_name: str = None,
        bbr_tel: str = None,
        bbr_type: str = None,
        cargo_name: str = None,
        cargo_quantity: str = None,
        cargo_quantity_unit: str = None,
        cargo_tonnage: str = None,
        cargo_type: str = None,
        cargo_volume: str = None,
        cargo_worth: str = None,
        car_length: str = None,
        car_model: str = None,
        destination: str = None,
        driver_name: str = None,
        driver_tel: str = None,
        eff_date: str = None,
        external_channel_code: str = None,
        external_product_code: str = None,
        frame_no: str = None,
        insured_amount: str = None,
        license_no: str = None,
        license_plate_color: str = None,
        nsr_identifier: str = None,
        order_time: str = None,
        packing: str = None,
        print_invoice: str = None,
        rate: str = None,
        start_place: str = None,
        tbr_addr: str = None,
        tbr_corporate_contract: str = None,
        tbr_did: str = None,
        tbr_email: str = None,
        tbr_id_no: str = None,
        tbr_id_type: str = None,
        tbr_name: str = None,
        tbr_tel: str = None,
        tbr_type: str = None,
        term_date: str = None,
        ticket_addr: str = None,
        trade_no: str = None,
        transit_point: str = None,
        waybill_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 投保人开户银行，当打印发票选择为“1”时，必填
        self.account_bank_name = account_bank_name
        # 投保人银行账户，当打印发票选择为“1”时，必填
        self.bank_account_information = bank_account_information
        # 被保人地址
        self.bbr_addr = bbr_addr
        # 被保人did（被保人所在链上分布式数字身份）
        self.bbr_did = bbr_did
        # 被保人证件号
        self.bbr_id_no = bbr_id_no
        # 被保人证件类型，01-居民身份证, 02-驾驶执照, 03-营业执照, 99-其他
        # 
        self.bbr_id_type = bbr_id_type
        # 被保人姓名
        self.bbr_name = bbr_name
        # 被保人电话号
        self.bbr_tel = bbr_tel
        # 被保人类型, 1-个人 2-团队
        self.bbr_type = bbr_type
        # 货物名称
        self.cargo_name = cargo_name
        # 货物数量
        self.cargo_quantity = cargo_quantity
        # 货物数量单位
        self.cargo_quantity_unit = cargo_quantity_unit
        # 货物吨位
        self.cargo_tonnage = cargo_tonnage
        # 货物类型，普货，手机/电子产品/家用电器，精密仪器，家具，易碎品，大宗散货，生鲜（瓜果蔬菜），棉纱
        self.cargo_type = cargo_type
        # 货物体积
        self.cargo_volume = cargo_volume
        # 货值
        self.cargo_worth = cargo_worth
        # 车长
        self.car_length = car_length
        # 车型
        self.car_model = car_model
        # 目的地，格式为"省-市-区"
        self.destination = destination
        # 司机姓名
        self.driver_name = driver_name
        # 司机联系方式
        self.driver_tel = driver_tel
        # 保险起始时间, 时间格式 "yyyy-MM-dd HH:mm:ss", 预计起运日期
        self.eff_date = eff_date
        # 保司, 01-华泰, 02-平安, 03-亚太
        self.external_channel_code = external_channel_code
        # 险种, 01-承运人平台责任险
        # 
        self.external_product_code = external_product_code
        # 车架号
        self.frame_no = frame_no
        # 投保额，整数以元为单位
        # 
        self.insured_amount = insured_amount
        # 车牌号
        self.license_no = license_no
        # 车牌颜色，01-黄牌，02-蓝牌
        self.license_plate_color = license_plate_color
        # 税务登记证/纳税人识别号，当打印发票选择为“1”时，必填
        self.nsr_identifier = nsr_identifier
        # 接单时间, 时间格式 "yyyy-MM-dd HH:mm:ss"
        self.order_time = order_time
        # 包装方式, 01-箱装、02-袋装、03-包装、04-桶装、05-捆扎包装、06-裸装、07-散装、08-其他包装
        self.packing = packing
        # 是否打印发票，默认0-不开票  1-专票 2-电子发票
        self.print_invoice = print_invoice
        # 费率，按实际业务商讨费率执行, 但最终结果以保司计算结果为准，0到1之间，最多6位小数
        self.rate = rate
        # 起运地，格式为"省-市-区"
        self.start_place = start_place
        # 投保人地址，当打印发票选择为“1”时，必填
        self.tbr_addr = tbr_addr
        # 投保人-企业联系人联系方式
        self.tbr_corporate_contract = tbr_corporate_contract
        # 投保人did（投保人所在链上分布式数字身份）
        self.tbr_did = tbr_did
        # 投保人邮箱，用以接受电子发票的邮箱地址
        self.tbr_email = tbr_email
        # 投保人证件号
        self.tbr_id_no = tbr_id_no
        # 投保人证件类型，01-居民身份证, 02-驾驶执照, 03-营业执照, 99-其他
        self.tbr_id_type = tbr_id_type
        # 投保人名称
        self.tbr_name = tbr_name
        # 投保人电话号
        self.tbr_tel = tbr_tel
        # 投保人类型, 1-个人 2-团队
        self.tbr_type = tbr_type
        # 保险截止时间, 时间格式 "yyyy-MM-dd HH:mm:ss", 预计到达日期，保险止期间隔为1-30天
        self.term_date = term_date
        # 专票邮寄地址
        self.ticket_addr = ticket_addr
        # 订单号, 年月日+唯一字符ID
        self.trade_no = trade_no
        # 中转地，格式为"省-市-区"
        self.transit_point = transit_point
        # 运单id（平台方运单id）
        self.waybill_id = waybill_id

    def validate(self):
        if self.account_bank_name is not None:
            self.validate_max_length(self.account_bank_name, 'account_bank_name', 100)
        if self.bank_account_information is not None:
            self.validate_max_length(self.bank_account_information, 'bank_account_information', 50)
        if self.bbr_addr is not None:
            self.validate_max_length(self.bbr_addr, 'bbr_addr', 200)
        if self.bbr_did is not None:
            self.validate_max_length(self.bbr_did, 'bbr_did', 200)
        self.validate_required(self.bbr_id_no, 'bbr_id_no')
        if self.bbr_id_no is not None:
            self.validate_max_length(self.bbr_id_no, 'bbr_id_no', 50)
        self.validate_required(self.bbr_id_type, 'bbr_id_type')
        if self.bbr_id_type is not None:
            self.validate_max_length(self.bbr_id_type, 'bbr_id_type', 2)
        self.validate_required(self.bbr_name, 'bbr_name')
        if self.bbr_name is not None:
            self.validate_max_length(self.bbr_name, 'bbr_name', 100)
        self.validate_required(self.bbr_tel, 'bbr_tel')
        if self.bbr_tel is not None:
            self.validate_max_length(self.bbr_tel, 'bbr_tel', 20)
        self.validate_required(self.bbr_type, 'bbr_type')
        if self.bbr_type is not None:
            self.validate_max_length(self.bbr_type, 'bbr_type', 1)
        if self.cargo_name is not None:
            self.validate_max_length(self.cargo_name, 'cargo_name', 100)
        self.validate_required(self.cargo_quantity, 'cargo_quantity')
        if self.cargo_quantity is not None:
            self.validate_max_length(self.cargo_quantity, 'cargo_quantity', 20)
        self.validate_required(self.cargo_quantity_unit, 'cargo_quantity_unit')
        if self.cargo_quantity_unit is not None:
            self.validate_max_length(self.cargo_quantity_unit, 'cargo_quantity_unit', 20)
        if self.cargo_tonnage is not None:
            self.validate_max_length(self.cargo_tonnage, 'cargo_tonnage', 20)
        self.validate_required(self.cargo_type, 'cargo_type')
        if self.cargo_type is not None:
            self.validate_max_length(self.cargo_type, 'cargo_type', 50)
        if self.cargo_volume is not None:
            self.validate_max_length(self.cargo_volume, 'cargo_volume', 20)
        self.validate_required(self.cargo_worth, 'cargo_worth')
        if self.cargo_worth is not None:
            self.validate_max_length(self.cargo_worth, 'cargo_worth', 50)
        if self.car_length is not None:
            self.validate_max_length(self.car_length, 'car_length', 10)
        if self.car_model is not None:
            self.validate_max_length(self.car_model, 'car_model', 20)
        self.validate_required(self.destination, 'destination')
        if self.destination is not None:
            self.validate_max_length(self.destination, 'destination', 100)
        self.validate_required(self.driver_name, 'driver_name')
        if self.driver_name is not None:
            self.validate_max_length(self.driver_name, 'driver_name', 50)
        self.validate_required(self.driver_tel, 'driver_tel')
        if self.driver_tel is not None:
            self.validate_max_length(self.driver_tel, 'driver_tel', 20)
        self.validate_required(self.eff_date, 'eff_date')
        if self.eff_date is not None:
            self.validate_pattern(self.eff_date, 'eff_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.external_channel_code, 'external_channel_code')
        if self.external_channel_code is not None:
            self.validate_max_length(self.external_channel_code, 'external_channel_code', 2)
        self.validate_required(self.external_product_code, 'external_product_code')
        if self.external_product_code is not None:
            self.validate_max_length(self.external_product_code, 'external_product_code', 2)
        if self.frame_no is not None:
            self.validate_max_length(self.frame_no, 'frame_no', 50)
        self.validate_required(self.insured_amount, 'insured_amount')
        if self.insured_amount is not None:
            self.validate_max_length(self.insured_amount, 'insured_amount', 12)
        self.validate_required(self.license_no, 'license_no')
        if self.license_no is not None:
            self.validate_max_length(self.license_no, 'license_no', 20)
        if self.license_plate_color is not None:
            self.validate_max_length(self.license_plate_color, 'license_plate_color', 2)
        if self.nsr_identifier is not None:
            self.validate_max_length(self.nsr_identifier, 'nsr_identifier', 50)
        self.validate_required(self.order_time, 'order_time')
        if self.order_time is not None:
            self.validate_pattern(self.order_time, 'order_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.packing is not None:
            self.validate_max_length(self.packing, 'packing', 100)
        self.validate_required(self.print_invoice, 'print_invoice')
        if self.print_invoice is not None:
            self.validate_max_length(self.print_invoice, 'print_invoice', 1)
        self.validate_required(self.rate, 'rate')
        if self.rate is not None:
            self.validate_max_length(self.rate, 'rate', 8)
        self.validate_required(self.start_place, 'start_place')
        if self.start_place is not None:
            self.validate_max_length(self.start_place, 'start_place', 100)
        if self.tbr_addr is not None:
            self.validate_max_length(self.tbr_addr, 'tbr_addr', 200)
        if self.tbr_corporate_contract is not None:
            self.validate_max_length(self.tbr_corporate_contract, 'tbr_corporate_contract', 20)
        if self.tbr_did is not None:
            self.validate_max_length(self.tbr_did, 'tbr_did', 200)
        if self.tbr_email is not None:
            self.validate_max_length(self.tbr_email, 'tbr_email', 50)
        self.validate_required(self.tbr_id_no, 'tbr_id_no')
        if self.tbr_id_no is not None:
            self.validate_max_length(self.tbr_id_no, 'tbr_id_no', 50)
        self.validate_required(self.tbr_id_type, 'tbr_id_type')
        if self.tbr_id_type is not None:
            self.validate_max_length(self.tbr_id_type, 'tbr_id_type', 2)
        self.validate_required(self.tbr_name, 'tbr_name')
        if self.tbr_name is not None:
            self.validate_max_length(self.tbr_name, 'tbr_name', 100)
        self.validate_required(self.tbr_tel, 'tbr_tel')
        if self.tbr_tel is not None:
            self.validate_max_length(self.tbr_tel, 'tbr_tel', 20)
        self.validate_required(self.tbr_type, 'tbr_type')
        if self.tbr_type is not None:
            self.validate_max_length(self.tbr_type, 'tbr_type', 1)
        self.validate_required(self.term_date, 'term_date')
        if self.term_date is not None:
            self.validate_pattern(self.term_date, 'term_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.ticket_addr is not None:
            self.validate_max_length(self.ticket_addr, 'ticket_addr', 200)
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 50)
        if self.transit_point is not None:
            self.validate_max_length(self.transit_point, 'transit_point', 100)
        self.validate_required(self.waybill_id, 'waybill_id')
        if self.waybill_id is not None:
            self.validate_max_length(self.waybill_id, 'waybill_id', 50)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.account_bank_name is not None:
            result['account_bank_name'] = self.account_bank_name
        if self.bank_account_information is not None:
            result['bank_account_information'] = self.bank_account_information
        if self.bbr_addr is not None:
            result['bbr_addr'] = self.bbr_addr
        if self.bbr_did is not None:
            result['bbr_did'] = self.bbr_did
        if self.bbr_id_no is not None:
            result['bbr_id_no'] = self.bbr_id_no
        if self.bbr_id_type is not None:
            result['bbr_id_type'] = self.bbr_id_type
        if self.bbr_name is not None:
            result['bbr_name'] = self.bbr_name
        if self.bbr_tel is not None:
            result['bbr_tel'] = self.bbr_tel
        if self.bbr_type is not None:
            result['bbr_type'] = self.bbr_type
        if self.cargo_name is not None:
            result['cargo_name'] = self.cargo_name
        if self.cargo_quantity is not None:
            result['cargo_quantity'] = self.cargo_quantity
        if self.cargo_quantity_unit is not None:
            result['cargo_quantity_unit'] = self.cargo_quantity_unit
        if self.cargo_tonnage is not None:
            result['cargo_tonnage'] = self.cargo_tonnage
        if self.cargo_type is not None:
            result['cargo_type'] = self.cargo_type
        if self.cargo_volume is not None:
            result['cargo_volume'] = self.cargo_volume
        if self.cargo_worth is not None:
            result['cargo_worth'] = self.cargo_worth
        if self.car_length is not None:
            result['car_length'] = self.car_length
        if self.car_model is not None:
            result['car_model'] = self.car_model
        if self.destination is not None:
            result['destination'] = self.destination
        if self.driver_name is not None:
            result['driver_name'] = self.driver_name
        if self.driver_tel is not None:
            result['driver_tel'] = self.driver_tel
        if self.eff_date is not None:
            result['eff_date'] = self.eff_date
        if self.external_channel_code is not None:
            result['external_channel_code'] = self.external_channel_code
        if self.external_product_code is not None:
            result['external_product_code'] = self.external_product_code
        if self.frame_no is not None:
            result['frame_no'] = self.frame_no
        if self.insured_amount is not None:
            result['insured_amount'] = self.insured_amount
        if self.license_no is not None:
            result['license_no'] = self.license_no
        if self.license_plate_color is not None:
            result['license_plate_color'] = self.license_plate_color
        if self.nsr_identifier is not None:
            result['nsr_identifier'] = self.nsr_identifier
        if self.order_time is not None:
            result['order_time'] = self.order_time
        if self.packing is not None:
            result['packing'] = self.packing
        if self.print_invoice is not None:
            result['print_invoice'] = self.print_invoice
        if self.rate is not None:
            result['rate'] = self.rate
        if self.start_place is not None:
            result['start_place'] = self.start_place
        if self.tbr_addr is not None:
            result['tbr_addr'] = self.tbr_addr
        if self.tbr_corporate_contract is not None:
            result['tbr_corporate_contract'] = self.tbr_corporate_contract
        if self.tbr_did is not None:
            result['tbr_did'] = self.tbr_did
        if self.tbr_email is not None:
            result['tbr_email'] = self.tbr_email
        if self.tbr_id_no is not None:
            result['tbr_id_no'] = self.tbr_id_no
        if self.tbr_id_type is not None:
            result['tbr_id_type'] = self.tbr_id_type
        if self.tbr_name is not None:
            result['tbr_name'] = self.tbr_name
        if self.tbr_tel is not None:
            result['tbr_tel'] = self.tbr_tel
        if self.tbr_type is not None:
            result['tbr_type'] = self.tbr_type
        if self.term_date is not None:
            result['term_date'] = self.term_date
        if self.ticket_addr is not None:
            result['ticket_addr'] = self.ticket_addr
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.transit_point is not None:
            result['transit_point'] = self.transit_point
        if self.waybill_id is not None:
            result['waybill_id'] = self.waybill_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('account_bank_name') is not None:
            self.account_bank_name = m.get('account_bank_name')
        if m.get('bank_account_information') is not None:
            self.bank_account_information = m.get('bank_account_information')
        if m.get('bbr_addr') is not None:
            self.bbr_addr = m.get('bbr_addr')
        if m.get('bbr_did') is not None:
            self.bbr_did = m.get('bbr_did')
        if m.get('bbr_id_no') is not None:
            self.bbr_id_no = m.get('bbr_id_no')
        if m.get('bbr_id_type') is not None:
            self.bbr_id_type = m.get('bbr_id_type')
        if m.get('bbr_name') is not None:
            self.bbr_name = m.get('bbr_name')
        if m.get('bbr_tel') is not None:
            self.bbr_tel = m.get('bbr_tel')
        if m.get('bbr_type') is not None:
            self.bbr_type = m.get('bbr_type')
        if m.get('cargo_name') is not None:
            self.cargo_name = m.get('cargo_name')
        if m.get('cargo_quantity') is not None:
            self.cargo_quantity = m.get('cargo_quantity')
        if m.get('cargo_quantity_unit') is not None:
            self.cargo_quantity_unit = m.get('cargo_quantity_unit')
        if m.get('cargo_tonnage') is not None:
            self.cargo_tonnage = m.get('cargo_tonnage')
        if m.get('cargo_type') is not None:
            self.cargo_type = m.get('cargo_type')
        if m.get('cargo_volume') is not None:
            self.cargo_volume = m.get('cargo_volume')
        if m.get('cargo_worth') is not None:
            self.cargo_worth = m.get('cargo_worth')
        if m.get('car_length') is not None:
            self.car_length = m.get('car_length')
        if m.get('car_model') is not None:
            self.car_model = m.get('car_model')
        if m.get('destination') is not None:
            self.destination = m.get('destination')
        if m.get('driver_name') is not None:
            self.driver_name = m.get('driver_name')
        if m.get('driver_tel') is not None:
            self.driver_tel = m.get('driver_tel')
        if m.get('eff_date') is not None:
            self.eff_date = m.get('eff_date')
        if m.get('external_channel_code') is not None:
            self.external_channel_code = m.get('external_channel_code')
        if m.get('external_product_code') is not None:
            self.external_product_code = m.get('external_product_code')
        if m.get('frame_no') is not None:
            self.frame_no = m.get('frame_no')
        if m.get('insured_amount') is not None:
            self.insured_amount = m.get('insured_amount')
        if m.get('license_no') is not None:
            self.license_no = m.get('license_no')
        if m.get('license_plate_color') is not None:
            self.license_plate_color = m.get('license_plate_color')
        if m.get('nsr_identifier') is not None:
            self.nsr_identifier = m.get('nsr_identifier')
        if m.get('order_time') is not None:
            self.order_time = m.get('order_time')
        if m.get('packing') is not None:
            self.packing = m.get('packing')
        if m.get('print_invoice') is not None:
            self.print_invoice = m.get('print_invoice')
        if m.get('rate') is not None:
            self.rate = m.get('rate')
        if m.get('start_place') is not None:
            self.start_place = m.get('start_place')
        if m.get('tbr_addr') is not None:
            self.tbr_addr = m.get('tbr_addr')
        if m.get('tbr_corporate_contract') is not None:
            self.tbr_corporate_contract = m.get('tbr_corporate_contract')
        if m.get('tbr_did') is not None:
            self.tbr_did = m.get('tbr_did')
        if m.get('tbr_email') is not None:
            self.tbr_email = m.get('tbr_email')
        if m.get('tbr_id_no') is not None:
            self.tbr_id_no = m.get('tbr_id_no')
        if m.get('tbr_id_type') is not None:
            self.tbr_id_type = m.get('tbr_id_type')
        if m.get('tbr_name') is not None:
            self.tbr_name = m.get('tbr_name')
        if m.get('tbr_tel') is not None:
            self.tbr_tel = m.get('tbr_tel')
        if m.get('tbr_type') is not None:
            self.tbr_type = m.get('tbr_type')
        if m.get('term_date') is not None:
            self.term_date = m.get('term_date')
        if m.get('ticket_addr') is not None:
            self.ticket_addr = m.get('ticket_addr')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('transit_point') is not None:
            self.transit_point = m.get('transit_point')
        if m.get('waybill_id') is not None:
            self.waybill_id = m.get('waybill_id')
        return self


class ApplyInsurancepolicyUniversalResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        pol_no: str = None,
        pol_url: str = None,
        total_premium: str = None,
        trade_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 保单号
        self.pol_no = pol_no
        # 电子保单下载地址
        self.pol_url = pol_url
        # 总保费
        self.total_premium = total_premium
        # 订单号
        self.trade_no = trade_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.pol_no is not None:
            result['pol_no'] = self.pol_no
        if self.pol_url is not None:
            result['pol_url'] = self.pol_url
        if self.total_premium is not None:
            result['total_premium'] = self.total_premium
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('pol_no') is not None:
            self.pol_no = m.get('pol_no')
        if m.get('pol_url') is not None:
            self.pol_url = m.get('pol_url')
        if m.get('total_premium') is not None:
            self.total_premium = m.get('total_premium')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        return self


class CancelInsurancepolicyUniversalRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        apply_trade_no: str = None,
        external_channel_code: str = None,
        external_product_code: str = None,
        pol_no: str = None,
        trade_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 投保订单号
        self.apply_trade_no = apply_trade_no
        # 保司, 01-华泰, 03-亚太
        self.external_channel_code = external_channel_code
        # 险种, 01-承运人平台责任险
        # 
        self.external_product_code = external_product_code
        # 保单号
        self.pol_no = pol_no
        # 退保全局唯一流水号
        self.trade_no = trade_no

    def validate(self):
        self.validate_required(self.apply_trade_no, 'apply_trade_no')
        if self.apply_trade_no is not None:
            self.validate_max_length(self.apply_trade_no, 'apply_trade_no', 50)
        self.validate_required(self.external_channel_code, 'external_channel_code')
        if self.external_channel_code is not None:
            self.validate_max_length(self.external_channel_code, 'external_channel_code', 2)
        self.validate_required(self.external_product_code, 'external_product_code')
        if self.external_product_code is not None:
            self.validate_max_length(self.external_product_code, 'external_product_code', 2)
        self.validate_required(self.pol_no, 'pol_no')
        if self.pol_no is not None:
            self.validate_max_length(self.pol_no, 'pol_no', 50)
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 50)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.apply_trade_no is not None:
            result['apply_trade_no'] = self.apply_trade_no
        if self.external_channel_code is not None:
            result['external_channel_code'] = self.external_channel_code
        if self.external_product_code is not None:
            result['external_product_code'] = self.external_product_code
        if self.pol_no is not None:
            result['pol_no'] = self.pol_no
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('apply_trade_no') is not None:
            self.apply_trade_no = m.get('apply_trade_no')
        if m.get('external_channel_code') is not None:
            self.external_channel_code = m.get('external_channel_code')
        if m.get('external_product_code') is not None:
            self.external_product_code = m.get('external_product_code')
        if m.get('pol_no') is not None:
            self.pol_no = m.get('pol_no')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        return self


class CancelInsurancepolicyUniversalResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        apply_trade_no: str = None,
        pol_no: str = None,
        send_back_premium: str = None,
        success_surrender_time: str = None,
        surrender_effective_time: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 投保订单号
        self.apply_trade_no = apply_trade_no
        # 保单号
        self.pol_no = pol_no
        # 退还保费
        self.send_back_premium = send_back_premium
        # 成功退保时间, 时间格式 "yyyy-MM-dd HH:mm:ss"
        self.success_surrender_time = success_surrender_time
        # 退保生效时间, 时间格式 "yyyy-MM-dd HH:mm:ss"
        self.surrender_effective_time = surrender_effective_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.apply_trade_no is not None:
            result['apply_trade_no'] = self.apply_trade_no
        if self.pol_no is not None:
            result['pol_no'] = self.pol_no
        if self.send_back_premium is not None:
            result['send_back_premium'] = self.send_back_premium
        if self.success_surrender_time is not None:
            result['success_surrender_time'] = self.success_surrender_time
        if self.surrender_effective_time is not None:
            result['surrender_effective_time'] = self.surrender_effective_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('apply_trade_no') is not None:
            self.apply_trade_no = m.get('apply_trade_no')
        if m.get('pol_no') is not None:
            self.pol_no = m.get('pol_no')
        if m.get('send_back_premium') is not None:
            self.send_back_premium = m.get('send_back_premium')
        if m.get('success_surrender_time') is not None:
            self.success_surrender_time = m.get('success_surrender_time')
        if m.get('surrender_effective_time') is not None:
            self.surrender_effective_time = m.get('surrender_effective_time')
        return self


class PushInsuranceOlpRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        bbr_id_no: str = None,
        bbr_name: str = None,
        bbr_type: str = None,
        channel_code: str = None,
        channel_name: str = None,
        claim_status: str = None,
        insure_date: str = None,
        insure_end: str = None,
        insure_start: str = None,
        platform_consumer_code: str = None,
        platform_consumer_name: str = None,
        pol_file_ids: str = None,
        pol_no: str = None,
        pol_status: str = None,
        pol_url: str = None,
        premium: str = None,
        product_code: str = None,
        product_name: str = None,
        surrender_time: str = None,
        tbr_id_no: str = None,
        tbr_name: str = None,
        tbr_type: str = None,
        trade_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 被保人证件号
        self.bbr_id_no = bbr_id_no
        # 被保人名称
        self.bbr_name = bbr_name
        # 被保人类型, 1-个人 2-企业
        # 
        self.bbr_type = bbr_type
        # 保险公司编码
        self.channel_code = channel_code
        # 保险公司名称
        self.channel_name = channel_name
        # 理赔单状态，ALREADY_RISK: 已出险，NOT_RISK: 未出险，CLAIMED: 已理赔
        self.claim_status = claim_status
        # 投保时间
        self.insure_date = insure_date
        # 保险止期
        self.insure_end = insure_end
        # 保险起期
        self.insure_start = insure_start
        # 存证平台编码
        self.platform_consumer_code = platform_consumer_code
        # 存证平台名称
        self.platform_consumer_name = platform_consumer_name
        # 保单文件id，可支持多个，逗号隔开
        self.pol_file_ids = pol_file_ids
        # 保单号
        self.pol_no = pol_no
        # 保单状态，INSURED: 已投保，SURRENDERED: 已退保,
        self.pol_status = pol_status
        # 电子保单url地址
        self.pol_url = pol_url
        # 保费
        self.premium = premium
        # 险种代码
        self.product_code = product_code
        # 险种名称
        self.product_name = product_name
        # 退保时间
        self.surrender_time = surrender_time
        # 投保人证件号
        self.tbr_id_no = tbr_id_no
        # 投保人名称
        self.tbr_name = tbr_name
        # 投保人类型, 1-个人 2-企业
        self.tbr_type = tbr_type
        # 交易流水号
        self.trade_no = trade_no

    def validate(self):
        self.validate_required(self.bbr_id_no, 'bbr_id_no')
        if self.bbr_id_no is not None:
            self.validate_max_length(self.bbr_id_no, 'bbr_id_no', 50)
        self.validate_required(self.bbr_name, 'bbr_name')
        if self.bbr_name is not None:
            self.validate_max_length(self.bbr_name, 'bbr_name', 100)
        self.validate_required(self.bbr_type, 'bbr_type')
        if self.bbr_type is not None:
            self.validate_max_length(self.bbr_type, 'bbr_type', 10)
        self.validate_required(self.channel_code, 'channel_code')
        if self.channel_code is not None:
            self.validate_max_length(self.channel_code, 'channel_code', 50)
        self.validate_required(self.channel_name, 'channel_name')
        if self.channel_name is not None:
            self.validate_max_length(self.channel_name, 'channel_name', 100)
        self.validate_required(self.claim_status, 'claim_status')
        if self.claim_status is not None:
            self.validate_max_length(self.claim_status, 'claim_status', 12)
        self.validate_required(self.insure_date, 'insure_date')
        if self.insure_date is not None:
            self.validate_pattern(self.insure_date, 'insure_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.insure_end is not None:
            self.validate_pattern(self.insure_end, 'insure_end', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.insure_start is not None:
            self.validate_pattern(self.insure_start, 'insure_start', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.platform_consumer_code, 'platform_consumer_code')
        if self.platform_consumer_code is not None:
            self.validate_max_length(self.platform_consumer_code, 'platform_consumer_code', 50)
        self.validate_required(self.platform_consumer_name, 'platform_consumer_name')
        if self.platform_consumer_name is not None:
            self.validate_max_length(self.platform_consumer_name, 'platform_consumer_name', 100)
        if self.pol_file_ids is not None:
            self.validate_max_length(self.pol_file_ids, 'pol_file_ids', 3200)
        self.validate_required(self.pol_no, 'pol_no')
        if self.pol_no is not None:
            self.validate_max_length(self.pol_no, 'pol_no', 100)
        self.validate_required(self.pol_status, 'pol_status')
        if self.pol_status is not None:
            self.validate_max_length(self.pol_status, 'pol_status', 12)
        if self.pol_url is not None:
            self.validate_max_length(self.pol_url, 'pol_url', 500)
        self.validate_required(self.premium, 'premium')
        if self.premium is not None:
            self.validate_max_length(self.premium, 'premium', 20)
        self.validate_required(self.product_code, 'product_code')
        if self.product_code is not None:
            self.validate_max_length(self.product_code, 'product_code', 50)
        self.validate_required(self.product_name, 'product_name')
        if self.product_name is not None:
            self.validate_max_length(self.product_name, 'product_name', 100)
        if self.surrender_time is not None:
            self.validate_pattern(self.surrender_time, 'surrender_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.tbr_id_no, 'tbr_id_no')
        if self.tbr_id_no is not None:
            self.validate_max_length(self.tbr_id_no, 'tbr_id_no', 50)
        self.validate_required(self.tbr_name, 'tbr_name')
        if self.tbr_name is not None:
            self.validate_max_length(self.tbr_name, 'tbr_name', 100)
        self.validate_required(self.tbr_type, 'tbr_type')
        if self.tbr_type is not None:
            self.validate_max_length(self.tbr_type, 'tbr_type', 10)
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 200)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.bbr_id_no is not None:
            result['bbr_id_no'] = self.bbr_id_no
        if self.bbr_name is not None:
            result['bbr_name'] = self.bbr_name
        if self.bbr_type is not None:
            result['bbr_type'] = self.bbr_type
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        if self.channel_name is not None:
            result['channel_name'] = self.channel_name
        if self.claim_status is not None:
            result['claim_status'] = self.claim_status
        if self.insure_date is not None:
            result['insure_date'] = self.insure_date
        if self.insure_end is not None:
            result['insure_end'] = self.insure_end
        if self.insure_start is not None:
            result['insure_start'] = self.insure_start
        if self.platform_consumer_code is not None:
            result['platform_consumer_code'] = self.platform_consumer_code
        if self.platform_consumer_name is not None:
            result['platform_consumer_name'] = self.platform_consumer_name
        if self.pol_file_ids is not None:
            result['pol_file_ids'] = self.pol_file_ids
        if self.pol_no is not None:
            result['pol_no'] = self.pol_no
        if self.pol_status is not None:
            result['pol_status'] = self.pol_status
        if self.pol_url is not None:
            result['pol_url'] = self.pol_url
        if self.premium is not None:
            result['premium'] = self.premium
        if self.product_code is not None:
            result['product_code'] = self.product_code
        if self.product_name is not None:
            result['product_name'] = self.product_name
        if self.surrender_time is not None:
            result['surrender_time'] = self.surrender_time
        if self.tbr_id_no is not None:
            result['tbr_id_no'] = self.tbr_id_no
        if self.tbr_name is not None:
            result['tbr_name'] = self.tbr_name
        if self.tbr_type is not None:
            result['tbr_type'] = self.tbr_type
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('bbr_id_no') is not None:
            self.bbr_id_no = m.get('bbr_id_no')
        if m.get('bbr_name') is not None:
            self.bbr_name = m.get('bbr_name')
        if m.get('bbr_type') is not None:
            self.bbr_type = m.get('bbr_type')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        if m.get('channel_name') is not None:
            self.channel_name = m.get('channel_name')
        if m.get('claim_status') is not None:
            self.claim_status = m.get('claim_status')
        if m.get('insure_date') is not None:
            self.insure_date = m.get('insure_date')
        if m.get('insure_end') is not None:
            self.insure_end = m.get('insure_end')
        if m.get('insure_start') is not None:
            self.insure_start = m.get('insure_start')
        if m.get('platform_consumer_code') is not None:
            self.platform_consumer_code = m.get('platform_consumer_code')
        if m.get('platform_consumer_name') is not None:
            self.platform_consumer_name = m.get('platform_consumer_name')
        if m.get('pol_file_ids') is not None:
            self.pol_file_ids = m.get('pol_file_ids')
        if m.get('pol_no') is not None:
            self.pol_no = m.get('pol_no')
        if m.get('pol_status') is not None:
            self.pol_status = m.get('pol_status')
        if m.get('pol_url') is not None:
            self.pol_url = m.get('pol_url')
        if m.get('premium') is not None:
            self.premium = m.get('premium')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        if m.get('product_name') is not None:
            self.product_name = m.get('product_name')
        if m.get('surrender_time') is not None:
            self.surrender_time = m.get('surrender_time')
        if m.get('tbr_id_no') is not None:
            self.tbr_id_no = m.get('tbr_id_no')
        if m.get('tbr_name') is not None:
            self.tbr_name = m.get('tbr_name')
        if m.get('tbr_type') is not None:
            self.tbr_type = m.get('tbr_type')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        return self


class PushInsuranceOlpResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class UpdateInsuranceOlpRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        bbr_id_no: str = None,
        bbr_name: str = None,
        bbr_type: str = None,
        channel_code: str = None,
        channel_name: str = None,
        claim_status: str = None,
        insure_date: str = None,
        insure_end: str = None,
        insure_start: str = None,
        platform_consumer_code: str = None,
        platform_consumer_name: str = None,
        pol_file_ids: str = None,
        pol_no: str = None,
        pol_status: str = None,
        pol_url: str = None,
        premium: str = None,
        product_code: str = None,
        product_name: str = None,
        surrender_time: str = None,
        tbr_id_no: str = None,
        tbr_name: str = None,
        tbr_type: str = None,
        trade_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 被保人证件号
        self.bbr_id_no = bbr_id_no
        # 被保人名称
        self.bbr_name = bbr_name
        # 被保人类型, 1-个人 2-企业
        self.bbr_type = bbr_type
        # 保险公司编码
        self.channel_code = channel_code
        # 保险公司名称
        self.channel_name = channel_name
        # 理赔单状态，ALREADY_RISK: 已出险，NOT_RISK: 未出险，CLAIMED: 已理赔
        self.claim_status = claim_status
        # 投保时间
        self.insure_date = insure_date
        # 保险止期
        self.insure_end = insure_end
        # 保险起期
        self.insure_start = insure_start
        # 存证平台编码
        self.platform_consumer_code = platform_consumer_code
        # 存证平台名称
        self.platform_consumer_name = platform_consumer_name
        # 保单文件id，可支持多个，逗号隔开
        self.pol_file_ids = pol_file_ids
        # 保单号
        self.pol_no = pol_no
        # 保单状态，INSURED: 已投保，SURRENDERED: 已退保,
        self.pol_status = pol_status
        # 电子保单url地址
        self.pol_url = pol_url
        # 保费
        # 
        self.premium = premium
        # 险种代码
        # 
        self.product_code = product_code
        # 险种名称
        # 
        self.product_name = product_name
        # 退保时间
        self.surrender_time = surrender_time
        # 投保人证件号
        self.tbr_id_no = tbr_id_no
        # 投保人名称
        self.tbr_name = tbr_name
        # 投保人类型, 1-个人 2-企业
        self.tbr_type = tbr_type
        # 交易流水号
        self.trade_no = trade_no

    def validate(self):
        if self.bbr_id_no is not None:
            self.validate_max_length(self.bbr_id_no, 'bbr_id_no', 50)
        if self.bbr_name is not None:
            self.validate_max_length(self.bbr_name, 'bbr_name', 100)
        if self.bbr_type is not None:
            self.validate_max_length(self.bbr_type, 'bbr_type', 10)
        if self.channel_code is not None:
            self.validate_max_length(self.channel_code, 'channel_code', 50)
        if self.channel_name is not None:
            self.validate_max_length(self.channel_name, 'channel_name', 100)
        if self.claim_status is not None:
            self.validate_max_length(self.claim_status, 'claim_status', 12)
        if self.insure_date is not None:
            self.validate_pattern(self.insure_date, 'insure_date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.insure_end is not None:
            self.validate_pattern(self.insure_end, 'insure_end', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.insure_start is not None:
            self.validate_pattern(self.insure_start, 'insure_start', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.platform_consumer_code, 'platform_consumer_code')
        if self.platform_consumer_code is not None:
            self.validate_max_length(self.platform_consumer_code, 'platform_consumer_code', 50)
        if self.platform_consumer_name is not None:
            self.validate_max_length(self.platform_consumer_name, 'platform_consumer_name', 100)
        if self.pol_file_ids is not None:
            self.validate_max_length(self.pol_file_ids, 'pol_file_ids', 3200)
        self.validate_required(self.pol_no, 'pol_no')
        if self.pol_no is not None:
            self.validate_max_length(self.pol_no, 'pol_no', 100)
        if self.pol_status is not None:
            self.validate_max_length(self.pol_status, 'pol_status', 12)
        if self.pol_url is not None:
            self.validate_max_length(self.pol_url, 'pol_url', 500)
        if self.premium is not None:
            self.validate_max_length(self.premium, 'premium', 20)
        if self.product_code is not None:
            self.validate_max_length(self.product_code, 'product_code', 50)
        if self.product_name is not None:
            self.validate_max_length(self.product_name, 'product_name', 100)
        if self.surrender_time is not None:
            self.validate_pattern(self.surrender_time, 'surrender_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.tbr_id_no is not None:
            self.validate_max_length(self.tbr_id_no, 'tbr_id_no', 50)
        if self.tbr_name is not None:
            self.validate_max_length(self.tbr_name, 'tbr_name', 100)
        if self.tbr_type is not None:
            self.validate_max_length(self.tbr_type, 'tbr_type', 10)
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 200)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.bbr_id_no is not None:
            result['bbr_id_no'] = self.bbr_id_no
        if self.bbr_name is not None:
            result['bbr_name'] = self.bbr_name
        if self.bbr_type is not None:
            result['bbr_type'] = self.bbr_type
        if self.channel_code is not None:
            result['channel_code'] = self.channel_code
        if self.channel_name is not None:
            result['channel_name'] = self.channel_name
        if self.claim_status is not None:
            result['claim_status'] = self.claim_status
        if self.insure_date is not None:
            result['insure_date'] = self.insure_date
        if self.insure_end is not None:
            result['insure_end'] = self.insure_end
        if self.insure_start is not None:
            result['insure_start'] = self.insure_start
        if self.platform_consumer_code is not None:
            result['platform_consumer_code'] = self.platform_consumer_code
        if self.platform_consumer_name is not None:
            result['platform_consumer_name'] = self.platform_consumer_name
        if self.pol_file_ids is not None:
            result['pol_file_ids'] = self.pol_file_ids
        if self.pol_no is not None:
            result['pol_no'] = self.pol_no
        if self.pol_status is not None:
            result['pol_status'] = self.pol_status
        if self.pol_url is not None:
            result['pol_url'] = self.pol_url
        if self.premium is not None:
            result['premium'] = self.premium
        if self.product_code is not None:
            result['product_code'] = self.product_code
        if self.product_name is not None:
            result['product_name'] = self.product_name
        if self.surrender_time is not None:
            result['surrender_time'] = self.surrender_time
        if self.tbr_id_no is not None:
            result['tbr_id_no'] = self.tbr_id_no
        if self.tbr_name is not None:
            result['tbr_name'] = self.tbr_name
        if self.tbr_type is not None:
            result['tbr_type'] = self.tbr_type
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('bbr_id_no') is not None:
            self.bbr_id_no = m.get('bbr_id_no')
        if m.get('bbr_name') is not None:
            self.bbr_name = m.get('bbr_name')
        if m.get('bbr_type') is not None:
            self.bbr_type = m.get('bbr_type')
        if m.get('channel_code') is not None:
            self.channel_code = m.get('channel_code')
        if m.get('channel_name') is not None:
            self.channel_name = m.get('channel_name')
        if m.get('claim_status') is not None:
            self.claim_status = m.get('claim_status')
        if m.get('insure_date') is not None:
            self.insure_date = m.get('insure_date')
        if m.get('insure_end') is not None:
            self.insure_end = m.get('insure_end')
        if m.get('insure_start') is not None:
            self.insure_start = m.get('insure_start')
        if m.get('platform_consumer_code') is not None:
            self.platform_consumer_code = m.get('platform_consumer_code')
        if m.get('platform_consumer_name') is not None:
            self.platform_consumer_name = m.get('platform_consumer_name')
        if m.get('pol_file_ids') is not None:
            self.pol_file_ids = m.get('pol_file_ids')
        if m.get('pol_no') is not None:
            self.pol_no = m.get('pol_no')
        if m.get('pol_status') is not None:
            self.pol_status = m.get('pol_status')
        if m.get('pol_url') is not None:
            self.pol_url = m.get('pol_url')
        if m.get('premium') is not None:
            self.premium = m.get('premium')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        if m.get('product_name') is not None:
            self.product_name = m.get('product_name')
        if m.get('surrender_time') is not None:
            self.surrender_time = m.get('surrender_time')
        if m.get('tbr_id_no') is not None:
            self.tbr_id_no = m.get('tbr_id_no')
        if m.get('tbr_name') is not None:
            self.tbr_name = m.get('tbr_name')
        if m.get('tbr_type') is not None:
            self.tbr_type = m.get('tbr_type')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        return self


class UpdateInsuranceOlpResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class PushInsuranceReppolicyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        platform_code: str = None,
        direct_insurer_name: str = None,
        pol_no: str = None,
        joint_insurance_logo: str = None,
        joint_insurance_rate: str = None,
        product_code: str = None,
        product_name: str = None,
        bbr_name: str = None,
        insure_start: str = None,
        insure_end: str = None,
        currency: str = None,
        premium: str = None,
        insurance_amount: str = None,
        fixed_insurance_amount_split_rate: str = None,
        fixed_premium_split_rate: str = None,
        facultative_insurance_amount_split_rate: str = None,
        facultative_premium_split_rate: str = None,
        split_premium: str = None,
        reinsurer: str = None,
        amortize_fee_rate: str = None,
        amortize_fee: str = None,
        reinsurance_contract_name: str = None,
        over_pay_facultative: str = None,
        project_name: str = None,
        receiver_platform_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 直保人租户ID
        self.platform_code = platform_code
        # 直保人
        self.direct_insurer_name = direct_insurer_name
        # 保单号
        self.pol_no = pol_no
        # 共保标志，1:是 0:否
        self.joint_insurance_logo = joint_insurance_logo
        # 共保比例（%）
        self.joint_insurance_rate = joint_insurance_rate
        # 险种代码
        self.product_code = product_code
        # 险种名称
        self.product_name = product_name
        # 被保险人
        self.bbr_name = bbr_name
        # 保险起期
        self.insure_start = insure_start
        # 保险止期
        self.insure_end = insure_end
        # 币种，CNY:人民币, USD:美元，JPY:日元，HKD:港元，EUR:欧元，GBP英镑
        self.currency = currency
        # 保费
        self.premium = premium
        # 保额
        self.insurance_amount = insurance_amount
        # 固定保额分出比例（%）
        self.fixed_insurance_amount_split_rate = fixed_insurance_amount_split_rate
        # 固定保费分出比例（%）
        self.fixed_premium_split_rate = fixed_premium_split_rate
        # 临分保额分出比例（%）
        self.facultative_insurance_amount_split_rate = facultative_insurance_amount_split_rate
        # 临分保费分出比例（%）
        self.facultative_premium_split_rate = facultative_premium_split_rate
        # 分出保费
        self.split_premium = split_premium
        # 再保人
        self.reinsurer = reinsurer
        # 摊回手续费比例（%）
        self.amortize_fee_rate = amortize_fee_rate
        # 摊回手续费
        self.amortize_fee = amortize_fee
        # 再保合同名称
        self.reinsurance_contract_name = reinsurance_contract_name
        # 是否有超赔临分，1:是 0:否
        self.over_pay_facultative = over_pay_facultative
        # 项目名称
        self.project_name = project_name
        # 接收方租户id
        self.receiver_platform_id = receiver_platform_id

    def validate(self):
        self.validate_required(self.platform_code, 'platform_code')
        if self.platform_code is not None:
            self.validate_max_length(self.platform_code, 'platform_code', 50)
        self.validate_required(self.direct_insurer_name, 'direct_insurer_name')
        if self.direct_insurer_name is not None:
            self.validate_max_length(self.direct_insurer_name, 'direct_insurer_name', 200)
        self.validate_required(self.pol_no, 'pol_no')
        if self.pol_no is not None:
            self.validate_max_length(self.pol_no, 'pol_no', 100)
        if self.joint_insurance_logo is not None:
            self.validate_max_length(self.joint_insurance_logo, 'joint_insurance_logo', 5)
        if self.joint_insurance_rate is not None:
            self.validate_max_length(self.joint_insurance_rate, 'joint_insurance_rate', 5)
        self.validate_required(self.product_code, 'product_code')
        if self.product_code is not None:
            self.validate_max_length(self.product_code, 'product_code', 20)
        self.validate_required(self.product_name, 'product_name')
        if self.product_name is not None:
            self.validate_max_length(self.product_name, 'product_name', 100)
        self.validate_required(self.bbr_name, 'bbr_name')
        if self.bbr_name is not None:
            self.validate_max_length(self.bbr_name, 'bbr_name', 200)
        self.validate_required(self.insure_start, 'insure_start')
        if self.insure_start is not None:
            self.validate_pattern(self.insure_start, 'insure_start', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.insure_end, 'insure_end')
        if self.insure_end is not None:
            self.validate_pattern(self.insure_end, 'insure_end', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.currency, 'currency')
        if self.currency is not None:
            self.validate_max_length(self.currency, 'currency', 10)
        self.validate_required(self.premium, 'premium')
        if self.premium is not None:
            self.validate_max_length(self.premium, 'premium', 20)
        if self.insurance_amount is not None:
            self.validate_max_length(self.insurance_amount, 'insurance_amount', 20)
        if self.fixed_insurance_amount_split_rate is not None:
            self.validate_max_length(self.fixed_insurance_amount_split_rate, 'fixed_insurance_amount_split_rate', 5)
        self.validate_required(self.fixed_premium_split_rate, 'fixed_premium_split_rate')
        if self.fixed_premium_split_rate is not None:
            self.validate_max_length(self.fixed_premium_split_rate, 'fixed_premium_split_rate', 5)
        if self.facultative_insurance_amount_split_rate is not None:
            self.validate_max_length(self.facultative_insurance_amount_split_rate, 'facultative_insurance_amount_split_rate', 5)
        self.validate_required(self.facultative_premium_split_rate, 'facultative_premium_split_rate')
        if self.facultative_premium_split_rate is not None:
            self.validate_max_length(self.facultative_premium_split_rate, 'facultative_premium_split_rate', 5)
        self.validate_required(self.split_premium, 'split_premium')
        if self.split_premium is not None:
            self.validate_max_length(self.split_premium, 'split_premium', 20)
        self.validate_required(self.reinsurer, 'reinsurer')
        if self.reinsurer is not None:
            self.validate_max_length(self.reinsurer, 'reinsurer', 100)
        self.validate_required(self.amortize_fee_rate, 'amortize_fee_rate')
        if self.amortize_fee_rate is not None:
            self.validate_max_length(self.amortize_fee_rate, 'amortize_fee_rate', 5)
        self.validate_required(self.amortize_fee, 'amortize_fee')
        if self.amortize_fee is not None:
            self.validate_max_length(self.amortize_fee, 'amortize_fee', 20)
        if self.reinsurance_contract_name is not None:
            self.validate_max_length(self.reinsurance_contract_name, 'reinsurance_contract_name', 200)
        if self.over_pay_facultative is not None:
            self.validate_max_length(self.over_pay_facultative, 'over_pay_facultative', 5)
        if self.project_name is not None:
            self.validate_max_length(self.project_name, 'project_name', 100)
        self.validate_required(self.receiver_platform_id, 'receiver_platform_id')
        if self.receiver_platform_id is not None:
            self.validate_max_length(self.receiver_platform_id, 'receiver_platform_id', 50)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.platform_code is not None:
            result['platform_code'] = self.platform_code
        if self.direct_insurer_name is not None:
            result['direct_insurer_name'] = self.direct_insurer_name
        if self.pol_no is not None:
            result['pol_no'] = self.pol_no
        if self.joint_insurance_logo is not None:
            result['joint_insurance_logo'] = self.joint_insurance_logo
        if self.joint_insurance_rate is not None:
            result['joint_insurance_rate'] = self.joint_insurance_rate
        if self.product_code is not None:
            result['product_code'] = self.product_code
        if self.product_name is not None:
            result['product_name'] = self.product_name
        if self.bbr_name is not None:
            result['bbr_name'] = self.bbr_name
        if self.insure_start is not None:
            result['insure_start'] = self.insure_start
        if self.insure_end is not None:
            result['insure_end'] = self.insure_end
        if self.currency is not None:
            result['currency'] = self.currency
        if self.premium is not None:
            result['premium'] = self.premium
        if self.insurance_amount is not None:
            result['insurance_amount'] = self.insurance_amount
        if self.fixed_insurance_amount_split_rate is not None:
            result['fixed_insurance_amount_split_rate'] = self.fixed_insurance_amount_split_rate
        if self.fixed_premium_split_rate is not None:
            result['fixed_premium_split_rate'] = self.fixed_premium_split_rate
        if self.facultative_insurance_amount_split_rate is not None:
            result['facultative_insurance_amount_split_rate'] = self.facultative_insurance_amount_split_rate
        if self.facultative_premium_split_rate is not None:
            result['facultative_premium_split_rate'] = self.facultative_premium_split_rate
        if self.split_premium is not None:
            result['split_premium'] = self.split_premium
        if self.reinsurer is not None:
            result['reinsurer'] = self.reinsurer
        if self.amortize_fee_rate is not None:
            result['amortize_fee_rate'] = self.amortize_fee_rate
        if self.amortize_fee is not None:
            result['amortize_fee'] = self.amortize_fee
        if self.reinsurance_contract_name is not None:
            result['reinsurance_contract_name'] = self.reinsurance_contract_name
        if self.over_pay_facultative is not None:
            result['over_pay_facultative'] = self.over_pay_facultative
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.receiver_platform_id is not None:
            result['receiver_platform_id'] = self.receiver_platform_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('platform_code') is not None:
            self.platform_code = m.get('platform_code')
        if m.get('direct_insurer_name') is not None:
            self.direct_insurer_name = m.get('direct_insurer_name')
        if m.get('pol_no') is not None:
            self.pol_no = m.get('pol_no')
        if m.get('joint_insurance_logo') is not None:
            self.joint_insurance_logo = m.get('joint_insurance_logo')
        if m.get('joint_insurance_rate') is not None:
            self.joint_insurance_rate = m.get('joint_insurance_rate')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        if m.get('product_name') is not None:
            self.product_name = m.get('product_name')
        if m.get('bbr_name') is not None:
            self.bbr_name = m.get('bbr_name')
        if m.get('insure_start') is not None:
            self.insure_start = m.get('insure_start')
        if m.get('insure_end') is not None:
            self.insure_end = m.get('insure_end')
        if m.get('currency') is not None:
            self.currency = m.get('currency')
        if m.get('premium') is not None:
            self.premium = m.get('premium')
        if m.get('insurance_amount') is not None:
            self.insurance_amount = m.get('insurance_amount')
        if m.get('fixed_insurance_amount_split_rate') is not None:
            self.fixed_insurance_amount_split_rate = m.get('fixed_insurance_amount_split_rate')
        if m.get('fixed_premium_split_rate') is not None:
            self.fixed_premium_split_rate = m.get('fixed_premium_split_rate')
        if m.get('facultative_insurance_amount_split_rate') is not None:
            self.facultative_insurance_amount_split_rate = m.get('facultative_insurance_amount_split_rate')
        if m.get('facultative_premium_split_rate') is not None:
            self.facultative_premium_split_rate = m.get('facultative_premium_split_rate')
        if m.get('split_premium') is not None:
            self.split_premium = m.get('split_premium')
        if m.get('reinsurer') is not None:
            self.reinsurer = m.get('reinsurer')
        if m.get('amortize_fee_rate') is not None:
            self.amortize_fee_rate = m.get('amortize_fee_rate')
        if m.get('amortize_fee') is not None:
            self.amortize_fee = m.get('amortize_fee')
        if m.get('reinsurance_contract_name') is not None:
            self.reinsurance_contract_name = m.get('reinsurance_contract_name')
        if m.get('over_pay_facultative') is not None:
            self.over_pay_facultative = m.get('over_pay_facultative')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('receiver_platform_id') is not None:
            self.receiver_platform_id = m.get('receiver_platform_id')
        return self


class PushInsuranceReppolicyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class PushInsuranceRepcorrectRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        platform_code: str = None,
        direct_insurer_name: str = None,
        approval_type: str = None,
        approval_no: str = None,
        pol_no: str = None,
        joint_insurance_logo: str = None,
        joint_insurance_rate: str = None,
        product_code: str = None,
        product_name: str = None,
        bbr_name: str = None,
        insure_start: str = None,
        insure_end: str = None,
        currency: str = None,
        insurance_amount: str = None,
        correct_premium: str = None,
        fixed_insurance_amount_split_rate: str = None,
        fixed_premium_split_rate: str = None,
        facultative_insurance_amount_split_rate: str = None,
        facultative_premium_split_rate: str = None,
        split_premium: str = None,
        reinsurer: str = None,
        amortize_fee_rate: str = None,
        amortize_fee: str = None,
        reinsurance_contract_name: str = None,
        over_pay_facultative: str = None,
        correct_reason: str = None,
        project_name: str = None,
        receiver_platform_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 直保人租户ID
        self.platform_code = platform_code
        # 直保人
        self.direct_insurer_name = direct_insurer_name
        # 批单类型 1:批增 2: 批减
        self.approval_type = approval_type
        # 批单号
        self.approval_no = approval_no
        # 保单号
        self.pol_no = pol_no
        # 共保标志，1:是 0:否
        # 
        self.joint_insurance_logo = joint_insurance_logo
        # 共保比例（%）
        self.joint_insurance_rate = joint_insurance_rate
        # 险种代码
        self.product_code = product_code
        # 险种名称
        # 
        self.product_name = product_name
        # 被保险人
        self.bbr_name = bbr_name
        # 保险起期
        self.insure_start = insure_start
        # 保险止期
        # 
        self.insure_end = insure_end
        # 币种，CNY:人民币, USD:美元，JPY:日元，HKD:港元，EUR:欧元，GBP英镑
        self.currency = currency
        # 保额
        self.insurance_amount = insurance_amount
        # 批改保费
        self.correct_premium = correct_premium
        # 固定保额分出比例（%）
        self.fixed_insurance_amount_split_rate = fixed_insurance_amount_split_rate
        # 固定保费分出比例（%）
        self.fixed_premium_split_rate = fixed_premium_split_rate
        # 临分保额分出比例（%）
        self.facultative_insurance_amount_split_rate = facultative_insurance_amount_split_rate
        # 临分保费分出比例（%）
        self.facultative_premium_split_rate = facultative_premium_split_rate
        # 分出保费
        self.split_premium = split_premium
        # 再保人
        # 
        self.reinsurer = reinsurer
        # 摊回手续费比例（%）
        self.amortize_fee_rate = amortize_fee_rate
        # 摊回手续费
        # 
        self.amortize_fee = amortize_fee
        # 再保合同名称
        self.reinsurance_contract_name = reinsurance_contract_name
        # 是否有超赔临分，1:是 0:否
        self.over_pay_facultative = over_pay_facultative
        # 批改原因
        # 
        self.correct_reason = correct_reason
        # 项目名称
        self.project_name = project_name
        # 接收方租户id
        # 
        self.receiver_platform_id = receiver_platform_id

    def validate(self):
        self.validate_required(self.platform_code, 'platform_code')
        if self.platform_code is not None:
            self.validate_max_length(self.platform_code, 'platform_code', 50)
        self.validate_required(self.direct_insurer_name, 'direct_insurer_name')
        if self.direct_insurer_name is not None:
            self.validate_max_length(self.direct_insurer_name, 'direct_insurer_name', 200)
        self.validate_required(self.approval_type, 'approval_type')
        if self.approval_type is not None:
            self.validate_max_length(self.approval_type, 'approval_type', 20)
        self.validate_required(self.approval_no, 'approval_no')
        if self.approval_no is not None:
            self.validate_max_length(self.approval_no, 'approval_no', 100)
        self.validate_required(self.pol_no, 'pol_no')
        if self.pol_no is not None:
            self.validate_max_length(self.pol_no, 'pol_no', 100)
        if self.joint_insurance_logo is not None:
            self.validate_max_length(self.joint_insurance_logo, 'joint_insurance_logo', 5)
        if self.joint_insurance_rate is not None:
            self.validate_max_length(self.joint_insurance_rate, 'joint_insurance_rate', 5)
        self.validate_required(self.product_code, 'product_code')
        if self.product_code is not None:
            self.validate_max_length(self.product_code, 'product_code', 20)
        self.validate_required(self.product_name, 'product_name')
        if self.product_name is not None:
            self.validate_max_length(self.product_name, 'product_name', 100)
        self.validate_required(self.bbr_name, 'bbr_name')
        if self.bbr_name is not None:
            self.validate_max_length(self.bbr_name, 'bbr_name', 200)
        self.validate_required(self.insure_start, 'insure_start')
        if self.insure_start is not None:
            self.validate_pattern(self.insure_start, 'insure_start', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.insure_end, 'insure_end')
        if self.insure_end is not None:
            self.validate_pattern(self.insure_end, 'insure_end', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.currency, 'currency')
        if self.currency is not None:
            self.validate_max_length(self.currency, 'currency', 10)
        if self.insurance_amount is not None:
            self.validate_max_length(self.insurance_amount, 'insurance_amount', 20)
        self.validate_required(self.correct_premium, 'correct_premium')
        if self.correct_premium is not None:
            self.validate_max_length(self.correct_premium, 'correct_premium', 20)
        if self.fixed_insurance_amount_split_rate is not None:
            self.validate_max_length(self.fixed_insurance_amount_split_rate, 'fixed_insurance_amount_split_rate', 5)
        self.validate_required(self.fixed_premium_split_rate, 'fixed_premium_split_rate')
        if self.fixed_premium_split_rate is not None:
            self.validate_max_length(self.fixed_premium_split_rate, 'fixed_premium_split_rate', 5)
        if self.facultative_insurance_amount_split_rate is not None:
            self.validate_max_length(self.facultative_insurance_amount_split_rate, 'facultative_insurance_amount_split_rate', 5)
        self.validate_required(self.facultative_premium_split_rate, 'facultative_premium_split_rate')
        if self.facultative_premium_split_rate is not None:
            self.validate_max_length(self.facultative_premium_split_rate, 'facultative_premium_split_rate', 5)
        self.validate_required(self.split_premium, 'split_premium')
        if self.split_premium is not None:
            self.validate_max_length(self.split_premium, 'split_premium', 20)
        self.validate_required(self.reinsurer, 'reinsurer')
        if self.reinsurer is not None:
            self.validate_max_length(self.reinsurer, 'reinsurer', 100)
        self.validate_required(self.amortize_fee_rate, 'amortize_fee_rate')
        if self.amortize_fee_rate is not None:
            self.validate_max_length(self.amortize_fee_rate, 'amortize_fee_rate', 5)
        self.validate_required(self.amortize_fee, 'amortize_fee')
        if self.amortize_fee is not None:
            self.validate_max_length(self.amortize_fee, 'amortize_fee', 20)
        if self.reinsurance_contract_name is not None:
            self.validate_max_length(self.reinsurance_contract_name, 'reinsurance_contract_name', 200)
        if self.over_pay_facultative is not None:
            self.validate_max_length(self.over_pay_facultative, 'over_pay_facultative', 5)
        if self.correct_reason is not None:
            self.validate_max_length(self.correct_reason, 'correct_reason', 500)
        if self.project_name is not None:
            self.validate_max_length(self.project_name, 'project_name', 100)
        self.validate_required(self.receiver_platform_id, 'receiver_platform_id')
        if self.receiver_platform_id is not None:
            self.validate_max_length(self.receiver_platform_id, 'receiver_platform_id', 50)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.platform_code is not None:
            result['platform_code'] = self.platform_code
        if self.direct_insurer_name is not None:
            result['direct_insurer_name'] = self.direct_insurer_name
        if self.approval_type is not None:
            result['approval_type'] = self.approval_type
        if self.approval_no is not None:
            result['approval_no'] = self.approval_no
        if self.pol_no is not None:
            result['pol_no'] = self.pol_no
        if self.joint_insurance_logo is not None:
            result['joint_insurance_logo'] = self.joint_insurance_logo
        if self.joint_insurance_rate is not None:
            result['joint_insurance_rate'] = self.joint_insurance_rate
        if self.product_code is not None:
            result['product_code'] = self.product_code
        if self.product_name is not None:
            result['product_name'] = self.product_name
        if self.bbr_name is not None:
            result['bbr_name'] = self.bbr_name
        if self.insure_start is not None:
            result['insure_start'] = self.insure_start
        if self.insure_end is not None:
            result['insure_end'] = self.insure_end
        if self.currency is not None:
            result['currency'] = self.currency
        if self.insurance_amount is not None:
            result['insurance_amount'] = self.insurance_amount
        if self.correct_premium is not None:
            result['correct_premium'] = self.correct_premium
        if self.fixed_insurance_amount_split_rate is not None:
            result['fixed_insurance_amount_split_rate'] = self.fixed_insurance_amount_split_rate
        if self.fixed_premium_split_rate is not None:
            result['fixed_premium_split_rate'] = self.fixed_premium_split_rate
        if self.facultative_insurance_amount_split_rate is not None:
            result['facultative_insurance_amount_split_rate'] = self.facultative_insurance_amount_split_rate
        if self.facultative_premium_split_rate is not None:
            result['facultative_premium_split_rate'] = self.facultative_premium_split_rate
        if self.split_premium is not None:
            result['split_premium'] = self.split_premium
        if self.reinsurer is not None:
            result['reinsurer'] = self.reinsurer
        if self.amortize_fee_rate is not None:
            result['amortize_fee_rate'] = self.amortize_fee_rate
        if self.amortize_fee is not None:
            result['amortize_fee'] = self.amortize_fee
        if self.reinsurance_contract_name is not None:
            result['reinsurance_contract_name'] = self.reinsurance_contract_name
        if self.over_pay_facultative is not None:
            result['over_pay_facultative'] = self.over_pay_facultative
        if self.correct_reason is not None:
            result['correct_reason'] = self.correct_reason
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.receiver_platform_id is not None:
            result['receiver_platform_id'] = self.receiver_platform_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('platform_code') is not None:
            self.platform_code = m.get('platform_code')
        if m.get('direct_insurer_name') is not None:
            self.direct_insurer_name = m.get('direct_insurer_name')
        if m.get('approval_type') is not None:
            self.approval_type = m.get('approval_type')
        if m.get('approval_no') is not None:
            self.approval_no = m.get('approval_no')
        if m.get('pol_no') is not None:
            self.pol_no = m.get('pol_no')
        if m.get('joint_insurance_logo') is not None:
            self.joint_insurance_logo = m.get('joint_insurance_logo')
        if m.get('joint_insurance_rate') is not None:
            self.joint_insurance_rate = m.get('joint_insurance_rate')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        if m.get('product_name') is not None:
            self.product_name = m.get('product_name')
        if m.get('bbr_name') is not None:
            self.bbr_name = m.get('bbr_name')
        if m.get('insure_start') is not None:
            self.insure_start = m.get('insure_start')
        if m.get('insure_end') is not None:
            self.insure_end = m.get('insure_end')
        if m.get('currency') is not None:
            self.currency = m.get('currency')
        if m.get('insurance_amount') is not None:
            self.insurance_amount = m.get('insurance_amount')
        if m.get('correct_premium') is not None:
            self.correct_premium = m.get('correct_premium')
        if m.get('fixed_insurance_amount_split_rate') is not None:
            self.fixed_insurance_amount_split_rate = m.get('fixed_insurance_amount_split_rate')
        if m.get('fixed_premium_split_rate') is not None:
            self.fixed_premium_split_rate = m.get('fixed_premium_split_rate')
        if m.get('facultative_insurance_amount_split_rate') is not None:
            self.facultative_insurance_amount_split_rate = m.get('facultative_insurance_amount_split_rate')
        if m.get('facultative_premium_split_rate') is not None:
            self.facultative_premium_split_rate = m.get('facultative_premium_split_rate')
        if m.get('split_premium') is not None:
            self.split_premium = m.get('split_premium')
        if m.get('reinsurer') is not None:
            self.reinsurer = m.get('reinsurer')
        if m.get('amortize_fee_rate') is not None:
            self.amortize_fee_rate = m.get('amortize_fee_rate')
        if m.get('amortize_fee') is not None:
            self.amortize_fee = m.get('amortize_fee')
        if m.get('reinsurance_contract_name') is not None:
            self.reinsurance_contract_name = m.get('reinsurance_contract_name')
        if m.get('over_pay_facultative') is not None:
            self.over_pay_facultative = m.get('over_pay_facultative')
        if m.get('correct_reason') is not None:
            self.correct_reason = m.get('correct_reason')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('receiver_platform_id') is not None:
            self.receiver_platform_id = m.get('receiver_platform_id')
        return self


class PushInsuranceRepcorrectResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回状态
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class ApplyInsuranceCbrfRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        business_id: str = None,
        insurance_code: str = None,
        product_code: str = None,
        insurance_start: str = None,
        delivery_time: str = None,
        related_oder_no: str = None,
        dest_country: str = None,
        business_merchant_id: str = None,
        collection_time: str = None,
        good_name: str = None,
        good_value: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 物流公司业务线的简称
        self.business_id = business_id
        # 保司编码
        self.insurance_code = insurance_code
        # 险种编码
        self.product_code = product_code
        # 起保时间
        self.insurance_start = insurance_start
        # 交付航司确认时间
        self.delivery_time = delivery_time
        # 客户订单编号
        self.related_oder_no = related_oder_no
        # 目的国，2位iso缩写
        self.dest_country = dest_country
        # 商家唯一脱敏的编码
        self.business_merchant_id = business_merchant_id
        # 货物的揽收时间
        self.collection_time = collection_time
        # 货物名称
        self.good_name = good_name
        # 货值(美金)，货物的美金商品价值
        self.good_value = good_value

    def validate(self):
        if self.business_id is not None:
            self.validate_max_length(self.business_id, 'business_id', 30)
        self.validate_required(self.insurance_code, 'insurance_code')
        if self.insurance_code is not None:
            self.validate_max_length(self.insurance_code, 'insurance_code', 8)
        self.validate_required(self.product_code, 'product_code')
        if self.product_code is not None:
            self.validate_max_length(self.product_code, 'product_code', 2)
        self.validate_required(self.insurance_start, 'insurance_start')
        if self.insurance_start is not None:
            self.validate_pattern(self.insurance_start, 'insurance_start', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.delivery_time, 'delivery_time')
        if self.delivery_time is not None:
            self.validate_pattern(self.delivery_time, 'delivery_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.related_oder_no, 'related_oder_no')
        if self.related_oder_no is not None:
            self.validate_max_length(self.related_oder_no, 'related_oder_no', 256)
        self.validate_required(self.dest_country, 'dest_country')
        if self.dest_country is not None:
            self.validate_max_length(self.dest_country, 'dest_country', 256)
        if self.business_merchant_id is not None:
            self.validate_max_length(self.business_merchant_id, 'business_merchant_id', 256)
        if self.collection_time is not None:
            self.validate_max_length(self.collection_time, 'collection_time', 50)
        if self.good_name is not None:
            self.validate_max_length(self.good_name, 'good_name', 200)
        if self.good_value is not None:
            self.validate_max_length(self.good_value, 'good_value', 50)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.business_id is not None:
            result['business_id'] = self.business_id
        if self.insurance_code is not None:
            result['insurance_code'] = self.insurance_code
        if self.product_code is not None:
            result['product_code'] = self.product_code
        if self.insurance_start is not None:
            result['insurance_start'] = self.insurance_start
        if self.delivery_time is not None:
            result['delivery_time'] = self.delivery_time
        if self.related_oder_no is not None:
            result['related_oder_no'] = self.related_oder_no
        if self.dest_country is not None:
            result['dest_country'] = self.dest_country
        if self.business_merchant_id is not None:
            result['business_merchant_id'] = self.business_merchant_id
        if self.collection_time is not None:
            result['collection_time'] = self.collection_time
        if self.good_name is not None:
            result['good_name'] = self.good_name
        if self.good_value is not None:
            result['good_value'] = self.good_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('business_id') is not None:
            self.business_id = m.get('business_id')
        if m.get('insurance_code') is not None:
            self.insurance_code = m.get('insurance_code')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        if m.get('insurance_start') is not None:
            self.insurance_start = m.get('insurance_start')
        if m.get('delivery_time') is not None:
            self.delivery_time = m.get('delivery_time')
        if m.get('related_oder_no') is not None:
            self.related_oder_no = m.get('related_oder_no')
        if m.get('dest_country') is not None:
            self.dest_country = m.get('dest_country')
        if m.get('business_merchant_id') is not None:
            self.business_merchant_id = m.get('business_merchant_id')
        if m.get('collection_time') is not None:
            self.collection_time = m.get('collection_time')
        if m.get('good_name') is not None:
            self.good_name = m.get('good_name')
        if m.get('good_value') is not None:
            self.good_value = m.get('good_value')
        return self


class ApplyInsuranceCbrfResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        insured_receipt_no: str = None,
        related_order_no: str = None,
        policy_no: str = None,
        response_time: str = None,
        idem_flag: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 投保响应编码
        self.insured_receipt_no = insured_receipt_no
        # 投保时的标的订单号
        self.related_order_no = related_order_no
        # 保司出具的保单编号
        self.policy_no = policy_no
        # 返回时间
        self.response_time = response_time
        # 幂等标识；true:幂等结果；false: 非幂等结果
        self.idem_flag = idem_flag

    def validate(self):
        if self.response_time is not None:
            self.validate_pattern(self.response_time, 'response_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.insured_receipt_no is not None:
            result['insured_receipt_no'] = self.insured_receipt_no
        if self.related_order_no is not None:
            result['related_order_no'] = self.related_order_no
        if self.policy_no is not None:
            result['policy_no'] = self.policy_no
        if self.response_time is not None:
            result['response_time'] = self.response_time
        if self.idem_flag is not None:
            result['idem_flag'] = self.idem_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('insured_receipt_no') is not None:
            self.insured_receipt_no = m.get('insured_receipt_no')
        if m.get('related_order_no') is not None:
            self.related_order_no = m.get('related_order_no')
        if m.get('policy_no') is not None:
            self.policy_no = m.get('policy_no')
        if m.get('response_time') is not None:
            self.response_time = m.get('response_time')
        if m.get('idem_flag') is not None:
            self.idem_flag = m.get('idem_flag')
        return self


class RepayInsuranceCbrfRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        business_id: str = None,
        insurance_code: str = None,
        product_code: str = None,
        related_order_no: str = None,
        policy_no: str = None,
        insured_receipt_no: str = None,
        dest_country: str = None,
        claim_time: str = None,
        claim_amount: str = None,
        dwa_time: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 物流公司业务线的简称
        self.business_id = business_id
        # 保司编码
        self.insurance_code = insurance_code
        # 险种
        self.product_code = product_code
        # 客户的订单编号
        self.related_order_no = related_order_no
        # 保单号
        self.policy_no = policy_no
        # 投保响应编码
        self.insured_receipt_no = insured_receipt_no
        # 2位ISO国家编码
        self.dest_country = dest_country
        # 理赔时间
        self.claim_time = claim_time
        # 理赔金额，单位为元，依据实际情况计算的理赔金额，最多小数点后2位
        self.claim_amount = claim_amount
        # 达到国内仓库时间
        self.dwa_time = dwa_time

    def validate(self):
        if self.business_id is not None:
            self.validate_max_length(self.business_id, 'business_id', 50)
        self.validate_required(self.insurance_code, 'insurance_code')
        if self.insurance_code is not None:
            self.validate_max_length(self.insurance_code, 'insurance_code', 16)
        self.validate_required(self.product_code, 'product_code')
        if self.product_code is not None:
            self.validate_max_length(self.product_code, 'product_code', 2)
        self.validate_required(self.related_order_no, 'related_order_no')
        if self.related_order_no is not None:
            self.validate_max_length(self.related_order_no, 'related_order_no', 256)
        self.validate_required(self.policy_no, 'policy_no')
        if self.policy_no is not None:
            self.validate_max_length(self.policy_no, 'policy_no', 50)
        self.validate_required(self.insured_receipt_no, 'insured_receipt_no')
        if self.insured_receipt_no is not None:
            self.validate_max_length(self.insured_receipt_no, 'insured_receipt_no', 40)
        self.validate_required(self.dest_country, 'dest_country')
        if self.dest_country is not None:
            self.validate_max_length(self.dest_country, 'dest_country', 256)
        self.validate_required(self.claim_time, 'claim_time')
        if self.claim_time is not None:
            self.validate_pattern(self.claim_time, 'claim_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.claim_amount, 'claim_amount')
        if self.claim_amount is not None:
            self.validate_max_length(self.claim_amount, 'claim_amount', 20)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.business_id is not None:
            result['business_id'] = self.business_id
        if self.insurance_code is not None:
            result['insurance_code'] = self.insurance_code
        if self.product_code is not None:
            result['product_code'] = self.product_code
        if self.related_order_no is not None:
            result['related_order_no'] = self.related_order_no
        if self.policy_no is not None:
            result['policy_no'] = self.policy_no
        if self.insured_receipt_no is not None:
            result['insured_receipt_no'] = self.insured_receipt_no
        if self.dest_country is not None:
            result['dest_country'] = self.dest_country
        if self.claim_time is not None:
            result['claim_time'] = self.claim_time
        if self.claim_amount is not None:
            result['claim_amount'] = self.claim_amount
        if self.dwa_time is not None:
            result['dwa_time'] = self.dwa_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('business_id') is not None:
            self.business_id = m.get('business_id')
        if m.get('insurance_code') is not None:
            self.insurance_code = m.get('insurance_code')
        if m.get('product_code') is not None:
            self.product_code = m.get('product_code')
        if m.get('related_order_no') is not None:
            self.related_order_no = m.get('related_order_no')
        if m.get('policy_no') is not None:
            self.policy_no = m.get('policy_no')
        if m.get('insured_receipt_no') is not None:
            self.insured_receipt_no = m.get('insured_receipt_no')
        if m.get('dest_country') is not None:
            self.dest_country = m.get('dest_country')
        if m.get('claim_time') is not None:
            self.claim_time = m.get('claim_time')
        if m.get('claim_amount') is not None:
            self.claim_amount = m.get('claim_amount')
        if m.get('dwa_time') is not None:
            self.dwa_time = m.get('dwa_time')
        return self


class RepayInsuranceCbrfResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        claim_no: str = None,
        related_order_no: str = None,
        policy_no: str = None,
        idem_flag: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 赔案号
        self.claim_no = claim_no
        # 客户投保时的标的订单号
        self.related_order_no = related_order_no
        # 保单号
        self.policy_no = policy_no
        # 幂等标识。true：幂等结果;false：非幂等结果
        self.idem_flag = idem_flag

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.claim_no is not None:
            result['claim_no'] = self.claim_no
        if self.related_order_no is not None:
            result['related_order_no'] = self.related_order_no
        if self.policy_no is not None:
            result['policy_no'] = self.policy_no
        if self.idem_flag is not None:
            result['idem_flag'] = self.idem_flag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('claim_no') is not None:
            self.claim_no = m.get('claim_no')
        if m.get('related_order_no') is not None:
            self.related_order_no = m.get('related_order_no')
        if m.get('policy_no') is not None:
            self.policy_no = m.get('policy_no')
        if m.get('idem_flag') is not None:
            self.idem_flag = m.get('idem_flag')
        return self


class ApplyInsuranceCbecRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        trade_no: str = None,
        external_channel_code: str = None,
        external_product_code: str = None,
        tbr_name: str = None,
        tbr_id_type: str = None,
        tbr_id_no: str = None,
        bbr_name: str = None,
        bbr_id_type: str = None,
        bbr_id_no: str = None,
        related_order_no: str = None,
        cargo_quantity: str = None,
        cargo_name: str = None,
        packing_code: str = None,
        cargo_type_code: str = None,
        flight_area_code: str = None,
        transport_type_code: str = None,
        transport_means_name: str = None,
        voyage: str = None,
        start_place: str = None,
        transit_point: str = None,
        destination: str = None,
        claim_agent_code: str = None,
        main_item_code: str = None,
        main_item_content: str = None,
        main_item_adds: List[MainItemAdd] = None,
        specialize: str = None,
        cargo_worth: str = None,
        rate: str = None,
        premium: str = None,
        insure_start: str = None,
        sale_date: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 调用方生成的唯一编码，格式为 yyyyMMdd_身份标识_其他编码，系统会根据该流水号做防重、幂等判断逻辑。
        # yyyyMMdd请传递当前时间。
        # 身份标识可自定义。
        # 其他编码建议为随机值。
        # 当极端场景中，系统会返回处理中，错误码为2222，客户端应该保持该流水号不变，并使用原来的请求再次发送请求，系统会根据幂等逻辑返回处理结果；
        self.trade_no = trade_no
        # 保司编码，CPIC---太保
        self.external_channel_code = external_channel_code
        # 险种编码，03--跨境出口货运险
        self.external_product_code = external_product_code
        # 投保人名称
        self.tbr_name = tbr_name
        # 投保人证件类型，03--营业执照
        self.tbr_id_type = tbr_id_type
        # 投保人证件号码
        self.tbr_id_no = tbr_id_no
        # 被保人名称
        self.bbr_name = bbr_name
        # 被保人证件类型，01--居民身份证，03--营业执照
        self.bbr_id_type = bbr_id_type
        # 被保人证件号码
        self.bbr_id_no = bbr_id_no
        # 出库单号/航次号/运单号
        self.related_order_no = related_order_no
        # 包装及数量
        self.cargo_quantity = cargo_quantity
        # 货物名称
        self.cargo_name = cargo_name
        # 包装代码,参考保司提供样例-包装代码
        self.packing_code = packing_code
        # 货物类型代码,参考保司提供样例-货物类型代码
        self.cargo_type_code = cargo_type_code
        # 航行区域代码,参考保司提供样例-航行区域代码
        self.flight_area_code = flight_area_code
        # 运输方式代码,参考保司提供样例-运输方式
        self.transport_type_code = transport_type_code
        # 运输工具名称
        self.transport_means_name = transport_means_name
        # 航次号
        self.voyage = voyage
        # 出发地
        self.start_place = start_place
        # 中转地
        self.transit_point = transit_point
        # 目的地
        self.destination = destination
        # 理赔代理地代码，参考保司提供样例-理赔代理地
        self.claim_agent_code = claim_agent_code
        # 主险条款代码--参考保司提供样例
        self.main_item_code = main_item_code
        # 主险条款内容--参考保司提供样例
        self.main_item_content = main_item_content
        # 附加条款集合
        self.main_item_adds = main_item_adds
        # 特别约定--填写协议中的特别约定
        self.specialize = specialize
        # 申报货物价值,，最多兼容2位小数，单位（元）
        self.cargo_worth = cargo_worth
        # 费率，最多兼容9位小数
        self.rate = rate
        # 保费，最多兼容2位小数，单位（元）
        self.premium = premium
        # 保险起期，日期格式yyyy-mm-dd
        self.insure_start = insure_start
        # 起运日期，日期格式yyyy-mm-dd
        self.sale_date = sale_date

    def validate(self):
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 50)
        self.validate_required(self.external_channel_code, 'external_channel_code')
        if self.external_channel_code is not None:
            self.validate_max_length(self.external_channel_code, 'external_channel_code', 64)
        self.validate_required(self.external_product_code, 'external_product_code')
        if self.external_product_code is not None:
            self.validate_max_length(self.external_product_code, 'external_product_code', 64)
        self.validate_required(self.tbr_name, 'tbr_name')
        if self.tbr_name is not None:
            self.validate_max_length(self.tbr_name, 'tbr_name', 100)
        if self.tbr_id_type is not None:
            self.validate_max_length(self.tbr_id_type, 'tbr_id_type', 2)
        if self.tbr_id_no is not None:
            self.validate_max_length(self.tbr_id_no, 'tbr_id_no', 30)
        self.validate_required(self.bbr_name, 'bbr_name')
        if self.bbr_name is not None:
            self.validate_max_length(self.bbr_name, 'bbr_name', 100)
        if self.bbr_id_type is not None:
            self.validate_max_length(self.bbr_id_type, 'bbr_id_type', 2)
        if self.bbr_id_no is not None:
            self.validate_max_length(self.bbr_id_no, 'bbr_id_no', 30)
        self.validate_required(self.related_order_no, 'related_order_no')
        if self.related_order_no is not None:
            self.validate_max_length(self.related_order_no, 'related_order_no', 200)
        self.validate_required(self.cargo_quantity, 'cargo_quantity')
        if self.cargo_quantity is not None:
            self.validate_max_length(self.cargo_quantity, 'cargo_quantity', 20)
        self.validate_required(self.cargo_name, 'cargo_name')
        if self.cargo_name is not None:
            self.validate_max_length(self.cargo_name, 'cargo_name', 100)
        self.validate_required(self.packing_code, 'packing_code')
        if self.packing_code is not None:
            self.validate_max_length(self.packing_code, 'packing_code', 2)
        self.validate_required(self.cargo_type_code, 'cargo_type_code')
        if self.cargo_type_code is not None:
            self.validate_max_length(self.cargo_type_code, 'cargo_type_code', 4)
        self.validate_required(self.flight_area_code, 'flight_area_code')
        if self.flight_area_code is not None:
            self.validate_max_length(self.flight_area_code, 'flight_area_code', 10)
        self.validate_required(self.transport_type_code, 'transport_type_code')
        if self.transport_type_code is not None:
            self.validate_max_length(self.transport_type_code, 'transport_type_code', 2)
        self.validate_required(self.transport_means_name, 'transport_means_name')
        if self.transport_means_name is not None:
            self.validate_max_length(self.transport_means_name, 'transport_means_name', 30)
        if self.voyage is not None:
            self.validate_max_length(self.voyage, 'voyage', 30)
        self.validate_required(self.start_place, 'start_place')
        if self.start_place is not None:
            self.validate_max_length(self.start_place, 'start_place', 200)
        if self.transit_point is not None:
            self.validate_max_length(self.transit_point, 'transit_point', 100)
        self.validate_required(self.destination, 'destination')
        if self.destination is not None:
            self.validate_max_length(self.destination, 'destination', 200)
        self.validate_required(self.claim_agent_code, 'claim_agent_code')
        if self.claim_agent_code is not None:
            self.validate_max_length(self.claim_agent_code, 'claim_agent_code', 30)
        self.validate_required(self.main_item_code, 'main_item_code')
        if self.main_item_code is not None:
            self.validate_max_length(self.main_item_code, 'main_item_code', 12)
        self.validate_required(self.main_item_content, 'main_item_content')
        if self.main_item_content is not None:
            self.validate_max_length(self.main_item_content, 'main_item_content', 500)
        if self.main_item_adds:
            for k in self.main_item_adds:
                if k:
                    k.validate()
        if self.specialize is not None:
            self.validate_max_length(self.specialize, 'specialize', 500)
        self.validate_required(self.cargo_worth, 'cargo_worth')
        if self.cargo_worth is not None:
            self.validate_max_length(self.cargo_worth, 'cargo_worth', 50)
        self.validate_required(self.rate, 'rate')
        self.validate_required(self.premium, 'premium')
        self.validate_required(self.insure_start, 'insure_start')
        self.validate_required(self.sale_date, 'sale_date')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.external_channel_code is not None:
            result['external_channel_code'] = self.external_channel_code
        if self.external_product_code is not None:
            result['external_product_code'] = self.external_product_code
        if self.tbr_name is not None:
            result['tbr_name'] = self.tbr_name
        if self.tbr_id_type is not None:
            result['tbr_id_type'] = self.tbr_id_type
        if self.tbr_id_no is not None:
            result['tbr_id_no'] = self.tbr_id_no
        if self.bbr_name is not None:
            result['bbr_name'] = self.bbr_name
        if self.bbr_id_type is not None:
            result['bbr_id_type'] = self.bbr_id_type
        if self.bbr_id_no is not None:
            result['bbr_id_no'] = self.bbr_id_no
        if self.related_order_no is not None:
            result['related_order_no'] = self.related_order_no
        if self.cargo_quantity is not None:
            result['cargo_quantity'] = self.cargo_quantity
        if self.cargo_name is not None:
            result['cargo_name'] = self.cargo_name
        if self.packing_code is not None:
            result['packing_code'] = self.packing_code
        if self.cargo_type_code is not None:
            result['cargo_type_code'] = self.cargo_type_code
        if self.flight_area_code is not None:
            result['flight_area_code'] = self.flight_area_code
        if self.transport_type_code is not None:
            result['transport_type_code'] = self.transport_type_code
        if self.transport_means_name is not None:
            result['transport_means_name'] = self.transport_means_name
        if self.voyage is not None:
            result['voyage'] = self.voyage
        if self.start_place is not None:
            result['start_place'] = self.start_place
        if self.transit_point is not None:
            result['transit_point'] = self.transit_point
        if self.destination is not None:
            result['destination'] = self.destination
        if self.claim_agent_code is not None:
            result['claim_agent_code'] = self.claim_agent_code
        if self.main_item_code is not None:
            result['main_item_code'] = self.main_item_code
        if self.main_item_content is not None:
            result['main_item_content'] = self.main_item_content
        result['main_item_adds'] = []
        if self.main_item_adds is not None:
            for k in self.main_item_adds:
                result['main_item_adds'].append(k.to_map() if k else None)
        if self.specialize is not None:
            result['specialize'] = self.specialize
        if self.cargo_worth is not None:
            result['cargo_worth'] = self.cargo_worth
        if self.rate is not None:
            result['rate'] = self.rate
        if self.premium is not None:
            result['premium'] = self.premium
        if self.insure_start is not None:
            result['insure_start'] = self.insure_start
        if self.sale_date is not None:
            result['sale_date'] = self.sale_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('external_channel_code') is not None:
            self.external_channel_code = m.get('external_channel_code')
        if m.get('external_product_code') is not None:
            self.external_product_code = m.get('external_product_code')
        if m.get('tbr_name') is not None:
            self.tbr_name = m.get('tbr_name')
        if m.get('tbr_id_type') is not None:
            self.tbr_id_type = m.get('tbr_id_type')
        if m.get('tbr_id_no') is not None:
            self.tbr_id_no = m.get('tbr_id_no')
        if m.get('bbr_name') is not None:
            self.bbr_name = m.get('bbr_name')
        if m.get('bbr_id_type') is not None:
            self.bbr_id_type = m.get('bbr_id_type')
        if m.get('bbr_id_no') is not None:
            self.bbr_id_no = m.get('bbr_id_no')
        if m.get('related_order_no') is not None:
            self.related_order_no = m.get('related_order_no')
        if m.get('cargo_quantity') is not None:
            self.cargo_quantity = m.get('cargo_quantity')
        if m.get('cargo_name') is not None:
            self.cargo_name = m.get('cargo_name')
        if m.get('packing_code') is not None:
            self.packing_code = m.get('packing_code')
        if m.get('cargo_type_code') is not None:
            self.cargo_type_code = m.get('cargo_type_code')
        if m.get('flight_area_code') is not None:
            self.flight_area_code = m.get('flight_area_code')
        if m.get('transport_type_code') is not None:
            self.transport_type_code = m.get('transport_type_code')
        if m.get('transport_means_name') is not None:
            self.transport_means_name = m.get('transport_means_name')
        if m.get('voyage') is not None:
            self.voyage = m.get('voyage')
        if m.get('start_place') is not None:
            self.start_place = m.get('start_place')
        if m.get('transit_point') is not None:
            self.transit_point = m.get('transit_point')
        if m.get('destination') is not None:
            self.destination = m.get('destination')
        if m.get('claim_agent_code') is not None:
            self.claim_agent_code = m.get('claim_agent_code')
        if m.get('main_item_code') is not None:
            self.main_item_code = m.get('main_item_code')
        if m.get('main_item_content') is not None:
            self.main_item_content = m.get('main_item_content')
        self.main_item_adds = []
        if m.get('main_item_adds') is not None:
            for k in m.get('main_item_adds'):
                temp_model = MainItemAdd()
                self.main_item_adds.append(temp_model.from_map(k))
        if m.get('specialize') is not None:
            self.specialize = m.get('specialize')
        if m.get('cargo_worth') is not None:
            self.cargo_worth = m.get('cargo_worth')
        if m.get('rate') is not None:
            self.rate = m.get('rate')
        if m.get('premium') is not None:
            self.premium = m.get('premium')
        if m.get('insure_start') is not None:
            self.insure_start = m.get('insure_start')
        if m.get('sale_date') is not None:
            self.sale_date = m.get('sale_date')
        return self


class ApplyInsuranceCbecResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        trade_no: str = None,
        policy_no: str = None,
        premium: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 投保交易号
        self.trade_no = trade_no
        # 保单号，保司生成的投保业务号
        self.policy_no = policy_no
        # 保费
        self.premium = premium

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.policy_no is not None:
            result['policy_no'] = self.policy_no
        if self.premium is not None:
            result['premium'] = self.premium
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('policy_no') is not None:
            self.policy_no = m.get('policy_no')
        if m.get('premium') is not None:
            self.premium = m.get('premium')
        return self


class ApplyInsuranceStockinRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        trade_no: str = None,
        stockin_no: str = None,
        stockin_date: str = None,
        timezone: str = None,
        repository_code: str = None,
        customer_code: str = None,
        policy_no: str = None,
        stockin_cargos: List[StockinCargo] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 入库交易流水号，保持唯一；
        # 格式为 yyyyMMdd_身份标识_其他编码。
        # 系统会根据该流水号做防重、幂等判断逻辑。
        # 当极端场景中（接口超时），客户端应该保持该流水号不变，并使用原来的请求再次发送请求，系统会根据幂等逻辑返回处理结果；
        self.trade_no = trade_no
        # 入库单号，可参考格式：年月日+唯一字符
        self.stockin_no = stockin_no
        # 入库时间，格式：yyyy-MM-dd HH:mm:ss
        self.stockin_date = stockin_date
        # 时区
        self.timezone = timezone
        # 仓库代码
        self.repository_code = repository_code
        # 客户代码
        self.customer_code = customer_code
        # 保单号,国内起运时投保产生的保单号
        self.policy_no = policy_no
        # 入库货物列表
        self.stockin_cargos = stockin_cargos

    def validate(self):
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 50)
        self.validate_required(self.stockin_no, 'stockin_no')
        if self.stockin_no is not None:
            self.validate_max_length(self.stockin_no, 'stockin_no', 50)
        self.validate_required(self.stockin_date, 'stockin_date')
        self.validate_required(self.timezone, 'timezone')
        if self.timezone is not None:
            self.validate_max_length(self.timezone, 'timezone', 16)
        self.validate_required(self.repository_code, 'repository_code')
        if self.repository_code is not None:
            self.validate_max_length(self.repository_code, 'repository_code', 50)
        self.validate_required(self.customer_code, 'customer_code')
        if self.customer_code is not None:
            self.validate_max_length(self.customer_code, 'customer_code', 50)
        if self.policy_no is not None:
            self.validate_max_length(self.policy_no, 'policy_no', 64)
        self.validate_required(self.stockin_cargos, 'stockin_cargos')
        if self.stockin_cargos:
            for k in self.stockin_cargos:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.stockin_no is not None:
            result['stockin_no'] = self.stockin_no
        if self.stockin_date is not None:
            result['stockin_date'] = self.stockin_date
        if self.timezone is not None:
            result['timezone'] = self.timezone
        if self.repository_code is not None:
            result['repository_code'] = self.repository_code
        if self.customer_code is not None:
            result['customer_code'] = self.customer_code
        if self.policy_no is not None:
            result['policy_no'] = self.policy_no
        result['stockin_cargos'] = []
        if self.stockin_cargos is not None:
            for k in self.stockin_cargos:
                result['stockin_cargos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('stockin_no') is not None:
            self.stockin_no = m.get('stockin_no')
        if m.get('stockin_date') is not None:
            self.stockin_date = m.get('stockin_date')
        if m.get('timezone') is not None:
            self.timezone = m.get('timezone')
        if m.get('repository_code') is not None:
            self.repository_code = m.get('repository_code')
        if m.get('customer_code') is not None:
            self.customer_code = m.get('customer_code')
        if m.get('policy_no') is not None:
            self.policy_no = m.get('policy_no')
        self.stockin_cargos = []
        if m.get('stockin_cargos') is not None:
            for k in m.get('stockin_cargos'):
                temp_model = StockinCargo()
                self.stockin_cargos.append(temp_model.from_map(k))
        return self


class ApplyInsuranceStockinResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        trade_no: str = None,
        stockin_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 入库交易流水号
        self.trade_no = trade_no
        # 入库单号
        # 
        # 
        self.stockin_no = stockin_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.stockin_no is not None:
            result['stockin_no'] = self.stockin_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('stockin_no') is not None:
            self.stockin_no = m.get('stockin_no')
        return self


class ApplyInsuranceInventoryRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        trade_no: str = None,
        inventory_no: str = None,
        inventory_query_date: str = None,
        repository_code: str = None,
        inventory_cargos: List[InventoryCargo] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 库存申报交易号，调用方生成的唯一编码；
        # 格式为 yyyyMMdd_身份标识_其他编码，yyyyMMdd请传递当前时间。
        # 系统会根据该流水号做防重、幂等判断逻辑。
        # 当极端场景中（接口超时），客户端应该保持该流水号不变，并使用原来的请求再次发送请求，系统会根据幂等逻辑返回处理结果；
        self.trade_no = trade_no
        # 库存申报编号
        self.inventory_no = inventory_no
        # 库存查询时间，yyyy-mm-dd，精确到（天）
        self.inventory_query_date = inventory_query_date
        # 仓库代码
        # 
        # 
        self.repository_code = repository_code
        # 库存货物列表
        self.inventory_cargos = inventory_cargos

    def validate(self):
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 50)
        self.validate_required(self.inventory_no, 'inventory_no')
        if self.inventory_no is not None:
            self.validate_max_length(self.inventory_no, 'inventory_no', 50)
        self.validate_required(self.inventory_query_date, 'inventory_query_date')
        self.validate_required(self.repository_code, 'repository_code')
        if self.repository_code is not None:
            self.validate_max_length(self.repository_code, 'repository_code', 50)
        self.validate_required(self.inventory_cargos, 'inventory_cargos')
        if self.inventory_cargos:
            for k in self.inventory_cargos:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.inventory_no is not None:
            result['inventory_no'] = self.inventory_no
        if self.inventory_query_date is not None:
            result['inventory_query_date'] = self.inventory_query_date
        if self.repository_code is not None:
            result['repository_code'] = self.repository_code
        result['inventory_cargos'] = []
        if self.inventory_cargos is not None:
            for k in self.inventory_cargos:
                result['inventory_cargos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('inventory_no') is not None:
            self.inventory_no = m.get('inventory_no')
        if m.get('inventory_query_date') is not None:
            self.inventory_query_date = m.get('inventory_query_date')
        if m.get('repository_code') is not None:
            self.repository_code = m.get('repository_code')
        self.inventory_cargos = []
        if m.get('inventory_cargos') is not None:
            for k in m.get('inventory_cargos'):
                temp_model = InventoryCargo()
                self.inventory_cargos.append(temp_model.from_map(k))
        return self


class ApplyInsuranceInventoryResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        inventory_no: str = None,
        trade_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 库存申报编号
        self.inventory_no = inventory_no
        # 库存申报交易流水号
        self.trade_no = trade_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.inventory_no is not None:
            result['inventory_no'] = self.inventory_no
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('inventory_no') is not None:
            self.inventory_no = m.get('inventory_no')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        return self


class ApplyInsuranceOspiRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        trade_no: str = None,
        external_channel_code: str = None,
        external_product_code: str = None,
        tbr_name: str = None,
        tbr_id_type: str = None,
        tbr_id_no: str = None,
        bbr_name: str = None,
        bbr_id_type: str = None,
        bbr_id_no: str = None,
        beneficiary_name: str = None,
        beneficiary_id_type: str = None,
        beneficiary_no: str = None,
        insure_start: str = None,
        insured_amount: str = None,
        scheme_name: str = None,
        project_name: str = None,
        rela_order_no: str = None,
        pick_up_time: str = None,
        courier_company: str = None,
        courier_number: str = None,
        cargo_type: str = None,
        cargo_name: str = None,
        cargo_quantity: str = None,
        buy_id: str = None,
        sell_id: str = None,
        site_id: str = None,
        start_place: str = None,
        destination: str = None,
        iso_country: str = None,
        cargo_worth: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 调用方生成的唯一编码，格式为 yyyyMMdd_身份标识_其他编码，系统会根据该流水号做防重、幂等判断逻辑。
        # yyyyMMdd请传递当前时间。
        # 身份标识可自定义。
        # 其他编码建议为随机值。
        # 当极端场景中，系统会返回处理中，错误码为2222，客户端应该保持该流水号不变，并使用原来的请求再次发送请求，系统会根据幂等逻辑返回处理结果；
        self.trade_no = trade_no
        # 保司编码.，PAIC---平安，CICP-中华财险
        self.external_channel_code = external_channel_code
        # 险种编码，04--海外邮包险
        # 
        self.external_product_code = external_product_code
        # 投保人姓名，保险协议中的投保人全称
        self.tbr_name = tbr_name
        # 投保人证件类型，03--营业执照
        self.tbr_id_type = tbr_id_type
        # 投保人证件号码
        self.tbr_id_no = tbr_id_no
        # 被保人姓名，实际的保险被保人名称
        self.bbr_name = bbr_name
        # 被保人证件类型，01--居民身份证、03--营业执照
        self.bbr_id_type = bbr_id_type
        # 被保人证件号码
        self.bbr_id_no = bbr_id_no
        # 受益人名称，实际的保险受益人名称
        self.beneficiary_name = beneficiary_name
        # 受益人证件类型，01--居民身份证、03--营业执照
        self.beneficiary_id_type = beneficiary_id_type
        # 受益人证件号码
        self.beneficiary_no = beneficiary_no
        # 保险起期，日期格式yyyy-MM-dd HH:mm:ss
        self.insure_start = insure_start
        # 保险金额，单位（元），最多支持2位小数，超过2位拒绝；
        self.insured_amount = insured_amount
        # 方案名，海外邮包险--OWFP
        self.scheme_name = scheme_name
        # 项目名称,海外邮包险：OWFP-对应国别，例OWFP-RU
        self.project_name = project_name
        # 订单号,物流平台用以区分业务的唯一码
        self.rela_order_no = rela_order_no
        # 寄件时间，日期格式yyyy-MM-dd HH:mm:ss
        self.pick_up_time = pick_up_time
        # 快递公司名称，实际的派送公司全称
        self.courier_company = courier_company
        # 快递单号，实际的派送快递单号
        self.courier_number = courier_number
        # 货物类型，货物类型的大类
        self.cargo_type = cargo_type
        # 货物名称，实际的货物名称
        self.cargo_name = cargo_name
        # 货物数量
        self.cargo_quantity = cargo_quantity
        # 买家ID，买家的脱敏唯一标识
        self.buy_id = buy_id
        # 卖家ID，卖家的脱敏唯一标识
        self.sell_id = sell_id
        # 站点/仓储ID，站点/仓储的脱敏唯一标识
        self.site_id = site_id
        # 出发地地址，包裹的实际发件地地址
        self.start_place = start_place
        # 目的地地址，包裹的实际收件地地址
        self.destination = destination
        # ISO到达国别，包裹业务实际发生的国家
        self.iso_country = iso_country
        # 货物申报价值，单位（元），最多支持2位小数，超过2位拒绝
        self.cargo_worth = cargo_worth

    def validate(self):
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 50)
        self.validate_required(self.external_channel_code, 'external_channel_code')
        if self.external_channel_code is not None:
            self.validate_max_length(self.external_channel_code, 'external_channel_code', 10)
        self.validate_required(self.external_product_code, 'external_product_code')
        if self.external_product_code is not None:
            self.validate_max_length(self.external_product_code, 'external_product_code', 2)
        self.validate_required(self.tbr_name, 'tbr_name')
        if self.tbr_name is not None:
            self.validate_max_length(self.tbr_name, 'tbr_name', 100)
        self.validate_required(self.tbr_id_type, 'tbr_id_type')
        if self.tbr_id_type is not None:
            self.validate_max_length(self.tbr_id_type, 'tbr_id_type', 2)
        self.validate_required(self.tbr_id_no, 'tbr_id_no')
        if self.tbr_id_no is not None:
            self.validate_max_length(self.tbr_id_no, 'tbr_id_no', 30)
        self.validate_required(self.bbr_name, 'bbr_name')
        if self.bbr_name is not None:
            self.validate_max_length(self.bbr_name, 'bbr_name', 100)
        self.validate_required(self.bbr_id_type, 'bbr_id_type')
        if self.bbr_id_type is not None:
            self.validate_max_length(self.bbr_id_type, 'bbr_id_type', 2)
        self.validate_required(self.bbr_id_no, 'bbr_id_no')
        if self.bbr_id_no is not None:
            self.validate_max_length(self.bbr_id_no, 'bbr_id_no', 30)
        self.validate_required(self.beneficiary_name, 'beneficiary_name')
        if self.beneficiary_name is not None:
            self.validate_max_length(self.beneficiary_name, 'beneficiary_name', 100)
        self.validate_required(self.beneficiary_id_type, 'beneficiary_id_type')
        if self.beneficiary_id_type is not None:
            self.validate_max_length(self.beneficiary_id_type, 'beneficiary_id_type', 2)
        self.validate_required(self.beneficiary_no, 'beneficiary_no')
        if self.beneficiary_no is not None:
            self.validate_max_length(self.beneficiary_no, 'beneficiary_no', 30)
        self.validate_required(self.insure_start, 'insure_start')
        self.validate_required(self.insured_amount, 'insured_amount')
        self.validate_required(self.scheme_name, 'scheme_name')
        if self.scheme_name is not None:
            self.validate_max_length(self.scheme_name, 'scheme_name', 100)
        self.validate_required(self.project_name, 'project_name')
        if self.project_name is not None:
            self.validate_max_length(self.project_name, 'project_name', 500)
        self.validate_required(self.rela_order_no, 'rela_order_no')
        if self.rela_order_no is not None:
            self.validate_max_length(self.rela_order_no, 'rela_order_no', 200)
        self.validate_required(self.pick_up_time, 'pick_up_time')
        self.validate_required(self.courier_company, 'courier_company')
        if self.courier_company is not None:
            self.validate_max_length(self.courier_company, 'courier_company', 200)
        self.validate_required(self.courier_number, 'courier_number')
        if self.courier_number is not None:
            self.validate_max_length(self.courier_number, 'courier_number', 100)
        self.validate_required(self.cargo_type, 'cargo_type')
        if self.cargo_type is not None:
            self.validate_max_length(self.cargo_type, 'cargo_type', 100)
        self.validate_required(self.cargo_name, 'cargo_name')
        if self.cargo_name is not None:
            self.validate_max_length(self.cargo_name, 'cargo_name', 200)
        self.validate_required(self.cargo_quantity, 'cargo_quantity')
        self.validate_required(self.buy_id, 'buy_id')
        if self.buy_id is not None:
            self.validate_max_length(self.buy_id, 'buy_id', 100)
        self.validate_required(self.sell_id, 'sell_id')
        if self.sell_id is not None:
            self.validate_max_length(self.sell_id, 'sell_id', 100)
        self.validate_required(self.site_id, 'site_id')
        if self.site_id is not None:
            self.validate_max_length(self.site_id, 'site_id', 100)
        self.validate_required(self.start_place, 'start_place')
        if self.start_place is not None:
            self.validate_max_length(self.start_place, 'start_place', 500)
        self.validate_required(self.destination, 'destination')
        if self.destination is not None:
            self.validate_max_length(self.destination, 'destination', 500)
        self.validate_required(self.iso_country, 'iso_country')
        if self.iso_country is not None:
            self.validate_max_length(self.iso_country, 'iso_country', 10)
        self.validate_required(self.cargo_worth, 'cargo_worth')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.external_channel_code is not None:
            result['external_channel_code'] = self.external_channel_code
        if self.external_product_code is not None:
            result['external_product_code'] = self.external_product_code
        if self.tbr_name is not None:
            result['tbr_name'] = self.tbr_name
        if self.tbr_id_type is not None:
            result['tbr_id_type'] = self.tbr_id_type
        if self.tbr_id_no is not None:
            result['tbr_id_no'] = self.tbr_id_no
        if self.bbr_name is not None:
            result['bbr_name'] = self.bbr_name
        if self.bbr_id_type is not None:
            result['bbr_id_type'] = self.bbr_id_type
        if self.bbr_id_no is not None:
            result['bbr_id_no'] = self.bbr_id_no
        if self.beneficiary_name is not None:
            result['beneficiary_name'] = self.beneficiary_name
        if self.beneficiary_id_type is not None:
            result['beneficiary_id_type'] = self.beneficiary_id_type
        if self.beneficiary_no is not None:
            result['beneficiary_no'] = self.beneficiary_no
        if self.insure_start is not None:
            result['insure_start'] = self.insure_start
        if self.insured_amount is not None:
            result['insured_amount'] = self.insured_amount
        if self.scheme_name is not None:
            result['scheme_name'] = self.scheme_name
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.rela_order_no is not None:
            result['rela_order_no'] = self.rela_order_no
        if self.pick_up_time is not None:
            result['pick_up_time'] = self.pick_up_time
        if self.courier_company is not None:
            result['courier_company'] = self.courier_company
        if self.courier_number is not None:
            result['courier_number'] = self.courier_number
        if self.cargo_type is not None:
            result['cargo_type'] = self.cargo_type
        if self.cargo_name is not None:
            result['cargo_name'] = self.cargo_name
        if self.cargo_quantity is not None:
            result['cargo_quantity'] = self.cargo_quantity
        if self.buy_id is not None:
            result['buy_id'] = self.buy_id
        if self.sell_id is not None:
            result['sell_id'] = self.sell_id
        if self.site_id is not None:
            result['site_id'] = self.site_id
        if self.start_place is not None:
            result['start_place'] = self.start_place
        if self.destination is not None:
            result['destination'] = self.destination
        if self.iso_country is not None:
            result['iso_country'] = self.iso_country
        if self.cargo_worth is not None:
            result['cargo_worth'] = self.cargo_worth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('external_channel_code') is not None:
            self.external_channel_code = m.get('external_channel_code')
        if m.get('external_product_code') is not None:
            self.external_product_code = m.get('external_product_code')
        if m.get('tbr_name') is not None:
            self.tbr_name = m.get('tbr_name')
        if m.get('tbr_id_type') is not None:
            self.tbr_id_type = m.get('tbr_id_type')
        if m.get('tbr_id_no') is not None:
            self.tbr_id_no = m.get('tbr_id_no')
        if m.get('bbr_name') is not None:
            self.bbr_name = m.get('bbr_name')
        if m.get('bbr_id_type') is not None:
            self.bbr_id_type = m.get('bbr_id_type')
        if m.get('bbr_id_no') is not None:
            self.bbr_id_no = m.get('bbr_id_no')
        if m.get('beneficiary_name') is not None:
            self.beneficiary_name = m.get('beneficiary_name')
        if m.get('beneficiary_id_type') is not None:
            self.beneficiary_id_type = m.get('beneficiary_id_type')
        if m.get('beneficiary_no') is not None:
            self.beneficiary_no = m.get('beneficiary_no')
        if m.get('insure_start') is not None:
            self.insure_start = m.get('insure_start')
        if m.get('insured_amount') is not None:
            self.insured_amount = m.get('insured_amount')
        if m.get('scheme_name') is not None:
            self.scheme_name = m.get('scheme_name')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('rela_order_no') is not None:
            self.rela_order_no = m.get('rela_order_no')
        if m.get('pick_up_time') is not None:
            self.pick_up_time = m.get('pick_up_time')
        if m.get('courier_company') is not None:
            self.courier_company = m.get('courier_company')
        if m.get('courier_number') is not None:
            self.courier_number = m.get('courier_number')
        if m.get('cargo_type') is not None:
            self.cargo_type = m.get('cargo_type')
        if m.get('cargo_name') is not None:
            self.cargo_name = m.get('cargo_name')
        if m.get('cargo_quantity') is not None:
            self.cargo_quantity = m.get('cargo_quantity')
        if m.get('buy_id') is not None:
            self.buy_id = m.get('buy_id')
        if m.get('sell_id') is not None:
            self.sell_id = m.get('sell_id')
        if m.get('site_id') is not None:
            self.site_id = m.get('site_id')
        if m.get('start_place') is not None:
            self.start_place = m.get('start_place')
        if m.get('destination') is not None:
            self.destination = m.get('destination')
        if m.get('iso_country') is not None:
            self.iso_country = m.get('iso_country')
        if m.get('cargo_worth') is not None:
            self.cargo_worth = m.get('cargo_worth')
        return self


class ApplyInsuranceOspiResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        trade_no: str = None,
        policy_no: str = None,
        premium: str = None,
        insured_amount: str = None,
        insure_start: str = None,
        insure_end: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 投保唯一码
        self.trade_no = trade_no
        # 保单号
        self.policy_no = policy_no
        # 保费
        self.premium = premium
        # 保额
        self.insured_amount = insured_amount
        # 保险起期
        self.insure_start = insure_start
        # 保险止期
        self.insure_end = insure_end

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.policy_no is not None:
            result['policy_no'] = self.policy_no
        if self.premium is not None:
            result['premium'] = self.premium
        if self.insured_amount is not None:
            result['insured_amount'] = self.insured_amount
        if self.insure_start is not None:
            result['insure_start'] = self.insure_start
        if self.insure_end is not None:
            result['insure_end'] = self.insure_end
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('policy_no') is not None:
            self.policy_no = m.get('policy_no')
        if m.get('premium') is not None:
            self.premium = m.get('premium')
        if m.get('insured_amount') is not None:
            self.insured_amount = m.get('insured_amount')
        if m.get('insure_start') is not None:
            self.insure_start = m.get('insure_start')
        if m.get('insure_end') is not None:
            self.insure_end = m.get('insure_end')
        return self


class ApplyInsuranceOspireportRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        trade_no: str = None,
        external_channel_code: str = None,
        external_product_code: str = None,
        policy_no: str = None,
        rela_order_no: str = None,
        accident_time: str = None,
        reporter_name: str = None,
        reporter_contact: str = None,
        claim_amount: str = None,
        collect_date: str = None,
        job_no: str = None,
        courier_company: str = None,
        courier_number: str = None,
        buy_id: str = None,
        sell_id: str = None,
        site_id: str = None,
        cargo_name: str = None,
        cargo_weight: str = None,
        start_place: str = None,
        destination: str = None,
        iso_country: str = None,
        accident_address: str = None,
        payment_time: str = None,
        payment_item: str = None,
        accident_type: str = None,
        claim_informations: List[ClaimInformation] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 调用方生成的唯一编码，格式为 yyyyMMdd_身份标识_其他编码，系统会根据该流水号做防重、幂等判断逻辑。
        # yyyyMMdd请传递当前时间。
        # 身份标识可自定义。
        # 其他编码建议为随机值。
        # 当极端场景中，系统会返回处理中，错误码为2222，客户端应该保持该流水号不变，并使用原来的请求再次发送请求，系统会根据幂等逻辑返回处理结果；
        self.trade_no = trade_no
        # 保司编码，PAIC---平安，CICP-中华财险
        self.external_channel_code = external_channel_code
        # 险种编码
        # 04--海外邮包险
        # 06--跨境邮包险
        self.external_product_code = external_product_code
        # 保单号，申请理赔的保单号
        self.policy_no = policy_no
        # 订单号，申请理赔所关联的订单号
        self.rela_order_no = rela_order_no
        # 出险时间，发生损失的时间，yyyy-MM-dd HH:mm:ss
        self.accident_time = accident_time
        # 报案人名称，申请报案人的名称
        self.reporter_name = reporter_name
        # 报案人联系方式，申请报案人的联系方式
        self.reporter_contact = reporter_contact
        # 索赔金额，单位（元），最多支持2位小数，超2位小数拒绝
        self.claim_amount = claim_amount
        # 物流揽收时间，yyyy-MM-dd HH:mm:ss
        self.collect_date = collect_date
        # 工单号，平台客服判责的工单号
        self.job_no = job_no
        # 快递公司名称，实际的派送公司全称
        self.courier_company = courier_company
        # 快递单号，实际的派送快递单号
        self.courier_number = courier_number
        # 买家ID，买家的脱敏唯一标识
        self.buy_id = buy_id
        # 卖家ID，卖家的脱敏唯一标识
        self.sell_id = sell_id
        # 站点/仓储ID，站点/仓储的脱敏唯一标识
        self.site_id = site_id
        # 货物名称，实际的货物名称
        self.cargo_name = cargo_name
        # 货物的重量，单位(kg)，最多支持6位小数
        self.cargo_weight = cargo_weight
        # 出发地地址，货物的出发地地址
        self.start_place = start_place
        # 目的地地址，货物的目的地地址
        self.destination = destination
        # ISO到达国别，包裹业务实际发生的国家
        self.iso_country = iso_country
        # 出险地址，货物发生实际损失的最近的一次地址记录
        self.accident_address = accident_address
        # 平台赔款支付时间，平台先行赔付的时间，yyyy-MM-dd HH:mm:ss
        self.payment_time = payment_time
        # 赔付项目类型，01-运费，02-货值，03-货值2
        self.payment_item = payment_item
        # 出险类型，赔付的出险类型，届时保司和平台方商定
        self.accident_type = accident_type
        # 索赔资料附件，最多10个
        self.claim_informations = claim_informations

    def validate(self):
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 50)
        self.validate_required(self.external_channel_code, 'external_channel_code')
        if self.external_channel_code is not None:
            self.validate_max_length(self.external_channel_code, 'external_channel_code', 10)
        self.validate_required(self.external_product_code, 'external_product_code')
        if self.external_product_code is not None:
            self.validate_max_length(self.external_product_code, 'external_product_code', 2)
        self.validate_required(self.policy_no, 'policy_no')
        if self.policy_no is not None:
            self.validate_max_length(self.policy_no, 'policy_no', 200)
        self.validate_required(self.rela_order_no, 'rela_order_no')
        if self.rela_order_no is not None:
            self.validate_max_length(self.rela_order_no, 'rela_order_no', 200)
        self.validate_required(self.accident_time, 'accident_time')
        self.validate_required(self.reporter_name, 'reporter_name')
        if self.reporter_name is not None:
            self.validate_max_length(self.reporter_name, 'reporter_name', 100)
        self.validate_required(self.reporter_contact, 'reporter_contact')
        if self.reporter_contact is not None:
            self.validate_max_length(self.reporter_contact, 'reporter_contact', 20)
        self.validate_required(self.claim_amount, 'claim_amount')
        self.validate_required(self.collect_date, 'collect_date')
        self.validate_required(self.job_no, 'job_no')
        if self.job_no is not None:
            self.validate_max_length(self.job_no, 'job_no', 100)
        self.validate_required(self.courier_company, 'courier_company')
        if self.courier_company is not None:
            self.validate_max_length(self.courier_company, 'courier_company', 200)
        self.validate_required(self.courier_number, 'courier_number')
        if self.courier_number is not None:
            self.validate_max_length(self.courier_number, 'courier_number', 100)
        self.validate_required(self.buy_id, 'buy_id')
        if self.buy_id is not None:
            self.validate_max_length(self.buy_id, 'buy_id', 100)
        self.validate_required(self.sell_id, 'sell_id')
        if self.sell_id is not None:
            self.validate_max_length(self.sell_id, 'sell_id', 100)
        if self.site_id is not None:
            self.validate_max_length(self.site_id, 'site_id', 100)
        self.validate_required(self.cargo_name, 'cargo_name')
        if self.cargo_name is not None:
            self.validate_max_length(self.cargo_name, 'cargo_name', 200)
        self.validate_required(self.cargo_weight, 'cargo_weight')
        if self.cargo_weight is not None:
            self.validate_max_length(self.cargo_weight, 'cargo_weight', 20)
        self.validate_required(self.start_place, 'start_place')
        if self.start_place is not None:
            self.validate_max_length(self.start_place, 'start_place', 500)
        self.validate_required(self.destination, 'destination')
        if self.destination is not None:
            self.validate_max_length(self.destination, 'destination', 500)
        self.validate_required(self.iso_country, 'iso_country')
        if self.iso_country is not None:
            self.validate_max_length(self.iso_country, 'iso_country', 10)
        self.validate_required(self.accident_address, 'accident_address')
        if self.accident_address is not None:
            self.validate_max_length(self.accident_address, 'accident_address', 500)
        self.validate_required(self.payment_time, 'payment_time')
        self.validate_required(self.payment_item, 'payment_item')
        if self.payment_item is not None:
            self.validate_max_length(self.payment_item, 'payment_item', 2)
        self.validate_required(self.accident_type, 'accident_type')
        if self.accident_type is not None:
            self.validate_max_length(self.accident_type, 'accident_type', 20)
        self.validate_required(self.claim_informations, 'claim_informations')
        if self.claim_informations:
            for k in self.claim_informations:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.external_channel_code is not None:
            result['external_channel_code'] = self.external_channel_code
        if self.external_product_code is not None:
            result['external_product_code'] = self.external_product_code
        if self.policy_no is not None:
            result['policy_no'] = self.policy_no
        if self.rela_order_no is not None:
            result['rela_order_no'] = self.rela_order_no
        if self.accident_time is not None:
            result['accident_time'] = self.accident_time
        if self.reporter_name is not None:
            result['reporter_name'] = self.reporter_name
        if self.reporter_contact is not None:
            result['reporter_contact'] = self.reporter_contact
        if self.claim_amount is not None:
            result['claim_amount'] = self.claim_amount
        if self.collect_date is not None:
            result['collect_date'] = self.collect_date
        if self.job_no is not None:
            result['job_no'] = self.job_no
        if self.courier_company is not None:
            result['courier_company'] = self.courier_company
        if self.courier_number is not None:
            result['courier_number'] = self.courier_number
        if self.buy_id is not None:
            result['buy_id'] = self.buy_id
        if self.sell_id is not None:
            result['sell_id'] = self.sell_id
        if self.site_id is not None:
            result['site_id'] = self.site_id
        if self.cargo_name is not None:
            result['cargo_name'] = self.cargo_name
        if self.cargo_weight is not None:
            result['cargo_weight'] = self.cargo_weight
        if self.start_place is not None:
            result['start_place'] = self.start_place
        if self.destination is not None:
            result['destination'] = self.destination
        if self.iso_country is not None:
            result['iso_country'] = self.iso_country
        if self.accident_address is not None:
            result['accident_address'] = self.accident_address
        if self.payment_time is not None:
            result['payment_time'] = self.payment_time
        if self.payment_item is not None:
            result['payment_item'] = self.payment_item
        if self.accident_type is not None:
            result['accident_type'] = self.accident_type
        result['claim_informations'] = []
        if self.claim_informations is not None:
            for k in self.claim_informations:
                result['claim_informations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('external_channel_code') is not None:
            self.external_channel_code = m.get('external_channel_code')
        if m.get('external_product_code') is not None:
            self.external_product_code = m.get('external_product_code')
        if m.get('policy_no') is not None:
            self.policy_no = m.get('policy_no')
        if m.get('rela_order_no') is not None:
            self.rela_order_no = m.get('rela_order_no')
        if m.get('accident_time') is not None:
            self.accident_time = m.get('accident_time')
        if m.get('reporter_name') is not None:
            self.reporter_name = m.get('reporter_name')
        if m.get('reporter_contact') is not None:
            self.reporter_contact = m.get('reporter_contact')
        if m.get('claim_amount') is not None:
            self.claim_amount = m.get('claim_amount')
        if m.get('collect_date') is not None:
            self.collect_date = m.get('collect_date')
        if m.get('job_no') is not None:
            self.job_no = m.get('job_no')
        if m.get('courier_company') is not None:
            self.courier_company = m.get('courier_company')
        if m.get('courier_number') is not None:
            self.courier_number = m.get('courier_number')
        if m.get('buy_id') is not None:
            self.buy_id = m.get('buy_id')
        if m.get('sell_id') is not None:
            self.sell_id = m.get('sell_id')
        if m.get('site_id') is not None:
            self.site_id = m.get('site_id')
        if m.get('cargo_name') is not None:
            self.cargo_name = m.get('cargo_name')
        if m.get('cargo_weight') is not None:
            self.cargo_weight = m.get('cargo_weight')
        if m.get('start_place') is not None:
            self.start_place = m.get('start_place')
        if m.get('destination') is not None:
            self.destination = m.get('destination')
        if m.get('iso_country') is not None:
            self.iso_country = m.get('iso_country')
        if m.get('accident_address') is not None:
            self.accident_address = m.get('accident_address')
        if m.get('payment_time') is not None:
            self.payment_time = m.get('payment_time')
        if m.get('payment_item') is not None:
            self.payment_item = m.get('payment_item')
        if m.get('accident_type') is not None:
            self.accident_type = m.get('accident_type')
        self.claim_informations = []
        if m.get('claim_informations') is not None:
            for k in m.get('claim_informations'):
                temp_model = ClaimInformation()
                self.claim_informations.append(temp_model.from_map(k))
        return self


class ApplyInsuranceOspireportResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        trade_no: str = None,
        report_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 报案唯一码
        self.trade_no = trade_no
        # 报案号
        self.report_no = report_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.report_no is not None:
            result['report_no'] = self.report_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('report_no') is not None:
            self.report_no = m.get('report_no')
        return self


class NotifyInsuranceOspireportRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        trade_no: str = None,
        report_no: str = None,
        rela_order_no: str = None,
        claim_amount: str = None,
        payment_time: str = None,
        bank_serial_num: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 案件同步唯一码，调用方生成的唯一编码； 格式为 yyyyMMdd_身份标识_其他编码，yyyyMMdd请传递当前时间。
        # 系统会根据该流水号做防重、幂等判断逻辑。
        self.trade_no = trade_no
        # 报案号，关联的报案案件号
        self.report_no = report_no
        # 订单号
        self.rela_order_no = rela_order_no
        # 理赔金额(元)，实际的理赔金额，最多支持2位小数，超2位小数拒绝请求
        self.claim_amount = claim_amount
        # 支付时间，实际的保司打款时间，格式：yyyy-MM-dd HH:mm:ss
        self.payment_time = payment_time
        # 银行流水，打款的银行流水号
        self.bank_serial_num = bank_serial_num

    def validate(self):
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 50)
        self.validate_required(self.report_no, 'report_no')
        if self.report_no is not None:
            self.validate_max_length(self.report_no, 'report_no', 100)
        self.validate_required(self.rela_order_no, 'rela_order_no')
        if self.rela_order_no is not None:
            self.validate_max_length(self.rela_order_no, 'rela_order_no', 100)
        self.validate_required(self.claim_amount, 'claim_amount')
        self.validate_required(self.payment_time, 'payment_time')
        self.validate_required(self.bank_serial_num, 'bank_serial_num')
        if self.bank_serial_num is not None:
            self.validate_max_length(self.bank_serial_num, 'bank_serial_num', 200)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.report_no is not None:
            result['report_no'] = self.report_no
        if self.rela_order_no is not None:
            result['rela_order_no'] = self.rela_order_no
        if self.claim_amount is not None:
            result['claim_amount'] = self.claim_amount
        if self.payment_time is not None:
            result['payment_time'] = self.payment_time
        if self.bank_serial_num is not None:
            result['bank_serial_num'] = self.bank_serial_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('report_no') is not None:
            self.report_no = m.get('report_no')
        if m.get('rela_order_no') is not None:
            self.rela_order_no = m.get('rela_order_no')
        if m.get('claim_amount') is not None:
            self.claim_amount = m.get('claim_amount')
        if m.get('payment_time') is not None:
            self.payment_time = m.get('payment_time')
        if m.get('bank_serial_num') is not None:
            self.bank_serial_num = m.get('bank_serial_num')
        return self


class NotifyInsuranceOspireportResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        trade_no: str = None,
        report_notify_status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 案件同步唯一码
        self.trade_no = trade_no
        # 案件通知状态--SUCCESS、FAIL
        self.report_notify_status = report_notify_status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.report_notify_status is not None:
            result['report_notify_status'] = self.report_notify_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('report_notify_status') is not None:
            self.report_notify_status = m.get('report_notify_status')
        return self


class ApplyInsuranceYzbRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        trade_no: str = None,
        external_channel_code: str = None,
        external_product_code: str = None,
        tbr_name: str = None,
        tbr_id_type: str = None,
        tbr_id_no: str = None,
        bbr_name: str = None,
        bbr_id_type: str = None,
        bbr_id_no: str = None,
        bbr_contact: str = None,
        beneficiary_name: str = None,
        beneficiary_id_type: str = None,
        beneficiary_no: str = None,
        insure_start: str = None,
        product_package_type: str = None,
        site_id: str = None,
        site_name: str = None,
        total_assets: str = None,
        employee_num: str = None,
        province_code: str = None,
        city_code: str = None,
        district_code: str = None,
        whole_address: str = None,
        scheme_name: str = None,
        acpl_bbr_name: str = None,
        acpl_bbr_id_no: str = None,
        pdt_mkt_code: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 调用方生成的唯一编码，格式为 yyyyMMdd_身份标识_其他编码，系统会根据该流水号做防重、幂等判断逻辑。
        # yyyyMMdd请传递当前时间。
        # 身份标识可自定义。
        # 其他编码建议为随机值。
        # 当极端场景中，系统会返回处理中，错误码为2222，客户端应该保持该流水号不变，并使用原来的请求再次发送请求，系统会根据幂等逻辑返回处理结果；
        self.trade_no = trade_no
        # 保司编码，PAIC---平安
        self.external_channel_code = external_channel_code
        # 险种编码，05-驿站宝
        self.external_product_code = external_product_code
        # 投保人姓名，保险协议中的投保人全称
        self.tbr_name = tbr_name
        # 投保人证件类型，03--营业执照
        self.tbr_id_type = tbr_id_type
        # 投保人证件号码
        self.tbr_id_no = tbr_id_no
        # 被保人姓名，实际的保险被保人名称
        self.bbr_name = bbr_name
        # 被保人证件类型，01--居民身份证、03--营业执照
        self.bbr_id_type = bbr_id_type
        # 被保人证件号码
        self.bbr_id_no = bbr_id_no
        # 被保人联系方式
        self.bbr_contact = bbr_contact
        # 受益人名称，实际的保险受益人名称
        self.beneficiary_name = beneficiary_name
        # 受益人证件类型，01--居民身份证、03--营业执照
        self.beneficiary_id_type = beneficiary_id_type
        # 受益人证件号码
        self.beneficiary_no = beneficiary_no
        # 保险起期，格式：yyyy-MM-dd HH:mm:ss
        self.insure_start = insure_start
        # 套餐编码，PK00053022、PK00053025、PK00053026
        self.product_package_type = product_package_type
        # 站点ID，站点的唯一标识
        self.site_id = site_id
        # 站点名称
        self.site_name = site_name
        # 总资产，单位（元），最多2位小数，超过拒绝请求
        self.total_assets = total_assets
        # 雇员人数，站点的雇佣人员数
        self.employee_num = employee_num
        # 省编码，站点位于的省份编码
        self.province_code = province_code
        # 市编码，站点位于的市区编码
        self.city_code = city_code
        # 区编码,站点位于的区县编码
        self.district_code = district_code
        # 完整地址，站点的详细地址
        self.whole_address = whole_address
        # 方案名称，菜鸟驿站宝、菜鸟校园驿站宝、溪鸟公共服务站保障
        self.scheme_name = scheme_name
        # 意健险被保人姓名
        self.acpl_bbr_name = acpl_bbr_name
        # 意健险被保人身份证号
        self.acpl_bbr_id_no = acpl_bbr_id_no
        # 产品市场编码，一般指保司端险种编码
        self.pdt_mkt_code = pdt_mkt_code

    def validate(self):
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 50)
        self.validate_required(self.external_channel_code, 'external_channel_code')
        if self.external_channel_code is not None:
            self.validate_max_length(self.external_channel_code, 'external_channel_code', 10)
        self.validate_required(self.external_product_code, 'external_product_code')
        if self.external_product_code is not None:
            self.validate_max_length(self.external_product_code, 'external_product_code', 2)
        self.validate_required(self.tbr_name, 'tbr_name')
        if self.tbr_name is not None:
            self.validate_max_length(self.tbr_name, 'tbr_name', 100)
        self.validate_required(self.tbr_id_type, 'tbr_id_type')
        if self.tbr_id_type is not None:
            self.validate_max_length(self.tbr_id_type, 'tbr_id_type', 2)
        self.validate_required(self.tbr_id_no, 'tbr_id_no')
        if self.tbr_id_no is not None:
            self.validate_max_length(self.tbr_id_no, 'tbr_id_no', 30)
        self.validate_required(self.bbr_name, 'bbr_name')
        if self.bbr_name is not None:
            self.validate_max_length(self.bbr_name, 'bbr_name', 100)
        self.validate_required(self.bbr_id_type, 'bbr_id_type')
        if self.bbr_id_type is not None:
            self.validate_max_length(self.bbr_id_type, 'bbr_id_type', 2)
        self.validate_required(self.bbr_id_no, 'bbr_id_no')
        if self.bbr_id_no is not None:
            self.validate_max_length(self.bbr_id_no, 'bbr_id_no', 30)
        self.validate_required(self.bbr_contact, 'bbr_contact')
        if self.bbr_contact is not None:
            self.validate_max_length(self.bbr_contact, 'bbr_contact', 30)
        self.validate_required(self.beneficiary_name, 'beneficiary_name')
        if self.beneficiary_name is not None:
            self.validate_max_length(self.beneficiary_name, 'beneficiary_name', 100)
        self.validate_required(self.beneficiary_id_type, 'beneficiary_id_type')
        if self.beneficiary_id_type is not None:
            self.validate_max_length(self.beneficiary_id_type, 'beneficiary_id_type', 2)
        self.validate_required(self.beneficiary_no, 'beneficiary_no')
        if self.beneficiary_no is not None:
            self.validate_max_length(self.beneficiary_no, 'beneficiary_no', 30)
        self.validate_required(self.insure_start, 'insure_start')
        self.validate_required(self.product_package_type, 'product_package_type')
        if self.product_package_type is not None:
            self.validate_max_length(self.product_package_type, 'product_package_type', 20)
        self.validate_required(self.site_id, 'site_id')
        if self.site_id is not None:
            self.validate_max_length(self.site_id, 'site_id', 30)
        self.validate_required(self.site_name, 'site_name')
        if self.site_name is not None:
            self.validate_max_length(self.site_name, 'site_name', 100)
        self.validate_required(self.total_assets, 'total_assets')
        self.validate_required(self.employee_num, 'employee_num')
        self.validate_required(self.province_code, 'province_code')
        if self.province_code is not None:
            self.validate_max_length(self.province_code, 'province_code', 10)
        self.validate_required(self.city_code, 'city_code')
        if self.city_code is not None:
            self.validate_max_length(self.city_code, 'city_code', 10)
        self.validate_required(self.district_code, 'district_code')
        if self.district_code is not None:
            self.validate_max_length(self.district_code, 'district_code', 10)
        self.validate_required(self.whole_address, 'whole_address')
        if self.whole_address is not None:
            self.validate_max_length(self.whole_address, 'whole_address', 300)
        self.validate_required(self.scheme_name, 'scheme_name')
        if self.scheme_name is not None:
            self.validate_max_length(self.scheme_name, 'scheme_name', 100)
        self.validate_required(self.acpl_bbr_name, 'acpl_bbr_name')
        if self.acpl_bbr_name is not None:
            self.validate_max_length(self.acpl_bbr_name, 'acpl_bbr_name', 100)
        self.validate_required(self.acpl_bbr_id_no, 'acpl_bbr_id_no')
        if self.acpl_bbr_id_no is not None:
            self.validate_max_length(self.acpl_bbr_id_no, 'acpl_bbr_id_no', 30)
        if self.pdt_mkt_code is not None:
            self.validate_max_length(self.pdt_mkt_code, 'pdt_mkt_code', 16)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.external_channel_code is not None:
            result['external_channel_code'] = self.external_channel_code
        if self.external_product_code is not None:
            result['external_product_code'] = self.external_product_code
        if self.tbr_name is not None:
            result['tbr_name'] = self.tbr_name
        if self.tbr_id_type is not None:
            result['tbr_id_type'] = self.tbr_id_type
        if self.tbr_id_no is not None:
            result['tbr_id_no'] = self.tbr_id_no
        if self.bbr_name is not None:
            result['bbr_name'] = self.bbr_name
        if self.bbr_id_type is not None:
            result['bbr_id_type'] = self.bbr_id_type
        if self.bbr_id_no is not None:
            result['bbr_id_no'] = self.bbr_id_no
        if self.bbr_contact is not None:
            result['bbr_contact'] = self.bbr_contact
        if self.beneficiary_name is not None:
            result['beneficiary_name'] = self.beneficiary_name
        if self.beneficiary_id_type is not None:
            result['beneficiary_id_type'] = self.beneficiary_id_type
        if self.beneficiary_no is not None:
            result['beneficiary_no'] = self.beneficiary_no
        if self.insure_start is not None:
            result['insure_start'] = self.insure_start
        if self.product_package_type is not None:
            result['product_package_type'] = self.product_package_type
        if self.site_id is not None:
            result['site_id'] = self.site_id
        if self.site_name is not None:
            result['site_name'] = self.site_name
        if self.total_assets is not None:
            result['total_assets'] = self.total_assets
        if self.employee_num is not None:
            result['employee_num'] = self.employee_num
        if self.province_code is not None:
            result['province_code'] = self.province_code
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.district_code is not None:
            result['district_code'] = self.district_code
        if self.whole_address is not None:
            result['whole_address'] = self.whole_address
        if self.scheme_name is not None:
            result['scheme_name'] = self.scheme_name
        if self.acpl_bbr_name is not None:
            result['acpl_bbr_name'] = self.acpl_bbr_name
        if self.acpl_bbr_id_no is not None:
            result['acpl_bbr_id_no'] = self.acpl_bbr_id_no
        if self.pdt_mkt_code is not None:
            result['pdt_mkt_code'] = self.pdt_mkt_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('external_channel_code') is not None:
            self.external_channel_code = m.get('external_channel_code')
        if m.get('external_product_code') is not None:
            self.external_product_code = m.get('external_product_code')
        if m.get('tbr_name') is not None:
            self.tbr_name = m.get('tbr_name')
        if m.get('tbr_id_type') is not None:
            self.tbr_id_type = m.get('tbr_id_type')
        if m.get('tbr_id_no') is not None:
            self.tbr_id_no = m.get('tbr_id_no')
        if m.get('bbr_name') is not None:
            self.bbr_name = m.get('bbr_name')
        if m.get('bbr_id_type') is not None:
            self.bbr_id_type = m.get('bbr_id_type')
        if m.get('bbr_id_no') is not None:
            self.bbr_id_no = m.get('bbr_id_no')
        if m.get('bbr_contact') is not None:
            self.bbr_contact = m.get('bbr_contact')
        if m.get('beneficiary_name') is not None:
            self.beneficiary_name = m.get('beneficiary_name')
        if m.get('beneficiary_id_type') is not None:
            self.beneficiary_id_type = m.get('beneficiary_id_type')
        if m.get('beneficiary_no') is not None:
            self.beneficiary_no = m.get('beneficiary_no')
        if m.get('insure_start') is not None:
            self.insure_start = m.get('insure_start')
        if m.get('product_package_type') is not None:
            self.product_package_type = m.get('product_package_type')
        if m.get('site_id') is not None:
            self.site_id = m.get('site_id')
        if m.get('site_name') is not None:
            self.site_name = m.get('site_name')
        if m.get('total_assets') is not None:
            self.total_assets = m.get('total_assets')
        if m.get('employee_num') is not None:
            self.employee_num = m.get('employee_num')
        if m.get('province_code') is not None:
            self.province_code = m.get('province_code')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('district_code') is not None:
            self.district_code = m.get('district_code')
        if m.get('whole_address') is not None:
            self.whole_address = m.get('whole_address')
        if m.get('scheme_name') is not None:
            self.scheme_name = m.get('scheme_name')
        if m.get('acpl_bbr_name') is not None:
            self.acpl_bbr_name = m.get('acpl_bbr_name')
        if m.get('acpl_bbr_id_no') is not None:
            self.acpl_bbr_id_no = m.get('acpl_bbr_id_no')
        if m.get('pdt_mkt_code') is not None:
            self.pdt_mkt_code = m.get('pdt_mkt_code')
        return self


class ApplyInsuranceYzbResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        trade_no: str = None,
        policy_no: str = None,
        policy_url: str = None,
        premium: str = None,
        insured_amount: str = None,
        insure_start: str = None,
        insure_end: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 投保唯一码
        self.trade_no = trade_no
        # 保单号
        self.policy_no = policy_no
        # 电子保单链接
        self.policy_url = policy_url
        # 保费
        self.premium = premium
        # 保额
        self.insured_amount = insured_amount
        # 保险起期
        self.insure_start = insure_start
        # 保险止期
        self.insure_end = insure_end

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.policy_no is not None:
            result['policy_no'] = self.policy_no
        if self.policy_url is not None:
            result['policy_url'] = self.policy_url
        if self.premium is not None:
            result['premium'] = self.premium
        if self.insured_amount is not None:
            result['insured_amount'] = self.insured_amount
        if self.insure_start is not None:
            result['insure_start'] = self.insure_start
        if self.insure_end is not None:
            result['insure_end'] = self.insure_end
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('policy_no') is not None:
            self.policy_no = m.get('policy_no')
        if m.get('policy_url') is not None:
            self.policy_url = m.get('policy_url')
        if m.get('premium') is not None:
            self.premium = m.get('premium')
        if m.get('insured_amount') is not None:
            self.insured_amount = m.get('insured_amount')
        if m.get('insure_start') is not None:
            self.insure_start = m.get('insure_start')
        if m.get('insure_end') is not None:
            self.insure_end = m.get('insure_end')
        return self


class ApplyInsuranceCbpiRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        trade_no: str = None,
        external_channel_code: str = None,
        external_product_code: str = None,
        tbr_name: str = None,
        tbr_id_type: str = None,
        tbr_id_no: str = None,
        bbr_name: str = None,
        bbr_id_type: str = None,
        bbr_id_no: str = None,
        beneficiary_name: str = None,
        beneficiary_id_type: str = None,
        beneficiary_no: str = None,
        insure_start: str = None,
        insured_amount: str = None,
        scheme_name: str = None,
        project_name: str = None,
        related_order_no: str = None,
        pick_up_time: str = None,
        courier_company: str = None,
        courier_number: str = None,
        cargo_type: str = None,
        cargo_name: str = None,
        cargo_quantity: str = None,
        buy_id: str = None,
        sell_id: str = None,
        start_place: str = None,
        destination: str = None,
        iso_country: str = None,
        cargo_worth: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 调用方生成的唯一编码，格式为 yyyyMMdd_身份标识_其他编码，系统会根据该流水号做防重、幂等判断逻辑。
        # yyyyMMdd请传递当前时间。
        # 身份标识可自定义。
        # 其他编码建议为随机值。
        # 当极端场景中，系统会返回处理中，错误码为2222，客户端应该保持该流水号不变，并使用原来的请求再次发送请求，系统会根据幂等逻辑返回处理结果；
        self.trade_no = trade_no
        # 保司编码.，PAIC---平安，PICC-人保
        self.external_channel_code = external_channel_code
        # 险种编码，06--跨境邮包险
        self.external_product_code = external_product_code
        # 保险协议中的投保人全称
        self.tbr_name = tbr_name
        # 投保人证件类型，03--营业执照
        # 
        self.tbr_id_type = tbr_id_type
        # 投保人证件号码
        self.tbr_id_no = tbr_id_no
        # 被保人姓名，实际的保险被保人名称
        self.bbr_name = bbr_name
        # 被保人证件类型，01--居民身份证、03--营业执照
        self.bbr_id_type = bbr_id_type
        # 被保人证件号码
        # 
        self.bbr_id_no = bbr_id_no
        # 受益人名称，实际的保险受益人名称
        # 
        self.beneficiary_name = beneficiary_name
        # 受益人证件类型，01--居民身份证、03--营业执照
        self.beneficiary_id_type = beneficiary_id_type
        # 受益人证件号码
        self.beneficiary_no = beneficiary_no
        # 保险起期，日期格式yyyy-MM-dd HH:mm:ss
        # 
        self.insure_start = insure_start
        # 保险金额，单位（元），最多支持2位小数，超过2位拒绝；
        # 
        self.insured_amount = insured_amount
        # 方案名，XBDP—跨境邮包险
        self.scheme_name = scheme_name
        # 项目名称，命名规范“方案种类+物流业务种类+国别”
        self.project_name = project_name
        # 订单号,物流平台用以区分业务的唯一码
        self.related_order_no = related_order_no
        # 寄件时间，日期格式yyyy-MM-dd HH:mm:ss
        self.pick_up_time = pick_up_time
        # 快递公司名称，实际的派送公司全称
        self.courier_company = courier_company
        # 快递单号，实际的派送快递单号
        # 
        self.courier_number = courier_number
        # 货物类型,货物类型的大类
        self.cargo_type = cargo_type
        # 货物名称,实际的货物名称
        self.cargo_name = cargo_name
        # 货物数量
        self.cargo_quantity = cargo_quantity
        # 买家ID,买家的脱敏唯一标识
        self.buy_id = buy_id
        # 卖家ID,卖家的脱敏唯一标识
        self.sell_id = sell_id
        # 出发地地址,包裹的实际发件地地址
        self.start_place = start_place
        # 目的地地址,包裹的实际收件地地址
        self.destination = destination
        # ISO到达国别,包裹业务实际发生的国家
        self.iso_country = iso_country
        # 货物申报价值，单位（元），最多支持2位小数，超过2位拒绝
        self.cargo_worth = cargo_worth

    def validate(self):
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 50)
        self.validate_required(self.external_channel_code, 'external_channel_code')
        if self.external_channel_code is not None:
            self.validate_max_length(self.external_channel_code, 'external_channel_code', 10)
        self.validate_required(self.external_product_code, 'external_product_code')
        if self.external_product_code is not None:
            self.validate_max_length(self.external_product_code, 'external_product_code', 2)
        self.validate_required(self.tbr_name, 'tbr_name')
        if self.tbr_name is not None:
            self.validate_max_length(self.tbr_name, 'tbr_name', 100)
        self.validate_required(self.tbr_id_type, 'tbr_id_type')
        if self.tbr_id_type is not None:
            self.validate_max_length(self.tbr_id_type, 'tbr_id_type', 2)
        self.validate_required(self.tbr_id_no, 'tbr_id_no')
        if self.tbr_id_no is not None:
            self.validate_max_length(self.tbr_id_no, 'tbr_id_no', 30)
        self.validate_required(self.bbr_name, 'bbr_name')
        if self.bbr_name is not None:
            self.validate_max_length(self.bbr_name, 'bbr_name', 100)
        self.validate_required(self.bbr_id_type, 'bbr_id_type')
        if self.bbr_id_type is not None:
            self.validate_max_length(self.bbr_id_type, 'bbr_id_type', 2)
        self.validate_required(self.bbr_id_no, 'bbr_id_no')
        if self.bbr_id_no is not None:
            self.validate_max_length(self.bbr_id_no, 'bbr_id_no', 30)
        self.validate_required(self.beneficiary_name, 'beneficiary_name')
        if self.beneficiary_name is not None:
            self.validate_max_length(self.beneficiary_name, 'beneficiary_name', 100)
        self.validate_required(self.beneficiary_id_type, 'beneficiary_id_type')
        if self.beneficiary_id_type is not None:
            self.validate_max_length(self.beneficiary_id_type, 'beneficiary_id_type', 2)
        self.validate_required(self.beneficiary_no, 'beneficiary_no')
        if self.beneficiary_no is not None:
            self.validate_max_length(self.beneficiary_no, 'beneficiary_no', 30)
        self.validate_required(self.insure_start, 'insure_start')
        self.validate_required(self.insured_amount, 'insured_amount')
        self.validate_required(self.scheme_name, 'scheme_name')
        if self.scheme_name is not None:
            self.validate_max_length(self.scheme_name, 'scheme_name', 100)
        self.validate_required(self.project_name, 'project_name')
        if self.project_name is not None:
            self.validate_max_length(self.project_name, 'project_name', 500)
        self.validate_required(self.related_order_no, 'related_order_no')
        if self.related_order_no is not None:
            self.validate_max_length(self.related_order_no, 'related_order_no', 100)
        self.validate_required(self.pick_up_time, 'pick_up_time')
        self.validate_required(self.courier_company, 'courier_company')
        if self.courier_company is not None:
            self.validate_max_length(self.courier_company, 'courier_company', 200)
        self.validate_required(self.courier_number, 'courier_number')
        if self.courier_number is not None:
            self.validate_max_length(self.courier_number, 'courier_number', 100)
        self.validate_required(self.cargo_type, 'cargo_type')
        if self.cargo_type is not None:
            self.validate_max_length(self.cargo_type, 'cargo_type', 100)
        self.validate_required(self.cargo_name, 'cargo_name')
        if self.cargo_name is not None:
            self.validate_max_length(self.cargo_name, 'cargo_name', 200)
        self.validate_required(self.cargo_quantity, 'cargo_quantity')
        self.validate_required(self.buy_id, 'buy_id')
        if self.buy_id is not None:
            self.validate_max_length(self.buy_id, 'buy_id', 100)
        self.validate_required(self.sell_id, 'sell_id')
        if self.sell_id is not None:
            self.validate_max_length(self.sell_id, 'sell_id', 100)
        self.validate_required(self.start_place, 'start_place')
        if self.start_place is not None:
            self.validate_max_length(self.start_place, 'start_place', 500)
        self.validate_required(self.destination, 'destination')
        if self.destination is not None:
            self.validate_max_length(self.destination, 'destination', 500)
        self.validate_required(self.iso_country, 'iso_country')
        if self.iso_country is not None:
            self.validate_max_length(self.iso_country, 'iso_country', 10)
        self.validate_required(self.cargo_worth, 'cargo_worth')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.external_channel_code is not None:
            result['external_channel_code'] = self.external_channel_code
        if self.external_product_code is not None:
            result['external_product_code'] = self.external_product_code
        if self.tbr_name is not None:
            result['tbr_name'] = self.tbr_name
        if self.tbr_id_type is not None:
            result['tbr_id_type'] = self.tbr_id_type
        if self.tbr_id_no is not None:
            result['tbr_id_no'] = self.tbr_id_no
        if self.bbr_name is not None:
            result['bbr_name'] = self.bbr_name
        if self.bbr_id_type is not None:
            result['bbr_id_type'] = self.bbr_id_type
        if self.bbr_id_no is not None:
            result['bbr_id_no'] = self.bbr_id_no
        if self.beneficiary_name is not None:
            result['beneficiary_name'] = self.beneficiary_name
        if self.beneficiary_id_type is not None:
            result['beneficiary_id_type'] = self.beneficiary_id_type
        if self.beneficiary_no is not None:
            result['beneficiary_no'] = self.beneficiary_no
        if self.insure_start is not None:
            result['insure_start'] = self.insure_start
        if self.insured_amount is not None:
            result['insured_amount'] = self.insured_amount
        if self.scheme_name is not None:
            result['scheme_name'] = self.scheme_name
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.related_order_no is not None:
            result['related_order_no'] = self.related_order_no
        if self.pick_up_time is not None:
            result['pick_up_time'] = self.pick_up_time
        if self.courier_company is not None:
            result['courier_company'] = self.courier_company
        if self.courier_number is not None:
            result['courier_number'] = self.courier_number
        if self.cargo_type is not None:
            result['cargo_type'] = self.cargo_type
        if self.cargo_name is not None:
            result['cargo_name'] = self.cargo_name
        if self.cargo_quantity is not None:
            result['cargo_quantity'] = self.cargo_quantity
        if self.buy_id is not None:
            result['buy_id'] = self.buy_id
        if self.sell_id is not None:
            result['sell_id'] = self.sell_id
        if self.start_place is not None:
            result['start_place'] = self.start_place
        if self.destination is not None:
            result['destination'] = self.destination
        if self.iso_country is not None:
            result['iso_country'] = self.iso_country
        if self.cargo_worth is not None:
            result['cargo_worth'] = self.cargo_worth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('external_channel_code') is not None:
            self.external_channel_code = m.get('external_channel_code')
        if m.get('external_product_code') is not None:
            self.external_product_code = m.get('external_product_code')
        if m.get('tbr_name') is not None:
            self.tbr_name = m.get('tbr_name')
        if m.get('tbr_id_type') is not None:
            self.tbr_id_type = m.get('tbr_id_type')
        if m.get('tbr_id_no') is not None:
            self.tbr_id_no = m.get('tbr_id_no')
        if m.get('bbr_name') is not None:
            self.bbr_name = m.get('bbr_name')
        if m.get('bbr_id_type') is not None:
            self.bbr_id_type = m.get('bbr_id_type')
        if m.get('bbr_id_no') is not None:
            self.bbr_id_no = m.get('bbr_id_no')
        if m.get('beneficiary_name') is not None:
            self.beneficiary_name = m.get('beneficiary_name')
        if m.get('beneficiary_id_type') is not None:
            self.beneficiary_id_type = m.get('beneficiary_id_type')
        if m.get('beneficiary_no') is not None:
            self.beneficiary_no = m.get('beneficiary_no')
        if m.get('insure_start') is not None:
            self.insure_start = m.get('insure_start')
        if m.get('insured_amount') is not None:
            self.insured_amount = m.get('insured_amount')
        if m.get('scheme_name') is not None:
            self.scheme_name = m.get('scheme_name')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('related_order_no') is not None:
            self.related_order_no = m.get('related_order_no')
        if m.get('pick_up_time') is not None:
            self.pick_up_time = m.get('pick_up_time')
        if m.get('courier_company') is not None:
            self.courier_company = m.get('courier_company')
        if m.get('courier_number') is not None:
            self.courier_number = m.get('courier_number')
        if m.get('cargo_type') is not None:
            self.cargo_type = m.get('cargo_type')
        if m.get('cargo_name') is not None:
            self.cargo_name = m.get('cargo_name')
        if m.get('cargo_quantity') is not None:
            self.cargo_quantity = m.get('cargo_quantity')
        if m.get('buy_id') is not None:
            self.buy_id = m.get('buy_id')
        if m.get('sell_id') is not None:
            self.sell_id = m.get('sell_id')
        if m.get('start_place') is not None:
            self.start_place = m.get('start_place')
        if m.get('destination') is not None:
            self.destination = m.get('destination')
        if m.get('iso_country') is not None:
            self.iso_country = m.get('iso_country')
        if m.get('cargo_worth') is not None:
            self.cargo_worth = m.get('cargo_worth')
        return self


class ApplyInsuranceCbpiResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        trade_no: str = None,
        policy_no: str = None,
        premium: str = None,
        insured_amount: str = None,
        insure_start: str = None,
        insure_end: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 投保唯一码
        # 
        self.trade_no = trade_no
        # 保单号
        # 
        self.policy_no = policy_no
        # 保费
        # 
        self.premium = premium
        # 保额
        # 
        self.insured_amount = insured_amount
        # 保险起期
        # 
        self.insure_start = insure_start
        # 保险止期
        # 
        self.insure_end = insure_end

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.policy_no is not None:
            result['policy_no'] = self.policy_no
        if self.premium is not None:
            result['premium'] = self.premium
        if self.insured_amount is not None:
            result['insured_amount'] = self.insured_amount
        if self.insure_start is not None:
            result['insure_start'] = self.insure_start
        if self.insure_end is not None:
            result['insure_end'] = self.insure_end
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('policy_no') is not None:
            self.policy_no = m.get('policy_no')
        if m.get('premium') is not None:
            self.premium = m.get('premium')
        if m.get('insured_amount') is not None:
            self.insured_amount = m.get('insured_amount')
        if m.get('insure_start') is not None:
            self.insure_start = m.get('insure_start')
        if m.get('insure_end') is not None:
            self.insure_end = m.get('insure_end')
        return self


class ApplyInsuranceYzbreportRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        trade_no: str = None,
        external_channel_code: str = None,
        external_product_code: str = None,
        policy_no: str = None,
        report_unique_key: str = None,
        claim_apply_person: str = None,
        reporter_name: str = None,
        reporter_contact: str = None,
        accident_time: str = None,
        accident_city_code: str = None,
        accident_district_code: str = None,
        accident_address: str = None,
        accident_detail: str = None,
        accident_cause_code: str = None,
        loss_type: str = None,
        loss_estimate_total_amount: str = None,
        complaint_job_no: str = None,
        courier_company: str = None,
        way_bill_no: str = None,
        payment_info: PaymentInfo = None,
        person_loss: PersonLoss = None,
        car_loss: CarLoss = None,
        cargo_loss: CargoLoss = None,
        documents: List[Document] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 调用方生成的唯一编码，格式为 yyyyMMdd_身份标识_其他编码，系统会根据该流水号做防重、幂等判断逻辑。
        # yyyyMMdd请传递当前时间。
        # 身份标识可自定义。
        # 其他编码建议为随机值。
        # 当极端场景中，系统会返回处理中，错误码为2222，客户端应该保持该流水号不变，并使用原来的请求再次发送请求，系统会根据幂等逻辑返回处理结果；
        self.trade_no = trade_no
        # 保司编码，PAIC---平安
        self.external_channel_code = external_channel_code
        # 险种编码，05-驿站宝
        self.external_product_code = external_product_code
        # 保单号，申请理赔的保单号
        self.policy_no = policy_no
        # 报案唯一标识，申请理赔所关联的订单号，如一个订单会存在多次理赔，请用唯一标识
        self.report_unique_key = report_unique_key
        # 理赔申请人
        self.claim_apply_person = claim_apply_person
        # 报案人名称
        self.reporter_name = reporter_name
        # 报案人联系方式
        self.reporter_contact = reporter_contact
        # 出险时间，发生损失的时间 yyyy-mm-dd hh:mm:ss
        self.accident_time = accident_time
        # 出险城市编码，国家地理位置编码6位城市编码
        self.accident_city_code = accident_city_code
        # 出险区县编码，国家地理位置编码6位城市编码
        self.accident_district_code = accident_district_code
        # 出险详细地址，事发出险地的详细地址
        self.accident_address = accident_address
        # 出险详细经过
        self.accident_detail = accident_detail
        # 出险原因代码，包裹破损丢失-R3028，火灾-R3025，爆炸-R3026，水湿-R3036，自燃-R3038，其他意外-R3039
        self.accident_cause_code = accident_cause_code
        # 损失类型，1-人伤，2-车损,，3-物损，6-其它损失，多种损失以英文逗号分隔
        self.loss_type = loss_type
        # 损失预估总金额，单位（元），最多支持2位小数
        self.loss_estimate_total_amount = loss_estimate_total_amount
        # 投诉工单号，申请理赔所关联的投诉工单号，包裹出险可填
        self.complaint_job_no = complaint_job_no
        # 快递公司，申请理赔所关联的快递公司名称，包裹出险可填
        self.courier_company = courier_company
        # 运单号，申请理赔所关联的运单号，包裹出险可填
        self.way_bill_no = way_bill_no
        # 支付信息
        self.payment_info = payment_info
        # 人员伤残情况
        self.person_loss = person_loss
        # 车辆损失详情
        self.car_loss = car_loss
        # 货物损失详情
        self.cargo_loss = cargo_loss
        # 文档信息
        self.documents = documents

    def validate(self):
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 50)
        self.validate_required(self.external_channel_code, 'external_channel_code')
        if self.external_channel_code is not None:
            self.validate_max_length(self.external_channel_code, 'external_channel_code', 10)
        self.validate_required(self.external_product_code, 'external_product_code')
        if self.external_product_code is not None:
            self.validate_max_length(self.external_product_code, 'external_product_code', 2)
        self.validate_required(self.policy_no, 'policy_no')
        if self.policy_no is not None:
            self.validate_max_length(self.policy_no, 'policy_no', 200)
        self.validate_required(self.report_unique_key, 'report_unique_key')
        if self.report_unique_key is not None:
            self.validate_max_length(self.report_unique_key, 'report_unique_key', 200)
        self.validate_required(self.claim_apply_person, 'claim_apply_person')
        if self.claim_apply_person is not None:
            self.validate_max_length(self.claim_apply_person, 'claim_apply_person', 100)
        self.validate_required(self.reporter_name, 'reporter_name')
        if self.reporter_name is not None:
            self.validate_max_length(self.reporter_name, 'reporter_name', 100)
        self.validate_required(self.reporter_contact, 'reporter_contact')
        if self.reporter_contact is not None:
            self.validate_max_length(self.reporter_contact, 'reporter_contact', 20)
        self.validate_required(self.accident_time, 'accident_time')
        self.validate_required(self.accident_city_code, 'accident_city_code')
        if self.accident_city_code is not None:
            self.validate_max_length(self.accident_city_code, 'accident_city_code', 10)
        self.validate_required(self.accident_district_code, 'accident_district_code')
        if self.accident_district_code is not None:
            self.validate_max_length(self.accident_district_code, 'accident_district_code', 10)
        self.validate_required(self.accident_address, 'accident_address')
        if self.accident_address is not None:
            self.validate_max_length(self.accident_address, 'accident_address', 500)
        self.validate_required(self.accident_detail, 'accident_detail')
        if self.accident_detail is not None:
            self.validate_max_length(self.accident_detail, 'accident_detail', 500)
        self.validate_required(self.accident_cause_code, 'accident_cause_code')
        if self.accident_cause_code is not None:
            self.validate_max_length(self.accident_cause_code, 'accident_cause_code', 10)
        self.validate_required(self.loss_type, 'loss_type')
        if self.loss_type is not None:
            self.validate_max_length(self.loss_type, 'loss_type', 50)
        self.validate_required(self.loss_estimate_total_amount, 'loss_estimate_total_amount')
        if self.complaint_job_no is not None:
            self.validate_max_length(self.complaint_job_no, 'complaint_job_no', 100)
        if self.courier_company is not None:
            self.validate_max_length(self.courier_company, 'courier_company', 200)
        if self.way_bill_no is not None:
            self.validate_max_length(self.way_bill_no, 'way_bill_no', 100)
        if self.payment_info:
            self.payment_info.validate()
        if self.person_loss:
            self.person_loss.validate()
        if self.car_loss:
            self.car_loss.validate()
        if self.cargo_loss:
            self.cargo_loss.validate()
        if self.documents:
            for k in self.documents:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.external_channel_code is not None:
            result['external_channel_code'] = self.external_channel_code
        if self.external_product_code is not None:
            result['external_product_code'] = self.external_product_code
        if self.policy_no is not None:
            result['policy_no'] = self.policy_no
        if self.report_unique_key is not None:
            result['report_unique_key'] = self.report_unique_key
        if self.claim_apply_person is not None:
            result['claim_apply_person'] = self.claim_apply_person
        if self.reporter_name is not None:
            result['reporter_name'] = self.reporter_name
        if self.reporter_contact is not None:
            result['reporter_contact'] = self.reporter_contact
        if self.accident_time is not None:
            result['accident_time'] = self.accident_time
        if self.accident_city_code is not None:
            result['accident_city_code'] = self.accident_city_code
        if self.accident_district_code is not None:
            result['accident_district_code'] = self.accident_district_code
        if self.accident_address is not None:
            result['accident_address'] = self.accident_address
        if self.accident_detail is not None:
            result['accident_detail'] = self.accident_detail
        if self.accident_cause_code is not None:
            result['accident_cause_code'] = self.accident_cause_code
        if self.loss_type is not None:
            result['loss_type'] = self.loss_type
        if self.loss_estimate_total_amount is not None:
            result['loss_estimate_total_amount'] = self.loss_estimate_total_amount
        if self.complaint_job_no is not None:
            result['complaint_job_no'] = self.complaint_job_no
        if self.courier_company is not None:
            result['courier_company'] = self.courier_company
        if self.way_bill_no is not None:
            result['way_bill_no'] = self.way_bill_no
        if self.payment_info is not None:
            result['payment_info'] = self.payment_info.to_map()
        if self.person_loss is not None:
            result['person_loss'] = self.person_loss.to_map()
        if self.car_loss is not None:
            result['car_loss'] = self.car_loss.to_map()
        if self.cargo_loss is not None:
            result['cargo_loss'] = self.cargo_loss.to_map()
        result['documents'] = []
        if self.documents is not None:
            for k in self.documents:
                result['documents'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('external_channel_code') is not None:
            self.external_channel_code = m.get('external_channel_code')
        if m.get('external_product_code') is not None:
            self.external_product_code = m.get('external_product_code')
        if m.get('policy_no') is not None:
            self.policy_no = m.get('policy_no')
        if m.get('report_unique_key') is not None:
            self.report_unique_key = m.get('report_unique_key')
        if m.get('claim_apply_person') is not None:
            self.claim_apply_person = m.get('claim_apply_person')
        if m.get('reporter_name') is not None:
            self.reporter_name = m.get('reporter_name')
        if m.get('reporter_contact') is not None:
            self.reporter_contact = m.get('reporter_contact')
        if m.get('accident_time') is not None:
            self.accident_time = m.get('accident_time')
        if m.get('accident_city_code') is not None:
            self.accident_city_code = m.get('accident_city_code')
        if m.get('accident_district_code') is not None:
            self.accident_district_code = m.get('accident_district_code')
        if m.get('accident_address') is not None:
            self.accident_address = m.get('accident_address')
        if m.get('accident_detail') is not None:
            self.accident_detail = m.get('accident_detail')
        if m.get('accident_cause_code') is not None:
            self.accident_cause_code = m.get('accident_cause_code')
        if m.get('loss_type') is not None:
            self.loss_type = m.get('loss_type')
        if m.get('loss_estimate_total_amount') is not None:
            self.loss_estimate_total_amount = m.get('loss_estimate_total_amount')
        if m.get('complaint_job_no') is not None:
            self.complaint_job_no = m.get('complaint_job_no')
        if m.get('courier_company') is not None:
            self.courier_company = m.get('courier_company')
        if m.get('way_bill_no') is not None:
            self.way_bill_no = m.get('way_bill_no')
        if m.get('payment_info') is not None:
            temp_model = PaymentInfo()
            self.payment_info = temp_model.from_map(m['payment_info'])
        if m.get('person_loss') is not None:
            temp_model = PersonLoss()
            self.person_loss = temp_model.from_map(m['person_loss'])
        if m.get('car_loss') is not None:
            temp_model = CarLoss()
            self.car_loss = temp_model.from_map(m['car_loss'])
        if m.get('cargo_loss') is not None:
            temp_model = CargoLoss()
            self.cargo_loss = temp_model.from_map(m['cargo_loss'])
        self.documents = []
        if m.get('documents') is not None:
            for k in m.get('documents'):
                temp_model = Document()
                self.documents.append(temp_model.from_map(k))
        return self


class ApplyInsuranceYzbreportResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        trade_no: str = None,
        report_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 报案唯一码
        self.trade_no = trade_no
        # 报案号
        self.report_no = report_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.report_no is not None:
            result['report_no'] = self.report_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('report_no') is not None:
            self.report_no = m.get('report_no')
        return self


class QueryInsuranceYzbreportRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        external_channel_code: str = None,
        policy_no: str = None,
        report_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 保司编码，PAIC---平安
        # 
        self.external_channel_code = external_channel_code
        # 保单号
        self.policy_no = policy_no
        # 报案号
        self.report_no = report_no

    def validate(self):
        self.validate_required(self.external_channel_code, 'external_channel_code')
        if self.external_channel_code is not None:
            self.validate_max_length(self.external_channel_code, 'external_channel_code', 10)
        self.validate_required(self.policy_no, 'policy_no')
        if self.policy_no is not None:
            self.validate_max_length(self.policy_no, 'policy_no', 200)
        self.validate_required(self.report_no, 'report_no')
        if self.report_no is not None:
            self.validate_max_length(self.report_no, 'report_no', 100)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.external_channel_code is not None:
            result['external_channel_code'] = self.external_channel_code
        if self.policy_no is not None:
            result['policy_no'] = self.policy_no
        if self.report_no is not None:
            result['report_no'] = self.report_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('external_channel_code') is not None:
            self.external_channel_code = m.get('external_channel_code')
        if m.get('policy_no') is not None:
            self.policy_no = m.get('policy_no')
        if m.get('report_no') is not None:
            self.report_no = m.get('report_no')
        return self


class QueryInsuranceYzbreportResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        report_no: str = None,
        policy_no: str = None,
        claim_no: str = None,
        report_req_time: str = None,
        report_status: str = None,
        report_paid_amount: str = None,
        external_product_name: str = None,
        report_end_time: str = None,
        report_paid_desc: str = None,
        report_paid_time: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 报案号
        self.report_no = report_no
        # 保单号
        self.policy_no = policy_no
        # 赔案号
        self.claim_no = claim_no
        # 报案时间，格式yyyy-mm-dd hh:mm:ss
        self.report_req_time = report_req_time
        # 案件状态，已报案，已结案，已赔付
        self.report_status = report_status
        # 案件赔付金额，单位元，两位小数;
        self.report_paid_amount = report_paid_amount
        # 险种名称
        self.external_product_name = external_product_name
        # 结案时间，格式yyyy-mm-dd hh:mm:ss
        self.report_end_time = report_end_time
        # 案件赔付结论，1-赔付 2-零结 3-商业险拒赔 4-整案拒赔 5-注销
        self.report_paid_desc = report_paid_desc
        # 案件赔付时间，格式yyyy-mm-dd hh:mm:ss
        # 
        self.report_paid_time = report_paid_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.report_no is not None:
            result['report_no'] = self.report_no
        if self.policy_no is not None:
            result['policy_no'] = self.policy_no
        if self.claim_no is not None:
            result['claim_no'] = self.claim_no
        if self.report_req_time is not None:
            result['report_req_time'] = self.report_req_time
        if self.report_status is not None:
            result['report_status'] = self.report_status
        if self.report_paid_amount is not None:
            result['report_paid_amount'] = self.report_paid_amount
        if self.external_product_name is not None:
            result['external_product_name'] = self.external_product_name
        if self.report_end_time is not None:
            result['report_end_time'] = self.report_end_time
        if self.report_paid_desc is not None:
            result['report_paid_desc'] = self.report_paid_desc
        if self.report_paid_time is not None:
            result['report_paid_time'] = self.report_paid_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('report_no') is not None:
            self.report_no = m.get('report_no')
        if m.get('policy_no') is not None:
            self.policy_no = m.get('policy_no')
        if m.get('claim_no') is not None:
            self.claim_no = m.get('claim_no')
        if m.get('report_req_time') is not None:
            self.report_req_time = m.get('report_req_time')
        if m.get('report_status') is not None:
            self.report_status = m.get('report_status')
        if m.get('report_paid_amount') is not None:
            self.report_paid_amount = m.get('report_paid_amount')
        if m.get('external_product_name') is not None:
            self.external_product_name = m.get('external_product_name')
        if m.get('report_end_time') is not None:
            self.report_end_time = m.get('report_end_time')
        if m.get('report_paid_desc') is not None:
            self.report_paid_desc = m.get('report_paid_desc')
        if m.get('report_paid_time') is not None:
            self.report_paid_time = m.get('report_paid_time')
        return self


class SaveInsuranceWaybillRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        trade_no: str = None,
        waybill_no: str = None,
        delivery_company: str = None,
        consignor: str = None,
        delivery_address: str = None,
        cargo_name: str = None,
        cargo_quantity: str = None,
        cargo_weight: str = None,
        cargo_dimensions: str = None,
        pickup_outlets: str = None,
        departure_station: str = None,
        destination_station: str = None,
        dispatch_outlets: str = None,
        consignee: str = None,
        receiving_address: str = None,
        trunk_line_carrier: str = None,
        trunk_line_car_number: str = None,
        driver_name: str = None,
        driver_contact: str = None,
        waybill_create_time: str = None,
        trunk_line_departure_time: str = None,
        trunk_line_arrival_time: str = None,
        freight: str = None,
        waybill_status: str = None,
        take_cargo_car_number: str = None,
        short_barge_car_number: str = None,
        delivery_car_number: str = None,
        waybill_action_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 调用方生成的唯一编码，格式为 yyyyMMdd_身份标识_其他编码，系统会根据该流水号做防重、幂等判断逻辑。
        # yyyyMMdd请传递当前时间。
        # 身份标识可自定义。
        # 其他编码建议为随机值。
        # 当极端场景中，系统会返回处理中，错误码为2222，客户端应该保持该流水号不变，并使用原来的请求再次发送请求，系统会根据幂等逻辑返回处理结果；
        # 
        self.trade_no = trade_no
        # 运单号，客户侧系统的运单唯一识别号
        self.waybill_no = waybill_no
        # 发货单位，客户唯一识别码或脱敏标识
        self.delivery_company = delivery_company
        # 发货人，客户唯一识别码或脱敏标识
        self.consignor = consignor
        # 发货地址，地址可脱敏，不需要精确到门牌号
        self.delivery_address = delivery_address
        # 货物名称
        self.cargo_name = cargo_name
        # 货物数量，单位（件）
        self.cargo_quantity = cargo_quantity
        # 货物重量，单位（kg）
        self.cargo_weight = cargo_weight
        # 货物体积，单位（方）
        self.cargo_dimensions = cargo_dimensions
        # 揽件网点，货物出发地的揽件网点
        self.pickup_outlets = pickup_outlets
        # 出发站，专线出发站点
        self.departure_station = departure_station
        # 到达站，专线到达站点
        self.destination_station = destination_station
        # 派件网点，货物目的地的派件网点
        self.dispatch_outlets = dispatch_outlets
        # 收货人，客户唯一识别码或脱敏标识
        self.consignee = consignee
        # 收货地址，地址可脱敏，不需要精确到门牌号
        self.receiving_address = receiving_address
        # 干线承运商
        self.trunk_line_carrier = trunk_line_carrier
        # 干线车牌号
        self.trunk_line_car_number = trunk_line_car_number
        # 司机姓名
        self.driver_name = driver_name
        # 司机联系方式
        self.driver_contact = driver_contact
        # 运单创建时间，格式：yyyy-mm-dd hh:mm:ss
        self.waybill_create_time = waybill_create_time
        # 干线运输发车时间，格式要求：yyyy-mm-dd hh:mm:ss
        self.trunk_line_departure_time = trunk_line_departure_time
        # 干线运输到达时间，格式要求：yyyy-mm-dd hh:mm:ss
        self.trunk_line_arrival_time = trunk_line_arrival_time
        # 运费总金额，单位（元），最多2位小数
        self.freight = freight
        # 运单状态，客户系统中实际的当前运单状态
        self.waybill_status = waybill_status
        # 提货车牌号
        self.take_cargo_car_number = take_cargo_car_number
        # 短驳车牌号
        self.short_barge_car_number = short_barge_car_number
        # 送货车牌号
        self.delivery_car_number = delivery_car_number
        # 运单操作类型，CREATE -创建，UPDATE-更新
        self.waybill_action_type = waybill_action_type

    def validate(self):
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 50)
        self.validate_required(self.waybill_no, 'waybill_no')
        if self.waybill_no is not None:
            self.validate_max_length(self.waybill_no, 'waybill_no', 200)
        if self.delivery_company is not None:
            self.validate_max_length(self.delivery_company, 'delivery_company', 200)
        self.validate_required(self.consignor, 'consignor')
        if self.consignor is not None:
            self.validate_max_length(self.consignor, 'consignor', 200)
        if self.delivery_address is not None:
            self.validate_max_length(self.delivery_address, 'delivery_address', 500)
        self.validate_required(self.cargo_name, 'cargo_name')
        if self.cargo_name is not None:
            self.validate_max_length(self.cargo_name, 'cargo_name', 500)
        self.validate_required(self.cargo_quantity, 'cargo_quantity')
        if self.cargo_quantity is not None:
            self.validate_max_length(self.cargo_quantity, 'cargo_quantity', 20)
        if self.cargo_weight is not None:
            self.validate_max_length(self.cargo_weight, 'cargo_weight', 20)
        if self.cargo_dimensions is not None:
            self.validate_max_length(self.cargo_dimensions, 'cargo_dimensions', 20)
        if self.pickup_outlets is not None:
            self.validate_max_length(self.pickup_outlets, 'pickup_outlets', 200)
        self.validate_required(self.departure_station, 'departure_station')
        if self.departure_station is not None:
            self.validate_max_length(self.departure_station, 'departure_station', 200)
        self.validate_required(self.destination_station, 'destination_station')
        if self.destination_station is not None:
            self.validate_max_length(self.destination_station, 'destination_station', 200)
        if self.dispatch_outlets is not None:
            self.validate_max_length(self.dispatch_outlets, 'dispatch_outlets', 200)
        if self.consignee is not None:
            self.validate_max_length(self.consignee, 'consignee', 200)
        if self.receiving_address is not None:
            self.validate_max_length(self.receiving_address, 'receiving_address', 500)
        if self.trunk_line_carrier is not None:
            self.validate_max_length(self.trunk_line_carrier, 'trunk_line_carrier', 200)
        if self.trunk_line_car_number is not None:
            self.validate_max_length(self.trunk_line_car_number, 'trunk_line_car_number', 20)
        if self.driver_name is not None:
            self.validate_max_length(self.driver_name, 'driver_name', 200)
        if self.driver_contact is not None:
            self.validate_max_length(self.driver_contact, 'driver_contact', 20)
        self.validate_required(self.waybill_create_time, 'waybill_create_time')
        self.validate_required(self.freight, 'freight')
        self.validate_required(self.waybill_status, 'waybill_status')
        if self.waybill_status is not None:
            self.validate_max_length(self.waybill_status, 'waybill_status', 200)
        if self.take_cargo_car_number is not None:
            self.validate_max_length(self.take_cargo_car_number, 'take_cargo_car_number', 20)
        if self.short_barge_car_number is not None:
            self.validate_max_length(self.short_barge_car_number, 'short_barge_car_number', 20)
        if self.delivery_car_number is not None:
            self.validate_max_length(self.delivery_car_number, 'delivery_car_number', 20)
        self.validate_required(self.waybill_action_type, 'waybill_action_type')
        if self.waybill_action_type is not None:
            self.validate_max_length(self.waybill_action_type, 'waybill_action_type', 20)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.waybill_no is not None:
            result['waybill_no'] = self.waybill_no
        if self.delivery_company is not None:
            result['delivery_company'] = self.delivery_company
        if self.consignor is not None:
            result['consignor'] = self.consignor
        if self.delivery_address is not None:
            result['delivery_address'] = self.delivery_address
        if self.cargo_name is not None:
            result['cargo_name'] = self.cargo_name
        if self.cargo_quantity is not None:
            result['cargo_quantity'] = self.cargo_quantity
        if self.cargo_weight is not None:
            result['cargo_weight'] = self.cargo_weight
        if self.cargo_dimensions is not None:
            result['cargo_dimensions'] = self.cargo_dimensions
        if self.pickup_outlets is not None:
            result['pickup_outlets'] = self.pickup_outlets
        if self.departure_station is not None:
            result['departure_station'] = self.departure_station
        if self.destination_station is not None:
            result['destination_station'] = self.destination_station
        if self.dispatch_outlets is not None:
            result['dispatch_outlets'] = self.dispatch_outlets
        if self.consignee is not None:
            result['consignee'] = self.consignee
        if self.receiving_address is not None:
            result['receiving_address'] = self.receiving_address
        if self.trunk_line_carrier is not None:
            result['trunk_line_carrier'] = self.trunk_line_carrier
        if self.trunk_line_car_number is not None:
            result['trunk_line_car_number'] = self.trunk_line_car_number
        if self.driver_name is not None:
            result['driver_name'] = self.driver_name
        if self.driver_contact is not None:
            result['driver_contact'] = self.driver_contact
        if self.waybill_create_time is not None:
            result['waybill_create_time'] = self.waybill_create_time
        if self.trunk_line_departure_time is not None:
            result['trunk_line_departure_time'] = self.trunk_line_departure_time
        if self.trunk_line_arrival_time is not None:
            result['trunk_line_arrival_time'] = self.trunk_line_arrival_time
        if self.freight is not None:
            result['freight'] = self.freight
        if self.waybill_status is not None:
            result['waybill_status'] = self.waybill_status
        if self.take_cargo_car_number is not None:
            result['take_cargo_car_number'] = self.take_cargo_car_number
        if self.short_barge_car_number is not None:
            result['short_barge_car_number'] = self.short_barge_car_number
        if self.delivery_car_number is not None:
            result['delivery_car_number'] = self.delivery_car_number
        if self.waybill_action_type is not None:
            result['waybill_action_type'] = self.waybill_action_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('waybill_no') is not None:
            self.waybill_no = m.get('waybill_no')
        if m.get('delivery_company') is not None:
            self.delivery_company = m.get('delivery_company')
        if m.get('consignor') is not None:
            self.consignor = m.get('consignor')
        if m.get('delivery_address') is not None:
            self.delivery_address = m.get('delivery_address')
        if m.get('cargo_name') is not None:
            self.cargo_name = m.get('cargo_name')
        if m.get('cargo_quantity') is not None:
            self.cargo_quantity = m.get('cargo_quantity')
        if m.get('cargo_weight') is not None:
            self.cargo_weight = m.get('cargo_weight')
        if m.get('cargo_dimensions') is not None:
            self.cargo_dimensions = m.get('cargo_dimensions')
        if m.get('pickup_outlets') is not None:
            self.pickup_outlets = m.get('pickup_outlets')
        if m.get('departure_station') is not None:
            self.departure_station = m.get('departure_station')
        if m.get('destination_station') is not None:
            self.destination_station = m.get('destination_station')
        if m.get('dispatch_outlets') is not None:
            self.dispatch_outlets = m.get('dispatch_outlets')
        if m.get('consignee') is not None:
            self.consignee = m.get('consignee')
        if m.get('receiving_address') is not None:
            self.receiving_address = m.get('receiving_address')
        if m.get('trunk_line_carrier') is not None:
            self.trunk_line_carrier = m.get('trunk_line_carrier')
        if m.get('trunk_line_car_number') is not None:
            self.trunk_line_car_number = m.get('trunk_line_car_number')
        if m.get('driver_name') is not None:
            self.driver_name = m.get('driver_name')
        if m.get('driver_contact') is not None:
            self.driver_contact = m.get('driver_contact')
        if m.get('waybill_create_time') is not None:
            self.waybill_create_time = m.get('waybill_create_time')
        if m.get('trunk_line_departure_time') is not None:
            self.trunk_line_departure_time = m.get('trunk_line_departure_time')
        if m.get('trunk_line_arrival_time') is not None:
            self.trunk_line_arrival_time = m.get('trunk_line_arrival_time')
        if m.get('freight') is not None:
            self.freight = m.get('freight')
        if m.get('waybill_status') is not None:
            self.waybill_status = m.get('waybill_status')
        if m.get('take_cargo_car_number') is not None:
            self.take_cargo_car_number = m.get('take_cargo_car_number')
        if m.get('short_barge_car_number') is not None:
            self.short_barge_car_number = m.get('short_barge_car_number')
        if m.get('delivery_car_number') is not None:
            self.delivery_car_number = m.get('delivery_car_number')
        if m.get('waybill_action_type') is not None:
            self.waybill_action_type = m.get('waybill_action_type')
        return self


class SaveInsuranceWaybillResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        waybill_action_type: str = None,
        trade_no: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 运单操作类型，与请求参数中一致
        self.waybill_action_type = waybill_action_type
        # 交易流水号，与请求参数中一致
        self.trade_no = trade_no

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.waybill_action_type is not None:
            result['waybill_action_type'] = self.waybill_action_type
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('waybill_action_type') is not None:
            self.waybill_action_type = m.get('waybill_action_type')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        return self


class QueryInsuranceEpolicyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        apply_trade_no: str = None,
        policy_no: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 投保返回的交易流水号
        self.apply_trade_no = apply_trade_no
        # 保单号
        self.policy_no = policy_no

    def validate(self):
        self.validate_required(self.apply_trade_no, 'apply_trade_no')
        if self.apply_trade_no is not None:
            self.validate_max_length(self.apply_trade_no, 'apply_trade_no', 50)
        self.validate_required(self.policy_no, 'policy_no')
        if self.policy_no is not None:
            self.validate_max_length(self.policy_no, 'policy_no', 64)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.apply_trade_no is not None:
            result['apply_trade_no'] = self.apply_trade_no
        if self.policy_no is not None:
            result['policy_no'] = self.policy_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('apply_trade_no') is not None:
            self.apply_trade_no = m.get('apply_trade_no')
        if m.get('policy_no') is not None:
            self.policy_no = m.get('policy_no')
        return self


class QueryInsuranceEpolicyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        policy_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 电子保单url地址
        self.policy_url = policy_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.policy_url is not None:
            result['policy_url'] = self.policy_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('policy_url') is not None:
            self.policy_url = m.get('policy_url')
        return self


class NotifyInsuranceReportresultRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        trade_no: str = None,
        channel_simple_code: str = None,
        report_no: str = None,
        rela_order_no: str = None,
        claim_amount: str = None,
        payment_time: str = None,
        bank_serial_num: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 案件同步唯一码，调用方生成的唯一编码； 格式为 yyyyMMdd_身份标识_其他编码，yyyyMMdd请传递当前时间。 系统会根据该流水号做防重、幂等判断逻辑。
        # 
        self.trade_no = trade_no
        # 渠道简称code
        self.channel_simple_code = channel_simple_code
        # 报案号，关联的报案案件号
        # 
        self.report_no = report_no
        # 订单号
        # 
        self.rela_order_no = rela_order_no
        # 理赔金额(元)，实际的理赔金额，最多支持2位小数，超2位小数拒绝请求
        # 
        self.claim_amount = claim_amount
        # 支付时间，实际的保司打款时间，格式：yyyy-MM-dd HH:mm:ss
        # 
        self.payment_time = payment_time
        # 银行流水，打款的银行流水号
        # 
        self.bank_serial_num = bank_serial_num

    def validate(self):
        self.validate_required(self.trade_no, 'trade_no')
        if self.trade_no is not None:
            self.validate_max_length(self.trade_no, 'trade_no', 50)
        self.validate_required(self.channel_simple_code, 'channel_simple_code')
        if self.channel_simple_code is not None:
            self.validate_max_length(self.channel_simple_code, 'channel_simple_code', 16)
        self.validate_required(self.report_no, 'report_no')
        if self.report_no is not None:
            self.validate_max_length(self.report_no, 'report_no', 100)
        self.validate_required(self.rela_order_no, 'rela_order_no')
        if self.rela_order_no is not None:
            self.validate_max_length(self.rela_order_no, 'rela_order_no', 100)
        self.validate_required(self.claim_amount, 'claim_amount')
        self.validate_required(self.payment_time, 'payment_time')
        self.validate_required(self.bank_serial_num, 'bank_serial_num')
        if self.bank_serial_num is not None:
            self.validate_max_length(self.bank_serial_num, 'bank_serial_num', 200)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.channel_simple_code is not None:
            result['channel_simple_code'] = self.channel_simple_code
        if self.report_no is not None:
            result['report_no'] = self.report_no
        if self.rela_order_no is not None:
            result['rela_order_no'] = self.rela_order_no
        if self.claim_amount is not None:
            result['claim_amount'] = self.claim_amount
        if self.payment_time is not None:
            result['payment_time'] = self.payment_time
        if self.bank_serial_num is not None:
            result['bank_serial_num'] = self.bank_serial_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('channel_simple_code') is not None:
            self.channel_simple_code = m.get('channel_simple_code')
        if m.get('report_no') is not None:
            self.report_no = m.get('report_no')
        if m.get('rela_order_no') is not None:
            self.rela_order_no = m.get('rela_order_no')
        if m.get('claim_amount') is not None:
            self.claim_amount = m.get('claim_amount')
        if m.get('payment_time') is not None:
            self.payment_time = m.get('payment_time')
        if m.get('bank_serial_num') is not None:
            self.bank_serial_num = m.get('bank_serial_num')
        return self


class NotifyInsuranceReportresultResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        trade_no: str = None,
        report_notify_status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 案件同步唯一码
        # 
        self.trade_no = trade_no
        # 案件通知状态--SUCCESS、FAIL
        # 
        self.report_notify_status = report_notify_status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.trade_no is not None:
            result['trade_no'] = self.trade_no
        if self.report_notify_status is not None:
            result['report_notify_status'] = self.report_notify_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('trade_no') is not None:
            self.trade_no = m.get('trade_no')
        if m.get('report_notify_status') is not None:
            self.report_notify_status = m.get('report_notify_status')
        return self


class PushAuthSigninfoRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        sign_process_id: str = None,
        auth_rel_type_id: str = None,
        sign_theme: str = None,
        initiator_name: str = None,
        initiator_cert_type: str = None,
        initiator_cert_num: str = None,
        cont_tmpl_hash: str = None,
        auth_partys: List[AuthParty] = None,
        auth_chain_files: List[AuthChainFile] = None,
        dyna_field_1: str = None,
        dyna_field_2: str = None,
        dyna_field_3: str = None,
        dyna_field_4: str = None,
        dyna_field_5: str = None,
        dyna_field_6: str = None,
        dyna_field_7: str = None,
        dyna_field_8: str = None,
        dyna_field_9: str = None,
        dyna_field_10: str = None,
        dyna_field_11: str = None,
        dyna_field_12: str = None,
        dyna_field_13: str = None,
        dyna_field_14: str = None,
        dyna_field_15: str = None,
        dyna_field_16: str = None,
        dyna_field_17: str = None,
        dyna_field_18: str = None,
        dyna_field_19: str = None,
        dyna_field_20: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 签署流程id
        self.sign_process_id = sign_process_id
        # 授权关系类型id
        self.auth_rel_type_id = auth_rel_type_id
        # 某某主题
        self.sign_theme = sign_theme
        # 发起方名称
        self.initiator_name = initiator_name
        # 发起方证件类型，可以填写的枚举类型：UNIFIED_SOCIAL_CREDIT_CODE,  BUSINESS_LICENSE_NUMBER。分别表示统一社会信用代码和工商注册号
        self.initiator_cert_type = initiator_cert_type
        # 发起方证件号码
        self.initiator_cert_num = initiator_cert_num
        # 合同模板hash
        self.cont_tmpl_hash = cont_tmpl_hash
        # 签署方信息列表
        self.auth_partys = auth_partys
        # 上链文件信息列表
        self.auth_chain_files = auth_chain_files
        # 动态字段1
        self.dyna_field_1 = dyna_field_1
        # 动态字段2
        self.dyna_field_2 = dyna_field_2
        # 动态字段3
        self.dyna_field_3 = dyna_field_3
        # 动态字段4
        self.dyna_field_4 = dyna_field_4
        # 动态字段5
        self.dyna_field_5 = dyna_field_5
        # 动态字段6
        self.dyna_field_6 = dyna_field_6
        # 动态字段7
        self.dyna_field_7 = dyna_field_7
        # 动态字段8
        self.dyna_field_8 = dyna_field_8
        # 动态字段9
        self.dyna_field_9 = dyna_field_9
        # 动态字段10
        self.dyna_field_10 = dyna_field_10
        # 动态字段11
        self.dyna_field_11 = dyna_field_11
        # 动态字段12
        self.dyna_field_12 = dyna_field_12
        # 动态字段13
        self.dyna_field_13 = dyna_field_13
        # 动态字段14
        self.dyna_field_14 = dyna_field_14
        # 动态字段15
        self.dyna_field_15 = dyna_field_15
        # 动态字段16
        self.dyna_field_16 = dyna_field_16
        # 动态字段17
        self.dyna_field_17 = dyna_field_17
        # 动态字段18
        self.dyna_field_18 = dyna_field_18
        # 动态字段19
        self.dyna_field_19 = dyna_field_19
        # 动态字段20
        self.dyna_field_20 = dyna_field_20

    def validate(self):
        self.validate_required(self.sign_process_id, 'sign_process_id')
        self.validate_required(self.auth_rel_type_id, 'auth_rel_type_id')
        self.validate_required(self.initiator_name, 'initiator_name')
        self.validate_required(self.initiator_cert_type, 'initiator_cert_type')
        self.validate_required(self.initiator_cert_num, 'initiator_cert_num')
        self.validate_required(self.cont_tmpl_hash, 'cont_tmpl_hash')
        self.validate_required(self.auth_partys, 'auth_partys')
        if self.auth_partys:
            for k in self.auth_partys:
                if k:
                    k.validate()
        self.validate_required(self.auth_chain_files, 'auth_chain_files')
        if self.auth_chain_files:
            for k in self.auth_chain_files:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.sign_process_id is not None:
            result['sign_process_id'] = self.sign_process_id
        if self.auth_rel_type_id is not None:
            result['auth_rel_type_id'] = self.auth_rel_type_id
        if self.sign_theme is not None:
            result['sign_theme'] = self.sign_theme
        if self.initiator_name is not None:
            result['initiator_name'] = self.initiator_name
        if self.initiator_cert_type is not None:
            result['initiator_cert_type'] = self.initiator_cert_type
        if self.initiator_cert_num is not None:
            result['initiator_cert_num'] = self.initiator_cert_num
        if self.cont_tmpl_hash is not None:
            result['cont_tmpl_hash'] = self.cont_tmpl_hash
        result['auth_partys'] = []
        if self.auth_partys is not None:
            for k in self.auth_partys:
                result['auth_partys'].append(k.to_map() if k else None)
        result['auth_chain_files'] = []
        if self.auth_chain_files is not None:
            for k in self.auth_chain_files:
                result['auth_chain_files'].append(k.to_map() if k else None)
        if self.dyna_field_1 is not None:
            result['dyna_field1'] = self.dyna_field_1
        if self.dyna_field_2 is not None:
            result['dyna_field2'] = self.dyna_field_2
        if self.dyna_field_3 is not None:
            result['dyna_field3'] = self.dyna_field_3
        if self.dyna_field_4 is not None:
            result['dyna_field4'] = self.dyna_field_4
        if self.dyna_field_5 is not None:
            result['dyna_field5'] = self.dyna_field_5
        if self.dyna_field_6 is not None:
            result['dyna_field6'] = self.dyna_field_6
        if self.dyna_field_7 is not None:
            result['dyna_field7'] = self.dyna_field_7
        if self.dyna_field_8 is not None:
            result['dyna_field8'] = self.dyna_field_8
        if self.dyna_field_9 is not None:
            result['dyna_field9'] = self.dyna_field_9
        if self.dyna_field_10 is not None:
            result['dyna_field10'] = self.dyna_field_10
        if self.dyna_field_11 is not None:
            result['dyna_field11'] = self.dyna_field_11
        if self.dyna_field_12 is not None:
            result['dyna_field12'] = self.dyna_field_12
        if self.dyna_field_13 is not None:
            result['dyna_field13'] = self.dyna_field_13
        if self.dyna_field_14 is not None:
            result['dyna_field14'] = self.dyna_field_14
        if self.dyna_field_15 is not None:
            result['dyna_field15'] = self.dyna_field_15
        if self.dyna_field_16 is not None:
            result['dyna_field16'] = self.dyna_field_16
        if self.dyna_field_17 is not None:
            result['dyna_field17'] = self.dyna_field_17
        if self.dyna_field_18 is not None:
            result['dyna_field18'] = self.dyna_field_18
        if self.dyna_field_19 is not None:
            result['dyna_field19'] = self.dyna_field_19
        if self.dyna_field_20 is not None:
            result['dyna_field20'] = self.dyna_field_20
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('sign_process_id') is not None:
            self.sign_process_id = m.get('sign_process_id')
        if m.get('auth_rel_type_id') is not None:
            self.auth_rel_type_id = m.get('auth_rel_type_id')
        if m.get('sign_theme') is not None:
            self.sign_theme = m.get('sign_theme')
        if m.get('initiator_name') is not None:
            self.initiator_name = m.get('initiator_name')
        if m.get('initiator_cert_type') is not None:
            self.initiator_cert_type = m.get('initiator_cert_type')
        if m.get('initiator_cert_num') is not None:
            self.initiator_cert_num = m.get('initiator_cert_num')
        if m.get('cont_tmpl_hash') is not None:
            self.cont_tmpl_hash = m.get('cont_tmpl_hash')
        self.auth_partys = []
        if m.get('auth_partys') is not None:
            for k in m.get('auth_partys'):
                temp_model = AuthParty()
                self.auth_partys.append(temp_model.from_map(k))
        self.auth_chain_files = []
        if m.get('auth_chain_files') is not None:
            for k in m.get('auth_chain_files'):
                temp_model = AuthChainFile()
                self.auth_chain_files.append(temp_model.from_map(k))
        if m.get('dyna_field1') is not None:
            self.dyna_field_1 = m.get('dyna_field1')
        if m.get('dyna_field2') is not None:
            self.dyna_field_2 = m.get('dyna_field2')
        if m.get('dyna_field3') is not None:
            self.dyna_field_3 = m.get('dyna_field3')
        if m.get('dyna_field4') is not None:
            self.dyna_field_4 = m.get('dyna_field4')
        if m.get('dyna_field5') is not None:
            self.dyna_field_5 = m.get('dyna_field5')
        if m.get('dyna_field6') is not None:
            self.dyna_field_6 = m.get('dyna_field6')
        if m.get('dyna_field7') is not None:
            self.dyna_field_7 = m.get('dyna_field7')
        if m.get('dyna_field8') is not None:
            self.dyna_field_8 = m.get('dyna_field8')
        if m.get('dyna_field9') is not None:
            self.dyna_field_9 = m.get('dyna_field9')
        if m.get('dyna_field10') is not None:
            self.dyna_field_10 = m.get('dyna_field10')
        if m.get('dyna_field11') is not None:
            self.dyna_field_11 = m.get('dyna_field11')
        if m.get('dyna_field12') is not None:
            self.dyna_field_12 = m.get('dyna_field12')
        if m.get('dyna_field13') is not None:
            self.dyna_field_13 = m.get('dyna_field13')
        if m.get('dyna_field14') is not None:
            self.dyna_field_14 = m.get('dyna_field14')
        if m.get('dyna_field15') is not None:
            self.dyna_field_15 = m.get('dyna_field15')
        if m.get('dyna_field16') is not None:
            self.dyna_field_16 = m.get('dyna_field16')
        if m.get('dyna_field17') is not None:
            self.dyna_field_17 = m.get('dyna_field17')
        if m.get('dyna_field18') is not None:
            self.dyna_field_18 = m.get('dyna_field18')
        if m.get('dyna_field19') is not None:
            self.dyna_field_19 = m.get('dyna_field19')
        if m.get('dyna_field20') is not None:
            self.dyna_field_20 = m.get('dyna_field20')
        return self


class PushAuthSigninfoResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 推送成功
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class QueryPfPaymentRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        buss_refr_no: str = None,
        financing_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 业务参考号
        self.buss_refr_no = buss_refr_no
        # 支用id
        self.financing_id = financing_id

    def validate(self):
        self.validate_required(self.buss_refr_no, 'buss_refr_no')
        if self.buss_refr_no is not None:
            self.validate_max_length(self.buss_refr_no, 'buss_refr_no', 100)
        self.validate_required(self.financing_id, 'financing_id')
        if self.financing_id is not None:
            self.validate_max_length(self.financing_id, 'financing_id', 32)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.buss_refr_no is not None:
            result['buss_refr_no'] = self.buss_refr_no
        if self.financing_id is not None:
            result['financing_id'] = self.financing_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('buss_refr_no') is not None:
            self.buss_refr_no = m.get('buss_refr_no')
        if m.get('financing_id') is not None:
            self.financing_id = m.get('financing_id')
        return self


class QueryPfPaymentResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        accountin_status: str = None,
        trade_time: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 入账状态: 10-受理 20-在途 00-成功 99-失败
        self.accountin_status = accountin_status
        # 交易时间
        self.trade_time = trade_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.accountin_status is not None:
            result['accountin_status'] = self.accountin_status
        if self.trade_time is not None:
            result['trade_time'] = self.trade_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('accountin_status') is not None:
            self.accountin_status = m.get('accountin_status')
        if m.get('trade_time') is not None:
            self.trade_time = m.get('trade_time')
        return self


class QueryPfIouRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        project_id: str = None,
        financing_subject_did: str = None,
        financing_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 项目id
        self.project_id = project_id
        # 融资主体Did
        self.financing_subject_did = financing_subject_did
        # 支用Id
        self.financing_id = financing_id

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        self.validate_required(self.financing_subject_did, 'financing_subject_did')
        self.validate_required(self.financing_id, 'financing_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.financing_subject_did is not None:
            result['financing_subject_did'] = self.financing_subject_did
        if self.financing_id is not None:
            result['financing_id'] = self.financing_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('financing_subject_did') is not None:
            self.financing_subject_did = m.get('financing_subject_did')
        if m.get('financing_id') is not None:
            self.financing_id = m.get('financing_id')
        return self


class QueryPfIouResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        annual_interest_rate: str = None,
        credit_id: str = None,
        interest_bearing_end: str = None,
        interest_bearing_start: str = None,
        issued_amount: str = None,
        repay_bank_name: str = None,
        repay_acct_name: str = None,
        repay_account: str = None,
        repay_amt: str = None,
        repay_interest: str = None,
        repay_total_amt: str = None,
        credit_status: str = None,
        is_overdue: str = None,
        project_id: str = None,
        financing_id: str = None,
        financing_subject_did: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 执行年利率
        self.annual_interest_rate = annual_interest_rate
        # 借据Id
        self.credit_id = credit_id
        # 借据到期日
        self.interest_bearing_end = interest_bearing_end
        # 借据起息日
        self.interest_bearing_start = interest_bearing_start
        # 应还本金，即放款金额
        self.issued_amount = issued_amount
        # 还款银行名称
        self.repay_bank_name = repay_bank_name
        # 还款账号名称
        self.repay_acct_name = repay_acct_name
        # 还款账号
        self.repay_account = repay_account
        # 实际已还本金
        self.repay_amt = repay_amt
        # 实际已还利息
        self.repay_interest = repay_interest
        # 实际已还总额
        self.repay_total_amt = repay_total_amt
        # 借据状态
        self.credit_status = credit_status
        # 是否逾期,0是,1否
        self.is_overdue = is_overdue
        # 项目id
        self.project_id = project_id
        # 支用id
        self.financing_id = financing_id
        # 融资主体DID
        self.financing_subject_did = financing_subject_did

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.annual_interest_rate is not None:
            result['annual_interest_rate'] = self.annual_interest_rate
        if self.credit_id is not None:
            result['credit_id'] = self.credit_id
        if self.interest_bearing_end is not None:
            result['interest_bearing_end'] = self.interest_bearing_end
        if self.interest_bearing_start is not None:
            result['interest_bearing_start'] = self.interest_bearing_start
        if self.issued_amount is not None:
            result['issued_amount'] = self.issued_amount
        if self.repay_bank_name is not None:
            result['repay_bank_name'] = self.repay_bank_name
        if self.repay_acct_name is not None:
            result['repay_acct_name'] = self.repay_acct_name
        if self.repay_account is not None:
            result['repay_account'] = self.repay_account
        if self.repay_amt is not None:
            result['repay_amt'] = self.repay_amt
        if self.repay_interest is not None:
            result['repay_interest'] = self.repay_interest
        if self.repay_total_amt is not None:
            result['repay_total_amt'] = self.repay_total_amt
        if self.credit_status is not None:
            result['credit_status'] = self.credit_status
        if self.is_overdue is not None:
            result['is_overdue'] = self.is_overdue
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.financing_id is not None:
            result['financing_id'] = self.financing_id
        if self.financing_subject_did is not None:
            result['financing_subject_did'] = self.financing_subject_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('annual_interest_rate') is not None:
            self.annual_interest_rate = m.get('annual_interest_rate')
        if m.get('credit_id') is not None:
            self.credit_id = m.get('credit_id')
        if m.get('interest_bearing_end') is not None:
            self.interest_bearing_end = m.get('interest_bearing_end')
        if m.get('interest_bearing_start') is not None:
            self.interest_bearing_start = m.get('interest_bearing_start')
        if m.get('issued_amount') is not None:
            self.issued_amount = m.get('issued_amount')
        if m.get('repay_bank_name') is not None:
            self.repay_bank_name = m.get('repay_bank_name')
        if m.get('repay_acct_name') is not None:
            self.repay_acct_name = m.get('repay_acct_name')
        if m.get('repay_account') is not None:
            self.repay_account = m.get('repay_account')
        if m.get('repay_amt') is not None:
            self.repay_amt = m.get('repay_amt')
        if m.get('repay_interest') is not None:
            self.repay_interest = m.get('repay_interest')
        if m.get('repay_total_amt') is not None:
            self.repay_total_amt = m.get('repay_total_amt')
        if m.get('credit_status') is not None:
            self.credit_status = m.get('credit_status')
        if m.get('is_overdue') is not None:
            self.is_overdue = m.get('is_overdue')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('financing_id') is not None:
            self.financing_id = m.get('financing_id')
        if m.get('financing_subject_did') is not None:
            self.financing_subject_did = m.get('financing_subject_did')
        return self


class QueryPfQuotaRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        project_id: str = None,
        cert_no: str = None,
        cert_type: str = None,
        customer_no: str = None,
        financing_subject_did: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 项目标识
        self.project_id = project_id
        # 证件号
        self.cert_no = cert_no
        # 证件类型;050 统一社会信用证代码
        self.cert_type = cert_type
        # 银行端客户号
        self.customer_no = customer_no
        # 融资主体did
        self.financing_subject_did = financing_subject_did

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        if self.project_id is not None:
            self.validate_max_length(self.project_id, 'project_id', 64)
        self.validate_required(self.cert_no, 'cert_no')
        if self.cert_no is not None:
            self.validate_max_length(self.cert_no, 'cert_no', 20)
        self.validate_required(self.cert_type, 'cert_type')
        if self.cert_type is not None:
            self.validate_max_length(self.cert_type, 'cert_type', 3)
        self.validate_required(self.customer_no, 'customer_no')
        if self.customer_no is not None:
            self.validate_max_length(self.customer_no, 'customer_no', 20)
        self.validate_required(self.financing_subject_did, 'financing_subject_did')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.cert_type is not None:
            result['cert_type'] = self.cert_type
        if self.customer_no is not None:
            result['customer_no'] = self.customer_no
        if self.financing_subject_did is not None:
            result['financing_subject_did'] = self.financing_subject_did
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('cert_type') is not None:
            self.cert_type = m.get('cert_type')
        if m.get('customer_no') is not None:
            self.customer_no = m.get('customer_no')
        if m.get('financing_subject_did') is not None:
            self.financing_subject_did = m.get('financing_subject_did')
        return self


class QueryPfQuotaResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        quota_info: List[PfCreditQuotaInfo] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 授信额度信息
        self.quota_info = quota_info

    def validate(self):
        if self.quota_info:
            for k in self.quota_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['quota_info'] = []
        if self.quota_info is not None:
            for k in self.quota_info:
                result['quota_info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.quota_info = []
        if m.get('quota_info') is not None:
            for k in m.get('quota_info'):
                temp_model = PfCreditQuotaInfo()
                self.quota_info.append(temp_model.from_map(k))
        return self


class ApplyPfWaybillfinancingRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        request_no: str = None,
        project_id: str = None,
        carrier_did: str = None,
        financing_amount: str = None,
        financing_currency: str = None,
        financing_subject_did: str = None,
        loan_term: str = None,
        payee_bank_number: str = None,
        payee_bcb: str = None,
        payee_bcb_card_no: str = None,
        payee_id_number: str = None,
        payee_id_type: str = None,
        payee_name: str = None,
        purpose: str = None,
        signature: str = None,
        transfer_postscript: str = None,
        voucher_category: str = None,
        voucher_ids: str = None,
        voucher_invoice_codes: str = None,
        confirmation_hash: str = None,
        confirmation_oss_key: str = None,
        signature_pub_key: str = None,
        online_bank_operator_account: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 请求号，以时间串yyyyMMdd 开头，要求该请求号在请求方系统内唯一；同时该字段也是幂等字段
        self.request_no = request_no
        # 项目标识；与对接同学确认对应的标识值
        self.project_id = project_id
        # 承运商did
        self.carrier_did = carrier_did
        # 融资支用金额；总长度最长20位，保留2位小数，四舍五入
        self.financing_amount = financing_amount
        # 支用币种，支持 CNY,USD
        self.financing_currency = financing_currency
        # 融资授信主体公司分布式数字身份
        self.financing_subject_did = financing_subject_did
        # 贷款期限，值为2~6，单位为月
        self.loan_term = loan_term
        # 收款方开户行总行联行号
        self.payee_bank_number = payee_bank_number
        # 收款方开户行名称
        self.payee_bcb = payee_bcb
        # 收款方开户行银行卡号
        self.payee_bcb_card_no = payee_bcb_card_no
        # 收款方证件号
        # 
        # 
        self.payee_id_number = payee_id_number
        # 收款方证件类型
        self.payee_id_type = payee_id_type
        # 收款方名称
        self.payee_name = payee_name
        # 0政府投标 1经营周转 2支付货款 3采购机票，一般默认填 2
        self.purpose = purpose
        # 银行端的Ukey签名；使用方调用接口前使用银行Ukey做签名，并将签名后的结果填入该字段；一期，该字段可不传，使用方通过登录网上银行使用网银进行确认
        self.signature = signature
        # 转账附言
        # 1: 工资、奖金收入
        # 2：稿费、演出费等劳务收入
        # 3：债券、期货、信托等投资的本金和收益
        # 4：个人债券或产权转让收益
        # 该字段建议填写 2
        self.transfer_postscript = transfer_postscript
        # 凭证类型，支持 WAYBILL,PAYABLE
        self.voucher_category = voucher_category
        # 支用凭证ids，支持多个，逗号隔开；
        self.voucher_ids = voucher_ids
        # 8位发票号，支持多个，逗号分隔
        self.voucher_invoice_codes = voucher_invoice_codes
        # 提款确认书hash
        self.confirmation_hash = confirmation_hash
        # 提款确认书 osskey
        self.confirmation_oss_key = confirmation_oss_key
        # 签名公钥
        self.signature_pub_key = signature_pub_key
        # 网银操作员账号
        # 
        # 
        self.online_bank_operator_account = online_bank_operator_account

    def validate(self):
        self.validate_required(self.request_no, 'request_no')
        if self.request_no is not None:
            self.validate_max_length(self.request_no, 'request_no', 23)
        self.validate_required(self.project_id, 'project_id')
        if self.project_id is not None:
            self.validate_max_length(self.project_id, 'project_id', 64)
        self.validate_required(self.carrier_did, 'carrier_did')
        if self.carrier_did is not None:
            self.validate_max_length(self.carrier_did, 'carrier_did', 80)
        self.validate_required(self.financing_amount, 'financing_amount')
        self.validate_required(self.financing_currency, 'financing_currency')
        self.validate_required(self.financing_subject_did, 'financing_subject_did')
        if self.financing_subject_did is not None:
            self.validate_max_length(self.financing_subject_did, 'financing_subject_did', 80)
        self.validate_required(self.loan_term, 'loan_term')
        if self.loan_term is not None:
            self.validate_max_length(self.loan_term, 'loan_term', 6)
        self.validate_required(self.payee_bank_number, 'payee_bank_number')
        if self.payee_bank_number is not None:
            self.validate_max_length(self.payee_bank_number, 'payee_bank_number', 32)
        self.validate_required(self.payee_bcb, 'payee_bcb')
        if self.payee_bcb is not None:
            self.validate_max_length(self.payee_bcb, 'payee_bcb', 200)
        self.validate_required(self.payee_bcb_card_no, 'payee_bcb_card_no')
        self.validate_required(self.payee_id_number, 'payee_id_number')
        if self.payee_id_number is not None:
            self.validate_max_length(self.payee_id_number, 'payee_id_number', 40)
        self.validate_required(self.payee_id_type, 'payee_id_type')
        if self.payee_id_type is not None:
            self.validate_max_length(self.payee_id_type, 'payee_id_type', 5)
        self.validate_required(self.payee_name, 'payee_name')
        if self.payee_name is not None:
            self.validate_max_length(self.payee_name, 'payee_name', 200)
        self.validate_required(self.purpose, 'purpose')
        if self.signature is not None:
            self.validate_max_length(self.signature, 'signature', 800)
        self.validate_required(self.transfer_postscript, 'transfer_postscript')
        if self.transfer_postscript is not None:
            self.validate_max_length(self.transfer_postscript, 'transfer_postscript', 3)
        self.validate_required(self.voucher_category, 'voucher_category')
        self.validate_required(self.voucher_ids, 'voucher_ids')
        if self.voucher_ids is not None:
            self.validate_max_length(self.voucher_ids, 'voucher_ids', 2000)
        if self.voucher_invoice_codes is not None:
            self.validate_max_length(self.voucher_invoice_codes, 'voucher_invoice_codes', 800)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.request_no is not None:
            result['request_no'] = self.request_no
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.carrier_did is not None:
            result['carrier_did'] = self.carrier_did
        if self.financing_amount is not None:
            result['financing_amount'] = self.financing_amount
        if self.financing_currency is not None:
            result['financing_currency'] = self.financing_currency
        if self.financing_subject_did is not None:
            result['financing_subject_did'] = self.financing_subject_did
        if self.loan_term is not None:
            result['loan_term'] = self.loan_term
        if self.payee_bank_number is not None:
            result['payee_bank_number'] = self.payee_bank_number
        if self.payee_bcb is not None:
            result['payee_bcb'] = self.payee_bcb
        if self.payee_bcb_card_no is not None:
            result['payee_bcb_card_no'] = self.payee_bcb_card_no
        if self.payee_id_number is not None:
            result['payee_id_number'] = self.payee_id_number
        if self.payee_id_type is not None:
            result['payee_id_type'] = self.payee_id_type
        if self.payee_name is not None:
            result['payee_name'] = self.payee_name
        if self.purpose is not None:
            result['purpose'] = self.purpose
        if self.signature is not None:
            result['signature'] = self.signature
        if self.transfer_postscript is not None:
            result['transfer_postscript'] = self.transfer_postscript
        if self.voucher_category is not None:
            result['voucher_category'] = self.voucher_category
        if self.voucher_ids is not None:
            result['voucher_ids'] = self.voucher_ids
        if self.voucher_invoice_codes is not None:
            result['voucher_invoice_codes'] = self.voucher_invoice_codes
        if self.confirmation_hash is not None:
            result['confirmation_hash'] = self.confirmation_hash
        if self.confirmation_oss_key is not None:
            result['confirmation_oss_key'] = self.confirmation_oss_key
        if self.signature_pub_key is not None:
            result['signature_pub_key'] = self.signature_pub_key
        if self.online_bank_operator_account is not None:
            result['online_bank_operator_account'] = self.online_bank_operator_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('request_no') is not None:
            self.request_no = m.get('request_no')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('carrier_did') is not None:
            self.carrier_did = m.get('carrier_did')
        if m.get('financing_amount') is not None:
            self.financing_amount = m.get('financing_amount')
        if m.get('financing_currency') is not None:
            self.financing_currency = m.get('financing_currency')
        if m.get('financing_subject_did') is not None:
            self.financing_subject_did = m.get('financing_subject_did')
        if m.get('loan_term') is not None:
            self.loan_term = m.get('loan_term')
        if m.get('payee_bank_number') is not None:
            self.payee_bank_number = m.get('payee_bank_number')
        if m.get('payee_bcb') is not None:
            self.payee_bcb = m.get('payee_bcb')
        if m.get('payee_bcb_card_no') is not None:
            self.payee_bcb_card_no = m.get('payee_bcb_card_no')
        if m.get('payee_id_number') is not None:
            self.payee_id_number = m.get('payee_id_number')
        if m.get('payee_id_type') is not None:
            self.payee_id_type = m.get('payee_id_type')
        if m.get('payee_name') is not None:
            self.payee_name = m.get('payee_name')
        if m.get('purpose') is not None:
            self.purpose = m.get('purpose')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        if m.get('transfer_postscript') is not None:
            self.transfer_postscript = m.get('transfer_postscript')
        if m.get('voucher_category') is not None:
            self.voucher_category = m.get('voucher_category')
        if m.get('voucher_ids') is not None:
            self.voucher_ids = m.get('voucher_ids')
        if m.get('voucher_invoice_codes') is not None:
            self.voucher_invoice_codes = m.get('voucher_invoice_codes')
        if m.get('confirmation_hash') is not None:
            self.confirmation_hash = m.get('confirmation_hash')
        if m.get('confirmation_oss_key') is not None:
            self.confirmation_oss_key = m.get('confirmation_oss_key')
        if m.get('signature_pub_key') is not None:
            self.signature_pub_key = m.get('signature_pub_key')
        if m.get('online_bank_operator_account') is not None:
            self.online_bank_operator_account = m.get('online_bank_operator_account')
        return self


class ApplyPfWaybillfinancingResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        financing_id: str = None,
        status: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 融资支用Id
        self.financing_id = financing_id
        # 申请状态，
        # 融资申请失败 IN_VALID
        # 融资申请失败 F_APPLY_FAIL
        # 融资申请成功 F_APPLY_SUC
        # 融资申请成功 COMMIT
        # 融资核验中 VERIFYING
        # 融资核验失败 VERIFY_FAILURE
        # 融资订单生成成功 P_WITHDRAW
        # 融资成功 A_WITHDRAW
        # 融资失败 EXPIRED
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.financing_id is not None:
            result['financing_id'] = self.financing_id
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('financing_id') is not None:
            self.financing_id = m.get('financing_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class PushPfPledgeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        project_id: str = None,
        bill_id: str = None,
        financing_subject_did: str = None,
        request_no: str = None,
        invoice_nos: List[str] = None,
        pallet_bill_amount: str = None,
        pallet_invoice_nos: List[str] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 项目标识，可联系对接同学提供
        self.project_id = project_id
        # 账单标识
        self.bill_id = bill_id
        # 融资主体did
        self.financing_subject_did = financing_subject_did
        # 请求号；以yyyyMMdd 时间串开头的32位字符串；该字符串需要保持请求系统内唯一，系统会以该请求号作为幂等处理
        self.request_no = request_no
        # 质押发票号码列表
        self.invoice_nos = invoice_nos
        # 托盘账单金额
        self.pallet_bill_amount = pallet_bill_amount
        # 托盘账单关联发票号列表
        self.pallet_invoice_nos = pallet_invoice_nos

    def validate(self):
        self.validate_required(self.project_id, 'project_id')
        if self.project_id is not None:
            self.validate_max_length(self.project_id, 'project_id', 64)
        self.validate_required(self.bill_id, 'bill_id')
        if self.bill_id is not None:
            self.validate_max_length(self.bill_id, 'bill_id', 128)
        self.validate_required(self.financing_subject_did, 'financing_subject_did')
        if self.financing_subject_did is not None:
            self.validate_max_length(self.financing_subject_did, 'financing_subject_did', 128)
        self.validate_required(self.request_no, 'request_no')
        if self.request_no is not None:
            self.validate_max_length(self.request_no, 'request_no', 32)
        if self.pallet_bill_amount is not None:
            self.validate_max_length(self.pallet_bill_amount, 'pallet_bill_amount', 64)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.bill_id is not None:
            result['bill_id'] = self.bill_id
        if self.financing_subject_did is not None:
            result['financing_subject_did'] = self.financing_subject_did
        if self.request_no is not None:
            result['request_no'] = self.request_no
        if self.invoice_nos is not None:
            result['invoice_nos'] = self.invoice_nos
        if self.pallet_bill_amount is not None:
            result['pallet_bill_amount'] = self.pallet_bill_amount
        if self.pallet_invoice_nos is not None:
            result['pallet_invoice_nos'] = self.pallet_invoice_nos
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('bill_id') is not None:
            self.bill_id = m.get('bill_id')
        if m.get('financing_subject_did') is not None:
            self.financing_subject_did = m.get('financing_subject_did')
        if m.get('request_no') is not None:
            self.request_no = m.get('request_no')
        if m.get('invoice_nos') is not None:
            self.invoice_nos = m.get('invoice_nos')
        if m.get('pallet_bill_amount') is not None:
            self.pallet_bill_amount = m.get('pallet_bill_amount')
        if m.get('pallet_invoice_nos') is not None:
            self.pallet_invoice_nos = m.get('pallet_invoice_nos')
        return self


class PushPfPledgeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        pledge_id: str = None,
        status: str = None,
        desc: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 质押标识，用于账单质押推送状态查询
        self.pledge_id = pledge_id
        # 已提交  COMMIT
        # 推送中 PUSHING
        # 推送成功 PUSH_SUC
        # 推送失败 PUSH_FAIL
        self.status = status
        # 描述
        self.desc = desc

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.pledge_id is not None:
            result['pledge_id'] = self.pledge_id
        if self.status is not None:
            result['status'] = self.status
        if self.desc is not None:
            result['desc'] = self.desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('pledge_id') is not None:
            self.pledge_id = m.get('pledge_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        return self


class QueryPfPledgeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        pledge_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 质押id
        self.pledge_id = pledge_id

    def validate(self):
        self.validate_required(self.pledge_id, 'pledge_id')
        if self.pledge_id is not None:
            self.validate_max_length(self.pledge_id, 'pledge_id', 32)

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.pledge_id is not None:
            result['pledge_id'] = self.pledge_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('pledge_id') is not None:
            self.pledge_id = m.get('pledge_id')
        return self


class QueryPfPledgeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        bill_id: str = None,
        financing_subject_did: str = None,
        status: str = None,
        desc: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 账单id
        self.bill_id = bill_id
        # 融资主体did
        self.financing_subject_did = financing_subject_did
        # 已提交  COMMIT
        # 推送中 PUSHING
        # 推送成功 PUSH_SUC
        # 推送失败 PUSH_FAIL
        self.status = status
        # 状态描述
        self.desc = desc

    def validate(self):
        pass

    def