"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const destination_1 = require("./destination");
const lambda_generated_1 = require("./lambda.generated");
/**
 * Configure options for asynchronous invocation on a version or an alias
 *
 * By default, Lambda retries an asynchronous invocation twice if the function
 * returns an error. It retains events in a queue for up to six hours. When an
 * event fails all processing attempts or stays in the asynchronous invocation
 * queue for too long, Lambda discards it.
 */
class EventInvokeConfig extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.maxEventAge && (props.maxEventAge.toSeconds() < 60 || props.maxEventAge.toSeconds() > 21600)) {
            throw new Error('`maximumEventAge` must represent a `Duration` that is between 60 and 21600 seconds.');
        }
        if (props.retryAttempts && (props.retryAttempts < 0 || props.retryAttempts > 2)) {
            throw new Error('`retryAttempts` must be between 0 and 2.');
        }
        new lambda_generated_1.CfnEventInvokeConfig(this, 'Resource', {
            destinationConfig: props.onFailure || props.onSuccess
                ? {
                    ...props.onFailure ? { onFailure: props.onFailure.bind(this, props.function, { type: destination_1.DestinationType.FAILURE }) } : {},
                    ...props.onSuccess ? { onSuccess: props.onSuccess.bind(this, props.function, { type: destination_1.DestinationType.SUCCESS }) } : {},
                }
                : undefined,
            functionName: props.function.functionName,
            maximumEventAgeInSeconds: props.maxEventAge && props.maxEventAge.toSeconds(),
            maximumRetryAttempts: props.retryAttempts !== undefined ? props.retryAttempts : undefined,
            qualifier: props.qualifier || '$LATEST',
        });
    }
}
exports.EventInvokeConfig = EventInvokeConfig;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXZlbnQtaW52b2tlLWNvbmZpZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImV2ZW50LWludm9rZS1jb25maWcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSx3Q0FBOEQ7QUFDOUQsK0NBQThEO0FBRTlELHlEQUEwRDtBQTJEMUQ7Ozs7Ozs7R0FPRztBQUNILE1BQWEsaUJBQWtCLFNBQVEsZUFBUTtJQUM3QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTZCO1FBQ3JFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxLQUFLLENBQUMsV0FBVyxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxTQUFTLEVBQUUsR0FBRyxFQUFFLElBQUksS0FBSyxDQUFDLFdBQVcsQ0FBQyxTQUFTLEVBQUUsR0FBRyxLQUFLLENBQUMsRUFBRTtZQUN0RyxNQUFNLElBQUksS0FBSyxDQUFDLHFGQUFxRixDQUFDLENBQUM7U0FDeEc7UUFFRCxJQUFJLEtBQUssQ0FBQyxhQUFhLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxHQUFHLENBQUMsSUFBSSxLQUFLLENBQUMsYUFBYSxHQUFHLENBQUMsQ0FBQyxFQUFFO1lBQy9FLE1BQU0sSUFBSSxLQUFLLENBQUMsMENBQTBDLENBQUMsQ0FBQztTQUM3RDtRQUVELElBQUksdUNBQW9CLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUN6QyxpQkFBaUIsRUFBRSxLQUFLLENBQUMsU0FBUyxJQUFJLEtBQUssQ0FBQyxTQUFTO2dCQUNuRCxDQUFDLENBQUM7b0JBQ0EsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxFQUFFLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLFFBQVEsRUFBRSxFQUFFLElBQUksRUFBRSw2QkFBZSxDQUFDLE9BQU8sRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRTtvQkFDdEgsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxFQUFFLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLFFBQVEsRUFBRSxFQUFFLElBQUksRUFBRSw2QkFBZSxDQUFDLE9BQU8sRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRTtpQkFDdkg7Z0JBQ0QsQ0FBQyxDQUFDLFNBQVM7WUFDYixZQUFZLEVBQUUsS0FBSyxDQUFDLFFBQVEsQ0FBQyxZQUFZO1lBQ3pDLHdCQUF3QixFQUFFLEtBQUssQ0FBQyxXQUFXLElBQUksS0FBSyxDQUFDLFdBQVcsQ0FBQyxTQUFTLEVBQUU7WUFDNUUsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLGFBQWEsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLFNBQVM7WUFDekYsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTLElBQUksU0FBUztTQUN4QyxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUF6QkQsOENBeUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0LCBEdXJhdGlvbiwgUmVzb3VyY2UgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IERlc3RpbmF0aW9uVHlwZSwgSURlc3RpbmF0aW9uIH0gZnJvbSAnLi9kZXN0aW5hdGlvbic7XG5pbXBvcnQgeyBJRnVuY3Rpb24gfSBmcm9tICcuL2Z1bmN0aW9uLWJhc2UnO1xuaW1wb3J0IHsgQ2ZuRXZlbnRJbnZva2VDb25maWcgfSBmcm9tICcuL2xhbWJkYS5nZW5lcmF0ZWQnO1xuXG4vKipcbiAqIE9wdGlvbnMgdG8gYWRkIGFuIEV2ZW50SW52b2tlQ29uZmlnIHRvIGEgZnVuY3Rpb24uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRXZlbnRJbnZva2VDb25maWdPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBkZXN0aW5hdGlvbiBmb3IgZmFpbGVkIGludm9jYXRpb25zLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIGRlc3RpbmF0aW9uXG4gICAqL1xuICByZWFkb25seSBvbkZhaWx1cmU/OiBJRGVzdGluYXRpb247XG5cbiAgLyoqXG4gICAqIFRoZSBkZXN0aW5hdGlvbiBmb3Igc3VjY2Vzc2Z1bCBpbnZvY2F0aW9ucy5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBkZXN0aW5hdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgb25TdWNjZXNzPzogSURlc3RpbmF0aW9uO1xuXG4gIC8qKlxuICAgKiBUaGUgbWF4aW11bSBhZ2Ugb2YgYSByZXF1ZXN0IHRoYXQgTGFtYmRhIHNlbmRzIHRvIGEgZnVuY3Rpb24gZm9yXG4gICAqIHByb2Nlc3NpbmcuXG4gICAqXG4gICAqIE1pbmltdW06IDYwIHNlY29uZHNcbiAgICogTWF4aW11bTogNiBob3Vyc1xuICAgKlxuICAgKiBAZGVmYXVsdCBEdXJhdGlvbi5ob3Vycyg2KVxuICAgKi9cbiAgcmVhZG9ubHkgbWF4RXZlbnRBZ2U/OiBEdXJhdGlvbjtcblxuICAvKipcbiAgICogVGhlIG1heGltdW0gbnVtYmVyIG9mIHRpbWVzIHRvIHJldHJ5IHdoZW4gdGhlIGZ1bmN0aW9uIHJldHVybnMgYW4gZXJyb3IuXG4gICAqXG4gICAqIE1pbmltdW06IDBcbiAgICogTWF4aW11bTogMlxuICAgKlxuICAgKiBAZGVmYXVsdCAyXG4gICAqL1xuICByZWFkb25seSByZXRyeUF0dGVtcHRzPzogbnVtYmVyO1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGFuIEV2ZW50SW52b2tlQ29uZmlnXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRXZlbnRJbnZva2VDb25maWdQcm9wcyBleHRlbmRzIEV2ZW50SW52b2tlQ29uZmlnT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgTGFtYmRhIGZ1bmN0aW9uXG4gICAqL1xuICByZWFkb25seSBmdW5jdGlvbjogSUZ1bmN0aW9uO1xuXG4gIC8qKlxuICAgKiBUaGUgcXVhbGlmaWVyXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbGF0ZXN0IHZlcnNpb25cbiAgICovXG4gIHJlYWRvbmx5IHF1YWxpZmllcj86IHN0cmluZztcbn1cblxuLyoqXG4gKiBDb25maWd1cmUgb3B0aW9ucyBmb3IgYXN5bmNocm9ub3VzIGludm9jYXRpb24gb24gYSB2ZXJzaW9uIG9yIGFuIGFsaWFzXG4gKlxuICogQnkgZGVmYXVsdCwgTGFtYmRhIHJldHJpZXMgYW4gYXN5bmNocm9ub3VzIGludm9jYXRpb24gdHdpY2UgaWYgdGhlIGZ1bmN0aW9uXG4gKiByZXR1cm5zIGFuIGVycm9yLiBJdCByZXRhaW5zIGV2ZW50cyBpbiBhIHF1ZXVlIGZvciB1cCB0byBzaXggaG91cnMuIFdoZW4gYW5cbiAqIGV2ZW50IGZhaWxzIGFsbCBwcm9jZXNzaW5nIGF0dGVtcHRzIG9yIHN0YXlzIGluIHRoZSBhc3luY2hyb25vdXMgaW52b2NhdGlvblxuICogcXVldWUgZm9yIHRvbyBsb25nLCBMYW1iZGEgZGlzY2FyZHMgaXQuXG4gKi9cbmV4cG9ydCBjbGFzcyBFdmVudEludm9rZUNvbmZpZyBleHRlbmRzIFJlc291cmNlIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEV2ZW50SW52b2tlQ29uZmlnUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgaWYgKHByb3BzLm1heEV2ZW50QWdlICYmIChwcm9wcy5tYXhFdmVudEFnZS50b1NlY29uZHMoKSA8IDYwIHx8IHByb3BzLm1heEV2ZW50QWdlLnRvU2Vjb25kcygpID4gMjE2MDApKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ2BtYXhpbXVtRXZlbnRBZ2VgIG11c3QgcmVwcmVzZW50IGEgYER1cmF0aW9uYCB0aGF0IGlzIGJldHdlZW4gNjAgYW5kIDIxNjAwIHNlY29uZHMuJyk7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLnJldHJ5QXR0ZW1wdHMgJiYgKHByb3BzLnJldHJ5QXR0ZW1wdHMgPCAwIHx8IHByb3BzLnJldHJ5QXR0ZW1wdHMgPiAyKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdgcmV0cnlBdHRlbXB0c2AgbXVzdCBiZSBiZXR3ZWVuIDAgYW5kIDIuJyk7XG4gICAgfVxuXG4gICAgbmV3IENmbkV2ZW50SW52b2tlQ29uZmlnKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIGRlc3RpbmF0aW9uQ29uZmlnOiBwcm9wcy5vbkZhaWx1cmUgfHwgcHJvcHMub25TdWNjZXNzXG4gICAgICAgID8ge1xuICAgICAgICAgIC4uLnByb3BzLm9uRmFpbHVyZSA/IHsgb25GYWlsdXJlOiBwcm9wcy5vbkZhaWx1cmUuYmluZCh0aGlzLCBwcm9wcy5mdW5jdGlvbiwgeyB0eXBlOiBEZXN0aW5hdGlvblR5cGUuRkFJTFVSRSB9KSB9IDoge30sXG4gICAgICAgICAgLi4ucHJvcHMub25TdWNjZXNzID8geyBvblN1Y2Nlc3M6IHByb3BzLm9uU3VjY2Vzcy5iaW5kKHRoaXMsIHByb3BzLmZ1bmN0aW9uLCB7IHR5cGU6IERlc3RpbmF0aW9uVHlwZS5TVUNDRVNTIH0pIH0gOiB7fSxcbiAgICAgICAgfVxuICAgICAgICA6IHVuZGVmaW5lZCxcbiAgICAgIGZ1bmN0aW9uTmFtZTogcHJvcHMuZnVuY3Rpb24uZnVuY3Rpb25OYW1lLFxuICAgICAgbWF4aW11bUV2ZW50QWdlSW5TZWNvbmRzOiBwcm9wcy5tYXhFdmVudEFnZSAmJiBwcm9wcy5tYXhFdmVudEFnZS50b1NlY29uZHMoKSxcbiAgICAgIG1heGltdW1SZXRyeUF0dGVtcHRzOiBwcm9wcy5yZXRyeUF0dGVtcHRzICE9PSB1bmRlZmluZWQgPyBwcm9wcy5yZXRyeUF0dGVtcHRzIDogdW5kZWZpbmVkLFxuICAgICAgcXVhbGlmaWVyOiBwcm9wcy5xdWFsaWZpZXIgfHwgJyRMQVRFU1QnLFxuICAgIH0pO1xuICB9XG59XG4iXX0=