"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

import requests as requests_http
from . import utils
from codataccounting.models import operations, shared
from typing import Optional

class Reports:
    r"""Reports"""
    _client: requests_http.Session
    _security_client: requests_http.Session
    _server_url: str
    _language: str
    _sdk_version: str
    _gen_version: str

    def __init__(self, client: requests_http.Session, security_client: requests_http.Session, server_url: str, language: str, sdk_version: str, gen_version: str) -> None:
        self._client = client
        self._security_client = security_client
        self._server_url = server_url
        self._language = language
        self._sdk_version = sdk_version
        self._gen_version = gen_version
        
    def get_aged_creditors_report(self, request: operations.GetAgedCreditorsReportRequest, retries: Optional[utils.RetryConfig] = None) -> operations.GetAgedCreditorsReportResponse:
        r"""Aged creditors report
        Returns aged creditors report for company that shows the total balance owed by a business to its suppliers over time.
        """
        base_url = self._server_url
        
        url = utils.generate_url(operations.GetAgedCreditorsReportRequest, base_url, '/companies/{companyId}/reports/agedCreditor', request)
        
        query_params = utils.get_query_params(operations.GetAgedCreditorsReportRequest, request)
        
        client = self._security_client
        
        retry_config = retries
        if retry_config is None:
            retry_config = utils.RetryConfig('backoff', True)
            retry_config.backoff = utils.BackoffStrategy(500, 60000, 1.5, 3600000)
            

        def do_request():
            return client.request('GET', url, params=query_params)
        
        http_res = utils.retry(do_request, utils.Retries(retry_config, [
            '408',
            '429',
            '5XX'
        ]))
        content_type = http_res.headers.get('Content-Type')

        res = operations.GetAgedCreditorsReportResponse(status_code=http_res.status_code, content_type=content_type, raw_response=http_res)
        
        if http_res.status_code == 200:
            if utils.match_content_type(content_type, 'application/json'):
                out = utils.unmarshal_json(http_res.text, Optional[shared.AgedCreditorReport])
                res.aged_creditor_report = out

        return res

    def get_aged_debtors_report(self, request: operations.GetAgedDebtorsReportRequest, retries: Optional[utils.RetryConfig] = None) -> operations.GetAgedDebtorsReportResponse:
        r"""Aged debtors report
        Returns aged debtors report for company that shows the total outstanding balance due from customers to the business over time.
        """
        base_url = self._server_url
        
        url = utils.generate_url(operations.GetAgedDebtorsReportRequest, base_url, '/companies/{companyId}/reports/agedDebtor', request)
        
        query_params = utils.get_query_params(operations.GetAgedDebtorsReportRequest, request)
        
        client = self._security_client
        
        retry_config = retries
        if retry_config is None:
            retry_config = utils.RetryConfig('backoff', True)
            retry_config.backoff = utils.BackoffStrategy(500, 60000, 1.5, 3600000)
            

        def do_request():
            return client.request('GET', url, params=query_params)
        
        http_res = utils.retry(do_request, utils.Retries(retry_config, [
            '408',
            '429',
            '5XX'
        ]))
        content_type = http_res.headers.get('Content-Type')

        res = operations.GetAgedDebtorsReportResponse(status_code=http_res.status_code, content_type=content_type, raw_response=http_res)
        
        if http_res.status_code == 200:
            if utils.match_content_type(content_type, 'application/json'):
                out = utils.unmarshal_json(http_res.text, Optional[shared.AgedDebtorReport])
                res.aged_debtor_report = out

        return res

    def is_aged_creditors_report_available(self, request: operations.IsAgedCreditorsReportAvailableRequest, retries: Optional[utils.RetryConfig] = None) -> operations.IsAgedCreditorsReportAvailableResponse:
        r"""Aged creditors report available
        Indicates whether the aged creditor report is available for the company.
        """
        base_url = self._server_url
        
        url = utils.generate_url(operations.IsAgedCreditorsReportAvailableRequest, base_url, '/companies/{companyId}/reports/agedCreditor/available', request)
        
        
        client = self._security_client
        
        retry_config = retries
        if retry_config is None:
            retry_config = utils.RetryConfig('backoff', True)
            retry_config.backoff = utils.BackoffStrategy(500, 60000, 1.5, 3600000)
            

        def do_request():
            return client.request('GET', url)
        
        http_res = utils.retry(do_request, utils.Retries(retry_config, [
            '408',
            '429',
            '5XX'
        ]))
        content_type = http_res.headers.get('Content-Type')

        res = operations.IsAgedCreditorsReportAvailableResponse(status_code=http_res.status_code, content_type=content_type, raw_response=http_res)
        
        if http_res.status_code == 200:
            if utils.match_content_type(content_type, 'application/json'):
                out = utils.unmarshal_json(http_res.text, Optional[bool])
                res.is_aged_creditors_report_available_200_application_json_boolean = out

        return res

    def is_aged_debtor_report_available(self, request: operations.IsAgedDebtorReportAvailableRequest, retries: Optional[utils.RetryConfig] = None) -> operations.IsAgedDebtorReportAvailableResponse:
        r"""Aged debtors report available
        Indicates whether the aged debtor report is available for the company.
        """
        base_url = self._server_url
        
        url = utils.generate_url(operations.IsAgedDebtorReportAvailableRequest, base_url, '/companies/{companyId}/reports/agedDebtor/available', request)
        
        
        client = self._security_client
        
        retry_config = retries
        if retry_config is None:
            retry_config = utils.RetryConfig('backoff', True)
            retry_config.backoff = utils.BackoffStrategy(500, 60000, 1.5, 3600000)
            

        def do_request():
            return client.request('GET', url)
        
        http_res = utils.retry(do_request, utils.Retries(retry_config, [
            '408',
            '429',
            '5XX'
        ]))
        content_type = http_res.headers.get('Content-Type')

        res = operations.IsAgedDebtorReportAvailableResponse(status_code=http_res.status_code, content_type=content_type, raw_response=http_res)
        
        if http_res.status_code == 200:
            if utils.match_content_type(content_type, 'application/json'):
                out = utils.unmarshal_json(http_res.text, Optional[bool])
                res.is_aged_debtor_report_available_200_application_json_boolean = out

        return res

    