#  Copyright 2022 Zeppelin Bend Pty Ltd
#
#  This Source Code Form is subject to the terms of the Mozilla Public
#  License, v. 2.0. If a copy of the MPL was not distributed with this
#  file, You can obtain one at https://mozilla.org/MPL/2.0/.
from dataclasses import dataclass
from typing import List

__all__ = ["TRANSFORMER_CATALOGUE"]


@dataclass
class XfmrCode:
    name: str
    phases: int
    windings: int
    kvas: List[int]
    kvs: List[float]
    xhl: float
    load_loss: float
    conns: List[str]
    tap: float


TRANSFORMER_CATALOGUE: List[XfmrCode] = [
    XfmrCode(name='E_16KVA_11KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[16, 16], kvs=[11, 22], xhl=3.3,
             load_loss=1.513, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_16KVA_11KV_433V_3PH_POLEMED', phases=3, windings=2, kvas=[16, 16], kvs=[11, 0.433], xhl=3.3,
             load_loss=1.513, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_16KVA_22KV__11kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[16, 16], kvs=[22, 11], xhl=3.3,
             load_loss=1.288, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_16KVA_22KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[16, 16], kvs=[22, 22], xhl=3.3,
             load_loss=1.288, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_16KVA_22KV_433V_3PH_POLEMED', phases=3, windings=2, kvas=[16, 16], kvs=[22, 0.433], xhl=3.3,
             load_loss=1.288, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_16KVA_33KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[16, 16], kvs=[33, 22], xhl=3.3,
             load_loss=1.281, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_16KVA_33KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[16, 16], kvs=[33, 33], xhl=3.3,
             load_loss=1.281, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_16KVA_33KV_19.1kV_SWER_Iso_Tx_POLE', phases=1, windings=2, kvas=[16, 16], kvs=[33, 33], xhl=3.3,
             load_loss=1.281, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_16KVA_33KV_433V_3PH_POLEMED', phases=3, windings=2, kvas=[16, 16], kvs=[33, 0.433], xhl=3.3,
             load_loss=1.281, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_16KVA_6.6KV_250V_1PH_POLEMED', phases=1, windings=2, kvas=[16, 16], kvs=[6.6, 0.5], xhl=3.3,
             load_loss=1.513, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_16KVA_6.6KV_433V_3PH_POLEMED', phases=3, windings=2, kvas=[16, 16], kvs=[6.6, 0.433], xhl=3.3,
             load_loss=1.513, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_16KVA_11KV_250V_1PH_POLEMED_Tyree', phases=1, windings=2, kvas=[16, 16], kvs=[11, 0.5], xhl=3.3,
             load_loss=1.513, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_16KVA_11KV_250V_SWER_POLEMED_Tyree', phases=1, windings=2, kvas=[16, 16], kvs=[11, 0.5], xhl=3.3,
             load_loss=1.513, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_16KVA_12.7KV_250V_SWER_POLEMED_Tyree', phases=1, windings=2, kvas=[16, 16], kvs=[22, 0.5], xhl=3.3,
             load_loss=1.288, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_16KVA_22KV_250V_1PH_POLEMED_Tyree', phases=1, windings=2, kvas=[16, 16], kvs=[22, 0.5], xhl=3.3,
             load_loss=1.288, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_16KVA_33KV_250V_1PH_POLEMED_Tyree', phases=1, windings=2, kvas=[16, 16], kvs=[33, 0.5], xhl=3.3,
             load_loss=1.281, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_16KVA_33KV_250V_SWER_POLEMED_Tyree', phases=1, windings=2, kvas=[16, 16], kvs=[33, 0.5], xhl=3.3,
             load_loss=1.281, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_16KVA_9.1KV_250V_SWER_POLEMED_Tyree', phases=1, windings=2, kvas=[16, 16], kvs=[33, 0.5], xhl=3.3,
             load_loss=1.281, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_16KVA_9.1KV_250V_SWER_POLEMED_Tyree', phases=1, windings=2, kvas=[16, 16], kvs=[33, 0.5], xhl=3.3,
             load_loss=1.281, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_25KVA_11KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[25, 25], kvs=[11, 22], xhl=3.3,
             load_loss=1.912, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_25KVA_22KV__11kV_HV1_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[25, 25], kvs=[22, 11],
             xhl=3.3, load_loss=1.552, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_25KVA_22KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[25, 25], kvs=[22, 22], xhl=3.3,
             load_loss=1.552, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_25KVA_22KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[25, 25], kvs=[22, 33], xhl=3.3,
             load_loss=1.552, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_25KVA_33KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[25, 25], kvs=[33, 33], xhl=3.3,
             load_loss=1.44, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_25KVA_33KV_19.1kV_SWER_Iso_Tx_POLE', phases=1, windings=2, kvas=[25, 25], kvs=[33, 33], xhl=3.3,
             load_loss=1.44, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_25KVA_6.6KV_433V_3PH_PAD_MOUNT', phases=3, windings=2, kvas=[25, 25], kvs=[6.6, 0.433], xhl=3.3,
             load_loss=1.912, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_25KVA_11KV_250V_1PH_POLEMED_Tyree', phases=1, windings=2, kvas=[25, 25], kvs=[11, 0.5], xhl=3.3,
             load_loss=1.324, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_25KVA_11KV_250V_SWER_POLEMED_Tyree', phases=1, windings=2, kvas=[25, 25], kvs=[11, 0.5], xhl=3.3,
             load_loss=1.324, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_25KVA_11KV_433V_3PH_PAD_MOUNT_Tyree', phases=3, windings=2, kvas=[25, 25], kvs=[11, 0.433],
             xhl=3.3, load_loss=1.912, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_25KVA_11KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[25, 25], kvs=[11, 0.433], xhl=3.3,
             load_loss=1.912, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_25KVA_12.7KV_250V_SWER_POLEMED_Tyree', phases=1, windings=2, kvas=[25, 25], kvs=[22, 0.5], xhl=3.3,
             load_loss=1.272, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_25KVA_22KV_250V_1PH_POLEMED_Tyree', phases=1, windings=2, kvas=[25, 25], kvs=[22, 0.5], xhl=3.3,
             load_loss=1.272, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_25KVA_22KV_433V_3PH_PAD_MOUNT_Tyree', phases=3, windings=2, kvas=[25, 25], kvs=[22, 0.433],
             xhl=3.3, load_loss=1.552, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_25KVA_22KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[25, 25], kvs=[22, 0.433], xhl=3.3,
             load_loss=1.552, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_25KVA_33KV_250V_1PH_POLEMED_Tyree', phases=1, windings=2, kvas=[25, 25], kvs=[33, 0.5], xhl=3.3,
             load_loss=1.376, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_25KVA_33KV_250V_SWER_POLEMED_Tyree', phases=1, windings=2, kvas=[25, 25], kvs=[33, 0.5], xhl=3.3,
             load_loss=1.376, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_25KVA_33KV_433V_3PH_PAD_MOUNT_Tyree', phases=3, windings=2, kvas=[25, 25], kvs=[33, 0.433],
             xhl=3.3, load_loss=1.44, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_25KVA_33KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[25, 25], kvs=[33, 0.433], xhl=3.3,
             load_loss=1.44, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_25KVA_9.1KV_250V_SWER_POLEMED_Tyree', phases=1, windings=2, kvas=[25, 25], kvs=[33, 0.5], xhl=3.3,
             load_loss=1.376, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_25KVA_9.1KV_250V_SWER_POLEMED_Tyree', phases=1, windings=2, kvas=[25, 25], kvs=[33, 0.5], xhl=3.3,
             load_loss=1.376, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_50KVA 3.3KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[50, 50], kvs=[3.3, 33], xhl=3.3,
             load_loss=0.9, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_50KVA_11KV_19.1kV_HV1 Iso_TXo POLE', phases=1, windings=2, kvas=[50, 50], kvs=[11, 33], xhl=3.6,
             load_loss=1.52, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_50KVA_11KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[50, 50], kvs=[11, 33], xhl=3.6,
             load_loss=1.52, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_50KVA_11KV_6.35kV_HV1 Iso_TXo POLE', phases=1, windings=2, kvas=[50, 50], kvs=[11, 11], xhl=3.6,
             load_loss=1.52, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_50KVA_22KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[50, 50], kvs=[22, 22], xhl=3.14,
             load_loss=1.34, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_50KVA_22KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[50, 50], kvs=[22, 33], xhl=3.14,
             load_loss=1.34, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_50KVA_22KV_19.1kV_SWER_Iso_Tx_POLE', phases=1, windings=2, kvas=[50, 50], kvs=[22, 33], xhl=3.14,
             load_loss=1.34, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_50KVA_33KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[50, 50], kvs=[33, 22], xhl=2.26,
             load_loss=1.1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_50KVA_33KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[50, 50], kvs=[33, 33], xhl=2.26,
             load_loss=1.1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_50KVA_33KV_6.6kV_HV1 Step_Down_Tx_PAD', phases=3, windings=2, kvas=[50, 50], kvs=[33, 6.6],
             xhl=2.26, load_loss=1.1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_50KVA_6.6KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[50, 50], kvs=[6.6, 33], xhl=3.6,
             load_loss=1.52, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_50KVA_6.6KV_250V_1PH_POLEMED', phases=1, windings=2, kvas=[50, 50], kvs=[6.6, 0.5], xhl=3.6,
             load_loss=1.52, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_50KVA_6.6KV_433V_3PH_POLEMED', phases=3, windings=2, kvas=[50, 50], kvs=[6.6, 0.433], xhl=3.6,
             load_loss=1.52, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA 6.35KV_250V SWER PADMOUNT_Tyree', phases=1, windings=2, kvas=[50, 50], kvs=[11, 0.5],
             xhl=3.3, load_loss=0.884, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_11KV_12.7kV_HV1_Iso_Tx_POLE_Wilson', phases=1, windings=2, kvas=[50, 50], kvs=[11, 22],
             xhl=3.3, load_loss=0.9, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_11KV_250V_1PH_PAD_MED_Tyree', phases=1, windings=2, kvas=[50, 50], kvs=[11, 0.5], xhl=3.3,
             load_loss=0.884, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_11KV_250V_1PH_POLEMED_Tyree', phases=1, windings=2, kvas=[50, 50], kvs=[11, 0.5], xhl=3.3,
             load_loss=0.884, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_11KV_433V_3PH_PADMOUNT_Tyree', phases=3, windings=2, kvas=[50, 50], kvs=[11, 0.433], xhl=3.6,
             load_loss=1.52, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_11KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[50, 50], kvs=[11, 0.433], xhl=3.6,
             load_loss=1.52, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_12.7KV_250V SWER PAD MED_Tyree', phases=1, windings=2, kvas=[50, 50], kvs=[22, 0.5], xhl=3.3,
             load_loss=0.836, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_12.7KV_250V_SWER_POLEMED_Tyree', phases=1, windings=2, kvas=[50, 50], kvs=[22, 0.5], xhl=3.3,
             load_loss=0.836, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_22KV_250V_1PH_PAD_MED_Tyree', phases=1, windings=2, kvas=[50, 50], kvs=[22, 0.5], xhl=3.3,
             load_loss=0.836, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_22KV_250V_1PH_POLEMED_Tyree', phases=1, windings=2, kvas=[50, 50], kvs=[22, 0.5], xhl=3.3,
             load_loss=0.836, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_22KV_433V_3PH_PADMOUNT_Tyree', phases=3, windings=2, kvas=[50, 50], kvs=[22, 0.433],
             xhl=3.14, load_loss=1.34, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_22KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[50, 50], kvs=[22, 0.433], xhl=3.14,
             load_loss=1.34, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_33KV_250V_1PH_POLEMED_Tyree', phases=1, windings=2, kvas=[50, 50], kvs=[33, 0.5], xhl=3.3,
             load_loss=0.91, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_33KV_433V_3PH_PADMOUNT_Tyree', phases=3, windings=2, kvas=[50, 50], kvs=[33, 0.433],
             xhl=2.26, load_loss=1.1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_33KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[50, 50], kvs=[33, 0.433], xhl=2.26,
             load_loss=1.1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_9.1KV_250V SWER PAD MED_Tyree', phases=1, windings=2, kvas=[50, 50], kvs=[33, 0.5], xhl=3.3,
             load_loss=0.91, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_50KVA_9.1KV_250V_SWER_POLEMED_Tyree', phases=1, windings=2, kvas=[50, 50], kvs=[33, 0.5], xhl=3.3,
             load_loss=0.91, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_55KVA_11kV_Vol Reg,_1PH_POLEMED', phases=1, windings=2, kvas=[55, 55], kvs=[11, 11], xhl=3.6,
             load_loss=1.52, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_63KVA_11KV_250V_1PH_POLEMED', phases=1, windings=2, kvas=[63, 63], kvs=[11, 0.5], xhl=3.3,
             load_loss=1.657, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_63KVA_11KV_250V_SWER_POLEMED', phases=1, windings=2, kvas=[63, 63], kvs=[11, 0.5], xhl=3.3,
             load_loss=1.657, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_63KVA_11KV_250V_SWER_POLEMED', phases=1, windings=2, kvas=[63, 63], kvs=[33, 0.5], xhl=3.3,
             load_loss=1.927, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_63KVA_22KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[63, 63], kvs=[22, 33], xhl=3.3,
             load_loss=1.551, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_63KVA_22KV_250V_1PH_POLEMED', phases=1, windings=2, kvas=[63, 63], kvs=[22, 0.5], xhl=3.3,
             load_loss=1.551, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_63KVA_33KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[63, 63], kvs=[33, 33], xhl=3.3,
             load_loss=1.927, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_63KVA_33KV_250V_1PH_POLEMED', phases=1, windings=2, kvas=[63, 63], kvs=[33, 0.5], xhl=3.3,
             load_loss=1.927, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_63KVA_6.6KV_433V_3PH_PADMOUNT', phases=3, windings=2, kvas=[63, 63], kvs=[6.6, 0.433], xhl=3.6,
             load_loss=1.52, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_63KVA_11KV_433V_3PH_PADMOUNT_Tyree', phases=3, windings=2, kvas=[63, 63], kvs=[11, 0.433], xhl=3.3,
             load_loss=1.657, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_63KVA_11KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[63, 63], kvs=[11, 0.433], xhl=3.3,
             load_loss=1.657, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_63KVA_22KV_433V_3PH_PADMOUNT_Tyree', phases=3, windings=2, kvas=[63, 63], kvs=[22, 0.433], xhl=3.3,
             load_loss=1.551, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_63KVA_22KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[63, 63], kvs=[22, 0.433], xhl=3.3,
             load_loss=1.551, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_63KVA_33KV_433V_3PH_PADMOUNT_Tyree', phases=3, windings=2, kvas=[63, 63], kvs=[33, 0.433], xhl=3.3,
             load_loss=1.927, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_63KVA_33KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[63, 63], kvs=[33, 0.433], xhl=3.3,
             load_loss=1.927, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_11KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[100, 100], kvs=[11, 33], xhl=4,
             load_loss=1.4, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_11KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[100, 100], kvs=[11, 33], xhl=4,
             load_loss=1.4, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_11KV_250V_1PH_POLE_MOUNT', phases=1, windings=2, kvas=[100, 100], kvs=[11, 0.5], xhl=4,
             load_loss=1.4, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_11KV_33kV__Step_Up_Txs_POLE', phases=3, windings=2, kvas=[100, 100], kvs=[11, 33], xhl=4,
             load_loss=1.4, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_11KV_6.35kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[100, 100], kvs=[11, 11], xhl=4,
             load_loss=1.4, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_11KV_6.35kV_SWER_Iso_Tx_PAD', phases=1, windings=2, kvas=[100, 100], kvs=[11, 11], xhl=4,
             load_loss=1.4, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_11KV_6.35kV_SWER_Iso_Tx_POLE', phases=1, windings=2, kvas=[100, 100], kvs=[11, 11], xhl=4,
             load_loss=1.4, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_12.7KV_250V_SWER_POLEMED', phases=1, windings=2, kvas=[100, 100], kvs=[22, 0.5], xhl=4.1,
             load_loss=1.381, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_22KV__11kV_HV1_Step_Down_Tx_DDN0_POLE', phases=3, windings=2, kvas=[100, 100], kvs=[22, 11],
             xhl=4.1, load_loss=1.381, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_22KV__11kV_HV1_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[100, 100], kvs=[22, 11],
             xhl=4.1, load_loss=1.381, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_22KV__11kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[100, 100], kvs=[22, 11], xhl=4.1,
             load_loss=1.381, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_22KV__11kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[100, 100], kvs=[22, 11], xhl=4.1,
             load_loss=1.381, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_22KV_250V_1PH_POLEMED', phases=1, windings=2, kvas=[100, 100], kvs=[22, 0.5], xhl=4.1,
             load_loss=1.381, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_33KV__11kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[100, 100], kvs=[33, 11],
             xhl=4.36, load_loss=0.976, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_33KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[100, 100], kvs=[33, 22], xhl=4.36,
             load_loss=0.976, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_33KV_22kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[100, 100], kvs=[33, 22], xhl=4.36,
             load_loss=0.976, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_6.6KV_433V_3PH_POLEMED', phases=3, windings=2, kvas=[100, 100], kvs=[6.6, 0.433], xhl=4,
             load_loss=1.4, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_100KVA_66KV_33kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[100, 100], kvs=[66, 33], xhl=3.7,
             load_loss=1.199, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_100KVA_11KV_12.7kV_HV1_Iso_Tx_PAD_Tyree', phases=1, windings=2, kvas=[100, 100], kvs=[11, 22],
             xhl=4, load_loss=1.4, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_100KVA_11KV_12.7kV_HV1_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[100, 100], kvs=[11, 22],
             xhl=4, load_loss=1.4, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_100KVA_11KV_22kV_Step_Up_Tx_Pole_Tyree', phases=3, windings=2, kvas=[100, 100], kvs=[11, 22],
             xhl=4, load_loss=1.4, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_100KVA_11KV_433V_3PH_PADMOUNT_Tyree', phases=3, windings=2, kvas=[100, 100], kvs=[11, 0.433],
             xhl=4.09, load_loss=1.011, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_100KVA_11KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[100, 100], kvs=[11, 0.433],
             xhl=4.09, load_loss=1.011, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_100KVA_22KV_12.7kV_HV1_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[100, 100], kvs=[22, 22],
             xhl=4, load_loss=1.4, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_100KVA_22KV_12.7kV_SWER_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[100, 100], kvs=[22, 22],
             xhl=4, load_loss=1.4, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_100KVA_22KV_19.1kV_HV1_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[100, 100], kvs=[22, 33],
             xhl=4, load_loss=0.92, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_100KVA_22KV_33kV_Step_Up_Tx_Pole_Tyree', phases=3, windings=2, kvas=[100, 100], kvs=[22, 33],
             xhl=4, load_loss=0.92, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_100KVA_22KV_433V_3PH_PADMOUNT_Tyree', phases=3, windings=2, kvas=[100, 100], kvs=[22, 0.433],
             xhl=4.1, load_loss=1.381, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_100KVA_22KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[100, 100], kvs=[22, 0.433],
             xhl=4.1, load_loss=1.381, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_100KVA_33KV_19.1kV_HV1_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[100, 100], kvs=[33, 33],
             xhl=4, load_loss=1.3, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_100KVA_33KV_433V_3PH_PADMOUNT_Tyree', phases=3, windings=2, kvas=[100, 100], kvs=[33, 0.433],
             xhl=4.36, load_loss=0.976, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_100KVA_33KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[100, 100], kvs=[33, 0.433],
             xhl=4.36, load_loss=0.976, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_200KVA_11KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[200, 200], kvs=[11, 22], xhl=4.21,
             load_loss=0.975, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_200KVA_11KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[200, 200], kvs=[11, 33], xhl=4.21,
             load_loss=0.975, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_200KVA_11KV_22kV_Step_Up_Tx_Pole', phases=3, windings=2, kvas=[200, 200], kvs=[11, 22], xhl=4.21,
             load_loss=0.975, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_200KVA_11KV_6.35kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[200, 200], kvs=[11, 11], xhl=4.21,
             load_loss=0.975, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_200KVA_11KV19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[200, 200], kvs=[11, 33], xhl=4.21,
             load_loss=0.975, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_200KVA_22KV__11kV_1PH Step_Down_Tx_PAD', phases=3, windings=2, kvas=[200, 200], kvs=[22, 11],
             xhl=3.93, load_loss=0.864, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_200KVA_22KV__11kV_3PH Step_Down_Tx_PAD', phases=3, windings=2, kvas=[200, 200], kvs=[22, 11],
             xhl=3.93, load_loss=0.864, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_200KVA_22KV__11kV_HV1_Step_Down_Tx_DDN0_POLE', phases=3, windings=2, kvas=[200, 200], kvs=[22, 11],
             xhl=3.93, load_loss=0.864, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_200KVA_22KV__11kV_HV1_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[200, 200], kvs=[22, 11],
             xhl=3.93, load_loss=0.864, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_200KVA_22KV__11kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[200, 200], kvs=[22, 11],
             xhl=3.93, load_loss=0.864, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_200KVA_33KV_19.1kV_HV1_Iso_Tx_YN0_POLE', phases=1, windings=2, kvas=[200, 200], kvs=[33, 33],
             xhl=4, load_loss=0.9, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_200KVA_6.6KV_433V_3PH_POLEMED', phases=3, windings=2, kvas=[200, 200], kvs=[6.6, 0.433], xhl=3.97,
             load_loss=1.12, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_11KV_433V_3PH_PADMOUNT_Tyree', phases=3, windings=2, kvas=[200, 200], kvs=[11, 0.433],
             xhl=4.21, load_loss=0.976, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_11KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[200, 200], kvs=[11, 0.433],
             xhl=4.21, load_loss=0.976, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_22KV_12.7kV_HV1_Iso_Tx_PAD_Tyree', phases=1, windings=2, kvas=[200, 200], kvs=[22, 22],
             xhl=4, load_loss=0.75, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_22KV_12.7kV_HV1_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[200, 200], kvs=[22, 22],
             xhl=4, load_loss=0.75, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_22KV_12.7kV_SWER_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[200, 200], kvs=[22, 22],
             xhl=4, load_loss=0.75, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_22KV_19.1kV_HV1_Iso_Tx_PAD_Tyree', phases=1, windings=2, kvas=[200, 200], kvs=[22, 33],
             xhl=4, load_loss=0.85, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_22KV_19.1kV_HV1_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[200, 200], kvs=[22, 33],
             xhl=4, load_loss=0.85, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_22KV_19.1kV_SWER_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[200, 200], kvs=[22, 33],
             xhl=4, load_loss=0.85, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_22KV_433V_3PH_PADMOUNT_Tyree', phases=3, windings=2, kvas=[200, 200], kvs=[22, 0.433],
             xhl=3.93, load_loss=0.864, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_22KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[200, 200], kvs=[22, 0.433],
             xhl=3.93, load_loss=0.864, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_33KV_12.7kV_HV1_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[200, 200], kvs=[33, 22],
             xhl=4, load_loss=0.9, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_33KV_19.1kV_HV1_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[200, 200], kvs=[33, 33],
             xhl=4, load_loss=0.9, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_33KV_19.1kV_SWER_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[200, 200], kvs=[33, 33],
             xhl=4, load_loss=0.9, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_33KV_433V_3PH_PADMOUNT_Tyree', phases=3, windings=2, kvas=[200, 200], kvs=[33, 0.433],
             xhl=3.81, load_loss=0.706, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_200KVA_33KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[200, 200], kvs=[33, 0.433],
             xhl=3.81, load_loss=0.706, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_250KVA_11KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[250, 250], kvs=[11, 22], xhl=4.21,
             load_loss=0.975, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_250KVA_11KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[250, 250], kvs=[11, 33], xhl=4.21,
             load_loss=0.975, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_250KVA_11KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[250, 250], kvs=[11, 33], xhl=4.21,
             load_loss=0.975, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_250KVA_11KV_22kV_Step_Up_Tx_Pole', phases=3, windings=2, kvas=[250, 250], kvs=[11, 22], xhl=4.21,
             load_loss=0.975, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_250KVA_11KV_33kV_Step_Up_Tx_Pole', phases=3, windings=2, kvas=[250, 250], kvs=[11, 33], xhl=4.21,
             load_loss=0.975, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_250KVA_11KV_6.35kV_HV1_Iso_Tx_PAD', phases=1, windings=2, kvas=[250, 250], kvs=[11, 11], xhl=4.21,
             load_loss=0.975, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_250KVA_22KV__11kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[250, 250], kvs=[22, 11], xhl=4,
             load_loss=0.92, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_250KVA_22KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[250, 250], kvs=[22, 22], xhl=4,
             load_loss=0.92, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_250KVA_33KV__11kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[250, 250], kvs=[33, 11], xhl=4,
             load_loss=1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_250KVA_33KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[250, 250], kvs=[33, 22], xhl=4,
             load_loss=1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_250KVA_33KV_22kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[250, 250], kvs=[33, 22], xhl=4,
             load_loss=1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_250KVA_66KV_33kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[250, 250], kvs=[66, 33], xhl=5.2,
             load_loss=1.001, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_250KVA_22KV_19.1kV_HV1_Iso_Tx_PAD_Tyree', phases=1, windings=2, kvas=[250, 250], kvs=[22, 33],
             xhl=4, load_loss=0.92, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_250KVA_22KV_19.1kV_HV1_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[250, 250], kvs=[22, 33],
             xhl=4, load_loss=0.92, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_250KVA_22KV_33kV_Step_Up_Tx_Pole_Tyree', phases=3, windings=2, kvas=[250, 250], kvs=[22, 33],
             xhl=4, load_loss=0.92, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_250KVA_33KV_19.1kV_HV1_Iso_Tx_PAD_Tyree', phases=1, windings=2, kvas=[250, 250], kvs=[33, 33],
             xhl=4, load_loss=1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_250KVA_33KV_19.1kV_HV1_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[250, 250], kvs=[33, 33],
             xhl=4, load_loss=1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_250KVA_33KV_19.1kV_SWER_Iso_Tx_POLE_Tyree', phases=1, windings=2, kvas=[250, 250], kvs=[33, 33],
             xhl=4, load_loss=1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_300KVA_11KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[300, 300], kvs=[11, 22], xhl=4.1,
             load_loss=1.235, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_300KVA_11KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[300, 300], kvs=[11, 33], xhl=4.1,
             load_loss=1.235, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_300KVA_11KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[300, 300], kvs=[11, 33], xhl=4.1,
             load_loss=1.235, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_300KVA_22KV__11kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[300, 300], kvs=[22, 11], xhl=4,
             load_loss=0.92, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_300KVA_22KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[300, 300], kvs=[22, 22], xhl=4,
             load_loss=0.92, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_300KVA_22KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[300, 300], kvs=[22, 33], xhl=4,
             load_loss=0.92, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_300KVA_33KV_12.7kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[300, 300], kvs=[33, 22], xhl=4,
             load_loss=1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_300KVA_33KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[300, 300], kvs=[33, 33], xhl=4,
             load_loss=1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_300KVA_33KV_19.1kV_SWER_Iso_Tx_POLE', phases=1, windings=2, kvas=[300, 300], kvs=[33, 33], xhl=4,
             load_loss=1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_300KVA_33KV_19.1kV_SWER_Iso_Tx_POLE', phases=1, windings=2, kvas=[300, 300], kvs=[33, 33], xhl=4,
             load_loss=1, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_315KVA_22KV__11kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[315, 315], kvs=[22, 11], xhl=4,
             load_loss=0.857, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_315KVA_33KV_19.1kV_HV1_Iso_Tx_YN0_POLE', phases=1, windings=2, kvas=[315, 315], kvs=[33, 33],
             xhl=4, load_loss=0.857, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_315KVA_6.6KV_433V_3PH_PADMOUNT', phases=3, windings=2, kvas=[315, 315], kvs=[6.6, 0.433], xhl=4,
             load_loss=0.921, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_315KVA_6.6KV_433V_3PH_POLEMED', phases=3, windings=2, kvas=[315, 315], kvs=[6.6, 0.433], xhl=4,
             load_loss=0.921, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_315KVA_11KV_433V_3PH_PADMOUNT_Wilson', phases=3, windings=2, kvas=[315, 315], kvs=[11, 0.433],
             xhl=4, load_loss=0.921, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_315KVA_11KV_433V_3PH_POLEMED_Wilson', phases=3, windings=2, kvas=[315, 315], kvs=[11, 0.433],
             xhl=4, load_loss=0.921, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_315KVA_22KV_433V_3PH_PADMOUNT_Wilson', phases=3, windings=2, kvas=[315, 315], kvs=[22, 0.433],
             xhl=4, load_loss=0.857, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_315KVA_22KV_433V_3PH_POLEMED_Wilson', phases=3, windings=2, kvas=[315, 315], kvs=[22, 0.433],
             xhl=4, load_loss=0.857, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_315KVA_33KV_433V_3PH_PADMOUNT_Tyree', phases=3, windings=2, kvas=[315, 315], kvs=[33, 0.433],
             xhl=3.94, load_loss=0.712, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_315KVA_33KV_433V_3PH_POLEMED_Tyree', phases=3, windings=2, kvas=[315, 315], kvs=[33, 0.433],
             xhl=3.94, load_loss=0.712, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_350KVA_33KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[350, 350], kvs=[33, 33], xhl=3.94,
             load_loss=0.712, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_500KVA_11KV_22kV_Step_Up_Tx_Pole', phases=3, windings=2, kvas=[500, 500], kvs=[11, 22], xhl=4,
             load_loss=0.821, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_500KVA_11KV_33kV_Step_Up_Tx_Pole', phases=3, windings=2, kvas=[500, 500], kvs=[11, 33], xhl=4,
             load_loss=0.821, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_500KVA_22KV__11kV_Step_Down_Tx_PAD', phases=3, windings=2, kvas=[500, 500], kvs=[22, 11], xhl=4,
             load_loss=0.977, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_500KVA_22KV__11kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[500, 500], kvs=[22, 11], xhl=4,
             load_loss=0.977, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_500KVA_22KV_19.1kV_HV1_Iso_Tx_PAD', phases=1, windings=2, kvas=[500, 500], kvs=[22, 33], xhl=4,
             load_loss=0.977, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_500KVA_22KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[500, 500], kvs=[22, 33], xhl=4,
             load_loss=0.977, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_500KVA_22KV_19.1kV_SWER_Iso_Tx_POLE', phases=1, windings=2, kvas=[500, 500], kvs=[22, 33], xhl=4,
             load_loss=0.977, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_500KVA_22KV_33kV_Step_Up_Tx_Pole', phases=3, windings=2, kvas=[500, 500], kvs=[22, 33], xhl=4,
             load_loss=0.977, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_500KVA_33KV__11kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[500, 500], kvs=[33, 11], xhl=4,
             load_loss=0.718, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_500KVA_33KV_19.1kV_HV1_Iso_Tx_POLE', phases=1, windings=2, kvas=[500, 500], kvs=[33, 33], xhl=4,
             load_loss=0.718, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_500KVA_33KV_22kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[500, 500], kvs=[33, 22], xhl=4,
             load_loss=0.718, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_500KVA_6.6KV_433V_3PH_POLEMED', phases=3, windings=2, kvas=[500, 500], kvs=[6.6, 0.433], xhl=4,
             load_loss=0.821, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_500KVA_66KV_33kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[500, 500], kvs=[66, 33], xhl=5.2,
             load_loss=1.001, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_500KVA_11KV_433V_3PH_PADMOUNT_Wilson', phases=3, windings=2, kvas=[500, 500], kvs=[11, 0.433],
             xhl=4, load_loss=0.821, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_500KVA_11KV_433V_3PH_POLEMED_Wilson', phases=3, windings=2, kvas=[500, 500], kvs=[11, 0.433],
             xhl=4, load_loss=0.821, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_500KVA_22KV_433V_3PH_PADMOUNT_Wilson', phases=3, windings=2, kvas=[500, 500], kvs=[22, 0.433],
             xhl=4, load_loss=0.977, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_500KVA_22KV_433V_3PH_POLEMED,_Wilson', phases=3, windings=2, kvas=[500, 500], kvs=[22, 0.433],
             xhl=4, load_loss=0.977, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_500KVA_22KV_433V_3PH_POLEMED_Wilson', phases=3, windings=2, kvas=[500, 500], kvs=[22, 0.433],
             xhl=4, load_loss=0.977, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_500KVA_33KV_433V_3PH_PADMOUNT_Wilson', phases=3, windings=2, kvas=[500, 500], kvs=[33, 0.433],
             xhl=4, load_loss=0.718, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_500KVA_33KV_433V_3PH_POLEMED_Wilson', phases=3, windings=2, kvas=[500, 500], kvs=[33, 0.433],
             xhl=4, load_loss=0.718, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_750KVA_11KV_22 kV_Step_Up_Tx_Pole', phases=3, windings=2, kvas=[750, 750], kvs=[11, 22], xhl=4,
             load_loss=0.977, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_750KVA_22KV__11kV_HV1_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[750, 750], kvs=[22, 11],
             xhl=4, load_loss=0.977, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_750KVA_22KV__11kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[750, 750], kvs=[22, 11], xhl=4,
             load_loss=0.977, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_750KVA_22KV_433V 3PH POLE MOUNT', phases=3, windings=2, kvas=[750, 750], kvs=[22, 0.433], xhl=4,
             load_loss=0.977, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_750KVA_22KV_433V_3PH_PADMOUNT', phases=3, windings=2, kvas=[750, 750], kvs=[22, 0.433], xhl=4,
             load_loss=0.977, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_750KVA_33KV_433V 3PH POLE MOUNT', phases=3, windings=2, kvas=[750, 750], kvs=[33, 0.433], xhl=4,
             load_loss=0.718, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_750KVA_33KV_433V_3PH_PADMOUNT', phases=3, windings=2, kvas=[750, 750], kvs=[33, 0.433], xhl=4,
             load_loss=0.718, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_750KVA_11KV_433V 3PH POLE MOUNT_Wilson', phases=3, windings=2, kvas=[750, 750], kvs=[11, 0.433],
             xhl=5, load_loss=1.075, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_750KVA_11KV_433V_3PH_PADMOUNT_Wilson', phases=3, windings=2, kvas=[750, 750], kvs=[11, 0.433],
             xhl=5, load_loss=1.075, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_11KV_22kV_Step_Up_Tx_PAD', phases=3, windings=2, kvas=[1000, 1000], kvs=[11, 22], xhl=5,
             load_loss=0.945, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_11KV_22kV_Step_Up_Tx_Pole', phases=3, windings=2, kvas=[1000, 1000], kvs=[11, 22], xhl=5,
             load_loss=0.945, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_11KV_33kV_Step_Up_Tx_PAD', phases=3, windings=2, kvas=[1000, 1000], kvs=[11, 33], xhl=5,
             load_loss=0.945, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_11KV_6.35kV_HV1_Iso_Tx_PAD', phases=1, windings=2, kvas=[1000, 1000], kvs=[11, 11], xhl=5,
             load_loss=0.945, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_11KV_6.35kV_SWER_Iso_Tx_PAD', phases=1, windings=2, kvas=[1000, 1000], kvs=[11, 11], xhl=5,
             load_loss=0.945, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_11KV_6.35kV_SWER_Iso_Tx_PAD', phases=1, windings=2, kvas=[1000, 1000], kvs=[11, 11], xhl=5,
             load_loss=0.945, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_22KV__11kV_Step_Down_Tx_PAD', phases=3, windings=2, kvas=[1000, 1000], kvs=[22, 11], xhl=5,
             load_loss=0.96, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_22KV__11kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[1000, 1000], kvs=[22, 11],
             xhl=5, load_loss=0.96, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_22KV_19.1kV_HV1_Iso_TX PAD', phases=1, windings=2, kvas=[1000, 1000], kvs=[22, 33], xhl=5,
             load_loss=0.96, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_22KV_33kV_Step_Up_Tx_PAD', phases=3, windings=2, kvas=[1000, 1000], kvs=[22, 33], xhl=5,
             load_loss=0.96, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_22KV_33kV_Step_Up_Tx_Pole', phases=3, windings=2, kvas=[1000, 1000], kvs=[22, 33], xhl=5,
             load_loss=0.96, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_33KV__11kV_3PH_POLEMED', phases=3, windings=2, kvas=[1000, 1000], kvs=[33, 11], xhl=5,
             load_loss=0.799, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_33KV__11kV_Step_Down_Tx_PAD', phases=3, windings=2, kvas=[1000, 1000], kvs=[33, 11], xhl=5,
             load_loss=0.799, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_33KV_22kV_3PH_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[1000, 1000], kvs=[33, 22],
             xhl=5, load_loss=0.799, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_33KV_22kV_Step_Down_Tx_PAD', phases=3, windings=2, kvas=[1000, 1000], kvs=[33, 22], xhl=5,
             load_loss=0.799, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1000KVA_66KV_33kV_Step_Down_Tx_PAD', phases=3, windings=2, kvas=[1000, 1000], kvs=[66, 33],
             xhl=6.25, load_loss=0.902, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_1000KVA_11KV_433V_3PH_PADMOUNT_Wilson', phases=3, windings=2, kvas=[1000, 1000], kvs=[11, 0.433],
             xhl=5, load_loss=0.945, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_1000KVA_22KV_433V_3PH_PADMOUNT_Wilson', phases=3, windings=2, kvas=[1000, 1000], kvs=[22, 0.433],
             xhl=5, load_loss=0.96, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_1000KVA_22KV_433V_3PH_POLEMED_Wilson', phases=3, windings=2, kvas=[1000, 1000], kvs=[22, 0.433],
             xhl=5, load_loss=0.96, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_1000KVA_33KV_433V_3PH_PADMOUNT_Wilson', phases=3, windings=2, kvas=[1000, 1000], kvs=[33, 0.433],
             xhl=5, load_loss=0.8, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1500KVA_11KV_22kV_Step_Up_Tx_PAD', phases=3, windings=2, kvas=[1500, 1500], kvs=[11, 22], xhl=5,
             load_loss=0.945, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1500KVA_11KV_22kV_Step_Up_Tx_PAD', phases=3, windings=2, kvas=[1500, 1500], kvs=[11, 22], xhl=5,
             load_loss=0.945, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1500KVA_11KV_33kV_Step_Up_Tx_PAD', phases=3, windings=2, kvas=[1500, 1500], kvs=[11, 33], xhl=5,
             load_loss=0.945, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1500KVA_11KV_433V_3PH_PADMOUNT', phases=3, windings=2, kvas=[1500, 1500], kvs=[11, 0.433], xhl=5,
             load_loss=0.945, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1500KVA_22KV__11kV_Step_Down_Tx_PAD', phases=3, windings=2, kvas=[1500, 1500], kvs=[22, 11], xhl=5,
             load_loss=0.96, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1500KVA_22KV__11kV_Step_Down_Tx_POLE', phases=3, windings=2, kvas=[1500, 1500], kvs=[22, 11],
             xhl=5, load_loss=0.96, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1500KVA_22KV_33kV_Step_Up_Tx_PAD', phases=3, windings=2, kvas=[1500, 1500], kvs=[22, 33], xhl=5,
             load_loss=0.96, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1500KVA_22KV_433V_3PH_PADMOUNT', phases=3, windings=2, kvas=[1500, 1500], kvs=[22, 0.433], xhl=5,
             load_loss=0.96, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1500KVA_33KV__11kV_Step_Down_Tx_PAD', phases=3, windings=2, kvas=[1500, 1500], kvs=[33, 11],
             xhl=6.25, load_loss=0.902, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1500KVA_33KV_22kV_Step_Down_Tx_PAD', phases=3, windings=2, kvas=[1500, 1500], kvs=[33, 22],
             xhl=6.25, load_loss=0.902, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='E_1500KVA_66KV_33kV_Step_Down_Tx_PAD', phases=3, windings=2, kvas=[1500, 1500], kvs=[66, 33],
             xhl=6.25, load_loss=0.902, conns=['delta', 'wye'], tap=1.0),
    XfmrCode(name='M_1500KVA_33KV_433V_3PH_PADMOUNT_Wilson', phases=3, windings=2, kvas=[1500, 1500], kvs=[33, 0.433],
             xhl=6.25, load_loss=0.902, conns=['delta', 'wye'], tap=1.0),
]
