# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2024-04-24T09:43:45+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional
from uuid import UUID

from pydantic import Field

from kelvin.api.client.base_model import BaseModelRoot
from kelvin.api.client.data_model import DataModelBase

from . import enum, type
from .type import AppManagerAppPlannerRules, AppManagerAppVersion, InstanceSettingsAppManagerPlannerRules


class AppManagerAppPlannerRulesUpdate(AppManagerAppPlannerRules):
    """
    AppManagerAppPlannerRulesUpdate object.

    Parameters
    ----------

    """


class Resource(BaseModelRoot[str]):
    """
    Resource object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=256, min_length=1)

    """

    __root__: str = Field(..., max_length=256, min_length=1)


class AppManagerAppResourcesList(DataModelBase):
    """
    AppManagerAppResourcesList object.

    Parameters
    ----------
    app_versions: Optional[List[str]]
    enabled_states: Optional[List[bool]]
    resources: Optional[List[Resource]]
    statuses: Optional[List[enum.AppManagerAppStatus]]

    """

    app_versions: Optional[List[str]] = Field(
        None,
        description="Search and filter on the list based on the Application versions. All strings in the array are treated as `OR`. ",
        example=["1.0.1", "1.0.2"],
    )
    enabled_states: Optional[List[bool]] = Field(
        None,
        description="Search and filter on the list based on the Application's key `enabled` for each Asset.",
        example=[True],
    )
    resources: Optional[List[Resource]] = Field(
        None,
        description="A filter on the list showing only Applications associated with any Assets in the array. The filter is on the full name only. All strings in the array are treated as `OR`. Each Asset name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:asset:beam_pump_16", "krn:asset:beam_pump_21"],
    )
    statuses: Optional[List[enum.AppManagerAppStatus]] = Field(
        None,
        description="Search and filter on the list based on the key 'status'. All strings in the array are treated as `OR`. ",
        example=["running", "updating"],
    )


class AppManagerAppVersionDataMappingGet(DataModelBase):
    """
    AppManagerAppVersionDataMappingGet object.

    Parameters
    ----------
    resources: Optional[List[Resource]]

    """

    resources: Optional[List[Resource]] = Field(
        None,
        description="A list of Assets running on the Application to perform the action requested. Partial names will be ignored. Each Asset name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:asset:bp_16", "krn:asset:bp_21"],
    )


class MappingItem(DataModelBase):
    """
    MappingItem object.

    Parameters
    ----------
    app: Optional[str]
    datastream: Optional[str]

    """

    app: Optional[str] = Field(
        None,
        description="Name of the variable used in the Application.",
        example="gas_flow_rate",
        max_length=64,
        min_length=1,
    )
    datastream: Optional[str] = Field(
        None,
        description="Name of the Data Stream linked to the variable in the Application.",
        example="gas_flow_rate",
        max_length=64,
        min_length=1,
    )


class Mappings(DataModelBase):
    """
    Mappings object.

    Parameters
    ----------
    inputs: Optional[List[MappingItem]]
    outputs: Optional[List[MappingItem]]

    """

    inputs: Optional[List[MappingItem]] = Field(
        None, description="Data mapping inputs between Application variables and Data Streams."
    )
    outputs: Optional[List[MappingItem]] = Field(
        None, description="Data mapping outputs between Application variables and Data Streams."
    )


class AppManagerAppVersionDeploy(DataModelBase):
    """
    AppManagerAppVersionDeploy object.

    Parameters
    ----------
    mappings: Optional[Mappings]
    resources: Optional[List[Resource]]

    """

    mappings: Optional[Mappings] = Field(None, description="Connecting Application inputs and outputs to Data Streams.")
    resources: Optional[List[Resource]] = Field(
        None,
        description="List of Assets to add to the Application. These Assets are paired with Data Streams to form Asset / Data Stream pairs, serving as pointers to the data location on Kelvin in the cloud.",
        example=["krn:asset:bp_16", "krn:asset:bp_21"],
    )


class AppManagerAppVersionStart(AppManagerAppVersion):
    """
    AppManagerAppVersionStart object.

    Parameters
    ----------

    """


class AppManagerAppVersionStop(AppManagerAppVersion):
    """
    AppManagerAppVersionStop object.

    Parameters
    ----------

    """


class AppManagerAppVersionUndeploy(AppManagerAppVersion):
    """
    AppManagerAppVersionUndeploy object.

    Parameters
    ----------

    """


class AppName(BaseModelRoot[str]):
    """
    AppName object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class AppManagerList(DataModelBase):
    """
    AppManagerList object.

    Parameters
    ----------
    app_names: Optional[List[AppName]]
    resources: Optional[List[Resource]]
    search: Optional[str]
    statuses: Optional[List[enum.AppManagerAppStatus]]

    """

    app_names: Optional[List[AppName]] = Field(
        None,
        description="A filter on the list based on the Application key `name`. The filter is on the full name only. All strings in the array are treated as `OR`. Can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["motor-speed-control", "load-control-app"],
    )
    resources: Optional[List[Resource]] = Field(
        None,
        description="A filter on the list showing only Applications associated with any Assets in the array. The filter is on the full name only. All strings in the array are treated as `OR`. Each Asset name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:asset:bp_16", "krn:asset:bp_21"],
    )
    search: Optional[str] = Field(
        None,
        description="Search and filter on the list based on the Application keys `title` (Display Name) or `name`. The search is case insensitive and will find partial matches as well.",
        example="Optimizer",
        max_length=64,
        min_length=1,
    )
    statuses: Optional[List[enum.AppManagerAppStatus]] = Field(
        None,
        description="Search and filter on the list based on the key 'status'. All strings in the array are treated as `OR`.",
        example=["running", "updating"],
    )


class AppCreate(DataModelBase):
    """
    AppCreate object.

    Parameters
    ----------
    manifest: Optional[Dict[str, Any]]
    payload: Optional[Dict[str, Any]]

    """

    manifest: Optional[Dict[str, Any]] = None
    payload: Optional[Dict[str, Any]] = None


class AppUpdate(DataModelBase):
    """
    AppUpdate object.

    Parameters
    ----------
    description: Optional[str]
    title: Optional[str]

    """

    description: Optional[str] = Field(
        None,
        description="New description of the App in the App Registry.",
        example="This application controls the speed of the beam pump motor in order to increase production for this type of artificial lift well. It uses values available from the control system such as Downhole Pressure, Motor Speed, Motor Torque and Choke position.\n",
        max_length=256,
        min_length=1,
    )
    title: Optional[str] = Field(
        None,
        description="New display name (`title`) of the App in the App Registry.",
        example="Motor Speed Control",
        max_length=64,
        min_length=1,
    )


class Status(Enum):
    running = "running"
    stopped = "stopped"
    updating = "updating"
    requires_attention = "requires_attention"


class AppExtraField(DataModelBase):
    """
    AppExtraField object.

    Parameters
    ----------
    app_name: Optional[str]
    app_versions: Optional[List[str]]
    name: Optional[str]
    statuses: Optional[List[Status]]

    """

    app_name: Optional[str] = Field(
        None,
        description="App Name from the App Registry. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="motor-speed-control",
        max_length=64,
        min_length=1,
    )
    app_versions: Optional[List[str]] = Field(
        None,
        description="Filter Apps by version number of the App. The filter is on the full version name only. Can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["1.2.0", "1.2.1"],
    )
    name: Optional[str] = Field(
        None,
        description="Unique identifier name for the key in the response, all keys in extra_fields object must be unique. Must contain only lowercase alphanumeric characters. The `.`, `_`, and `-` characters are allowed to separate words but cannot be at the beginning or end of the name.",
        example="motor-speed",
        max_length=64,
        min_length=1,
    )
    statuses: Optional[List[Status]] = Field(
        None, description="Filter Apps by current status of the App.", example=["running", "updating"]
    )


class Operator(Enum):
    Equal = "=="
    NotEqual = "!="
    Lower = "<"
    Greater = ">"
    GreaterOrEqual = ">="
    LowerOrEqual = "<="


class AssetInsightsFilter(DataModelBase):
    """
    AssetInsightsFilter object.

    Parameters
    ----------
    operator: Optional[Operator]
    value: Optional[Any]

    """

    operator: Optional[Operator] = Field(
        None,
        description="Type of operation for the filter, allowed operators: '==', '!=', '<', '>', '>=', '<='",
        example="==",
    )
    value: Optional[Any] = Field(
        None, description="Value to use in association with the `operator` for the filter of the field.", example=500
    )


class AssetPropertyExtraField(DataModelBase):
    """
    AssetPropertyExtraField object.

    Parameters
    ----------
    filters: Optional[List[AssetInsightsFilter]]
    name: Optional[str]
    primitive_type: Optional[enum.PropertyType]
    property_name: Optional[str]

    """

    filters: Optional[List[AssetInsightsFilter]] = Field(
        None,
        description="Optional to filter the returned Asset List based on an array of operator / value criteria relating to the Asset Property. Each filter is treated as `OR`. This will remove Assets from the returned Asset list that do not meet this criteria.",
    )
    name: Optional[str] = Field(
        None,
        description="Unique identifier name for the key in the response, all keys in extra_fields object must be unique. Must contain only lowercase alphanumeric characters. The `.`, `_`, and `-` characters are allowed to separate words but cannot be at the beginning or end of the name.",
        example="motor-speed",
        max_length=64,
        min_length=1,
    )
    primitive_type: Optional[enum.PropertyType] = Field(
        None, description="Property data type of the new filtered Asset Property column."
    )
    property_name: Optional[str] = Field(
        None,
        description="Name of the Asset Property to include. This Asset Property column are custom filtered fields that can be created with the Asset listing.",
        example="motor-speed-control",
        max_length=64,
        min_length=1,
    )


class Datastream(BaseModelRoot[str]):
    """
    Datastream object.

    Parameters
    ----------
    __root__: str = Field(..., example='motor-speed', max_length=64, min_length=1)

    """

    __root__: str = Field(..., example="motor-speed", max_length=64, min_length=1)


class ControlChangeExtraField(DataModelBase):
    """
    ControlChangeExtraField object.

    Parameters
    ----------
    datastreams: Optional[List[Datastream]]
    name: Optional[str]
    statuses: Optional[List[enum.ControlChangeState]]

    """

    datastreams: Optional[List[Datastream]] = Field(
        None,
        description="Filter Control Change Field by Control Change Data Stream key `datastream_name`. The filter is on the full name only. Can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
    )
    name: Optional[str] = Field(
        None,
        description="Unique identifier name used for the key in the response. All keys in `extra_fields` object must be unique. Must contain only lowercase alphanumeric characters. The `.`, `_`, and `-` characters are allowed to separate words but cannot be at the beginning or end of the name.",
        example="motor-speed",
        max_length=64,
        min_length=1,
    )
    statuses: Optional[List[enum.ControlChangeState]] = Field(
        None,
        description="Filter Control Change Field by the Control Change current `state`.",
        example=["pending", "sent"],
    )


class Agg(Enum):
    count = "count"
    mean = "mean"
    sum = "sum"
    max = "max"
    min = "min"


class DatastreamExtraFieldComputation(DataModelBase):
    """
    DatastreamExtraFieldComputation object.

    Parameters
    ----------
    agg: Optional[Agg]
    end_time: Optional[datetime]
    start_time: Optional[datetime]

    """

    agg: Optional[Agg] = Field(
        None,
        description="Perform mathematical calculations on a group of data defined by the 'starttime' and 'endtime' keys. For text data, the option available is `count`.",
    )
    end_time: Optional[datetime] = Field(
        None,
        description="UTC time for the latest time in the time range used by `agg` of Data Streams related to an Asset, formatted in RFC 3339.",
        example="2023-11-13T12:00:00Z",
    )
    start_time: Optional[datetime] = Field(
        None,
        description="UTC time for the earliest time in the time range used by `agg` of Data Streams related to an Asset, formatted in RFC 3339.",
        example="2023-11-13T12:00:00Z",
    )


class DatastreamExtraField(DataModelBase):
    """
    DatastreamExtraField object.

    Parameters
    ----------
    computation: Optional[DatastreamExtraFieldComputation]
    datastream_name: Optional[str]
    name: Optional[str]

    """

    computation: Optional[DatastreamExtraFieldComputation] = None
    datastream_name: Optional[str] = Field(
        None,
        description="Data Stream key `name`. Used in connection with the Asset `name` to retrieve the Asset / Data Stream pair's data",
        example="motor-speed",
        max_length=64,
        min_length=1,
    )
    name: Optional[str] = Field(
        None,
        description="Unique identifier name for the key in the response, all keys in extra_fields object must be unique. Must contain only lowercase alphanumeric characters. The `.`, `_`, and `-` characters are allowed to separate words but cannot be at the beginning or end of the name.",
        example="motor-speed-count",
        max_length=64,
        min_length=1,
    )


class ParameterExtraField(DataModelBase):
    """
    ParameterExtraField object.

    Parameters
    ----------
    app_name: Optional[str]
    filters: Optional[List[AssetInsightsFilter]]
    name: Optional[str]
    parameter_name: Optional[str]
    primitive_type: Optional[enum.ParameterType]

    """

    app_name: Optional[str] = Field(
        None,
        description="App Registry App key `name` to retrieve the Parameters. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="motor-speed-control",
        max_length=32,
        min_length=1,
    )
    filters: Optional[List[AssetInsightsFilter]] = Field(
        None,
        description="Optional to filter the returned Asset List based on an array of operator / value criteria relating to the Parameters. Each filter is treated as `OR`. This will remove Assets from the returned Asset list that do not meet this criteria. ",
    )
    name: Optional[str] = Field(
        None,
        description="Unique identifier name for the key in the response, all keys in extra_fields object must be unique. Must contain only lowercase alphanumeric characters. The `.`, `_`, and `-` characters are allowed to separate words but cannot be at the beginning or end of the name.",
        example="motor-speed-set-point-low",
        max_length=64,
        min_length=1,
    )
    parameter_name: Optional[str] = Field(
        None,
        description="Parameter key `name` to retrieve the Parameters from the App for the Assets. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="motor-speed-set-point",
        max_length=64,
        min_length=1,
    )
    primitive_type: Optional[enum.ParameterType] = None


class Type(BaseModelRoot[str]):
    """
    Type object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class RecommendationExtraField(DataModelBase):
    """
    RecommendationExtraField object.

    Parameters
    ----------
    name: Optional[str]
    since: Optional[datetime]
    source: Optional[str]
    states: Optional[List[enum.RecommendationState]]
    types: Optional[List[Type]]

    """

    name: Optional[str] = Field(
        None,
        description="Unique identifier name for the key in the response, all keys in extra_fields object must be unique. Must contain only lowercase alphanumeric characters. The `.`, `_`, and `-` characters are allowed to separate words but cannot be at the beginning or end of the name.",
        example="motor-speed-recommendations",
        max_length=64,
        min_length=1,
    )
    since: Optional[datetime] = Field(
        None,
        description="UTC time for the earliest creation time of Recommendations associated with an Asset, formatted in RFC 3339. Recommendations before this time regardless of `state` will be ignored.",
        example="2023-11-13T12:00:00Z",
    )
    source: Optional[str] = Field(
        None,
        description="KRN of the User or Service that created the Recommendation.",
        example="krn:user:richard.teo@kelvininc.com",
        max_length=256,
        min_length=1,
    )
    states: Optional[List[enum.RecommendationState]] = Field(
        None,
        description="Only return Recommendations associated with one or more `states`. The filter is on the full `state` name only. All strings in the array are treated as `OR`.",
        example=["pending", "auto_accepted"],
    )
    types: Optional[List[Type]] = Field(
        None,
        description="Only return Recommendations associated with one or more Recommendation Types. The filter is on the full Recommendation Type `name` only. All strings in the array are treated as `OR`. Each name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["decrease_speed", "increase_speed"],
    )


class AssetInsightsExtraFields(DataModelBase):
    """
    AssetInsightsExtraFields object.

    Parameters
    ----------
    apps: Optional[List[AppExtraField]]
    asset_properties: Optional[List[AssetPropertyExtraField]]
    control_changes: Optional[List[ControlChangeExtraField]]
    datastreams: Optional[List[DatastreamExtraField]]
    parameters: Optional[List[ParameterExtraField]]
    recommendations: Optional[List[RecommendationExtraField]]

    """

    apps: Optional[List[AppExtraField]] = Field(
        None,
        description="Create new columns based on Apps in the App Registry related to Assets. Multiple columns can be created, each with different App filter requirements.",
    )
    asset_properties: Optional[List[AssetPropertyExtraField]] = Field(
        None,
        description="Create new columns based on the `property` field in Assets. Multiple columns can be created, each with different `property` requirements. Separately, the `filter` option will remove Assets from the returned Asset list that do not meet the operator and value criteria.",
    )
    control_changes: Optional[List[ControlChangeExtraField]] = Field(
        None,
        description="Create new columns based on the Last Control Changes associated with the Asset. Multiple columns can be created, each with different Control Change filter requirements.",
    )
    datastreams: Optional[List[DatastreamExtraField]] = Field(
        None,
        description="Create new columns based on mathematical calculations for a time range of a Data Stream associated with the Assets. Multiple columns can be created, each with its own mathematical formula and Asset / Data Stream pair.",
    )
    parameters: Optional[List[ParameterExtraField]] = Field(
        None,
        description="Create new columns based on Application Parameters associated with the Asset. Multiple columns can be created, each with different Application Parameters requirements. Separately, the `filter` option will remove Assets from the returned Asset list that do not meet the operator and value criteria.",
    )
    recommendations: Optional[List[RecommendationExtraField]] = Field(
        None,
        description="Create new columns based on Recommendations associated with the Asset. Multiple columns can be created, each with different Recommendation filter requirements.",
    )


class Direction(Enum):
    asc = "asc"
    desc = "desc"


class AssetInsightsSortBy(DataModelBase):
    """
    AssetInsightsSortBy object.

    Parameters
    ----------
    direction: Optional[Direction]
    field: Optional[str]
    sort_by_extra_field: Optional[bool]

    """

    direction: Optional[Direction] = Field("asc", description="Sorting order for the results returned.", example="desc")
    field: Optional[str] = Field(
        "name",
        description="Key name of the Asset or `extra_field` field `name` to sort by. Source of field will be determined by the `SortByExtraField` key. If sorting by Asset key, available options are; `name`, `title`, `asset_type_name`, `asset_type_title` and `state`.",
        example="title",
    )
    sort_by_extra_field: Optional[bool] = Field(
        None,
        description="Choose the `sort_by` source of the `field` parameter. If `false`, the source of the `field` name is an Asset key. If `true`, the source is a `extra_field[].name` key.",
        example=False,
    )


class AssetName(BaseModelRoot[str]):
    """
    AssetName object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class AssetType(BaseModelRoot[str]):
    """
    AssetType object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class PinnedAsset(BaseModelRoot[str]):
    """
    PinnedAsset object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class SearchItem(BaseModelRoot[str]):
    """
    SearchItem object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class AssetInsightsGet(DataModelBase):
    """
    AssetInsightsGet object.

    Parameters
    ----------
    asset_names: Optional[List[AssetName]]
    asset_states: Optional[List[enum.AssetState]]
    asset_types: Optional[List[AssetType]]
    extra_fields: Optional[AssetInsightsExtraFields]
    force_parameters_refresh: Optional[bool]
    pinned_assets: Optional[List[PinnedAsset]]
    search: Optional[List[SearchItem]]
    sort_by: Optional[List[AssetInsightsSortBy]]

    """

    asset_names: Optional[List[AssetName]] = Field(
        None,
        description="Filter on the Asset parameter `name`. The filter is on the full name only. All strings in the array are treated as `OR`. Can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["beam", "MOTOR"],
    )
    asset_states: Optional[List[enum.AssetState]] = Field(
        None,
        description="Filter by the asset `state`. The filter is on the full name only. All strings in the array are treated as `OR`.",
        example=["offline", "unknown"],
    )
    asset_types: Optional[List[AssetType]] = Field(
        None,
        description="Filter on the Asset Type parameter `name`. The filter is on the full name only. All strings in the array are treated as `OR`. Can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["decrease_speed", "increase_speed"],
    )
    extra_fields: Optional[AssetInsightsExtraFields] = None
    force_parameters_refresh: Optional[bool] = Field(
        None, description="Force all parameters to be refreshed.", example=True
    )
    pinned_assets: Optional[List[PinnedAsset]] = Field(
        None,
        description="List of Asset names that should always appear at the top of page 1 of any search results. The filter is on the full name only. Can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["beam_pump_01", "beam_pump_32"],
    )
    search: Optional[List[SearchItem]] = Field(
        None,
        description="Search and filter on the list based on the Asset keys `title` (Display Name) or `name`. The search is case insensitive and will find partial matches as well.",
        example=["beam", "Motor"],
    )
    sort_by: Optional[List[AssetInsightsSortBy]] = Field(None, description="Options for sorting the returned results.")


class AssetPropertyCreate(DataModelBase):
    """
    AssetPropertyCreate object.

    Parameters
    ----------
    name: str
    title: Optional[str]
    value: Any

    """

    name: str = Field(
        ...,
        description="Unique identifier `name` for the Asset Property. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="water-line-pressure",
        max_length=64,
        min_length=1,
    )
    title: Optional[str] = Field(
        None,
        description="Title for this property. This title is ignored if the property with this `name` already exists.",
        example="Water Line Pressure",
        max_length=64,
        min_length=1,
    )
    value: Any = Field(
        ..., description="Value for this Asset Property. This can be stored as a number, string or boolean."
    )


class AssetCreate(DataModelBase):
    """
    AssetCreate object.

    Parameters
    ----------
    asset_type_name: str
    name: str
    properties: Optional[List[AssetPropertyCreate]]
    title: str

    """

    asset_type_name: str = Field(
        ...,
        description="Asset Type `name`. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="beam_pump",
        max_length=64,
        min_length=1,
    )
    name: str = Field(
        ...,
        description="Unique identifier `name` for the Asset. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="well_01",
        max_length=64,
        min_length=1,
    )
    properties: Optional[List[AssetPropertyCreate]] = Field(
        None,
        description="Array of custom properties. These properties are not used by the Kelvin Platform and are for end-user use only.",
    )
    title: str = Field(..., description="Asset display name (`title`).", example="Well 01", max_length=64, min_length=1)


class AssetBulkCreate(DataModelBase):
    """
    AssetBulkCreate object.

    Parameters
    ----------
    assets: List[AssetCreate]

    """

    assets: List[AssetCreate] = Field(
        ..., description="Array of objects, each object in the array represents a new Asset.", min_items=1
    )


class Name(BaseModelRoot[str]):
    """
    Name object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class AssetsAdvancedList(DataModelBase):
    """
    AssetsAdvancedList object.

    Parameters
    ----------
    asset_type_name: Optional[List[str]]
    names: Optional[List[Name]]
    search: Optional[List[SearchItem]]
    status_state: Optional[List[enum.AssetState]]

    """

    asset_type_name: Optional[List[str]] = Field(
        None,
        description="A filter on the list based on the key `asset_type_name`. The filter is on the full name only. All strings in the array are treated as `OR`. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["beam_pump", "progressive_cavity_pump"],
    )
    names: Optional[List[Name]] = Field(
        None,
        description="A filter on the list based on the key `name`. The filter is on the full name only. All strings in the array are treated as `OR`. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["well_1", "well_5"],
    )
    search: Optional[List[SearchItem]] = Field(
        None,
        description="Search and filter on the list based on the keys `title` (Display Name) or `name`. All strings in the array are treated as `OR`. The search is case insensitive and will find partial matches as well.",
        example=["well_1", "Well 3"],
    )
    status_state: Optional[List[enum.AssetState]] = Field(
        None,
        description="A filter on the list based on the key ['status']['state']. Multiple statuses can be given and will be filtered as `OR`.",
        example=["online"],
    )


class AssetPropertyDefinitionsList(DataModelBase):
    """
    AssetPropertyDefinitionsList object.

    Parameters
    ----------
    names: Optional[List[Name]]
    primitive_types: Optional[List[enum.PropertyType]]
    search: Optional[List[str]]

    """

    names: Optional[List[Name]] = Field(
        None,
        description="A filter on the list based on the key `name`. The filter is on the full name only. All strings in the array are treated as `OR`. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["production_casing_depth", "rp-property"],
    )
    primitive_types: Optional[List[enum.PropertyType]] = Field(
        None, description="A filter on the list based on the key `primitive_type`.", example=["number", "boolean"]
    )
    search: Optional[List[str]] = Field(
        None,
        description="Search and filter on the list based on the keys `title` (Display Name) or `name`. All strings in the array are treated as `OR`. The search is case insensitive and will find partial matches as well.",
    )


class AssetPropertyValuesGet(DataModelBase):
    """
    AssetPropertyValuesGet object.

    Parameters
    ----------
    primitive_types: Optional[List[enum.PropertyType]]
    property_names: Optional[List[str]]

    """

    primitive_types: Optional[List[enum.PropertyType]] = Field(
        None, description="A filter on the list based on the key `primitive_type`.", example=["number", "boolean"]
    )
    property_names: Optional[List[str]] = Field(
        None,
        description="A filter on the list based on the key `name`. The filter is on the full name only. All strings in the array are treated as `OR`. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["production_casing_depth", "rp-property"],
    )


class AssetTypeCreate(DataModelBase):
    """
    AssetTypeCreate object.

    Parameters
    ----------
    name: str
    title: str

    """

    name: str = Field(
        ...,
        description="Unique Asset Type name. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="beam_pump",
        max_length=64,
        min_length=1,
    )
    title: str = Field(
        ..., description="Asset Type display name (`title`).", example="Beam Pump", max_length=64, min_length=1
    )


class AssetTypesAdvancedList(DataModelBase):
    """
    AssetTypesAdvancedList object.

    Parameters
    ----------
    names: Optional[List[Name]]
    search: Optional[List[SearchItem]]

    """

    names: Optional[List[Name]] = Field(
        None,
        description="A filter on the list based on the key `name`. The filter is on the full name only. All strings in the array are treated as `OR`. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["pump", "centrifugal_pump"],
    )
    search: Optional[List[SearchItem]] = Field(
        None,
        description="Search and filter the Kelvin Asset Type list. Both the Display Name and the Name will be included in the search field criteria. This is given as an array, for example `[pump,fan]`. The search is case insensitive and will find partial matches as well. For example if a Kelvin Asset Type name is `centrifugal_pump`, then a match will be made if the search string is `pum` or `FUGaL`.",
        example=["pump", "fan"],
    )


class NameModel(BaseModelRoot[str]):
    """
    NameModel object.

    Parameters
    ----------
    __root__: str = Field(..., example=['pump', 'fan'], max_length=64, min_length=1)

    """

    __root__: str = Field(..., example=["pump", "fan"], max_length=64, min_length=1)


class AssetTypeBulkDelete(DataModelBase):
    """
    AssetTypeBulkDelete object.

    Parameters
    ----------
    names: List[NameModel]

    """

    names: List[NameModel] = Field(..., description="List of asset type names to be deleted.", min_items=1)


class AssetTypeUpdate(DataModelBase):
    """
    AssetTypeUpdate object.

    Parameters
    ----------
    title: Optional[str]

    """

    title: Optional[str] = Field(
        None, description="New Asset Type display name (`title`).", example="Beam Pump", max_length=64, min_length=1
    )


class NameModel1(BaseModelRoot[str]):
    """
    NameModel1 object.

    Parameters
    ----------
    __root__: str = Field(..., example=['well_1', 'well_62'], max_length=64, min_length=1)

    """

    __root__: str = Field(..., example=["well_1", "well_62"], max_length=64, min_length=1)


class AssetBulkDelete(DataModelBase):
    """
    AssetBulkDelete object.

    Parameters
    ----------
    names: List[NameModel1]

    """

    names: List[NameModel1] = Field(..., description="List of asset names to be deleted.", min_items=1)


class AssetUpdate(DataModelBase):
    """
    AssetUpdate object.

    Parameters
    ----------
    asset_type_name: Optional[str]
    properties: Optional[List[AssetPropertyCreate]]
    title: str

    """

    asset_type_name: Optional[str] = Field(
        None,
        description="Asset Type `name`. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="beam_pump",
        max_length=64,
        min_length=1,
    )
    properties: Optional[List[AssetPropertyCreate]] = Field(
        None,
        description="Array of custom properties. These properties are not used by the Kelvin Platform and are for end-user use only.",
    )
    title: str = Field(..., description="Asset display name (`title`).", example="Well 01", max_length=64, min_length=1)


class BridgeDeploy(DataModelBase):
    """
    BridgeDeploy object.

    Parameters
    ----------
    app_version: Optional[str]
    cluster_name: str
    name: str
    payload: type.AppYaml
    title: Optional[str]
    app_name: str

    """

    app_version: Optional[str] = Field(None, max_length=64)
    cluster_name: str = Field(
        ...,
        description="Unique identifier `name` of the Cluster. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="docs-demo-cluster-k3s",
        max_length=64,
        min_length=1,
    )
    name: str = Field(
        ...,
        description="Unique identifier `name` of the Bridge (Connection). The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="motor-plc-opcua-connection",
        max_length=32,
        min_length=1,
    )
    payload: type.AppYaml = Field(
        ...,
        description="Dictionary with keys for configuration, language, logging level, metrics mapping, protocol, and system packages. Each key represents specific settings and parameters for the Bridge (Connection).",
    )
    title: Optional[str] = Field(
        None,
        description="Display name (`title`) of the Bridge (Connection).",
        example="Motor PLC OPCUA Connection",
        max_length=64,
        min_length=1,
    )
    app_name: str = Field(
        ...,
        description="Unique identifier `name` of the App. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="test-app",
        max_length=64,
        min_length=1,
    )


class Source(BaseModelRoot[str]):
    """
    Source object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=256, min_length=1)

    """

    __root__: str = Field(..., max_length=256, min_length=1)


class ControlChangeClusteringGet(DataModelBase):
    """
    ControlChangeClusteringGet object.

    Parameters
    ----------
    end_date: datetime
    resources: Optional[List[Resource]]
    sources: Optional[List[Source]]
    start_date: datetime
    states: Optional[List[enum.ControlChangeState]]
    time_bucket: str

    """

    end_date: datetime = Field(
        ...,
        description="Most recent (end) creation time for counting the number of Control Changes. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2023-11-18T18:22:18.582724Z",
    )
    resources: Optional[List[Resource]] = Field(
        None,
        description="Filter Assets / Data Streams (`resources`) linked to Control Changes for inclusion in the count. The filter is on the full name only. All strings in the array are treated as `OR`. Each Asset and Data Stream name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:ad:bp_01/motor_speed_set_point", "krn:ad:bp_16/motor_speed_set_point"],
    )
    sources: Optional[List[Source]] = Field(
        None,
        description="Filter to only count Control Changes from certain `sources`. The filter is on the full name only. All strings in the array are treated as `OR`. Each KRN name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:app:motor-speed-control"],
    )
    start_date: datetime = Field(
        ...,
        description="Earliest (start) creation time for counting the  number of Control Changes. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2023-11-18T18:22:18.582724Z",
    )
    states: Optional[List[enum.ControlChangeState]] = Field(
        None,
        description="Filter to only count Control Changes associated with one or more `states`. The filter is on the full `state` name only. All strings in the array are treated as `OR`.",
        example=["sent", "applied"],
    )
    time_bucket: str = Field(
        ..., description="Defines the time range to use to group and count the Control Changes.", example="5m"
    )


class ControlChangeCreate(DataModelBase):
    """
    ControlChangeCreate object.

    Parameters
    ----------
    expiration_date: datetime
    from_: Optional[type.ControlChangeFrom]
    payload: Any
    resource: str
    retries: Optional[int]
    timeout: Optional[int]

    """

    expiration_date: datetime = Field(
        ...,
        description="UTC time when the Control Change will expire and the `status` automatically marked as `failed`, formatted in RFC 3339.",
        example="2023-11-18T18:22:18.582724Z",
    )
    from_: Optional[type.ControlChangeFrom] = Field(None, alias="from")
    payload: Any = Field(
        ...,
        description="The new value payload to be applied to the Asset / Data Stream pair in `resource`.",
        example=2000,
    )
    resource: str = Field(
        ...,
        description="The asset / data stream pair that this Control Change will be applied to.",
        example="krn:ad:beam_pump_01/motor_speed_set_point",
        max_length=256,
        min_length=1,
    )
    retries: Optional[int] = Field(
        None,
        description="How many times the Control Change Manager will try and send the same Control Change request to the Bridge before the change is tagged `failed` and no further attempts will be made. If the Bridge sends a `processed` acknowledgment, then the Control Change Manager will stop any further retries and wait for an `applied` response.",
        example=3,
    )
    timeout: Optional[int] = Field(
        None,
        description="How long the Control Change Manager will wait in seconds for the Bridge to send a `processed` acknowledgement before a retry will be attempted. If the total number of retries has reach its `retries` limit, then the change is tagged `failed` and no further attempts will be made.",
        example=150,
    )


class ControlChangeLastGet(DataModelBase):
    """
    ControlChangeLastGet object.

    Parameters
    ----------
    resources: List[Resource]
    sources: Optional[List[Source]]
    states: Optional[List[enum.ControlChangeState]]

    """

    resources: List[Resource] = Field(
        ...,
        description="Filter on the list to show Control Change for requested Asset / Data Stream pairs only. The filter is on the full KRN name only. All strings in the array are treated as `OR`. Each Asset and Data Stream name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:ad:beam_pump_02/motor_speed_set_point", "krn:ad:beam_pump_16/motor_speed_set_point"],
    )
    sources: Optional[List[Source]] = Field(
        None,
        description="Filter on the list to show Control Change for requested `sources` only. The filter is on the full KRN name only. All strings in the array are treated as `OR`. Each `source` name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:user:person@kelvin.ai", "krn:app:motor_speed_control"],
    )
    states: Optional[List[enum.ControlChangeState]] = Field(
        None,
        description="Filter on the Control Change states wanted. This will only check and filter on the `last_state` and not in the `status_log` object.",
        example=["sent", "applied"],
    )


class ControlChangesList(DataModelBase):
    """
    ControlChangesList object.

    Parameters
    ----------
    ids: Optional[List[UUID]]
    resources: Optional[List[Resource]]
    sources: Optional[List[Source]]
    states: Optional[List[enum.ControlChangeState]]

    """

    ids: Optional[List[UUID]] = Field(
        None,
        description="Filter on the list to show only specific Control Changes.",
        example=["0002bc79-b42f-461b-95d6-cf0a28ba87aa", "89df1fa1-72b3-4ffa-aae6-1a3e5324ee2e"],
    )
    resources: Optional[List[Resource]] = Field(
        None,
        description="Filter list to display only Control Changes for specified Asset/Data Stream pairs. The filter is on the full KRN name only. All strings in the array are treated as `OR`. Each Asset and Data Stream name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:ad:beam_pump_02/motor_speed_set_point", "krn:ad:beam_pump_16/motor_speed_set_point"],
    )
    sources: Optional[List[Source]] = Field(
        None,
        description="Filter list to display only Control Changes for specified `sources` only. The filter is on the full KRN name only. All strings in the array are treated as `OR`. Each `source` name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:user:person@kelvin.ai", "krn:app:motor_speed_control"],
    )
    states: Optional[List[enum.ControlChangeState]] = Field(
        None,
        description="Filter list to display only Control Changes for specified `states` only. This will only check and filter on the `last_state` and not in the `status_log` object.",
        example=["sent", "applied"],
    )


class ControlChangeRangeGet(DataModelBase):
    """
    ControlChangeRangeGet object.

    Parameters
    ----------
    end_date: datetime
    resources: List[Resource]
    sources: Optional[List[Source]]
    start_date: datetime
    states: Optional[List[enum.ControlChangeState]]

    """

    end_date: datetime = Field(
        ...,
        description="Most recent (end) creation time for the list of Control Changes. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2023-11-18T18:22:18.582724Z",
    )
    resources: List[Resource] = Field(
        ...,
        description="Filter Assets / Data Streams (`resources`) linked to Control Changes for inclusion in the count. The filter is on the full name only. All strings in the array are treated as `OR`. Each Asset and Data Stream name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:ad:bp_01/motor_speed_set_point", "krn:ad:bp_16/motor_speed_set_point"],
    )
    sources: Optional[List[Source]] = Field(
        None,
        description="Filter to only count Control Changes from certain `sources`. The filter is on the full name only. All strings in the array are treated as `OR`. Each KRN name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:app:motor-speed-control"],
    )
    start_date: datetime = Field(
        ...,
        description="Earliest (start) creation time for counting the  number of Control Changes. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2023-11-18T18:22:18.582724Z",
    )
    states: Optional[List[enum.ControlChangeState]] = Field(
        None,
        description="Filter to only count Control Changes associated with one or more `states`. The filter is on the full `state` name only. All strings in the array are treated as `OR`.",
        example=["sent", "applied"],
    )


class DataStreamSemanticTypeCreate(DataModelBase):
    """
    DataStreamSemanticTypeCreate object.

    Parameters
    ----------
    name: str
    title: str

    """

    name: str = Field(
        ...,
        description="Unique identifier `name` of the new Semantic Type.",
        example="mass_flow_rate",
        max_length=64,
        min_length=1,
    )
    title: str = Field(
        ...,
        description="Display name (`title`) of the new Semantic Type.",
        example="Mass Flow Rate",
        max_length=64,
        min_length=1,
    )


class DataStreamSemanticTypeUpdate(DataModelBase):
    """
    DataStreamSemanticTypeUpdate object.

    Parameters
    ----------
    title: Optional[str]

    """

    title: Optional[str] = Field(
        None,
        description="Display name (`title`) of the Semantic Type.",
        example="Mass Flow Rate",
        max_length=64,
        min_length=1,
    )


class DataStreamUnitCreate(DataModelBase):
    """
    DataStreamUnitCreate object.

    Parameters
    ----------
    name: str
    symbol: str
    title: str

    """

    name: str = Field(
        ...,
        description="Unique identifier `name` of the new Unit.",
        example="degree_fahrenheit",
        max_length=64,
        min_length=1,
    )
    symbol: str = Field(
        ...,
        description="A brief and precise character or set of characters that symbolize a specific measurement of the new Unit.",
        example="°F",
        max_length=16,
        min_length=1,
    )
    title: str = Field(
        ...,
        description="Display name (`title`) of the new Unit.",
        example="Degree Fahrenheit",
        max_length=64,
        min_length=1,
    )


class BulkDataStreamUnitCreate(DataModelBase):
    """
    BulkDataStreamUnitCreate object.

    Parameters
    ----------
    units: List[DataStreamUnitCreate]

    """

    units: List[DataStreamUnitCreate] = Field(
        ..., description="Array of objects, each object in the array represents a new Unit.", min_items=1
    )


class DataStreamUnitUpdate(DataModelBase):
    """
    DataStreamUnitUpdate object.

    Parameters
    ----------
    symbol: Optional[str]
    title: Optional[str]

    """

    symbol: Optional[str] = Field(
        None,
        description="A brief and precise character or set of characters that symbolize a specific measurement of the Unit.",
        example="°F",
        max_length=16,
        min_length=1,
    )
    title: Optional[str] = Field(
        None,
        description="Display name (`title`) of the Unit.",
        example="Degree Fahrenheit",
        max_length=64,
        min_length=1,
    )


class TypeModel(Enum):
    computed = "computed"
    measurement = "measurement"


class DataStreamCreate(DataModelBase):
    """
    DataStreamCreate object.

    Parameters
    ----------
    description: Optional[str]
    name: str
    data_type_name: enum.DataType
    semantic_type_name: Optional[str]
    title: str
    type: TypeModel
    unit_name: Optional[str]

    """

    description: Optional[str] = Field(
        None,
        description="Detailed description of the new Data Stream.",
        example="The rate at which gas flows from the reservoir to the surface.",
        max_length=200,
        min_length=1,
    )
    name: str = Field(
        ...,
        description="Unique identifier `name` for the new Data Stream. Can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="gas_flow_rate",
        max_length=64,
        min_length=1,
    )
    data_type_name: enum.DataType = Field(..., description="Data type of the new Data Stream.")
    semantic_type_name: Optional[str] = Field(
        None,
        description="Unique identifier `name` of the Semantic Type that describes the nature, purpose or origin of the data.",
        example="volume_flow_rate",
        max_length=64,
        min_length=1,
    )
    title: str = Field(
        ...,
        description="Display name (`title`) of the Data Stream.",
        example="Gas Flow Rate",
        max_length=64,
        min_length=1,
    )
    type: TypeModel = Field(..., description="Specifies the technique used for generating data in the Data Stream.")
    unit_name: Optional[str] = Field(
        None,
        description="Unique identifier `name` of the Units that describes the type or category of data represented by each unit.",
        example="litre_per_second",
        max_length=64,
        min_length=1,
    )


class BulkDataStreamCreate(DataModelBase):
    """
    BulkDataStreamCreate object.

    Parameters
    ----------
    datastreams: List[DataStreamCreate]

    """

    datastreams: List[DataStreamCreate] = Field(
        ..., description="Array of objects, each object in the array represents a new Datastream.", min_items=1
    )


class DataStreamUpdate(DataModelBase):
    """
    DataStreamUpdate object.

    Parameters
    ----------
    description: Optional[str]
    title: Optional[str]

    """

    description: Optional[str] = Field(
        None,
        description="Detailed description of the Data Stream.",
        example="The rate at which gas flows from the reservoir to the surface.",
        max_length=200,
        min_length=1,
    )
    title: Optional[str] = Field(
        None,
        description="Display name (`title`) of the Data Stream.",
        example="Gas Flow Rate",
        max_length=64,
        min_length=1,
    )


class DataTypeName(BaseModelRoot[str]):
    """
    DataTypeName object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class NameModel2(BaseModelRoot[str]):
    """
    NameModel2 object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class SemanticTypeName(BaseModelRoot[str]):
    """
    SemanticTypeName object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class UnitName(BaseModelRoot[str]):
    """
    UnitName object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class DataStreamsList(DataModelBase):
    """
    DataStreamsList object.

    Parameters
    ----------
    data_type_names: Optional[List[DataTypeName]]
    names: Optional[List[NameModel2]]
    search: Optional[List[SearchItem]]
    semantic_type_names: Optional[List[SemanticTypeName]]
    unit_names: Optional[List[UnitName]]

    """

    data_type_names: Optional[List[DataTypeName]] = Field(
        None,
        description="A filter on the list based on the key `data_type_name`. The filter is on the full name only. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["number", "string"],
    )
    names: Optional[List[NameModel2]] = Field(
        None,
        description="A filter on the list based on the  Data Stream key `name`. The filter is on the full name only. All strings in the array are treated as `OR`. Each string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["motor_temperature", "water_flow_rate"],
    )
    search: Optional[List[SearchItem]] = Field(
        None,
        description="Search and filter on the list based on the keys `title` (Display Name) or `name`. The search is case insensitive and will find partial matches as well. All strings in the array are treated as `OR`.",
        example=["motor", "water"],
    )
    semantic_type_names: Optional[List[SemanticTypeName]] = Field(
        None,
        description="A filter on the list based on the key `semantic_type_name`. The filter is on the full name only. All strings in the array are treated as `OR`. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["sound_pressure", "volume"],
    )
    unit_names: Optional[List[UnitName]] = Field(
        None,
        description="A filter on the list based on the key `unit_name`. The filter is on the full name only. All strings in the array are treated as `OR`. Each string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["kilogram", "litre_per_second"],
    )


class DatastreamName(BaseModelRoot[str]):
    """
    DatastreamName object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class DataStreamContextsList(DataModelBase):
    """
    DataStreamContextsList object.

    Parameters
    ----------
    datastream_names: Optional[List[DatastreamName]]
    resources: Optional[List[Resource]]
    sources: Optional[List[Source]]

    """

    datastream_names: Optional[List[DatastreamName]] = Field(
        None,
        description="A filter on the list based on the Data Stream key `name`. The filter is on the full name only. All strings in the array are treated as `OR`. Each string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["motor_temperature", "water_flow_rate"],
    )
    resources: Optional[List[Resource]] = Field(
        None,
        description="A filter on the list showing only Data Streams associated with any Assets in the array. The filter is on the full name only. All strings in the array are treated as `OR`. Each Asset name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:asset:bp_16", "krn:asset:bp_21"],
    )
    sources: Optional[List[Source]] = Field(
        None,
        description="A filter on the list showing only Data Streams associated with any workloads in the array. The filter is on the full name only. All strings in the array are treated as `OR`. Each Workload name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:wlappv:cluster1/app1/1.2.0"],
    )


class Context(BaseModelRoot[str]):
    """
    Context object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=256, min_length=1)

    """

    __root__: str = Field(..., max_length=256, min_length=1)


class DataTagCreate(DataModelBase):
    """
    DataTagCreate object.

    Parameters
    ----------
    start_date: datetime
    end_date: datetime
    tag_name: str
    resource: str
    source: Optional[str]
    description: Optional[str]
    contexts: Optional[List[Context]]

    """

    start_date: datetime = Field(
        ...,
        description="Start date for the Data Tag. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2024-02-06T18:22:18.582724Z",
    )
    end_date: datetime = Field(
        ...,
        description="End date for the Data Tag. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2024-02-06T19:22:18.582724Z",
    )
    tag_name: str = Field(
        ..., description="Tag name to categorize the Data Tag", example="Valve Change", max_length=64, min_length=1
    )
    resource: str = Field(
        ...,
        description="The Asset that this Data Tag is related to.",
        example="krn:asset:well_01",
        max_length=256,
        min_length=1,
    )
    source: Optional[str] = Field(
        None,
        description="The process that created this Data Tag. This can be a user or an automated process like a workload, application, etc.",
        example="krn:wlappv:cluster1/app1/1.2.0",
        max_length=256,
        min_length=1,
    )
    description: Optional[str] = Field(
        None,
        description="Detailed description of the Data Tag.",
        example="A Valve was changed today.",
        max_length=256,
        min_length=1,
    )
    contexts: Optional[List[Context]] = Field(
        None,
        description="A list of associated resources with this Data Tag. This can be a datastream, application or any other valid resource in the Kelvin Platform.",
        example=["krn:datastream:temperature", "krn:appversion:smart-pcp/2.0.0"],
    )


class DataTagUpdate(DataModelBase):
    """
    DataTagUpdate object.

    Parameters
    ----------
    start_date: Optional[datetime]
    end_date: Optional[datetime]
    tag_name: Optional[str]
    resource: Optional[str]
    description: Optional[str]
    contexts: Optional[List[Context]]

    """

    start_date: Optional[datetime] = Field(
        None,
        description="Start date for the Data Tag. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2024-02-06T18:22:18.582724Z",
    )
    end_date: Optional[datetime] = Field(
        None,
        description="End date for the Data Tag. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2024-02-06T19:22:18.582724Z",
    )
    tag_name: Optional[str] = Field(
        None, description="Tag name to categorize the Data Tag", example="Valve Change", max_length=64, min_length=1
    )
    resource: Optional[str] = Field(
        None,
        description="The Asset that this Data Tag is related to.",
        example="krn:asset:well_01",
        max_length=256,
        min_length=1,
    )
    description: Optional[str] = Field(
        None,
        description="Detailed description of the Data Tag.",
        example="A Valve was changed today.",
        max_length=256,
        min_length=1,
    )
    contexts: Optional[List[Context]] = Field(
        None,
        description="A list of associated resources with this Data Tag. This can be a datastream, application or any other valid resource in the Kelvin Platform.",
        example=["krn:datastream:temperature", "krn:appversion:smart-pcp/2.0.0"],
    )


class TagName(BaseModelRoot[str]):
    """
    TagName object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class DataTagList(DataModelBase):
    """
    DataTagList object.

    Parameters
    ----------
    ids: Optional[List[UUID]]
    search: Optional[List[SearchItem]]
    tag_names: Optional[List[TagName]]
    resources: Optional[List[Resource]]
    sources: Optional[List[Source]]
    contexts: Optional[List[Context]]
    start_date: Optional[datetime]
    end_date: Optional[datetime]

    """

    ids: Optional[List[UUID]] = Field(
        None,
        description="Search and filter on the list based on the key `id`. The filter is on the full UUID `id` only. All strings in the array are treated as `OR`.",
        example=["0002bc79-b42f-461b-95d6-cf0a28ba87aa", "00080f9e-d086-452d-b41d-c8aa8fb27c92"],
    )
    search: Optional[List[SearchItem]] = Field(
        None,
        description="Search and filter on the list based on the key `tag_name`. The search is case insensitive and will find partial matches as well. All strings in the array are treated as `OR`.",
        example=["break", "change"],
    )
    tag_names: Optional[List[TagName]] = Field(
        None,
        description="A filter on the list showing only Data Tags associated with one or more tags. The filter is on the full Data Tags `tag_name` only. All strings in the array are treated as `OR`.",
        example=["Breakdown", "Valve Change"],
    )
    resources: Optional[List[Resource]] = Field(
        None,
        description="A filter on the list showing only Data Tags associated with any Assets in the array. The filter is on the full KRN Asset name only. All strings in the array are treated as `OR`. Each Asset name must be in the KRN format.",
        example=["krn:asset:bp_16", "krn:asset:bp_21"],
    )
    sources: Optional[List[Source]] = Field(
        None,
        description="A filter on the list showing only Data Tags created by a certain source. The filter is on the full `source` KRN name only. All strings in the array are treated as `OR`.",
        example=["krn:wlappv:cluster1/app1/1.2.0", "krn:user:richard.teo@kelvininc.com"],
    )
    contexts: Optional[List[Context]] = Field(
        None,
        description="A filter on the list showing only Data Tags associated with any context resource. The filter is on the full `contexts` KRN only. All strings in the array are treated as `OR`.",
        example=["krn:datastream:temperature", "krn:appversion:smart-pcp/2.0.0"],
    )
    start_date: Optional[datetime] = Field(
        None,
        description="Earliest `end_date` time for the list of Data Tags. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2024-02-06T00:00:00.000000Z",
    )
    end_date: Optional[datetime] = Field(
        None,
        description="Most recent `start_date` time for the list of Data Tags. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2024-02-07T00:00:00.000000Z",
    )


class TagCreate(DataModelBase):
    """
    TagCreate object.

    Parameters
    ----------
    name: str
    metadata: Optional[Dict[str, Any]]

    """

    name: str = Field(
        ..., description="Case insensitive Tag name.", example="Valve Change", max_length=64, min_length=1
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description="Detailed Attributes of the Tag. The structure of the `metadata` object can have any key/value structure and will depend on the required properties of the Tag.",
    )


class TagUpdate(DataModelBase):
    """
    TagUpdate object.

    Parameters
    ----------
    metadata: Optional[Dict[str, Any]]

    """

    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description="Detailed Attributes of the Tag. The structure of the `metadata` object can have any key/value structure and will depend on the required properties of the Tag.",
    )


class FilesList(DataModelBase):
    """
    FilesList object.

    Parameters
    ----------
    file_names: Optional[List[str]]
    sources: Optional[List[str]]
    search: Optional[List[str]]

    """

    file_names: Optional[List[str]] = Field(
        None,
        description="Array of file names to filter. This filter only returns exact matches with the passed values.",
        example=["test.csv", "test.tar.gz"],
    )
    sources: Optional[List[str]] = Field(
        None,
        description="Array of sources to filter. This filter only returns exact matches with the passed values. (Note that all sources are in the KRN format)",
        example=["krn:user:user1", "krn:user:user2"],
    )
    search: Optional[List[str]] = Field(
        None,
        description="Search and filter based of file name. All values in array will be filtered as `OR`. The search is case insensitive and will find partial matches as well.",
        example=["test.csv", "test.tar.gz"],
    )


class InstanceSettingsAppManagerPlannerRulesUpdate(InstanceSettingsAppManagerPlannerRules):
    """
    InstanceSettingsAppManagerPlannerRulesUpdate object.

    Parameters
    ----------

    """


class ClusterSettingAutoUpdate(DataModelBase):
    """
    ClusterSettingAutoUpdate object.

    Parameters
    ----------
    enabled: Optional[bool]
    interval: Optional[int]

    """

    enabled: Optional[bool] = Field(None, description="If the auto update is enabled.", example=True)
    interval: Optional[int] = Field(None, description="If the auto update is enabled.")


class ClusterSettingDeployOptions(DataModelBase):
    """
    ClusterSettingDeployOptions object.

    Parameters
    ----------
    instantly_apply: Optional[bool]
    pre_download: Optional[bool]

    """

    instantly_apply: Optional[bool] = Field(
        None,
        description="Option if upgrades should be applied automatically and instantly as soon as they are available in the Cluster.",
        example=True,
    )
    pre_download: Optional[bool] = Field(
        None,
        description="Option for pre-downloading Cluster Instance. Actual upgrade initiation requires manual action or having `instantly_apply` set to true.",
        example=True,
    )


class ClusterSettingForwardLogs(DataModelBase):
    """
    ClusterSettingForwardLogs object.

    Parameters
    ----------
    buffer_size: Optional[int]
    enabled: Optional[bool]

    """

    buffer_size: Optional[int] = Field(
        5,
        description="Size in gigabytes of the log storage in the Instance Cluster when Cluster is offline. Any setting changes will delete all logs not yet transferred from the Cluster to Cloud.",
        example=10,
    )
    enabled: Optional[bool] = Field(
        True,
        description="Enable offline storage in the Instance Cluster for log retention; transfers logs when Cluster is next online.",
        example=True,
    )


class ClusterSettingSync(DataModelBase):
    """
    ClusterSettingSync object.

    Parameters
    ----------
    interval: Optional[int]

    """

    interval: Optional[int] = Field(
        30,
        description="Frequency in minutes that the Instance Cluster checks for new changes to apply to Workloads or Applications (deploy, start, stop, etc.)",
        example=60,
        ge=1,
        le=1440,
    )


class ClusterSettingTelemetry(DataModelBase):
    """
    ClusterSettingTelemetry object.

    Parameters
    ----------
    buffer_size: Optional[int]
    enabled: Optional[bool]
    scrape_interval: Optional[int]

    """

    buffer_size: Optional[int] = Field(
        5,
        description="Size in gigabytes of telemetry data storage in the Cluster Instance when the Cluster is offline. Any setting changes will delete all logs not yet transferred from the Cluster to Cloud.",
        example=10,
        ge=1,
        le=20,
    )
    enabled: Optional[bool] = Field(
        True,
        description="Enable offline storage in the Cluster Instance for telemetry data retention; transfers data when the Cluster is next online.",
    )
    scrape_interval: Optional[int] = Field(
        30,
        description="Time interval in seconds to save each telemetry data. Any setting changes will delete all data not yet transferred from the Cluster Instance to Cloud.",
        example=60,
        ge=1,
        le=3600,
    )


class ClusterSetting(DataModelBase):
    """
    ClusterSetting object.

    Parameters
    ----------
    auto_update: Optional[ClusterSettingAutoUpdate]
    cluster_upgrade: Optional[ClusterSettingDeployOptions]
    forward_logs: Optional[ClusterSettingForwardLogs]
    sync: Optional[ClusterSettingSync]
    telemetry: Optional[ClusterSettingTelemetry]
    workload_deploy: Optional[ClusterSettingDeployOptions]

    """

    auto_update: Optional[ClusterSettingAutoUpdate] = None
    cluster_upgrade: Optional[ClusterSettingDeployOptions] = None
    forward_logs: Optional[ClusterSettingForwardLogs] = None
    sync: Optional[ClusterSettingSync] = None
    telemetry: Optional[ClusterSettingTelemetry] = None
    workload_deploy: Optional[ClusterSettingDeployOptions] = None


class InstanceSettingsKelvinClusterUpdate(DataModelBase):
    """
    InstanceSettingsKelvinClusterUpdate object.

    Parameters
    ----------
    payload: Optional[ClusterSetting]

    """

    payload: Optional[ClusterSetting] = None


class InstanceSettingsUpdate(DataModelBase):
    """
    InstanceSettingsUpdate object.

    Parameters
    ----------
    payload: Optional[Dict[str, Any]]

    """

    payload: Optional[Dict[str, Any]] = Field(
        None,
        description="The Instance Settings. The structure of this `payload` object depends on the type of Instance Setting being defined.",
    )


class OrchestrationClustersCreate(DataModelBase):
    """
    OrchestrationClustersCreate object.

    Parameters
    ----------
    name: Optional[str]
    title: Optional[str]
    type: Optional[enum.ClusterType]

    """

    name: Optional[str] = Field(
        None,
        description="Unique identifier key `name` of the Cluster.",
        example="aws-cluster",
        max_length=64,
        min_length=1,
    )
    title: Optional[str] = Field(
        None, description="Display name (`title`) of the Cluster.", example="AWS Cluster", max_length=64, min_length=1
    )
    type: Optional[enum.ClusterType] = Field(None, description="Type of Cluster to deploy..")


class ClusterUpgrade(DataModelBase):
    """
    ClusterUpgrade object.

    Parameters
    ----------
    instantly_apply: Optional[bool]
    pre_download: Optional[bool]

    """

    instantly_apply: Optional[bool] = Field(
        None,
        description="Setting to immediately apply upgrades to Workloads or Applications as soon as they are available in the Cluster.",
    )
    pre_download: Optional[bool] = Field(
        None,
        description="Setting to immediately download new Workloads or Application upgrades to the Cluster; requires manual initiation or `instantly_apply` set to true to initiate upgrade.",
    )


class OrchestrationClustersUpdate(DataModelBase):
    """
    OrchestrationClustersUpdate object.

    Parameters
    ----------
    forward_logs_buffer_size: Optional[int]
    forward_logs_enabled: Optional[bool]
    manifests_scrape_enabled: Optional[bool]
    manifests_scrape_interval: Optional[int]
    ready: Optional[bool]
    sync_scrape_interval: Optional[int]
    telemetry_buffer_size: Optional[int]
    telemetry_enabled: Optional[bool]
    telemetry_scrape_interval: Optional[int]
    title: Optional[str]
    upgrade: Optional[ClusterUpgrade]

    """

    forward_logs_buffer_size: Optional[int] = Field(
        5,
        description="Size in gigabytes of the log storage in the Cluster when Cluster is offline. Any setting changes will delete all logs not yet transferred from the Cluster to Cloud.",
        example=10,
        ge=1,
        le=20,
    )
    forward_logs_enabled: Optional[bool] = Field(
        True,
        description="Enable offline storage in the Cluster for log retention; transfers logs when the Cluster is next online.",
    )
    manifests_scrape_enabled: Optional[bool] = Field(
        True, description="Enable auto update Kelvin Software running on the Cluster."
    )
    manifests_scrape_interval: Optional[int] = Field(
        86400,
        description="Frequency in seconds for checking updates in the Cloud for Kelvin Software running on the Cluster.",
        example=3600,
        ge=30,
        le=86400,
    )
    ready: Optional[bool] = Field(None, description="Setting to inform Kelvin UI if the Cluster is ready.")
    sync_scrape_interval: Optional[int] = Field(
        30,
        description="Frequency in seconds that the Cluster checks for new changes to apply in Workloads or Applications (deploy, start, stop, etc.)",
        example=3600,
        ge=10,
        le=86400,
    )
    telemetry_buffer_size: Optional[int] = Field(
        5,
        description="Size in gigabytes of telemetry data storage in the Cluster when the Cluster is offline. Any setting changes will delete all logs not yet transferred from the Cluster to Cloud.",
        example=10,
        ge=1,
        le=20,
    )
    telemetry_enabled: Optional[bool] = Field(
        True,
        description="Enable offline storage in the Cluster for telemetry data retention; transfers data when the Cluster is next online.",
    )
    telemetry_scrape_interval: Optional[int] = Field(
        30,
        description="Time interval in seconds to save each telemetry data. Any setting changes will delete all data not yet transferred from the Cluster to Cloud.",
        example=60,
        ge=1,
        le=3600,
    )
    title: Optional[str] = Field(
        None,
        description="New display name (`title`) for Cluster.",
        example="AWS Cluster 01",
        max_length=64,
        min_length=1,
    )
    upgrade: Optional[ClusterUpgrade] = None


class ParameterValueUpdate(DataModelBase):
    """
    ParameterValueUpdate object.

    Parameters
    ----------
    comment: Optional[str]
    name: str
    value: Any

    """

    comment: Optional[str] = Field(
        None,
        description="Any comments about the updates to the Parameter value.",
        example="Updating parameter for well operational optimization.",
        max_length=200,
        min_length=1,
    )
    name: str = Field(
        ...,
        description="Unique identifier name for this Parameter.",
        example="gas_flow_rate_max_threshold",
        max_length=64,
        min_length=1,
    )
    value: Any = Field(
        ...,
        description="New value for this parameter. The format of the value expected will depend on its Primitive Type.",
        example=160,
    )


class ParametersUpdate(DataModelBase):
    """
    ParametersUpdate object.

    Parameters
    ----------
    parameters: List[ParameterValueUpdate]
    source: Optional[str]

    """

    parameters: List[ParameterValueUpdate] = Field(
        ...,
        description="New values for one or more Parameters for the Asset in the App. Bulk updates of Parameters are possible.",
    )
    source: Optional[str] = Field(
        None,
        description="KRN of the User or Service that last created or updated the Parameter.",
        example="krn:user:richard.teo@kelvininc.com",
        max_length=256,
        min_length=1,
    )


class ParamtersAppVersionUpdate(DataModelBase):
    """
    ParamtersAppVersionUpdate object.

    Parameters
    ----------
    source: Optional[str]
    resource_parameters: List[type.ResourceParameters]

    """

    source: Optional[str] = Field(
        None,
        description="The source of the change request (restricted to Service Accounts)",
        max_length=256,
        min_length=1,
    )
    resource_parameters: List[type.ResourceParameters]


class AppNameModel(BaseModelRoot[str]):
    """
    AppNameModel object.

    Parameters
    ----------
    __root__: str = Field(..., example='motor-speed-control', max_length=64, min_length=1)

    """

    __root__: str = Field(..., example="motor-speed-control", max_length=64, min_length=1)


class NameModel3(BaseModelRoot[str]):
    """
    NameModel3 object.

    Parameters
    ----------
    __root__: str = Field(..., example='gas_flow_rate_max_threshold', max_length=64, min_length=1)

    """

    __root__: str = Field(..., example="gas_flow_rate_max_threshold", max_length=64, min_length=1)


class ParametersDefinitionsList(DataModelBase):
    """
    ParametersDefinitionsList object.

    Parameters
    ----------
    app_names: Optional[List[AppNameModel]]
    names: Optional[List[NameModel3]]
    primitive_types: Optional[List[enum.ParameterType]]
    search: Optional[List[SearchItem]]

    """

    app_names: Optional[List[AppNameModel]] = Field(
        None,
        description="A filter on the list based on the key `app_name`. The filter is on the full name only. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
    )
    names: Optional[List[NameModel3]] = Field(None, description="Unique identifier name for this Parameter.")
    primitive_types: Optional[List[enum.ParameterType]] = Field(
        None,
        description="Filter on the list based on the Primitive data type key `primitive_type` of the Parameter.",
        example=["number", "boolean"],
    )
    search: Optional[List[SearchItem]] = Field(
        None,
        description="Search and filter on the list based on the keys `parameter_name`. The search is case insensitive and will find partial matches as well. All strings in the array are treated as `OR`. ",
        example=["motor", "water"],
    )


class ParameterAppVersion(DataModelBase):
    """
    ParameterAppVersion object.

    Parameters
    ----------
    name: str
    version: Optional[str]

    """

    name: str = Field(
        ...,
        description="A filter on the list based on the key `app_name`. The filter is on the full name only. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="motor-speed-control",
        max_length=64,
        min_length=1,
    )
    version: Optional[str] = Field(
        None,
        description="A filter on the list based on the key `app_version`. The filter is on the full name only. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="1.2.0",
        max_length=64,
    )


class ParameterName(BaseModelRoot[str]):
    """
    ParameterName object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class ResourceParametersList(DataModelBase):
    """
    ResourceParametersList object.

    Parameters
    ----------
    apps: Optional[List[ParameterAppVersion]]
    resources: Optional[List[Resource]]
    parameter_names: Optional[List[ParameterName]]
    start_date: Optional[datetime]
    end_date: Optional[datetime]

    """

    apps: Optional[List[ParameterAppVersion]] = Field(
        None,
        description="A filter on the list for Apps and its Versions. Multiple Apps and Versions can be given. All App Versions in the array are treated as `OR`.",
    )
    resources: Optional[List[Resource]] = Field(
        None,
        description="A filter on the list showing only current Parameter values associated with any Assets in the array. The filter is on the full name only. All strings in the array are treated as `OR`. Each Asset name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:asset:bp_16", "krn:asset:bp_21"],
    )
    parameter_names: Optional[List[ParameterName]] = Field(
        None,
        description="A filter on the list for Parameters. The filter is on the full name only. All strings in the array are treated as `OR`. Each Parameter name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["motor-speed-control", "gas_flow_rate_max_threshold"],
    )
    start_date: Optional[datetime] = Field(
        None,
        description="Earliest `created` time for the list of Parameters. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2024-02-06T00:00:00.000000Z",
    )
    end_date: Optional[datetime] = Field(
        None,
        description="Most recent `created` time for the list of Parameters. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2024-02-07T00:00:00.000000Z",
    )


class LastParametersResourcesGet(DataModelBase):
    """
    LastParametersResourcesGet object.

    Parameters
    ----------
    apps: Optional[List[ParameterAppVersion]]
    resources: Optional[List[Resource]]
    parameter_names: Optional[List[ParameterName]]

    """

    apps: Optional[List[ParameterAppVersion]] = Field(
        None,
        description="A filter on the list for Apps and its Versions. Multiple Apps and Versions can be given. All App Versions in the array are treated as `OR`.",
    )
    resources: Optional[List[Resource]] = Field(
        None,
        description="A filter on the list showing only current Parameter values associated with any Assets in the array. The filter is on the full name only. All strings in the array are treated as `OR`. Each Asset name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:asset:bp_16", "krn:asset:bp_21"],
    )
    parameter_names: Optional[List[ParameterName]] = Field(
        None,
        description="A filter on the list for Parameters. The filter is on the full name only. All strings in the array are treated as `OR`. Each Parameter name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["motor-speed-control", "gas_flow_rate_max_threshold"],
    )


class Parameter(BaseModelRoot[str]):
    """
    Parameter object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class AppParameter(DataModelBase):
    """
    AppParameter object.

    Parameters
    ----------
    app_name: str
    parameters: Optional[List[Parameter]]

    """

    app_name: str = Field(
        ...,
        description="A filter on the list based on the key `app_name`. The filter is on the full name only. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="motor-speed-control",
        max_length=64,
        min_length=1,
    )
    parameters: Optional[List[Parameter]] = Field(
        None,
        description="Array of Parameter `names` to fetch associated values for Apps.",
        example=["gas_flow_rate_min_threshold", "gas_flow_rate_max_threshold"],
    )


class ParametersValuesGet(DataModelBase):
    """
    ParametersValuesGet object.

    Parameters
    ----------
    app_parameters: Optional[List[AppParameter]]
    primitive_types: Optional[List[enum.ParameterType]]

    """

    app_parameters: Optional[List[AppParameter]] = Field(
        None,
        description="Filter on the list based on the key `app_name` and wanted Parameter `name` per App. The filter is on the full name only. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
    )
    primitive_types: Optional[List[enum.ParameterType]] = Field(
        None,
        description="Filter on the list based on the Parameter data type key `primitive_type` of the Parameter.",
        example=["number", "boolean"],
    )


class ResourceName(BaseModelRoot[str]):
    """
    ResourceName object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=256, min_length=1)

    """

    __root__: str = Field(..., max_length=256, min_length=1)


class TypeModel1(BaseModelRoot[str]):
    """
    TypeModel1 object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=64, min_length=1)

    """

    __root__: str = Field(..., max_length=64, min_length=1)


class RecommendationClusteringGet(DataModelBase):
    """
    RecommendationClusteringGet object.

    Parameters
    ----------
    end_date: datetime
    resource_names: Optional[List[ResourceName]]
    sources: Optional[List[Source]]
    start_date: datetime
    states: Optional[List[enum.RecommendationState]]
    time_bucket: str
    types: Optional[List[TypeModel1]]

    """

    end_date: datetime = Field(
        ...,
        description="Most recent (end) creation time for counting the number of Recommendations. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2023-11-18T18:22:18.582724Z",
    )
    resource_names: Optional[List[ResourceName]] = Field(
        None,
        description="Filter Assets (`resources`) linked to Recommendations for inclusion in the count. The filter is on the full name only. All strings in the array are treated as `OR`. Each Asset name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:asset:bp_02", "krn:asset:bp_16"],
    )
    sources: Optional[List[Source]] = Field(
        None,
        description="A filter to only count Recommendations from certain `sources`. The filter is on the full name only. All strings in the array are treated as `OR`. Each KRN name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:app:motor-speed-control"],
    )
    start_date: datetime = Field(
        ...,
        description="Earliest (start) creation time for counting the  number of Recommendations. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2023-11-18T18:22:18.582724Z",
    )
    states: Optional[List[enum.RecommendationState]] = Field(
        None,
        description="A filter to only count Recommendations associated with one or more `states`. The filter is on the full `state` name only. All strings in the array are treated as `OR`.",
        example=["accepted", "applied"],
    )
    time_bucket: str = Field(
        ..., description="Defines the time range to use to group and count the Recommendations.", example="5m"
    )
    types: Optional[List[TypeModel1]] = Field(
        None,
        description="A filter to only count Recommendations associated with one or more `types`. The filter is on the full `state` name only. All strings in the array are treated as `OR`.",
        example=["decrease_speed", "increase_speed"],
    )


class RecommendationCreate(DataModelBase):
    """
    RecommendationCreate object.

    Parameters
    ----------
    actions: Optional[type.RecommendationActions]
    confidence: Optional[int]
    custom_identifier: Optional[str]
    description: Optional[str]
    expiration_date: Optional[datetime]
    metadata: Optional[Dict[str, Any]]
    resource: str
    resource_parameters: Optional[Dict[str, Any]]
    source: str
    state: Optional[enum.RecommendationState]
    type: str

    """

    actions: Optional[type.RecommendationActions] = None
    confidence: Optional[int] = Field(
        None,
        description="Confidence level of the Recommendation. This is usually, but not mandatory, related to any machine learning model confidence results.",
        example=7,
        ge=-2147483648,
        le=2147483647,
    )
    custom_identifier: Optional[str] = Field(
        None, description="An optional custom identifier for any purpose.", example="model-aws-ltsm-anomaly"
    )
    description: Optional[str] = Field(
        None,
        description="Detailed description of the Recommendation.",
        example="Beam pump speed AI optimizer application recommends a new value for the speed setpoint of the controller.",
    )
    expiration_date: Optional[datetime] = Field(
        None,
        description="UTC time when the Recommendation will expire and the `status` automatically marked as `expired`, formatted in RFC 3339. The operator will not be able to take any further actions on this Recommendation. If no date is given, then the Recommendation will never expire.",
        example="2023-11-18T18:22:18.582724Z",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description="Custom dictionary keys/values for use by clients for anything useful and related to the Recommendation.",
    )
    resource: str = Field(
        ...,
        description="The Asset that this Recommendation is related to.",
        example="krn:asset:bp_16",
        max_length=256,
        min_length=1,
    )
    resource_parameters: Optional[Dict[str, Any]] = Field(None, description="resource_parameters")
    source: str = Field(
        ...,
        description="The process that created or last updated this Recommendation. This can be a user or an automated process like a workload, application, etc.",
        example="krn:wlappv:cluster1/app1/1.2.0",
        max_length=256,
        min_length=1,
    )
    state: Optional[enum.RecommendationState] = Field(None, description="Current `state` of the Recommendation.")
    type: str = Field(
        ...,
        description="The Recommendation Type `name` associated with the Recommendation.",
        example="decrease_speed",
        max_length=64,
        min_length=1,
    )


class RecommendationLastGet(DataModelBase):
    """
    RecommendationLastGet object.

    Parameters
    ----------
    resources: List[Resource]
    sources: Optional[List[Source]]
    states: Optional[List[enum.RecommendationState]]
    types: Optional[List[TypeModel1]]

    """

    resources: List[Resource] = Field(
        ...,
        description="A filter on the list to show Last Recommendation for requested Assets only. The filter is on the full name only. All strings in the array are treated as `OR`. Each Asset name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:asset:bp_02", "krn:asset:bp_16"],
    )
    sources: Optional[List[Source]] = Field(
        None,
        description="A filter on the list showing only Data Streams associated with any workloads in the array. The filter is on the full name only. All strings in the array are treated as `OR`. Each Workload name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:app:motor-speed-control"],
    )
    states: Optional[List[enum.RecommendationState]] = Field(
        None,
        description="A filter on the list showing only Recommendations associated with one or more `states`. The filter is on the full `state` name only. All strings in the array are treated as `OR`.",
        example=["accepted", "applied"],
    )
    types: Optional[List[TypeModel1]] = Field(
        None,
        description="A filter on the list showing only Recommendations associated with one or more `types`. The filter is on the full `types` name only. All strings in the array are treated as `OR`.",
        example=["decrease_speed", "increase_speed"],
    )


class RecommendationsList(DataModelBase):
    """
    RecommendationsList object.

    Parameters
    ----------
    ids: Optional[List[UUID]]
    resources: Optional[List[Resource]]
    sources: Optional[List[Source]]
    states: Optional[List[enum.RecommendationState]]
    types: Optional[List[TypeModel1]]

    """

    ids: Optional[List[UUID]] = Field(
        None,
        description="Search and filter on the list based on the key `id`. The filter is on the full UUID `id` only. All strings in the array are treated as `OR`.",
        example=["0002bc79-b42f-461b-95d6-cf0a28ba87aa", "00080f9e-d086-452d-b41d-c8aa8fb27c92"],
    )
    resources: Optional[List[Resource]] = Field(
        None,
        description="A filter on the list showing only Recommendations associated with any Assets in the array. The filter is on the full KRN Asset name only. All strings in the array are treated as `OR`. Each Asset name must be in the KRN format.",
        example=["krn:asset:bp_16", "krn:asset:bp_21"],
    )
    sources: Optional[List[Source]] = Field(
        None,
        description="A filter on the list showing only Recommendations created by a certain source. The filter is on the full `source` KRN name only. All strings in the array are treated as `OR`. This does not include the `sources` in the logs of a Recommendation.",
        example=["krn:wlappv:cluster1/app1/1.2.0", "krn:user:richard.teo@kelvininc.com"],
    )
    states: Optional[List[enum.RecommendationState]] = Field(
        None,
        description="A filter on the list showing only Recommendations associated with one or more `states`. The filter is on the full `state` name only. All strings in the array are treated as `OR`.",
        example=["accepted", "applied"],
    )
    types: Optional[List[TypeModel1]] = Field(
        None,
        description="A filter on the list showing only Recommendations associated with one or more Recommendation Types. The filter is on the full Recommendation Type `name` only. All strings in the array are treated as `OR`. Each name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["decrease_speed", "increase_speed"],
    )


class RecommendationRangeGet(DataModelBase):
    """
    RecommendationRangeGet object.

    Parameters
    ----------
    end_date: datetime
    resources: List[Resource]
    sources: Optional[List[Source]]
    start_date: datetime
    states: Optional[List[enum.RecommendationState]]
    types: Optional[List[TypeModel1]]

    """

    end_date: datetime = Field(
        ...,
        description="Most recent (end) creation time for the list of Recommendations. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2023-11-18T18:22:18.582724Z",
    )
    resources: List[Resource] = Field(
        ...,
        description="A filter on the list to show Range of Recommendations for requested Assets only. The filter is on the full name only. All strings in the array are treated as `OR`. Each Asset name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:asset:bp_02", "krn:asset:bp_16"],
    )
    sources: Optional[List[Source]] = Field(
        None,
        description="A filter on the list showing only Recommendations coming from certain `sources`. The filter is on the full name only. All strings in the array are treated as `OR`. Each Workload name can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example=["krn:app:motor-speed-control"],
    )
    start_date: datetime = Field(
        ...,
        description="Earliest (start) creation time for the list of Recommendations. Time is based on UTC timezone, formatted in RFC 3339.",
        example="2023-11-18T18:22:18.582724Z",
    )
    states: Optional[List[enum.RecommendationState]] = Field(
        None,
        description="A filter on the list showing only Range of Recommendations associated with one or more `states`. The filter is on the full `state` name only. All strings in the array are treated as `OR`.",
        example=["accepted", "applied"],
    )
    types: Optional[List[TypeModel1]] = Field(
        None,
        description="A filter on the list showing only Recommendations associated with one or more `types`. The filter is on the full `state` name only. All strings in the array are treated as `OR`.",
        example=["decrease_speed", "increase_speed"],
    )


class RecommendationTypeCreate(DataModelBase):
    """
    RecommendationTypeCreate object.

    Parameters
    ----------
    description: Optional[str]
    name: str
    title: str

    """

    description: Optional[str] = Field(
        None,
        description="Full description of the purpose for this Recommendation Type.",
        example="Recommendations that require a reduction in the speed set point.",
    )
    name: str = Field(
        ...,
        description="Recommendation Type key `name` to create. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="decrease_speed",
        max_length=64,
        min_length=1,
    )
    title: str = Field(
        ...,
        description="Display name (`title`) of the Asset Type.",
        example="Decrease Speed",
        max_length=64,
        min_length=1,
    )


class RecommendationTypeUpdate(DataModelBase):
    """
    RecommendationTypeUpdate object.

    Parameters
    ----------
    description: Optional[str]
    title: Optional[str]

    """

    description: Optional[str] = Field(
        None,
        description="New fFull description of the purpose for this Recommendation Type.",
        example="Recommendations that require a reduction in the speed set point.",
    )
    title: Optional[str] = Field(
        None,
        description="New display name (`title`) of the Recommendation Type.",
        example="Decrease Speed",
        max_length=64,
        min_length=1,
    )


class RecommendationAcceptUpdate(DataModelBase):
    """
    RecommendationAcceptUpdate object.

    Parameters
    ----------
    confidence: Optional[int]
    message: Optional[str]

    """

    confidence: Optional[int] = Field(
        None,
        description="Confidence level of the decision to accept the Recommendation. This is usually, but not mandatory, related to any machine learning model confidence results.",
        example=7,
        ge=-2147483648,
        le=2147483647,
    )
    message: Optional[str] = Field(
        None,
        description="Contains a message with any descriptions useful to be associated with the `accepted` state. This will be recorded in logs of the actual Recommendation.",
        example="Recommendation is accurate based on the current performance.",
    )


class RecommendationLogCreate(DataModelBase):
    """
    RecommendationLogCreate object.

    Parameters
    ----------
    message: Optional[str]

    """

    message: Optional[str] = Field(
        None,
        description="Contains a message with any descriptions useful to be recorded in logs of the actual Recommendation.",
        example="Need more time to assess Recommendation data before making a decision.",
    )


class RecommendationRejectUpdate(DataModelBase):
    """
    RecommendationRejectUpdate object.

    Parameters
    ----------
    confidence: Optional[int]
    message: Optional[str]

    """

    confidence: Optional[int] = Field(
        None,
        description="Confidence level of the decision to reject the Recommendation. This is usually, but not mandatory, related to any machine learning model confidence results.",
        example=7,
        ge=-2147483648,
        le=2147483647,
    )
    message: Optional[str] = Field(
        None,
        description="Contains a message with any descriptions useful to be associated with the `reject` state. This will be recorded in logs of the actual Recommendation.",
        example="Recommendation is not accurate based on the current performance.",
    )


class SecretCreate(DataModelBase):
    """
    SecretCreate object.

    Parameters
    ----------
    name: str
    value: str

    """

    name: str = Field(
        ...,
        description="Unique identifier `name` for the Secret. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="my_secret_password",
        max_length=32,
        min_length=1,
    )
    value: str = Field(
        ...,
        description="The actual secret. Once this is set you can not change or see it from Kelvin API. Retrieval of the value can only be done through an App.",
        example="Nh9Noq%QWNaJim%uAe9r",
        max_length=64000,
        min_length=1,
    )


class ThreadCreate(DataModelBase):
    """
    ThreadCreate object.

    Parameters
    ----------
    body: str
    file: Optional[bytes]

    """

    body: str = Field(..., description="requests.ThreadCreate schema")
    file: Optional[bytes] = Field(None, description="Attachment")


class ThreadReplyCreate(DataModelBase):
    """
    ThreadReplyCreate object.

    Parameters
    ----------
    body: str
    file: Optional[bytes]

    """

    body: str = Field(..., description="requests.ThreadReplyCreate schema")
    file: Optional[bytes] = Field(None, description="Attachment")


class ThreadReplyUpdate(DataModelBase):
    """
    ThreadReplyUpdate object.

    Parameters
    ----------
    body: str
    file: Optional[bytes]

    """

    body: str = Field(..., description="requests.ThreadReplyUpdate schema")
    file: Optional[bytes] = Field(None, description="Attachment")


class ThreadUpdate(DataModelBase):
    """
    ThreadUpdate object.

    Parameters
    ----------
    body: str
    file: Optional[bytes]

    """

    body: str = Field(..., description="requests.ThreadUpdate schema")
    file: Optional[bytes] = Field(None, description="Attachment")


class TimeseriesCreate(DataModelBase):
    """
    TimeseriesCreate object.

    Parameters
    ----------
    data: List[type.KelvinMessage]

    """

    data: List[type.KelvinMessage] = Field(..., description="Array of new time series data objects to create.")


class Selector(DataModelBase):
    """
    Selector object.

    Parameters
    ----------
    fields: Optional[List[str]]
    resource: str

    """

    fields: Optional[List[str]] = Field(
        None,
        description="A filter on the list based on the `field` element names. Blank array will return all data field element names and associated values.",
    )
    resource: str = Field(
        ...,
        description="Specifies the resource (Asset / Data Stream pair) from which field/values are returned.",
        example="krn:ad:asset1/data_stream1",
        max_length=256,
        min_length=1,
    )


class TimeseriesLastGet(DataModelBase):
    """
    TimeseriesLastGet object.

    Parameters
    ----------
    selectors: Optional[List[Selector]]

    """

    selectors: Optional[List[Selector]] = Field(
        None,
        description="Array specifying resources and their optional field element names to filter the returned list.",
    )


class ResourceItem(BaseModelRoot[str]):
    """
    ResourceItem object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=256, min_length=1)

    """

    __root__: str = Field(..., max_length=256, min_length=1)


class SourceItem(BaseModelRoot[str]):
    """
    SourceItem object.

    Parameters
    ----------
    __root__: str = Field(..., max_length=256, min_length=1)

    """

    __root__: str = Field(..., max_length=256, min_length=1)


class TimeseriesList(DataModelBase):
    """
    TimeseriesList object.

    Parameters
    ----------
    resource: Optional[List[ResourceItem]]
    source: Optional[List[SourceItem]]

    """

    resource: Optional[List[ResourceItem]] = Field(
        None,
        description="Only return data from the Asset / DataStream pairs specified. Blank array will return all pairs. Resources are written in the krn format.",
        example=["krn:ad:asset1/data_stream1", "krn:ad:asset1/data_stream2"],
    )
    source: Optional[List[SourceItem]] = Field(
        None,
        description="Only return data from the user and/or workloads specified. Blank array will return from all sources. Sources are written in the krn format.",
        example=[
            "krn:user:person@example.com",
            "krn:wl:my-node/temp-adjuster-1",
            "krn:wlappv:my-node/pvc-r312:pvc/1.0.0",
        ],
    )


class AggModel(Enum):
    none = "none"
    count = "count"
    distinct = "distinct"
    integral = "integral"
    mean = "mean"
    median = "median"
    mode = "mode"
    spread = "spread"
    stddev = "stddev"
    sum = "sum"
    max = "max"
    min = "min"
    first = "first"
    last = "last"


class Fill(Enum):
    none = "none"
    linear = "linear"
    previous = "previous"
    fixed_integer_value = "fixed integer value"


class Order(Enum):
    ASC = "ASC"
    DESC = "DESC"


class TimeseriesRangeGet(DataModelBase):
    """
    TimeseriesRangeGet object.

    Parameters
    ----------
    agg: Optional[AggModel]
    end_time: datetime
    fill: Optional[Fill]
    group_by_selector: Optional[bool]
    order: Optional[Order]
    selectors: List[Selector]
    start_time: datetime
    time_bucket: Optional[str]
    time_shift: Optional[str]

    """

    agg: Optional[AggModel] = Field(
        "none",
        description="Performs mathematical calculations on the Time Series values and returns the calculated results only. Depending on enumerator used `time_bucket` may also be required.",
        example="mean",
    )
    end_time: datetime = Field(
        ...,
        description="UTC time for the latest time in the Time Series, formatted in RFC 3339.",
        example="2023-06-01T12:00:00Z",
    )
    fill: Optional[Fill] = Field(
        "none",
        description="Fills any group of data with a calculated value when there is no data. `fixed integer value` is any integer value. `linear` will perform a linear regression to calculate value.",
        example="25",
    )
    group_by_selector: Optional[bool] = Field(
        True,
        description="If true, results will be separated per `selector` element `resource` (Asset / Data Stream pair).",
        example=True,
    )
    order: Optional[Order] = Field(
        "ASC",
        description="Sort order of the `timestamp` key for the returned data. This string is case sensitive.",
        example="ASC",
    )
    selectors: List[Selector] = Field(
        ...,
        description="An array of `resources` and corresponding data `field` element name to filter on the list and optional `agg` calculations.",
    )
    start_time: datetime = Field(
        ...,
        description="UTC time for the earliest time in the Time Series, formatted in RFC 3339.",
        example="2023-06-01T12:00:00Z",
    )
    time_bucket: Optional[str] = Field(
        None,
        description='Defines the time range to use to aggregate the data values when using the `agg` key. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".',
        example="5m",
    )
    time_shift: Optional[str] = Field(
        None,
        description='Shift initial starting point of time buckets from the standard epoch for `time_bucket`. Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h".',
        example="1h",
    )


class TimeseriesRangeDownload(TimeseriesRangeGet):
    """
    TimeseriesRangeDownload object.

    Parameters
    ----------

    """


class UserSettingsUpdate(DataModelBase):
    """
    UserSettingsUpdate object.

    Parameters
    ----------
    payload: Optional[Dict[str, Any]]

    """

    payload: Optional[Dict[str, Any]] = Field(
        None,
        description="The new payload for the User Setting. The structure of this `payload` object depends on the type of User Setting being updated.",
    )


class WorkloadDeploy(DataModelBase):
    """
    WorkloadDeploy object.

    Parameters
    ----------
    acp_name: Optional[str]
    app_name: str
    app_version: Optional[str]
    cluster_name: Optional[str]
    instantly_apply: Optional[bool]
    name: Optional[str]
    payload: Optional[Dict[str, Any]]
    pre_download: Optional[bool]
    source: Optional[str]
    title: Optional[str]

    """

    acp_name: Optional[str] = Field(
        None,
        description="[`Deprecated`] Target Cluster Name (`acp_name`) for Workload deployment. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="docs-demo-cluster-k3s",
        max_length=64,
        min_length=1,
    )
    app_name: str = Field(
        ...,
        description="App Name from App Registry to use for Workload deployment. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters.",
        example="motor-speed-control",
        max_length=64,
        min_length=1,
    )
    app_version: Optional[str] = Field(
        None, description="Version of the App to use.", example="1.2.0", max_length=64, min_length=1
    )
    cluster_name: Optional[str] = Field(
        None,
        description="Target Cluster Name for Workload deployment. The string can only contain lowercase alphanumeric characters and `.`, `_` or `-` characters. If set, it will override acp_name",
        example="docs-demo-cluster-k3s",
        max_length=64,
        min_length=1,
    )
    instantly_apply: Optional[bool] = Field(
        None,
        description="If true, applies deploy/upgrade immediately. If false, user will need to send an additional API request `/workloads/{workload_name}/apply` to initate the deploy/upgrade.",
        example=True,
    )
    name: Optional[str] = Field(
        None,
        description="Unique identifier `name` of the Workload.",
        example="motor-speed-control-ubdhwnshdy67",
        max_length=32,
        min_length=1,
    )
    payload: Optional[Dict[str, Any]] = Field(
        None,
        description="All parameters associated with the Kelvin App like Inputs, Outputs, Info, Spec Version and System.",
    )
    pre_download: Optional[bool] = Field(
        None,
        description="If true, deploy process is handled by Kelvin and all Workloads wil be downloaded to Edge System before deploy. If false, deploy process is handled by Kubernetes through default settings.",
        example=True,
    )
    source: Optional[str] = Field(
        None,
        description="Who or which process initiated the Workload deploy.",
        example="krn:user:richard.teo@kelvininc.com",
        max_length=256,
        min_length=1,
    )
    title: Optional[str] = Field(
        None,
        description="Display name (`title`) of the Workload.",
        example="Motor Speed Control",
        max_length=64,
        min_length=1,
    )


class WorkloadConfigurationUpdate(DataModelBase):
    """
    WorkloadConfigurationUpdate object.

    Parameters
    ----------
    configuration: Optional[Dict[str, Any]]

    """

    configuration: Optional[Dict[str, Any]] = None
