"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie.types import BaseModel
from mollie.utils import FieldMetadata, HeaderMetadata, RequestMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RequestApplePayPaymentSessionRequestBodyTypedDict(TypedDict):
    validation_url: str
    r"""The validationUrl you got from the
    [ApplePayValidateMerchant event](https://developer.apple.com/documentation/apple_pay_on_the_web/applepayvalidatemerchantevent).

    A list of all
    [valid host names](https://developer.apple.com/documentation/apple_pay_on_the_web/setting_up_your_server)
    for merchant validation is available. You should white list these in your application and reject any
    `validationUrl`s that have a host name not in the list.
    """
    domain: str
    r"""The domain of your web shop, that is visible in the browser's location bar. For example
    `pay.myshop.com`.
    """
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """


class RequestApplePayPaymentSessionRequestBody(BaseModel):
    validation_url: Annotated[str, pydantic.Field(alias="validationUrl")]
    r"""The validationUrl you got from the
    [ApplePayValidateMerchant event](https://developer.apple.com/documentation/apple_pay_on_the_web/applepayvalidatemerchantevent).

    A list of all
    [valid host names](https://developer.apple.com/documentation/apple_pay_on_the_web/setting_up_your_server)
    for merchant validation is available. You should white list these in your application and reject any
    `validationUrl`s that have a host name not in the list.
    """

    domain: str
    r"""The domain of your web shop, that is visible in the browser's location bar. For example
    `pay.myshop.com`.
    """

    profile_id: Annotated[Optional[str], pydantic.Field(alias="profileId")] = None
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """


class RequestApplePayPaymentSessionRequestTypedDict(TypedDict):
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""
    request_body: NotRequired[RequestApplePayPaymentSessionRequestBodyTypedDict]


class RequestApplePayPaymentSessionRequest(BaseModel):
    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""

    request_body: Annotated[
        Optional[RequestApplePayPaymentSessionRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
