import numpy as np
from PIL import Image
from torch.utils.data import Dataset

class SorelSmallDataset(Dataset):
    def __init__(self, files, labels, image_resolution=32):
        self.files = files
        self.labels = labels
        self.image_res = image_resolution

    def __len__(self):
        return len(self.files)

    def __getitem__(self, idx):
        if self.image_res != 32:
            image = Image.open(self.files[idx]).resize((self.image_res, self.image_res))
        else:
            image = Image.open(self.files[idx])
        # make the image into a 3 channel image in numpy array
        image = np.array(image).reshape(1, image.size[0], image.size[1]).astype('float32')
        return image, np.argmax(self.labels[idx])