import numpy as np
from torch.utils.data import DataLoader, TensorDataset
from torch import Tensor
from sklearn.model_selection import train_test_split
import torch
from os import listdir
import os
import logging
from PIL import Image
from os.path import isfile, join


# Note this method enforces train/test/validation splits
def advnet_lisacnn(
        path_to_dataset: str = '',
        batch_size: int = 128,
        signs=None,
        split=None,
        image_resolution=None,
        datasets=None
):
    if split is None:
        split = [70, 20, 10]
    if signs is None:
        signs = ['Speed35Signs', 'StopSigns', 'YieldSigns']
    if path_to_dataset == '':
        raise Exception("path_to_dataset must be specified")
    if len(signs) > 3 or len(signs) < 1:
        raise Exception("signs must be a list of length 1-3")
    path_to_dataset = path_to_dataset + '/AdvNet - LisaCnn'
    labels = ['Adv', 'Clean']
    loaders = {
        'image_resolution': 32,
        'batch_size': batch_size,
        'labels': labels,
        'input_channels': 3
    }
    logging.info('--- BEGIN LOADING DATASET ---')
    features = []
    full_labels = []
    for index, sign in enumerate(signs):
        logging.info(f'LOADING SIGN: {index + 1} OF {len(signs)}')
        for label_index, label in enumerate(labels):
            path = path_to_dataset + f'/{sign}/{label}'
            files_full = []
            for path, subdirs, files in os.walk(path):
                files = [f for f in listdir(path) if isfile(join(path, f))]
                for name in files:
                    if isfile(os.path.join(path, name)) and not name.startswith('.'):
                        files_full.append(os.path.join(path, name))
            for file in files_full:
                img = Image.open(file).convert('RGB')
                img = img.resize((32, 32), Image.ANTIALIAS)
                img = np.asarray(img)
                features.append(img)
                full_labels.append(label_index)
    logging.info(f'--- DATASET LOADING COMPLETE ---')
    logging.info(f'--- BEGIN DATASET PREPROCESSING ---')
    features = np.asarray([feature for feature in features])
    full_labels = np.array([label for label in full_labels])
    train_features = features[:int(len(features) * (split[0] / 100))]
    train_labels = full_labels[:int(len(full_labels) * (split[0] / 100))]
    test_features = features[int(len(features) * (split[0] / 100)):int(len(features) * ((split[0] + split[1]) / 100))]
    test_labels = full_labels[
                  int(len(full_labels) * (split[0] / 100)):int(len(full_labels) * ((split[0] + split[1]) / 100))]
    val_features = features[int(len(features) * ((split[0] + split[1]) / 100)):]
    val_labels = full_labels[int(len(full_labels) * ((split[0] + split[1]) / 100)):]

    idx = np.random.choice(len(train_features), len(train_features))
    train_features = train_features[idx]
    train_labels = train_labels[idx]

    idx = np.random.choice(len(test_features), len(test_features))
    test_features = test_features[idx]
    test_labels = test_labels[idx]

    idx = np.random.choice(len(val_features), len(val_features))
    val_features = val_features[idx]
    val_labels = val_labels[idx]

    # reshape
    train_labels = train_labels.reshape(len(train_labels), 1)
    test_labels = test_labels.reshape(len(test_labels), 1)
    val_labels = val_labels.reshape(len(val_labels), 1)

    train_features = train_features.reshape(len(train_features), 3, 32, 32)
    test_features = test_features.reshape(len(test_features), 3, 32, 32)
    val_features = val_features.reshape(len(val_features), 3, 32, 32)

    new_train_labels = np.zeros((len(train_features), len(labels)))
    # Set the labels value to the index of the classes
    for ind, val in enumerate(train_labels):
        tmp = np.zeros(len(labels))
        tmp[val] = 1
        new_train_labels[ind] = tmp
    train_labels = new_train_labels

    new_test_labels = np.zeros((len(test_features), len(labels)))
    # Set the labels value to the index of the classes
    for ind, val in enumerate(test_labels):
        tmp = np.zeros(len(labels))
        tmp[val] = 1
        new_test_labels[ind] = tmp
    test_labels = new_test_labels

    new_val_labels = np.zeros((len(val_features), len(labels)))
    # Set the labels value to the index of the classes
    for ind, val in enumerate(val_labels):
        tmp = np.zeros(len(labels))
        tmp[val] = 1
        new_val_labels[ind] = tmp
    val_labels = new_val_labels

    loaders['train'] = DataLoader(TensorDataset(Tensor(train_features), torch.argmax(Tensor(train_labels), dim=1)),
                                  batch_size=batch_size)
    loaders['test'] = DataLoader(TensorDataset(Tensor(test_features), torch.argmax(Tensor(test_labels), dim=1)),
                                 batch_size=batch_size)
    loaders['val'] = DataLoader(TensorDataset(Tensor(val_features), torch.argmax(Tensor(val_labels), dim=1)),
                                batch_size=batch_size)
    logging.info(f'--- DATASET PREPROCESSING COMPLETE ---')
    return loaders
