import numpy as np
from torch.utils.data import DataLoader, TensorDataset
from torch import Tensor
from sklearn.model_selection import train_test_split
import torch
from os import listdir
import random
from SorelSmallDataset import SorelSmallDataset
import os
import logging
from PIL import Image
from os.path import isfile, join


def sorel_small(path_to_dataset: str = '/home/cornelius/dev/datasets/',
                batch_size: int = 128,
                image_resolution: int = 32,
                datasets=None,
                split=None,
                batch_loading: bool = False):
    # Validate that the parameters are within bounds
    if datasets is None:
        datasets = ['train', 'val']
    if path_to_dataset == '':
        raise Exception("path_to_dataset must be specified")
    if len(datasets) > 3 or len(datasets) < 1:
        raise Exception("datasets must be a list of length 1-3")
    if not np.in1d(datasets, ['train', 'val', 'test']).all():
        raise Exception("datasets must be a list of 'train', 'val', and/or 'test'")

    # Set the split ratio
    if split is None:
        split = [0.7, 0.15, 0.15]

    # specify the known expected sample count for the dataset
    # expected_sample_count = {'train': 61201, 'val': 8743, 'test': 17486}

    # specify the known labels of the dataset
    labels = ['adware', 'crypto_miner',
              'downloader', 'file_infector',
              'flooder', 'installer',
              'spyware', 'worm',
              'ransomware', 'dropper', 'packed']
    loaders = {
        'image_resolution': image_resolution,
        'batch_size': batch_size,
        # 'expected_sample_count': expected_sample_count,
        'labels': labels,
        'input_channels': 1
    }
    if not batch_loading:
        path_to_dataset = path_to_dataset + '/sorel_small'
        logging.info('--- BEGIN LOADING DATASET ---')
        features = []
        full_labels = []
        for index, label in enumerate(labels):
            logging.info(f'LOADING CLASS {index + 1} OF {len(labels)}')
            path = path_to_dataset + f'/{label}'
            files = [f for f in listdir(path) if isfile(join(path, f))]
            files_full = []
            for path, subdirs, files in os.walk(path):
                files = [f for f in listdir(path) if isfile(join(path, f))]
                for name in files:
                    if isfile(os.path.join(path, name)) and not name.startswith('.'):
                        files_full.append(os.path.join(path, name))
            images = [Image.open(f).convert('L') for f in files_full]
            images = [img.resize((image_resolution, image_resolution)) for img in images]
            images_np = [np.asarray(img) for img in images]
            features.extend(images_np)
            full_labels.extend([index for i in range(len(images_np))])
        # Resize the data and check that the samples are in the correct size
        logging.info(f'--- CLASS LOADING COMPLETE ---')
        logging.info(f'--- BEGIN DATASET PREPROCESSING ---')
        features = np.asarray([feature for feature in features])
        full_labels = np.array([label for label in full_labels])
        # Shuffles the dataset
        np.random.seed(10)
        idx = np.random.choice(len(full_labels), len(full_labels))
        full_labels = full_labels[idx]
        features = features[idx]
        # if len(full_labels) != expected_sample_count[set]:
        #     raise Exception(f"Expected {expected_sample_count[set]} samples in dataset, but got {len(full_labels)}")
        full_labels = full_labels.reshape((len(full_labels), 1))
        X_train = features.reshape((len(features), 1, image_resolution, image_resolution))
        new_y_train = np.zeros((len(X_train), len(labels)))
        # Set the labels value to the index of the classes
        for ind, val in enumerate(full_labels):
            tmp = np.zeros(len(labels))
            tmp[val] = 1
            new_y_train[ind] = tmp
        Y_train = new_y_train
        # make three dataloaders with the train, val, and test sets
        train_split_size = split[0]
        val_split_size = split[1]
        test_split_size = split[2]
        # get the first split size of data and put into an array
        x_train = X_train[:int(train_split_size * len(X_train))]
        y_train = Y_train[:int(train_split_size * len(Y_train))]
        # get the second split size of data and put into an array
        x_val = X_train[int(train_split_size * len(X_train)):int((train_split_size + val_split_size) * len(X_train))]
        y_val = Y_train[int(train_split_size * len(Y_train)):int((train_split_size + val_split_size) * len(Y_train))]
        # get the third split size of data and put into an array
        x_test = X_train[int((train_split_size + val_split_size) * len(X_train)):]
        y_test = Y_train[int((train_split_size + val_split_size) * len(Y_train)):]
        # create the loaders dictionary
        if 'train' in datasets:
            loaders['train'] = DataLoader(TensorDataset(Tensor(x_train), torch.argmax(Tensor(y_train), dim=1)),
                                          batch_size=batch_size)
        if 'val' in datasets:
            loaders['val'] = DataLoader(TensorDataset(Tensor(x_val), torch.argmax(Tensor(y_val), dim=1)),
                                        batch_size=batch_size)
        if 'test' in datasets:
            loaders['test'] = DataLoader(TensorDataset(Tensor(x_test), torch.argmax(Tensor(y_test), dim=1)),
                                         batch_size=batch_size)
        logging.info(f'--- DATASET PREPROCESSING COMPLETE ---')
        return loaders
    else:
        # Load the images from the disk on each batch
        path_to_dataset = path_to_dataset + '/sorel_small'
        logging.info('--- BEGIN LOADING DATASET ---')
        features = []
        full_labels = []
        all_files = []
        for index, label in enumerate(labels):
            logging.info(f'LOADING CLASS {index + 1} OF {len(labels)}')
            path = path_to_dataset + f'/{label}'
            files = [f for f in listdir(path) if isfile(join(path, f))]
            files_full = []
            for path, subdirs, files in os.walk(path):
                files = [f for f in listdir(path) if isfile(join(path, f))]
                for name in files:
                    if isfile(os.path.join(path, name)) and not name.startswith('.'):
                        files_full.append(os.path.join(path, name))
            full_labels.extend([index for i in range(len(files_full))])
            all_files.extend(files_full)
        # Shuffles the dataset
        full_labels = np.array([label for label in full_labels])
        all_files = np.array([file for file in all_files])
        np.random.seed(10)
        idx = np.random.choice(len(full_labels), len(full_labels))
        full_labels = full_labels[idx]
        all_files = all_files[idx]
        train_split_size = split[0]
        val_split_size = split[1]
        test_split_size = split[2]
        # get the first split size of data and put into an array
        x_train = all_files[:int(train_split_size * len(all_files))]
        y_train = full_labels[:int(train_split_size * len(full_labels))]
        # get the second split size of data and put into an array
        x_val = all_files[
                int(train_split_size * len(all_files)):int((train_split_size + val_split_size) * len(all_files))]
        y_val = full_labels[
                int(train_split_size * len(full_labels)):int((train_split_size + val_split_size) * len(full_labels))]
        # get the third split size of data and put into an array
        x_test = all_files[int((train_split_size + val_split_size) * len(all_files)):]
        y_test = full_labels[int((train_split_size + val_split_size) * len(full_labels)):]
        if 'train' in datasets:
            loaders['train'] = DataLoader(SorelSmallDataset(x_train, y_train), batch_size=batch_size)
        if 'val' in datasets:
            loaders['val'] = DataLoader(SorelSmallDataset(x_val, y_val), batch_size=batch_size)
        if 'test' in datasets:
            loaders['test'] = DataLoader(SorelSmallDataset(x_test, y_test), batch_size=batch_size)
        logging.info(f'--- DATASET PREPROCESSING COMPLETE ---')


if __name__ == '__main__':
    d = sorel_small(path_to_dataset='/Users/corneliuspaardekooper/Dev/image-based-malware-dataloader/Datasets',
                    datasets=['train', 'val', 'test'], batch_loading=True)
