import numpy as np
from torch.utils.data import DataLoader, TensorDataset
from torch import Tensor
from concurrent.futures import as_completed
from sklearn.model_selection import train_test_split
import torch
from concurrent.futures import wait
from os import listdir
from concurrent.futures import ThreadPoolExecutor
import os
import logging
from PIL import Image
from concurrent.futures import ThreadPoolExecutor
from os.path import isfile, join


def img_resize(x, image_resolution):
    return Image.open(x).resize((image_resolution, image_resolution))


# Dataset from https://github.com/Zelinkai/FractalMalware
def zelinka_fractal(
        path_to_dataset: str = '',
        batch_size: int = 16,
        image_resolution: int = 1024,
        datasets=None
):
    # Validate that the parameters are within bounds
    if datasets is None:
        datasets = ['train', 'val', 'test']
    split = [0.7, 0.15, 0.15]
    if path_to_dataset == '':
        path_to_dataset = '/Datasets'
    if len(datasets) > 3 or len(datasets) < 1:
        raise Exception("datasets must be a list of length 1-3")
    if not np.in1d(datasets, ['train', 'val', 'test']).all():
        raise Exception("datasets must be a list of 'train', 'val', and/or 'test'")
    # specify the known labels of the dataset
    labels = ['malicious', 'benign']
    # define the loaders dictionary with the metadata of what will be loaded
    loaders = {
        'image_resolution': image_resolution,
        'batch_size': batch_size,
        'labels': labels,
        'input_channels': 3
    }
    path_to_dataset = path_to_dataset + '/Zelinka-Fractal'
    logging.info('--- BEGIN LOADING DATASET ---')
    features = []
    full_labels = []
    for index, label in enumerate(labels):
        if label == 'malicious':
            path_label = 'MW1'
        else:
            path_label = 'GW1'
        logging.info(f'LOADING DATASETSET: CLASS {index + 1} OF {len(labels)}')
        path = path_to_dataset + f'/{path_label}'
        # files = [f for f in listdir(path) if isfile(join(path, f))]
        files_full = []
        for path, subdirs, files in os.walk(path):
            files = [f for f in listdir(path) if isfile(join(path, f))]
            for name in files:
                if isfile(os.path.join(path, name)) and not name.startswith('.'):
                    files_full.append(os.path.join(path, name))
        if image_resolution != 1024:
            images = []
            # use the resize function to open and resize the images in parallel using ThreadPoolExecutor and wait for all to be done
            with ThreadPoolExecutor() as executor:
                futures = [executor.submit(img_resize, x, image_resolution) for x in files_full]
                wait(futures)
                for future in as_completed(futures):
                    images.append(future.result())
        else:
            images = [Image.open(f) for f in files_full]
        images_np = [np.asarray(img) for img in images]
        features.extend(images_np)
        full_labels.extend([index for i in range(len(images_np))])
    # Resize the data and check that the samples are in the correct size
    logging.info(f'--- DATASET LOADING COMPLETE ---')
    logging.info(f'--- BEGIN DATASET PREPROCESSING ---')
    features = np.asarray([feature for feature in features])
    full_labels = np.array([label for label in full_labels])
    # Shuffles the dataset
    np.random.seed(10)
    idx = np.random.choice(len(full_labels), len(full_labels))
    full_labels = full_labels[idx]
    features = features[idx]
    full_labels = full_labels.reshape((len(full_labels), 1))
    X_train = features.reshape((len(features), 3, image_resolution, image_resolution))
    new_y_train = np.zeros((len(X_train), len(labels)))
    # Set the labels value to the index of the classes
    for ind, val in enumerate(full_labels):
        tmp = np.zeros(len(labels))
        tmp[val] = 1
        new_y_train[ind] = tmp
    Y_train = new_y_train
    # make three dataloaders with the train, val, and test sets
    train_split_size = split[0]
    val_split_size = split[1]
    test_split_size = split[2]
    # get the first split size of data and put into an array
    x_train = X_train[:int(train_split_size * len(X_train))]
    y_train = Y_train[:int(train_split_size * len(Y_train))]
    # get the second split size of data and put into an array
    x_val = X_train[int(train_split_size * len(X_train)):int((train_split_size + val_split_size) * len(X_train))]
    y_val = Y_train[int(train_split_size * len(Y_train)):int((train_split_size + val_split_size) * len(Y_train))]
    # get the third split size of data and put into an array
    x_test = X_train[int((train_split_size + val_split_size) * len(X_train)):]
    y_test = Y_train[int((train_split_size + val_split_size) * len(Y_train)):]
    # create the loaders dictionary
    if 'train' in datasets:
        loaders['train'] = DataLoader(TensorDataset(Tensor(x_train), torch.argmax(Tensor(y_train), dim=1)),
                                      batch_size=batch_size)
    if 'val' in datasets:
        loaders['val'] = DataLoader(TensorDataset(Tensor(x_val), torch.argmax(Tensor(y_val), dim=1)),
                                    batch_size=batch_size)
    if 'test' in datasets:
        loaders['test'] = DataLoader(TensorDataset(Tensor(x_test), torch.argmax(Tensor(y_test), dim=1)),
                                     batch_size=batch_size)
    logging.info(f'--- DATASET PREPROCESSING COMPLETE ---')
    return loaders


if __name__ == "__main__":
    zelinka_fractal(path_to_dataset='/Users/corneliuspaardekooper/Dev/image-based-malware-dataloader/Datasets',
                    batch_size=16, image_resolution=32, datasets=['train', 'val', 'test'])
