# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.9.2527
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.time_window import TimeWindow
from typing import Optional, Set
from typing_extensions import Self

class AssignedTransport(BaseModel):
    """
    Transport's shift assigned to the specified time (`shift_time`).
    """ # noqa: E501
    transport_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Transport key, unique identifier.")
    shift_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Transport's shift key.")
    shift_time: Optional[TimeWindow]
    __properties: ClassVar[List[str]] = ["transport_key", "shift_key", "shift_time"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AssignedTransport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of shift_time
        if self.shift_time:
            _dict['shift_time'] = self.shift_time.to_dict()
        # set to None if shift_time (nullable) is None
        # and model_fields_set contains the field
        if self.shift_time is None and "shift_time" in self.model_fields_set:
            _dict['shift_time'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AssignedTransport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "transport_key": obj.get("transport_key"),
            "shift_key": obj.get("shift_key"),
            "shift_time": TimeWindow.from_dict(obj["shift_time"]) if obj.get("shift_time") is not None else None
        })
        return _obj


