# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.9.2527
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from vrt_lss_studio.models.actualize_settings import ActualizeSettings
from vrt_lss_studio.models.plan_settings import PlanSettings
from vrt_lss_studio.models.replan_settings import ReplanSettings
from typing import Optional, Set
from typing_extensions import Self

class ExperimentSettings(BaseModel):
    """
    Experiment settings.
    """ # noqa: E501
    plan_settings: PlanSettings
    replan_settings: ReplanSettings
    actualize_settings: ActualizeSettings
    __properties: ClassVar[List[str]] = ["plan_settings", "replan_settings", "actualize_settings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExperimentSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of plan_settings
        if self.plan_settings:
            _dict['plan_settings'] = self.plan_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of replan_settings
        if self.replan_settings:
            _dict['replan_settings'] = self.replan_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of actualize_settings
        if self.actualize_settings:
            _dict['actualize_settings'] = self.actualize_settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExperimentSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "plan_settings": PlanSettings.from_dict(obj["plan_settings"]) if obj.get("plan_settings") is not None else None,
            "replan_settings": ReplanSettings.from_dict(obj["replan_settings"]) if obj.get("replan_settings") is not None else None,
            "actualize_settings": ActualizeSettings.from_dict(obj["actualize_settings"]) if obj.get("actualize_settings") is not None else None
        })
        return _obj


