# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.9.2527
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.geopoint import Geopoint
from vrt_lss_studio.models.location_compatibilities import LocationCompatibilities
from vrt_lss_studio.models.location_timetable_element import LocationTimetableElement
from typing import Optional, Set
from typing_extensions import Self

class Location(BaseModel):
    """
    Location - unique geographical location of the object with accessibility parameters. 
    """ # noqa: E501
    key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Location key, unique identifier.")
    geopoint: Geopoint
    arrival_duration: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).")
    departure_duration: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default='PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).")
    timetable: Optional[Annotated[List[LocationTimetableElement], Field(min_length=0, max_length=30)]] = Field(default=None, description="Location timetable - time windows of availability and capacity restrictions. If the list is empty or not specified, the location works without restrictions. ")
    compatibilities: Optional[LocationCompatibilities] = None
    attributes: Optional[Annotated[List[Attribute], Field(min_length=0, max_length=1000)]] = Field(default=None, description="Attributes. Used to add service information.")
    __properties: ClassVar[List[str]] = ["key", "geopoint", "arrival_duration", "departure_duration", "timetable", "compatibilities", "attributes"]

    @field_validator('arrival_duration')
    def arrival_duration_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @field_validator('departure_duration')
    def departure_duration_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Location from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of geopoint
        if self.geopoint:
            _dict['geopoint'] = self.geopoint.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in timetable (list)
        _items = []
        if self.timetable:
            for _item in self.timetable:
                if _item:
                    _items.append(_item.to_dict())
            _dict['timetable'] = _items
        # override the default output from pydantic by calling `to_dict()` of compatibilities
        if self.compatibilities:
            _dict['compatibilities'] = self.compatibilities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        # set to None if compatibilities (nullable) is None
        # and model_fields_set contains the field
        if self.compatibilities is None and "compatibilities" in self.model_fields_set:
            _dict['compatibilities'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Location from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "geopoint": Geopoint.from_dict(obj["geopoint"]) if obj.get("geopoint") is not None else None,
            "arrival_duration": obj.get("arrival_duration") if obj.get("arrival_duration") is not None else 'PT0S',
            "departure_duration": obj.get("departure_duration") if obj.get("departure_duration") is not None else 'PT0S',
            "timetable": [LocationTimetableElement.from_dict(_item) for _item in obj["timetable"]] if obj.get("timetable") is not None else None,
            "compatibilities": LocationCompatibilities.from_dict(obj["compatibilities"]) if obj.get("compatibilities") is not None else None,
            "attributes": [Attribute.from_dict(_item) for _item in obj["attributes"]] if obj.get("attributes") is not None else None
        })
        return _obj


