# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.9.2527
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.location_limit import LocationLimit
from vrt_lss_studio.models.time_window import TimeWindow
from typing import Optional, Set
from typing_extensions import Self

class LocationTimetableElement(BaseModel):
    """
    Location - unique geographical location of the object with accessibility parameters. 
    """ # noqa: E501
    work_window: Optional[TimeWindow]
    limits: Optional[Annotated[List[LocationLimit], Field(min_length=0, max_length=100)]] = Field(default=None, description="List of bandwidth restrictions inside the working window of the location. Constraint time windows cannot overlap and must total `work_window`. ")
    __properties: ClassVar[List[str]] = ["work_window", "limits"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LocationTimetableElement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of work_window
        if self.work_window:
            _dict['work_window'] = self.work_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in limits (list)
        _items = []
        if self.limits:
            for _item in self.limits:
                if _item:
                    _items.append(_item.to_dict())
            _dict['limits'] = _items
        # set to None if work_window (nullable) is None
        # and model_fields_set contains the field
        if self.work_window is None and "work_window" in self.model_fields_set:
            _dict['work_window'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LocationTimetableElement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "work_window": TimeWindow.from_dict(obj["work_window"]) if obj.get("work_window") is not None else None,
            "limits": [LocationLimit.from_dict(_item) for _item in obj["limits"]] if obj.get("limits") is not None else None
        })
        return _obj


