# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.9.2527
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.feature_lifetime import FeatureLifetime
from typing import Optional, Set
from typing_extensions import Self

class PerformerCompatibilities(BaseModel):
    """
    Performer [compatibilities](#section/Description/Compatibilities). 
    """ # noqa: E501
    performer_features: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=256)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="A list of tags that define a property or requirement. ")
    performer_features_lifetimes: Optional[Annotated[List[FeatureLifetime], Field(min_length=0, max_length=100)]] = Field(default=None, description="List of feature tag lifetime. ")
    transport_restrictions: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=256)]], Field(min_length=0, max_length=1000)]] = Field(default=None, description="A list of tags that define a property or requirement. ")
    __properties: ClassVar[List[str]] = ["performer_features", "performer_features_lifetimes", "transport_restrictions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PerformerCompatibilities from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in performer_features_lifetimes (list)
        _items = []
        if self.performer_features_lifetimes:
            for _item in self.performer_features_lifetimes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['performer_features_lifetimes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PerformerCompatibilities from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "performer_features": obj.get("performer_features"),
            "performer_features_lifetimes": [FeatureLifetime.from_dict(_item) for _item in obj["performer_features_lifetimes"]] if obj.get("performer_features_lifetimes") is not None else None,
            "transport_restrictions": obj.get("transport_restrictions")
        })
        return _obj


