# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.9.2527
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class TableHardlinkFields(BaseModel):
    """
    Hardlink and element fields for table.
    """ # noqa: E501
    essence_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key, unique identifier.")
    essence_type: Optional[StrictStr] = Field(default='HARDLINK', description="Essence type.")
    enabled: Optional[StrictBool] = Field(default=True, description="Using essence for calculations.")
    pristine: Optional[StrictBool] = Field(default=True, description="A flag indicating whether changes to the entity have been made relative to the original data. `true` - means that the data is original and has not been changed. ")
    element_type: Optional[StrictStr] = Field(default='HARDLINK', description="Element type.")
    elements_count: Optional[Annotated[int, Field(le=15001, strict=True, ge=0)]] = Field(default=0, description="Elements count.")
    trip_key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="Key, unique identifier.")
    trip_name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=64)]] = Field(default='', description="Trip name.")
    __properties: ClassVar[List[str]] = ["essence_key", "essence_type", "enabled", "pristine", "element_type", "elements_count", "trip_key", "trip_name"]

    @field_validator('essence_type')
    def essence_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['HARDLINK', 'ELEMENT']):
            raise ValueError("must be one of enum values ('HARDLINK', 'ELEMENT')")
        return value

    @field_validator('element_type')
    def element_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['HARDLINK', 'ORDER', 'PERFORMER_SHIFT', 'TRANSPORT_SHIFT']):
            raise ValueError("must be one of enum values ('HARDLINK', 'ORDER', 'PERFORMER_SHIFT', 'TRANSPORT_SHIFT')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TableHardlinkFields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pristine",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if essence_key (nullable) is None
        # and model_fields_set contains the field
        if self.essence_key is None and "essence_key" in self.model_fields_set:
            _dict['essence_key'] = None

        # set to None if trip_key (nullable) is None
        # and model_fields_set contains the field
        if self.trip_key is None and "trip_key" in self.model_fields_set:
            _dict['trip_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TableHardlinkFields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "essence_key": obj.get("essence_key"),
            "essence_type": obj.get("essence_type") if obj.get("essence_type") is not None else 'HARDLINK',
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "pristine": obj.get("pristine") if obj.get("pristine") is not None else True,
            "element_type": obj.get("element_type") if obj.get("element_type") is not None else 'HARDLINK',
            "elements_count": obj.get("elements_count") if obj.get("elements_count") is not None else 0,
            "trip_key": obj.get("trip_key"),
            "trip_name": obj.get("trip_name") if obj.get("trip_name") is not None else ''
        })
        return _obj


