# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.9.2527
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.assigned_performer import AssignedPerformer
from vrt_lss_studio.models.assigned_transport import AssignedTransport
from vrt_lss_studio.models.attribute import Attribute
from vrt_lss_studio.models.trip_state import TripState
from typing import Optional, Set
from typing_extensions import Self

class Trip(BaseModel):
    """
    A trip is a set of works planned to be performed by a specific performer on a specific transport, expressed through a [change in the states](#section/Description/Trip-model) of the performer. 
    """ # noqa: E501
    key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Unique trip identifier.")
    name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=64)]] = Field(default='', description="Trip name.")
    performer: AssignedPerformer
    transport: AssignedTransport
    states: Annotated[List[TripState], Field(min_length=0, max_length=15001)] = Field(description="List of performer's states.")
    waitlist: Optional[Annotated[List[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]], Field(min_length=0, max_length=15001)]] = Field(default=None, description="List of order keys assigned to the performer, but not scheduled for a specific time and not taken into account in the transport load. ")
    attributes: Optional[Annotated[List[Attribute], Field(min_length=0, max_length=1000)]] = Field(default=None, description="Attributes. Used to add service information.")
    __properties: ClassVar[List[str]] = ["key", "name", "performer", "transport", "states", "waitlist", "attributes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Trip from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of performer
        if self.performer:
            _dict['performer'] = self.performer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of transport
        if self.transport:
            _dict['transport'] = self.transport.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in states (list)
        _items = []
        if self.states:
            for _item in self.states:
                if _item:
                    _items.append(_item.to_dict())
            _dict['states'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Trip from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "name": obj.get("name") if obj.get("name") is not None else '',
            "performer": AssignedPerformer.from_dict(obj["performer"]) if obj.get("performer") is not None else None,
            "transport": AssignedTransport.from_dict(obj["transport"]) if obj.get("transport") is not None else None,
            "states": [TripState.from_dict(_item) for _item in obj["states"]] if obj.get("states") is not None else None,
            "waitlist": obj.get("waitlist"),
            "attributes": [Attribute.from_dict(_item) for _item in obj["attributes"]] if obj.get("attributes") is not None else None
        })
        return _obj


