# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.9.2527
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.transport_capacity_multiplier import TransportCapacityMultiplier
from vrt_lss_studio.models.transport_speed_multiplier import TransportSpeedMultiplier
from typing import Optional, Set
from typing_extensions import Self

class TripAssumptions(BaseModel):
    """
    Planning assumptions. Designed to adjust the logic of planning via mass change of input data. 
    """ # noqa: E501
    transport_speed_multipliers: Optional[Annotated[List[TransportSpeedMultiplier], Field(min_length=0, max_length=16)]] = Field(default=None, description="Transport speed change coefficients.")
    transport_capacity_multipliers: Optional[Annotated[List[TransportCapacityMultiplier], Field(min_length=0, max_length=16)]] = Field(default=None, description="Transport capacity change coefficients. Change the `capacity` parameters for all boxes and `max_capacity` for the transport. ")
    disable_compatibility: Optional[StrictBool] = Field(default=False, description="Disable the accounting for capacity. If `true` is specified, all becomes compatible with everything. ")
    disable_capacity: Optional[StrictBool] = Field(default=False, description="Disable the accounting for capacity. If `true` is specified, all transports can accommodate an unlimited cargo amount. ")
    same_order_time_window: Optional[StrictBool] = Field(default=False, description="Use for calculation the same (specified) time window for orders and demands. The time window is specified from the beginning of the earliest window to the end of the latest window from all orders and demands. ")
    expand_shift_time_window: Optional[StrictBool] = Field(default=False, description="Expand the time window for performer and transport shifts.  The left border of the first shift extends to the left border of the specified window, right border extends to the right border or to the beginning of the next window for this entity. Each next shift moves the right border to the next shift or to the right border of the specified window. ")
    __properties: ClassVar[List[str]] = ["transport_speed_multipliers", "transport_capacity_multipliers", "disable_compatibility", "disable_capacity", "same_order_time_window", "expand_shift_time_window"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TripAssumptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in transport_speed_multipliers (list)
        _items = []
        if self.transport_speed_multipliers:
            for _item in self.transport_speed_multipliers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['transport_speed_multipliers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in transport_capacity_multipliers (list)
        _items = []
        if self.transport_capacity_multipliers:
            for _item in self.transport_capacity_multipliers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['transport_capacity_multipliers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TripAssumptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "transport_speed_multipliers": [TransportSpeedMultiplier.from_dict(_item) for _item in obj["transport_speed_multipliers"]] if obj.get("transport_speed_multipliers") is not None else None,
            "transport_capacity_multipliers": [TransportCapacityMultiplier.from_dict(_item) for _item in obj["transport_capacity_multipliers"]] if obj.get("transport_capacity_multipliers") is not None else None,
            "disable_compatibility": obj.get("disable_compatibility") if obj.get("disable_compatibility") is not None else False,
            "disable_capacity": obj.get("disable_capacity") if obj.get("disable_capacity") is not None else False,
            "same_order_time_window": obj.get("same_order_time_window") if obj.get("same_order_time_window") is not None else False,
            "expand_shift_time_window": obj.get("expand_shift_time_window") if obj.get("expand_shift_time_window") is not None else False
        })
        return _obj


