# generated by datamodel-codegen:
#   filename:  api/classification/createTag.json
#   timestamp: 2024-11-26T06:50:54+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic


class CreateTagRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    classification: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='Name of the classification that this tag is part of.'),
    ]
    parent: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description='Fully qualified name of the parent tag. When null, the term is at the root of the classification.',
        ),
    ]
    name: basic.EntityName
    displayName: Annotated[
        Optional[str], Field(None, description='Display Name that identifies this tag.')
    ]
    description: Annotated[
        basic.Markdown, Field(description='Unique name of the classification')
    ]
    style: Optional[basic.Style] = None
    associatedTags: Annotated[
        Optional[List[str]],
        Field(
            None, description='Fully qualified names of tags associated with this tag'
        ),
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    mutuallyExclusive: Annotated[
        Optional[bool],
        Field(
            'false',
            description='Children tags under this group are mutually exclusive. When mutually exclusive is `true` the tags from this group are used to **classify** an entity. An entity can only be in one class - example, it can only be either `tier1` or `tier2` and not both. When mutually exclusive is `false`, the tags from this group are used to **categorize** an entity. An entity can be in multiple categories simultaneously - example a customer can be `newCustomer` and `atRisk` simultaneously.',
        ),
    ]
    domain: Annotated[
        Optional[str],
        Field(
            None, description='Fully qualified name of the domain the Table belongs to.'
        ),
    ]
